/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.formplugin.ecoplatform;

import java.util.Objects;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class EcoTypeListPlugin
extends AbstractListPlugin {
    private static Log logger = LogFactory.getLog(EcoTypeListPlugin.class);
    private static String OP_SETDEFAULT = "setdefault";
    private static String OP_PARAMSET = "paramset";
    private static final String BILLLISTAP = "billlistap";

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        FormOperate operate = (FormOperate)e.getSource();
        String operateKey = operate.getOperateKey();
        if (OP_SETDEFAULT.equals(operateKey)) {
            RefObject afterConfirm = new RefObject();
            if (operate.getOption().tryGetVariableValue("afterconfirm", afterConfirm)) {
                return;
            }
            BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
            ListSelectedRowCollection selects = billList.getSelectedRows();
            int size = selects.size();
            if (size > 1) {
                String msg = ResManager.loadKDString((String)"\u8bbe\u7f6e\u9ed8\u8ba4\u53ea\u80fd\u5355\u884c\u64cd\u4f5c\u3002", (String)"EcoTypeListPlugin_0", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(msg);
                e.setCancel(true);
                return;
            }
            Object[] primaryKeyValues = selects.getPrimaryKeyValues();
            QFilter qFilter = new QFilter("id", "in", (Object)primaryKeyValues);
            DynamicObject ecoType = BusinessDataServiceHelper.loadSingle((String)"pdm_ecotype", (String)"id,number,isdefault,status,enable", (QFilter[])new QFilter[]{qFilter});
            if (ecoType.getBoolean("isdefault")) {
                String msg = String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u7c7b\u578b\u201c%1$s\u201d\uff0c\u5df2\u8bbe\u7f6e\u4e3a\u9ed8\u8ba4\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002", (String)"EcoTypeListPlugin_1", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), ecoType.getString("number"));
                this.getView().showTipNotification(msg);
                e.setCancel(true);
                return;
            }
            if (!"1".equals(ecoType.getString("enable"))) {
                String msg = String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u7c7b\u578b\u201c%1$s\u201d\uff0c\u4f7f\u7528\u72b6\u6001\u4e0d\u7b49\u4e8e\u53ef\u7528\uff0c\u4e0d\u5141\u8bb8\u8bbe\u7f6e\u4e3a\u9ed8\u8ba4\u503c\u3002", (String)"EcoTypeListPlugin_2", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), ecoType.getString("number"));
                this.getView().showTipNotification(msg);
                e.setCancel(true);
                return;
            }
            qFilter = new QFilter("isdefault", "=", (Object)true);
            ecoType = BusinessDataServiceHelper.loadSingle((String)"pdm_ecotype", (String)"id,number,createorg.name", (QFilter[])new QFilter[]{qFilter});
            if (ecoType != null) {
                String msg = String.format(ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7:\u201c%1$s\u201d\u5df2\u8bbe\u7f6e\u9ed8\u8ba4\u7684\u53d8\u66f4\u7c7b\u578b\u201c%2$s\u201d,\u662f\u5426\u9700\u8981\u91cd\u65b0\u8bbe\u7f6e?", (String)"EcoTypeListPlugin_3", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), ecoType.getDynamicObject("createorg").getString("name"), ecoType.getString("number"));
                ConfirmCallBackListener listener = new ConfirmCallBackListener(OP_SETDEFAULT, (IFormPlugin)this);
                this.getView().showConfirm(msg, MessageBoxOptions.YesNo, listener);
                e.setCancel(true);
                return;
            }
        } else if (OP_PARAMSET.equals(operateKey)) {
            this.showConfigSetForm(Long.parseLong("1839983312026846208"));
        }
    }

    private void showConfigSetForm(Long pkId) {
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setFormId("pdm_ecotypeparamset");
        baseShowParameter.setPkId((Object)pkId);
        baseShowParameter.setCustomParam("view", (Object)Boolean.TRUE);
        baseShowParameter.setShowTitle(true);
        baseShowParameter.setCaption(ResManager.loadKDString((String)"\u53d8\u66f4\u5bf9\u8c61\u9ed8\u8ba4\u7c7b\u578b\u8bbe\u7f6e", (String)"EcoTypeListPlugin_5", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
        OperationStatus operationStatus = OperationStatus.EDIT;
        baseShowParameter.setStatus(operationStatus);
        baseShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss css = new StyleCss();
        css.setWidth("650px");
        css.setHeight("200px");
        baseShowParameter.getOpenStyle().setInlineStyleCss(css);
        this.getView().showForm((FormShowParameter)baseShowParameter);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        String key = e.getOperateKey();
        if (OP_SETDEFAULT.equals(key)) {
            DynamicObject[] ecoTypes;
            ListSelectedRowCollection selects = billList.getSelectedRows();
            Object[] primaryKeyValues = selects.getPrimaryKeyValues();
            QFilter qFilter = new QFilter("id", "in", (Object)primaryKeyValues);
            qFilter.or(new QFilter("isdefault", "=", (Object)true));
            for (DynamicObject ecoType : ecoTypes = BusinessDataServiceHelper.load((String)"pdm_ecotype", (String)"id,number,isdefault", (QFilter[])new QFilter[]{qFilter})) {
                if (Objects.equals(ecoType.getPkValue(), primaryKeyValues[0])) {
                    ecoType.set("isdefault", (Object)true);
                    continue;
                }
                ecoType.set("isdefault", (Object)false);
            }
            SaveServiceHelper.update((DynamicObject[])ecoTypes);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u9ed8\u8ba4\u503c\u8bbe\u7f6e\u6210\u529f\u3002", (String)"EcoTypeListPlugin_4", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            billList.refresh();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        MessageBoxResult result;
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (OP_SETDEFAULT.equals(callBackId) && MessageBoxResult.Yes.equals((Object)(result = messageBoxClosedEvent.getResult()))) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("afterconfirm", "true");
            this.getView().invokeOperation(OP_SETDEFAULT, operateOption);
        }
    }
}

