/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.formplugin.ecoroute;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.common.utils.ECNLocalCacheUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mmc.fmm.formplugin.processroute.FMMProcessRountEditPlugin;
import kd.mmc.pdm.common.bom.ecoplatform.PlatformUtils;
import kd.mmc.pdm.common.bom.ecoroute.EcoCommonHelper;
import kd.mmc.pdm.common.util.MMCUtils;

public class EcoRouteEditFormPlugin
extends FMMProcessRountEditPlugin {
    private static Log logger = LogFactory.getLog(EcoRouteEditFormPlugin.class);
    private static final String PROP_PENTRYVALIDDATE = "pentryvaliddate";
    private static final String PROP_ENTRYMODE3 = "entrymode3";
    private static final String PROP_ENTRYMODE = "entrymode";
    private static final String PROP_OPERATIONNO3 = "operationno3";
    private static final String PROP_ACTTIME3 = "acttime3";
    private static final String PROP_ACTTIME = "acttime";
    private static final String PROP_ESREMARK3 = "esremark3";
    private static final String PROP_ESREMARK = "esremark";
    private static final String PROP_ESTIMATESTATUS3 = "estimatestatus3";
    private static final String PROP_ESTIMATESTATUS = "estimatestatus";
    private static final String PROP_ENTRYVALIDDATE = "entryvaliddate";
    private static final String PROP_ENTRYVALIDDATE3 = "entryvaliddate3";
    private static final String PROP_OLDPROCESSENTRYID3 = "oldprocessentryid3";
    private static final String PROP_NEWPROCESSENTRYID3 = "newprocessentryid3";
    private static final String PROP_OLDPROCESSENTRYID = "oldprocessentryid";
    private static final String PROP_NEWPROCESSENTRYID = "newprocessentryid";
    private static final String PROP_ENTRY3 = "processentry1";
    private static final String PROP_ENTRY = "processentry";
    private static final String PROP_RELENTRYENTITY = "relentryentity";
    private static final String PROP_ENTRYENTITY = "entryentity";
    private static final String PROP_PENTRY = "pentry";
    public static final String CACHE_ECOROUTESTR = "cache_ecoroutestring";

    public Map<String, String> genShowFieldMap() {
        Map map = super.genShowFieldMap();
        map.put(PROP_OLDPROCESSENTRYID3, PROP_OLDPROCESSENTRYID);
        map.put(PROP_NEWPROCESSENTRYID3, PROP_NEWPROCESSENTRYID);
        map.put(PROP_ENTRYMODE3, PROP_ENTRYMODE);
        map.put(PROP_ACTTIME3, PROP_ACTTIME);
        map.put(PROP_ESREMARK3, PROP_ESREMARK);
        map.put(PROP_ESTIMATESTATUS3, PROP_ESTIMATESTATUS);
        return map;
    }

    public void showPageTagDataExt(int rowIndex, String tabKey, IDataModel model, IFormView view) {
        super.showPageTagDataExt(rowIndex, tabKey, model, view);
        String entryModeField = "";
        switch (tabKey) {
            case "detailpage": {
                entryModeField = "entrymode1";
                break;
            }
            case "schepage": {
                entryModeField = "entrymode2";
                break;
            }
            case "activitypage": {
                entryModeField = "entrymode4";
                break;
            }
            case "outsourcingpage": {
                entryModeField = "entrymode5";
                break;
            }
            case "configrulepage": {
                entryModeField = "entrymode6";
                break;
            }
        }
        if (!kd.bos.util.StringUtils.isEmpty((String)entryModeField)) {
            if (rowIndex > -1) {
                model.setValue(entryModeField, model.getValue(PROP_ENTRYMODE, ((Integer)model.getValue("row3", rowIndex)).intValue()));
            } else {
                model.setValue(entryModeField, (Object)"");
            }
            String entryMode = (String)model.getValue(entryModeField);
            boolean isEnable = !"".equals(entryMode) && !"B".equals(entryMode) && !"E".equals(entryMode);
            this.setEnableChildTag(isEnable, tabKey, model, view);
        }
    }

    private Long getRouteId() {
        return (Long)this.getModel().getValue("routeid");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        String operateKey = operate.getOperateKey();
        if ("editop_entry".equalsIgnoreCase(operateKey) || "disableop_entry".equalsIgnoreCase(operateKey)) {
            Long routeId = this.getRouteId();
            if (PlatformUtils.isNullLong((Long)routeId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u5de5\u827a\u8def\u7ebf\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u5de5\u827a\u8def\u7ebfID\u3002", (String)"EcoRouteEditFormPlugin_1", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            this.openRouteOperationF7(operateKey, routeId);
        } else if ("donothing_delete".equalsIgnoreCase(operateKey)) {
            AbstractGrid.GridState entryGS;
            EntryGrid entryEG = (EntryGrid)this.getControl(PROP_ENTRY3);
            AbstractGrid.GridState gridState = entryGS = entryEG == null ? null : entryEG.getEntryState();
            if (entryGS == null) {
                return;
            }
            int[] entryRowIndexes = entryGS.getSelectedRows();
            if (entryRowIndexes.length <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u5de5\u5e8f\u5206\u5f55\u6570\u636e\u3002", (String)"EcoRouteEditFormPlugin_2", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            HashSet<Integer> dealRowIndexes = new HashSet<Integer>(entryRowIndexes.length);
            IDataModel dm = this.getModel();
            Integer size = this.getModel().getEntryRowCount(PROP_ENTRY3);
            ArrayList<String> entryidList = new ArrayList<String>(entryRowIndexes.length);
            for (int i = 0; i < entryRowIndexes.length; ++i) {
                int index = entryRowIndexes[i];
                DynamicObject rowentity = dm.getEntryRowEntity(PROP_ENTRY3, index);
                if (rowentity == null) continue;
                String entryid = rowentity.getString(PROP_OLDPROCESSENTRYID3);
                if (StringUtils.isNotEmpty((CharSequence)entryid) && !"0".equals(entryid)) {
                    entryidList.add(entryid);
                }
                dealRowIndexes.add(index);
            }
            for (int k = 0; k < size; ++k) {
                String entryid;
                DynamicObject rentity = dm.getEntryRowEntity(PROP_ENTRY3, k);
                if (rentity == null || !entryidList.contains(entryid = rentity.getString(PROP_OLDPROCESSENTRYID3))) continue;
                dealRowIndexes.add(k);
            }
            int[] d = dealRowIndexes.stream().mapToInt(Integer::intValue).toArray();
            dm.deleteEntryRows(PROP_ENTRY, d);
            DynamicObject ecoType = (DynamicObject)this.getPentryPropertyValue("ecotype", -1);
            this.setFiledEnable(ecoType);
        }
    }

    private String getProcessSeq() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(PROP_ENTRYENTITY);
        String processSeq = "";
        if (entryGrid.getSelectRows().length > 0) {
            processSeq = (String)this.getModel().getValue("processseq", entryGrid.getSelectRows()[0]);
        } else {
            int entryRowIndex;
            AbstractGrid.GridState entryGS = entryGrid == null ? null : entryGrid.getEntryState();
            int n = entryRowIndex = entryGS == null ? -1 : entryGS.getFocusRow();
            if (entryRowIndex >= 0) {
                processSeq = (String)this.getModel().getValue("processseq", entryRowIndex);
            }
        }
        if (kd.bos.util.StringUtils.isEmpty((String)processSeq)) {
            processSeq = "1";
        }
        return processSeq;
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        if (event == null) {
            return;
        }
        String actID = event.getActionId();
        Object retDataObj = event.getReturnData();
        if (MMCUtils.isEmptyString((String)actID) || retDataObj == null) {
            return;
        }
        ListSelectedRowCollection returnLSRC = retDataObj instanceof ListSelectedRowCollection ? (ListSelectedRowCollection)retDataObj : null;
        int returnLSRCSize = returnLSRC == null || returnLSRC.isEmpty() ? 0 : returnLSRC.size();
        if ("editop_entry".equalsIgnoreCase(actID) || "disableop_entry".equalsIgnoreCase(actID)) {
            if (returnLSRCSize <= 0) {
                return;
            }
            HashSet<Long> returnRoutePKSet = new HashSet<Long>(returnLSRCSize);
            for (int index = 0; index < returnLSRCSize; ++index) {
                ListSelectedRow returnLSR = returnLSRC.get(index);
                if (returnLSR == null) continue;
                Long returnPK = (Long)returnLSR.getPrimaryKeyValue();
                returnRoutePKSet.add(returnPK);
            }
            String entryMode = "C";
            if ("disableop_entry".equalsIgnoreCase(actID)) {
                entryMode = "E";
            }
            this.genEntryData(returnRoutePKSet, entryMode);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        String operateKey = operate.getOperateKey();
        if ("donothing_addnew".equalsIgnoreCase(operateKey) || "donothing_insert".equalsIgnoreCase(operateKey)) {
            int count = 0;
            Long routeId = this.getRouteId();
            String processSeq = this.getProcessSeq();
            int maxOperationNo = EcoCommonHelper.getMaxOperationNo((Long)routeId, (String)processSeq);
            IDataModel model = this.getModel();
            for (int i = 0; i < this.getModel().getEntryRowCount(PROP_ENTRY3); ++i) {
                if (!"A".equals((String)this.getModel().getValue(PROP_ENTRYMODE3, i))) continue;
                int opNo = maxOperationNo + ++count * 10;
                model.setValue(PROP_OPERATIONNO3, (Object)opNo, i);
            }
        }
    }

    public void openRouteOperationF7(String opKey, Long routeId) {
        String entitykey = "pdm_route_processentry";
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)entitykey, (boolean)true);
        if (lsp != null) {
            CloseCallBack ccb = new CloseCallBack((IFormPlugin)this, opKey);
            lsp.setCloseCallBack(ccb);
            ListFilterParameter lfp = lsp.getListFilterParameter() == null ? new ListFilterParameter() : lsp.getListFilterParameter();
            lfp.setOrderBy("entryseq");
            lfp.setQFilters(this.getRouteProcessEntryQFilterList(routeId));
            lsp.setListFilterParameter(lfp);
            lsp.setHasRight(true);
            this.getView().showForm((FormShowParameter)lsp);
        }
    }

    private List<QFilter> getRouteProcessEntryQFilterList(Long routeId) {
        Date validDate;
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(16);
        qFilterList.add(new QFilter("routeid", "=", (Object)routeId));
        qFilterList.add(new QFilter("parent", "=", (Object)"1"));
        Set<Long> ignoreMFTInfoPKSet = this.getExistOpEntryId();
        if (!MMCUtils.isEmptySet(ignoreMFTInfoPKSet)) {
            qFilterList.add(new QFilter("entryid", "not in", ignoreMFTInfoPKSet));
        }
        if ((validDate = (Date)this.getPentryPropertyValue(PROP_PENTRYVALIDDATE, -1)) != null) {
            qFilterList.add(new QFilter("entryinvaliddate", ">=", (Object)validDate));
        }
        return qFilterList;
    }

    private Set<Long> getExistOpEntryId() {
        DynamicObjectCollection entryDOC = this.getModel().getEntryEntity(PROP_ENTRY3);
        int entryDOCSize = MMCUtils.isEmptyList((List)entryDOC) ? 0 : entryDOC.size();
        HashSet<Long> ignoreMFTInfoPKSet = new HashSet<Long>(16);
        for (int index = 0; index < entryDOCSize; ++index) {
            DynamicObject entryDO = (DynamicObject)entryDOC.get(index);
            Long entryBOMEntryPK = entryDO.getLong(PROP_OLDPROCESSENTRYID3);
            if (PlatformUtils.isNullLong((Long)entryBOMEntryPK)) continue;
            ignoreMFTInfoPKSet.add(entryBOMEntryPK);
        }
        return ignoreMFTInfoPKSet;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (this.getPageCache().get("isIgnoreChangeListener") == "true") {
            return;
        }
        if ("1".equals(this.getPageCache().get("flag"))) {
            return;
        }
        String name = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        int rowIndex = changeData[0].getRowIndex();
        if (rowIndex < 0) {
            return;
        }
        IFormView fv = this.getView();
        IDataModel dm = fv.getModel();
        if (PROP_ACTTIME3.equals(name)) {
            String entrymode = (String)dm.getValue(PROP_ENTRYMODE3, rowIndex);
            List<String> values = Arrays.asList("B", "E");
            if (!values.contains(entrymode)) {
                dm.setValue(PROP_ENTRYVALIDDATE3, newValue, rowIndex);
            }
            if ("C".equalsIgnoreCase(entrymode)) {
                long entryProcessEntryid = (Long)dm.getValue(PROP_OLDPROCESSENTRYID3, rowIndex);
                DynamicObjectCollection entryEntity = dm.getEntryEntity(PROP_ENTRY3);
                for (int i = 0; i < entryEntity.size(); ++i) {
                    DynamicObject entry = (DynamicObject)entryEntity.get(i);
                    if (!"B".equals(entry.getString(PROP_ENTRYMODE3)) || entryProcessEntryid != entry.getLong(PROP_OLDPROCESSENTRYID3)) continue;
                    dm.setValue(PROP_ACTTIME3, newValue, i);
                    break;
                }
            }
            this.getPageCache().put("isIgnoreChangeListener", "true");
            dm.setValue(PROP_ACTTIME, newValue, rowIndex);
            this.getPageCache().put("isIgnoreChangeListener", "false");
        }
    }

    private String getSerialiationCacheType(IPageCache parentpage) {
        IPageCache pc = this.getPageCache();
        if (parentpage != null) {
            String cacheType = parentpage.get("SerializeCacheType");
            pc.put("SerializeCacheType", cacheType);
            return cacheType;
        }
        return pc.get("SerializeCacheType");
    }

    public void beforeBindData(EventObject evt) {
        int entryRowIndex;
        IFormView fv = this.getView();
        IDataModel dm = fv.getModel();
        IFormView parentfv = fv.getParentView();
        if (parentfv == null) {
            return;
        }
        IDataModel parentdm = parentfv.getModel();
        if (parentdm == null) {
            return;
        }
        EntryGrid entryGrid = (EntryGrid)parentfv.getControl(PROP_PENTRY);
        IDataModel pdm = parentfv.getModel();
        IPageCache parentpc = parentfv.getPageCache();
        String lindex = parentfv.getPageCache().get("lastindex");
        this.getSerialiationCacheType(parentpc);
        if (StringUtils.isNotBlank((CharSequence)lindex)) {
            String contrVersion;
            int lastIndex = Integer.parseInt(lindex);
            String string = contrVersion = pdm.getValue("entryversioncontrol", lastIndex) == null ? null : pdm.getValue("entryversioncontrol", lastIndex).toString();
            if (null != contrVersion && "D".equals(contrVersion)) {
                Object org = pdm.getValue("org");
                this.setFieldValue(dm, "createorg", org);
                fv.setVisible(Boolean.valueOf(false), new String[]{"editop_entry"});
                fv.setVisible(Boolean.valueOf(false), new String[]{"disableop_entry"});
                fv.setEnable(Boolean.valueOf(true), new String[]{"donothing_addnew"});
                fv.setEnable(Boolean.valueOf(true), new String[]{"donothing_insert"});
                fv.setEnable(Boolean.valueOf(true), new String[]{"donothing_delete"});
            }
            if (null != contrVersion && !"D".equals(contrVersion)) {
                fv.setVisible(Boolean.valueOf(true), new String[]{"editop_entry"});
                fv.setVisible(Boolean.valueOf(true), new String[]{"disableop_entry"});
            }
        } else {
            fv.setVisible(Boolean.valueOf(false), new String[]{"editop_entry"});
            fv.setVisible(Boolean.valueOf(false), new String[]{"disableop_entry"});
            fv.setVisible(Boolean.valueOf(false), new String[]{"donothing_addnew"});
            fv.setVisible(Boolean.valueOf(false), new String[]{"donothing_insert"});
            fv.setVisible(Boolean.valueOf(false), new String[]{"donothing_delete"});
        }
        AbstractGrid.GridState entryGS = entryGrid == null ? null : entryGrid.getEntryState();
        int n = entryRowIndex = entryGS == null ? -1 : entryGS.getFocusRow();
        if (entryRowIndex >= 0) {
            String ecoRoute;
            DynamicObject pDo;
            String ecorouteid;
            String contrVersion;
            this.setFieldValue(dm, "productno", String.valueOf(entryRowIndex + 1));
            String string = contrVersion = pdm.getValue("entryversioncontrol", entryRowIndex) == null ? null : pdm.getValue("entryversioncontrol", entryRowIndex).toString();
            if (null != contrVersion && "D".equals(contrVersion) && StringUtils.isNotBlank((CharSequence)(ecorouteid = (pDo = parentfv.getModel().getEntryRowEntity(PROP_PENTRY, entryRowIndex)).getString("ecorouteid"))) && !this.isSameEcoRoute(ecoRoute = parentfv.getPageCache().get(ecorouteid))) {
                this.setEcoRouteCacheString(ecoRoute);
            }
        }
    }

    private String getEcoRouteCacheString() {
        return this.getPageCache().get(CACHE_ECOROUTESTR);
    }

    private void setEcoRouteCacheString(String ecoBomStr) {
        this.getPageCache().put(CACHE_ECOROUTESTR, ecoBomStr);
    }

    private boolean isSameEcoRoute(String ecoRouteStr) {
        String cacheStr = this.getEcoRouteCacheString();
        if (ecoRouteStr == null && cacheStr == null) {
            return true;
        }
        if (ecoRouteStr == null || cacheStr == null) {
            return false;
        }
        return ecoRouteStr.equals(cacheStr);
    }

    private Object getPentryPropertyValue(String propertyName, int rowIndex) {
        IFormView parentfv = this.getView().getParentView();
        if (parentfv == null) {
            return null;
        }
        IDataModel parentdm = parentfv.getModel();
        if (parentdm == null) {
            return null;
        }
        EntryGrid parentEntryEG = (EntryGrid)parentfv.getControl(PROP_PENTRY);
        if (parentEntryEG == null) {
            return null;
        }
        if (rowIndex < 0) {
            int parententryRowIndex = parentEntryEG.getEntryState().getFocusRow();
            DynamicObjectCollection pentrys = parentdm.getEntryEntity(PROP_PENTRY);
            if (parententryRowIndex < 0 && !pentrys.isEmpty()) {
                parententryRowIndex = 0;
            }
            return parentdm.getValue(propertyName, parententryRowIndex);
        }
        return parentdm.getValue(propertyName, rowIndex);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject ecoType = (DynamicObject)this.getPentryPropertyValue("ecotype", -1);
        this.setFiledEnable(ecoType);
        this.closeShowLoading();
    }

    private void closeShowLoading() {
        IFormView formView = this.getView().getParentView();
        if (null != formView && formView.getEntityId().equals("pdm_bom_eco")) {
            formView.hideLoading();
        }
    }

    private void setFiledEnable(DynamicObject ecoType) {
        if (ecoType != null) {
            boolean isAdjustActtime = this.isAdjustActTime(ecoType);
            int rowCount = this.getModel().getEntryRowCount(PROP_ENTRY3);
            IFormView view = this.getView();
            for (int i = 0; i < rowCount; ++i) {
                view.setEnable(Boolean.valueOf(isAdjustActtime), i, new String[]{PROP_ACTTIME3});
            }
        }
    }

    private boolean isAdjustActTime(DynamicObject ecoType) {
        return ecoType == null ? Boolean.FALSE : ecoType.getBoolean("adjustacttime") && "A".equals(ecoType.getString("adjusttype"));
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        EntryProp prop = e.getEntryProp();
        String key = prop.getName();
        if (PROP_ENTRY.equals(key)) {
            DynamicObject ecoType = (DynamicObject)this.getPentryPropertyValue("ecotype", -1);
            Date pentryvaliddate = (Date)this.getPentryPropertyValue(PROP_PENTRYVALIDDATE, -1);
            RowDataEntity[] rowDataEntities = e.getRowDataEntities();
            if (pentryvaliddate != null) {
                IDataModel dm = this.getModel();
                for (RowDataEntity rowData : rowDataEntities) {
                    int row = rowData.getRowIndex();
                    dm.setValue(PROP_ACTTIME, (Object)pentryvaliddate, row);
                    dm.setValue(PROP_ACTTIME3, (Object)pentryvaliddate, row);
                }
            }
            this.setFiledEnable(ecoType);
        }
    }

    public void afterCreateNewData(EventObject e) {
        IPageCache parentpc;
        super.afterCreateNewData(e);
        IFormView fv = this.getView();
        IDataModel dm = fv.getModel();
        IPageCache iPageCache = parentpc = fv.getParentView() == null ? null : (IPageCache)fv.getParentView().getService(IPageCache.class);
        if (parentpc == null) {
            return;
        }
        try {
            String ecoRouteid = parentpc.get("mmc_pdm_selectbomid");
            String routeJson = parentpc.get(ecoRouteid);
            if (StringUtils.isNotEmpty((CharSequence)routeJson) && !this.isSameEcoRoute(routeJson)) {
                String cacheType = this.getSerialiationCacheType(parentpc);
                this.setEcoRouteCacheString(routeJson);
                DynamicObject ecoRouteObj = ECNLocalCacheUtils.deSerializeFromBase64((String)routeJson, (String)cacheType);
                DynamicObjectCollection entrys3 = null;
                DynamicObjectCollection entrys = null;
                DynamicObjectCollection entryentity = null;
                DynamicObjectCollection relentryentity = null;
                if (ecoRouteObj != null) {
                    dm.beginInit();
                    dm.setValue("id", (Object)ecoRouteObj.getLong("id"));
                    dm.setValue("number", ecoRouteObj.get("number"));
                    dm.setValue("name", ecoRouteObj.get("name"));
                    dm.setValue("material", ecoRouteObj.get("material"));
                    dm.setValue("createorg", ecoRouteObj.get("createorg"));
                    dm.setValue("version", ecoRouteObj.get("version"));
                    dm.setValue("routeversion", ecoRouteObj.get("routeversion"));
                    dm.setValue("status", ecoRouteObj.get("status"));
                    dm.setValue("routeid", ecoRouteObj.get("routeid"));
                    dm.setValue(PROP_PENTRYVALIDDATE, ecoRouteObj.get(PROP_PENTRYVALIDDATE));
                    dm.setValue("productno", ecoRouteObj.get("productno"));
                    dm.setValue("ismainprocess", ecoRouteObj.get("ismainprocess"));
                    dm.setValue("fremark", ecoRouteObj.get("fremark"));
                    dm.setValue("routereplace", ecoRouteObj.get("routereplace"));
                    dm.setValue("processtype", ecoRouteObj.get("processtype"));
                    dm.setValue("unit", ecoRouteObj.get("unit"));
                    dm.setValue("ctrlstrategy", ecoRouteObj.get("ctrlstrategy"));
                    dm.setValue("wbs", ecoRouteObj.get("wbs"));
                    entrys = ecoRouteObj.getDynamicObjectCollection(PROP_ENTRY);
                    entrys3 = ecoRouteObj.getDynamicObjectCollection(PROP_ENTRY3);
                    entryentity = ecoRouteObj.getDynamicObjectCollection(PROP_ENTRYENTITY);
                    relentryentity = ecoRouteObj.getDynamicObjectCollection(PROP_RELENTRYENTITY);
                    if (!PlatformUtils.isNullCollection((DynamicObjectCollection)entrys)) {
                        dm.setValue(PROP_ENTRY, (Object)entrys);
                    }
                    if (!PlatformUtils.isNullCollection((DynamicObjectCollection)entrys3)) {
                        dm.setValue(PROP_ENTRY3, (Object)entrys3);
                    }
                    if (!PlatformUtils.isNullCollection((DynamicObjectCollection)entryentity)) {
                        dm.setValue(PROP_ENTRYENTITY, (Object)entryentity);
                    }
                    if (!PlatformUtils.isNullCollection((DynamicObjectCollection)relentryentity)) {
                        dm.setValue(PROP_RELENTRYENTITY, (Object)relentryentity);
                    }
                    dm.endInit();
                }
            }
        }
        catch (Exception e1) {
            logger.error((Throwable)e1);
            this.closeShowLoading();
            throw e1;
        }
    }

    private Set<String> getNotUpdateEntryFieldSet() {
        HashSet<String> fieldSet = new HashSet<String>(16);
        fieldSet.add("id");
        return fieldSet;
    }

    public void genEntryData(Set<Long> routeEntryIdSet, String entryMode) {
        AbstractGrid.GridState entryGS;
        AbstractFormDataModel afdm;
        IFormView fv = this.getView();
        IDataModel dm = fv.getModel();
        AbstractFormDataModel abstractFormDataModel = afdm = dm instanceof AbstractFormDataModel ? (AbstractFormDataModel)dm : null;
        if (afdm == null) {
            return;
        }
        EntryGrid entryEG = (EntryGrid)this.getControl(PROP_ENTRY3);
        AbstractGrid.GridState gridState = entryGS = entryEG == null ? null : entryEG.getEntryState();
        if (entryGS == null) {
            return;
        }
        Long routeId = this.getRouteId();
        DynamicObject pEntryRouteDO = BusinessDataServiceHelper.loadSingle((Object)routeId, (String)"pdm_route");
        DynamicObjectCollection processEntryColl = pEntryRouteDO.getDynamicObjectCollection(PROP_ENTRY);
        if (PlatformUtils.isNullCollection((DynamicObjectCollection)processEntryColl)) {
            return;
        }
        Set<String> unIncludeFieldSet = this.getNotUpdateEntryFieldSet();
        DynamicObjectCollection ecoProcessEntryColl = this.getModel().getEntryEntity(PROP_ENTRY);
        Date pentryvaliddate = (Date)this.getPentryPropertyValue(PROP_PENTRYVALIDDATE, -1);
        for (DynamicObject processEntry : processEntryColl) {
            Long processEntryId = (Long)processEntry.getPkValue();
            if (!routeEntryIdSet.contains(processEntryId)) continue;
            DynamicObject newEcoRouteProcessEntry = ecoProcessEntryColl.addNew();
            EcoCommonHelper.putAllProperties((DynamicObject)processEntry, (DynamicObject)newEcoRouteProcessEntry, unIncludeFieldSet);
            newEcoRouteProcessEntry.set(PROP_ENTRYMODE, (Object)entryMode);
            newEcoRouteProcessEntry.set(PROP_OLDPROCESSENTRYID, (Object)processEntryId);
            newEcoRouteProcessEntry.set(PROP_NEWPROCESSENTRYID, (Object)processEntryId);
            newEcoRouteProcessEntry.set(PROP_ACTTIME, (Object)pentryvaliddate);
            newEcoRouteProcessEntry.set(PROP_ESTIMATESTATUS, (Object)"A");
            if (!"C".equals(entryMode)) continue;
            newEcoRouteProcessEntry.set(PROP_ENTRYMODE, (Object)"B");
            newEcoRouteProcessEntry = ecoProcessEntryColl.addNew();
            EcoCommonHelper.putAllProperties((DynamicObject)processEntry, (DynamicObject)newEcoRouteProcessEntry, unIncludeFieldSet);
            newEcoRouteProcessEntry.set(PROP_ENTRYMODE, (Object)entryMode);
            newEcoRouteProcessEntry.set(PROP_OLDPROCESSENTRYID, (Object)processEntryId);
            newEcoRouteProcessEntry.set(PROP_NEWPROCESSENTRYID, (Object)0L);
            newEcoRouteProcessEntry.set(PROP_ACTTIME, (Object)pentryvaliddate);
            newEcoRouteProcessEntry.set(PROP_ESTIMATESTATUS, (Object)"A");
            newEcoRouteProcessEntry.set(PROP_ENTRYVALIDDATE, (Object)pentryvaliddate);
        }
        dm.updateEntryCache(ecoProcessEntryColl);
        fv.updateView(PROP_ENTRY);
        this.showData(dm, 0);
    }

    private void setFieldValue(IDataModel dm, String fieldNumber, Object newValue) {
        Object oldValue = dm.getValue(fieldNumber);
        if (EcoCommonHelper.isDifferent((Object)oldValue, (Object)newValue)) {
            if (newValue instanceof DynamicObject) {
                dm.setValue(fieldNumber, ((DynamicObject)newValue).getPkValue());
            } else {
                dm.setValue(fieldNumber, newValue);
            }
        }
    }
}

