/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.formplugin.mftbom.bomsearch;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.mmc.pdm.business.mftbom.bomsearch.BOMExpandConfigBusiness;
import kd.mmc.pdm.business.mftbom.bomsearch.BOMVersionFilterBusiness;
import kd.mmc.pdm.business.mftbom.bomsearch.BomBackwardSearchBusiness;
import kd.mmc.pdm.common.bom.ecoplatform.PlatformUtils;

public class BOMBackForwardSearchReportPlugin
extends AbstractReportListDataPlugin {
    private String isLeaf = "false";
    private String showTypeTmp = null;
    private BigDecimal demandCount = new BigDecimal("1");

    public DataSet query(ReportQueryParam param, Object obj) throws Throwable {
        String showtype;
        FilterInfo filterInfo = param.getFilter();
        Date searchDate = filterInfo.getDate("searchdate");
        DynamicObject materialObj = filterInfo.getDynamicObject("materialno");
        DynamicObject orgObj = filterInfo.getDynamicObject("org");
        DynamicObject bomVerObj = filterInfo.getDynamicObject("bomversion");
        DynamicObject bomExpandConfigObj = filterInfo.getDynamicObject("bomexpandconfig");
        DynamicObject insteadObj = filterInfo.getDynamicObject("insteadnum");
        DynamicObject featureTypeObj = filterInfo.getDynamicObject("featuretypeid");
        DynamicObject wbsObj = filterInfo.getDynamicObject("bomwbs");
        Long wbsId = PlatformUtils.getDynamicObjectId((DynamicObject)wbsObj);
        BigDecimal demandCountTmp = filterInfo.getBigDecimal("demandcount");
        if (demandCountTmp != null && demandCountTmp.compareTo(BigDecimal.ZERO) > 0) {
            this.demandCount = demandCountTmp;
        }
        int levelCount = filterInfo.getInt("levelcount");
        this.showTypeTmp = showtype = filterInfo.getString("showtype");
        boolean isshowlast = filterInfo.getBoolean("isshowlast");
        Map bomExpandMap = BOMExpandConfigBusiness.getBomExpandConfig((long)(bomExpandConfigObj == null ? -1L : bomExpandConfigObj.getLong("id")));
        Set bomTypeSet = BOMExpandConfigBusiness.getBomType((Map)bomExpandMap);
        long materialId = materialObj == null ? 0L : materialObj.getLong("id");
        long versionId = bomVerObj == null ? 0L : bomVerObj.getLong("id");
        String auxproperty = "";
        String rondomId = "";
        String nodeType = "material";
        if (obj != null) {
            JSONObject nodeParams = JSONObject.parseObject((String)obj.toString());
            materialId = Long.parseLong(nodeParams.getString("objectId"));
            versionId = Long.parseLong(nodeParams.getString("version"));
            auxproperty = nodeParams.getString("auxproperty");
            nodeType = nodeParams.getString("nodeType");
            rondomId = nodeParams.getString("childNum");
            String usesCount = nodeParams.getString("usesCount");
            if (usesCount != null && !"".equals(usesCount)) {
                this.demandCount = new BigDecimal(usesCount);
            }
            if (nodeParams.getString("isLeaf") != null) {
                this.isLeaf = nodeParams.getString("isLeaf");
            }
        }
        if (versionId != 0L && !BOMVersionFilterBusiness.isVerEnable((long)versionId, (Date)searchDate, (String)"")) {
            versionId = -1L;
        }
        QFilter ids = BaseDataServiceHelper.getBaseDataFilter((String)"pdm_mftbom", (Long)orgObj.getLong("id"));
        QFilter material = new QFilter("entry.entrymaterialid", "=", (Object)materialId);
        QFilter bomType = new QFilter("type", "in", (Object)bomTypeSet);
        QFilter version = new QFilter("entry.entryversion", "=", (Object)versionId);
        QFilter auxp = new QFilter("entry.entryauxproperty", "=", (Object)(auxproperty == null ? 0L : Long.parseLong(auxproperty)));
        QFilter effect = new QFilter("entry.entryvaliddate", "<=", (Object)searchDate);
        QFilter invalid = new QFilter("entry.entryinvaliddate", ">=", (Object)searchDate);
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        QFilter status = new QFilter("status", "=", (Object)"C");
        Object[] allDataFilter = new QFilter[]{};
        if (orgObj != null) {
            allDataFilter = new QFilter[]{status, enable, effect, invalid, bomType, ids};
        }
        Object[] matDataFilter = null;
        Object[] featureDataFilter = null;
        matDataFilter = allDataFilter;
        BomBackwardSearchBusiness backwardSearchBusiness = new BomBackwardSearchBusiness(this.isLeaf, this.demandCount, false, levelCount, bomExpandConfigObj);
        featureDataFilter = (QFilter[])allDataFilter.clone();
        HashSet<Long> matIdSet = new HashSet<Long>(16);
        HashSet<Long> featureTypeSet = new HashSet<Long>(16);
        if (materialId != 0L) {
            matIdSet.add(materialId);
            Set featureTypeSetA = backwardSearchBusiness.getFeatureTypeByMat(matIdSet);
            if (featureTypeSetA != null && !featureTypeSetA.isEmpty()) {
                featureTypeSet.addAll(featureTypeSetA);
            }
        }
        if ("featureType".equals(nodeType)) {
            String matId;
            long featureTypeId;
            long l = featureTypeId = featureTypeObj == null ? 0L : featureTypeObj.getLong("id");
            if (featureTypeId != 0L) {
                Set matIdSetA = backwardSearchBusiness.getFeatureTypeByMat(featureTypeId);
                featureTypeSet.add(featureTypeId);
                if (matIdSetA != null && !matIdSetA.isEmpty()) {
                    matIdSet.addAll(matIdSetA);
                }
            }
            String string = matId = materialObj == null ? null : materialObj.getString("id");
            if (matId == null || matId != null && !matId.equals(materialId + "")) {
                material = new QFilter("entry.entrymaterialid", "=", (Object)-1L);
            }
        }
        QFilter featureType = new QFilter("entry.featuretype", "in", featureTypeSet);
        if (featureTypeSet.isEmpty()) {
            featureType = new QFilter("entry.id", "=", (Object)-1L);
        }
        matDataFilter = (QFilter[])ArrayUtils.add((Object[])matDataFilter, (Object)material);
        matDataFilter = (QFilter[])ArrayUtils.add((Object[])matDataFilter, (Object)version);
        if (auxproperty != null && !"".equals(auxproperty)) {
            matDataFilter = (QFilter[])ArrayUtils.add((Object[])matDataFilter, (Object)auxp);
        }
        featureDataFilter = (QFilter[])ArrayUtils.add((Object[])featureDataFilter, (Object)featureType);
        DataSet set = backwardSearchBusiness.getDataSet((QFilter[])allDataFilter, (QFilter[])matDataFilter, (QFilter[])featureDataFilter, showtype, isshowlast, searchDate, insteadObj, rondomId, true, matIdSet, versionId, wbsId);
        return this.headFilter(set, showtype);
    }

    public DataSet headFilter(DataSet set, String showtype) {
        ReportQueryParam queryParam = this.getQueryParam();
        List headFilters = queryParam.getFilter().getHeadFilters();
        String s = "";
        boolean flag = false;
        if (!headFilters.isEmpty()) {
            for (QFilter qFilter2 : headFilters) {
                String partSql = "";
                String field = qFilter2.getProperty();
                if ("materialattr".equals(field)) {
                    partSql = qFilter2.toString();
                } else if ("materialid".equals(field)) {
                    partSql = this.getMaterialSql(qFilter2, "bd_material", "materialid", "number");
                } else if ("entrymaterialid".equals(field) && !"C".equals(showtype)) {
                    partSql = this.getMaterialSql(qFilter2, "bd_material", "entrymaterialid", "number");
                } else if ("materialname".equals(field)) {
                    partSql = this.getMaterialSql(qFilter2, "bd_material", "materialname", "name");
                } else if ("entrymaterialname".equals(field) && !"C".equals(showtype)) {
                    partSql = this.getMaterialSql(qFilter2, "bd_material", "entrymaterialname", "name");
                } else if ("featuretype".equals(field) && !"C".equals(showtype)) {
                    partSql = this.getMaterialSql(qFilter2, "mpdm_featuretype", "featuretype", "number");
                } else if ("featuretypename".equals(field) && !"C".equals(showtype)) {
                    partSql = this.getMaterialSql(qFilter2, "mpdm_featuretype", "featuretypename", "name");
                } else if ("entryqtytype".equals(field)) {
                    partSql = qFilter2.toString();
                } else if ("level".equals(field) && !"C".equals(showtype)) {
                    partSql = this.getOperation(qFilter2, field, partSql);
                } else if ("wbs".equals(field)) {
                    partSql = this.getMaterialSql(qFilter2, "bd_wbs", "wbs", "name");
                }
                if ("".equals(partSql)) {
                    flag = true;
                    continue;
                }
                if (!"".equals(s)) {
                    s = s + " AND " + partSql;
                    continue;
                }
                s = partSql;
            }
        }
        if (flag && !"C".equals(showtype)) {
            set = set.filter("materialid = 0 ");
        } else if (!"".equals(s)) {
            set = set.filter(s);
        }
        if (queryParam.getSortInfo() != null) {
            return set.orderBy(new String[]{queryParam.getSortInfo()});
        }
        return set;
    }

    private String getOperation(QFilter qFilter2, String field, String partSql) {
        if (qFilter2.getCP().contains("is null")) {
            QFilter filter = new QFilter(field, "=", (Object)"");
            partSql = filter.toString();
        } else if (qFilter2.getCP().contains("not null")) {
            QFilter filter = new QFilter(field, "!=", (Object)"");
            partSql = filter.toString();
        } else {
            partSql = qFilter2.toString();
        }
        return partSql;
    }

    public String getMaterialSql(QFilter qFilter, String entityName, String filed, String filterField) {
        StringBuilder partSql = new StringBuilder();
        if (qFilter.getCP().contains("null")) {
            return filed + " " + qFilter.getCP();
        }
        qFilter.__setProperty(filterField);
        List nests = qFilter.getNests(true);
        if (nests != null) {
            qFilter.clearNests();
            for (QFilter.QFilterNest qFilterNest : nests) {
                QFilter filter = qFilterNest.getFilter();
                filter.__setProperty(filterField);
                qFilter.addFirstNest(filter, "and");
            }
        }
        DynamicObjectCollection dynamicObject = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])qFilter.toArray());
        Iterator iterator = dynamicObject.iterator();
        ArrayList<String> longs = new ArrayList<String>();
        while (iterator.hasNext()) {
            DynamicObject next = (DynamicObject)iterator.next();
            longs.add(next.getString("id"));
        }
        if (!longs.isEmpty()) {
            partSql.append(filed).append(" in (");
            if (longs.size() == 1) {
                partSql.append((String)longs.get(0));
            } else {
                for (String aLong : longs) {
                    partSql.append(aLong).append(",");
                }
                partSql.deleteCharAt(partSql.length() - 1);
            }
            partSql.append(')');
        }
        return partSql.toString();
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        ArrayList<AbstractReportColumn> hideCol = new ArrayList<AbstractReportColumn>(columns.size());
        if ("C".equals(this.showTypeTmp)) {
            for (int i = 0; i < columns.size(); ++i) {
                AbstractReportColumn reportCol = columns.get(i);
                String dataIndex = (String)reportCol.createColumn().get("dataIndex");
                if (!"entrymaterialid".equals(dataIndex) && !"entrymaterialname".equals(dataIndex) && !"featuretype".equals(dataIndex) && !"featuretypename".equals(dataIndex) && !"entryqtynumerator".equals(dataIndex) && !"entryqtydenominator".equals(dataIndex) && !"bomlevel".equals(dataIndex) && !"level".equals(dataIndex) && !"unit".equals(dataIndex)) continue;
                hideCol.add(reportCol);
            }
            columns.removeAll(hideCol);
        }
        return super.getColumns(columns);
    }
}

