/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.formplugin.mftbom.bomsearch;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.report.AbstractReportTreeDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.mmc.pdm.business.mftbom.bomsearch.BOMExpandConfigBusiness;
import kd.mmc.pdm.business.mftbom.bomsearch.BOMReportFromProConfigBusiness;
import kd.mmc.pdm.business.mftbom.bomsearch.BOMVersionFilterBusiness;
import kd.mmc.pdm.business.mftbom.bomsearch.BomForwardSearchBusiness;
import kd.mmc.pdm.business.proconfig.proconfiglist.ProductConifgListBusiness;
import kd.mmc.pdm.common.bom.ecoplatform.PlatformUtils;
import kd.mmc.pdm.common.util.MMCUtils;

public class BomFowordSearchReportTreePlugin
extends AbstractReportTreeDataPlugin {
    public List<TreeNode> query(ReportQueryParam queryParam, String paramString) throws Throwable {
        List<TreeNode> resultList;
        long versionId;
        FilterInfo filterInfo = queryParam.getFilter();
        Date searchDate = filterInfo.getDate("searchdate");
        DynamicObject materialObj = filterInfo.getDynamicObject("materialno");
        DynamicObject orgObj = filterInfo.getDynamicObject("org");
        DynamicObject bomExpandConfigObj = filterInfo.getDynamicObject("bomexpandconfig");
        DynamicObject bomVerObj = filterInfo.getDynamicObject("bomversion");
        DynamicObject configcodeObj = filterInfo.getDynamicObject("configcode");
        DynamicObject wbsObj = filterInfo.getDynamicObject("bomwbs");
        DynamicObject insteadObj = filterInfo.getDynamicObject("insteadnum");
        BigDecimal demandCountTmp = filterInfo.getBigDecimal("demandcount");
        int levelCount = filterInfo.getInt("levelcount");
        boolean showtree = filterInfo.getBoolean("showtree");
        String showtype = filterInfo.getString("showtype");
        boolean isshowlast = filterInfo.getBoolean("isshowlast");
        Long wbsId = PlatformUtils.getDynamicObjectId((DynamicObject)wbsObj);
        Map bomExpandMap = BOMExpandConfigBusiness.getBomExpandConfig((long)(bomExpandConfigObj == null ? -1L : bomExpandConfigObj.getLong("id")));
        String verConfig = BOMExpandConfigBusiness.getExpandVerConfig((Map)bomExpandMap);
        boolean purchaseexpand = true;
        if (filterInfo.containProp("purchaseexpand")) {
            purchaseexpand = filterInfo.getBoolean("purchaseexpand");
        }
        boolean jumplevelexpand = false;
        if (filterInfo.containProp("jumplevelexpand")) {
            jumplevelexpand = filterInfo.getBoolean("jumplevelexpand");
        }
        long l = versionId = bomVerObj == null ? 0L : bomVerObj.getLong("id");
        if (!showtree) {
            return this.getDefaultTreeNodeList(versionId, materialObj, demandCountTmp, showtype, configcodeObj, false);
        }
        String purpose = BOMExpandConfigBusiness.getPurPose((DynamicObject)materialObj, (DynamicObject)configcodeObj, (Long)0L);
        Set bomTypeSet = BOMExpandConfigBusiness.getBomTypeOfPurpose((Map)bomExpandMap, (String)purpose);
        QFilter material = new QFilter("materialid", "=", (Object)(materialObj == null ? 0L : materialObj.getLong("id")));
        QFilter bomType = new QFilter("type", "in", (Object)bomTypeSet);
        QFilter version = new QFilter("version", "=", (Object)versionId);
        QFilter configCode = new QFilter("configuredcode", "=", configcodeObj == null ? Long.valueOf(0L) : configcodeObj.get("id"));
        QFilter effect = new QFilter("entry.entryvaliddate", "<=", (Object)searchDate);
        QFilter invalid = new QFilter("entry.entryinvaliddate", ">=", (Object)searchDate);
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        QFilter status = new QFilter("status", "=", (Object)"C");
        long replaceNo = insteadObj == null ? 0L : insteadObj.getLong("id");
        QFilter[] allDataFilter = null;
        if (orgObj != null) {
            QFilter ids = BaseDataServiceHelper.getBaseDataFilter((String)"pdm_mftbom", (Long)orgObj.getLong("id"));
            allDataFilter = new QFilter[]{status, enable, effect, invalid, ids};
        } else {
            allDataFilter = new QFilter[]{status, enable, effect, invalid};
        }
        Object[] globalDataFilter = (QFilter[])allDataFilter.clone();
        globalDataFilter = (QFilter[])ArrayUtils.add((Object[])globalDataFilter, (Object)bomType);
        globalDataFilter = (QFilter[])ArrayUtils.add((Object[])globalDataFilter, (Object)material);
        if (configcodeObj != null) {
            globalDataFilter = (QFilter[])ArrayUtils.add((Object[])globalDataFilter, (Object)configCode);
        }
        if (bomVerObj != null) {
            globalDataFilter = (QFilter[])ArrayUtils.add((Object[])globalDataFilter, (Object)version);
        }
        BomForwardSearchBusiness forwardBusiness = new BomForwardSearchBusiness("false", demandCountTmp, false, bomExpandConfigObj, purchaseexpand, purpose, levelCount, jumplevelexpand);
        DataSet firstSet = null;
        DataSet dataSet = null;
        boolean expandByConfigBom = false;
        if (configcodeObj != null && !QueryServiceHelper.exists((String)"pdm_mftbom", (QFilter[])globalDataFilter)) {
            ArrayList<Long> list = new ArrayList<Long>(2);
            list.add(configcodeObj == null ? -1L : configcodeObj.getLong("id"));
            JSONObject params = new JSONObject();
            params.put("searchTime", (Object)searchDate);
            params.put("isNeedProRoute", (Object)false);
            params.put("model", (Object)"model_pdm");
            params.put("configCodeList", list);
            params.put("org", (Object)(orgObj == null ? -1L : orgObj.getLong("id")));
            params.put("matId", (Object)(materialObj == null ? -1L : materialObj.getLong("id")));
            params.put("bomVer", bomVerObj == null ? Long.valueOf(0L) : bomVerObj.get("id"));
            params.put("replaceNo", (Object)replaceNo);
            params.put("wbs", (Object)wbsId);
            params.put("purchaseExpand", (Object)purchaseexpand);
            params.put("num", (Object)demandCountTmp);
            params.put("levelCount", (Object)levelCount);
            params.put("jumplevelExpand", (Object)jumplevelexpand);
            JSONObject retObj = ProductConifgListBusiness.getInstance().getProdConfigListByFeature(params.toJSONString());
            RowMeta rowMeta = this.getRowMeta(forwardBusiness);
            long configCodeId = configcodeObj == null ? 0L : configcodeObj.getLong("id");
            BOMReportFromProConfigBusiness business = new BOMReportFromProConfigBusiness("");
            dataSet = business.parseToDataSetFromJson(rowMeta, retObj, configCodeId, false);
            DataSet setTmp = dataSet.copy();
            firstSet = setTmp.filter("level='1'");
            setTmp.close();
            expandByConfigBom = true;
        }
        if (firstSet == null) {
            firstSet = forwardBusiness.getLeverDate((QFilter[])globalDataFilter);
            List firstList = MMCUtils.parseToList((DataSet)firstSet);
            firstList = BOMExpandConfigBusiness.firstLevelPriorityFilterByType((List)firstList, (Map)bomExpandMap, (String)purpose, (String)"");
            firstList = BOMExpandConfigBusiness.firstLevelPriorityFilterByWBS((List)firstList, (Map)bomExpandMap, (long)wbsId, (String)"");
            if ("B".equals(verConfig) && bomVerObj == null) {
                long verId = BOMVersionFilterBusiness.getTheLastVerOfMaterial((List)firstList, (Date)searchDate, (String)"");
                if (verId != 0L && !BOMVersionFilterBusiness.isVerEnable((long)verId, (Date)searchDate, (String)"")) {
                    verId = -1L;
                }
                firstList = BOMVersionFilterBusiness.versionFilter((List)firstList, (long)verId, (Date)searchDate, (String)"");
                versionId = verId;
            } else {
                if (versionId != 0L && !BOMVersionFilterBusiness.isVerEnable((long)versionId, (Date)searchDate, (String)"")) {
                    versionId = -1L;
                }
                firstList = BOMVersionFilterBusiness.versionFilter((List)firstList, (long)versionId, (Date)searchDate, (String)"");
            }
            firstList = BOMExpandConfigBusiness.firstLevelPriorityFilterByReplaceNo((List)firstList, (Map)bomExpandMap, (long)replaceNo, (String)"");
            firstList = BOMExpandConfigBusiness.replaceGroupFilter((List)firstList, (Date)searchDate, (String)"");
            firstSet = MMCUtils.parseToDataSet(((Object)((Object)this)).getClass(), (List)firstList, (RowMeta)firstSet.getRowMeta());
        }
        if (!showtree || !firstSet.hasNext()) {
            return this.getDefaultTreeNodeList(versionId, materialObj, demandCountTmp, showtype, configcodeObj, expandByConfigBom);
        }
        if (dataSet == null) {
            dataSet = forwardBusiness.getDataSet(allDataFilter, (QFilter[])globalDataFilter, showtype, isshowlast, searchDate, insteadObj, null, verConfig, versionId, wbsId, true);
        }
        if ((resultList = this.getTreeList(firstSet, dataSet, materialObj, bomVerObj, showtype, demandCountTmp, configcodeObj, expandByConfigBom)) == null || resultList.isEmpty()) {
            return this.getDefaultTreeNodeList(bomVerObj == null ? 0L : bomVerObj.getLong("id"), materialObj, demandCountTmp, showtype, configcodeObj, expandByConfigBom);
        }
        return resultList;
    }

    public RowMeta getRowMeta(BomForwardSearchBusiness forwardBusiness) {
        String formNum = "pdm_mftbom";
        UUID uuid = UUID.randomUUID();
        String randomId = uuid.toString().replace("-", "");
        String selectItems = forwardBusiness.getSelectItems("1");
        selectItems = selectItems + ",concat('" + randomId + "',version) randomId,version tmpver";
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"BOMForwardSearchReportPlugin", (String)formNum, (String)selectItems, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)-1L)}, null).orderBy(new String[]{"entrySeq"});
        dataSet.close();
        return dataSet.getRowMeta();
    }

    public List<TreeNode> getTreeList(DataSet firstSet, DataSet dataSet, DynamicObject materialObj, DynamicObject bomVerObj, String showtype, BigDecimal demandCountTmp, DynamicObject configcodeObj, boolean expandByConfigBom) {
        ArrayList<TreeNode> retList = new ArrayList<TreeNode>(64);
        try {
            DataSet tmpDataSet = dataSet.copy();
            Map<Long, Map<String, String>> treeNodeMap = this.getMaterial(dataSet);
            if (treeNodeMap == null) {
                ArrayList<TreeNode> arrayList = retList;
                return arrayList;
            }
            Map<String, String> firstMap = this.dealFirstLevel(retList, firstSet, materialObj, demandCountTmp, showtype, configcodeObj, expandByConfigBom);
            this.createTreeNode(retList, tmpDataSet, materialObj, showtype, treeNodeMap, configcodeObj, expandByConfigBom, firstMap);
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25", (String)"BomFowordSearchReportTreePlugin_1", (String)"mmc-pdm-formplugin", (Object[])new Object[0])), new Object[0]);
        }
        finally {
            dataSet.close();
            firstSet.close();
        }
        return retList;
    }

    private String convertNullStr(String obj) {
        return StringUtils.isEmpty((String)obj) ? "0" : obj;
    }

    private Map<String, String> dealFirstLevel(List<TreeNode> retList, DataSet firstSet, DynamicObject materialObj, BigDecimal demandCountTmp, String showtype, DynamicObject configcodeObj, boolean expandByConfigBom) {
        demandCountTmp = demandCountTmp.stripTrailingZeros();
        HashSet<String> rootIdSet = new HashSet<String>(64);
        String configId = configcodeObj == null ? "0" : configcodeObj.getString("id");
        HashMap<String, String> dataMap = new HashMap<String, String>(16);
        while (firstSet.hasNext()) {
            String configureCodeId;
            String auxproperty;
            String bomVer;
            Row row = firstSet.next();
            String materialId = row.getString("materialId");
            String rootId = this.getNodeAndPNodeId(materialId, bomVer = row.getString("bomVer"), auxproperty = this.convertNullStr(row.getString("auxproperty")), configureCodeId = this.convertNullStr(expandByConfigBom ? configId : row.getString("configCode")), expandByConfigBom, "A".equals(showtype) ? demandCountTmp : BigDecimal.ZERO, "");
            if (!rootIdSet.add(rootId)) continue;
            String matNum = materialObj.getString("number");
            String matName = materialObj.getString("name");
            String nodeName = matNum + "[" + matName + "]";
            TreeNode rootNode = new TreeNode("root", rootId, nodeName);
            this.setTreeNodeListExt(rootNode, showtype, row);
            retList.add(rootNode);
            dataMap.put(materialId + "_" + bomVer + "_auxproperty", auxproperty);
            dataMap.put(materialId + "_" + bomVer + "_configureCodeId", configureCodeId);
        }
        return dataMap;
    }

    private void createTreeNode(List<TreeNode> retList, DataSet tmpDataSet, DynamicObject materialObj, String showtype, Map<Long, Map<String, String>> treeNodeMap, DynamicObject configcodeObj, boolean expandByConfigBom, Map<String, String> firstMap) {
        try {
            Long configcodeObjId = configcodeObj == null ? 0L : configcodeObj.getLong("id");
            while (tmpDataSet.hasNext()) {
                String[] num;
                String childNum;
                String parentNum;
                Row row = tmpDataSet.next();
                String randomId = "";
                String materialId = null;
                String version = null;
                String pConfigureId = null;
                String pauxproperty = null;
                if (!"A".equals(showtype)) {
                    parentNum = "0";
                    childNum = "0";
                    materialId = String.valueOf(materialObj.get("id"));
                    version = String.valueOf(row.getLong("tmpver"));
                    pauxproperty = firstMap.get(materialId + "_" + version + "_auxproperty");
                    pConfigureId = firstMap.get(materialId + "_" + version + "_configureCodeId");
                    if (pauxproperty == null || "".equals(pauxproperty)) {
                        pauxproperty = "0";
                    }
                    if (pConfigureId == null || "".equals(pConfigureId)) {
                        pConfigureId = "0";
                    }
                } else {
                    randomId = row.getString("randomId");
                    materialId = String.valueOf(row.get("materialId"));
                    version = String.valueOf(row.getLong("bomVer"));
                    pConfigureId = this.convertNullStr(expandByConfigBom ? String.valueOf(configcodeObjId) : row.getString("configCode"));
                    pauxproperty = this.convertNullStr(row.getString("auxproperty"));
                }
                if ((num = randomId.split("-")).length == 1) {
                    parentNum = "";
                    childNum = randomId;
                } else {
                    parentNum = num[num.length - 2];
                    childNum = num[num.length - 1];
                }
                long entrymaterialId = row.getLong("entrymaterialId");
                Object entryVerObj = row.get("entryversion");
                long entryversion = 0L;
                if (entryVerObj != null) {
                    entryversion = row.getLong("entryversion");
                }
                long entryauxproperty = row.getLong("entryauxproperty");
                long entryConfigureId = expandByConfigBom ? configcodeObjId : row.getLong("entryConfigCode");
                Map<String, String> mateMap = treeNodeMap.get(entrymaterialId);
                if (mateMap == null) continue;
                String number = mateMap.get("number");
                String name = mateMap.get("name");
                if (!"A".equals(showtype)) {
                    childNum = version;
                }
                BigDecimal pcommonused = "A".equals(showtype) ? row.getBigDecimal("pcommonused") : BigDecimal.ZERO;
                BigDecimal commonused = "A".equals(showtype) ? row.getBigDecimal("commonused") : BigDecimal.ZERO;
                String parentId = this.getNodeAndPNodeId(materialId, version, pauxproperty, pConfigureId, expandByConfigBom, pcommonused, parentNum);
                String id = this.getNodeAndPNodeId(String.valueOf(entrymaterialId), String.valueOf(entryversion), String.valueOf(entryauxproperty), String.valueOf(entryConfigureId), expandByConfigBom, commonused, childNum);
                String text = number + "[" + name + "]";
                TreeNode node = new TreeNode(parentId, id, text);
                this.setTreeNodeListExt(node, showtype, row);
                retList.add(node);
            }
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, new ErrorCode("find-error", ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25", (String)"BomFowordSearchReportTreePlugin_1", (String)"mmc-pdm-formplugin", (Object[])new Object[0])), new Object[0]);
        }
        finally {
            tmpDataSet.close();
        }
    }

    public void setTreeNodeListExt(TreeNode node, String showtype, Row row) {
    }

    private Map<Long, Map<String, String>> getMaterial(DataSet dataSet) {
        HashSet<Long> mids = new HashSet<Long>(512);
        while (dataSet.hasNext()) {
            Row tmpRow = dataSet.next();
            long entrymaterialId = tmpRow.getLong("entrymaterialId");
            mids.add(entrymaterialId);
        }
        if (mids.isEmpty()) {
            return null;
        }
        QFilter material = new QFilter("id", "in", mids);
        HashMap<Long, Map<String, String>> treeNodeMap = new HashMap<Long, Map<String, String>>(mids.size());
        try (DataSet materialDataSet = QueryServiceHelper.queryDataSet((String)"BomFowordSearchReportTreePlugin", (String)"bd_material", (String)"id,number,name,modelnum", (QFilter[])new QFilter[]{material}, null);){
            while (materialDataSet.hasNext()) {
                Row mateRow = materialDataSet.next();
                Long id = mateRow.getLong("id");
                String number = mateRow.getString("number");
                String name = mateRow.getString("name");
                String modelnum = mateRow.getString("modelnum");
                HashMap<String, String> mateMap = new HashMap<String, String>(16);
                mateMap.put("number", number);
                mateMap.put("name", name);
                mateMap.put("modelnum", modelnum);
                treeNodeMap.put(id, mateMap);
            }
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, new ErrorCode("search-error", ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25", (String)"BomFowordSearchReportTreePlugin_1", (String)"mmc-pdm-formplugin", (Object[])new Object[0])), new Object[0]);
        }
        return treeNodeMap;
    }

    private List<TreeNode> getDefaultTreeNodeList(long versionId, DynamicObject materialObj, BigDecimal demandCountTmp, String showType, DynamicObject configcodeObj, boolean expandByConfigBom) {
        demandCountTmp = demandCountTmp.stripTrailingZeros();
        ArrayList<TreeNode> retList = new ArrayList<TreeNode>(16);
        if (materialObj != null) {
            String configId = configcodeObj == null ? "0" : configcodeObj.getString("id");
            String rootId = this.getNodeAndPNodeId(materialObj.getString("id"), String.valueOf(versionId), "0", configId, expandByConfigBom, demandCountTmp, "");
            String matNum = String.valueOf(materialObj.get("number"));
            String matName = String.valueOf(materialObj.get("name"));
            String nodeName = matNum + "[" + matName + "]";
            TreeNode rootNode = new TreeNode("root", rootId, nodeName);
            retList.add(rootNode);
        }
        return retList;
    }

    private String getNodeAndPNodeId(String materialId, String version, String auxproperty, String configureCodeId, boolean expandByConfigBom, BigDecimal demandCount, String randomId) {
        JSONObject pObj = new JSONObject(new LinkedHashMap(16));
        pObj.put("materialId", (Object)materialId);
        pObj.put("version", (Object)version);
        pObj.put("auxproperty", (Object)auxproperty);
        pObj.put("configureCodeId", (Object)configureCodeId);
        pObj.put("expandByConfigBom", (Object)expandByConfigBom);
        demandCount = demandCount.stripTrailingZeros();
        pObj.put("demandCount", (Object)demandCount.toPlainString());
        pObj.put("randomId", (Object)randomId);
        return pObj.toJSONString();
    }
}

