/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.formplugin.mftbom.bomsearch.batch;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.filter.ReportFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mmc.pdm.common.util.MMCUtils;
import kd.mmc.pdm.common.util.PdmParamSetHelper;
import kd.mmc.pdm.formplugin.mftbom.bomsearch.batch.BomBatchSearchFormPlugin;

public class BomBatchForwardSearchFormPlugin
extends BomBatchSearchFormPlugin {
    private static Log log = LogFactory.getLog(BomBatchForwardSearchFormPlugin.class);
    private static String[] fieldArray = new String[]{"querymaterial", "querybomversion", "queryconfigurecode", "querybomwbs", "queryinsteadnum", "queryqty", "queryunit"};

    @Override
    public Set<String> sortAndFilterFieldSet() {
        IReportView view = this.getView();
        IDataModel model = view.getModel();
        String showType = (String)model.getValue("showtype");
        if ("A".equals(showType)) {
            return new TreeSet<String>(Arrays.asList("level", "bomlevel", "entrymaterialattr", "rootmaterialid", "rootconfigcode", "materialid", "entrymaterialid", "entryconfigcode", "entryqtytype", "featuretype", "featuretypename", "rootwbs", "wbs"));
        }
        return new TreeSet<String>(Arrays.asList("entrymaterialattr", "rootmaterialid", "rootconfigcode", "materialid", "entrymaterialid", "entryconfigcode", "entryqtytype", "featuretype", "featuretypename", "rootwbs", "wbs"));
    }

    @Override
    public void initDefaultQueryParam(ReportQueryParam queryParam) {
        super.initDefaultQueryParam(queryParam);
        this.getModel().setValue("bomexpandconfig", (Object)1637711947497568256L);
    }

    private boolean isDefaultConfigcode() {
        return (Boolean)this.getModel().getValue("defaultconfigcode");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObjectCollection entryEntity;
        if (this.getPageCache().get("isIgnoreChangeListener") == "true") {
            return;
        }
        String propertyName = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        int rowIndex = changeData[0].getRowIndex();
        IReportView view = this.getView();
        IDataModel model = view.getModel();
        if ("querymaterial".equals(propertyName)) {
            model.setValue("querybomversion", null, rowIndex);
            model.setValue("queryconfigurecode", null, rowIndex);
            model.setValue("queryinsteadnum", null, rowIndex);
            model.setValue("queryunit", null, rowIndex);
            model.setValue("querybomwbs", null, rowIndex);
            if (newValue == null) {
                return;
            }
            DynamicObject materialObj = (DynamicObject)newValue;
            DynamicObject baseUnit = (DynamicObject)materialObj.get("baseunit");
            if (baseUnit == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7269\u6599\u5bf9\u5e94\u7684\u57fa\u672c\u5355\u4f4d\u4e3a\u7a7a\u3002", (String)"BomBatchForwardSearchFormPlugin_0", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
                return;
            }
            model.setValue("queryunit", (Object)baseUnit, rowIndex);
            if (this.isDefaultConfigcode()) {
                DynamicObject configCode = this.getDefaultConfigCode(materialObj);
                model.setValue("queryconfigurecode", (Object)configCode, rowIndex);
            }
            view.updateView("querybomversion", rowIndex);
            view.updateView("queryconfigurecode", rowIndex);
            view.updateView("queryinsteadnum", rowIndex);
            view.updateView("queryunit", rowIndex);
            view.updateView("querybomwbs", rowIndex);
        } else if ("showtype".equals(propertyName)) {
            String showType = (String)model.getValue("showtype");
            if ("A".equals(showType)) {
                view.setVisible(Boolean.FALSE, new String[]{"isshowlast"});
                view.updateView();
            } else {
                view.setVisible(Boolean.TRUE, new String[]{"isshowlast"});
                view.updateView();
            }
        } else if ("defaultconfigcode".equals(propertyName) && ((Boolean)newValue).booleanValue() && (entryEntity = this.getModel().getEntryEntity("queryentry")) != null && !entryEntity.isEmpty()) {
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject entry = (DynamicObject)entryEntity.get(i);
                DynamicObject material = entry.getDynamicObject("querymaterial");
                if (material == null) continue;
                DynamicObject configCode = this.getDefaultConfigCode(material);
                model.setValue("queryconfigurecode", (Object)configCode, i);
                view.updateView("queryconfigurecode", i);
            }
        }
    }

    private DynamicObject getDefaultConfigCode(DynamicObject material) {
        if (material == null) {
            return null;
        }
        long matId = material.getLong("id");
        QFilter matfilter = new QFilter("material", "=", (Object)matId);
        QFilter isDefault = new QFilter("isdefault", "=", (Object)"1");
        DynamicObject configcodeObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_configuredcode", (QFilter[])new QFilter[]{matfilter, isDefault});
        return configcodeObj;
    }

    public void setExcelName(List<String> list) {
        String name = ResManager.loadKDString((String)"BOM\u6279\u91cf\u6b63\u67e5_", (String)"BomBatchForwardSearchFormPlugin_1", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
        Date searchDate = (Date)this.getModel().getValue("searchdate");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        name = name + this.getExcelName(searchDate, org);
        list.add(name);
        super.setExcelName(list);
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        this.addCustomParam(queryParam);
        super.beforeQuery(queryParam);
        ReportFilter reportfilterap = (ReportFilter)this.getControl("reportfilterap");
        reportfilterap.setCollapse(true);
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"toolbarap", "reportlistap"});
    }

    public void addCustomParam(ReportQueryParam queryParam) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("queryentry");
        HashMap<String, DynamicObjectCollection> customParamMap = queryParam.getCustomParam();
        if (customParamMap == null) {
            customParamMap = new HashMap<String, DynamicObjectCollection>(16);
        }
        customParamMap.put("queryentry", entryEntity);
        queryParam.setCustomParam(customParamMap);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        DynamicObject materialInfoObj;
        DynamicObject orgObj;
        ListFilterParameter lfp;
        IDataEntityProperty srcDEP = e.getProperty();
        String srcDEPName = srcDEP == null ? null : srcDEP.getName();
        IReportView view = this.getView();
        IDataModel model = view.getModel();
        FormShowParameter fsp = e.getFormShowParameter();
        if (fsp == null) {
            return;
        }
        ListShowParameter lsp = fsp instanceof ListShowParameter ? (ListShowParameter)fsp : null;
        ListFilterParameter listFilterParameter = lfp = lsp == null ? null : lsp.getListFilterParameter();
        if (lsp == null) {
            return;
        }
        if (lfp == null) {
            return;
        }
        int rowIndex = e.getRow();
        if ("querymaterial".equalsIgnoreCase(srcDEPName) && (orgObj = (DynamicObject)model.getValue("org")) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4f7f\u7528\u7ec4\u7ec7\u3002", (String)"BomBatchForwardSearchFormPlugin_2", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        if ("querybomversion".equalsIgnoreCase(srcDEPName) && (materialInfoObj = (DynamicObject)model.getValue("querymaterial", rowIndex)) != null) {
            qFilterList.add(new QFilter("material", "=", materialInfoObj.getPkValue()));
        }
        if (!MMCUtils.isEmptyList(qFilterList)) {
            lfp.setQFilters(qFilterList);
            lsp.setListFilterParameter(lfp);
            e.setFormShowParameter((FormShowParameter)lsp);
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        Date searchDate = filterInfo.getDate("searchdate");
        DynamicObject org = filterInfo.getDynamicObject("org");
        DynamicObject bomexpandconfig = filterInfo.getDynamicObject("bomexpandconfig");
        String showtype = filterInfo.getString("showtype");
        if (showtype == null || "".equals(showtype)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5c55\u5f00\u65b9\u5f0f\u3002", (String)"BomBatchForwardSearchFormPlugin_3", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            return false;
        }
        List headFilters = filterInfo.getHeadFilters();
        if (headFilters != null && !headFilters.isEmpty()) {
            Set<String> fields = this.sortAndFilterFieldSet();
            for (QFilter headFilter : headFilters) {
                String fieldNumber = headFilter.getProperty();
                if (fields.contains(fieldNumber)) continue;
                String expandTypeName = "A".equalsIgnoreCase(showtype) ? ResManager.loadKDString((String)"\u9010\u7ea7\u5c55\u5f00", (String)"BomBatchForwardSearchFormPlugin_4", (String)"mmc-pdm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7efc\u5408\u5c55\u5f00", (String)"BomBatchForwardSearchFormPlugin_5", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5c55\u5f00\u65b9\u5f0f\u201c%1$s\u201d\u4e0d\u652f\u6301\u5b57\u6bb5\u201c%2$s\u201d\u7684\u8fc7\u6ee4\uff0c\u8bf7\u6e05\u9664\u8be5\u8fc7\u6ee4\u6761\u4ef6\u540e\u518d\u91cd\u8bd5\u3002", (String)"BomBatchForwardSearchFormPlugin_6", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), expandTypeName, this.getFieldName(fieldNumber)));
                return false;
            }
        }
        if (searchDate == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u67e5\u8be2\u65f6\u95f4\u3002", (String)"BomBatchForwardSearchFormPlugin_7", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (bomexpandconfig == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199BOM\u5c55\u5f00\u8bbe\u7f6e\u3002", (String)"BomBatchForwardSearchFormPlugin_8", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4f7f\u7528\u7ec4\u7ec7\u3002", (String)"BomBatchForwardSearchFormPlugin_2", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            return false;
        }
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("queryentry");
        if (!entryEntity.isEmpty()) {
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject entry = (DynamicObject)entryEntity.get(i);
                DynamicObject materialObj = entry.getDynamicObject("querymaterial");
                if (materialObj == null) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7b2c\u201c%1$s\u201d\u884c\u5206\u5f55\u7684\u7269\u6599\u7f16\u7801\u3002", (String)"BomBatchForwardSearchFormPlugin_9", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), i + 1));
                    return false;
                }
                BigDecimal demandcount = entry.getBigDecimal("queryqty");
                if (BigDecimal.ZERO.compareTo(demandcount) == 0) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7b2c\u201c%1$s\u201d\u884c\u5206\u5f55\u7684\u9700\u6c42\u6570\u91cf\u3002", (String)"BomBatchForwardSearchFormPlugin_10", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), i + 1));
                    return false;
                }
                if (BigDecimal.ZERO.compareTo(demandcount) <= 0) continue;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\u5206\u5f55\u9700\u6c42\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"BomBatchForwardSearchFormPlugin_11", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), i + 1));
                return false;
            }
            int maxSize = this.getMaxQuerySize();
            if (entryEntity.size() > maxSize) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7269\u6599\u6570\u636e\u91cf\u201c%1$s\u201d\u8d85\u8fc7\u6700\u5927\u9650\u5236\u6570\u201c%2$s\u201d\uff0c\u8bf7\u91cd\u65b0\u67e5\u8be2\u3002", (String)"BomBatchForwardSearchFormPlugin_12", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), entryEntity.size(), maxSize));
                return false;
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u6570\u636e\u6e05\u5355\u4e2d\u65e0\u6570\u636e\u3002", (String)"BomBatchForwardSearchFormPlugin_13", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    @Override
    public void registerListener(EventObject e) {
        BasedataEdit bomVersionBaseData = (BasedataEdit)this.getControl("querybomversion");
        bomVersionBaseData.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit materialBaseData = (BasedataEdit)this.getControl("querymaterial");
        materialBaseData.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit configureCodeBaseData = (BasedataEdit)this.getControl("queryconfigurecode");
        configureCodeBaseData.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit insteadNumBaseData = (BasedataEdit)this.getControl("queryinsteadnum");
        insteadNumBaseData.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void addToEntry(String excelData) {
        super.addToEntry(excelData);
        JSONArray excelDataArray = JSON.parseArray((String)excelData);
        if (excelDataArray == null || excelDataArray.isEmpty()) {
            return;
        }
        TableValueSetter vs = new TableValueSetter(fieldArray);
        IReportView view = this.getView();
        AbstractFormDataModel model = (AbstractFormDataModel)view.getModel();
        model.beginInit();
        for (int i = 0; i < excelDataArray.size(); ++i) {
            JSONObject jsonData = (JSONObject)excelDataArray.get(i);
            ArrayList<Object[]> listValues = new ArrayList<Object[]>(16);
            ArrayList<Number> listValue = new ArrayList<Number>(16);
            Long materialId = jsonData.getLong("querymaterial");
            Long unitId = jsonData.getLong("queryunit");
            Long bomVersionId = jsonData.getLong("querybomversion");
            Long confiureCode = jsonData.getLong("queryconfigurecode");
            Long wbsId = jsonData.getLong("querybomwbs");
            Long insteadNumId = jsonData.getLong("queryinsteadnum");
            BigDecimal qty = jsonData.getBigDecimal("queryqty");
            listValue.add(materialId);
            listValue.add(bomVersionId);
            listValue.add(confiureCode);
            listValue.add(wbsId);
            listValue.add(insteadNumId);
            listValue.add(qty);
            listValue.add(unitId);
            listValues.add(listValue.toArray());
            if (listValues.isEmpty()) continue;
            for (Object[] value : listValues) {
                vs.addRow(value);
            }
        }
        model.batchCreateNewEntryRow("queryentry", vs);
        model.endInit();
        this.getView().updateView("queryentry");
    }

    private int getMaxQuerySize() {
        return PdmParamSetHelper.getIntParamValue((String)"BomBatchForwardSearch_MaxSize");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        DynamicObject org;
        super.beforeDoOperation(e);
        String key = ((AbstractOperate)e.getSource()).getOperateKey();
        if ("importexcelentry".equals(key) && (org = (DynamicObject)this.getModel().getValue("org")) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4f7f\u7528\u7ec4\u7ec7\u3002", (String)"BomBatchForwardSearchFormPlugin_2", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        if ("importexcelentry".equals(key)) {
            HashMap<String, String> para = new HashMap<String, String>();
            String importEntity = "pdm_bomexcelimport";
            para.put("formId", importEntity);
            FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
            showParameter.setCustomParam("bombatchquerytype", (Object)"bombatchforwardsearch");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, importEntity));
            showParameter.setCaption(ResManager.loadKDString((String)"\u6279\u91cf\u6b63\u67e5\u6570\u636e\u5bfc\u5165", (String)"BomBatchForwardSearchFormPlugin_14", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            this.getView().showForm(showParameter);
        }
    }
}

