/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.formplugin.mftbom.bomsearch.batch;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.pdm.business.mftbom.bomsearch.BomForwardSearchBusiness;
import kd.mmc.pdm.business.mftbom.bomsearch.batch.BomBatchSearchImpl;
import kd.mmc.pdm.business.mftbom.bomsearch.batch.batchtask.BomBatchSearchTaskEvent;
import kd.mmc.pdm.common.bom.ecoplatform.PlatformUtils;
import kd.mmc.pdm.common.util.PdmParamSetHelper;
import kd.mmc.pdm.formplugin.mftbom.bomsearch.batch.BatchQueryUtils;
import kd.mmc.pdm.formplugin.mftbom.bomsearch.batch.BomBatchSearchReportPlugin;
import kd.mpscmm.msplan.mservice.service.batchtask.BatchTask;

public class BomBatchForwardSearchReportPlugin
extends BomBatchSearchReportPlugin {
    private static final Log logger = LogFactory.getLog(BomBatchForwardSearchReportPlugin.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSet doQuery(ReportQueryParam param, Object obj) throws Throwable {
        DynamicObjectCollection queryColl;
        FilterInfo filterInfo = param.getFilter();
        DynamicObject org = filterInfo.getDynamicObject("org");
        Date searchDate = filterInfo.getDate("searchdate");
        DynamicObject bomExpandConfigObj = filterInfo.getDynamicObject("bomexpandconfig");
        String showtype = filterInfo.getString("showtype");
        boolean isshowlast = filterInfo.getBoolean("isshowlast");
        boolean purchaseexpand = filterInfo.getBoolean("purchaseexpand");
        boolean jumplevelexpand = filterInfo.getBoolean("jumplevelexpand");
        int levelCount = filterInfo.getInt("levelcount");
        Map customParamMap = param.getCustomParam();
        DynamicObjectCollection dynamicObjectCollection = queryColl = customParamMap == null ? null : (DynamicObjectCollection)customParamMap.get("queryentry");
        if (queryColl == null || queryColl.isEmpty()) {
            logger.error("--------------BomBatchForwardSearchReportPlugin------queryColl is null----");
            return this.buildNullResult(param, obj);
        }
        boolean isBatchCompute = this.isBatchCompute();
        StringBuilder errorSb = new StringBuilder();
        DataSet dataSet = null;
        ArrayList<DataSet> nextDataSetList = new ArrayList<DataSet>(16);
        int querySize = queryColl.size();
        HashMap<Integer, String> uuidMap = new HashMap<Integer, String>(16);
        long[] uuids = this.genUUIds(querySize);
        String rowMsg = ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\u5206\u5f55\u7269\u6599\u201c%2$s\u201d\u3002", (String)"BomBatchForwardSearchReportPlugin_0", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
        boolean isRedisCache = isBatchCompute && querySize > 1;
        BatchTask task = null;
        if (isRedisCache) {
            task = BatchTask.create((String)this.getTaskName());
            task.setQueueName(BatchQueryUtils.getBatchConsumerQueue());
            task.registBizClass(BomBatchSearchTaskEvent.class);
            task.setTimeOut(3600000L);
        }
        for (int i = 0; i < querySize; ++i) {
            DynamicObject queryDy = (DynamicObject)queryColl.get(i);
            DynamicObject materialObj = queryDy.getDynamicObject("querymaterial");
            DynamicObject bomVerObj = queryDy.getDynamicObject("querybomversion");
            DynamicObject configcodeObj = queryDy.getDynamicObject("queryconfigurecode");
            DynamicObject wbsObj = queryDy.getDynamicObject("querybomwbs");
            DynamicObject insteadObj = queryDy.getDynamicObject("queryinsteadnum");
            BigDecimal demandCount = queryDy.getBigDecimal("queryqty");
            String configproperties = materialObj.getString("configproperties");
            boolean isEnableMaterialVersion = materialObj.getBoolean("isenablematerialversion");
            String rowMsgString = String.format(rowMsg, i + 1, materialObj.getString("number"));
            HashMap<String, Object> queryParamMap = new HashMap<String, Object>(32);
            String uuid = String.valueOf(uuids[i]);
            queryParamMap.put("uuid", uuid);
            queryParamMap.put("querytype", "bombatchforwardsearch");
            queryParamMap.put("cacheredis", isRedisCache ? "true" : "false");
            queryParamMap.put("orgid", org.getLong("id"));
            queryParamMap.put("bomexpandConfigId", bomExpandConfigObj == null ? 0L : bomExpandConfigObj.getLong("id"));
            queryParamMap.put("materialid", materialObj == null ? 0L : materialObj.getLong("id"));
            queryParamMap.put("bomversionid", bomVerObj == null ? 0L : bomVerObj.getLong("id"));
            queryParamMap.put("insteadnumid", insteadObj == null ? 0L : insteadObj.getLong("id"));
            queryParamMap.put("wbsid", wbsObj == null ? 0L : wbsObj.getLong("id"));
            queryParamMap.put("configurecodeid", configcodeObj == null ? 0L : configcodeObj.getLong("id"));
            queryParamMap.put("configproperties", configproperties);
            queryParamMap.put("isenablematerialversion", isEnableMaterialVersion);
            queryParamMap.put("showtype", showtype);
            queryParamMap.put("isshowlast", isshowlast);
            queryParamMap.put("purchaseexpand", purchaseexpand);
            queryParamMap.put("demandcount", demandCount);
            queryParamMap.put("searchdate", searchDate.getTime());
            queryParamMap.put("levelcount", levelCount);
            queryParamMap.put("jumplevelexpand", jumplevelexpand);
            if (!isRedisCache) {
                JSONObject result = BomBatchSearchImpl.getInstance().exec(queryParamMap);
                dataSet = this.buildDataSet(result, errorSb, nextDataSetList, queryDy, dataSet, rowMsgString);
                continue;
            }
            uuidMap.put(i, uuid);
            if (task == null) continue;
            task.addEvent(queryParamMap);
        }
        if (isRedisCache && task != null) {
            boolean successful = true;
            long startTime = System.currentTimeMillis();
            String errorMsg = "";
            try {
                logger.info("BomBatchForwardSearchReportPlugin_BatchTask\u5206\u5e03\u5f0f\u8ba1\u7b97\u8c03\u5ea6\u5f00\u59cb\uff0c\u5171[" + querySize + "]\u4e2a\u4efb\u52a1...");
                logger.info("BomBatchForwardSearchReportPlugin_BatchTask\u5206\u5e03\u5f0f\u8ba1\u7b97\u8c03\u5ea6\u5f00\u59cb\uff0c\u5171[" + querySize + "]\u4e2a\u4efb\u52a1...");
                task.startTask();
                logger.info("BomBatchForwardSearchReportPlugin_BatchTask\u5206\u5e03\u5f0f\u8ba1\u7b97\u8c03\u5ea6\u7ed3\u675f...");
                logger.info("BomBatchForwardSearchReportPlugin_BatchTask\u5206\u5e03\u5f0f\u8ba1\u7b97\u8c03\u5ea6\u7ed3\u675f...");
            }
            catch (Exception e) {
                logger.error("BomBatchForwardSearchReportPlugin_BatchTask\u5206\u5e03\u5f0f\u8ba1\u7b97\u51fa\u9519\uff1a" + e.getMessage(), (Throwable)e);
                logger.error("BomBatchForwardSearchReportPlugin_BatchTask\u5206\u5e03\u5f0f\u8ba1\u7b97\u51fa\u9519\uff1a" + e.getMessage(), (Throwable)e);
                successful = false;
                errorMsg = PlatformUtils.getExceptionString((Exception)e);
            }
            finally {
                task.terminate();
            }
            if (!successful) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"BOM\u8fdb\u884c\u5206\u5e03\u5f0f\u5c55\u5f00\u8fd0\u7b97\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7%1$s\u3002", (String)"BomBatchForwardSearchReportPlugin_1", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), errorMsg));
            }
            long enddate = System.currentTimeMillis() - startTime;
            logger.info("BomBatchForwardSearchReportPlugin_BatchTask\u5206\u5e03\u5f0f\u8ba1\u7b97\u5b8c\u6bd5,querySize =" + querySize + ",cost:" + enddate + "ms");
            logger.info("BomBatchForwardSearchReportPlugin_BatchTask\u5206\u5e03\u5f0f\u8ba1\u7b97\u5b8c\u6bd5,querySize =" + querySize + ",cost:" + enddate + "ms");
            for (int i = 0; i < querySize; ++i) {
                DynamicObject queryDy = (DynamicObject)queryColl.get(i);
                DynamicObject materialObj = queryDy.getDynamicObject("querymaterial");
                String rowMsgString = String.format(rowMsg, i + 1, materialObj.getString("number"));
                String uuid = (String)uuidMap.get(i);
                JSONObject result = this.getResultJsonObject("bombatchforwardsearch_" + uuid);
                dataSet = this.buildDataSet(result, errorSb, nextDataSetList, queryDy, dataSet, rowMsgString);
            }
        }
        if (dataSet == null) {
            if (errorSb != null && errorSb.length() > 0) {
                param.setMessage(errorSb.toString());
            }
            this.closeNextDatas(nextDataSetList);
            return this.buildNullResult(param, obj);
        }
        if (nextDataSetList != null && !nextDataSetList.isEmpty()) {
            dataSet = this.mergeDataSetField(dataSet, nextDataSetList);
            DataSet[] nextDatas = nextDataSetList.toArray(new DataSet[nextDataSetList.size()]);
            dataSet = dataSet.union(nextDatas);
        }
        this.closeNextDatas(nextDataSetList);
        dataSet = this.dealOrgField(dataSet, org.getLong("id"));
        dataSet = this.renameField(dataSet);
        if (errorSb != null && errorSb.length() > 0) {
            param.setMessage(errorSb.toString());
            logger.error("--------------BomBatchForwardSearchReportPlugin----end-----errorSb :" + errorSb);
        }
        return dataSet;
    }

    @Override
    public Map<String, String> getRenamField() {
        HashMap<String, String> renameFieldMap = new HashMap<String, String>(16);
        renameFieldMap.put("id", "bomid");
        renameFieldMap.put("entry_Id", "bomentryid");
        renameFieldMap.put("createorg", "org");
        return renameFieldMap;
    }

    public DataSet buildNullResult(ReportQueryParam param, Object obj) {
        Algo algo = Algo.create((String)((Object)((Object)this)).getClass().getName());
        RowMeta rowMeta = this.getRowMeta(new BomForwardSearchBusiness("false", BigDecimal.ONE, false));
        DataSetBuilder builder = algo.createDataSetBuilder(rowMeta);
        return builder.build();
    }

    private RowMeta getRowMeta(BomForwardSearchBusiness forwardBusiness) {
        String formNum = "pdm_mftbom";
        UUID uuid = UUID.randomUUID();
        String randomId = uuid.toString().replace("-", "");
        String selectItems = forwardBusiness.getSelectItems("1");
        selectItems = selectItems + ",concat('" + randomId + "',version) randomId,version tmpver";
        RowMeta meta = null;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"BOMForwardSearchReportPlugin", (String)formNum, (String)selectItems, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)-1L)}, null);){
            meta = dataSet.getRowMeta();
        }
        return meta;
    }

    private boolean isBatchCompute() {
        return PdmParamSetHelper.getBooleanParamValue((String)"BomBatchForwardSearch_IsBatchCompute");
    }

    public String getTaskName() {
        return "BomBatchForwardSearch";
    }

    public String getReportEntity(ReportQueryParam queryParam) {
        String showtype = this.getQueryParam().getFilter().getString("showtype");
        return "B".equals(showtype) ? "pdm_bombatch_totalforward" : "pdm_bombatch_forward";
    }
}

