/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.formplugin.superbom;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.mmc.pdm.common.enums.MaterialAttrEnum;
import kd.mmc.pdm.common.enums.SuperBOMEntryTypeEnum;
import kd.mmc.pdm.common.util.ChangeDataUtil;
import kd.mmc.pdm.common.util.MMCUtils;
import kd.mmc.pdm.common.util.UnitUtils;
import kd.mmc.pdm.formplugin.superbom.SuperBOMBaseEdit;

public class SuperBOMEdit
extends SuperBOMBaseEdit
implements BeforeF7SelectListener,
TabSelectListener {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void registerListener(EventObject evt) {
        BasedataEdit entryUnit;
        BasedataEdit entryMaterialBE;
        BasedataEdit copEntryMaterialBE;
        BasedataEdit material;
        super.registerListener(evt);
        if (evt == null) {
            return;
        }
        this.addItemClickListeners(new String[]{"bar_treemaintain"});
        Tab tab = (Tab)this.getControl("tab_entry");
        if (tab != null) {
            tab.addTabSelectListener((TabSelectListener)this);
        }
        if ((material = (BasedataEdit)this.getControl("material")) != null) {
            material.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((copEntryMaterialBE = (BasedataEdit)this.getControl("copentrymaterial")) != null) {
            copEntryMaterialBE.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((entryMaterialBE = (BasedataEdit)this.getControl("entrymaterial")) != null) {
            entryMaterialBE.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((entryUnit = (BasedataEdit)this.getControl("entryunit")) != null) {
            entryUnit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        super.beforeDoOperation(evt);
        if (evt == null) {
            return;
        }
        FormOperate op = (FormOperate)evt.getSource();
        String opKey = op.getOperateKey();
        String errMessage = "";
        int entryRowIndex = this.getEntryRowIndex();
        switch (opKey) {
            case "nextentry": {
                errMessage = this.checkOptQtyMessage(entryRowIndex);
                break;
            }
            case "preventry": {
                errMessage = this.checkOptQtyMessage(entryRowIndex);
                break;
            }
        }
        if (errMessage.length() > 0) {
            this.getView().showTipNotification(errMessage);
            evt.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        List evInfoList;
        super.afterDoOperation(evt);
        if (evt == null) {
            return;
        }
        OperationResult or = evt.getOperationResult();
        List list = evInfoList = or == null ? null : or.getAllErrorOrValidateInfo();
        if (!MMCUtils.isEmptyList((List)evInfoList)) {
            return;
        }
        String opKey = evt.getOperateKey();
        if (MMCUtils.isEmptyString((String)opKey)) {
            return;
        }
        Tab entryTab = (Tab)this.getControl("tab_entry");
        String tabPageKey = entryTab == null ? null : entryTab.getCurrentTab();
        int entryRowIndex = this.getEntryRowIndex();
        if (mTabPage.contains(tabPageKey) && entryRowIndex >= 0) {
            if (opKey.equalsIgnoreCase("nextentry") || opKey.equalsIgnoreCase("preventry")) {
                this.updateChildPage(tabPageKey, true);
            } else {
                this.updateChildPage(tabPageKey, false);
            }
            this.updateTabCtl(tabPageKey);
        }
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        ChangeData[] changeDatas;
        String propertyName;
        if (evt == null) {
            return;
        }
        super.propertyChanged(evt);
        IDataEntityProperty dataEntityProperty = evt.getProperty();
        String string = propertyName = dataEntityProperty == null ? null : dataEntityProperty.getName();
        if (MMCUtils.isEmptyString((String)propertyName)) {
            return;
        }
        for (ChangeData changeSet : changeDatas = evt.getChangeSet()) {
            if (!ChangeDataUtil.isRealChanged((ChangeData)changeSet)) continue;
            this.propertyChanged(propertyName, changeSet);
        }
    }

    protected void propertyChanged(String propertyName, ChangeData changeSet) {
        if (!this.validPropertyChanged(propertyName).booleanValue()) {
            return;
        }
        int entryRowIndex = this.getEntryRowIndex(changeSet);
        if (entryRowIndex < 0) {
            return;
        }
        this.propertyChangedEntry(propertyName, entryRowIndex);
        if (mOptCtls.contains(propertyName) && entryRowIndex > -1) {
            this.changeOptVal(propertyName, entryRowIndex, changeSet);
        }
        this.fieldMustInput(propertyName);
    }

    private void fieldMustInput(String propertyName) {
        IFormView viev = this.getView();
        IDataModel model = viev.getModel();
        if ("material".equals(propertyName)) {
            FieldEdit optioncontrolEdit = (FieldEdit)viev.getControl("optioncontrol");
            DynamicObject matObj = (DynamicObject)model.getValue("material");
            if (matObj == null) {
                return;
            }
            String configproperties = matObj.getString("configproperties");
            if ("3".equals(configproperties)) {
                optioncontrolEdit.setMustInput(true);
                model.setValue("optioncontrol", (Object)Character.valueOf('A'));
            } else {
                model.setValue("optioncontrol", null);
                optioncontrolEdit.setMustInput(false);
            }
        }
    }

    private void propertyChangedEntry(String propertyName, int entryRowIndex) {
        switch (propertyName) {
            case "entrymaterial": {
                this.updateEntryMaterial(entryRowIndex);
                break;
            }
            case "entryqty": {
                this.updateEntryQty(entryRowIndex);
                break;
            }
            case "entrytype": {
                this.updateEntryType(entryRowIndex);
                break;
            }
        }
    }

    private Boolean validPropertyChanged(String propertyName) {
        IFormView fv;
        Boolean validPropertyChanged = Boolean.TRUE;
        if (MMCUtils.isEmptyString((String)propertyName)) {
            validPropertyChanged = Boolean.FALSE;
        }
        if ((fv = this.getView()) == null) {
            validPropertyChanged = Boolean.FALSE;
            return validPropertyChanged;
        }
        IDataModel dm = fv.getModel();
        if (dm == null) {
            validPropertyChanged = Boolean.FALSE;
            return validPropertyChanged;
        }
        IPageCache pc = this.getPageCache();
        if (pc == null) {
            validPropertyChanged = Boolean.FALSE;
        }
        return validPropertyChanged;
    }

    private int getEntryRowIndex(ChangeData propertyValueCD) {
        int entryRowIndex = -1;
        if (StringUtils.isBlank((Object)propertyValueCD)) {
            return entryRowIndex;
        }
        entryRowIndex = propertyValueCD.getRowIndex() < 0 ? this.getEntryRowIndex() : propertyValueCD.getRowIndex();
        return entryRowIndex;
    }

    private void updateEntryType(int entryRowIndex) {
        IFormView fv = this.getView();
        IDataModel dm = fv.getModel();
        String entryType = MMCUtils.getDataModelStringData((IDataModel)dm, (String)"entrytype", (int)entryRowIndex);
        DynamicObject entrymaterial = MMCUtils.getDataModelDynamicObjectData((IDataModel)dm, (String)"entrymaterial", (int)entryRowIndex);
        String materialtype = "";
        if (StringUtils.isNotBlank((Object)entrymaterial)) {
            materialtype = MMCUtils.getDynamicObjectStringData((DynamicObject)entrymaterial, (String)"materialtype");
        }
        if (StringUtils.isNotBlank((CharSequence)materialtype) && StringUtils.equalsIgnoreCase((CharSequence)entryType, (CharSequence)SuperBOMEntryTypeEnum.OPTIONCLASS.getValue()) && !mMaterialType.contains(materialtype)) {
            dm.setValue("entrymaterial", null, entryRowIndex);
        }
    }

    private void updateEntryMaterial(int entryRowIndex) {
        DynamicObject baseunitObj;
        IFormView fv = this.getView();
        IDataModel dm = fv.getModel();
        DynamicObject entrymaterial = MMCUtils.getDataModelDynamicObjectData((IDataModel)dm, (String)"entrymaterial", (int)entryRowIndex);
        Object baseUnit = null;
        if (StringUtils.isNotBlank((Object)entrymaterial) && StringUtils.isNotBlank((Object)(baseunitObj = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)entrymaterial, (String)"baseunit")))) {
            baseUnit = baseunitObj.getPkValue();
        }
        dm.setValue("entryunit", baseUnit, entryRowIndex);
        fv.updateView("entryunit", entryRowIndex);
    }

    private void updateEntryQty(int entryRowIndex) {
        IFormView fv = this.getView();
        IDataModel dm = fv.getModel();
        BigDecimal entryqty = MMCUtils.getDataModelBigDecimalData((IDataModel)dm, (String)"entryqty", (int)entryRowIndex);
        BigDecimal entryqtydenominator = MMCUtils.getDataModelBigDecimalData((IDataModel)dm, (String)"entryqtydenominator", (int)entryRowIndex);
        if (StringUtils.isBlank((Object)entryqtydenominator) || entryqtydenominator.compareTo(BigDecimal.ZERO) <= 0) {
            entryqtydenominator = BigDecimal.ONE;
            dm.setValue("entryqtydenominator", (Object)entryqtydenominator, entryRowIndex);
        }
        if (StringUtils.isNotBlank((Object)entryqty)) {
            DynamicObject unitDy = MMCUtils.getDataModelDynamicObjectData((IDataModel)dm, (String)"entryunit", (int)entryRowIndex);
            int precision = UnitUtils.getPrecision((DynamicObject)unitDy);
            int roundingMode = UnitUtils.getRoundType((DynamicObject)unitDy);
            BigDecimal entryqtynumerator = entryqty.divide(entryqtydenominator).setScale(precision, roundingMode);
            dm.setValue("entryqtynumerator", (Object)entryqtynumerator, entryRowIndex);
        }
    }

    public void tabSelected(TabSelectEvent evt) {
        if (!this.validTabSelected(evt).booleanValue()) {
            return;
        }
        IFormView fv = this.getView();
        IDataModel dm = fv.getModel();
        String tabPageKey = evt.getTabKey();
        int entryRowIndex = this.getEntryRowIndex();
        DynamicObject entryDO = dm.getEntryRowEntity("entry", entryRowIndex);
        fv.setEnable(Boolean.TRUE, new String[]{"material"});
        if (!mTabPage.contains(tabPageKey)) {
            return;
        }
        if (entryRowIndex >= 0) {
            if (tabPageKey.equalsIgnoreCase("tabpage_setupentry") && StringUtils.isNotBlank((Object)entryDO)) {
                String materailattr = MMCUtils.getDynamicObjectStringData((DynamicObject)entryDO, (String)"entrymaterialattr");
                if (MaterialAttrEnum.PHANTOMPART.getValue().equalsIgnoreCase(materailattr)) {
                    fv.showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u7ec4\u4ef6\u7684\u7269\u6599\u5c5e\u6027\u4e3a\u865a\u62df\u4ef6\uff0c\u65e0\u6cd5\u8bbe\u7f6e\u5b89\u88c5\u4f4d\u7f6e\u3002", (String)"SuperBOMEdit_0", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), entryRowIndex + 1));
                    fv.setVisible(Boolean.FALSE, new String[]{"flex_setupentry"});
                    return;
                }
            }
            this.updateChildPage(tabPageKey, true);
        } else {
            fv.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u7ec4\u4ef6\u3002", (String)"SuperBOMEdit_1", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
        }
        this.updateTabCtl(tabPageKey);
    }

    private void updateTabCtl(String tabPageKey) {
        IFormView fv = this.getView();
        List<String> oprVisbleCtl = this.getOprVisibleCtls(tabPageKey);
        if (oprVisbleCtl.size() > 0) {
            fv.setVisible(Boolean.TRUE, oprVisbleCtl.toArray(new String[oprVisbleCtl.size()]));
        }
        List<String> oprHideCtl = this.getOprHideCtls(tabPageKey);
        if (oprVisbleCtl.size() > 0) {
            fv.setVisible(Boolean.FALSE, oprHideCtl.toArray(new String[oprHideCtl.size()]));
        }
    }

    public void afterAddRow(AfterAddRowEventArgs evt) {
        super.afterAddRow(evt);
    }

    public void beforeClosed(BeforeClosedEvent evt) {
        super.beforeClosed(evt);
        IFormView fv = this.getView();
        if (fv == null) {
            return;
        }
        IDataModel dm = fv.getModel();
        if (dm == null) {
            return;
        }
        String billStatus = MMCUtils.getDataModelStringData((IDataModel)dm, (String)"status");
        if (StringUtils.equals((CharSequence)billStatus, (CharSequence)"A")) {
            evt.setCheckDataChange(true);
        } else {
            evt.setCheckDataChange(false);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String srcDEPName;
        if (!this.valideBeforeF7Select(evt).booleanValue()) {
            return;
        }
        QFilter filter = null;
        int rowIndex = evt.getRow();
        IDataEntityProperty srcDEP = evt.getProperty();
        String string = srcDEPName = srcDEP == null ? "" : srcDEP.getName();
        if (StringUtils.isBlank((CharSequence)srcDEPName)) {
            return;
        }
        if ("entrymaterial".equals(srcDEPName)) {
            filter = this.getEntryMaterialFilter(rowIndex);
        }
        if (null != filter) {
            FormShowParameter fsp = evt.getFormShowParameter();
            ListShowParameter lsp = (ListShowParameter)fsp;
            ListFilterParameter lfp = lsp.getListFilterParameter();
            lfp.setFilter(filter);
            lsp.setListFilterParameter(lfp);
            evt.setFormShowParameter((FormShowParameter)lsp);
        }
    }

    protected void updateChildPage(String tabPageKey, boolean isUpdateSubEntry) {
        switch (tabPageKey) {
            case "tabpage_matchctlentry": 
            case "tabpage_chararule": {
                this.updateFlexOptCtl(tabPageKey);
                break;
            }
        }
    }

    private void updateFlexOptCtl(String tabPageKey) {
        if (!this.checkViewNotNull().booleanValue() && StringUtils.isBlank((Object)this.getPageCache())) {
            return;
        }
        IFormView fv = this.getView();
        IDataModel dm = fv.getModel();
        int entryRowIndex = this.getEntryRowIndex();
        DynamicObject entryDO = null;
        if (entryRowIndex >= 0) {
            entryDO = dm.getEntryRowEntity("entry", entryRowIndex);
        }
        String suffix = this.getPageSuffix(tabPageKey);
        if (entryDO == null || StringUtils.isBlank((CharSequence)suffix)) {
            return;
        }
        this.updateFlexOptHeadCtl(dm, entryRowIndex, entryDO, suffix);
        this.updateOptCtl(tabPageKey, entryDO, suffix, entryRowIndex);
    }

    private void updateFlexOptHeadCtl(IDataModel dm, int entryRowIndex, DynamicObject entryDO, String suffix) {
        dm.beginInit();
        DynamicObject entryMFTInfoDO = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)entryDO, (String)"entrymaterial");
        Object entryMFTInfoPKObj = entryMFTInfoDO == null ? null : entryMFTInfoDO.getPkValue();
        Long entryMFTInfoPK = entryMFTInfoPKObj == null ? Long.valueOf(0L) : Long.valueOf(Long.parseLong(entryMFTInfoPKObj.toString()));
        dm.setValue("entryseq" + suffix, (Object)(entryRowIndex + 1));
        dm.setValue("entrymaterial" + suffix, (Object)(entryMFTInfoPK <= 0L ? null : entryMFTInfoPK));
        DynamicObject entryMFTUnitDO = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)entryDO, (String)"entryunit");
        Object entryMFTUnitPKObj = entryMFTUnitDO == null ? null : entryMFTUnitDO.getPkValue();
        Long entryMFTUnitPK = entryMFTUnitPKObj == null ? Long.valueOf(0L) : Long.valueOf(Long.parseLong(entryMFTUnitPKObj.toString()));
        dm.setValue("entryunit" + suffix, (Object)(entryMFTUnitPK <= 0L ? null : entryMFTUnitPK));
        dm.endInit();
    }

    private void updateOptCtl(String tabPageKey, DynamicObject entryDO, String suffix, int entryRowIndex) {
        DynamicObject entryMatoBJ;
        IFormView fv = this.getView();
        IDataModel dm = fv.getModel();
        Object entrytype = MMCUtils.getDynamicObjectData((DynamicObject)entryDO, (String)"entrytype");
        if (StringUtils.isNotBlank((Object)entrytype) && StringUtils.equalsIgnoreCase((CharSequence)String.valueOf(entrytype), (CharSequence)"B")) {
            fv.setEnable(Boolean.TRUE, new String[]{"mutuexcopt_optctl"});
        } else {
            fv.setEnable(Boolean.FALSE, new String[]{"mutuexcopt_optctl"});
        }
        for (String tabHeadField : mTabHeadFields) {
            fv.updateView(tabHeadField + suffix);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)tabPageKey, (CharSequence)"tabpage_matchctlentry")) {
            dm.beginInit();
            for (String optCtl : mOptCtls) {
                String optKey = optCtl.replace(suffix, "");
                Object srcObj = entryDO.get(optKey);
                dm.setValue(optCtl, srcObj);
            }
            dm.endInit();
            dm.updateCache();
            for (String optCtl : mOptCtls) {
                fv.updateView(optCtl);
            }
        }
        if ((entryMatoBJ = (DynamicObject)dm.getValue("entrymaterial", entryRowIndex)) == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u7ec4\u4ef6\u7f16\u7801\u3002", (String)"SuperBOMEdit_2", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            return;
        }
        String configProperties = entryMatoBJ.getString("configproperties");
        if ("2".equals(configProperties) || "3".equals(configProperties)) {
            dm.setValue("opt_optctl", (Object)Boolean.FALSE);
            fv.setEnable(Boolean.FALSE, new String[]{"opt_optctl"});
        } else {
            fv.setEnable(Boolean.TRUE, new String[]{"opt_optctl"});
        }
        this.manualCtlPropertyChanged("opt_optctl", entryRowIndex);
        this.manualCtlPropertyChanged("qtyopt_optctl", entryRowIndex);
    }

    private void manualCtlPropertyChanged(String ctlKey, int entryRowIndex) {
        IDataModel md = this.getModel();
        Object optctl = MMCUtils.getDataModelData((IDataModel)md, (String)ctlKey);
        ChangeData qtyoptOptctlChange = new ChangeData(entryRowIndex, md.getDataEntity(), optctl, optctl);
        this.propertyChanged(ctlKey, qtyoptOptctlChange);
    }

    private QFilter getEntryMaterialFilter(int rowIndex) {
        QFilter qfilter = null;
        if (rowIndex < 0) {
            return qfilter;
        }
        IDataModel dm = this.getModel();
        DynamicObject material = MMCUtils.getDataModelDynamicObjectData((IDataModel)dm, (String)"material");
        if (material == null) {
            return qfilter;
        }
        String configProperties = material.getString("configproperties");
        if ("3".equals(configProperties)) {
            ArrayList<String> list = new ArrayList<String>(10);
            list.add("3");
            list.add("2");
            qfilter = new QFilter("configproperties", "not in", list);
        }
        return qfilter;
    }

    private void changeOptVal(String propertyName, int entryRowIndex, ChangeData changeSet) {
        String valideMessage = "";
        IFormView fv = this.getView();
        IDataModel dm = fv.getModel();
        switch (propertyName) {
            case "opt_optctl": {
                this.updateOptCtl(changeSet);
                break;
            }
            case "maxqtyopt_optctl": {
                valideMessage = this.checkOptQtyMessage(entryRowIndex);
                break;
            }
            case "qtyopt_optctl": {
                this.updateQtyOpt(entryRowIndex, changeSet);
                break;
            }
            case "preferopt_optctl": {
                this.updateFirstChoose(entryRowIndex, changeSet);
                break;
            }
        }
        if (valideMessage.length() > 0) {
            fv.showTipNotification(valideMessage);
        } else {
            String optPropName = propertyName.replace("_optctl", "");
            dm.setValue(optPropName, ChangeDataUtil.getNewValue((ChangeData)changeSet), entryRowIndex);
        }
    }

    public void updateFirstChoose(int entryRowIndex, ChangeData changeSet) {
        IFormView fv = this.getView();
        IDataModel dm = fv.getModel();
        boolean firstChoose = (Boolean)changeSet.getNewValue();
        if (!firstChoose) {
            return;
        }
        DynamicObjectCollection supBomEntryCol = dm.getEntryEntity("entry");
        for (DynamicObject supBomEntry : supBomEntryCol) {
            supBomEntry.set("preferopt", (Object)false);
        }
        DynamicObject entryObj = (DynamicObject)supBomEntryCol.get(entryRowIndex);
        entryObj.set("preferopt", (Object)true);
    }

    private void updateOptCtl(ChangeData changeSet) {
        IFormView fv = this.getView();
        IDataModel dm = fv.getModel();
        Object propValueObj = ChangeDataUtil.getNewValue((ChangeData)changeSet);
        if (StringUtils.isNotBlank((Object)propValueObj) && ((Boolean)propValueObj).booleanValue()) {
            fv.setEnable(Boolean.TRUE, new String[]{"preferopt_optctl"});
        } else {
            fv.setEnable(Boolean.FALSE, new String[]{"preferopt_optctl"});
            dm.setValue("preferopt_optctl", (Object)Boolean.FALSE);
        }
    }

    private void updateQtyOpt(int entryRowIndex, ChangeData changeSet) {
        IFormView fv = this.getView();
        IDataModel dm = fv.getModel();
        Object propValueObj = ChangeDataUtil.getNewValue((ChangeData)changeSet);
        if (StringUtils.isNotBlank((Object)propValueObj) && ((Boolean)propValueObj).booleanValue()) {
            fv.setEnable(Boolean.TRUE, new String[]{"minqtyopt_optctl"});
            fv.setEnable(Boolean.TRUE, new String[]{"maxqtyopt_optctl"});
        } else {
            fv.setEnable(Boolean.FALSE, new String[]{"minqtyopt_optctl"});
            fv.setEnable(Boolean.FALSE, new String[]{"maxqtyopt_optctl"});
        }
        if (!((Boolean)propValueObj).booleanValue()) {
            dm.setValue("minqtyopt_optctl", (Object)BigDecimal.ZERO);
            dm.setValue("maxqtyopt_optctl", (Object)BigDecimal.ZERO);
            fv.updateView("minqtyopt_optctl");
            fv.updateView("maxqtyopt_optctl");
        } else {
            BigDecimal maxQtyOpt = MMCUtils.getDataModelBigDecimalData((IDataModel)dm, (String)"maxqtyopt_optctl");
            BigDecimal minQtyOpt = MMCUtils.getDataModelBigDecimalData((IDataModel)dm, (String)"minqtyopt_optctl");
            BigDecimal entryqty = MMCUtils.getDataModelBigDecimalData((IDataModel)dm, (String)"entryqty", (int)entryRowIndex);
            if (maxQtyOpt.compareTo(BigDecimal.ZERO) == 0 && minQtyOpt.compareTo(BigDecimal.ZERO) == 0) {
                dm.setValue("minqtyopt_optctl", (Object)entryqty);
                dm.setValue("maxqtyopt_optctl", (Object)entryqty);
            }
        }
    }

    private String checkOptQtyMessage(int entryRowIndex) {
        String errMessage = "";
        IFormView fv = this.getView();
        IDataModel dm = fv.getModel();
        BigDecimal maxQtyOpt = MMCUtils.getDataModelBigDecimalData((IDataModel)dm, (String)"maxqtyopt_optctl");
        BigDecimal minQtyOpt = MMCUtils.getDataModelBigDecimalData((IDataModel)dm, (String)"minqtyopt_optctl");
        if (minQtyOpt.compareTo(maxQtyOpt) > 0) {
            errMessage = String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u7b2c%s\u884c,\u9009\u914d\u63a7\u5236\u201c\u6700\u5c0f\u6570\u91cf\u201d\u5927\u4e8e\u201c\u6700\u5927\u6570\u91cf\u201d\u3002", (String)"SuperBOMEdit_3", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), entryRowIndex + 1);
        }
        return errMessage;
    }
}

