/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.business.ecoplatform;

import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.pdm.business.ecoplatform.ActTimeCopBean;
import kd.mmc.pdm.business.ecoplatform.EcoCopUtils;
import kd.mmc.pdm.common.bom.ecoplatform.PlatformUtils;

public class ActTimeCopValidataBusiness {
    private static ActTimeCopValidataBusiness business;

    public static ActTimeCopValidataBusiness getInstance() {
        if (business == null) {
            business = new ActTimeCopValidataBusiness();
        }
        return business;
    }

    public String checkValidData(Date actTime, DynamicObject ecoBomCopEntry, String ecoBillNumber, Long ecoBillId, String billStatus) {
        if (ecoBomCopEntry == null || actTime == null) {
            return "";
        }
        Long materialId = ecoBomCopEntry.getDynamicObject("copentrymaterialid").getLong("id");
        ActTimeCopBean bean = new ActTimeCopBean(actTime, ecoBomCopEntry.getDate("copentryvaliddate"), ecoBomCopEntry.getDate("copentryinvaliddate"), ecoBomCopEntry.getLong("oldcopentryid"), ecoBomCopEntry.getLong("newcopentryid"), ecoBillId, ecoBillNumber, ecoBomCopEntry.getString("copentrymode"), billStatus, materialId);
        return this.checkValidData(bean);
    }

    public String checkValidData(ActTimeCopBean bean) {
        String entrymode = bean.getEntryMode();
        if ("C".equals(entrymode)) {
            return "";
        }
        HashSet<Long> copEntryIdset = new HashSet<Long>(16);
        Long copAfterEntryId = 0L;
        if ("B".equals(bean.getEntryMode()) && !PlatformUtils.isNullLong((Long)(copAfterEntryId = bean.getCopEntryAfterId()))) {
            copEntryIdset.add(copAfterEntryId);
        }
        Long copEntryId = bean.getCopEntryId();
        copEntryIdset.add(copEntryId);
        StringBuilder message = new StringBuilder();
        Date actTime = bean.getActtime();
        String ecoBillNumber = bean.getEcoBillNumber();
        Long ecoBillId = bean.getEcoBillId();
        Long materialId = bean.getMaterialId();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if ("C".equalsIgnoreCase(bean.getBillStatus())) {
            Date bomentryInValiddate;
            Map<String, Object> entryBom;
            Map<Long, Map<String, Object>> bomMap = this.getBomCopEntryData(copEntryIdset);
            if ("B".equals(entrymode)) {
                Date bomentryValiddate;
                Map<String, Object> entryBomBefore;
                Date bomentryInvaliddate;
                Map<String, Object> entryBomAfter = bomMap.get(copAfterEntryId);
                if (entryBomAfter != null && entryBomAfter.get("entryinvaliddate") != null && actTime.compareTo(bomentryInvaliddate = (Date)entryBomAfter.get("entryinvaliddate")) > 0) {
                    String materialNumber = this.getMaterialNumber(materialId);
                    message.append(String.format(ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u5355[%1$s]\u4e0b\u8054\u526f\u4ea7\u54c1\u7f16\u7801[%2$s]\u7684\u5b9e\u65bd\u65f6\u95f4[%3$s]\u4e0d\u80fd\u5927\u4e8eBOM\u8054\u526f\u4ea7\u54c1\u5206\u5f55\u884c\u7684\u5931\u6548\u65f6\u95f4[%4$s]\u3002", (String)"ActTimeCopValidataBusiness_01", (String)"mmc-pdm-business", (Object[])new Object[0]), ecoBillNumber, materialNumber, sdf.format(actTime), sdf.format(bomentryInvaliddate)));
                }
                if ((entryBomBefore = bomMap.get(copEntryId)) != null && entryBomBefore.get("entryvaliddate") != null && actTime.compareTo(bomentryValiddate = (Date)entryBomBefore.get("entryvaliddate")) <= 0) {
                    String materialNumber = this.getMaterialNumber(materialId);
                    message.append(String.format(ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u5355[%1$s]\u4e0b\u8054\u526f\u4ea7\u54c1\u7f16\u7801[%2$s]\u7684\u5b9e\u65bd\u65f6\u95f4[%3$s]\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8eBOM\u8054\u526f\u4ea7\u54c1\u5206\u5f55\u884c\u7684\u751f\u6548\u65f6\u95f4[%4$s]\u3002", (String)"ActTimeCopValidataBusiness_02", (String)"mmc-pdm-business", (Object[])new Object[0]), ecoBillNumber, materialNumber, sdf.format(actTime), sdf.format(bomentryValiddate)));
                }
            } else if ("E".equals(entrymode)) {
                String otherEcnBillNo;
                Map<String, Object> entryBom2 = bomMap.get(copEntryId);
                if (entryBom2 == null) {
                    String materialNumber = this.getMaterialNumber(materialId);
                    message.append(String.format(ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u5355[%1$s]\u4e0b\u8054\u526f\u4ea7\u54c1\u7f16\u7801[%2$s]\u5bf9\u5e94\u7684BOM\u5206\u5f55\u7684ID[%3$s]\u5728BOM\u8054\u526f\u4ea7\u54c1\u5206\u5f55\u4e2d\u5df2\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"ActTimeCopValidataBusiness_05", (String)"mmc-pdm-business", (Object[])new Object[0]), ecoBillNumber, materialNumber, copEntryId));
                    return message.toString();
                }
                Date bomentryValiddate = (Date)entryBom2.get("entryvaliddate");
                if (actTime.compareTo(bomentryValiddate) <= 0) {
                    String materialNumber = this.getMaterialNumber(materialId);
                    message.append(String.format(ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u5355[%1$s]\u4e0b\u8054\u526f\u4ea7\u54c1\u7f16\u7801[%2$s]\u7684\u5b9e\u65bd\u65f6\u95f4[%3$s]\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8eBOM\u8054\u526f\u4ea7\u54c1\u5206\u5f55\u884c\u7684\u751f\u6548\u65f6\u95f4[%4$s]\u3002", (String)"ActTimeCopValidataBusiness_02", (String)"mmc-pdm-business", (Object[])new Object[0]), ecoBillNumber, materialNumber, sdf.format(actTime), sdf.format(bomentryValiddate)));
                }
                if ((otherEcnBillNo = EcoCopUtils.getAduitEcnBill(copEntryIdset, ecoBillId, "B")) != null && !"".equals(otherEcnBillNo)) {
                    Date bomentryInValiddate2;
                    if (entryBom2 != null && entryBom2.get("entryinvaliddate") != null && actTime.compareTo(bomentryInValiddate2 = (Date)entryBom2.get("entryinvaliddate")) > 0) {
                        String materialNumber = this.getMaterialNumber(materialId);
                        message.append(String.format(ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u5355[%1$s]\u4e0b\u8054\u526f\u4ea7\u54c1\u7f16\u7801[%2$s]\u7684\u5b9e\u65bd\u65f6\u95f4[%3$s]\u4e0d\u80fd\u5927\u4e8eBOM\u8054\u526f\u4ea7\u54c1\u5206\u5f55\u884c\u7684\u5931\u6548\u65f6\u95f4[%4$s]\u3002", (String)"ActTimeCopValidataBusiness_01", (String)"mmc-pdm-business", (Object[])new Object[0]), ecoBillNumber, materialNumber, sdf.format(actTime), sdf.format(bomentryInValiddate2)));
                    }
                } else {
                    Date entryInValidDate = bean.getEcnInValiddate();
                    if (actTime.compareTo(entryInValidDate) > 0) {
                        String materialNumber = this.getMaterialNumber(materialId);
                        message.append(String.format(ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u5355[%1$s]\u4e0b\u8054\u526f\u4ea7\u54c1\u7f16\u7801[%2$s]\u7684\u5b9e\u65bd\u65f6\u95f4[%3$s]\u4e0d\u80fd\u5927\u4e8eBOM\u8054\u526f\u4ea7\u54c1\u5206\u5f55\u884c\u4fee\u6539\u524d\u5931\u6548\u65f6\u95f4[%4$s]\u3002", (String)"ActTimeCopValidataBusiness_03", (String)"mmc-pdm-business", (Object[])new Object[0]), ecoBillNumber, materialNumber, sdf.format(actTime), sdf.format(entryInValidDate)));
                    }
                }
            } else if ("A".equals(entrymode) && (entryBom = bomMap.get(copEntryId)) != null && entryBom.get("entryinvaliddate") != null && actTime.compareTo(PlatformUtils.addSecond((Date)(bomentryInValiddate = (Date)entryBom.get("entryinvaliddate")), (int)1)) > 0) {
                String materialNumber = this.getMaterialNumber(materialId);
                message.append(String.format(ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u5355[%1$s]\u4e0b\u8054\u526f\u4ea7\u54c1\u7f16\u7801[%2$s]\u7684\u5b9e\u65bd\u65f6\u95f4[%3$s]\u4e0d\u80fd\u5927\u4e8eBOM\u8054\u526f\u4ea7\u54c1\u5206\u5f55\u884c\u7684\u5931\u6548\u65f6\u95f4[%4$s]\u3002", (String)"ActTimeCopValidataBusiness_01", (String)"mmc-pdm-business", (Object[])new Object[0]), ecoBillNumber, materialNumber, sdf.format(actTime), sdf.format(bomentryInValiddate)));
            }
        } else {
            Date entryValidDate;
            Date entryInValidDate = bean.getEcnInValiddate();
            if (entryInValidDate != null && actTime.compareTo(entryInValidDate) > 0) {
                String materialNumber = this.getMaterialNumber(materialId);
                message.append(String.format(ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u5355[%1$s]\u4e0b\u8054\u526f\u4ea7\u54c1\u7f16\u7801[%2$s]\u7684\u5b9e\u65bd\u65f6\u95f4[%3$s]\u4e0d\u80fd\u5927\u4e8eBOM\u8054\u526f\u4ea7\u54c1\u5206\u5f55\u884c\u4fee\u6539\u524d\u5931\u6548\u65f6\u95f4[%4$s]\u3002", (String)"ActTimeCopValidataBusiness_03", (String)"mmc-pdm-business", (Object[])new Object[0]), ecoBillNumber, materialNumber, sdf.format(actTime), sdf.format(entryInValidDate)));
            }
            if ("B".equals(entrymode) && (entryValidDate = bean.getEcnValiddate()) != null && actTime.compareTo(entryValidDate) < 0) {
                String materialNumber = this.getMaterialNumber(materialId);
                message.append(String.format(ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u5355[%1$s]\u4e0b\u8054\u526f\u4ea7\u54c1\u7f16\u7801[%2$s]\u7684\u5b9e\u65bd\u65f6\u95f4[%3$s]\u4e0d\u80fd\u5c0f\u4e8eBOM\u8054\u526f\u4ea7\u54c1\u5206\u5f55\u884c\u4fee\u6539\u524d\u751f\u6548\u65f6\u95f4[%4$s]\u3002", (String)"ActTimeCopValidataBusiness_04", (String)"mmc-pdm-business", (Object[])new Object[0]), ecoBillNumber, materialNumber, sdf.format(actTime), sdf.format(entryValidDate)));
            }
        }
        return message.toString();
    }

    private String getMaterialNumber(Long materialId) {
        if (materialId != null && !materialId.equals(0L)) {
            DynamicObject material = BusinessDataServiceHelper.loadSingleFromCache((Object)materialId, (String)"bd_material", (String)"number");
            return material.getString("number");
        }
        return "";
    }

    private Map<Long, Map<String, Object>> getBomCopEntryData(Set<Long> copEntryIdSet) {
        if (copEntryIdSet.isEmpty()) {
            return Collections.emptyMap();
        }
        String algoKey = ActTimeCopValidataBusiness.class.getName() + "_getBomCopEntryData";
        HashMap<Long, Map<String, Object>> dataMap = new HashMap<Long, Map<String, Object>>(copEntryIdSet.size());
        QFilter filter = new QFilter("copentry.id", "in", copEntryIdSet);
        QFilter[] qFilters = new QFilter[]{filter};
        String selectProperties = "copentry.id as entryid,copentry.copentryvaliddate entryvaliddate ,copentry.copentryinvaliddate entryinvaliddate ";
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)algoKey, (String)"pdm_mftbom", (String)selectProperties, (QFilter[])qFilters, (String)"id");){
            while (ds.hasNext()) {
                Row arow = ds.next();
                Long entryId = arow.getLong("entryid");
                HashMap<String, Date> bomMap = new HashMap<String, Date>(16);
                bomMap.put("entryvaliddate", arow.getDate("entryvaliddate"));
                bomMap.put("entryinvaliddate", arow.getDate("entryinvaliddate"));
                dataMap.put(entryId, bomMap);
            }
        }
        return dataMap;
    }
}

