/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.business.ecoplatform;

import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.pdm.business.ecoplatform.ActTimeRouteBean;
import kd.mmc.pdm.business.ecoplatform.EcoRouteUtils;
import kd.mmc.pdm.common.bom.ecoplatform.PlatformUtils;

public class ActTimeRouteValidataBusiness {
    private static ActTimeRouteValidataBusiness business;

    public static ActTimeRouteValidataBusiness getInstance() {
        if (business == null) {
            business = new ActTimeRouteValidataBusiness();
        }
        return business;
    }

    public String checkValidData(Date actTime, DynamicObject ecoRouteEntry, String ecoBillNumber, Long ecoBillId, String billStatus) {
        if (ecoRouteEntry == null || actTime == null) {
            return "";
        }
        ActTimeRouteBean bean = new ActTimeRouteBean(actTime, ecoRouteEntry.getDate("entryvaliddate"), ecoRouteEntry.getDate("entryinvaliddate"), ecoRouteEntry.getLong("oldprocessentryid"), ecoRouteEntry.getLong("newprocessentryid"), ecoBillId, ecoBillNumber, ecoRouteEntry.getString("entrymode"), billStatus, ecoRouteEntry.getString("operationno"), ecoRouteEntry.getString("parent"));
        return this.checkValidData(bean);
    }

    public String checkValidData(ActTimeRouteBean bean) {
        String entrymode = bean.getEntryMode();
        if ("C".equals(entrymode)) {
            return "";
        }
        HashSet<Long> routeEntryIdset = new HashSet<Long>(16);
        Long routeAfterEntryId = 0L;
        if ("B".equals(bean.getEntryMode()) && !PlatformUtils.isNullLong((Long)(routeAfterEntryId = bean.getRouteEntryAfterId()))) {
            routeEntryIdset.add(routeAfterEntryId);
        }
        Long routeEntryId = bean.getRouteEntryId();
        routeEntryIdset.add(routeEntryId);
        StringBuilder message = new StringBuilder();
        Date actTime = bean.getActtime();
        String ecoBillNumber = bean.getEcoBillNumber();
        Long ecoBillId = bean.getEcoBillId();
        String opParent = bean.getOpParent();
        String operationNo = bean.getOperationNo();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if ("C".equalsIgnoreCase(bean.getBillStatus())) {
            Date routeEntryInValiddate;
            Map<String, Object> entryRoute;
            Map<Long, Map<String, Object>> routeMap = this.getRouteEntryData(routeEntryIdset);
            if ("B".equals(entrymode)) {
                Date routeEntryValiddate;
                Map<String, Object> entryRouteBefore;
                Date routeentryInvaliddate;
                Map<String, Object> entryRouteAfter = routeMap.get(routeAfterEntryId);
                if (entryRouteAfter != null && entryRouteAfter.get("entryinvaliddate") != null && actTime.compareTo(routeentryInvaliddate = (Date)entryRouteAfter.get("entryinvaliddate")) > 0) {
                    message.append(String.format(ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u5355\u201c%1$s\u201d\u4e0b\u5de5\u5e8f\u4fe1\u606f\u5206\u5f55\u7684\u5de5\u5e8f\u5e8f\u5217\u201c%2$s\u201d\u3001\u5de5\u5e8f\u53f7\u201c%3$s\u201d\u7684\u5b9e\u65bd\u65f6\u95f4\u201c%4$s\u201d\u4e0d\u80fd\u5927\u4e8e\u5de5\u827a\u8def\u7ebf\u5de5\u5e8f\u5206\u5f55\u884c\u7684\u5931\u6548\u65f6\u95f4\u201c%5$s\u201d\u3002", (String)"ActTimeRouteValidataBusiness_1", (String)"mmc-pdm-business", (Object[])new Object[0]), ecoBillNumber, opParent, operationNo, sdf.format(actTime), sdf.format(routeentryInvaliddate)));
                }
                if ((entryRouteBefore = routeMap.get(routeEntryId)) != null && entryRouteBefore.get("entryvaliddate") != null && actTime.compareTo(routeEntryValiddate = (Date)entryRouteBefore.get("entryvaliddate")) <= 0) {
                    message.append(String.format(ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u5355\u201c%1$s\u201d\u4e0b\u5de5\u5e8f\u4fe1\u606f\u5206\u5f55\u7684\u5de5\u5e8f\u5e8f\u5217\u201c%2$s\u201d\u3001\u5de5\u5e8f\u53f7\u201c%3$s\u201d\u7684\u5b9e\u65bd\u65f6\u95f4\u201c%4$s\u201d\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e\u5de5\u827a\u8def\u7ebf\u5de5\u5e8f\u5206\u5f55\u884c\u7684\u751f\u6548\u65f6\u95f4\u201c%5$s\u201d\u3002", (String)"ActTimeRouteValidataBusiness_2", (String)"mmc-pdm-business", (Object[])new Object[0]), ecoBillNumber, opParent, operationNo, sdf.format(actTime), sdf.format(routeEntryValiddate)));
                }
            } else if ("E".equals(entrymode)) {
                String otherEcnBillNo;
                Map<String, Object> entryRoute2 = routeMap.get(routeEntryId);
                if (entryRoute2 == null) {
                    message.append(String.format(ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u5355\u201c%1$s\u201d\u4e0b\u5de5\u5e8f\u4fe1\u606f\u5206\u5f55\u7684\u5de5\u5e8f\u5e8f\u5217\u201c%2$s\u201d\u3001\u5de5\u5e8f\u53f7\u201c%3$s\u201d\u5bf9\u5e94\u7684\u5de5\u827a\u8def\u7ebf\u5de5\u5e8f\u5206\u5f55\u7684ID\u201c%4$s\u201d\u5728\u5de5\u827a\u8def\u7ebf\u4e2d\u5df2\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5\u3002", (String)"ActTimeRouteValidataBusiness_3", (String)"mmc-pdm-business", (Object[])new Object[0]), ecoBillNumber, opParent, operationNo, routeEntryId));
                    return message.toString();
                }
                Date routeEntryValiddate = (Date)entryRoute2.get("entryvaliddate");
                if (actTime.compareTo(routeEntryValiddate) <= 0) {
                    message.append(String.format(ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u5355\u201c%1$s\u201d\u4e0b\u5de5\u5e8f\u4fe1\u606f\u5206\u5f55\u7684\u5de5\u5e8f\u5e8f\u5217\u201c%2$s\u201d\u3001\u5de5\u5e8f\u53f7\u201c%3$s\u201d\u7684\u5b9e\u65bd\u65f6\u95f4\u201c%4$s\u201d\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e\u5de5\u827a\u8def\u7ebf\u5de5\u5e8f\u5206\u5f55\u884c\u7684\u751f\u6548\u65f6\u95f4\u201c%5$s\u201d\u3002", (String)"ActTimeRouteValidataBusiness_2", (String)"mmc-pdm-business", (Object[])new Object[0]), ecoBillNumber, opParent, operationNo, sdf.format(actTime), sdf.format(routeEntryValiddate)));
                }
                if ((otherEcnBillNo = EcoRouteUtils.getAduitEcnBill(routeEntryIdset, ecoBillId, "B")) != null && !"".equals(otherEcnBillNo)) {
                    Date routeEntryInValiddate2;
                    if (entryRoute2 != null && entryRoute2.get("entryinvaliddate") != null && actTime.compareTo(routeEntryInValiddate2 = (Date)entryRoute2.get("entryinvaliddate")) > 0) {
                        message.append(String.format(ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u5355\u201c%1$s\u201d\u4e0b\u5de5\u5e8f\u4fe1\u606f\u5206\u5f55\u7684\u5de5\u5e8f\u5e8f\u5217\u201c%2$s\u201d\u3001\u5de5\u5e8f\u53f7\u201c%3$s\u201d\u7684\u5b9e\u65bd\u65f6\u95f4\u201c%4$s\u201d\u4e0d\u80fd\u5927\u4e8e\u5de5\u827a\u8def\u7ebf\u5de5\u5e8f\u5206\u5f55\u884c\u7684\u5931\u6548\u65f6\u95f4\u201c%5$s\u201d\u3002", (String)"ActTimeRouteValidataBusiness_1", (String)"mmc-pdm-business", (Object[])new Object[0]), ecoBillNumber, opParent, operationNo, sdf.format(actTime), sdf.format(routeEntryInValiddate2)));
                    }
                } else {
                    Date entryInValidDate = bean.getEcnInValiddate();
                    if (actTime.compareTo(entryInValidDate) > 0) {
                        message.append(String.format(ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u5355\u201c%1$s\u201d\u4e0b\u5de5\u5e8f\u4fe1\u606f\u5206\u5f55\u7684\u5de5\u5e8f\u5e8f\u5217\u201c%2$s\u201d\u3001\u5de5\u5e8f\u53f7\u201c%3$s\u201d\u7684\u5b9e\u65bd\u65f6\u95f4\u201c%4$s\u201d\u4e0d\u80fd\u5927\u4e8e\u5de5\u827a\u8def\u7ebf\u5de5\u5e8f\u5206\u5f55\u884c\u4fee\u6539\u524d\u5931\u6548\u65f6\u95f4\u201c%5$s\u201d\u3002", (String)"ActTimeRouteValidataBusiness_4", (String)"mmc-pdm-business", (Object[])new Object[0]), ecoBillNumber, opParent, operationNo, sdf.format(actTime), sdf.format(entryInValidDate)));
                    }
                }
            } else if ("A".equals(entrymode) && (entryRoute = routeMap.get(routeEntryId)) != null && entryRoute.get("entryinvaliddate") != null && actTime.compareTo(PlatformUtils.addSecond((Date)(routeEntryInValiddate = (Date)entryRoute.get("entryinvaliddate")), (int)1)) > 0) {
                message.append(String.format(ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u5355\u201c%1$s\u201d\u4e0b\u5de5\u5e8f\u4fe1\u606f\u5206\u5f55\u7684\u5de5\u5e8f\u5e8f\u5217\u201c%2$s\u201d\u3001\u5de5\u5e8f\u53f7\u201c%3$s\u201d\u7684\u5b9e\u65bd\u65f6\u95f4\u201c%4$s\u201d\u4e0d\u80fd\u5927\u4e8e\u5de5\u827a\u8def\u7ebf\u5de5\u5e8f\u5206\u5f55\u884c\u7684\u5931\u6548\u65f6\u95f4\u201c%5$s\u201d\u3002", (String)"ActTimeRouteValidataBusiness_1", (String)"mmc-pdm-business", (Object[])new Object[0]), ecoBillNumber, opParent, operationNo, sdf.format(actTime), sdf.format(routeEntryInValiddate)));
            }
        } else {
            Date entryValidDate;
            Date entryInValidDate = bean.getEcnInValiddate();
            if (entryInValidDate != null && actTime.compareTo(entryInValidDate) > 0) {
                message.append(String.format(ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u5355\u201c%1$s\u201d\u4e0b\u5de5\u5e8f\u4fe1\u606f\u5206\u5f55\u7684\u5de5\u5e8f\u5e8f\u5217\u201c%2$s\u201d\u3001\u5de5\u5e8f\u53f7\u201c%3$s\u201d\u7684\u5b9e\u65bd\u65f6\u95f4\u201c%4$s\u201d\u4e0d\u80fd\u5927\u4e8e\u5de5\u827a\u8def\u7ebf\u5de5\u5e8f\u5206\u5f55\u884c\u4fee\u6539\u524d\u5931\u6548\u65f6\u95f4\u201c%5$s\u201d\u3002", (String)"ActTimeRouteValidataBusiness_4", (String)"mmc-pdm-business", (Object[])new Object[0]), ecoBillNumber, opParent, operationNo, sdf.format(actTime), sdf.format(entryInValidDate)));
            }
            if ("B".equals(entrymode) && (entryValidDate = bean.getEcnValiddate()) != null && actTime.compareTo(entryValidDate) < 0) {
                message.append(String.format(ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u5355\u201c%1$s\u201d\u4e0b\u5de5\u5e8f\u4fe1\u606f\u5206\u5f55\u7684\u5de5\u5e8f\u5e8f\u5217\u201c%2$s\u201d\u3001\u5de5\u5e8f\u53f7\u201c%3$s\u201d\u7684\u5b9e\u65bd\u65f6\u95f4\u201c%4$s\u201d\u4e0d\u80fd\u5c0f\u4e8e\u5de5\u827a\u8def\u7ebf\u5de5\u5e8f\u5206\u5f55\u884c\u4fee\u6539\u524d\u751f\u6548\u65f6\u95f4\u201c%5$s\u201d\u3002", (String)"ActTimeRouteValidataBusiness_5", (String)"mmc-pdm-business", (Object[])new Object[0]), ecoBillNumber, opParent, operationNo, sdf.format(actTime), sdf.format(entryValidDate)));
            }
        }
        return message.toString();
    }

    private Map<Long, Map<String, Object>> getRouteEntryData(Set<Long> routeEntryIdSet) {
        if (routeEntryIdSet.isEmpty()) {
            return Collections.emptyMap();
        }
        String algoKey = ActTimeRouteValidataBusiness.class.getName() + "getRouteEntryData";
        HashMap<Long, Map<String, Object>> dataMap = new HashMap<Long, Map<String, Object>>(routeEntryIdSet.size());
        QFilter filter = new QFilter("processentry.id", "in", routeEntryIdSet);
        QFilter[] qFilters = new QFilter[]{filter};
        String selectProperties = "processentry.id as entryid,processentry.entryvaliddate entryvaliddate ,processentry.entryinvaliddate entryinvaliddate";
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)algoKey, (String)"pdm_route", (String)selectProperties, (QFilter[])qFilters, (String)"id");){
            while (ds.hasNext()) {
                Row arow = ds.next();
                Long entryId = arow.getLong("entryid");
                HashMap<String, Date> routeMap = new HashMap<String, Date>(16);
                routeMap.put("entryvaliddate", arow.getDate("entryvaliddate"));
                routeMap.put("entryinvaliddate", arow.getDate("entryinvaliddate"));
                dataMap.put(entryId, routeMap);
            }
        }
        return dataMap;
    }
}

