/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.business.ecoplatform;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.common.route.ProcessRouteComparatorImpl;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.mmc.fmm.business.route.RouteSyncCostUtils;
import kd.mmc.pdm.business.ecoplatform.EcoRouteUtils;
import kd.mmc.pdm.business.ecoplatform.ext.ECNUpdateRouteExtPlugin;
import kd.mmc.pdm.business.ecoplatform.ext.IECNUpdateRouteExt;
import kd.mmc.pdm.business.ecoplatform.service.AbstractECNUpdateService;
import kd.mmc.pdm.common.bom.ecoplatform.PlatformUtils;
import kd.mmc.pdm.common.bom.ecoroute.EcoCommonHelper;
import kd.mmc.pdm.common.util.BOMVersionUtil;

public class ECNUpdateRouteBusiness
extends AbstractECNUpdateService {
    private static final Log log = LogFactory.getLog(ECNUpdateRouteBusiness.class);
    public static final String EXT_PLGUIN_NUMBER = "PDM_ECN_UPDATEROUTE_EXT";
    private static ECNUpdateRouteBusiness impl;

    public static ECNUpdateRouteBusiness getInstance() {
        if (impl == null) {
            impl = new ECNUpdateRouteBusiness();
        }
        return impl;
    }

    @Override
    public String execUpdate(DynamicObject ecnBill) {
        DynamicObjectCollection pentryColl = ecnBill.getDynamicObjectCollection("pentry");
        int psize = pentryColl.size();
        HashSet<Long> ecoRouteIdSet = new HashSet<Long>(16);
        HashSet<Long> routeIdSet = new HashSet<Long>(16);
        for (int i = 0; i < psize; ++i) {
            DynamicObject pentry = (DynamicObject)pentryColl.get(i);
            String chkMsg = this.checkData(ecnBill, pentry);
            if (!StringUtils.isEmpty((String)chkMsg)) {
                throw new KDBizException(new ErrorCode("checkDataError", chkMsg), new Object[0]);
            }
            Long ecnrouteid = pentry.getLong("ecorouteid");
            ecoRouteIdSet.add(ecnrouteid);
            DynamicObject pentryRoute = pentry.getDynamicObject("pentryroute");
            Long routeId = pentryRoute == null ? 0L : pentryRoute.getLong("id");
            if (PlatformUtils.isNullLong((Long)routeId)) continue;
            routeIdSet.add(routeId);
        }
        Map<Long, DynamicObject> ecoRouteMap = this.queryDynamicObjectMap(ecoRouteIdSet, "pdm_ecoroute");
        Map<Long, DynamicObject> routeMap = this.queryDynamicObjectMap(routeIdSet, "pdm_route");
        ArrayList updateRouteList = new ArrayList(16);
        ArrayList<DynamicObject> addRouteList = new ArrayList<DynamicObject>(16);
        for (int i = 0; i < psize; ++i) {
            DynamicObjectCollection ecoRouteEntryColl;
            DynamicObject pentry = (DynamicObject)pentryColl.get(i);
            DynamicObject pentryRoute = pentry.getDynamicObject("pentryroute");
            String entryversioncontrol = pentry.getString("entryversioncontrol");
            Long ecoRouteId = pentry.getLong("ecorouteid");
            DynamicObject newRtVersion = pentry.getDynamicObject("pentrynewrtversion");
            DynamicObject dynamicObject = ecoRouteMap.get(ecoRouteId);
            if (dynamicObject == null || PlatformUtils.isNullCollection((DynamicObjectCollection)(ecoRouteEntryColl = dynamicObject.getDynamicObjectCollection("processentry")))) continue;
            for (DynamicObject ecoRouteEntry : ecoRouteEntryColl) {
                String rtNumber;
                DynamicObject route;
                if (this.isAddMode(ecoRouteEntry, "entrymode") || this.isChangeAfterMode(ecoRouteEntry, "entrymode")) {
                    if ("A".equals(entryversioncontrol) || "B".equals(entryversioncontrol)) {
                        route = routeMap.get((Long)pentryRoute.getPkValue());
                        this.addProcessEntry(route, ecnBill, dynamicObject, ecoRouteEntry);
                        if ("B".equals(entryversioncontrol)) {
                            route.set("routeversion", (Object)newRtVersion);
                            route.set("version", null);
                            route.set("id", dynamicObject.getPkValue());
                            rtNumber = route.getString("number");
                            if (StringUtils.isEmpty((String)rtNumber)) {
                                route.set("number", (Object)(dynamicObject.getPkValue() + ""));
                            }
                            PlatformUtils.addList(addRouteList, (DynamicObject)route);
                            continue;
                        }
                        PlatformUtils.addList(updateRouteList, (DynamicObject)route);
                        continue;
                    }
                    if (!this.isAddMode(ecoRouteEntry, "entrymode")) continue;
                    route = this.findFromList(addRouteList, (Long)dynamicObject.getPkValue());
                    if (route == null) {
                        route = this.addRouteHead(ecnBill, pentry, dynamicObject);
                    }
                    this.addProcessEntry(route, ecnBill, dynamicObject, ecoRouteEntry);
                    PlatformUtils.addList(addRouteList, (DynamicObject)route);
                    continue;
                }
                if (this.isDisableMode(ecoRouteEntry, "entrymode")) {
                    route = routeMap.get(pentryRoute.getPkValue());
                    this.disableProcessEntry(route, ecnBill, dynamicObject, ecoRouteEntry);
                    if ("B".equals(entryversioncontrol)) {
                        route.set("routeversion", (Object)newRtVersion);
                        route.set("version", null);
                        route.set("id", dynamicObject.getPkValue());
                        rtNumber = route.getString("number");
                        if (StringUtils.isEmpty((String)rtNumber)) {
                            route.set("number", (Object)(dynamicObject.getPkValue() + ""));
                        }
                        PlatformUtils.addList(addRouteList, (DynamicObject)route);
                        continue;
                    }
                    PlatformUtils.addList(updateRouteList, (DynamicObject)route);
                    continue;
                }
                ecoRouteEntry.set("newprocessentryid", ecoRouteEntry.get("oldprocessentryid"));
            }
        }
        PluginProxy<IECNUpdateRouteExt> extPlugin = this.genExtPluginxy();
        boolean isUpdateEcnBill = Boolean.FALSE;
        if (!PlatformUtils.isNullList(addRouteList)) {
            int addSize = addRouteList.size();
            long[] addIds = ORM.create().genLongIds("pdm_route", addSize);
            DynamicObject routeA = (DynamicObject)addRouteList.get(0);
            String orgId = String.valueOf(routeA.getDynamicObject("org").getPkValue());
            String[] stringArray = CodeRuleServiceHelper.getBatchNumber((String)"pdm_route", (DynamicObject)routeA, (String)orgId, (int)addSize);
            ArrayList<DynamicObject> newAddRouteList = new ArrayList<DynamicObject>(addSize);
            long userId = RequestContext.get().getCurrUserId();
            Date currentDate = new Date();
            for (int i = 0; i < addSize; ++i) {
                DynamicObject addRoute = (DynamicObject)addRouteList.get(i);
                Long ecoRouteId = addRoute.getLong("id");
                String oldNumber = addRoute.getString("number");
                String oldName = addRoute.getString("name");
                boolean isInitVersion = Boolean.TRUE;
                if (!StringUtils.isEmpty((String)oldNumber)) {
                    Map<String, Long> cacheOldEntryIdMap = this.cacheOldEntryIdMap(addRoute);
                    addRoute = (DynamicObject)OrmUtils.clone((Object)addRoute, (IDataEntityType)addRoute.getDataEntityType(), (boolean)false, (boolean)true);
                    isInitVersion = Boolean.FALSE;
                    this.setPrimaryKey(addRoute);
                    DynamicObject ecoRoute = ecoRouteMap.get(ecoRouteId);
                    this.reSetNewEntryIdByRef(ecoRoute, cacheOldEntryIdMap, addRoute);
                }
                Long newRtid = addIds[i];
                String newNumber = this.getNewNumber(stringArray, i, newRtid, "ECN_");
                addRoute.set("id", (Object)newRtid);
                addRoute.set("masterid", (Object)newRtid);
                addRoute.set("number", (Object)newNumber);
                addRoute.set("name", (Object)oldName);
                addRoute.set("enable", (Object)"1");
                addRoute.set("status", (Object)"A");
                addRoute.set("creator", (Object)userId);
                addRoute.set("modifier", (Object)userId);
                addRoute.set("auditor", (Object)userId);
                addRoute.set("createtime", (Object)currentDate);
                addRoute.set("modifytime", (Object)currentDate);
                addRoute.set("ctrlstrategy", (Object)this.getDefaultCt("pdm_route", orgId));
                DynamicObjectCollection addColl = addRoute.getDynamicObjectCollection("processentry");
                for (DynamicObject addEntry : addColl) {
                    addEntry.set("entryecnid", ecnBill.getPkValue());
                    addEntry.set("entryecnno", (Object)ecnBill.getString("billno"));
                }
                newAddRouteList.add(addRoute);
                if (!isInitVersion) continue;
                DynamicObject ecoRoute = ecoRouteMap.get(ecoRouteId);
                ecoRoute.set("routeid", (Object)newRtid);
                ecoRoute.set("number", (Object)newNumber);
                ecoRoute.set("name", (Object)oldName);
                for (int j = 0; j < psize; ++j) {
                    DynamicObject pentry = (DynamicObject)pentryColl.get(j);
                    Long ecnrouteid = pentry.getLong("ecorouteid");
                    if (!ecnrouteid.equals(ecoRoute.getLong("id"))) continue;
                    pentry.set("pentryroute", (Object)addRoute);
                    pentry.set("pentryroutename", (Object)oldName);
                    isUpdateEcnBill = Boolean.TRUE;
                }
            }
            this.beforeSubmitByAddRoute(ecnBill, newAddRouteList, extPlugin);
            this.submitAndAuditRoute(newAddRouteList, ecnBill.getString("billno"));
            for (DynamicObject newRoute : newAddRouteList) {
                Long newPkId = newRoute.getLong("id");
                for (Map.Entry<Long, DynamicObject> entrys : ecoRouteMap.entrySet()) {
                    DynamicObject ecoRoute = entrys.getValue();
                    if (!newPkId.equals(ecoRoute.getLong("routeid"))) continue;
                    ecoRoute.set("number", (Object)newRoute.getString("number"));
                    ecoRoute.set("name", (Object)newRoute.getString("name"));
                }
            }
            this.afterAuditByAddRoute(ecnBill, newAddRouteList, extPlugin);
        }
        if (!PlatformUtils.isNullList(updateRouteList)) {
            for (DynamicObject route : updateRouteList) {
                Long newPkId = route.getLong("id");
                for (Map.Entry entry : ecoRouteMap.entrySet()) {
                    DynamicObject ecoRoute = (DynamicObject)entry.getValue();
                    if (!newPkId.equals(ecoRoute.getLong("routeid"))) continue;
                    route.set("ismainprocess", ecoRoute.get("ismainprocess"));
                    route.set("routereplace", ecoRoute.get("routereplace"));
                    route.set("fremark", ecoRoute.get("fremark"));
                    DynamicObjectCollection ecoEntryentityColl = ecoRoute.getDynamicObjectCollection("entryentity");
                    DynamicObjectCollection routeEntryentityColl = route.getDynamicObjectCollection("entryentity");
                    for (DynamicObject entryEntity : routeEntryentityColl) {
                        DynamicObject ecoEntryEntity = this.getEntryEntity(entryEntity, ecoEntryentityColl);
                        if (ecoEntryEntity == null) continue;
                        entryEntity.set("processseqname", ecoEntryEntity.get("processseqname"));
                        entryEntity.set("processseqremark", ecoEntryEntity.get("processseqremark"));
                    }
                }
                DynamicObjectCollection updateColl = route.getDynamicObjectCollection("processentry");
                for (DynamicObject updateEntry : updateColl) {
                    Long srcOpEntryId = updateEntry.getLong("srcopentryid");
                    if (srcOpEntryId != null && !srcOpEntryId.equals(0L)) continue;
                    updateEntry.set("srcopentryid", updateEntry.getPkValue());
                }
                this.sort(route);
            }
            DynamicObject[] updateDatas = updateRouteList.toArray(new DynamicObject[updateRouteList.size()]);
            this.beforeUpdateByEditRoute(ecnBill, updateDatas, extPlugin);
            SaveServiceHelper.save((DynamicObject[])updateDatas);
            this.afterUpdateByEditRoute(ecnBill, updateDatas, extPlugin);
            for (DynamicObject route : updateRouteList) {
                EcoRouteUtils.refreshRouteEntryCache(route);
            }
            RouteSyncCostUtils.syncCost((DynamicObject[])updateDatas, (String)ecnBill.getString("billno"));
        }
        this.saveEcoDynamicObject(ecoRouteMap);
        if (isUpdateEcnBill) {
            SaveServiceHelper.update((DynamicObject)ecnBill);
        }
        return "";
    }

    public void submitAndAuditRoute(List<DynamicObject> addRouteList, String ecnBillNo) {
        this.submitAndAuditData(addRouteList, "pdm_route", ecnBillNo);
    }

    private DynamicObject addRouteHead(DynamicObject ecnBill, DynamicObject pentry, DynamicObject ecoRoute) {
        DynamicObject newRoute = BusinessDataServiceHelper.newDynamicObject((String)"pdm_route");
        EcoCommonHelper.putHeadProperties((DynamicObject)ecoRoute, (DynamicObject)newRoute, this.getUnIncludeFieldSetC());
        if (StringUtils.isEmpty((String)newRoute.getString("name"))) {
            newRoute.set("name", (Object)pentry.getString("pentryroutename"));
        }
        if (newRoute.getDynamicObject("version") == null) {
            newRoute.set("routeversion", pentry.get("pentrynewrtversion"));
        }
        newRoute.set("version", null);
        newRoute.set("id", ecoRoute.getPkValue());
        newRoute.set("number", (Object)"");
        return newRoute;
    }

    private void addProcessEntry(DynamicObject route, DynamicObject ecnBill, DynamicObject ecoRoute, DynamicObject ecoRouteEntry) {
        this.addEntryEntity(route, ecoRoute, ecoRouteEntry);
        DynamicObjectCollection routeProcessEntryColl = route.getDynamicObjectCollection("processentry");
        Set<String> unUpdateFieldSet = this.getUnIncludeFieldSetB();
        DynamicObject addEntry = routeProcessEntryColl.addNew();
        EcoCommonHelper.putAllProperties((DynamicObject)ecoRouteEntry, (DynamicObject)addEntry, unUpdateFieldSet);
        Long id = ORM.create().genLongId("pdm_route.processentry");
        addEntry.set("id", (Object)id);
        ecoRouteEntry.set("newprocessentryid", (Object)id);
        Date acttime = ecoRouteEntry.getDate("acttime");
        addEntry.set("entryvaliddate", (Object)acttime);
        addEntry.set("entryecnid", ecnBill.getPkValue());
        addEntry.set("entryecnno", (Object)ecnBill.getString("billno"));
        this.validateRouteEntryDate(route, addEntry);
        if (this.isChangeAfterMode(ecoRouteEntry, "entrymode")) {
            Long oldProcessEntryId = ecoRouteEntry.getLong("oldprocessentryid");
            DynamicObject changeBeforeEntry = this.getEntryById(routeProcessEntryColl, oldProcessEntryId);
            if (changeBeforeEntry != null) {
                changeBeforeEntry.set("entryinvaliddate", (Object)PlatformUtils.addSecond((Date)acttime, (int)-1));
                changeBeforeEntry.set("entryecnid", ecnBill.getPkValue());
                changeBeforeEntry.set("entryecnno", (Object)ecnBill.getString("billno"));
                Long srcOpEntryId = this.getSrcOpEntryId(changeBeforeEntry);
                changeBeforeEntry.set("srcopentryid", (Object)srcOpEntryId);
                addEntry.set("srcopentryid", (Object)srcOpEntryId);
            } else {
                String msg = String.format(ResManager.loadKDString((String)"\u5de5\u827a\u8def\u7ebf\u201c%1$s\u201d\uff1a\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u7684\u5de5\u5e8f\u5206\u5f55ID\u201c%2$s\u201d\uff0c\u5bf9\u5e94\u7684\u5de5\u5e8f\u53f7\u4e3a\u201c%3$s\u201d\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"ECNUpdateRouteBusiness_6", (String)"mmc-pdm-business", (Object[])new Object[0]), route.getString("number"), oldProcessEntryId, ecoRouteEntry.getString("operationno"));
                throw new KDBizException(new ErrorCode("validateRouteEntryData", msg), new Object[0]);
            }
        }
    }

    private Long getSrcOpEntryId(DynamicObject changeBeforeEntry) {
        Long id = changeBeforeEntry.getLong("srcopentryid");
        if (PlatformUtils.isNullLong((Long)id)) {
            id = (Long)changeBeforeEntry.getPkValue();
        }
        return id;
    }

    private void disableProcessEntry(DynamicObject route, DynamicObject ecnBill, DynamicObject ecoRoute, DynamicObject ecoRouteEntry) {
        Long oldProcessEntryId;
        DynamicObjectCollection routeProcessEntryColl = route.getDynamicObjectCollection("processentry");
        DynamicObject disableEntry = this.getEntryById(routeProcessEntryColl, oldProcessEntryId = Long.valueOf(ecoRouteEntry.getLong("oldprocessentryid")));
        if (disableEntry == null) {
            String msg = String.format(ResManager.loadKDString((String)"\u5de5\u827a\u8def\u7ebf\u201c%1$s\u201d\uff1a\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u7684\u5de5\u5e8f\u5206\u5f55ID\u201c%2$s\u201d\uff0c\u5bf9\u5e94\u7684\u5de5\u5e8f\u53f7\u4e3a\u201c%3$s\u201d\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"ECNUpdateRouteBusiness_6", (String)"mmc-pdm-business", (Object[])new Object[0]), route.getString("number"), oldProcessEntryId, ecoRouteEntry.getString("operationno"));
            throw new KDBizException(new ErrorCode("validateRouteEntryData", msg), new Object[0]);
        }
        Date acttime = ecoRouteEntry.getDate("acttime");
        disableEntry.set("entryinvaliddate", (Object)PlatformUtils.addSecond((Date)acttime, (int)-1));
        disableEntry.set("entryecnid", ecnBill.getPkValue());
        disableEntry.set("entryecnno", (Object)ecnBill.getString("billno"));
        ecoRouteEntry.set("newprocessentryid", disableEntry.getPkValue());
        this.validateRouteEntryDate(route, disableEntry);
    }

    private void addEntryEntity(DynamicObject route, DynamicObject ecoRoute, DynamicObject ecoRouteEntry) {
        DynamicObjectCollection entryColl = route.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection srcEntryColl = ecoRoute.getDynamicObjectCollection("entryentity");
        if (PlatformUtils.isNullCollection((DynamicObjectCollection)srcEntryColl)) {
            return;
        }
        Set<String> unUpdateFieldSet = this.getUnIncludeFieldSetA();
        for (DynamicObject srcEntry : srcEntryColl) {
            if (this.checkIsExistsProcessSeq(entryColl, srcEntry)) continue;
            DynamicObject addEntry = entryColl.addNew();
            EcoCommonHelper.putAllProperties((DynamicObject)srcEntry, (DynamicObject)addEntry, unUpdateFieldSet);
        }
    }

    private void validateRouteEntryDate(DynamicObject route, DynamicObject routeEntry) {
        Date inValideDate;
        Date valideDate = routeEntry.getDate("entryvaliddate");
        if (valideDate.compareTo(inValideDate = routeEntry.getDate("entryinvaliddate")) > 0) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String msg = String.format(ResManager.loadKDString((String)"\u5de5\u827a\u8def\u7ebf\u201c%1$s\u201d:\u5de5\u5e8f\u5e8f\u5217\u201c%2$s\u201d\u3001\u5de5\u5e8f\u53f7\u201c%3$s\u201d\u7684\u751f\u6548\u65e5\u671f\u201c%3$s\u201d\u5e94\u5c0f\u4e8e\u7b49\u4e8e\u5931\u6548\u65e5\u671f\u201c%4$s\u201d\u3002", (String)"ECNUpdateRouteBusiness_0", (String)"mmc-pdm-business", (Object[])new Object[0]), route.getString("number"), routeEntry.getString("parent"), routeEntry.getString("operationno"), sdf.format(valideDate), sdf.format(inValideDate));
            throw new KDBizException(new ErrorCode("validateRouteEntryDate", msg), new Object[0]);
        }
    }

    private Set<String> getUnIncludeFieldSetA() {
        HashSet<String> fieldSet = new HashSet<String>(16);
        fieldSet.add("id");
        fieldSet.add("seq");
        return fieldSet;
    }

    private Set<String> getUnIncludeFieldSetB() {
        HashSet<String> fieldSet = new HashSet<String>(16);
        fieldSet.add("id");
        fieldSet.add("seq");
        fieldSet.add("entryecnno");
        fieldSet.add("entryecnid");
        fieldSet.add("oldprocessentryid");
        fieldSet.add("newprocessentryid");
        fieldSet.add("entrymode");
        fieldSet.add("acttime");
        fieldSet.add("minacttime");
        fieldSet.add("estimatestatus");
        fieldSet.add("esremark");
        return fieldSet;
    }

    private Set<String> getUnIncludeFieldSetC() {
        HashSet<String> fieldSet = new HashSet<String>(16);
        fieldSet.add("id");
        fieldSet.add("masterid");
        fieldSet.add("number");
        fieldSet.add("pentryvaliddate");
        fieldSet.add("productno");
        fieldSet.add("routeid");
        fieldSet.add("sourcedata");
        fieldSet.add("bitindex");
        fieldSet.add("srcindex");
        return fieldSet;
    }

    private boolean checkIsExistsProcessSeq(DynamicObjectCollection entryColl, DynamicObject srcEntry) {
        String processSeq = srcEntry.getString("processseq");
        for (DynamicObject eEntry : entryColl) {
            if (!processSeq.equals(eEntry.getString("processseq"))) continue;
            return true;
        }
        return false;
    }

    private String checkData(DynamicObject ecnBill, DynamicObject pentry) {
        DynamicObject pentryRoute = pentry.getDynamicObject("pentryroute");
        String entryversioncontrol = pentry.getString("entryversioncontrol");
        DynamicObject materialMaster = pentry.getDynamicObject("proentrymaterialid");
        int seq = pentry.getInt("seq");
        String billno = ecnBill.getString("billno");
        if (!"B".equals(ecnBill.getString("changetype"))) {
            return String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u5355%1$s\u7684\u53d8\u66f4\u5bf9\u8c61\u4e0d\u662f\u5de5\u827a\u8def\u7ebf\uff0c\u65e0\u6cd5\u6267\u884c\u53d8\u66f4\u64cd\u4f5c\u3002", (String)"ECNUpdateRouteBusiness_1", (String)"mmc-pdm-business", (Object[])new Object[0]), billno, seq + 1);
        }
        if ("D".equals(entryversioncontrol)) {
            if (materialMaster == null) {
                return String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u5355%1$s\u7684\u7b2c%2$s\u884c\u4ea7\u54c1\u5206\u5f55\u4e2d\uff0c\u521d\u59cb\u7248\u672c\u672a\u5f55\u5165\u201c\u4ea7\u54c1\u7f16\u7801\u201d\u3002", (String)"ECNUpdateRouteBusiness_2", (String)"mmc-pdm-business", (Object[])new Object[0]), billno, seq + 1);
            }
            if (StringUtils.isEmpty((String)pentry.getString("pentryroutename"))) {
                return String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u5355%1$s\u7684\u7b2c%2$s\u884c\u5206\u5f55\u4e2d\uff0c\u521d\u59cb\u7248\u672c\u672a\u5f55\u5165\u201c\u5de5\u827a\u8def\u7ebf\u540d\u79f0\u201d\u3002", (String)"ECNUpdateRouteBusiness_3", (String)"mmc-pdm-business", (Object[])new Object[0]), billno, seq + 1);
            }
        }
        if (("A".equals(entryversioncontrol) || "B".equals(entryversioncontrol)) && pentryRoute == null) {
            return String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u5355%1$s\u7684\u7b2c%2$s\u884c\u5206\u5f55\u4e2d\uff0c\u521d\u59cb\u7248\u672c\u672a\u5f55\u5165\u201c\u5de5\u827a\u8def\u7ebf\u7f16\u7801\u201d\u3002", (String)"ECNUpdateRouteBusiness_4", (String)"mmc-pdm-business", (Object[])new Object[0]), billno, seq + 1);
        }
        if (pentry.getDynamicObject("pentrynewrtversion") == null && ("D".equals(entryversioncontrol) && BOMVersionUtil.isNeedVersion((boolean)false, (DynamicObject)ecnBill, (DynamicObject)pentry) || "B".equals(entryversioncontrol))) {
            return String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u5355%1$s\u7684\u7b2c%2$s\u884c\u4ea7\u54c1\u5206\u5f55\u6570\u636e\u4e2d\uff0c\u672a\u5f55\u5165\u65b0\u5de5\u827a\u8def\u7ebf\u7248\u672c\u3002", (String)"ECNUpdateRouteBusiness_5", (String)"mmc-pdm-business", (Object[])new Object[0]), billno, seq + 1);
        }
        return "";
    }

    private void sort(DynamicObject obj) {
        DynamicObjectCollection objCol = obj.getDynamicObjectCollection("processentry");
        objCol.sort((Comparator)new ProcessRouteComparatorImpl());
        for (int i = 0; i < objCol.size(); ++i) {
            ((DynamicObject)objCol.get(i)).set("seq", (Object)(i + 1));
        }
    }

    private DynamicObject getEntryEntity(DynamicObject obj, DynamicObjectCollection routeEntryentityColl) {
        for (DynamicObject eco : routeEntryentityColl) {
            if (!eco.getString("processseq").equals(obj.getString("processseq"))) continue;
            return eco;
        }
        return null;
    }

    private void beforeSubmitByAddRoute(DynamicObject ecnBill, List<DynamicObject> addRouteList, PluginProxy<IECNUpdateRouteExt> pluginProxy) {
        if (pluginProxy != null) {
            pluginProxy.callReplace(p -> {
                p.beforeSubmitByAddRoute(ecnBill, addRouteList);
                return null;
            });
        }
    }

    private void afterAuditByAddRoute(DynamicObject ecnBill, List<DynamicObject> addRouteList, PluginProxy<IECNUpdateRouteExt> pluginProxy) {
        if (pluginProxy != null) {
            pluginProxy.callReplace(p -> {
                p.afterAuditByAddRoute(ecnBill, addRouteList);
                return null;
            });
        }
    }

    private void beforeUpdateByEditRoute(DynamicObject ecnBill, DynamicObject[] editRoutes, PluginProxy<IECNUpdateRouteExt> pluginProxy) {
        if (pluginProxy != null) {
            pluginProxy.callReplace(p -> {
                p.beforeUpdateByEditRoute(ecnBill, editRoutes);
                return null;
            });
        }
    }

    private void afterUpdateByEditRoute(DynamicObject ecnBill, DynamicObject[] editRoutes, PluginProxy<IECNUpdateRouteExt> pluginProxy) {
        if (pluginProxy != null) {
            pluginProxy.callReplace(p -> {
                p.afterUpdateByEditRoute(ecnBill, editRoutes);
                return null;
            });
        }
    }

    private PluginProxy<IECNUpdateRouteExt> genExtPluginxy() {
        ECNUpdateRouteExtPlugin extPluginClass = new ECNUpdateRouteExtPlugin();
        return PluginProxy.create((Object)extPluginClass, IECNUpdateRouteExt.class, (String)EXT_PLGUIN_NUMBER, null);
    }
}

