/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.business.ecoplatform;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bd.mpdm.common.query.helper.MaterialMftQueryHelper;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.StringUtils;
import kd.mmc.pdm.business.ecoplatform.EcoCommonBusiness;
import kd.mmc.pdm.business.ecoplatform.EcoUtils;
import kd.mmc.pdm.common.util.MMCUtils;

public class EcoChangeBillCreateBusiness
extends EcoCommonBusiness {
    private static final Log log = LogFactory.getLog(EcoChangeBillCreateBusiness.class);
    private static Set<String> versionControlValueSet = Sets.newHashSet((Object[])new String[]{"A", "B", "D"});
    private static Set<String> entryModeValueSet = Sets.newHashSet((Object[])new String[]{"A", "C", "E"});
    private static Set<String> entryTypeValueSet = Sets.newHashSet((Object[])new String[]{"A", "B"});
    private static Set<String> entryQtyTypeValueSet = Sets.newHashSet((Object[])new String[]{"A", "B", "C"});
    private static Set<String> copEntryTypeValueSet = Sets.newHashSet((Object[])new String[]{"10720", "10730"});
    public Map<String, DynamicObject> dynamicObjectCacheMap = new ConcurrentHashMap<String, DynamicObject>();
    public Map<String, Map<Object, DynamicObject>> dynamicObjectMulCacheMap = new ConcurrentHashMap<String, Map<Object, DynamicObject>>();
    private static final String[] childEntryArray = new String[]{"setupentry", "subentryentity", "workstationentry", "qtyentry"};

    public EcoChangeBillCreateBusiness() {
        this.dynamicObjectCacheMap = new ConcurrentHashMap<String, DynamicObject>();
        this.dynamicObjectMulCacheMap = new ConcurrentHashMap<String, Map<Object, DynamicObject>>();
    }

    public JSONObject createBill(String params) {
        if (StringUtils.isEmpty((String)params)) {
            String msg = ResManager.loadKDString((String)"\u4f20\u5165\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"EcoChangeBillCreateBusiness_76", (String)"mmc-pdm-business", (Object[])new Object[0]);
            return this.genReturnData(msg, false, "");
        }
        if (!this.hasNewECNPermission()) {
            return this.genReturnData(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u201c%1$s\u201d\u65e0\u65b0\u589e\u5de5\u7a0b\u53d8\u66f4\u5355\u6743\u9650\u3002", (String)"EcoChangeBillCreateBusiness_74", (String)"mmc-pdm-business", (Object[])new Object[0]), this.getCurrentUserName()), false, "");
        }
        JSONObject paramsJson = new JSONObject();
        try {
            paramsJson = JSONObject.parseObject((String)params);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            String msg = String.format(ResManager.loadKDString((String)"\u89e3\u6790\u53c2\u6570\u4e3aJsonObject\u5bf9\u8c61\u65f6\u53d1\u751f\u9519\u8bef: %1$s\u3002", (String)"EcoChangeBillCreateBusiness_69", (String)"mmc-pdm-business", (Object[])new Object[0]), e.getMessage());
            return this.genReturnData(msg, false, "");
        }
        long startTime1 = System.currentTimeMillis();
        String chkResult = this.checkData(paramsJson);
        if (!chkResult.equals("ok")) {
            return this.genReturnData(chkResult, false, "");
        }
        long enddate1 = System.currentTimeMillis() - startTime1;
        long startTime2 = System.currentTimeMillis();
        JSONObject genResultObject = this.addChangeBill(paramsJson);
        long enddate2 = System.currentTimeMillis() - startTime2;
        log.info(String.format("EcoChangeBillCreateBusiness.createBill validateData:%s,createBillData:%s", enddate1, enddate2));
        this.dynamicObjectCacheMap.clear();
        this.dynamicObjectMulCacheMap.clear();
        return genResultObject;
    }

    private JSONObject addChangeBill(JSONObject paramsJson) {
        String errorString;
        ORM orm = ORM.create();
        DynamicObject bill = orm.newDynamicObject("pdm_bom_eco");
        Long id = orm.genLongId(bill.getDataEntityType());
        DynamicObject org = this.getOrg(paramsJson);
        bill.set("billno", (Object)this.getBillNo(paramsJson, bill));
        bill.set("billstatus", (Object)this.getBillStatus(paramsJson));
        bill.set("createtime", (Object)this.getCreateDate(paramsJson));
        bill.set("creator", (Object)this.getCreator(paramsJson));
        bill.set("name", (Object)paramsJson.getString("name"));
        bill.set("org", (Object)org);
        bill.set("id", (Object)id);
        bill.set("enable", (Object)"1");
        bill.set("changetype", (Object)"A");
        this.dealExtField(paramsJson, bill);
        JSONArray pentryArray = paramsJson.getJSONArray("pentry");
        int size = pentryArray.size();
        DynamicObjectCollection pentryColl = bill.getDynamicObjectCollection("pentry");
        DynamicObject[] ecoBoms = new DynamicObject[size];
        for (int i = 0; i < size; ++i) {
            JSONObject pentryJsonObject = pentryArray.getJSONObject(i);
            DynamicObject pentry = pentryColl.addNew();
            DynamicObject bom = this.getPBomByNumber(paramsJson, pentryJsonObject);
            if (bom == null) continue;
            bom = this.getFullBom(bom);
            pentry.set("bomtype", (Object)bom.getDynamicObject("type"));
            if (bill.getDynamicObject("type") == null) {
                bill.set("type", (Object)bom.getDynamicObject("type"));
            }
            boolean isInitVersion = this.isInitVersionControl(pentryJsonObject);
            DynamicObject masterMft = null;
            DynamicObject materialmaster = this.getPMaterial(pentryJsonObject);
            pentry.set("pentrybom", (Object)bom);
            masterMft = isInitVersion ? this.getMaterialMftByBom(null, materialmaster, org) : this.getMaterialMftByBom(bom, null, org);
            pentry.set("proentrymaterial", (Object)masterMft);
            pentry.set("proentrymaterialid", (Object)materialmaster);
            if (!isInitVersion) {
                pentry.set("bomauxproperty", bom.get("auxproperty"));
            }
            pentry.set("entryversioncontrol", (Object)pentryJsonObject.getString("entryversioncontrol"));
            pentry.set("pentryoldversion", bom == null ? null : bom.getDynamicObject("version"));
            if (this.isInitVersionControl(pentryJsonObject)) {
                pentry.set("pentrynewversion", (Object)this.getPNewVersion(pentryJsonObject));
            }
            if (pentryJsonObject.containsKey((Object)"pentryexecmode")) {
                pentry.set("pentryexecmode", (Object)pentryJsonObject.getString("pentryexecmode"));
            }
            if (this.isNullString(pentry.get("pentryexecmode"))) {
                pentry.set("pentryexecmode", (Object)"A");
            }
            pentry.set("pentryexecdate", (Object)this.getDate(pentryJsonObject.get((Object)"pentryexecdate")));
            pentry.set("pentryvaliddate", (Object)this.getDate(pentryJsonObject.get((Object)"pentryvaliddate")));
            DynamicObject ecoType = this.getEcoType(pentryJsonObject);
            if (ecoType == null) {
                ecoType = EcoUtils.getDefaultEcoType(org.getLong("id"));
            }
            pentry.set("ecotype", (Object)ecoType);
            pentry.set("pentryexecstatus", (Object)"A");
            pentry.set("pentryecreason", (Object)this.getEcnReason(pentryJsonObject));
            pentry.set("ecobomid", (Object)0L);
            this.dealExtField(pentryJsonObject, pentry);
            DynamicObject ecoBom = this.addEcoBom(orm, bill, pentry, paramsJson, pentryJsonObject, bom);
            Long ecoBomId = ecoBom.getLong("id");
            pentry.set("ecobomid", (Object)ecoBomId);
            pentry.set("ecobomdata", (Object)ecoBom);
            pentry.set("seq", (Object)pentryColl.size());
            ecoBoms[i] = ecoBom;
        }
        DynamicObject[] bills = new DynamicObject[]{bill};
        OperateOption option = this.getOperateOption();
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"pdm_bom_eco", (DynamicObject[])bills, (OperateOption)option);
        if (saveResult.getAllErrorOrValidateInfo() != null && !StringUtils.isEmpty((String)(errorString = EcoChangeBillCreateBusiness.getErrorMsg(saveResult)))) {
            String errorStr = String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5de5\u7a0b\u53d8\u66f4\u5355\u65f6\u53d1\u751f\u9519\u8bef\uff1a%1$s\u3002", (String)"EcoChangeBillCreateBusiness_68", (String)"mmc-pdm-business", (Object[])new Object[0]), errorString);
            log.info(errorStr);
            return this.genReturnData(errorStr, false, "");
        }
        saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"pdm_ecobom", (DynamicObject[])ecoBoms, (OperateOption)option);
        errorString = EcoChangeBillCreateBusiness.getErrorMsg(saveResult);
        if (!StringUtils.isEmpty((String)errorString)) {
            DeleteServiceHelper.delete((IDataEntityType)bill.getDataEntityType(), (Object[])new Object[]{bill.getPkValue()});
            String errorStr = String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5de5\u7a0b\u53d8\u66f4\u5355\u65f6\u53d1\u751f\u9519\u8bef\uff1a%1$s\u3002", (String)"EcoChangeBillCreateBusiness_68", (String)"mmc-pdm-business", (Object[])new Object[0]), errorString);
            log.info(errorStr);
            return this.genReturnData(errorStr, false, "");
        }
        JSONObject dataJsonObject = new JSONObject();
        dataJsonObject.put("billid", bill.getPkValue());
        dataJsonObject.put("billno", (Object)bill.getString("billno"));
        dataJsonObject.put("billstatus", (Object)bill.getString("billstatus"));
        String successfulMsg = ResManager.loadKDString((String)"\u751f\u6210\u6210\u529f", (String)"EcoChangeBillCreateBusiness_01", (String)"mmc-pdm-business", (Object[])new Object[0]);
        return this.genReturnData(successfulMsg, true, dataJsonObject.toJSONString());
    }

    private DynamicObject addEcoBom(ORM orm, DynamicObject bill, DynamicObject pentry, JSONObject paramsJson, JSONObject pentryJsonObject, DynamicObject bom) {
        JSONArray bomCopEntryArray;
        DynamicObject ecoBom = orm.newDynamicObject("pdm_ecobom");
        Long ecoBomId = orm.genLongId(ecoBom.getDataEntityType());
        DynamicObject materialMasterId = pentry.getDynamicObject("proentrymaterial").getDynamicObject("masterid");
        if (bom != null) {
            materialMasterId = bom.getDynamicObject("materialid");
        }
        ecoBom.set("id", (Object)ecoBomId);
        ecoBom.set("status", (Object)"A");
        ecoBom.set("enable", (Object)"1");
        ecoBom.set("datasource", (Object)"3");
        ecoBom.set("bomid", bom == null ? null : String.valueOf(bom.getPkValue()));
        ecoBom.set("useorg", (Object)bill.getDynamicObject("org"));
        ecoBom.set("productno", (Object)pentry.get("seq").toString());
        ecoBom.set("number", (Object)(bom == null ? "" : bom.getString("number")));
        ecoBom.set("group", (Object)(bom == null ? this.getBomGroup(pentryJsonObject) : bom.getDynamicObject("group")));
        ecoBom.set("createorg", (Object)bill.getDynamicObject("org"));
        ecoBom.set("materialid", (Object)materialMasterId);
        ecoBom.set("type", (Object)pentry.getDynamicObject("bomtype"));
        ecoBom.set("material", (Object)(bom == null ? pentry.getDynamicObject("proentrymaterial") : bom.getDynamicObject("material")));
        ecoBom.set("configuredcode", bom == null ? null : bom.getDynamicObject("configuredcode"));
        ecoBom.set("version", bom == null ? pentry.get("pentrynewversion") : bom.getDynamicObject("version"));
        ecoBom.set("replaceno", bom == null ? null : bom.getDynamicObject("replaceno"));
        ecoBom.set("optioncontrol", (Object)"A");
        ecoBom.set("yieldrate", (Object)(bom == null ? BigDecimal.ONE : bom.getBigDecimal("yieldrate")));
        ecoBom.set("auxproperty", bom == null ? null : bom.get("auxproperty"));
        ecoBom.set("iscoproduct", (Object)(bom == null ? false : bom.getBoolean("iscoproduct")));
        ecoBom.set("description", (Object)(bom == null ? "" : bom.getString("description")));
        ecoBom.set("qtybaseunit", (Object)(bom == null ? materialMasterId.getDynamicObject("baseunit") : bom.getDynamicObject("qtybaseunit")));
        ecoBom.set("pentryvaliddate", pentry.get("pentryvaliddate"));
        JSONArray bomEntryArray = pentryJsonObject.getJSONArray("bomentry");
        if (bomEntryArray != null && !bomEntryArray.isEmpty()) {
            int size = bomEntryArray.size();
            DynamicObjectCollection bomEntryColl = ecoBom.getDynamicObjectCollection("entry");
            for (int i = 0; i < size; ++i) {
                DynamicObject ecoBomEntry;
                JSONObject bomentryJsonObject = bomEntryArray.getJSONObject(i);
                String entrymode = bomentryJsonObject.getString("entrymode");
                if (this.isEditMode(bomentryJsonObject)) {
                    ecoBomEntry = bomEntryColl.addNew();
                    this.addEcoBomEntry(orm, ecoBom, ecoBomEntry, paramsJson, pentryJsonObject, bomentryJsonObject, bom, "B");
                    ecoBomEntry.set("entryecnno", (Object)bill.getString("billno"));
                    ecoBomEntry.set("entryecnid", (Object)String.valueOf(bill.getPkValue()));
                    ecoBomEntry.set("seq", (Object)bomEntryColl.size());
                    DynamicObject ecoBomEntryAfter = bomEntryColl.addNew();
                    this.addEcoBomEntry(orm, ecoBom, ecoBomEntryAfter, paramsJson, pentryJsonObject, bomentryJsonObject, bom, "C");
                    ecoBomEntryAfter.set("entryecnno", (Object)bill.getString("billno"));
                    ecoBomEntryAfter.set("entryecnid", (Object)String.valueOf(bill.getPkValue()));
                    ecoBomEntryAfter.set("seq", (Object)bomEntryColl.size());
                    continue;
                }
                ecoBomEntry = bomEntryColl.addNew();
                this.addEcoBomEntry(orm, ecoBom, ecoBomEntry, paramsJson, pentryJsonObject, bomentryJsonObject, bom, entrymode);
                ecoBomEntry.set("entryecnno", (Object)bill.getString("billno"));
                ecoBomEntry.set("entryecnid", (Object)String.valueOf(bill.getPkValue()));
                ecoBomEntry.set("seq", (Object)bomEntryColl.size());
            }
        }
        if ((bomCopEntryArray = pentryJsonObject.getJSONArray("copentry")) != null && !bomCopEntryArray.isEmpty()) {
            int size = bomCopEntryArray.size();
            DynamicObjectCollection bomCopEntryColl = ecoBom.getDynamicObjectCollection("copentry");
            for (int i = 0; i < size; ++i) {
                DynamicObject ecoBomCopEntry;
                JSONObject bomCopEntryJsonObject = bomCopEntryArray.getJSONObject(i);
                String entrymode = bomCopEntryJsonObject.getString("copentrymode");
                if (this.isCopEditMode(bomCopEntryJsonObject)) {
                    ecoBomCopEntry = bomCopEntryColl.addNew();
                    this.addEcoBomCopEntry(orm, ecoBom, ecoBomCopEntry, paramsJson, pentryJsonObject, bomCopEntryJsonObject, bom, "B");
                    ecoBomCopEntry.set("copentryecnno", (Object)bill.getString("billno"));
                    ecoBomCopEntry.set("seq", (Object)bomCopEntryColl.size());
                    DynamicObject ecoBomEntryAfter = bomCopEntryColl.addNew();
                    this.addEcoBomCopEntry(orm, ecoBom, ecoBomEntryAfter, paramsJson, pentryJsonObject, bomCopEntryJsonObject, bom, "C");
                    ecoBomEntryAfter.set("copentryecnno", (Object)bill.getString("billno"));
                    ecoBomEntryAfter.set("seq", (Object)bomCopEntryColl.size());
                    continue;
                }
                ecoBomCopEntry = bomCopEntryColl.addNew();
                this.addEcoBomCopEntry(orm, ecoBom, ecoBomCopEntry, paramsJson, pentryJsonObject, bomCopEntryJsonObject, bom, entrymode);
                ecoBomCopEntry.set("copentryecnno", (Object)bill.getString("billno"));
                ecoBomCopEntry.set("seq", (Object)bomCopEntryColl.size());
            }
        }
        return ecoBom;
    }

    private DynamicObject addEcoBomEntry(ORM orm, DynamicObject ecoBom, DynamicObject ecoBomEntry, JSONObject paramsJson, JSONObject pentryJsonObject, JSONObject bomentryJsonObject, DynamicObject parentBom, String entrymode) {
        boolean isAdd = "A".equals(entrymode);
        boolean isBefore = "B".equals(entrymode);
        boolean isAfter = "C".equals(entrymode);
        boolean isDisable = "E".equals(entrymode);
        int bomSeq = bomentryJsonObject.getInteger("bomentryseq");
        DynamicObject bomentry = this.getBomEntryIdBySeq(parentBom, bomSeq);
        DynamicObject materialMasterId = null;
        DynamicObject materialMft = null;
        ecoBomEntry.set("entrymode", (Object)entrymode);
        if (isBefore || isAfter || isDisable) {
            this.putBomEntryToEcoBom(bomentry, ecoBomEntry);
            ecoBomEntry.set("entryseq", bomentry.get("seq"));
        }
        ecoBomEntry.set("bomentry", null);
        if (isBefore || isDisable) {
            ecoBomEntry.set("bomentry", bomentry.getPkValue());
        }
        if (!isAdd) {
            ecoBomEntry.set("entrybomentryid", bomentry.getPkValue());
        } else {
            Long pBomEntryPK = ORM.create().genLongId("pdm_ecobom.entry");
            ecoBomEntry.set("entrybomentryid", (Object)pBomEntryPK);
        }
        ecoBomEntry.set("acttime", (Object)this.getActTime(bomentryJsonObject));
        ecoBomEntry.set("estimatestatus", (Object)"A");
        ecoBomEntry.set("entrygroupno", (Object)this.getEntryGroupNo(bomentryJsonObject));
        ecoBomEntry.set("entryrefno", (Object)this.getEntryRefNo(bomentryJsonObject));
        ecoBomEntry.set("continuouspoint", (Object)"A");
        ecoBomEntry.set("iscanestimate", (Object)true);
        if (isAdd || isAfter) {
            DynamicObject ecoBomChildEntry;
            DynamicObject bomType;
            String entryQtyType;
            DynamicObject entryConfigureCode;
            materialMasterId = this.getEntryMaterial(bomentryJsonObject);
            materialMft = this.getMaterialMftByBom(null, materialMasterId, ecoBom.getDynamicObject("createorg"));
            BigDecimal fz = this.getEntryQtyNumerator(bomentryJsonObject);
            BigDecimal fm = this.getEntryQtyDenominator(bomentryJsonObject);
            ecoBomEntry.set("entrytype", (Object)bomentryJsonObject.getString("entrytype"));
            ecoBomEntry.set("entrymaterial", (Object)materialMft);
            ecoBomEntry.set("featuretype", (Object)this.getEntryFeatureType(bomentryJsonObject));
            ecoBomEntry.set("entrymaterialid", (Object)materialMasterId);
            ecoBomEntry.set("entryqty", (Object)MMCUtils.divide((BigDecimal)fz, (BigDecimal)fm));
            ecoBomEntry.set("entryunit", (Object)(materialMasterId == null ? Long.valueOf(0L) : materialMasterId.getDynamicObject("baseunit")));
            DynamicObject entryVersion = this.getEntryVersion(bomentryJsonObject);
            if (entryVersion != null) {
                ecoBomEntry.set("entryversion", (Object)entryVersion);
            }
            if ((entryConfigureCode = this.getEntryConfigureCode(bomentryJsonObject)) != null) {
                ecoBomEntry.set("entryconfiguredcode", (Object)entryConfigureCode);
            }
            if (this.isNullString(entryQtyType = bomentryJsonObject.getString("entryqtytype"))) {
                entryQtyType = "A";
            }
            ecoBomEntry.set("entryqtytype", (Object)entryQtyType);
            ecoBomEntry.set("entryqtynumerator", (Object)fz);
            ecoBomEntry.set("entryqtydenominator", (Object)fm);
            ecoBomEntry.set("entryfixscrap", (Object)this.getEntryFixscrap(bomentryJsonObject));
            ecoBomEntry.set("entryscraprate", (Object)this.getEntryScraprate(bomentryJsonObject));
            ecoBomEntry.set("entryvaliddate", (Object)this.getEntryValidDate(bomentryJsonObject));
            ecoBomEntry.set("entryinvaliddate", (Object)this.getEntryInvalidDate(bomentryJsonObject));
            ecoBomEntry.set("entryisjumplevel", (Object)this.getEntryIsJumpLevel(bomentryJsonObject));
            ecoBomEntry.set("entryremark", (Object)this.getEntryRemark(bomentryJsonObject));
            ecoBomEntry.set("entryprocessseq", (Object)this.getEntryProcessSeq(bomentryJsonObject));
            ecoBomEntry.set("entryoperationnumber", (Object)this.getEntryOperationNumber(bomentryJsonObject));
            ecoBomEntry.set("entrymaterialattr", (Object)this.getEntryMaterialAttr(bomentryJsonObject));
            ecoBomEntry.set("entryleadtime", (Object)this.getEntryLeadTime(bomentryJsonObject));
            ecoBomEntry.set("entrynumber", (Object)(materialMasterId == null ? "" : materialMasterId.getString("number")));
            ecoBomEntry.set("continuouspoint", (Object)"A");
            ecoBomEntry.set("iscanestimate", (Object)true);
            if (isAdd && materialMft != null) {
                ecoBomEntry.set("entryownertype", (Object)"bos_org");
                ecoBomEntry.set("entryissuemode", materialMft.get("issuemode"));
                ecoBomEntry.set("entryiskey", materialMft.get("iskeypart"));
                ecoBomEntry.set("entryisbulkmaterial", materialMft.get("isbulkmaterial"));
                ecoBomEntry.set("entryisstockalloc", materialMft.get("isstockallot"));
                ecoBomEntry.set("entryisbackflush", materialMft.get("isbackflush"));
                ecoBomEntry.set("entryoutorg", materialMft.get("outstorageunit"));
                ecoBomEntry.set("entryoutwarehouse", materialMft.get("outwarehouse"));
                ecoBomEntry.set("entrytimeunit", (Object)"D");
                ecoBomEntry.set("entryoutlocation", materialMft.get("outwarelocation"));
                ecoBomEntry.set("entrysupplytype", (Object)"10910");
                ecoBomEntry.set("entrysupplyorg", materialMft.get("supplyorgunitid"));
                ecoBomEntry.set("entrywarehouse", materialMft.get("warehouse"));
                ecoBomEntry.set("entrylocation", materialMft.get("location"));
                ecoBomEntry.set("configproperties", materialMasterId == null ? "1" : materialMasterId.get("configproperties"));
            }
            JSONArray setupEntryArray = bomentryJsonObject.getJSONArray("setupentry");
            JSONArray qtyEntryArray = bomentryJsonObject.getJSONArray("qtyentry");
            JSONArray subEntityEntryArray = bomentryJsonObject.getJSONArray("subentryentity");
            JSONArray workStationEntryArray = bomentryJsonObject.getJSONArray("workstationentry");
            if (setupEntryArray != null && !setupEntryArray.isEmpty() && this.bomTypeIsInsloc(bomType = this.getBomType(pentryJsonObject))) {
                ecoBomEntry.getDynamicObjectCollection("setupentry").clear();
                for (int j = 0; j < setupEntryArray.size(); ++j) {
                    JSONObject childJs = setupEntryArray.getJSONObject(j);
                    DynamicObject ecoBomChildEntry2 = ecoBomEntry.getDynamicObjectCollection("setupentry").addNew();
                    ecoBomChildEntry2.set("setupentryqty", (Object)this.getSetupEntryQty(childJs));
                    ecoBomChildEntry2.set("setupentrysetuplocation", (Object)this.getSetupEntrySetupLocation(childJs));
                    ecoBomChildEntry2.set("setupentryremark", (Object)this.getSetupEntryRemark(childJs));
                    this.dealExtField(childJs, ecoBomChildEntry2);
                }
            }
            if (qtyEntryArray != null && !qtyEntryArray.isEmpty() && this.isSetpQty(bomentryJsonObject)) {
                ecoBomEntry.getDynamicObjectCollection("qtyentry").clear();
                for (int j = 0; j < qtyEntryArray.size(); ++j) {
                    JSONObject childJs = qtyEntryArray.getJSONObject(j);
                    ecoBomChildEntry = ecoBomEntry.getDynamicObjectCollection("qtyentry").addNew();
                    ecoBomChildEntry.set("qtyentrybatchstartqty", (Object)this.getQtyEntryBatchStartQty(childJs));
                    ecoBomChildEntry.set("qtyentrybatchendqty", (Object)this.getQtyEntryBatchEndQty(childJs));
                    ecoBomChildEntry.set("qtyentryisstepfix", (Object)this.getQtyEntryIsStepFix(childJs));
                    ecoBomChildEntry.set("qtyentryqtynumerator", (Object)this.getQtyEntryQtyNumerator(childJs));
                    ecoBomChildEntry.set("qtyentryqtydenominator", (Object)this.getQtyEntryQtyDenominator(childJs));
                    ecoBomChildEntry.set("qtyentryfixscrap", (Object)this.getQtyEntryFixscrap(childJs));
                    ecoBomChildEntry.set("qtyentryscraprate", (Object)this.getQtyEntryScrapRate(childJs));
                    this.dealExtField(childJs, ecoBomChildEntry);
                }
            }
            if (subEntityEntryArray != null && !subEntityEntryArray.isEmpty()) {
                ecoBomEntry.getDynamicObjectCollection("subentryentity").clear();
                for (int j = 0; j < subEntityEntryArray.size(); ++j) {
                    JSONObject childJs = subEntityEntryArray.getJSONObject(j);
                    ecoBomChildEntry = ecoBomEntry.getDynamicObjectCollection("subentryentity").addNew();
                    ecoBomChildEntry.set("chararuleno", (Object)this.getCharaRuleNo(childJs));
                    this.dealExtField(childJs, ecoBomChildEntry);
                }
            }
            if (workStationEntryArray != null && !workStationEntryArray.isEmpty()) {
                ecoBomEntry.getDynamicObjectCollection("workstationentry").clear();
                for (int j = 0; j < workStationEntryArray.size(); ++j) {
                    JSONObject childJs = workStationEntryArray.getJSONObject(j);
                    ecoBomChildEntry = ecoBomEntry.getDynamicObjectCollection("workstationentry").addNew();
                    DynamicObject workCenter = this.getWorkCenter(childJs);
                    String workStationNumber = childJs.getString("workstation");
                    ecoBomChildEntry.set("workcenter", (Object)workCenter);
                    ecoBomChildEntry.set("workstation", (Object)this.getWorkStation(workCenter, workStationNumber));
                    ecoBomChildEntry.set("workentryqty", (Object)this.getWorkEntryQty(childJs));
                    this.dealExtField(childJs, ecoBomChildEntry);
                }
            }
        }
        this.dealExtField(bomentryJsonObject, ecoBomEntry);
        if (isAdd || isBefore || isDisable) {
            ecoBomEntry.set("tranqty", (Object)this.getTranqty(bomentryJsonObject));
            ecoBomEntry.set("transtartdate", (Object)this.getTranstartDate(bomentryJsonObject));
        }
        if ("B".equals(ecoBomEntry.getString("entrytype"))) {
            ecoBomEntry.set("entrymaterial", null);
            ecoBomEntry.set("entrymaterialid", null);
            ecoBomEntry.set("entrymaterialattr", (Object)"");
            ecoBomEntry.set("configproperties", (Object)"");
        }
        return ecoBomEntry;
    }

    private void putBomEntryToEcoBom(DynamicObject bomEntry, DynamicObject ecoBomEntry) {
        Set<String> bomEntryFieldSet = this.getFieldSet(bomEntry);
        Set<String> ecoBomEntryFieldSet = this.getFieldSet(ecoBomEntry);
        HashSet noFiledSet = Sets.newHashSet((Object[])new String[]{"id", "ecobomentryid", "number", "masterid", "sourcedata", "bitindex", "srcindex", "seq", "setupentry", "subentryentity", "workstationentry", "qtyentry"});
        for (String fieldNumber : bomEntryFieldSet) {
            Object value;
            if (!ecoBomEntryFieldSet.contains(fieldNumber) || noFiledSet.contains(fieldNumber) || (value = bomEntry.get(fieldNumber)) == null || value instanceof DynamicObjectCollection || value instanceof MulBasedataDynamicObjectCollection) continue;
            if ("multilanguagetext".equalsIgnoreCase(fieldNumber)) {
                DynamicObjectCollection newLocCol = this.setLocaleString(bomEntry, fieldNumber);
                log.info("multilanguagetext field:" + fieldNumber + ",value =" + value.toString() + ",newLocCol=" + newLocCol.toString());
                ecoBomEntry.set(fieldNumber, (Object)newLocCol);
                continue;
            }
            ecoBomEntry.set(fieldNumber, value);
        }
        for (int i = 0; i < childEntryArray.length; ++i) {
            String entryName = childEntryArray[i];
            DynamicObjectCollection bomChildEntryColl = bomEntry.getDynamicObjectCollection(entryName);
            DynamicObjectCollection ecoBomChildEntryColl = ecoBomEntry.getDynamicObjectCollection(entryName);
            if (bomChildEntryColl == null || bomChildEntryColl.isEmpty()) continue;
            for (int j = 0; j < bomChildEntryColl.size(); ++j) {
                DynamicObject bomChildEntry = (DynamicObject)bomChildEntryColl.get(j);
                DynamicObject ecoBomChildEntry = ecoBomChildEntryColl.addNew();
                this.putChildEntryToEcoBom(bomChildEntry, ecoBomChildEntry);
            }
        }
    }

    @Override
    public Set<String> getNotFieldSet() {
        return Sets.newHashSet((Object[])new String[]{"id", "number", "masterid", "sourcedata", "bitindex", "srcindex", "seq"});
    }

    private void putChildEntryToEcoBom(DynamicObject bomChildEntry, DynamicObject ecoBomChildEntry) {
        this.putDynaicObject(bomChildEntry, ecoBomChildEntry);
    }

    private String checkData(JSONObject paramsJson) {
        String chkCreatetime;
        String chkCreator;
        String chkNameMsg;
        String chkBillNoMsg;
        StringBuilder sb = new StringBuilder();
        String chkOrgMsg = this.checkData_org(paramsJson);
        if (!this.isNullString(chkOrgMsg) && !"ok".equals(chkOrgMsg)) {
            sb.append(chkOrgMsg).append(";");
        }
        if (!this.isNullString(chkBillNoMsg = this.checkData_billno(paramsJson)) && !"ok".equals(chkBillNoMsg)) {
            sb.append(chkBillNoMsg).append(";");
        }
        if (!this.isNullString(chkNameMsg = this.checkData_Name(paramsJson)) && !"ok".equals(chkNameMsg)) {
            sb.append(chkNameMsg).append(";");
        }
        if (!this.isNullString(chkCreator = this.checkData_Creator(paramsJson)) && !"ok".equals(chkCreator)) {
            sb.append(chkCreator).append(";");
        }
        if (!this.isNullString(chkCreatetime = this.checkData_Createtime(paramsJson)) && !"ok".equals(chkCreatetime)) {
            sb.append(chkCreatetime).append(";");
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return this.checkData_PEntry(paramsJson);
    }

    private String checkData_PEntry(JSONObject paramsJson) {
        String chkMsg = "";
        JSONArray pentryArray = paramsJson.getJSONArray("pentry");
        if (pentryArray == null || pentryArray.isEmpty()) {
            chkMsg = ResManager.loadKDString((String)"\u53d8\u66f4\u5355\u4ea7\u54c1\u4fe1\u606f\u5206\u5f55\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"EcoChangeBillCreateBusiness_13", (String)"mmc-pdm-business", (Object[])new Object[0]);
            return chkMsg;
        }
        int size = pentryArray.size();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            String chkMsgBomEntry;
            String chkMsgBomGroup;
            String chkMsgEcnReason;
            String chkMsgEcoType;
            String chkMsgValidDate;
            String chkMsgNewVersion;
            String chkMsgBom;
            String chkMsgPMaterial;
            int rowIndex;
            JSONObject pentryJsonObject = pentryArray.getJSONObject(i);
            String chkMsgVersionControl = this.checkData_entryversioncontrol(pentryJsonObject, rowIndex = i + 1);
            if (!this.isNullString(chkMsgVersionControl) && !"ok".equals(chkMsgVersionControl)) {
                sb.append(chkMsgVersionControl).append(";");
            }
            if (!this.isNullString(chkMsgPMaterial = this.checkData_proentrymaterial(paramsJson, pentryJsonObject, rowIndex)) && !"ok".equals(chkMsgPMaterial)) {
                sb.append(chkMsgPMaterial).append(";");
            }
            if (!this.isNullString(chkMsgBom = this.checkData_pentrybom(paramsJson, pentryJsonObject, rowIndex)) && !"ok".equals(chkMsgBom)) {
                sb.append(chkMsgBom).append(";");
            }
            if (!this.isNullString(chkMsgNewVersion = this.checkData_pentrynewversion(paramsJson, pentryJsonObject, rowIndex)) && !"ok".equals(chkMsgNewVersion)) {
                sb.append(chkMsgNewVersion).append(";");
            }
            if (!this.isNullString(chkMsgValidDate = this.checkData_pentryvaliddate(paramsJson, pentryJsonObject, rowIndex)) && !"ok".equals(chkMsgValidDate)) {
                sb.append(chkMsgValidDate).append(";");
            }
            if (!this.isNullString(chkMsgEcoType = this.checkData_ecotype(pentryJsonObject, rowIndex)) && !"ok".equals(chkMsgEcoType)) {
                sb.append(chkMsgEcoType).append(";");
            }
            if (!this.isNullString(chkMsgEcnReason = this.checkData_ecnreason(pentryJsonObject, rowIndex)) && !"ok".equals(chkMsgEcnReason)) {
                sb.append(chkMsgEcnReason).append(";");
            }
            if (!this.isNullString(chkMsgBomGroup = this.checkData_bomGroup(pentryJsonObject, rowIndex)) && !"ok".equals(chkMsgBomGroup)) {
                sb.append(chkMsgBomGroup).append(";");
            }
            JSONArray bomEntryArray = pentryJsonObject.getJSONArray("bomentry");
            JSONArray bomCopEntryArray = pentryJsonObject.getJSONArray("copentry");
            if ((bomEntryArray == null || bomEntryArray.isEmpty()) && (bomCopEntryArray == null || bomCopEntryArray.isEmpty())) {
                chkMsg = String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\u4ea7\u54c1\u4fe1\u606f\u5206\u5f55\u5bf9\u5e94\u7684ECO_BOM\u5b50\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"EcoChangeBillCreateBusiness_77", (String)"mmc-pdm-business", (Object[])new Object[0]), rowIndex);
                sb.append(chkMsg).append(";");
            }
            if (!this.isNullString(chkMsgBomEntry = this.checkData_BomEntry(paramsJson, pentryJsonObject, rowIndex)) && !"ok".equals(chkMsgBomEntry)) {
                sb.append(chkMsgBomEntry).append(";");
                break;
            }
            String chkMsgBomCopEntry = this.checkData_BomCopEntry(paramsJson, pentryJsonObject, rowIndex);
            if (this.isNullString(chkMsgBomCopEntry) || "ok".equals(chkMsgBomCopEntry)) continue;
            sb.append(chkMsgBomCopEntry).append(";");
            break;
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return "ok";
    }

    private String checkData_BomEntry(JSONObject paramsJson, JSONObject pentryJsonObject, int rowIndex) {
        JSONArray bomEntryArray = pentryJsonObject.getJSONArray("bomentry");
        if (bomEntryArray == null || bomEntryArray.isEmpty()) {
            return "ok";
        }
        int bomSize = bomEntryArray.size();
        DynamicObject bomHead = this.getPBomByNumber(paramsJson, pentryJsonObject);
        StringBuilder sb = new StringBuilder();
        DynamicObject org = this.getOrg(paramsJson);
        String chkMsg = "";
        for (int j = 0; j < bomSize; ++j) {
            String chkMsgEntryvaliddate;
            String chkMsgActTime;
            String chkMsgTransDate;
            String chkMsgQtyValidate;
            String chkMsgEntryQtyType;
            String chkMsgEntryConfigureCode;
            String chkMsgEntryVersion;
            String chkMsgBomSeq;
            String chkMsgFeatureType;
            DynamicObject entryMaterial;
            DynamicObject materialMft;
            String chkMsgEntryMaterial;
            String chkMsgEntryType;
            int rowIndex2;
            JSONObject bomentryJsonObject = bomEntryArray.getJSONObject(j);
            String chkMsgEntryMode = this.checkData_entrymode(bomentryJsonObject, rowIndex2 = j + 1);
            if (!this.isNullString(chkMsgEntryMode) && !"ok".equals(chkMsgEntryMode)) {
                sb.append(chkMsgEntryMode).append(";");
            }
            if (!this.isNullString(chkMsgEntryType = this.checkData_entrytype(bomentryJsonObject, rowIndex2)) && !"ok".equals(chkMsgEntryType)) {
                sb.append(chkMsgEntryType).append(";");
            }
            if (!this.isNullString(chkMsgEntryMaterial = this.checkData_entrymaterial(bomentryJsonObject, rowIndex2)) && !"ok".equals(chkMsgEntryMaterial)) {
                sb.append(chkMsgEntryMaterial).append(";");
            }
            if ((materialMft = this.getMaterialMftByBom(null, entryMaterial = this.getEntryMaterial(bomentryJsonObject), org)) == null) {
                chkMsg = String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\u53d8\u66f4\u5355\u7684\u7ec4\u4ef6\u7f16\u7801\u201c%2$s\u201d\u5728\u751f\u4ea7\u7ec4\u7ec7\u201c%3$s\u201d\u4e0b\u65e0\u7269\u6599\u751f\u4ea7\u4fe1\u606f\u3002", (String)"EcoChangeBillCreateBusiness_75", (String)"mmc-pdm-business", (Object[])new Object[0]), rowIndex, entryMaterial == null ? "" : entryMaterial.getString("number"), org.getString("number"));
                sb.append(chkMsg).append(";");
            }
            if (!this.isNullString(chkMsgFeatureType = this.checkData_featuretype(bomentryJsonObject, rowIndex2)) && !"ok".equals(chkMsgFeatureType)) {
                sb.append(chkMsgFeatureType).append(";");
            }
            if (!this.isNullString(chkMsgBomSeq = this.checkData_bomSeq(bomentryJsonObject, rowIndex2, bomHead)) && !"ok".equals(chkMsgBomSeq)) {
                sb.append(chkMsgBomSeq).append(";");
            }
            if (!this.isNullString(chkMsgEntryVersion = this.checkData_entryversion(pentryJsonObject, bomentryJsonObject, rowIndex2)) && !"ok".equals(chkMsgEntryVersion)) {
                sb.append(chkMsgEntryVersion).append(";");
            }
            if (!this.isNullString(chkMsgEntryConfigureCode = this.checkData_entryconfiguredcode(paramsJson, bomentryJsonObject, rowIndex2)) && !"ok".equals(chkMsgEntryConfigureCode)) {
                sb.append(chkMsgEntryConfigureCode).append(";");
            }
            if (!this.isNullString(chkMsgEntryQtyType = this.checkData_entryqtytype(bomentryJsonObject, rowIndex2)) && !"ok".equals(chkMsgEntryQtyType)) {
                sb.append(chkMsgEntryQtyType).append(";");
            }
            if (!this.isNullString(chkMsgQtyValidate = this.checkData_qtyValidate(bomentryJsonObject, rowIndex2)) && !"ok".equals(chkMsgQtyValidate)) {
                sb.append(chkMsgQtyValidate).append(";");
            }
            if (!this.isNullString(chkMsgTransDate = this.checkData_transDate(bomentryJsonObject, rowIndex2)) && !"ok".equals(chkMsgTransDate)) {
                sb.append(chkMsgTransDate).append(";");
            }
            if (!this.isNullString(chkMsgActTime = this.checkData_acttime(bomentryJsonObject, rowIndex2)) && !"ok".equals(chkMsgActTime)) {
                sb.append(chkMsgActTime).append(";");
            }
            if (!this.isNullString(chkMsgEntryvaliddate = this.checkData_entryvaliddate(bomentryJsonObject, rowIndex2)) && !"ok".equals(chkMsgEntryvaliddate)) {
                sb.append(chkMsgEntryvaliddate).append(";");
                continue;
            }
            String chkMsgEntryinvaliddate = this.checkData_entryinvaliddate(bomentryJsonObject, rowIndex2);
            if (!this.isNullString(chkMsgEntryinvaliddate) && !"ok".equals(chkMsgEntryinvaliddate)) {
                sb.append(chkMsgEntryinvaliddate).append(";");
                continue;
            }
            String chkMsgEntryDateValidate = this.checkData_entryDateValidate(bomentryJsonObject, rowIndex2);
            if (!this.isNullString(chkMsgEntryDateValidate) && !"ok".equals(chkMsgEntryDateValidate)) {
                sb.append(chkMsgEntryDateValidate).append(";");
                continue;
            }
            String chkMsgAddMaterial = this.checkData_AddMaterial(bomentryJsonObject, rowIndex2, bomHead);
            if (!this.isNullString(chkMsgAddMaterial) && !"ok".equals(chkMsgAddMaterial)) {
                sb.append(chkMsgAddMaterial).append(";");
                continue;
            }
            String chkMsgWoskStationEntry = this.checkData_WorkStationEntry(paramsJson, pentryJsonObject, bomentryJsonObject, rowIndex2);
            if (!this.isNullString(chkMsgWoskStationEntry) && !"ok".equals(chkMsgWoskStationEntry)) {
                sb.append(chkMsgWoskStationEntry).append(";");
                break;
            }
            String chkMsgSubEntry = this.checkData_SubEntryEntity(paramsJson, pentryJsonObject, bomentryJsonObject, rowIndex2);
            if (!this.isNullString(chkMsgSubEntry) && !"ok".equals(chkMsgSubEntry)) {
                sb.append(chkMsgSubEntry).append(";");
                break;
            }
            String chkMsgsetupEntry = this.checkData_setupEntry(paramsJson, pentryJsonObject, bomentryJsonObject, rowIndex2);
            if (!this.isNullString(chkMsgsetupEntry) && !"ok".equals(chkMsgsetupEntry)) {
                sb.append(chkMsgsetupEntry).append(";");
                break;
            }
            String chkMsgQtyEntry = this.checkData_qtyEntry(paramsJson, pentryJsonObject, bomentryJsonObject, rowIndex2);
            if (this.isNullString(chkMsgQtyEntry) || "ok".equals(chkMsgQtyEntry)) continue;
            sb.append(chkMsgQtyEntry).append(";");
            break;
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return "ok";
    }

    private String checkData_BomCopEntry(JSONObject paramsJson, JSONObject pentryJsonObject, int rowIndex) {
        JSONArray bomCopEntryArray = pentryJsonObject.getJSONArray("copentry");
        if (bomCopEntryArray == null || bomCopEntryArray.isEmpty()) {
            return "ok";
        }
        int bomSize = bomCopEntryArray.size();
        DynamicObject bomHead = this.getPBomByNumber(paramsJson, pentryJsonObject);
        StringBuilder sb = new StringBuilder();
        DynamicObject org = this.getOrg(paramsJson);
        String chkMsg = "";
        for (int j = 0; j < bomSize; ++j) {
            String chkMsgEntryvaliddate;
            String chkMsgActTime;
            String chkMsgQtyValidate;
            String chkMsgEntryVersion;
            DynamicObject entryMaterial;
            DynamicObject materialMft;
            String chkMsgEntryMaterial;
            String chkMsgEntryType;
            int rowIndex2;
            JSONObject bomCopEntryJsonObject = bomCopEntryArray.getJSONObject(j);
            String chkMsgEntryMode = this.checkData_copEntrymode(bomCopEntryJsonObject, rowIndex2 = j + 1);
            if (!this.isNullString(chkMsgEntryMode) && !"ok".equals(chkMsgEntryMode)) {
                sb.append(chkMsgEntryMode).append(";");
            }
            if (!this.isNullString(chkMsgEntryType = this.checkData_copEntryType(bomCopEntryJsonObject, rowIndex2)) && !"ok".equals(chkMsgEntryType)) {
                sb.append(chkMsgEntryType).append(";");
            }
            if (!this.isNullString(chkMsgEntryMaterial = this.checkData_copEntrymaterial(bomCopEntryJsonObject, rowIndex2)) && !"ok".equals(chkMsgEntryMaterial)) {
                sb.append(chkMsgEntryMaterial).append(";");
            }
            if ((materialMft = this.getMaterialMftByBom(null, entryMaterial = this.getCopEntryMaterial(bomCopEntryJsonObject), org)) == null) {
                chkMsg = String.format(ResManager.loadKDString((String)"\u7b2c[%1$s]\u884c\u53d8\u66f4\u5355\u7684\u8054\u526f\u4ea7\u54c1\u5206\u5f55\u7684\u4ea7\u54c1\u7f16\u7801[%2$s]\u5728\u751f\u4ea7\u7ec4\u7ec7[%3$s]\u4e0b\u65e0\u7269\u6599\u751f\u4ea7\u4fe1\u606f.", (String)"EcoChangeBillCreateBusiness_93", (String)"mmc-pdm-business", (Object[])new Object[0]), rowIndex, entryMaterial == null ? "" : entryMaterial.getString("number"), org.getString("number"));
                sb.append(chkMsg).append(";");
            } else if (!materialMft.getBoolean("isjointproduct")) {
                chkMsg = String.format(ResManager.loadKDString((String)"\u7b2c[%1$s]\u884c\u53d8\u66f4\u5355\u7684\u8054\u526f\u4ea7\u54c1\u5206\u5f55\u7684\u4ea7\u54c1\u7f16\u7801[%2$s]\u7684\u751f\u4ea7\u4fe1\u606f\u8bbe\u7f6e\u4e2d\u672a\u52fe\u9009\u3010\u53ef\u8054\u526f\u4ea7\u54c1\u3011.", (String)"EcoChangeBillCreateBusiness_94", (String)"mmc-pdm-business", (Object[])new Object[0]), rowIndex, entryMaterial == null ? "" : entryMaterial.getString("number"));
                sb.append(chkMsg).append(";");
            }
            String chkMsgBomSeq = this.checkData_bomCopSeq(bomCopEntryJsonObject, rowIndex2, bomHead);
            if (!this.isNullString(chkMsgBomSeq) && !"ok".equals(chkMsgBomSeq)) {
                sb.append(chkMsgBomSeq).append(";");
            }
            if (!this.isNullString(chkMsgEntryVersion = this.checkData_copEntryversion(pentryJsonObject, bomCopEntryJsonObject, rowIndex2)) && !"ok".equals(chkMsgEntryVersion)) {
                sb.append(chkMsgEntryVersion).append(";");
            }
            if (!this.isNullString(chkMsgQtyValidate = this.checkData_copEntryQtyValidate(bomCopEntryJsonObject, rowIndex2)) && !"ok".equals(chkMsgQtyValidate)) {
                sb.append(chkMsgQtyValidate).append(";");
            }
            if (!this.isNullString(chkMsgActTime = this.checkData_copActtime(bomCopEntryJsonObject, rowIndex2)) && !"ok".equals(chkMsgActTime)) {
                sb.append(chkMsgActTime).append(";");
            }
            if (!this.isNullString(chkMsgEntryvaliddate = this.checkData_copEntryvaliddate(bomCopEntryJsonObject, rowIndex2)) && !"ok".equals(chkMsgEntryvaliddate)) {
                sb.append(chkMsgEntryvaliddate).append(";");
                continue;
            }
            String chkMsgEntryinvaliddate = this.checkData_copEntryinvaliddate(bomCopEntryJsonObject, rowIndex2);
            if (!this.isNullString(chkMsgEntryinvaliddate) && !"ok".equals(chkMsgEntryinvaliddate)) {
                sb.append(chkMsgEntryinvaliddate).append(";");
                continue;
            }
            String chkMsgEntryDateValidate = this.checkData_copEntryDateValidate(bomCopEntryJsonObject, rowIndex2);
            if (!this.isNullString(chkMsgEntryDateValidate) && !"ok".equals(chkMsgEntryDateValidate)) {
                sb.append(chkMsgEntryDateValidate).append(";");
                continue;
            }
            String chkMsgAddMaterial = this.checkData_CopAddMaterial(bomCopEntryJsonObject, rowIndex2, bomHead);
            if (!this.isNullString(chkMsgAddMaterial) && !"ok".equals(chkMsgAddMaterial)) {
                sb.append(chkMsgAddMaterial).append(";");
                continue;
            }
            String chkMsgOperation = this.checkData_copEntryOperation(bomCopEntryJsonObject, rowIndex2);
            if (this.isNullString(chkMsgOperation) || "ok".equals(chkMsgOperation)) continue;
            sb.append(chkMsgOperation).append(";");
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return "ok";
    }

    private String checkData_WorkStationEntry(JSONObject paramsJson, JSONObject pentryJsonObject, JSONObject bomentryJsonObject, int rowIndex) {
        String chkMsg = "";
        JSONArray workStationEntryArray = bomentryJsonObject.getJSONArray("workstationentry");
        if (workStationEntryArray == null || workStationEntryArray.isEmpty()) {
            return chkMsg;
        }
        int size = workStationEntryArray.size();
        StringBuilder sb = new StringBuilder();
        HashSet<String> repeatSet = new HashSet<String>(16);
        HashMap<Long, BigDecimal> wcMap = new HashMap<Long, BigDecimal>(16);
        BigDecimal fz = this.getEntryQtyNumerator(bomentryJsonObject);
        BigDecimal fm = this.getEntryQtyDenominator(bomentryJsonObject);
        BigDecimal bomQty = MMCUtils.divide((BigDecimal)fz, (BigDecimal)fm);
        for (int j = 0; j < size; ++j) {
            int rowIndex2;
            JSONObject workStationEntryJsonObject = workStationEntryArray.getJSONObject(j);
            String chkMsgWorkCenter = this.checkData_workCenter(workStationEntryJsonObject, rowIndex2 = j + 1);
            if (!this.isNullString(chkMsgWorkCenter) && !"ok".equals(chkMsgWorkCenter)) {
                sb.append(chkMsgWorkCenter).append(";");
                continue;
            }
            String chkMsgWorkStation = this.checkData_workStation(workStationEntryJsonObject, rowIndex2);
            if (!this.isNullString(chkMsgWorkStation) && !"ok".equals(chkMsgWorkStation)) {
                sb.append(chkMsgWorkStation).append(";");
                continue;
            }
            String chkMsgWorkEntryQty = this.checkData_workEntryQty(workStationEntryJsonObject, rowIndex2);
            if (!this.isNullString(chkMsgWorkEntryQty) && !"ok".equals(chkMsgWorkEntryQty)) {
                sb.append(chkMsgWorkEntryQty).append(";");
                continue;
            }
            String workStationNumber = this.getStringValue(workStationEntryJsonObject.get((Object)"workstation"));
            DynamicObject workCenter = this.getWorkCenter(workStationEntryJsonObject);
            DynamicObject workStation = this.getWorkStation(workCenter, workStationNumber);
            if (workStation == null) continue;
            if (!repeatSet.add(workCenter.getLong("id") + "_" + workStation.getLong("id"))) {
                chkMsg = String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\u5de5\u4f4d\u6e05\u5355\u5206\u5f55\u4e2d\uff0c\u5de5\u4f5c\u4e2d\u5fc3\u201c%2$s\u201d\u53ca\u5de5\u4f4d\u7f16\u7801\u201c%3$s\u201d\u5b58\u5728\u91cd\u590d\u9879\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EcoChangeBillCreateBusiness_51", (String)"mmc-pdm-business", (Object[])new Object[0]), rowIndex2, workCenter.getString("number"), workStation.getString("number"));
                sb.append(chkMsg).append(";");
                continue;
            }
            BigDecimal workEntryQty = this.getWorkEntryQty(workStationEntryJsonObject);
            BigDecimal sumQty = (BigDecimal)wcMap.get(workCenter.getLong("id"));
            if (sumQty == null) {
                sumQty = BigDecimal.ZERO;
            }
            if ((sumQty = sumQty.add(workEntryQty)).compareTo(bomQty) > 0) {
                chkMsg = String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\u5de5\u4f4d\u6e05\u5355\u5206\u5f55\u4e2d\uff0c\u5de5\u4f5c\u4e2d\u5fc3\u201c%2$s\u201d\u5bf9\u5e94\u7684\u5de5\u4f4d\u6570\u91cf\u201c%3$s\u201d\u8d85\u8fc7\u4e86BOM\u5206\u5f55\u7684\u5206\u5b50\u6570\u91cf\u201c%4$s\u201d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EcoChangeBillCreateBusiness_52", (String)"mmc-pdm-business", (Object[])new Object[0]), rowIndex2, workCenter.getString("number"), sumQty, bomQty);
                sb.append(chkMsg).append(";");
                continue;
            }
            wcMap.put(workCenter.getLong("id"), sumQty);
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return "ok";
    }

    public String checkData_entrymode(JSONObject bomentryJsonObject, int rowIndex) {
        String filedNumber = "entrymode";
        String chkMsg = "";
        Object obj = bomentryJsonObject.get((Object)filedNumber);
        if (obj == null || !entryModeValueSet.contains(obj.toString())) {
            chkMsg = String.format(ResManager.loadKDString((String)"\u4f20\u5165\u53c2\u6570\u4e2d\uff0c\u7b2c\u201c%1$s\u201d\u884cBOM\u5206\u5f55\u7684\u884c\u6807\u8bc6\u5b57\u6bb5\u201c%2$s\u201d\u4e0d\u7b26\u5408\u6570\u636e\u8981\u6c42\uff1a\u53ea\u5141\u8bb8\u4f20\u5165\u201c\u65b0\u589eA\uff0c\u4fee\u6539C\uff0c\u5931\u6548E\u201d\u7b49\u4e09\u79cd\u7c7b\u578b\u6570\u636e\u3002", (String)"EcoChangeBillCreateBusiness_27", (String)"mmc-pdm-business", (Object[])new Object[0]), rowIndex, obj == null ? "" : obj.toString());
            return chkMsg + " " + this.getMaterialNumber(bomentryJsonObject);
        }
        return "ok";
    }

    private String checkData_entrytype(JSONObject bomentryJsonObject, int rowIndex) {
        String filedNumber = "entrytype";
        String chkMsg = "";
        Object obj = bomentryJsonObject.get((Object)filedNumber);
        if (obj == null || !entryTypeValueSet.contains(obj.toString())) {
            chkMsg = String.format(ResManager.loadKDString((String)"\u4f20\u5165\u53c2\u6570\u4e2d\uff0c\u7b2c\u201c%1$s\u201d\u884cBOM\u5206\u5f55\u7684\u7ec4\u4ef6\u7c7b\u578b\u5b57\u6bb5\u201c%2$s\u201d\u4e0d\u7b26\u5408\u6570\u636e\u8981\u6c42\uff1a\u53ea\u5141\u8bb8\u4f20\u5165\u201c\u5e93\u5b58A\u3001\u9009\u9879\u7c7bB\u201d\u4e24\u79cd\u7c7b\u578b\u6570\u636e\u3002", (String)"EcoChangeBillCreateBusiness_28", (String)"mmc-pdm-business", (Object[])new Object[0]), rowIndex, obj == null ? "" : obj.toString());
            return chkMsg + " " + this.getMaterialNumber(bomentryJsonObject);
        }
        return "ok";
    }

    public String checkData_entrymaterial(JSONObject bomentryJsonObject, int rowIndex) {
        String filedNumber = "entrymaterial";
        String chkMsg = "";
        Object obj = bomentryJsonObject.get((Object)filedNumber);
        chkMsg = this.checkIsMustInput(obj, filedNumber);
        if (!"ok".equals(chkMsg)) {
            return chkMsg;
        }
        String baseEntityName = "bd_material";
        String fieldName = ResManager.loadKDString((String)"\u7ec4\u4ef6\u7f16\u7801", (String)"EcoChangeBillCreateBusiness_29", (String)"mmc-pdm-business", (Object[])new Object[0]);
        chkMsg = this.checkBaseDataIsExists(obj.toString(), baseEntityName, fieldName);
        return chkMsg;
    }

    private String checkData_featuretype(JSONObject bomentryJsonObject, int rowIndex) {
        String filedNumber = "featuretype";
        String chkMsg = "";
        Object obj = bomentryJsonObject.get((Object)filedNumber);
        if (!this.entryTypeIsSelect(bomentryJsonObject)) {
            return "ok";
        }
        chkMsg = this.checkIsMustInput(obj, filedNumber);
        if (!"ok".equals(chkMsg)) {
            return chkMsg;
        }
        String baseEntityName = "mpdm_featuretype";
        String fieldName = ResManager.loadKDString((String)"\u7279\u5f81\u7c7b\u578b", (String)"EcoChangeBillCreateBusiness_30", (String)"mmc-pdm-business", (Object[])new Object[0]);
        chkMsg = this.checkBaseDataIsExists(obj.toString(), baseEntityName, fieldName);
        return chkMsg;
    }

    private String checkData_bomSeq(JSONObject bomentryJsonObject, int rowIndex, DynamicObject bomHead) {
        if (this.isAddMode(bomentryJsonObject)) {
            return "ok";
        }
        String filedNumber = "bomentryseq";
        String chkMsg = "";
        Object obj = bomentryJsonObject.get((Object)filedNumber);
        chkMsg = this.checkIsMustInput(obj, filedNumber);
        if (!"ok".equals(chkMsg)) {
            return chkMsg;
        }
        DynamicObject bom = this.getFullBom(bomHead);
        DynamicObject bomentry = this.getBomEntryIdBySeq(bom, Integer.parseInt(obj.toString()));
        if (bomentry == null) {
            chkMsg = String.format(ResManager.loadKDString((String)"BOM\u7f16\u7801\u201c%1$s\u201d\u7684\u5206\u5f55\u4e2d\u4e0d\u5b58\u5728\u5e8f\u53f7\u4e3a\u201c%2$s\u201d\u7684\u6570\u636e\u3002", (String)"EcoChangeBillCreateBusiness_32", (String)"mmc-pdm-business", (Object[])new Object[0]), bom.getString("number"), obj.toString());
            return chkMsg;
        }
        if ("B".equals(bomentry.getString("entrytype"))) {
            DynamicObject featureType = this.getEntryFeatureType(bomentryJsonObject);
            DynamicObject bomFeatureType = bomentry.getDynamicObject("featuretype");
            if (!featureType.getPkValue().equals(bomFeatureType.getPkValue())) {
                chkMsg = String.format(ResManager.loadKDString((String)"BOM\u7f16\u7801\u201c%1$s\u201d\u4e2d\u5e8f\u53f7\u4e3a\u201c%2$s\u201d\u7684\u5206\u5f55\u6570\u636e\u5bf9\u5e94\u7684\u7279\u5f81\u7c7b\u201c%3$s\u201d\u4e0e\u4f20\u5165\u53c2\u6570\u7684\u7279\u5f81\u7c7b\u201c%4$s\u201d\u4e0d\u4e00\u81f4\u3002", (String)"EcoChangeBillCreateBusiness_67", (String)"mmc-pdm-business", (Object[])new Object[0]), bom.getString("number"), obj.toString(), bomFeatureType.getString("number"), featureType.getString("number"));
                return chkMsg;
            }
        } else {
            DynamicObject entryMaterial = this.getEntryMaterial(bomentryJsonObject);
            Long entryMaterialId = entryMaterial.getLong("id");
            if (!entryMaterialId.equals(bomentry.getDynamicObject("entrymaterialid").getLong("id"))) {
                chkMsg = String.format(ResManager.loadKDString((String)"BOM\u7f16\u7801\u201c%1$s\u201d\u4e2d\u5e8f\u53f7\u4e3a\u201c%2$s\u201d\u7684\u5206\u5f55\u6570\u636e\u5bf9\u5e94\u7684\u7ec4\u4ef6ID\u4e0e\u4f20\u5165\u53c2\u6570\u7684\u7ec4\u4ef6ID\u4e0d\u5339\u914d\u3002", (String)"EcoChangeBillCreateBusiness_33", (String)"mmc-pdm-business", (Object[])new Object[0]), bom.getString("number"), obj.toString());
                return chkMsg;
            }
        }
        return "ok";
    }

    private String checkData_entryversion(JSONObject pentryJsonObject, JSONObject bomentryJsonObject, int rowIndex) {
        String filedNumber = "entryversion";
        String chkMsg = "";
        Object obj = bomentryJsonObject.get((Object)filedNumber);
        if (this.isNullString(obj)) {
            return chkMsg;
        }
        DynamicObject bomType = this.getBomType(pentryJsonObject);
        if (this.bomTypeIsVersion(bomType)) {
            DynamicObject material = this.getEntryMaterial(bomentryJsonObject);
            if (this.getBomVersion(obj.toString(), material) == null) {
                String pmaterialNumber = bomentryJsonObject.getString("entrymaterial");
                chkMsg = String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884cBOM\u5206\u5f55\u4e2d\uff0c\u65e0\u6cd5\u83b7\u53d6\u5230\u7ec4\u4ef6\u7f16\u7801\u201c%2$s\u201d\u53caBOM\u7248\u672c\u53f7\u201c%3$s\u201d\u5bf9\u5e94\u7684\u7248\u672c\u4fe1\u606f\u3002\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"EcoChangeBillCreateBusiness_78", (String)"mmc-pdm-business", (Object[])new Object[0]), rowIndex, pmaterialNumber, obj.toString());
                return chkMsg;
            }
        }
        return "ok";
    }

    private String checkData_entryconfiguredcode(JSONObject paramsJson, JSONObject bomentryJsonObject, int rowIndex) {
        String filedNumber = "entryconfiguredcode";
        String chkMsg = "";
        Object obj = bomentryJsonObject.get((Object)filedNumber);
        if (this.isNullString(obj)) {
            return chkMsg;
        }
        DynamicObject material = this.getEntryMaterial(bomentryJsonObject);
        if (this.getConfigureCode(obj.toString(), material) == null) {
            String pmaterialNumber = bomentryJsonObject.getString("entrymaterial");
            chkMsg = String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884cBOM\u5206\u5f55\u4e2d,\u4f9d\u636e\u7ec4\u4ef6\u7f16\u7801\u201c%2$s\u201d\u53ca\u914d\u7f6e\u53f7\u201c%3$s\u201d\u65e0\u6cd5\u83b7\u53d6\u5230\u5bf9\u5e94\u7684\u914d\u7f6e\u53f7\u57fa\u7840\u8d44\u6599\u4fe1\u606f,\u8bf7\u68c0\u67e5\u6570\u636e", (String)"EcoChangeBillCreateBusiness_34", (String)"mmc-pdm-business", (Object[])new Object[0]), rowIndex, pmaterialNumber, obj.toString());
            return chkMsg;
        }
        return "ok";
    }

    private String checkData_entryqtytype(JSONObject bomentryJsonObject, int rowIndex) {
        String filedNumber = "entryqtytype";
        String chkMsg = "";
        Object obj = bomentryJsonObject.get((Object)filedNumber);
        if (obj == null || !entryQtyTypeValueSet.contains(obj.toString())) {
            chkMsg = String.format(ResManager.loadKDString((String)"\u4f20\u5165\u53c2\u6570\u4e2d\uff0c\u7b2c\u201c%1$s\u201d\u884cBOM\u5206\u5f55\u7684\u7528\u91cf\u7c7b\u578b\u5b57\u6bb5\u201c%2$s\u201d\u4e0d\u7b26\u5408\u6570\u636e\u8981\u6c42\uff1a\u53ea\u5141\u8bb8\u4f20\u5165\u201c\u53d8\u52a8A\u3001\u56fa\u5b9aB\u3001\u9636\u68afC\u201d\u7b49\u4e09\u79cd\u7c7b\u578b\u6570\u636e\u3002", (String)"EcoChangeBillCreateBusiness_35", (String)"mmc-pdm-business", (Object[])new Object[0]), rowIndex, obj == null ? "" : obj.toString());
            return chkMsg + " " + this.getMaterialNumber(bomentryJsonObject);
        }
        return "ok";
    }

    private String checkData_qtyValidate(JSONObject bomentryJsonObject, int rowIndex) {
        String chkMsg = "";
        BigDecimal fz = this.getEntryQtyNumerator(bomentryJsonObject);
        BigDecimal fm = this.getEntryQtyDenominator(bomentryJsonObject);
        BigDecimal entryfixscrap = this.getEntryFixscrap(bomentryJsonObject);
        BigDecimal entryscraprate = this.getEntryScraprate(bomentryJsonObject);
        BigDecimal transQty = this.getTranqty(bomentryJsonObject);
        if (fz.compareTo(BigDecimal.ZERO) < 0) {
            chkMsg = String.format(ResManager.loadKDString((String)"\u4f20\u5165\u53c2\u6570\u4e2d\uff0c\u7b2c\u201c%1$s\u201d\u884cBOM\u5206\u5f55\u7684\u5206\u5b50\u201c%2$s\u201d\u4e0d\u7b26\u5408\u6570\u636e\u8981\u6c42\uff08\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0\uff09\u3002", (String)"EcoChangeBillCreateBusiness_39", (String)"mmc-pdm-business", (Object[])new Object[0]), rowIndex, fz);
            return chkMsg + " " + this.getMaterialNumber(bomentryJsonObject);
        }
        if (fm.compareTo(BigDecimal.ZERO) <= 0) {
            chkMsg = String.format(ResManager.loadKDString((String)"\u4f20\u5165\u53c2\u6570\u4e2d\uff0c\u7b2c\u201c%1$s\u201d\u884cBOM\u5206\u5f55\u7684\u5206\u6bcd\u201c%2$s\u201d\u4e0d\u7b26\u5408\u6570\u636e\u8981\u6c42\uff08\u5fc5\u987b\u5927\u4e8e0\uff09\u3002", (String)"EcoChangeBillCreateBusiness_40", (String)"mmc-pdm-business", (Object[])new Object[0]), rowIndex, fm);
            return chkMsg + " " + this.getMaterialNumber(bomentryJsonObject);
        }
        if (entryfixscrap.compareTo(BigDecimal.ZERO) < 0) {
            chkMsg = String.format(ResManager.loadKDString((String)"\u4f20\u5165\u53c2\u6570\u4e2d\uff0c\u7b2c\u201c%1$s\u201d\u884cBOM\u5206\u5f55\u7684\u56fa\u5b9a\u635f\u8017\u7387\u201c%2$s\u201d\u4e0d\u7b26\u5408\u6570\u636e\u8981\u6c42\uff08\u5fc5\u987b\u5927\u4e8e0\uff09\u3002", (String)"EcoChangeBillCreateBusiness_36", (String)"mmc-pdm-business", (Object[])new Object[0]), rowIndex, entryfixscrap);
            return chkMsg + " " + this.getMaterialNumber(bomentryJsonObject);
        }
        if (entryscraprate.compareTo(BigDecimal.ZERO) < 0 || entryscraprate.compareTo(BigDecimal.ONE) > 0) {
            chkMsg = String.format(ResManager.loadKDString((String)"\u4f20\u5165\u53c2\u6570\u4e2d\uff0c\u7b2c\u201c%1$s\u201d\u884cBOM\u5206\u5f55\u7684\u53d8\u52a8\u635f\u8017\u7387\u201c%2$s\u201d\u8d85\u51fa\u8303\u56f4,\u5fc5\u987b\u5728[0-1)\u8303\u56f4\u5185\u3002", (String)"EcoChangeBillCreateBusiness_37", (String)"mmc-pdm-business", (Object[])new Object[0]), rowIndex, entryscraprate);
            return chkMsg + " " + this.getMaterialNumber(bomentryJsonObject);
        }
        if (transQty.compareTo(BigDecimal.ZERO) < 0) {
            chkMsg = String.format(ResManager.loadKDString((String)"\u4f20\u5165\u53c2\u6570\u4e2d\uff0c\u7b2c\u201c%1$s\u201d\u884cBOM\u5206\u5f55\u7684\u8fc7\u6e21\u6570\u91cf\u201c%2$s\u201d\u4e0d\u7b26\u5408\u6570\u636e\u8981\u6c42\uff08\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0\uff09\u3002", (String)"EcoChangeBillCreateBusiness_79", (String)"mmc-pdm-business", (Object[])new Object[0]), rowIndex, transQty);
            return chkMsg + " " + this.getMaterialNumber(bomentryJsonObject);
        }
        return "ok";
    }

    private String checkData_transDate(JSONObject bomentryJsonObject, int rowIndex) {
        String filedNumber = "transtartdate";
        String chkMsg = "";
        Object obj = bomentryJsonObject.get((Object)filedNumber);
        chkMsg = this.checkLongDateFormat(obj);
        if (!"ok".equals(chkMsg)) {
            String fieldName = String.format(ResManager.loadKDString((String)"BOM\u5206\u5f55\u201c%1$s\u201d\u7684\u5f00\u59cb\u8fc7\u6e21\u65f6\u95f4\u4e3a\uff1a", (String)"EcoChangeBillCreateBusiness_41", (String)"mmc-pdm-business", (Object[])new Object[0]), rowIndex);
            return fieldName + chkMsg;
        }
        return "ok";
    }

    private String checkData_acttime(JSONObject bomentryJsonObject, int rowIndex) {
        String filedNumber = "acttime";
        String chkMsg = "";
        Object obj = bomentryJsonObject.get((Object)filedNumber);
        chkMsg = this.checkIsMustInput(obj, filedNumber);
        if (!"ok".equals(chkMsg)) {
            return chkMsg;
        }
        chkMsg = this.checkLongDateFormat(obj);
        if (!"ok".equals(chkMsg)) {
            String fieldName = String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884cBOM\u5206\u5f55\u7684\u5b9e\u65bd\u65f6\u95f4:", (String)"EcoChangeBillCreateBusiness_42", (String)"mmc-pdm-business", (Object[])new Object[0]), rowIndex);
            return fieldName + chkMsg + " " + this.getMaterialNumber(bomentryJsonObject);
        }
        return "ok";
    }

    private String checkData_entryvaliddate(JSONObject bomentryJsonObject, int rowIndex) {
        String filedNumber = "entryvaliddate";
        String chkMsg = "";
        Object obj = bomentryJsonObject.get((Object)filedNumber);
        chkMsg = this.checkIsMustInput(obj, filedNumber);
        if (!"ok".equals(chkMsg)) {
            return chkMsg;
        }
        chkMsg = this.checkLongDateFormat(obj);
        if (!"ok".equals(chkMsg)) {
            String fieldName = String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u884c\u201dBOM\u5206\u5f55\u7684\u751f\u6548\u65f6\u95f4\u4e3a\u201c%2$s\u201d\u3002", (String)"EcoChangeBillCreateBusiness_43", (String)"mmc-pdm-business", (Object[])new Object[0]), rowIndex);
            return fieldName + chkMsg + " " + this.getMaterialNumber(bomentryJsonObject);
        }
        return "ok";
    }

    private String checkData_entryinvaliddate(JSONObject bomentryJsonObject, int rowIndex) {
        String filedNumber = "entryinvaliddate";
        String chkMsg = "";
        Object obj = bomentryJsonObject.get((Object)filedNumber);
        chkMsg = this.checkIsMustInput(obj, filedNumber);
        if (!"ok".equals(chkMsg)) {
            return chkMsg;
        }
        chkMsg = this.checkLongDateFormat(obj);
        if (!"ok".equals(chkMsg)) {
            String fieldName = String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884cBOM\u5206\u5f55\u7684\u5931\u6548\u65f6\u95f4\u4e3a\u201c%2$s\u201d\u3002", (String)"EcoChangeBillCreateBusiness_44", (String)"mmc-pdm-business", (Object[])new Object[0]), rowIndex);
            return fieldName + chkMsg + " " + this.getMaterialNumber(bomentryJsonObject);
        }
        return "ok";
    }

    private String checkData_entryDateValidate(JSONObject bomentryJsonObject, int rowIndex) {
        String filedNumber = "entryinvaliddate";
        Object obj = bomentryJsonObject.get((Object)filedNumber);
        Date entryinvaliddate = this.getEntryInvalidDate(bomentryJsonObject);
        filedNumber = "entryvaliddate";
        Object obj2 = bomentryJsonObject.get((Object)filedNumber);
        Date entryvaliddate = this.getEntryValidDate(bomentryJsonObject);
        if (entryvaliddate.after(entryinvaliddate)) {
            return String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884cBOM\u5206\u5f55\u7684\u751f\u6548\u65f6\u95f4\u201c%2$s\u201d\u5e94\u5c0f\u4e8e\u7b49\u4e8e\u5931\u6548\u65f6\u95f4\u201c%3$s\u201d\u3002", (String)"EcoChangeBillCreateBusiness_45", (String)"mmc-pdm-business", (Object[])new Object[0]), rowIndex, obj2.toString(), obj.toString());
        }
        return "ok";
    }

    private String checkData_AddMaterial(JSONObject bomentryJsonObject, int rowIndex, DynamicObject pbom) {
        if (pbom != null && this.isAddMode(bomentryJsonObject) && "A".equals(bomentryJsonObject.getString("entrytype"))) {
            DynamicObject entryMaterial = this.getEntryMaterial(bomentryJsonObject);
            if (entryMaterial == null) {
                return "ok";
            }
            DynamicObject bomMaterial = pbom.getDynamicObject("materialid");
            if (entryMaterial.getPkValue().equals(bomMaterial.getPkValue())) {
                return String.format(ResManager.loadKDString((String)"\u4f20\u5165\u53c2\u6570\u4e2d\uff0c\u4e0d\u5141\u8bb8\u7b2c\u201c%1$s\u201d\u884cBOM\u5206\u5f55\u7684\u7269\u6599\u201c%2$s\u201d\u4e0eBOM\u8868\u5934\u7684\u4ea7\u54c1\u76f8\u540c\u3002", (String)"EcoChangeBillCreateBusiness_73", (String)"mmc-pdm-business", (Object[])new Object[0]), rowIndex, entryMaterial.getString("number"));
            }
        }
        return "ok";
    }

    private boolean getEntryIsJumpLevel(JSONObject bomentryJsonObject) {
        return this.getBooleanValue(bomentryJsonObject.get((Object)"entryisjumplevel"));
    }

    private String getEntryRemark(JSONObject bomentryJsonObject) {
        return this.getStringValue(bomentryJsonObject.get((Object)"entryremark"));
    }

    private String getEntryGroupNo(JSONObject bomentryJsonObject) {
        return this.getStringValue(bomentryJsonObject.get((Object)"entrygroupno"));
    }

    private String getEntryRefNo(JSONObject bomentryJsonObject) {
        return this.getStringValue(bomentryJsonObject.get((Object)"entryrefno"));
    }

    private String getEntryProcessSeq(JSONObject bomentryJsonObject) {
        String value = this.getStringValue(bomentryJsonObject.get((Object)"entryprocessseq"));
        if (StringUtils.isEmpty((String)value)) {
            value = "1";
        }
        return value;
    }

    private String getEntryOperationNumber(JSONObject bomentryJsonObject) {
        String value = this.getStringValue(bomentryJsonObject.get((Object)"entryoperationnumber"));
        if (StringUtils.isEmpty((String)value)) {
            value = "10";
        }
        return value;
    }

    private String getEntryMaterialAttr(JSONObject bomentryJsonObject) {
        return this.getStringValue(bomentryJsonObject.get((Object)"entrymaterialattr"));
    }

    private int getEntryLeadTime(JSONObject bomentryJsonObject) {
        return this.getIntValue(bomentryJsonObject.get((Object)"entryleadtime"));
    }

    private Date getEntryInvalidDate(JSONObject bomentryJsonObject) {
        Date entryInValidDate = this.getDate(bomentryJsonObject.get((Object)"entryinvaliddate"));
        if (entryInValidDate == null) {
            entryInValidDate = this.getDate("2999-01-01 00:00:00");
        }
        return entryInValidDate;
    }

    private Date getEntryValidDate(JSONObject bomentryJsonObject) {
        Date entryValidDate = this.getDate(bomentryJsonObject.get((Object)"entryvaliddate"));
        if (entryValidDate == null) {
            entryValidDate = new Date();
        }
        return entryValidDate;
    }

    private Date getTranstartDate(JSONObject bomentryJsonObject) {
        return this.getDate(bomentryJsonObject.get((Object)"transtartdate"));
    }

    private Date getActTime(JSONObject bomentryJsonObject) {
        return this.getDate(bomentryJsonObject.get((Object)"acttime"));
    }

    private BigDecimal getEntryQtyNumerator(JSONObject bomentryJsonObject) {
        return this.getBigDecimalValue(bomentryJsonObject.get((Object)"entryqtynumerator"));
    }

    private BigDecimal getEntryQtyDenominator(JSONObject bomentryJsonObject) {
        return this.getBigDecimalValue(bomentryJsonObject.get((Object)"entryqtydenominator"));
    }

    private BigDecimal getEntryFixscrap(JSONObject bomentryJsonObject) {
        return this.getBigDecimalValue(bomentryJsonObject.get((Object)"entryfixscrap"));
    }

    private BigDecimal getEntryScraprate(JSONObject bomentryJsonObject) {
        return this.getBigDecimalValue(bomentryJsonObject.get((Object)"entryscraprate"));
    }

    private BigDecimal getTranqty(JSONObject bomentryJsonObject) {
        return this.getBigDecimalValue(bomentryJsonObject.get((Object)"tranqty"));
    }

    private boolean isSetpQty(JSONObject bomentryJsonObject) {
        String filedNumber = "entryqtytype";
        return "C".equalsIgnoreCase(bomentryJsonObject.getString(filedNumber));
    }

    private boolean isAddMode(JSONObject bomentryJsonObject) {
        String filedNumber = "entrymode";
        return "A".equalsIgnoreCase(bomentryJsonObject.getString(filedNumber));
    }

    private boolean isEditMode(JSONObject bomentryJsonObject) {
        String filedNumber = "entrymode";
        return "C".equalsIgnoreCase(bomentryJsonObject.getString(filedNumber));
    }

    private DynamicObject getEntryMaterial(JSONObject bomentryJsonObject) {
        String filedNumber = "entrymaterial";
        Object obj = bomentryJsonObject.get((Object)filedNumber);
        String baseEntityName = "bd_material";
        return this.getSingleCacheBaseDataByNumber(obj, baseEntityName);
    }

    private String getMaterialNumber(JSONObject bomentryJsonObject) {
        String filedNumber = "entrymaterial";
        Object obj = bomentryJsonObject.get((Object)filedNumber);
        if (obj == null || "".equals(obj.toString())) {
            filedNumber = "featuretype";
            obj = bomentryJsonObject.get((Object)filedNumber);
        }
        return obj == null ? "" : obj.toString();
    }

    private DynamicObject getEntryFeatureType(JSONObject bomentryJsonObject) {
        String filedNumber = "featuretype";
        Object obj = bomentryJsonObject.get((Object)filedNumber);
        String baseEntityName = "mpdm_featuretype";
        return this.getSingleCacheBaseDataByNumber(obj, baseEntityName);
    }

    private DynamicObject getEntryVersion(JSONObject bomentryJsonObject) {
        String filedNumber = "entryversion";
        Object obj = bomentryJsonObject.get((Object)filedNumber);
        DynamicObject material = this.getEntryMaterial(bomentryJsonObject);
        if (obj == null || material == null) {
            return null;
        }
        return this.getBomVersion(obj.toString(), material);
    }

    private DynamicObject getEntryConfigureCode(JSONObject bomentryJsonObject) {
        String filedNumber = "entryconfiguredcode";
        Object obj = bomentryJsonObject.get((Object)filedNumber);
        DynamicObject material = this.getEntryMaterial(bomentryJsonObject);
        if (obj == null || material == null) {
            return null;
        }
        return this.getConfigureCode(obj.toString(), material);
    }

    private String checkData_entryversioncontrol(JSONObject pentryJsonObject, int rowIndex) {
        String filedNumber = "entryversioncontrol";
        String chkMsg = "";
        Object obj = pentryJsonObject.get((Object)filedNumber);
        if (obj == null || !versionControlValueSet.contains(obj.toString())) {
            chkMsg = String.format(ResManager.loadKDString((String)"\u53c2\u6570\u4e2d\u7684\u7b2c\u201c%1$s\u201d\u884c\u53d8\u66f4\u5355\u4ea7\u54c1\u4fe1\u606f\u5206\u5f55\u7684\u7248\u672c\u63a7\u5236\u5b57\u6bb5\u201c%2$s\u201d\u4e0d\u7b26\u5408\u6570\u636e\u8981\u6c42\uff1a\u53ea\u5141\u8bb8\u4f20\u5165\u201c\u4fee\u6539\u7248\u672cA\u3001\u987a\u5ef6\u7248\u672cB\u3001\u521d\u59cb\u7248\u672cD\u201d\u7b49\u4e09\u79cd\u7c7b\u578b\u6570\u636e\u3002", (String)"EcoChangeBillCreateBusiness_14", (String)"mmc-pdm-business", (Object[])new Object[0]), rowIndex, obj == null ? "" : obj.toString());
            return chkMsg;
        }
        return "ok";
    }

    private boolean isInitVersionControl(JSONObject pentryJsonObject) {
        String filedNumber = "entryversioncontrol";
        return "D".equalsIgnoreCase(pentryJsonObject.getString(filedNumber));
    }

    public String checkData_proentrymaterial(JSONObject paramsJson, JSONObject pentryJsonObject, int rowIndex) {
        String filedNumber = "proentrymaterial";
        String chkMsg = "";
        Object obj = pentryJsonObject.get((Object)filedNumber);
        chkMsg = this.checkIsMustInput(obj, filedNumber);
        if (!"ok".equals(chkMsg)) {
            return chkMsg;
        }
        String baseEntityName = "bd_material";
        String fieldName = ResManager.loadKDString((String)"\u4ea7\u54c1\u7f16\u7801", (String)"EcoChangeBillCreateBusiness_16", (String)"mmc-pdm-business", (Object[])new Object[0]);
        chkMsg = this.checkBaseDataIsExists(obj.toString(), baseEntityName, fieldName);
        if (!"ok".equals(chkMsg)) {
            return chkMsg;
        }
        DynamicObject org = this.getOrg(paramsJson);
        DynamicObject material = this.getPMaterial(pentryJsonObject);
        DynamicObject materialMft = this.getMaterialMftByBom(null, material, org);
        if (materialMft == null) {
            chkMsg = String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201c\u884c\u53d8\u66f4\u5355\u4ea7\u54c1\u4fe1\u606f\u5206\u5f55\u7684\u7269\u6599\u7f16\u7801\u201c%2$s\u201d\u5728\u751f\u4ea7\u7ec4\u7ec7\u201c%3$s\u201d\u4e0b\u65e0\u7269\u6599\u751f\u4ea7\u4fe1\u606f\u3002", (String)"EcoChangeBillCreateBusiness_66", (String)"mmc-pdm-business", (Object[])new Object[0]), rowIndex, material.getString("number"), org.getString("number"));
            return chkMsg;
        }
        if (!materialMft.getBoolean("ismainproduct")) {
            chkMsg = String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\u53d8\u66f4\u5355\u4ea7\u54c1\u4fe1\u606f\u5206\u5f55\u7684\u7269\u6599\u7f16\u7801\u201c%2$s\u201d\u5728\u751f\u4ea7\u7ec4\u7ec7\u201c%3$s\u201d\u4e0b\u7684\u7269\u6599\u751f\u4ea7\u4fe1\u606f\u4e2d\uff0c\u6ca1\u6709\u914d\u7f6e\u201c\u53ef\u4e3b\u4ea7\u54c1\u201d\u3002", (String)"EcoChangeBillCreateBusiness_72", (String)"mmc-pdm-business", (Object[])new Object[0]), rowIndex, material.getString("number"), org.getString("number"));
            return chkMsg;
        }
        return "ok";
    }

    public String checkData_pentrybom(JSONObject paramsJson, JSONObject pentryJsonObject, int rowIndex) {
        String filedNumber = "pentrybom";
        Object obj = pentryJsonObject.get((Object)filedNumber);
        if (!this.isInitVersionControl(pentryJsonObject)) {
            Long changeBomTypeId;
            String chkMsg = this.checkIsMustInput(obj, filedNumber);
            if (!"ok".equals(chkMsg)) {
                return chkMsg;
            }
            chkMsg = this.checkBomIsExists(paramsJson, pentryJsonObject);
            if (!"ok".equals(chkMsg)) {
                return chkMsg;
            }
            DynamicObject bom = this.getPBomByNumber(paramsJson, pentryJsonObject);
            if (bom == null) {
                return "ok";
            }
            Long bomTypeId = bom.getDynamicObject("type").getLong("id");
            if (!bomTypeId.equals(changeBomTypeId = Long.valueOf(this.getBomType(pentryJsonObject).getLong("id")))) {
                chkMsg = String.format(ResManager.loadKDString((String)"\u7b2c[%1$s]\u884c\u53d8\u66f4\u5355\u4ea7\u54c1\u4fe1\u606f\u5206\u5f55\u7684BOM\u5bf9\u5e94\u7684\u7c7b\u578b\u4e0e\u4f20\u5165\u7684BOM\u7c7b\u578b\u4e0d\u4e00\u81f4.", (String)"EcoChangeBillCreateBusiness_31", (String)"mmc-pdm-business", (Object[])new Object[0]), rowIndex);
                return chkMsg;
            }
            DynamicObject org = this.getOrg(paramsJson);
            DynamicObject materialMft = this.getMaterialMftByBom(bom, null, org);
            if (materialMft == null) {
                chkMsg = String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\u53d8\u66f4\u5355\u4ea7\u54c1\u4fe1\u606f\u5206\u5f55\u7684BOM\u7f16\u7801\u201c%2$s\u201d\u5bf9\u5e94\u7684\u7269\u6599\u5728\u751f\u4ea7\u7ec4\u7ec7\u201c%3$s\u201d\u4e0b\u65e0\u7269\u6599\u751f\u4ea7\u4fe1\u606f\u3002", (String)"EcoChangeBillCreateBusiness_65", (String)"mmc-pdm-business", (Object[])new Object[0]), rowIndex, bom.getString("number"), org.getString("number"));
                return chkMsg;
            }
        }
        return "ok";
    }

    private String checkData_pentrynewversion(JSONObject paramsJson, JSONObject pentryJsonObject, int rowIndex) {
        DynamicObject bomType;
        String filedNumber = "pentrynewversion";
        String chkMsg = "";
        Object obj = pentryJsonObject.get((Object)filedNumber);
        if (this.isInitVersionControl(pentryJsonObject) && this.bomTypeIsVersion(bomType = this.getBomType(pentryJsonObject))) {
            chkMsg = this.checkIsMustInput(obj, filedNumber);
            if (!"ok".equals(chkMsg)) {
                return chkMsg;
            }
            DynamicObject material = this.getPMaterial(pentryJsonObject);
            if (this.getBomVersion(obj.toString(), material) == null) {
                String pmaterialNumber = pentryJsonObject.get((Object)"proentrymaterial").toString();
                chkMsg = String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\u53d8\u66f4\u5355\u4ea7\u54c1\u4fe1\u606f\u5206\u5f55,\u4f9d\u636e\u4ea7\u54c1\u7f16\u7801\u201c%2$s\u201d\u53caBOM\u7248\u672c\u53f7\u201c%3$s\u201d\u65e0\u6cd5\u83b7\u53d6\u5230\u5bf9\u5e94\u7684\u7248\u672c\u4fe1\u606f,\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"EcoChangeBillCreateBusiness_22", (String)"mmc-pdm-business", (Object[])new Object[0]), rowIndex, pmaterialNumber, obj.toString());
                return chkMsg;
            }
        }
        return "ok";
    }

    private String checkData_pentryvaliddate(JSONObject paramsJson, JSONObject pentryJsonObject, int rowIndex) {
        String filedNumber = "pentryvaliddate";
        String chkMsg = "";
        Object obj = pentryJsonObject.get((Object)filedNumber);
        chkMsg = this.checkIsMustInput(obj, filedNumber);
        if (!"ok".equals(chkMsg)) {
            return chkMsg;
        }
        chkMsg = this.checkLongDateFormat(obj);
        if (!"ok".equals(chkMsg)) {
            String fieldName = String.format(ResManager.loadKDString((String)"\u7b2c[%1$s]\u884c\u4ea7\u54c1\u5206\u5f55\u7684\u751f\u6548\u65f6\u95f4:", (String)"EcoChangeBillCreateBusiness_80", (String)"mmc-pdm-business", (Object[])new Object[0]), rowIndex);
            return fieldName + chkMsg;
        }
        return "ok";
    }

    private String checkData_ecotype(JSONObject pentryJsonObject, int rowIndex) {
        String filedNumber = "ecotype";
        String chkMsg = "";
        Object obj = pentryJsonObject.get((Object)filedNumber);
        if (!this.isNullString(obj)) {
            String baseEntityName = "pdm_ecotype";
            String fieldName = ResManager.loadKDString((String)"\u53d8\u66f4\u7c7b\u578b", (String)"EcoChangeBillCreateBusiness_23", (String)"mmc-pdm-business", (Object[])new Object[0]);
            chkMsg = this.checkBaseDataIsExists(obj.toString(), baseEntityName, fieldName);
            return chkMsg;
        }
        return "ok";
    }

    private DynamicObject getPNewVersion(JSONObject pentryJsonObject) {
        DynamicObject material = this.getPMaterial(pentryJsonObject);
        String filedNumber = "pentrynewversion";
        Object obj = pentryJsonObject.get((Object)filedNumber);
        return this.getBomVersion(obj.toString(), material);
    }

    private DynamicObject getEcoType(JSONObject pentryJsonObject) {
        String filedNumber = "ecotype";
        Object obj = pentryJsonObject.get((Object)filedNumber);
        String baseEntityName = "pdm_ecotype";
        return this.getSingleCacheBaseDataByNumber(obj, baseEntityName);
    }

    private String checkData_ecnreason(JSONObject pentryJsonObject, int rowIndex) {
        String filedNumber = "pentryecreason";
        String chkMsg = "";
        Object obj = pentryJsonObject.get((Object)filedNumber);
        if (!this.isNullString(obj)) {
            String baseEntityName = "pdm_ecnreason";
            String fieldName = ResManager.loadKDString((String)"\u53d8\u66f4\u539f\u56e0", (String)"EcoChangeBillCreateBusiness_24", (String)"mmc-pdm-business", (Object[])new Object[0]);
            chkMsg = this.checkBaseDataIsExists(obj.toString(), baseEntityName, fieldName);
            return chkMsg;
        }
        return "ok";
    }

    private DynamicObject getEcnReason(JSONObject pentryJsonObject) {
        String filedNumber = "pentryecreason";
        Object obj = pentryJsonObject.get((Object)filedNumber);
        String baseEntityName = "pdm_ecnreason";
        return this.getSingleCacheBaseDataByNumber(obj, baseEntityName);
    }

    private String checkData_bomGroup(JSONObject pentryJsonObject, int rowIndex) {
        String filedNumber = "pentrybomgroup";
        String chkMsg = "";
        Object obj = pentryJsonObject.get((Object)filedNumber);
        if (!this.isNullString(obj) && this.isInitVersionControl(pentryJsonObject)) {
            String baseEntityName = "mpdm_bomgroup";
            String fieldName = ResManager.loadKDString((String)"BOM\u5206\u7ec4", (String)"EcoChangeBillCreateBusiness_25", (String)"mmc-pdm-business", (Object[])new Object[0]);
            chkMsg = this.checkBaseDataIsExists(obj.toString(), baseEntityName, fieldName);
            return chkMsg;
        }
        return "ok";
    }

    private DynamicObject getBomGroup(JSONObject pentryJsonObject) {
        String filedNumber = "pentrybomgroup";
        Object obj = pentryJsonObject.get((Object)filedNumber);
        String baseEntityName = "mpdm_bomgroup";
        return this.getSingleCacheBaseDataByNumber(obj, baseEntityName);
    }

    private BigDecimal getYieldRate(JSONObject pentryJsonObject) {
        String filedNumber = "pentryyieldrate";
        Object obj = pentryJsonObject.get((Object)filedNumber);
        if (!this.isNullString(obj)) {
            BigDecimal yieldRate = new BigDecimal(obj.toString());
            if (yieldRate.compareTo(BigDecimal.ONE) > 0 || yieldRate.compareTo(BigDecimal.ZERO) < 0) {
                return BigDecimal.ONE;
            }
            return yieldRate;
        }
        return BigDecimal.ONE;
    }

    private DynamicObject getBomVersion(String versionNumber, DynamicObject material) {
        if (this.isNullString(versionNumber)) {
            return null;
        }
        if (material == null) {
            return null;
        }
        QFilter qFilter = new QFilter("name", "=", (Object)versionNumber);
        qFilter.and(new QFilter("material", "=", material.getPkValue()));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        String baseEntityName = "bd_bomversion_new";
        String cacheKeyString = baseEntityName + "_" + versionNumber + "_" + material.getPkValue() + "_getBomVersion";
        Map<Object, DynamicObject> dyMap = this.getCacheBaseDataByFilter(qFilter, baseEntityName, "", cacheKeyString);
        DynamicObject dy = null;
        for (Map.Entry<Object, DynamicObject> entrys : dyMap.entrySet()) {
            dy = entrys.getValue();
        }
        return dy;
    }

    private DynamicObject getConfigureCode(String configureCodeNumber, DynamicObject material) {
        if (this.isNullString(configureCodeNumber)) {
            return null;
        }
        if (material == null) {
            return null;
        }
        QFilter qFilter = new QFilter("number", "=", (Object)configureCodeNumber);
        qFilter.and(new QFilter("material", "=", material.getPkValue()));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        String baseEntityName = "bd_configuredcode";
        String cacheKeyString = baseEntityName + "_" + configureCodeNumber + "_" + material.getPkValue() + "_getConfigureCode";
        Map<Object, DynamicObject> dyMap = this.getCacheBaseDataByFilter(qFilter, baseEntityName, "", cacheKeyString);
        DynamicObject dy = null;
        for (Map.Entry<Object, DynamicObject> entrys : dyMap.entrySet()) {
            dy = entrys.getValue();
        }
        return dy;
    }

    public DynamicObject getPMaterial(JSONObject pentryJsonObject) {
        String filedNumber = "proentrymaterial";
        Object obj = pentryJsonObject.get((Object)filedNumber);
        String baseEntityName = "bd_material";
        return this.getSingleCacheBaseDataByNumber(obj, baseEntityName);
    }

    private DynamicObject getPBomByNumber(JSONObject paramsJson, JSONObject pentryJsonObject) {
        String filedNumber = "pentrybom";
        Object obj = pentryJsonObject.get((Object)filedNumber);
        DynamicObject org = this.getOrg(paramsJson);
        Map<Object, DynamicObject> dyMap = this.getMulBomByNumber(obj.toString(), org);
        DynamicObject result = null;
        for (Map.Entry<Object, DynamicObject> entrys : dyMap.entrySet()) {
            result = entrys.getValue();
        }
        return result;
    }

    private Map<Object, DynamicObject> getMulBomByNumber(String bomnumber, DynamicObject org) {
        String selectProperties = "id,number,name,type,createorg,group,material,materialid";
        QFilter qFilter = new QFilter("number", "=", (Object)bomnumber);
        qFilter.and(new QFilter("createorg", "=", org.getPkValue()));
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        String cacheKeyString = "pdm_mftbom_" + bomnumber + "_" + org.getPkValue() + "_getMulBomByNumber";
        return this.getCacheBaseDataByFilter(qFilter, "pdm_mftbom", selectProperties, cacheKeyString);
    }

    public String getFullBomSelectProperties() {
        StringBuilder sf = new StringBuilder();
        sf.append("id,");
        sf.append("number,");
        sf.append("replaceno,");
        sf.append("type,");
        sf.append("type.number,");
        sf.append("type.name,");
        sf.append("status,");
        sf.append("enable,");
        sf.append("ecn,");
        sf.append("iscoproduct,");
        sf.append("isversion,");
        sf.append("version,");
        sf.append("group,");
        sf.append("group.number,");
        sf.append("configuredcode,");
        sf.append("description,");
        sf.append("qtybaseunit,");
        sf.append("yieldrate,");
        sf.append("createorg,");
        sf.append("material,");
        sf.append("materialid,");
        sf.append("auxproperty,");
        sf.append("entry,");
        sf.append("entry.id,");
        sf.append("entry.seq,");
        sf.append("entry.entrytype,");
        sf.append("entry.entrymaterial,");
        sf.append("entry.entrymaterialid,");
        sf.append("entry.featuretype,");
        sf.append("entry.entrymaterialattr,");
        sf.append("entry.entryqty,");
        sf.append("entry.entryunit,");
        sf.append("entry.entryqtytype,");
        sf.append("entry.entryqtynumerator,");
        sf.append("entry.entryqtydenominator,");
        sf.append("entry.entryfixscrap,");
        sf.append("entry.entryscraprate,");
        sf.append("entry.entryremark,");
        sf.append("entry.entryleadtime,");
        sf.append("entry.entryoutlocation,");
        sf.append("entry.entryreplaceplan,");
        sf.append("entry.reppriority,");
        sf.append("entry.entryisreplaceplanmm,");
        sf.append("entry.entryisreplace,");
        sf.append("entry.entrytimeunit,");
        sf.append("entry.entrysupplyorg,");
        sf.append("entry.entrysupplymode,");
        sf.append("entry.entrywarehouse,");
        sf.append("entry.entryiskey,");
        sf.append("entry.entrylocation,");
        sf.append("entry.entryisbackflush,");
        sf.append("entry.entryprocessseq,");
        sf.append("entry.entryoperationnumber,");
        sf.append("entry.entryissuemode,");
        sf.append("entry.entryisbulkmaterial,");
        sf.append("entry.entryisstockalloc,");
        sf.append("entry.entryversion,");
        sf.append("entry.entryauxproperty,");
        sf.append("entry.qtyentry,");
        sf.append("entry.entryisjumplevel,");
        sf.append("entry.entryownertype,");
        sf.append("entry.entryoutorg,");
        sf.append("entry.entryoutwarehouse,");
        sf.append("entry.entryvaliddate,");
        sf.append("entry.entryinvaliddate,");
        sf.append("entry.entryecn,");
        sf.append("entry.entryecn.id,");
        sf.append("entry.entryecn.number,");
        sf.append("entry.entryecn.invaliddate,");
        sf.append("entry.entryecn.validdate,");
        sf.append("entry.entryowner,");
        sf.append("entry.setupentry,");
        sf.append("entry.dateentry,");
        sf.append("entry.entryconfiguredcode,");
        sf.append("entry.configproperties,");
        sf.append("qtyentry.id,");
        sf.append("qtyentry.seq,");
        sf.append("qtyentry.qtyentrymaterial,");
        sf.append("qtyentry.qtyentrybatchstartqty,");
        sf.append("qtyentry.qtyentrybatchendqty,");
        sf.append("qtyentry.qtyentryqtynumerator,");
        sf.append("qtyentry.qtyentryqtydenominator,");
        sf.append("qtyentry.qtyentryisstepfix,");
        sf.append("qtyentry.qtyentryfixscrap,");
        sf.append("qtyentry.qtyentryscraprate,");
        sf.append("copentry.copentrymaterial,");
        sf.append("copentry.copentryvaliddate,");
        sf.append("copentry.copentryinvaliddate,");
        sf.append("copentry.copentrytype,");
        sf.append("copentry.copentryauxproperty,");
        sf.append("copentry.copentryqty,");
        sf.append("copentry.copentryoperation,");
        sf.append("setupentry.id,");
        sf.append("setupentry.seq,");
        sf.append("setupentry.setupentrysetuplocation,");
        sf.append("setupentry.setupentryremark,");
        sf.append("setupentry.setupentryqty, ");
        sf.append("subentryentity.id,");
        sf.append("subentryentity.chararuleno,");
        sf.append("subentryentity.seq, ");
        sf.append("workstationentry.id,");
        sf.append("workstationentry.seq,");
        sf.append("workstationentry.workcenter, ");
        sf.append("workstationentry.workstation, ");
        sf.append("workstationentry.workentryqty ");
        return sf.toString();
    }

    public DynamicObject getFullBom(DynamicObject bomHead) {
        Long bomId = bomHead.getLong("id");
        String keyString = "pdm_mftbom_" + bomId + "_getFullBom";
        DynamicObject bom = this.dynamicObjectCacheMap.get(keyString);
        if (bom == null) {
            bom = BusinessDataServiceHelper.loadSingle((Object)bomId, (String)"pdm_mftbom");
            if (this.dynamicObjectCacheMap == null) {
                this.dynamicObjectCacheMap = new ConcurrentHashMap<String, DynamicObject>();
            }
            if (keyString != null && bom != null) {
                this.dynamicObjectCacheMap.putIfAbsent(keyString, bom);
            }
        }
        return bom;
    }

    public DynamicObject getBomEntryIdBySeq(DynamicObject bom, int seq) {
        if (bom == null || seq == 0) {
            return null;
        }
        DynamicObjectCollection coll = bom.getDynamicObjectCollection("entry");
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject entry = (DynamicObject)coll.get(i);
            if (entry.getInt("seq") != seq) continue;
            return entry;
        }
        return null;
    }

    private boolean bomTypeIsVersion(DynamicObject bomType) {
        return bomType.getBoolean("isversion");
    }

    private boolean bomTypeIsInsloc(DynamicObject bomType) {
        return bomType.getBoolean("isinsloc");
    }

    private DynamicObject getBomType(JSONObject pentryJsonObject) {
        String filedNumber = "bomtype";
        Object obj = pentryJsonObject.get((Object)filedNumber);
        String baseEntityName = "mpdm_bomtype";
        return this.getSingleCacheBaseDataByNumber(obj, baseEntityName);
    }

    private String checkData_Createtime(JSONObject paramsJson) {
        String filedNumber = "createtime";
        Object obj = paramsJson.get((Object)filedNumber);
        String chkMsg = this.checkLongDateFormat(obj);
        if (!"ok".equals(chkMsg)) {
            String fieldName = ResManager.loadKDString((String)"\u521b\u5efa\u65e5\u671f:", (String)"EcoChangeBillCreateBusiness_12", (String)"mmc-pdm-business", (Object[])new Object[0]);
            return fieldName + chkMsg;
        }
        return "ok";
    }

    private String checkData_Creator(JSONObject paramsJson) {
        String filedNumber = "creator";
        Object obj = paramsJson.get((Object)filedNumber);
        String chkMsg = this.checkIsMustInput(obj, filedNumber);
        if (!"ok".equals(chkMsg)) {
            return chkMsg;
        }
        String baseEntityName = "bos_user";
        String fieldName = ResManager.loadKDString((String)"\u5236\u5355\u4eba", (String)"EcoChangeBillCreateBusiness_10", (String)"mmc-pdm-business", (Object[])new Object[0]);
        chkMsg = this.checkBaseDataIsExists(obj.toString(), baseEntityName, fieldName);
        return chkMsg;
    }

    private DynamicObject getCreator(JSONObject paramsJson) {
        String filedNumber = "creator";
        Object obj = paramsJson.get((Object)filedNumber);
        String baseEntityName = "bos_user";
        return this.getSingleCacheBaseDataByNumber(obj, baseEntityName);
    }

    private Date getCreateDate(JSONObject paramsJson) {
        String filedNumber = "createtime";
        Object obj = paramsJson.get((Object)filedNumber);
        Date date = this.getDate(obj);
        if (date == null) {
            date = new Date();
        }
        return date;
    }

    private String checkData_BomType(JSONObject pentryJsonObject) {
        String filedNumber = "bomtype";
        Object obj = pentryJsonObject.get((Object)filedNumber);
        String chkMsg = this.checkIsMustInput(obj, filedNumber);
        if (!"ok".equals(chkMsg)) {
            return chkMsg;
        }
        String baseEntityName = "mpdm_bomtype";
        String fieldName = ResManager.loadKDString((String)"BOM\u7c7b\u578b", (String)"EcoChangeBillCreateBusiness_08", (String)"mmc-pdm-business", (Object[])new Object[0]);
        chkMsg = this.checkBaseDataIsExists(obj.toString(), baseEntityName, fieldName);
        return chkMsg;
    }

    private String checkData_Name(JSONObject paramsJson) {
        String filedNumber = "name";
        Object obj = paramsJson.get((Object)filedNumber);
        return this.checkIsMustInput(obj, filedNumber);
    }

    public String checkData_org(JSONObject paramsJson) {
        String filedNumber = "org";
        Object obj = paramsJson.get((Object)filedNumber);
        String chkMsg = this.checkIsMustInput(obj, filedNumber);
        if (!"ok".equals(chkMsg)) {
            return chkMsg;
        }
        String baseEntityName = "bos_org";
        String fieldName = ResManager.loadKDString((String)"\u53d8\u66f4\u7ec4\u7ec7", (String)"EcoChangeBillCreateBusiness_04", (String)"mmc-pdm-business", (Object[])new Object[0]);
        chkMsg = this.checkBaseDataIsExists(obj.toString(), baseEntityName, fieldName);
        return chkMsg;
    }

    public DynamicObject getOrg(JSONObject paramsJson) {
        String filedNumber = "org";
        Object obj = paramsJson.get((Object)filedNumber);
        String baseEntityName = "bos_org";
        return this.getSingleCacheBaseDataByNumber(obj, baseEntityName);
    }

    private String checkData_billno(JSONObject paramsJson) {
        String filedNumber = "billno";
        Object obj = paramsJson.get((Object)filedNumber);
        if (!this.isNullString(obj)) {
            StringBuilder sb = new StringBuilder();
            sb.append("select fid from t_pdm_bom_eco where fbillno = ?");
            boolean isExistsOthers = false;
            try (DataSet ds = DB.queryDataSet((String)this.getAlgoxKeyString("checkData_billno"), (DBRoute)scmDBRoute, (String)sb.toString(), (Object[])new Object[]{obj.toString()});){
                for (Row row : ds) {
                    isExistsOthers = true;
                }
            }
            if (isExistsOthers) {
                return String.format(ResManager.loadKDString((String)"\u4f20\u5165\u53c2\u6570\u4e2d,\u5355\u636e\u53f7\u201c%1$s\u201d\u5df2\u7ecf\u5728\u7cfb\u7edf\u4e2d\u5b58\u5728\u5de5\u7a0b\u53d8\u66f4\u5355\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EcoChangeBillCreateBusiness_09", (String)"mmc-pdm-business", (Object[])new Object[0]), obj.toString());
            }
        }
        return "ok";
    }

    private String getBillStatus(JSONObject paramsJson) {
        return "A";
    }

    private String getBillNo(JSONObject paramsJson, DynamicObject bill) {
        String filedNumber = "billno";
        Object obj = paramsJson.get((Object)filedNumber);
        if (!this.isNullString(obj)) {
            return obj.toString();
        }
        DynamicObject org = this.getOrg(paramsJson);
        ORM orm = ORM.create();
        CodeRuleInfo codeRuleInfo = CodeRuleServiceHelper.getCodeRule((String)"pdm_bom_eco", (DynamicObject)bill, (String)String.valueOf(org.getPkValue()));
        return codeRuleInfo == null ? "AUTO_" + orm.genLongId("pdm_bom_eco") : CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRuleInfo, (DynamicObject)bill);
    }

    @Override
    public String getAlgoxKeyString(String paramString) {
        return EcoChangeBillCreateBusiness.class.getName() + "_" + paramString;
    }

    public String checkBaseDataIsExists(String number, String baseEntityName, String fieldName) {
        Map<Object, DynamicObject> dyMap = this.getCacheBaseDataByNumber(number, baseEntityName, "");
        if (dyMap == null || dyMap.isEmpty()) {
            return String.format(ResManager.loadKDString((String)"\u4f20\u5165\u53c2\u6570\u4e2d\uff0c\u5b57\u6bb5:%1$s \u4f9d\u636e\u7f16\u7801\u201c%2$s\u201d\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u7684\u57fa\u7840\u8d44\u6599\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"EcoChangeBillCreateBusiness_05", (String)"mmc-pdm-business", (Object[])new Object[0]), fieldName, number);
        }
        if (dyMap.size() > 1) {
            return String.format(ResManager.loadKDString((String)"\u4f20\u5165\u53c2\u6570\u4e2d\uff0c\u5b57\u6bb5\uff1a\u201c%1$s\u201d\uff0c\u4f9d\u636e\u7f16\u7801\u201c%2$s\u201d\uff0c\u627e\u5230\u591a\u4e2a\u57fa\u7840\u8d44\u6599\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"EcoChangeBillCreateBusiness_06", (String)"mmc-pdm-business", (Object[])new Object[0]), fieldName, number);
        }
        if ("bos_org".equals(baseEntityName)) {
            for (Map.Entry<Object, DynamicObject> entrys : dyMap.entrySet()) {
                if (entrys.getValue().getBoolean("fisproduce")) continue;
                return String.format(ResManager.loadKDString((String)"\u4f20\u5165\u53c2\u6570\u4e2d,\u5b57\u6bb5:\u201c%1$s\u201d ,\u7f16\u7801\u201c%2$s\u201d\u5bf9\u5e94\u7684\u7ec4\u7ec7\u4e0d\u662f\u751f\u4ea7\u7ec4\u7ec7\u3002", (String)"EcoChangeBillCreateBusiness_07", (String)"mmc-pdm-business", (Object[])new Object[0]), fieldName, number);
            }
        }
        return "ok";
    }

    public String checkBomIsExists(JSONObject paramsJson, JSONObject pentryJsonObject) {
        String filedNumber = "pentrybom";
        Object obj = pentryJsonObject.get((Object)filedNumber);
        DynamicObject org = this.getOrg(paramsJson);
        Map<Object, DynamicObject> dyMap = this.getMulBomByNumber(obj.toString(), org);
        if (dyMap == null || dyMap.isEmpty()) {
            return String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u627e\u5230\u5df2\u5ba1\u6838\u7684BOM\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u4f20\u5165\u53c2\u6570\u4e2d\u7684BOM\u7f16\u7801\u201c%1$s\u201d\u548c\u521b\u5efa\u7ec4\u7ec7\u201c%2$s\u201d\u3002", (String)"EcoChangeBillCreateBusiness_63", (String)"mmc-pdm-business", (Object[])new Object[0]), obj.toString(), org.getString("number"));
        }
        if (dyMap.size() > 1) {
            return String.format(ResManager.loadKDString((String)"\u4f20\u5165\u53c2\u6570\u4e2d,\u4f9d\u636eBOM\u7f16\u7801\u201c%1$\u201d\u53ca\u521b\u5efa\u7ec4\u7ec7\u201c%2$s\u201d\u627e\u5230\u4e86\u591a\u4e2a\u5df2\u5ba1\u6838\u53ef\u4ee5\u7684BOM\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"EcoChangeBillCreateBusiness_64", (String)"mmc-pdm-business", (Object[])new Object[0]), obj.toString(), org.getString("number"));
        }
        return "ok";
    }

    public String checkIsMustInput(Object obj, String filedNumber) {
        if (obj == null) {
            return String.format(ResManager.loadKDString((String)"\u4f20\u5165\u53c2\u6570\u4e2d,\u5b57\u6bb5:%1$s \u4e3a\u5fc5\u5f55\u3002", (String)"EcoChangeBillCreateBusiness_03", (String)"mmc-pdm-business", (Object[])new Object[0]), filedNumber);
        }
        if (obj instanceof Integer && Integer.parseInt(obj.toString()) == 0) {
            return String.format(ResManager.loadKDString((String)"\u4f20\u5165\u53c2\u6570\u4e2d,\u5b57\u6bb5:%1$s \u4e3a\u5fc5\u5f55\u3002", (String)"EcoChangeBillCreateBusiness_03", (String)"mmc-pdm-business", (Object[])new Object[0]), filedNumber);
        }
        return "ok";
    }

    private String checkData_workCenter(JSONObject workStationEntryJsonObject, int rowIndex) {
        String filedNumber = "workcenter";
        String chkMsg = "";
        Object obj = workStationEntryJsonObject.get((Object)filedNumber);
        chkMsg = this.checkIsMustInput(obj, filedNumber);
        if (!"ok".equals(chkMsg)) {
            return chkMsg;
        }
        String baseEntityName = "mpdm_workcentre";
        String fieldName = ResManager.loadKDString((String)"\u5de5\u4f5c\u4e2d\u5fc3", (String)"EcoChangeBillCreateBusiness_47", (String)"mmc-pdm-business", (Object[])new Object[0]);
        chkMsg = this.checkBaseDataIsExists(obj.toString(), baseEntityName, fieldName);
        return chkMsg;
    }

    private DynamicObject getWorkStation(DynamicObject workCenter, String workStationNumber) {
        if (this.isNullString(workStationNumber)) {
            return null;
        }
        if (workCenter == null) {
            return null;
        }
        QFilter qFilter = new QFilter("number", "=", (Object)workStationNumber);
        qFilter.and(new QFilter("workcenter", "=", workCenter.getPkValue()));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        String baseEntityName = "mpdm_workstation";
        String cacheKeyString = baseEntityName + "_" + workCenter.getPkValue() + "_" + workStationNumber + "_getWorkStation";
        Map<Object, DynamicObject> dyMap = this.getCacheBaseDataByFilter(qFilter, baseEntityName, "", cacheKeyString);
        DynamicObject dy = null;
        for (Map.Entry<Object, DynamicObject> entrys : dyMap.entrySet()) {
            dy = entrys.getValue();
        }
        return dy;
    }

    private DynamicObject getWorkCenter(JSONObject workStationEntryJsonObject) {
        String filedNumber = "workcenter";
        Object obj = workStationEntryJsonObject.get((Object)filedNumber);
        String baseEntityName = "mpdm_workcentre";
        return this.getSingleCacheBaseDataByNumber(obj, baseEntityName);
    }

    private String checkData_workStation(JSONObject workStationEntryJsonObject, int rowIndex) {
        String filedNumber = "workstation";
        String chkMsg = "";
        Object obj = workStationEntryJsonObject.get((Object)filedNumber);
        chkMsg = this.checkIsMustInput(obj, filedNumber);
        if (!"ok".equals(chkMsg)) {
            return chkMsg;
        }
        DynamicObject workCenter = this.getWorkCenter(workStationEntryJsonObject);
        DynamicObject workStation = this.getWorkStation(workCenter, obj.toString());
        if (workStation == null) {
            String pmaterialNumber = workStationEntryJsonObject.getString("workcenter");
            chkMsg = String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\u5de5\u4f4d\u6e05\u5355\u5206\u5f55\u4e2d\uff0c\u65e0\u6cd5\u83b7\u53d6\u5de5\u4f5c\u4e2d\u5fc3\u201c%2$s\u201d\u548c\u5de5\u4f4d\u7f16\u7801\u201c%3$s\u201d\u7684\u57fa\u7840\u8d44\u6599\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EcoChangeBillCreateBusiness_48", (String)"mmc-pdm-business", (Object[])new Object[0]), rowIndex, pmaterialNumber, obj.toString());
            return chkMsg;
        }
        return "ok";
    }

    private BigDecimal getWorkEntryQty(JSONObject workStationEntryJsonObject) {
        return this.getBigDecimalValue(workStationEntryJsonObject.get((Object)"workentryqty"));
    }

    private String checkData_workEntryQty(JSONObject workStationEntryJsonObject, int rowIndex) {
        String chkMsg = "";
        BigDecimal qty = this.getWorkEntryQty(workStationEntryJsonObject);
        if (qty.compareTo(BigDecimal.ZERO) <= 0) {
            chkMsg = String.format(ResManager.loadKDString((String)"\u4f20\u5165\u53c2\u6570\u4e2d\uff0c\u7b2c\u201c%1$s\u201d\u884cBOM\u5de5\u4f4d\u6e05\u5355\u5206\u5f55\u7684\u6570\u91cf\u201c%2$s\u201d\u5e94\u5927\u4e8e\u7b49\u4e8e0\u3002", (String)"EcoChangeBillCreateBusiness_49", (String)"mmc-pdm-business", (Object[])new Object[0]), rowIndex, qty);
            return chkMsg;
        }
        return chkMsg;
    }

    private String checkData_SubEntryEntity(JSONObject paramsJson, JSONObject pentryJsonObject, JSONObject bomentryJsonObject, int rowIndex) {
        String chkMsg = "";
        JSONArray subEntryArray = bomentryJsonObject.getJSONArray("subentryentity");
        if (subEntryArray == null || subEntryArray.isEmpty()) {
            return chkMsg;
        }
        int size = subEntryArray.size();
        StringBuilder sb = new StringBuilder();
        HashSet<String> repeatSet = new HashSet<String>(16);
        for (int j = 0; j < size; ++j) {
            int rowIndex2;
            JSONObject subEntryJsonObject = subEntryArray.getJSONObject(j);
            String chkMsgChaeaRuleNo = this.checkData_chararuleno(subEntryJsonObject, rowIndex2 = j + 1);
            if (!this.isNullString(chkMsgChaeaRuleNo) && !"ok".equals(chkMsgChaeaRuleNo)) {
                sb.append(chkMsgChaeaRuleNo).append(";");
                continue;
            }
            DynamicObject chararRuleNo = this.getCharaRuleNo(subEntryJsonObject);
            if (repeatSet.add(chararRuleNo.getPkValue() + "")) continue;
            chkMsg = String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\u914d\u7f6e\u89c4\u5219\u5206\u5f55\u4e2d\uff0c\u914d\u7f6e\u89c4\u5219\u7f16\u7801\u201c%2$s\u201d\u5b58\u5728\u91cd\u590d\u9879\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"EcoChangeBillCreateBusiness_53", (String)"mmc-pdm-business", (Object[])new Object[0]), rowIndex2, chararRuleNo.getString("number"));
            sb.append(chkMsg).append(";");
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return "ok";
    }

    private String checkData_chararuleno(JSONObject subEntryJsonObject, int rowIndex) {
        String filedNumber = "chararuleno";
        String chkMsg = "";
        Object obj = subEntryJsonObject.get((Object)filedNumber);
        chkMsg = this.checkIsMustInput(obj, filedNumber);
        if (!"ok".equals(chkMsg)) {
            return chkMsg;
        }
        String baseEntityName = "pdm_chararule";
        String fieldName = ResManager.loadKDString((String)"\u914d\u7f6e\u89c4\u5219", (String)"EcoChangeBillCreateBusiness_50", (String)"mmc-pdm-business", (Object[])new Object[0]);
        chkMsg = this.checkBaseDataIsExists(obj.toString(), baseEntityName, fieldName);
        return chkMsg;
    }

    private DynamicObject getCharaRuleNo(JSONObject subEntryJsonObject) {
        String filedNumber = "chararuleno";
        Object obj = subEntryJsonObject.get((Object)filedNumber);
        String baseEntityName = "pdm_chararule";
        return this.getSingleCacheBaseDataByNumber(obj, baseEntityName);
    }

    private String checkData_qtyEntry(JSONObject paramsJson, JSONObject pentryJsonObject, JSONObject bomentryJsonObject, int rowIndex) {
        String chkMsg = "";
        JSONArray qtyEntryArray = bomentryJsonObject.getJSONArray("qtyentry");
        if (qtyEntryArray == null || qtyEntryArray.isEmpty()) {
            return chkMsg;
        }
        if (!this.isSetpQty(bomentryJsonObject)) {
            return chkMsg;
        }
        int size = qtyEntryArray.size();
        StringBuilder sb = new StringBuilder();
        for (int j = 0; j < size; ++j) {
            int rowIndex2;
            JSONObject qtyEntryJsonObject = qtyEntryArray.getJSONObject(j);
            String chkMsgQtyValidate = this.checkData_qtyEntryQtyValidate(qtyEntryJsonObject, rowIndex2 = j + 1);
            if (this.isNullString(chkMsgQtyValidate) || "ok".equals(chkMsgQtyValidate)) continue;
            sb.append(chkMsgQtyValidate).append(";");
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return "ok";
    }

    private BigDecimal getQtyEntryBatchStartQty(JSONObject qtyEntryJsonObject) {
        return this.getBigDecimalValue(qtyEntryJsonObject.get((Object)"qtyentrybatchstartqty"));
    }

    private BigDecimal getQtyEntryBatchEndQty(JSONObject qtyEntryJsonObject) {
        return this.getBigDecimalValue(qtyEntryJsonObject.get((Object)"qtyentrybatchendqty"));
    }

    private BigDecimal getQtyEntryQtyNumerator(JSONObject qtyEntryJsonObject) {
        return this.getBigDecimalValue(qtyEntryJsonObject.get((Object)"qtyentryqtynumerator"));
    }

    private BigDecimal getQtyEntryQtyDenominator(JSONObject qtyEntryJsonObject) {
        return this.getBigDecimalValue(qtyEntryJsonObject.get((Object)"qtyentryqtydenominator"));
    }

    private BigDecimal getQtyEntryFixscrap(JSONObject qtyEntryJsonObject) {
        return this.getBigDecimalValue(qtyEntryJsonObject.get((Object)"qtyentryfixscrap"));
    }

    private BigDecimal getQtyEntryScrapRate(JSONObject qtyEntryJsonObject) {
        return this.getBigDecimalValue(qtyEntryJsonObject.get((Object)"qtyentryscraprate"));
    }

    private boolean getQtyEntryIsStepFix(JSONObject qtyEntryJsonObject) {
        return this.getBooleanValue(qtyEntryJsonObject.get((Object)"qtyentryisstepfix"));
    }

    private String checkData_qtyEntryQtyValidate(JSONObject qtyEntryJsonObject, int rowIndex) {
        String chkMsg = "";
        BigDecimal fz = this.getQtyEntryQtyNumerator(qtyEntryJsonObject);
        BigDecimal fm = this.getQtyEntryQtyDenominator(qtyEntryJsonObject);
        BigDecimal entryfixscrap = this.getQtyEntryFixscrap(qtyEntryJsonObject);
        BigDecimal entryscraprate = this.getQtyEntryScrapRate(qtyEntryJsonObject);
        BigDecimal startQty = this.getQtyEntryBatchStartQty(qtyEntryJsonObject);
        BigDecimal endQty = this.getQtyEntryBatchEndQty(qtyEntryJsonObject);
        if (fz.compareTo(BigDecimal.ZERO) < 0) {
            chkMsg = String.format(ResManager.loadKDString((String)"\u4f20\u5165\u53c2\u6570\u4e2d\uff0c\u7b2c\u201c%1$s\u201d\u884c\u9636\u68af\u7528\u91cf\u5206\u5f55\u7684\u5206\u5b50\u201c%2$s\u201d\u4e0d\u7b26\u5408\u6570\u636e\u8981\u6c42\uff08\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0\uff09\u3002", (String)"EcoChangeBillCreateBusiness_54", (String)"mmc-pdm-business", (Object[])new Object[0]), rowIndex, fz);
            return chkMsg;
        }
        if (fm.compareTo(BigDecimal.ZERO) <= 0) {
            chkMsg = String.format(ResManager.loadKDString((String)"\u4f20\u5165\u53c2\u6570\u4e2d\uff0c\u7b2c\u201c%1$s\u201d\u884c\u9636\u68af\u7528\u91cf\u5206\u5f55\u7684\u5206\u6bcd\u201c%2$s\u201d\u4e0d\u7b26\u5408\u6570\u636e\u8981\u6c42(\u5fc5\u987b\u5927\u4e8e0)\u3002", (String)"EcoChangeBillCreateBusiness_55", (String)"mmc-pdm-business", (Object[])new Object[0]), rowIndex, fm);
            return chkMsg;
        }
        if (entryfixscrap.compareTo(BigDecimal.ZERO) < 0) {
            chkMsg = String.format(ResManager.loadKDString((String)"\u4f20\u5165\u53c2\u6570\u4e2d\uff0c\u7b2c\u201c%1$s\u201d\u884c\u9636\u68af\u7528\u91cf\u5206\u5f55\u7684\u56fa\u5b9a\u635f\u8017\u7387\u201c%2$s\u201d\u4e0d\u7b26\u5408\u6570\u636e\u8981\u6c42\uff08\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0\uff09\u3002", (String)"EcoChangeBillCreateBusiness_56", (String)"mmc-pdm-business", (Object[])new Object[0]), rowIndex, entryfixscrap);
            return chkMsg;
        }
        if (entryscraprate.compareTo(BigDecimal.ZERO) < 0 || entryscraprate.compareTo(BigDecimal.ONE) > 0) {
            chkMsg = String.format(ResManager.loadKDString((String)"\u4f20\u5165\u53c2\u6570\u4e2d\uff0c\u7b2c\u201c%1$s\u201d\u884cBOM\u5206\u5f55\u7684\u53d8\u52a8\u635f\u8017\u7387\u201c%2$s\u201d\u8d85\u51fa\u8303\u56f4,\u5fc5\u987b\u5728[0-1)\u8303\u56f4\u5185\u3002", (String)"EcoChangeBillCreateBusiness_57", (String)"mmc-pdm-business", (Object[])new Object[0]), rowIndex, entryscraprate);
            return chkMsg;
        }
        if (startQty.compareTo(BigDecimal.ZERO) < 0) {
            chkMsg = String.format(ResManager.loadKDString((String)"\u4f20\u5165\u53c2\u6570\u4e2d\uff0c\u7b2c\u201c%1$s\u201d\u884c\u9636\u68af\u7528\u91cf\u5206\u5f55\u7684\u6279\u91cf\u6570\u91cf\u201c%2$s\u201d\u4e0d\u7b26\u5408\u6570\u636e\u8981\u6c42\uff08\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0\uff09\u3002", (String)"EcoChangeBillCreateBusiness_58", (String)"mmc-pdm-business", (Object[])new Object[0]), rowIndex, startQty);
            return chkMsg;
        }
        if (endQty.compareTo(BigDecimal.ZERO) < 0) {
            chkMsg = String.format(ResManager.loadKDString((String)"\u4f20\u5165\u53c2\u6570\u4e2d\uff0c\u7b2c\u201c%1$s\u201d\u884c\u9636\u68af\u7528\u91cf\u5206\u5f55\u7684\u6279\u91cf\u6570\u91cf\u201c%2$s\u201d\u4e0d\u7b26\u5408\u6570\u636e\u8981\u6c42\uff08\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0\uff09\u3002", (String)"EcoChangeBillCreateBusiness_59", (String)"mmc-pdm-business", (Object[])new Object[0]), rowIndex, endQty);
            return chkMsg;
        }
        return "ok";
    }

    private String checkData_setupEntry(JSONObject paramsJson, JSONObject pentryJsonObject, JSONObject bomentryJsonObject, int rowIndex) {
        String chkMsg = "";
        JSONArray setupEntryArray = bomentryJsonObject.getJSONArray("setupentry");
        if (setupEntryArray == null || setupEntryArray.isEmpty()) {
            return chkMsg;
        }
        DynamicObject bomType = this.getBomType(pentryJsonObject);
        if (!this.bomTypeIsInsloc(bomType)) {
            return chkMsg;
        }
        int size = setupEntryArray.size();
        StringBuilder sb = new StringBuilder();
        HashSet<String> repeatSet = new HashSet<String>(16);
        for (int j = 0; j < size; ++j) {
            int rowIndex2;
            JSONObject setupEntryJsonObject = setupEntryArray.getJSONObject(j);
            String chkMsgQtyValidate = this.checkData_setupEntryQtyValidate(setupEntryJsonObject, rowIndex2 = j + 1);
            if (!this.isNullString(chkMsgQtyValidate) && !"ok".equals(chkMsgQtyValidate)) {
                sb.append(chkMsgQtyValidate).append(";");
                continue;
            }
            String location = this.getSetupEntrySetupLocation(setupEntryJsonObject);
            if (location == null || "".equals(location)) {
                chkMsg = String.format(ResManager.loadKDString((String)"\u201c\u5b89\u88c5\u4f4d\u7f6e\u201d\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u4f20\u5165\u53c2\u6570\u4e2d\u7b2c\u201c%1$s\u201d\u884c\u5b89\u88c5\u4f4d\u7f6e\u3002", (String)"EcoChangeBillCreateBusiness_61", (String)"mmc-pdm-business", (Object[])new Object[0]), rowIndex);
                sb.append(chkMsg).append(";");
                continue;
            }
            if (repeatSet.add(location)) continue;
            chkMsg = String.format(ResManager.loadKDString((String)"\u4f20\u5165\u53c2\u6570\u4e2d,\u7b2c\u201c%1$s\u201d\u884c\u5b89\u88c5\u4f4d\u7f6e\u5206\u5f55\u7684\u5b89\u88c5\u4f4d\u7f6e\u201c%2$s\u201d\u6570\u636e\u5b58\u5728\u91cd\u590d\u3002", (String)"EcoChangeBillCreateBusiness_62", (String)"mmc-pdm-business", (Object[])new Object[0]), rowIndex, location);
            sb.append(chkMsg).append(";");
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return "ok";
    }

    private String checkData_setupEntryQtyValidate(JSONObject setupEntryJsonObject, int rowIndex) {
        String chkMsg = "";
        BigDecimal qty = this.getSetupEntryQty(setupEntryJsonObject);
        if (qty.compareTo(BigDecimal.ZERO) <= 0) {
            chkMsg = String.format(ResManager.loadKDString((String)"\u4f20\u5165\u53c2\u6570\u4e2d\uff0c\u7b2c\u201c%1$s\u201d\u884c\u5b89\u88c5\u4f4d\u7f6e\u5206\u5f55\u7684\u7ec4\u4ef6\u6570\u91cf\u201c%2$s\u201d\u4e0d\u7b26\u5408\u6570\u636e\u8981\u6c42\uff08\u5fc5\u987b\u5927\u4e8e0\uff09\u3002", (String)"EcoChangeBillCreateBusiness_60", (String)"mmc-pdm-business", (Object[])new Object[0]), rowIndex, qty);
            return chkMsg;
        }
        return "ok";
    }

    private BigDecimal getSetupEntryQty(JSONObject setupEntryJsonObject) {
        return this.getBigDecimalValue(setupEntryJsonObject.get((Object)"setupentryqty"));
    }

    private String getSetupEntrySetupLocation(JSONObject setupEntryJsonObject) {
        return this.getStringValue(setupEntryJsonObject.get((Object)"setupentrysetuplocation"));
    }

    private String getSetupEntryRemark(JSONObject setupEntryJsonObject) {
        return this.getStringValue(setupEntryJsonObject.get((Object)"setupentryremark"));
    }

    private boolean entryTypeIsSelect(JSONObject bomentryJsonObject) {
        String filedNumber = "entrytype";
        Object obj = bomentryJsonObject.get((Object)filedNumber);
        return "B".equals(obj.toString());
    }

    public DynamicObject getBomByMaterial(DynamicObject material, DynamicObject org) {
        String selectProperties = this.getFullBomSelectProperties();
        QFilter qfilter3 = new QFilter("materialid", "=", material.getPkValue());
        QFilter qfilter4 = BaseDataServiceHelper.getBaseDataFilter((String)"pdm_mftbom", (Long)org.getLong("id"));
        QFilter qfilter5 = new QFilter("status", "=", (Object)"C");
        qfilter5.and(new QFilter("enable", "=", (Object)"1"));
        QFilter[] qFilter = new QFilter[]{qfilter3, qfilter4, qfilter5};
        String keyString = "pdm_mftbom_" + material.getPkValue() + "_" + org.getPkValue() + "_getBomByMaterial";
        DynamicObject bom = this.dynamicObjectCacheMap.get(keyString);
        if (bom == null) {
            Map dyMap = BusinessDataServiceHelper.loadFromCache((String)"pdm_mftbom", (String)selectProperties, (QFilter[])qFilter);
            for (Map.Entry entrys : dyMap.entrySet()) {
                bom = (DynamicObject)entrys.getValue();
            }
        }
        if (this.dynamicObjectCacheMap == null) {
            this.dynamicObjectCacheMap = new ConcurrentHashMap<String, DynamicObject>();
        }
        if (keyString != null && bom != null) {
            this.dynamicObjectCacheMap.putIfAbsent(keyString, bom);
        }
        return bom;
    }

    public DynamicObject getMaterialMftByBom(DynamicObject bom, DynamicObject material, DynamicObject org) {
        DynamicObject materialMft = null;
        DynamicObject materialmaster = material;
        String cacheKeyString = "";
        if (bom != null) {
            materialMft = bom.getDynamicObject("material");
            if (materialMft != null) {
                cacheKeyString = "bd_materialmftinfo_" + materialMft.getPkValue() + "_byId";
                DynamicObject materialMft1 = this.dynamicObjectCacheMap.get(cacheKeyString);
                if (materialMft1 == null) {
                    materialMft = MaterialMftQueryHelper.getDataCacheByID((Object)materialMft.getPkValue());
                    if (this.dynamicObjectCacheMap == null) {
                        this.dynamicObjectCacheMap = new ConcurrentHashMap<String, DynamicObject>();
                    }
                    if (cacheKeyString != null && materialMft != null) {
                        this.dynamicObjectCacheMap.putIfAbsent(cacheKeyString, materialMft);
                    }
                } else {
                    materialMft = materialMft1;
                }
                return materialMft;
            }
            materialmaster = bom.getDynamicObject("materialid");
        }
        if (materialmaster == null) {
            return null;
        }
        cacheKeyString = "bd_materialmftinfo_" + materialmaster.getPkValue() + "_" + org.getPkValue() + "_bymaterial";
        materialMft = this.dynamicObjectCacheMap.get(cacheKeyString);
        if (materialMft == null) {
            materialMft = MaterialMftQueryHelper.getDataCacheByMaterial((DynamicObject)materialmaster, (DynamicObject)org);
            if (this.dynamicObjectCacheMap == null) {
                this.dynamicObjectCacheMap = new ConcurrentHashMap<String, DynamicObject>();
            }
            if (cacheKeyString != null && materialMft != null) {
                this.dynamicObjectCacheMap.putIfAbsent(cacheKeyString, materialMft);
            }
        }
        return materialMft;
    }

    public String getDefSelectProperties(String baseEntityName) {
        String selectProperties = "id,number,name";
        if ("bos_org".equals(baseEntityName)) {
            selectProperties = selectProperties + ",fisproduce";
        } else if ("mpdm_bomtype".equals(baseEntityName)) {
            selectProperties = selectProperties + ",isversion,purpose,isecnupdate,isinsloc";
        } else if ("bd_material".equals(baseEntityName)) {
            selectProperties = selectProperties + ",baseunit,configproperties";
        } else if ("pdm_mftbom".equals(baseEntityName)) {
            selectProperties = selectProperties + ",type,createorg,group,material,materialid";
        } else if ("mpdm_featuretype".equals(baseEntityName)) {
            selectProperties = selectProperties + ",entryentity.featurenumt";
        }
        return selectProperties;
    }

    public DynamicObject getSingleCacheBaseDataByNumber(Object number, String baseEntityName) {
        if (this.isNullString(number)) {
            return null;
        }
        String cackeKeyString = this.getUnionString(baseEntityName, number.toString(), "getSingleCacheBaseData", null);
        DynamicObject dy = this.dynamicObjectCacheMap.get(cackeKeyString);
        if (dy == null) {
            dy = this.getSingleBaseDataByNumber(number, baseEntityName, this.getDefSelectProperties(baseEntityName));
            if (this.dynamicObjectCacheMap == null) {
                this.dynamicObjectCacheMap = new ConcurrentHashMap<String, DynamicObject>();
            }
            if (cackeKeyString != null && dy != null) {
                this.dynamicObjectCacheMap.putIfAbsent(cackeKeyString, dy);
            }
        }
        return dy;
    }

    public Map<Object, DynamicObject> getCacheBaseDataByFilter(QFilter qFilter, String baseEntityName, String selectProperties, String cacheKeyString) {
        Map<Object, DynamicObject> data;
        String keyString = cacheKeyString;
        if (selectProperties == null || "".equals(selectProperties)) {
            selectProperties = this.getDefSelectProperties(baseEntityName);
        }
        if (StringUtils.isEmpty((String)keyString)) {
            keyString = this.getUnionString(baseEntityName, qFilter.toString(), selectProperties, null);
        }
        if ((data = this.dynamicObjectMulCacheMap.get(keyString)) == null) {
            data = this.getBaseDataByFilter(qFilter, baseEntityName, selectProperties);
            if (this.dynamicObjectMulCacheMap == null) {
                this.dynamicObjectMulCacheMap = new ConcurrentHashMap<String, Map<Object, DynamicObject>>();
            }
            this.dynamicObjectMulCacheMap.putIfAbsent(keyString, data);
        }
        return data;
    }

    public Map<Object, DynamicObject> getCacheBaseDataByNumber(String number, String baseEntityName, String selectProperties) {
        Map<Object, DynamicObject> data;
        String keyString = this.getUnionString(baseEntityName, number, "getCacheBaseDataByNumber", null);
        if (selectProperties == null || "".equals(selectProperties)) {
            selectProperties = this.getDefSelectProperties(baseEntityName);
        }
        if ((data = this.dynamicObjectMulCacheMap.get(keyString)) == null) {
            data = this.getBaseDataByNumber(number, baseEntityName, selectProperties);
            if (this.dynamicObjectMulCacheMap == null) {
                this.dynamicObjectMulCacheMap = new ConcurrentHashMap<String, Map<Object, DynamicObject>>();
            }
            this.dynamicObjectMulCacheMap.putIfAbsent(keyString, data);
        }
        return data;
    }

    private String getCopMaterialNumber(JSONObject bomCopEntryJsonObject) {
        String filedNumber = "copentrymaterial";
        Object obj = bomCopEntryJsonObject.get((Object)filedNumber);
        return obj == null ? "" : obj.toString();
    }

    private boolean isCopAddMode(JSONObject bomCopEntryJsonObject) {
        String filedNumber = "copentrymode";
        return "A".equalsIgnoreCase(bomCopEntryJsonObject.getString(filedNumber));
    }

    private boolean isCopEditMode(JSONObject bomCopEntryJsonObject) {
        String filedNumber = "copentrymode";
        return "C".equalsIgnoreCase(bomCopEntryJsonObject.getString(filedNumber));
    }

    private DynamicObject getCopEntryMaterial(JSONObject bomCopEntryJsonObject) {
        String filedNumber = "copentrymaterial";
        Object obj = bomCopEntryJsonObject.get((Object)filedNumber);
        String baseEntityName = "bd_material";
        return this.getSingleCacheBaseDataByNumber(obj, baseEntityName);
    }

    private BigDecimal getCopEntryQty(JSONObject bomCopEntryJsonObject) {
        return this.getBigDecimalValue(bomCopEntryJsonObject.get((Object)"copentryqty"));
    }

    private Date getCopActTime(JSONObject bomCopEntryJsonObject) {
        return this.getDate(bomCopEntryJsonObject.get((Object)"copacttime"));
    }

    private Date getCopEntryInvalidDate(JSONObject bomCopEntryJsonObject) {
        Date entryInValidDate = this.getDate(bomCopEntryJsonObject.get((Object)"copentryinvaliddate"));
        if (entryInValidDate == null) {
            entryInValidDate = this.getDate("2999-01-01 00:00:00");
        }
        return entryInValidDate;
    }

    private Date getCopEntryValidDate(JSONObject bomCopEntryJsonObject) {
        Date entryValidDate = this.getDate(bomCopEntryJsonObject.get((Object)"copentryvaliddate"));
        if (entryValidDate == null) {
            entryValidDate = new Date();
        }
        return entryValidDate;
    }

    public DynamicObject getBomCopEntryIdBySeq(DynamicObject bom, int seq) {
        if (bom == null || seq == 0) {
            return null;
        }
        DynamicObjectCollection coll = bom.getDynamicObjectCollection("copentry");
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject entry = (DynamicObject)coll.get(i);
            if (entry.getInt("seq") != seq) continue;
            return entry;
        }
        return null;
    }

    private DynamicObject getCopEntryVersion(JSONObject bomCopEntryJsonObject) {
        String filedNumber = "copentryversion";
        Object obj = bomCopEntryJsonObject.get((Object)filedNumber);
        DynamicObject material = this.getCopEntryMaterial(bomCopEntryJsonObject);
        if (obj == null || material == null) {
            return null;
        }
        return this.getBomVersion(obj.toString(), material);
    }

    private String getCopEntryProcessSeq(JSONObject bomCopEntryJsonObject) {
        String value = this.getStringValue(bomCopEntryJsonObject.get((Object)"copentryprocessseq"));
        if (StringUtils.isEmpty((String)value)) {
            value = "1";
        }
        return value;
    }

    private String getCopEntryOperationNum(JSONObject bomCopEntryJsonObject) {
        String value = this.getStringValue(bomCopEntryJsonObject.get((Object)"copentryoperationnum"));
        if (StringUtils.isEmpty((String)value)) {
            value = "10";
        }
        return value;
    }

    private DynamicObject getCopEntryOperation(JSONObject bomCopEntryJsonObject) {
        String filedNumber = "copentryoperation";
        Object obj = bomCopEntryJsonObject.get((Object)filedNumber);
        String baseEntityName = "mpdm_workprocedure";
        return this.getSingleCacheBaseDataByNumber(obj, baseEntityName);
    }

    public String checkData_copEntrymode(JSONObject bomCopEntryJsonObject, int rowIndex) {
        String filedNumber = "copentrymode";
        String chkMsg = "";
        Object obj = bomCopEntryJsonObject.get((Object)filedNumber);
        if (obj == null || !entryModeValueSet.contains(obj.toString())) {
            chkMsg = String.format(ResManager.loadKDString((String)"\u4f20\u5165\u53c2\u6570\u4e2d,\u7b2c[%1$s]\u884cBOM\u8054\u526f\u4ea7\u54c1\u5206\u5f55\u7684\u884c\u6807\u8bc6\u5b57\u6bb5[%2$s]\u4e0d\u7b26\u5408\u6570\u636e\u8981\u6c42:\u53ea\u5141\u8bb8\u4f20\u5165[\u65b0\u589eA \u4fee\u6539C \u5931\u6548E]\u7b49\u4e09\u79cd\u7c7b\u578b\u6570\u636e.", (String)"EcoChangeBillCreateBusiness_81", (String)"mmc-pdm-business", (Object[])new Object[0]), rowIndex, obj == null ? "" : obj.toString());
            return chkMsg + " " + this.getCopMaterialNumber(bomCopEntryJsonObject);
        }
        return "ok";
    }

    private String checkData_copEntryType(JSONObject bomCopEntryJsonObject, int rowIndex) {
        String filedNumber = "copentrytype";
        String chkMsg = "";
        Object obj = bomCopEntryJsonObject.get((Object)filedNumber);
        if (obj == null || !copEntryTypeValueSet.contains(obj.toString())) {
            chkMsg = String.format(ResManager.loadKDString((String)"\u4f20\u5165\u53c2\u6570\u4e2d\uff0c\u7b2c[%1$s]\u884cBOM\u8054\u526f\u4ea7\u54c1\u5206\u5f55\u7684\u4ea7\u54c1\u7c7b\u578b\u5b57\u6bb5[%2$s]\u4e0d\u7b26\u5408\u6570\u636e\u8981\u6c42\uff1a\u53ea\u5141\u8bb8\u4f20\u5165[\u8054\u4ea7\u54c110720\u3001\u526f\u4ea7\u54c110730]\u7b49\u4e24\u79cd\u7c7b\u578b\u6570\u636e\u3002", (String)"EcoChangeBillCreateBusiness_82", (String)"mmc-pdm-business", (Object[])new Object[0]), rowIndex, obj == null ? "" : obj.toString());
            return chkMsg + " " + this.getCopMaterialNumber(bomCopEntryJsonObject);
        }
        return "ok";
    }

    public String checkData_copEntrymaterial(JSONObject bomCopEntryJsonObject, int rowIndex) {
        String filedNumber = "copentrymaterial";
        String chkMsg = "";
        Object obj = bomCopEntryJsonObject.get((Object)filedNumber);
        chkMsg = this.checkIsMustInput(obj, filedNumber);
        if (!"ok".equals(chkMsg)) {
            return chkMsg;
        }
        String baseEntityName = "bd_material";
        String fieldName = ResManager.loadKDString((String)"\u8054\u526f\u4ea7\u54c1\u7f16\u7801", (String)"EcoChangeBillCreateBusiness_83", (String)"mmc-pdm-business", (Object[])new Object[0]);
        chkMsg = this.checkBaseDataIsExists(obj.toString(), baseEntityName, fieldName);
        return chkMsg;
    }

    private String checkData_bomCopSeq(JSONObject bomCopEntryJsonObject, int rowIndex, DynamicObject bomHead) {
        if (this.isCopAddMode(bomCopEntryJsonObject)) {
            return "ok";
        }
        String filedNumber = "copentryseq";
        String chkMsg = "";
        Object obj = bomCopEntryJsonObject.get((Object)filedNumber);
        chkMsg = this.checkIsMustInput(obj, filedNumber);
        if (!"ok".equals(chkMsg)) {
            return chkMsg;
        }
        DynamicObject bom = this.getFullBom(bomHead);
        DynamicObject bomCopEntry = this.getBomCopEntryIdBySeq(bom, Integer.parseInt(obj.toString()));
        if (bomCopEntry == null) {
            chkMsg = String.format(ResManager.loadKDString((String)"BOM\u7f16\u7801[%1$s]\u7684\u8054\u526f\u4ea7\u54c1\u5206\u5f55\u4e2d\u4e0d\u5b58\u5728\u5e8f\u53f7\u4e3a[%2$s]\u7684\u6570\u636e\u3002", (String)"EcoChangeBillCreateBusiness_84", (String)"mmc-pdm-business", (Object[])new Object[0]), bom.getString("number"), obj.toString());
            return chkMsg;
        }
        DynamicObject entryMaterial = this.getCopEntryMaterial(bomCopEntryJsonObject);
        Long entryMaterialId = entryMaterial.getLong("id");
        if (!entryMaterialId.equals(bomCopEntry.getDynamicObject("copentrymaterialid").getLong("id"))) {
            chkMsg = String.format(ResManager.loadKDString((String)"BOM\u7f16\u7801[%1$s]\u4e2d\u5e8f\u53f7\u4e3a[%2$s]\u7684\u8054\u526f\u4ea7\u54c1\u5206\u5f55\u6570\u636e\u5bf9\u5e94\u7684\u4ea7\u54c1ID\u4e0e\u4f20\u5165\u53c2\u6570\u7684\u4ea7\u54c1ID\u4e0d\u4e00\u81f4\u3002", (String)"EcoChangeBillCreateBusiness_85", (String)"mmc-pdm-business", (Object[])new Object[0]), bom.getString("number"), obj.toString());
            return chkMsg;
        }
        return "ok";
    }

    private String checkData_copEntryversion(JSONObject pentryJsonObject, JSONObject bomCopEntryJsonObject, int rowIndex) {
        String filedNumber = "copentryversion";
        String chkMsg = "";
        Object obj = bomCopEntryJsonObject.get((Object)filedNumber);
        if (this.isNullString(obj)) {
            return chkMsg;
        }
        DynamicObject bomType = this.getBomType(pentryJsonObject);
        if (this.bomTypeIsVersion(bomType)) {
            DynamicObject material = this.getCopEntryMaterial(bomCopEntryJsonObject);
            if (this.getBomVersion(obj.toString(), material) == null) {
                String pmaterialNumber = bomCopEntryJsonObject.getString("copentrymaterial");
                chkMsg = String.format(ResManager.loadKDString((String)"\u7b2c[%1$s]\u884cBOM\u8054\u526f\u4ea7\u54c1\u5206\u5f55\u4e2d,\u4f9d\u636e\u8054\u526f\u4ea7\u54c1\u7f16\u7801[%2$s]\u53caBOM\u7248\u672c\u53f7[%3$s]\u65e0\u6cd5\u83b7\u53d6\u5230\u5bf9\u5e94\u7684\u7248\u672c\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"EcoChangeBillCreateBusiness_86", (String)"mmc-pdm-business", (Object[])new Object[0]), rowIndex, pmaterialNumber, obj.toString());
                return chkMsg;
            }
        }
        return "ok";
    }

    private String checkData_copEntryQtyValidate(JSONObject bomCopEntryJsonObject, int rowIndex) {
        String chkMsg = "";
        BigDecimal qty = this.getCopEntryQty(bomCopEntryJsonObject);
        if (qty.compareTo(BigDecimal.ZERO) < 0) {
            chkMsg = String.format(ResManager.loadKDString((String)"\u4f20\u5165\u53c2\u6570\u4e2d,\u7b2c[%1$s]\u884cBOM\u8054\u526f\u4ea7\u54c1\u5206\u5f55\u7684\u6570\u91cf[%2$s]\u4e0d\u7b26\u5408\u6570\u636e\u8981\u6c42(\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0)\u3002", (String)"EcoChangeBillCreateBusiness_87", (String)"mmc-pdm-business", (Object[])new Object[0]), rowIndex, qty);
            return chkMsg + " " + this.getCopMaterialNumber(bomCopEntryJsonObject);
        }
        return "ok";
    }

    private String checkData_copActtime(JSONObject bomCopEntryJsonObject, int rowIndex) {
        String filedNumber = "copacttime";
        String chkMsg = "";
        Object obj = bomCopEntryJsonObject.get((Object)filedNumber);
        chkMsg = this.checkIsMustInput(obj, filedNumber);
        if (!"ok".equals(chkMsg)) {
            return chkMsg;
        }
        chkMsg = this.checkLongDateFormat(obj);
        if (!"ok".equals(chkMsg)) {
            String fieldName = String.format(ResManager.loadKDString((String)"\u7b2c[%1$s]\u884cBOM\u8054\u526f\u4ea7\u54c1\u5206\u5f55\u7684\u5b9e\u65bd\u65f6\u95f4:", (String)"EcoChangeBillCreateBusiness_88", (String)"mmc-pdm-business", (Object[])new Object[0]), rowIndex);
            return fieldName + chkMsg + " " + this.getCopMaterialNumber(bomCopEntryJsonObject);
        }
        return "ok";
    }

    private String checkData_copEntryvaliddate(JSONObject bomCopEntryJsonObject, int rowIndex) {
        String filedNumber = "copentryvaliddate";
        String chkMsg = "";
        Object obj = bomCopEntryJsonObject.get((Object)filedNumber);
        chkMsg = this.checkIsMustInput(obj, filedNumber);
        if (!"ok".equals(chkMsg)) {
            return chkMsg;
        }
        chkMsg = this.checkLongDateFormat(obj);
        if (!"ok".equals(chkMsg)) {
            String fieldName = String.format(ResManager.loadKDString((String)"\u7b2c[%1$s]\u884cBOM\u8054\u526f\u4ea7\u54c1\u5206\u5f55\u7684\u751f\u6548\u65f6\u95f4:", (String)"EcoChangeBillCreateBusiness_89", (String)"mmc-pdm-business", (Object[])new Object[0]), rowIndex);
            return fieldName + chkMsg + " " + this.getCopMaterialNumber(bomCopEntryJsonObject);
        }
        return "ok";
    }

    private String checkData_copEntryinvaliddate(JSONObject bomCopEntryJsonObject, int rowIndex) {
        String filedNumber = "copentryinvaliddate";
        String chkMsg = "";
        Object obj = bomCopEntryJsonObject.get((Object)filedNumber);
        chkMsg = this.checkIsMustInput(obj, filedNumber);
        if (!"ok".equals(chkMsg)) {
            return chkMsg;
        }
        chkMsg = this.checkLongDateFormat(obj);
        if (!"ok".equals(chkMsg)) {
            String fieldName = String.format(ResManager.loadKDString((String)"\u7b2c[%1$s]\u884cBOM\u8054\u526f\u4ea7\u54c1\u5206\u5f55\u7684\u5931\u6548\u65f6\u95f4:", (String)"EcoChangeBillCreateBusiness_90", (String)"mmc-pdm-business", (Object[])new Object[0]), rowIndex);
            return fieldName + chkMsg + " " + this.getCopMaterialNumber(bomCopEntryJsonObject);
        }
        return "ok";
    }

    private String checkData_copEntryDateValidate(JSONObject bomCopEntryJsonObject, int rowIndex) {
        String filedNumber = "copentryinvaliddate";
        Object obj = bomCopEntryJsonObject.get((Object)filedNumber);
        Date entryinvaliddate = this.getCopEntryInvalidDate(bomCopEntryJsonObject);
        filedNumber = "copentryvaliddate";
        Object obj2 = bomCopEntryJsonObject.get((Object)filedNumber);
        Date entryvaliddate = this.getCopEntryValidDate(bomCopEntryJsonObject);
        if (entryvaliddate.after(entryinvaliddate)) {
            return String.format(ResManager.loadKDString((String)"\u7b2c[%1$s]\u884cBOM\u8054\u526f\u4ea7\u54c1\u5206\u5f55\u7684\u751f\u6548\u65f6\u95f4[%2$s]\u4e0d\u80fd\u5927\u4e8e\u5931\u6548\u65f6\u95f4[%3$s].", (String)"EcoChangeBillCreateBusiness_91", (String)"mmc-pdm-business", (Object[])new Object[0]), rowIndex, obj2.toString(), obj.toString());
        }
        return "ok";
    }

    private String checkData_CopAddMaterial(JSONObject bomCopEntryJsonObject, int rowIndex, DynamicObject pbom) {
        if (pbom != null && this.isCopAddMode(bomCopEntryJsonObject)) {
            DynamicObject entryMaterial = this.getCopEntryMaterial(bomCopEntryJsonObject);
            DynamicObject bomMaterial = pbom.getDynamicObject("materialid");
            if (entryMaterial.getPkValue().equals(bomMaterial.getPkValue())) {
                return String.format(ResManager.loadKDString((String)"\u4f20\u5165\u53c2\u6570\u4e2d,\u7b2c[%1$s]\u884cBOM\u8054\u526f\u4ea7\u54c1\u5206\u5f55\u7684\u4ea7\u54c1\u7f16\u7801[%2$s]\u4e0eBOM\u8868\u5934\u7684\u4ea7\u54c1\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8.", (String)"EcoChangeBillCreateBusiness_92", (String)"mmc-pdm-business", (Object[])new Object[0]), rowIndex, entryMaterial.getString("number"));
            }
        }
        return "ok";
    }

    public String checkData_copEntryOperation(JSONObject bomCopEntryJsonObject, int rowIndex) {
        String filedNumber = "copentryoperation";
        String chkMsg = "";
        Object obj = bomCopEntryJsonObject.get((Object)filedNumber);
        if (this.isNullString(obj)) {
            return chkMsg;
        }
        String baseEntityName = "mpdm_workprocedure";
        String fieldName = ResManager.loadKDString((String)"\u8054\u526f\u4ea7\u54c1\u4ea7\u51fa\u5de5\u5e8f\u7f16\u7801", (String)"EcoChangeBillCreateBusiness_95", (String)"mmc-pdm-business", (Object[])new Object[0]);
        chkMsg = this.checkBaseDataIsExists(obj.toString(), baseEntityName, fieldName);
        return chkMsg;
    }

    private DynamicObject addEcoBomCopEntry(ORM orm, DynamicObject ecoBom, DynamicObject ecoBomCopEntry, JSONObject paramsJson, JSONObject pentryJsonObject, JSONObject bomCopEntryJsonObject, DynamicObject parentBom, String entrymode) {
        boolean isAdd = "A".equals(entrymode);
        boolean isBefore = "B".equals(entrymode);
        boolean isAfter = "C".equals(entrymode);
        boolean isDisable = "E".equals(entrymode);
        int bomCopSeq = bomCopEntryJsonObject.getInteger("copentryseq");
        DynamicObject bomCopEntry = this.getBomCopEntryIdBySeq(parentBom, bomCopSeq);
        DynamicObject materialMasterId = null;
        DynamicObject materialMft = null;
        ecoBomCopEntry.set("copentrymode", (Object)entrymode);
        if (isBefore || isAfter || isDisable) {
            this.putBomCopEntryToEcoBom(bomCopEntry, ecoBomCopEntry);
            ecoBomCopEntry.set("copentryseq", bomCopEntry.get("seq"));
        }
        ecoBomCopEntry.set("newcopentryid", (Object)0L);
        if (isBefore || isDisable) {
            ecoBomCopEntry.set("oldcopentryid", bomCopEntry.getPkValue());
        }
        if (!isAdd) {
            ecoBomCopEntry.set("oldcopentryid", bomCopEntry.getPkValue());
        } else {
            Long pBomEntryPK = ORM.create().genLongId("pdm_ecobom.copentry");
            ecoBomCopEntry.set("oldcopentryid", (Object)pBomEntryPK);
        }
        ecoBomCopEntry.set("copacttime", (Object)this.getCopActTime(bomCopEntryJsonObject));
        ecoBomCopEntry.set("copestimatestatus", (Object)"A");
        if (isAdd || isAfter) {
            materialMasterId = this.getCopEntryMaterial(bomCopEntryJsonObject);
            materialMft = this.getMaterialMftByBom(null, materialMasterId, ecoBom.getDynamicObject("createorg"));
            BigDecimal qty = this.getCopEntryQty(bomCopEntryJsonObject);
            ecoBomCopEntry.set("copentrytype", (Object)bomCopEntryJsonObject.getString("copentrytype"));
            ecoBomCopEntry.set("copentrymaterial", (Object)materialMft);
            ecoBomCopEntry.set("copentrymaterialid", (Object)materialMasterId);
            ecoBomCopEntry.set("copentryqty", (Object)qty);
            ecoBomCopEntry.set("copentryunit", (Object)(materialMasterId == null ? Long.valueOf(0L) : materialMasterId.getDynamicObject("baseunit")));
            DynamicObject entryVersion = this.getCopEntryVersion(bomCopEntryJsonObject);
            if (entryVersion != null) {
                ecoBomCopEntry.set("copentryversion", (Object)entryVersion);
            }
            ecoBomCopEntry.set("copentryvaliddate", (Object)this.getCopEntryValidDate(bomCopEntryJsonObject));
            ecoBomCopEntry.set("copentryinvaliddate", (Object)this.getCopEntryInvalidDate(bomCopEntryJsonObject));
            ecoBomCopEntry.set("copentryprocessseq", (Object)bomCopEntryJsonObject.getString("copentryprocessseq"));
            ecoBomCopEntry.set("copentryoperationnum", (Object)bomCopEntryJsonObject.getString("copentryoperationnum"));
            ecoBomCopEntry.set("copentryoperation", (Object)this.getCopEntryOperation(bomCopEntryJsonObject));
            ecoBomCopEntry.set("copentryremark", (Object)bomCopEntryJsonObject.getString("copentryremark"));
        }
        this.dealExtField(bomCopEntryJsonObject, ecoBomCopEntry);
        return ecoBomCopEntry;
    }

    private void putBomCopEntryToEcoBom(DynamicObject bomCopEntry, DynamicObject ecoBomCopEntry) {
        Set<String> bomEntryFieldSet = this.getFieldSet(bomCopEntry);
        Set<String> ecoBomEntryFieldSet = this.getFieldSet(ecoBomCopEntry);
        HashSet noFiledSet = Sets.newHashSet((Object[])new String[]{"id", "seq"});
        for (String fieldNumber : bomEntryFieldSet) {
            Object value;
            if (!ecoBomEntryFieldSet.contains(fieldNumber) || noFiledSet.contains(fieldNumber) || (value = bomCopEntry.get(fieldNumber)) == null || value instanceof DynamicObjectCollection || value instanceof MulBasedataDynamicObjectCollection) continue;
            if ("multilanguagetext".equalsIgnoreCase(fieldNumber)) {
                DynamicObjectCollection newLocCol = this.setLocaleString(bomCopEntry, fieldNumber);
                log.info("multilanguagetext field:" + fieldNumber + ",value =" + value.toString() + ",newLocCol=" + newLocCol.toString());
                ecoBomCopEntry.set(fieldNumber, (Object)newLocCol);
                continue;
            }
            ecoBomCopEntry.set(fieldNumber, value);
        }
    }
}

