/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.business.ecoplatform;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.common.query.helper.MaterialQueryHelper;
import kd.bd.mpdm.common.query.helper.OrgQueryHelper;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.db.DBRoute;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.mmc.pdm.business.ecoplatform.EcoFilterFormulaBusiness;
import kd.mmc.pdm.common.bom.ecoplatform.PlatformUtils;
import kd.mmc.pdm.common.util.PdmParamSetHelper;

public class EcoCommonBusiness {
    public static final DBRoute scmDBRoute = new DBRoute("scm");
    private static final Log log = LogFactory.getLog(EcoCommonBusiness.class);
    public static final String CHKSUCCESSFUL = "ok";
    private static final int IDBATCHMAXSIZE = 50000;
    public StringBuilder logs = new StringBuilder();
    private boolean SHOWDETIALLOG = false;
    private boolean ADDMUTEXLOCK = false;
    public static final ORM orm = ORM.create();
    private Map<String, Set<Long>> allMutexLockSuccessIds = new HashMap<String, Set<Long>>(16);
    public StringBuilder allMutexLockErrors = new StringBuilder();

    public static String getErrorMsg(OperationResult operationResult) {
        StringBuilder errMsg = new StringBuilder();
        List validateErrors = operationResult.getValidateResult().getValidateErrors();
        for (ValidateResult validateResult : validateErrors) {
            List allErrorInfo = validateResult.getAllErrorInfo();
            String validatorKey = validateResult.getValidatorKey();
            allErrorInfo.forEach(operateErrorInfo -> {
                String message = operateErrorInfo.getMessage();
                errMsg.append(validatorKey).append(message);
            });
        }
        if (errMsg.length() < 1 && !operationResult.getAllErrorInfo().isEmpty()) {
            errMsg.append(operationResult.getAllErrorInfo());
        }
        if (errMsg.length() < 1 && !operationResult.isSuccess() && operationResult.getMessage() != null) {
            errMsg.append(operationResult.getMessage());
        }
        if (errMsg.length() < 1 && !operationResult.isSuccess()) {
            errMsg.append(operationResult.toString());
        }
        return errMsg.toString();
    }

    public Set<String> getNotFieldSet() {
        return Sets.newHashSet((Object[])new String[]{"id", "number", "masterid", "sourcedata", "bitindex", "srcindex", "seq"});
    }

    public boolean isAutoSubmit() {
        return PdmParamSetHelper.getBooleanParamValue((String)"ECN_AutoSubmitAndAuditXStock");
    }

    public void addLongDataToMap(Map<Long, Set<Long>> map, Long value, Long keyString) {
        Set<Long> set = map.get(keyString);
        if (set == null) {
            set = new HashSet<Long>(16);
        }
        set.add(value);
        map.put(keyString, set);
    }

    public void putDynaicObject(DynamicObject dyFrom, DynamicObject dyTo) {
        Set<String> bomEntryFieldSet = this.getFieldSet(dyFrom);
        Set<String> ecoBomEntryFieldSet = this.getFieldSet(dyTo);
        Set<String> noFiledSet = this.getNotFieldSet();
        for (String fieldNumber : bomEntryFieldSet) {
            Object value;
            if (!ecoBomEntryFieldSet.contains(fieldNumber) || noFiledSet.contains(fieldNumber) || (value = dyFrom.get(fieldNumber)) == null || value instanceof DynamicObjectCollection || value instanceof MulBasedataDynamicObjectCollection) continue;
            if ("multilanguagetext".equalsIgnoreCase(fieldNumber)) {
                DynamicObjectCollection newLocCol = this.setLocaleString(dyFrom, fieldNumber);
                dyTo.set(fieldNumber, (Object)newLocCol);
                log.info("multilanguagetext field:" + fieldNumber + ",value =" + value.toString() + ",newLocCol=" + newLocCol.toString());
                continue;
            }
            dyTo.set(fieldNumber, value);
        }
    }

    public boolean hasNewECNPermission() {
        RequestContext curUserID = RequestContext.getOrCreate();
        Long userId = curUserID.getCurrUserId();
        boolean hasPer = PermissionServiceHelper.hasNewPermission((long)userId, (String)"pdm", (String)"pdm_bom_eco");
        return hasPer;
    }

    public String getCurrentUserName() {
        RequestContext curUserID = RequestContext.getOrCreate();
        Long userId = curUserID.getCurrUserId();
        DynamicObject user = BusinessDataServiceHelper.loadSingleFromCache((Object)userId, (String)"bos_user");
        String userName = user.getString("name");
        return userName;
    }

    public Set<String> getFieldSet(DynamicObject bomEntry) {
        IDataEntityType dt = bomEntry.getDataEntityType();
        DataEntityPropertyCollection properties = dt.getProperties();
        HashSet<String> fieldNumbers = new HashSet<String>(128);
        for (IDataEntityProperty prop : properties) {
            String name = prop.getName();
            if (!StringUtils.isNotEmpty((String)name) || StringUtils.isEmpty((String)prop.getAlias()) || prop.getDisplayName() == null || prop instanceof EntryProp) continue;
            fieldNumbers.add(name);
        }
        return fieldNumbers;
    }

    public void dealExtField(JSONObject paramsJson, DynamicObject bill) {
        for (String objKey : paramsJson.keySet()) {
            String extField;
            Object data = paramsJson.get((Object)objKey);
            if (data == null || !objKey.startsWith("ext_") || !bill.containsProperty(extField = objKey.substring("ext_".length()))) continue;
            bill.set(extField, data);
        }
    }

    public BigDecimal getBigDecimalValue(Object obj) {
        return obj == null ? BigDecimal.ZERO : new BigDecimal(obj.toString());
    }

    public boolean getBooleanValue(Object obj) {
        return obj == null ? false : (Boolean)obj;
    }

    public String getStringValue(Object obj) {
        return obj == null ? "" : obj.toString();
    }

    public int getIntValue(Object obj) {
        return obj == null ? 0 : Integer.parseInt(obj.toString());
    }

    public Long getLongValue(Object obj) {
        return obj == null || "".equals(obj.toString()) ? 0L : Long.parseLong(obj.toString());
    }

    public boolean isNullString(Object obj) {
        return obj == null || StringUtils.isEmpty((String)obj.toString());
    }

    public DynamicObject getSingleBaseDataByNumber(Object obj, String baseEntityName, String selectProperties) {
        if (this.isNullString(obj)) {
            return null;
        }
        Map<Object, DynamicObject> dyMap = this.getBaseDataByNumber(obj.toString(), baseEntityName, selectProperties);
        DynamicObject dy = null;
        for (Map.Entry<Object, DynamicObject> entrys : dyMap.entrySet()) {
            dy = entrys.getValue();
        }
        return dy;
    }

    public Map<Object, DynamicObject> getBaseDataByNumber(String number, String baseEntityName, String selectProperties) {
        if (StringUtils.isEmpty((String)selectProperties)) {
            selectProperties = "id,number,name";
        }
        QFilter qFilter = new QFilter("number", "=", (Object)number);
        if (!"bos_org".equals(baseEntityName) && !"bos_user".equals(baseEntityName)) {
            qFilter.and(new QFilter("enable", "=", (Object)"1"));
            qFilter.and(new QFilter("status", "=", (Object)"C"));
        }
        return this.getBaseDataByFilter(qFilter, baseEntityName, selectProperties);
    }

    public Map<Object, DynamicObject> getBaseDataByFilter(QFilter qFilter, String baseEntityName, String selectProperties) {
        if (selectProperties == null || "".equals(selectProperties)) {
            selectProperties = "id,number";
        }
        return BusinessDataServiceHelper.loadFromCache((String)baseEntityName, (String)selectProperties, (QFilter[])new QFilter[]{qFilter});
    }

    public JSONObject genReturnData(String msg, boolean successful, String data) {
        JSONObject ret = new JSONObject();
        if (msg != null && msg.endsWith(";")) {
            msg = msg.substring(0, msg.length() - 1);
        }
        ret.put("status", (Object)successful);
        ret.put("msg", (Object)msg);
        ret.put("data", (Object)data);
        return ret;
    }

    public DynamicObjectCollection getNullColl() {
        return new DynamicObjectCollection();
    }

    public DynamicObjectCollection trasnsMulBaseDynamicObjectCollection(String entityName, Object sourceData, String propertyName, String proEntityNum) {
        if (sourceData == null) {
            return this.getNullColl();
        }
        if (sourceData instanceof MulBasedataDynamicObjectCollection) {
            MulBasedataDynamicObjectCollection sourceColl = (MulBasedataDynamicObjectCollection)sourceData;
            if (sourceColl.isEmpty()) {
                return sourceColl;
            }
            ArrayList<Object> baseDataObjectList = new ArrayList<Object>(sourceColl.size());
            for (int i = 0; i < sourceColl.size(); ++i) {
                DynamicObject dy = (DynamicObject)sourceColl.get(i);
                baseDataObjectList.add(dy.getDynamicObject("fbasedataid"));
            }
            return this.getEntryMulBaseDataDyColl(entityName, baseDataObjectList, propertyName, proEntityNum);
        }
        return this.getNullColl();
    }

    public DynamicObjectCollection getEntryMulBaseDataDyColl(String entityName, List<Object> fieldValueIds, String fieldName, String mulBasedataEntity) {
        DynamicObject paySchDy = ORM.create().newDynamicObject(entityName);
        DynamicObjectCollection dyColl = paySchDy.getDynamicObjectCollection(fieldName);
        DynamicObjectType dynamicObjectType = dyColl.getDynamicObjectType();
        for (int i = 0; i < fieldValueIds.size(); ++i) {
            DynamicObject mulBasedataDy = new DynamicObject(dynamicObjectType);
            DynamicObject payBizActDy = BusinessDataServiceHelper.newDynamicObject((String)mulBasedataEntity);
            payBizActDy.set("id", ((DynamicObject)fieldValueIds.get(i)).getPkValue());
            mulBasedataDy.set("fbasedataid", (Object)payBizActDy);
            dyColl.add((Object)mulBasedataDy);
        }
        return dyColl;
    }

    public Date getDate(Object dates) {
        if (dates != null) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                return sdf.parse(dates.toString());
            }
            catch (ParseException e) {
                log.error((Throwable)e);
            }
        }
        return null;
    }

    public Long genLongId(ORM orm, String entityname) {
        return orm.genLongId(entityname);
    }

    public Map<String, Object> copyMap(Map<String, Object> dataFrom) {
        HashMap<String, Object> dataTo = new HashMap<String, Object>(dataFrom.size());
        for (Map.Entry<String, Object> entrys : dataFrom.entrySet()) {
            dataTo.put(entrys.getKey(), entrys.getValue());
        }
        return dataTo;
    }

    public String getUnionString(Object obj1, Object obj2, Object obj3, Object obj4) {
        return PlatformUtils.getUnionString((Object)obj1, (Object)obj2, (Object)obj3, (Object)obj4);
    }

    public String getUnionString(Object obj1, Object obj2, Object obj3, Object obj4, Object obj5) {
        return this.getUnionString(this.getUnionString(obj1, obj2, obj3, obj4), obj5);
    }

    public String getUnionString(Object obj1, Object obj2) {
        return PlatformUtils.getUnionString((Object)obj1, (Object)obj2);
    }

    public String nullValue(Long data) {
        return data == null ? "0" : String.valueOf(data);
    }

    public String checkLongDateFormat(Object dates) {
        if (dates != null) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                sdf.parse(dates.toString());
            }
            catch (ParseException e) {
                log.error((Throwable)e);
                return ResManager.loadKDString((String)"\u65e5\u671f\u201c%1$s\u201d\u683c\u5f0f\u8f6c\u6362\u9519\u8bef\u3002", (String)"EcoCommonBusiness_0", (String)"mmc-pdm-business", (Object[])new Object[0]);
            }
        }
        return CHKSUCCESSFUL;
    }

    public String getAlgoxKeyString(String paramString) {
        return EcoCommonBusiness.class.getName() + "_" + paramString;
    }

    public DynamicObjectCollection setLocaleString(DynamicObject sourceEntryObj, String fieldName) {
        LocaleDynamicObjectCollection locCol = (LocaleDynamicObjectCollection)sourceEntryObj.get(fieldName);
        LocaleDynamicObjectCollection newLocCol = new LocaleDynamicObjectCollection();
        for (DynamicObject locObj : locCol) {
            DynamicObject newLocObj = new DynamicObject(locObj.getDynamicObjectType());
            DataEntityPropertyCollection locPros = locObj.getDataEntityType().getProperties();
            for (IDataEntityProperty locProperty : locPros) {
                newLocObj.set(locProperty.getName(), locObj.get(locProperty.getName()));
            }
            newLocObj.set("pkid", (Object)Uuid16.create().toString());
            newLocCol.add((Object)newLocObj);
        }
        return newLocCol;
    }

    public Map<Object, DynamicObject> getEcoFilterMap(String changeObject) {
        QFilter qfilter = new QFilter("changeobject", "=", (Object)changeObject);
        qfilter.and(new QFilter("enable", "=", (Object)"1"));
        qfilter.and(new QFilter("status", "=", (Object)"C"));
        return BusinessDataServiceHelper.loadFromCache((String)"pdm_ecorequirefilter", (String)this.getEcoFilterSelectProperties(), (QFilter[])new QFilter[]{qfilter});
    }

    private String getEcoFilterSelectProperties() {
        StringBuilder sb = new StringBuilder();
        sb.append(" isforward ");
        sb.append(",srcobjectentity ");
        sb.append(",objectentity ");
        sb.append(",number ");
        sb.append(",name ");
        sb.append(",changeobject ");
        sb.append(",datematchbysfc ");
        sb.append(",datematchadd ");
        sb.append(",datematchedit ");
        sb.append(",filterrule ");
        sb.append(",filterrulevalue ");
        sb.append(",filterrulevalue_tag ");
        sb.append(",delay ");
        sb.append(",matchentry.leftchar ");
        sb.append(",matchentry.srcfieldnumber ");
        sb.append(",matchentry.condition ");
        sb.append(",matchentry.tragetfieldnumber ");
        sb.append(",matchentry.rightchar ");
        sb.append(",matchentry.orand ");
        return sb.toString();
    }

    public Set<String> getSrcMatchFieldSet(Map<Object, DynamicObject> filterMap) {
        HashSet<String> extAllFieldSet = new HashSet<String>(16);
        for (Map.Entry<Object, DynamicObject> filters : filterMap.entrySet()) {
            DynamicObject filterObject = filters.getValue();
            Set<String> extFieldSet = this.getMatchFieldSet(filterObject, (String)filterObject.getDynamicObject("objectentity").getPkValue());
            if (PlatformUtils.isNullSet(extFieldSet)) continue;
            extAllFieldSet.addAll(extFieldSet);
        }
        return extAllFieldSet;
    }

    public boolean isContainBackFlow(Map<Object, DynamicObject> filterMap) {
        for (Map.Entry<Object, DynamicObject> filters : filterMap.entrySet()) {
            DynamicObject filterObject = filters.getValue();
            if (this.isForward(filterObject)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Set<String> getMatchFieldSet(DynamicObject filterObject, String entityNumber) {
        return EcoFilterFormulaBusiness.getInstance().getMatchEntryField(filterObject, this.isECNEntity(entityNumber));
    }

    public boolean isECNEntity(String entityNumber) {
        return "pdm_ecobom_entryf7".equals(entityNumber) || "pdm_ecoroute_entryf7".equals(entityNumber);
    }

    public boolean isForward(DynamicObject filterObj) {
        return filterObj.getBoolean("isforward");
    }

    public static String genStringBySet(Set<String> fields) {
        StringBuilder sb = new StringBuilder();
        for (String fieldNumber : fields) {
            sb.append(fieldNumber).append(",");
        }
        String sp = sb.toString();
        return sp.substring(0, sp.length() - 1);
    }

    public Date getDate(Map<String, Date> minMaxDateMap, String tag) {
        return minMaxDateMap.get(tag);
    }

    public Map<String, Date> getMinMaxActtime(Map<Long, DynamicObject> dyMap) {
        if (dyMap == null) {
            return new HashMap<String, Date>(16);
        }
        Date minDate = null;
        Date maxDate = null;
        for (Map.Entry<Long, DynamicObject> entrys : dyMap.entrySet()) {
            Date actTime = entrys.getValue().getDate("acttime");
            if (minDate == null) {
                minDate = actTime;
            } else if (actTime.before(minDate)) {
                minDate = actTime;
            }
            if (maxDate == null) {
                maxDate = actTime;
                continue;
            }
            if (!actTime.after(maxDate)) continue;
            maxDate = actTime;
        }
        HashMap<String, Date> dateMap = new HashMap<String, Date>(16);
        dateMap.put("max", maxDate);
        dateMap.put("min", minDate);
        return dateMap;
    }

    public int getAllBillCount(Map<Long, DynamicObject> ecobomEntryMap) {
        int count = 0;
        for (Map.Entry<Long, DynamicObject> entrys : ecobomEntryMap.entrySet()) {
            DynamicObject ecoBomEntry = entrys.getValue();
            if (this.isAfterModifyMode(ecoBomEntry)) continue;
            ++count;
        }
        return count;
    }

    public boolean isAddMode(DynamicObject ecoBomEntry) {
        return "A".equals(ecoBomEntry.getString("entrymode"));
    }

    public boolean isBeforeModifyMode(DynamicObject ecoBomEntry) {
        return "B".equals(ecoBomEntry.getString("entrymode"));
    }

    public boolean isAfterModifyMode(DynamicObject ecoBomEntry) {
        return "C".equals(ecoBomEntry.getString("entrymode"));
    }

    public boolean isDisableModifyMode(DynamicObject ecoBomEntry) {
        return "E".equals(ecoBomEntry.getString("entrymode"));
    }

    public Date getMinDateByDelay(DynamicObject filterObj, Date hisMinActTime) {
        int delay = filterObj.getInt("delay");
        Date minDate = PlatformUtils.addDay((Date)new Date(), (int)(0 - delay));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(minDate);
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.set(11, 0);
        return calendar.getTime();
    }

    public Long getLongValue(Map<String, Object> data, String field) {
        return PlatformUtils.getLongValue(data, (String)field);
    }

    public int getIntValue(Map<String, Object> data, String field) {
        return PlatformUtils.getIntValue(data, (String)field);
    }

    public BigDecimal getBigDecimalValue(Map<String, Object> data, String field) {
        return PlatformUtils.getBigDecimalValue(data, (String)field);
    }

    public Date getDateValue(Map<String, Object> data, String field) {
        return PlatformUtils.getDateValue(data, (String)field);
    }

    public String getStringValue(Map<String, Object> data, String field) {
        return PlatformUtils.getStringValue(data, (String)field);
    }

    public boolean getBooleanValue(Map<String, Object> data, String field) {
        return PlatformUtils.getBooleanValue(data, (String)field);
    }

    public DynamicObject getMaterialDy(Long materialid) {
        return MaterialQueryHelper.getDataCacheByID((Object)materialid);
    }

    public DynamicObject getOrgDy(Long org) {
        return OrgQueryHelper.getDataCacheByID((Object)org);
    }

    public Long getLongId(DynamicObject dy, String field) {
        Object value = dy.get(field);
        if (value != null) {
            if (value instanceof Long) {
                return (Long)value;
            }
            if (value instanceof Integer) {
                return Long.parseLong(value + "");
            }
            if (value instanceof DynamicObject) {
                return (Long)dy.getDynamicObject(field).getPkValue();
            }
        }
        return 0L;
    }

    private String getECOBillSelectFields() {
        StringBuilder sb = new StringBuilder();
        sb.append("id  ");
        sb.append(",org  ");
        sb.append(",billstatus  ");
        sb.append(",changetype  ");
        sb.append(",billno  ");
        sb.append(",pentry.pentrybom  ");
        sb.append(",pentry.pentryroute  ");
        sb.append(",pentry.ecobomid  ");
        sb.append(",pentry.ecorouteid  ");
        sb.append(",pentry.id ");
        return sb.toString();
    }

    public Map<Long, DynamicObject> getEcoChangeBillData(Set<Long> ecoBillIdSet) {
        DynamicObject[] coll;
        long startTime = System.currentTimeMillis();
        HashMap<Long, DynamicObject> dataMap = new HashMap<Long, DynamicObject>(ecoBillIdSet.size());
        QFilter filter = new QFilter("id", "in", ecoBillIdSet);
        QFilter[] qFilters = new QFilter[]{filter};
        for (DynamicObject dy : coll = BusinessDataServiceHelper.load((String)"pdm_bom_eco", (String)this.getECOBillSelectFields(), (QFilter[])qFilters)) {
            DynamicObjectCollection pcoll = dy.getDynamicObjectCollection("pentry");
            for (int i = 0; i < pcoll.size(); ++i) {
                dataMap.put(this.getEcoObjectId(dy, (DynamicObject)pcoll.get(i)), dy);
            }
        }
        long enddate = System.currentTimeMillis() - startTime;
        log.info("getEcoChangeBillData,cost:" + enddate + "ms,ecoBillIdSet.size=" + ecoBillIdSet.size());
        return dataMap;
    }

    private boolean isBomChange(DynamicObject changeBill) {
        return !"B".equals(changeBill.getString("changetype"));
    }

    private Long getEcoObjectId(DynamicObject changeBill, DynamicObject pentry) {
        if (this.isBomChange(changeBill)) {
            return this.getEcoBomId(pentry);
        }
        return this.getEcoRouteId(pentry);
    }

    private Long getEcoBomId(DynamicObject pentry) {
        return pentry.getLong("ecobomid");
    }

    private Long getEcoRouteId(DynamicObject pentry) {
        return pentry.getLong("ecorouteid");
    }

    public Long getEcoPEntryId(DynamicObject changeBill, Long ecoBomId) {
        DynamicObject entry = this.getEcoPEntry(changeBill, ecoBomId);
        return entry == null ? 0L : entry.getLong("id");
    }

    public Long getEcoPEntryBomId(DynamicObject changeBill, Long ecoBomId) {
        DynamicObject entry = this.getEcoPEntry(changeBill, ecoBomId);
        return entry == null ? 0L : entry.getDynamicObject("pentrybom").getLong("id");
    }

    public DynamicObject getEcoPEntry(DynamicObject changeBill, Long ecoBomId) {
        DynamicObjectCollection pcoll = changeBill.getDynamicObjectCollection("pentry");
        for (int i = 0; i < pcoll.size(); ++i) {
            DynamicObject entry = (DynamicObject)pcoll.get(i);
            if (!ecoBomId.equals(this.getEcoObjectId(changeBill, entry))) continue;
            return entry;
        }
        return null;
    }

    public QFilter getCommonQuery(DynamicObject filterObject) {
        return this.getCommonQueryFromModel(filterObject);
    }

    private QFilter getCommonQueryFromModel(DynamicObject filterObject) {
        String filterrulevalue = filterObject.getString("filterrulevalue_tag");
        if (null != filterrulevalue && !"".equals(filterrulevalue)) {
            String entityName = (String)filterObject.getDynamicObject("objectentity").getPkValue();
            return PlatformUtils.getQFilter((String)filterrulevalue, (String)entityName);
        }
        return new QFilter("id", "=", (Object)0L);
    }

    public List<List<Long>> splitIdData(List<Long> stockEntryIdList) {
        int size = stockEntryIdList.size();
        int batchSize = this.getIdBatchMaxSize();
        ArrayList<List<Long>> splitList = new ArrayList<List<Long>>(16);
        if (size <= batchSize) {
            splitList.add(stockEntryIdList);
            return splitList;
        }
        int times = size / batchSize;
        if (size % batchSize > 0) {
            ++times;
        }
        List<Long> subList = null;
        for (int i = 1; i <= times; ++i) {
            subList = i < times ? stockEntryIdList.subList(batchSize * (i - 1), batchSize * i) : stockEntryIdList.subList(batchSize * (i - 1), size);
            splitList.add(subList);
        }
        return splitList;
    }

    public int getIdBatchMaxSize() {
        return 50000;
    }

    public void mergeMsgString(String msg, Map<String, Object> resultMap) {
        if (StringUtils.isNotEmpty((String)msg)) {
            msg = msg + " " + (resultMap.get("errormsg") == null ? "" : resultMap.get("errormsg").toString());
            resultMap.put("errormsg", msg);
        }
    }

    public List<Object> mergeList(List<Object> aList, List<Object> bList) {
        if (aList == null || aList.isEmpty()) {
            return bList;
        }
        if (bList == null || bList.isEmpty()) {
            return aList;
        }
        aList.addAll(bList);
        return aList;
    }

    public void dealMutexLockResult(Map<String, Set<Long>> successIdMaps, String lockErrorMsg) {
        if (StringUtils.isEmpty((String)lockErrorMsg)) {
            for (Map.Entry<String, Set<Long>> entrys : successIdMaps.entrySet()) {
                String keyString = entrys.getKey();
                Set<Long> valueSet = entrys.getValue();
                Set<Long> allValueSet = this.allMutexLockSuccessIds.get(keyString);
                if (allValueSet == null) {
                    allValueSet = valueSet;
                } else {
                    allValueSet.addAll(valueSet);
                }
                this.allMutexLockSuccessIds.put(keyString, allValueSet);
            }
        } else {
            this.allMutexLockErrors.append(lockErrorMsg).append("\r\n");
        }
    }

    public Set<String> getAddMutexRepeatKeySet() {
        HashSet<String> repeatSet = new HashSet<String>(64);
        for (Map.Entry<String, Set<Long>> entrys : this.allMutexLockSuccessIds.entrySet()) {
            String orderType = entrys.getKey();
            Set<Long> valueSet = entrys.getValue();
            if (PlatformUtils.isNullSet(valueSet)) continue;
            for (Long stockId : valueSet) {
                repeatSet.add(stockId + "_" + orderType);
            }
        }
        return repeatSet;
    }

    public boolean isWithLockMutex(String srcType) {
        String lockMutexs = PdmParamSetHelper.getStringParamValue((String)"ECN_UpdateOrderLockType");
        return lockMutexs.contains(srcType);
    }

    public boolean isShowDetialLog() {
        return this.SHOWDETIALLOG;
    }

    public boolean isAddMutexLock() {
        return this.ADDMUTEXLOCK;
    }

    public void setIsShowDetialLog(boolean showDetialLog) {
        this.SHOWDETIALLOG = showDetialLog;
    }

    public void setIsAddMutexLock(boolean isAddMutexLock) {
        this.ADDMUTEXLOCK = isAddMutexLock;
    }

    public void initAddMutexLockCache() {
        this.allMutexLockSuccessIds = new HashMap<String, Set<Long>>(16);
        this.allMutexLockErrors = new StringBuilder();
    }

    public void initLogs() {
        this.logs = new StringBuilder();
    }

    public Map<String, Set<Long>> getAllMutexLockSuccessIds() {
        return this.allMutexLockSuccessIds;
    }

    public List<Object> getUnSuccessfulIdList(List<Object> xStockIdList, List<Object> successfulIdList) {
        if (PlatformUtils.isNullList(successfulIdList)) {
            return xStockIdList;
        }
        ArrayList<Object> unSuccessfulList = new ArrayList<Object>(16);
        for (Object id : xStockIdList) {
            if (successfulIdList.contains(id)) continue;
            unSuccessfulList.add(id);
        }
        return unSuccessfulList;
    }

    public Map<String, Object> submitAndAuditXBill(List<Object> xbillIdList, String entityName) {
        if (PlatformUtils.isNullList(xbillIdList)) {
            return new HashMap<String, Object>(16);
        }
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"submit", (String)entityName, (Object[])xbillIdList.toArray(), (OperateOption)this.getOperateOption());
        String errorMsg = EcoCommonBusiness.getErrorMsg(operationResult);
        List submitSuccessPkList = operationResult.getSuccessPkIds();
        HashMap<String, Object> returnMap = new HashMap<String, Object>(16);
        returnMap.put("msg", errorMsg);
        returnMap.put("successpkids", submitSuccessPkList);
        returnMap.put("unsuccesspkids", this.getUnSuccessfulIdList(xbillIdList, submitSuccessPkList));
        if (submitSuccessPkList != null && !submitSuccessPkList.isEmpty()) {
            operationResult = OperationServiceHelper.executeOperate((String)"audit", (String)entityName, (Object[])submitSuccessPkList.toArray(), (OperateOption)this.getOperateOption());
            String errorMsg2 = EcoCommonBusiness.getErrorMsg(operationResult);
            List auditSuccessPkList = operationResult.getSuccessPkIds();
            returnMap.put("msg", errorMsg + " " + errorMsg2);
            returnMap.put("successpkids", auditSuccessPkList);
            returnMap.put("unsuccesspkids", this.getUnSuccessfulIdList(xbillIdList, auditSuccessPkList));
        }
        return returnMap;
    }

    public void setReturnMap(Map<String, Object> resultMap, Map<String, Object> xMap) {
        String msg;
        if (xMap == null || xMap.isEmpty()) {
            return;
        }
        String errormsg = resultMap.get("errormsg") == null ? "" : resultMap.get("errormsg").toString();
        String string = msg = xMap.get("msg") == null ? "" : xMap.get("msg").toString();
        if (!StringUtils.isEmpty((String)msg)) {
            resultMap.put("errormsg", errormsg + " " + msg);
        }
        List unSuccessPkIds = PlatformUtils.getPkIdsFromMap(resultMap, (String)"unsuccesspkids");
        List auditSuccessPkIds = PlatformUtils.getPkIdsFromMap(xMap, (String)"successpkids");
        List auditUnSuccessPkIds = PlatformUtils.getPkIdsFromMap(xMap, (String)"unsuccesspkids");
        resultMap.put("successpkids", auditSuccessPkIds);
        if (!PlatformUtils.isNullList((List)auditUnSuccessPkIds)) {
            if (!PlatformUtils.isNullList((List)unSuccessPkIds)) {
                resultMap.put("unsuccesspkids", unSuccessPkIds.addAll(auditUnSuccessPkIds));
            } else {
                resultMap.put("unsuccesspkids", auditUnSuccessPkIds);
            }
        }
    }

    public OperateOption getOperateOption() {
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("ignorewarn", String.valueOf(true));
        operateOption.setVariableValue("ignoreinteraction", String.valueOf(true));
        operateOption.setVariableValue("strictvalidation", String.valueOf(true));
        operateOption.setVariableValue("needlog", String.valueOf(true));
        return operateOption;
    }

    public boolean isAuditStatus(DynamicObject changeBill) {
        return "C".equals(changeBill.getString("billstatus"));
    }

    public Long getBomId(DynamicObject changeBill, DynamicObject bomEntry, Long ecoBomId) {
        if (bomEntry != null) {
            return bomEntry.getLong("bomid");
        }
        DynamicObjectCollection coll = changeBill.getDynamicObjectCollection("pentry");
        for (DynamicObject pentry : coll) {
            if (!ecoBomId.equals(pentry.getLong("ecobomid"))) continue;
            return this.getLongId(pentry, "pentrybom");
        }
        return 0L;
    }

    public Long getRouteId(DynamicObject changeBill, DynamicObject routeEntry, Long ecoRouteId) {
        if (routeEntry != null) {
            return routeEntry.getLong("routeid");
        }
        DynamicObjectCollection coll = changeBill.getDynamicObjectCollection("pentry");
        for (DynamicObject pentry : coll) {
            if (!ecoRouteId.equals(pentry.getLong("ecorouteid"))) continue;
            return this.getLongId(pentry, "pentryroute");
        }
        return 0L;
    }
}

