/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.business.ecoplatform;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.formula.platform.engine.FormulaEngine;
import kd.bos.formula.platform.engine.RunFormulaException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class EcoFilterFormulaBusiness {
    private static EcoFilterFormulaBusiness business;
    private static final String STR_TRUE = "true";
    private static final String STR_FALSE = "false";
    private static final String STR_NULL = " ";
    private static final Log logger;
    private static final ThreadLocal<Map<String, Boolean>> matchThreadLocal;

    public static EcoFilterFormulaBusiness getInstance() {
        if (business == null) {
            business = new EcoFilterFormulaBusiness();
        }
        return business;
    }

    public String buildFromulaStr(DynamicObject filterObj, boolean isReturnFields) {
        DynamicObjectCollection coll = filterObj.getDynamicObjectCollection("matchentry");
        if (coll == null || coll.isEmpty()) {
            return null;
        }
        StringBuilder formulaStr = new StringBuilder();
        int row = 0;
        int size = coll.size();
        for (DynamicObject entry : coll) {
            String leftChar = entry.getString("leftchar");
            String srcfieldnumber = entry.getString("srcfieldnumber");
            String condition = entry.getString("condition");
            String tragetfieldnumber = entry.getString("tragetfieldnumber");
            String rightChar = entry.getString("rightchar");
            String orAnd = entry.getString("orand");
            formulaStr.append(this.genChar(leftChar, Boolean.TRUE)).append(STR_NULL);
            if (isReturnFields) {
                formulaStr.append(srcfieldnumber).append(STR_NULL);
                formulaStr.append(this.genCondition(condition, false)).append(STR_NULL);
                formulaStr.append(tragetfieldnumber).append(STR_NULL);
            } else {
                formulaStr.append(STR_TRUE).append(STR_NULL);
            }
            formulaStr.append(this.genChar(rightChar, Boolean.FALSE)).append(STR_NULL);
            if (++row >= size) continue;
            formulaStr.append(this.genOrAnd(orAnd)).append(STR_NULL);
        }
        return formulaStr.toString();
    }

    private String genOrAnd(String orandCombType) {
        return "A".equalsIgnoreCase(orandCombType) ? "&&" : "||";
    }

    private String genCondition(String conditionCombType, boolean isStrValue) {
        String resultTag;
        switch (conditionCombType) {
            case "A": {
                resultTag = "==";
                break;
            }
            case "B": {
                resultTag = "!=";
                break;
            }
            case "C": {
                resultTag = ">";
                break;
            }
            case "D": {
                resultTag = ">=";
                break;
            }
            case "E": {
                resultTag = "<";
                break;
            }
            case "F": {
                resultTag = "<=";
                break;
            }
            default: {
                resultTag = "";
            }
        }
        return resultTag;
    }

    private String genChar(String charCombType, boolean isLeft) {
        if (isLeft) {
            return "C".equalsIgnoreCase(charCombType) ? "((" : ("B".equalsIgnoreCase(charCombType) ? "(" : "");
        }
        return "C".equalsIgnoreCase(charCombType) ? "))" : ("B".equalsIgnoreCase(charCombType) ? ")" : "");
    }

    public Set<String> getMatchEntryField(DynamicObject filterObj, boolean isSrc) {
        HashSet<String> extFieldSet = new HashSet<String>(16);
        DynamicObjectCollection coll = filterObj.getDynamicObjectCollection("matchentry");
        if (coll == null || coll.isEmpty()) {
            return extFieldSet;
        }
        for (DynamicObject entry : coll) {
            String srcfieldnumber = entry.getString("srcfieldnumber");
            String tragetfieldnumber = entry.getString("tragetfieldnumber");
            if (isSrc && !StringUtils.isEmpty((String)srcfieldnumber)) {
                extFieldSet.add(srcfieldnumber);
            }
            if (isSrc || StringUtils.isEmpty((String)tragetfieldnumber)) continue;
            extFieldSet.add(tragetfieldnumber);
        }
        return extFieldSet;
    }

    public boolean chkIsMatch(DynamicObject srcObject, Map<String, Object> stockData, DynamicObject filterObj) throws RunFormulaException {
        DynamicObjectCollection coll = filterObj.getDynamicObjectCollection("matchentry");
        if (coll == null || coll.isEmpty()) {
            return true;
        }
        StringBuilder formulaStr = new StringBuilder();
        int row = 0;
        int size = coll.size();
        for (DynamicObject entry : coll) {
            String leftChar = entry.getString("leftchar");
            String srcfieldnumber = entry.getString("srcfieldnumber");
            String condition = entry.getString("condition");
            String tragetfieldnumber = entry.getString("tragetfieldnumber");
            String rightChar = entry.getString("rightchar");
            String orAnd = entry.getString("orand");
            formulaStr.append(this.genChar(leftChar, Boolean.TRUE)).append(STR_NULL);
            Object srcValue = srcObject.get(srcfieldnumber);
            Object targetValue = stockData.get(tragetfieldnumber);
            boolean isContainEquals = this.isContiainEquals(condition);
            if (this.isNullValue(srcValue) && this.isNullValue(targetValue)) {
                formulaStr.append(isContainEquals ? STR_TRUE : STR_FALSE).append(STR_NULL);
            } else if (this.isNullValue(srcValue) || this.isNullValue(targetValue)) {
                formulaStr.append(isContainEquals ? STR_FALSE : STR_TRUE).append(STR_NULL);
            } else {
                boolean isStrValue = !this.isIntValue(srcValue) || !this.isIntValue(targetValue);
                String strChar = isStrValue ? "\"" : "";
                formulaStr.append(strChar).append(srcValue).append(strChar).append(STR_NULL);
                formulaStr.append(this.genCondition(condition, isStrValue)).append(STR_NULL);
                formulaStr.append(strChar).append(targetValue).append(strChar).append(STR_NULL);
            }
            formulaStr.append(this.genChar(rightChar, Boolean.FALSE)).append(STR_NULL);
            if (++row >= size) continue;
            formulaStr.append(this.genOrAnd(orAnd)).append(STR_NULL);
        }
        String formulas = formulaStr.toString();
        Map<String, Boolean> threadCacheMap = matchThreadLocal.get();
        if (threadCacheMap == null) {
            threadCacheMap = new HashMap<String, Boolean>(16);
            matchThreadLocal.set(threadCacheMap);
        }
        boolean isMatch = false;
        if (threadCacheMap.containsKey(formulas)) {
            isMatch = threadCacheMap.get(formulas);
            logger.info("------MMC.EcoFilterFormulaBusiness.chkIsMatch,formulaStr=" + formulas + ",isMatch=" + isMatch + ",from threadCacheMap");
            return isMatch;
        }
        isMatch = this.validFormula(formulas);
        threadCacheMap.put(formulas, isMatch);
        logger.info("------MMC.EcoFilterFormulaBusiness.chkIsMatch,formulaStr=" + formulas + ",isMatch=" + isMatch);
        return isMatch;
    }

    private boolean isIntValue(Object value) {
        return value instanceof Integer || value instanceof BigDecimal;
    }

    public boolean validFormula(String formula) throws RunFormulaException {
        Object result = FormulaEngine.runFormula((String)formula, new HashMap(16));
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        if (result instanceof String) {
            return STR_TRUE.equalsIgnoreCase((String)result);
        }
        if (result instanceof Integer) {
            return 1 == (Integer)result;
        }
        return false;
    }

    public boolean isContiainEquals(String condition) {
        return "A".equals(condition) || "D".equals(condition) || "F".equals(condition);
    }

    public boolean isNullValue(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof Integer && (Integer)value == 0) {
            return true;
        }
        if (value instanceof String && StringUtils.isEmpty((String)value.toString())) {
            return true;
        }
        if (value instanceof BigDecimal && ((BigDecimal)value).compareTo(BigDecimal.ZERO) == 0) {
            return true;
        }
        if (value instanceof OrmLocaleValue && ((OrmLocaleValue)value).isEmpty()) {
            return true;
        }
        if (value instanceof MulBasedataDynamicObjectCollection && ((MulBasedataDynamicObjectCollection)value).isEmpty()) {
            return true;
        }
        return value instanceof DynamicObjectCollection && ((DynamicObjectCollection)value).isEmpty();
    }

    static {
        logger = LogFactory.getLog(EcoFilterFormulaBusiness.class);
        matchThreadLocal = new ThreadLocal();
    }
}

