/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.business.ecoplatform;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.common.mftorder.utils.ConfigBomToStockUtils;
import kd.bd.mpdm.common.mftorder.utils.CreateStockByBomUtils;
import kd.bd.mpdm.common.mftorderbom.utils.BomBaseData;
import kd.bd.mpdm.common.query.helper.MaterialMftQueryHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.mmc.business.query.helper.MmcCommonHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.StringUtils;
import kd.mmc.pdm.common.bom.ecoplatform.PlatformUtils;
import kd.mmc.pdm.common.util.MMCUtils;

public class ExpandBomByConfigBom {
    private static final Log logger = LogFactory.getLog(ExpandBomByConfigBom.class);

    public List<BomBaseData> expandBom(JSONObject configCodeJs, Long materialMasterId, Date searchTime, BigDecimal qty, Map<String, String> bomResultCacheMap, Long pMaterialMasterId, Long productOrgId, boolean includeParent) {
        JSONObject bomResult = this.getExpandBomResult(configCodeJs, materialMasterId, searchTime, qty, bomResultCacheMap, productOrgId);
        logger.info("bomResult=" + bomResult.toJSONString());
        JSONArray resArray = bomResult.getJSONArray("treeentryentity");
        ArrayList<BomBaseData> bbdList = new ArrayList<BomBaseData>(10);
        if (resArray != null) {
            boolean isAll = true;
            HashSet<Long> pidSet = new HashSet<Long>(16);
            BigDecimal parentQty = BigDecimal.ONE;
            Long parentId = 0L;
            int dataSize = resArray.size();
            HashSet<Long> materialMasterIdSet = new HashSet<Long>(16);
            for (int i = 0; i < dataSize; ++i) {
                JSONObject resJson = (JSONObject)resArray.get(i);
                if (resJson.getLong("pid").equals(0L)) continue;
                Long mftId = 0L;
                if (resJson.get((Object)"pmaterialmftifoid") != null) {
                    mftId = Long.parseLong(resJson.get((Object)"pmaterialmftifoid").toString());
                }
                if (mftId != null && !mftId.equals(0L)) continue;
                materialMasterIdSet.add(Long.parseLong(resJson.get((Object)"pmaterial").toString()));
            }
            HashMap<Object, DynamicObject> mftCacheMap = new HashMap(16);
            if (!materialMasterIdSet.isEmpty()) {
                mftCacheMap = MaterialMftQueryHelper.getDataCacheByMaterialSet(materialMasterIdSet, (Long)productOrgId);
            }
            for (int i = 0; i < dataSize; ++i) {
                JSONObject resJson = (JSONObject)resArray.get(i);
                if (resJson.getLong("pid").equals(0L)) {
                    boolean isNullPM = PlatformUtils.isNullLong((Long)pMaterialMasterId);
                    if (isNullPM || pMaterialMasterId.equals(resJson.get((Object)"entrymaterial_id"))) continue;
                    isAll = false;
                    continue;
                }
                if (!isAll) {
                    Long pmftid = (Long)resJson.get((Object)"pmaterial");
                    Long id = (Long)resJson.get((Object)"id");
                    Long pid = (Long)resJson.get((Object)"pid");
                    if (pMaterialMasterId.equals(resJson.get((Object)"entrymaterial_id"))) {
                        BigDecimal entryqty;
                        if (resJson.get((Object)"entryqty") != null && (entryqty = new BigDecimal(resJson.get((Object)"entryqty").toString())).compareTo(BigDecimal.ZERO) != 0) {
                            parentQty = entryqty;
                        }
                        if (parentId.equals(0L)) {
                            parentId = id;
                        }
                        if (includeParent) {
                            this.addBbd(bbdList, resJson, productOrgId, mftCacheMap, parentQty);
                        }
                    }
                    if (!parentId.equals(pid) && !pidSet.contains(pid)) continue;
                    pidSet.add(id);
                    this.addBbd(bbdList, resJson, productOrgId, mftCacheMap, parentQty);
                    continue;
                }
                BomBaseData bbd = ConfigBomToStockUtils.getBomBaseData((JSONObject)resJson, (Long)productOrgId);
                bbd.setPMaterial(ConfigBomToStockUtils.getMaterialMftId((JSONObject)resJson, (Long)productOrgId, mftCacheMap));
                bbdList.add(bbd);
            }
        }
        return bbdList;
    }

    private void addBbd(List<BomBaseData> bbdList, JSONObject resJson, Long productOrgId, Map<Object, DynamicObject> mftCacheMap, BigDecimal parentQty) {
        BomBaseData bbd = ConfigBomToStockUtils.getBomBaseData((JSONObject)resJson, (Long)productOrgId);
        bbd.setPMaterial(ConfigBomToStockUtils.getMaterialMftId((JSONObject)resJson, (Long)productOrgId, mftCacheMap));
        if (parentQty.compareTo(BigDecimal.ONE) != 0) {
            BigDecimal bbdfz = (BigDecimal)bbd.getQtynumerator();
            bbd.setQtynumerator((Object)MMCUtils.divide((BigDecimal)bbdfz, (BigDecimal)parentQty));
        }
        bbdList.add(bbd);
    }

    private JSONObject getExpandBomResult(JSONObject configRoteJs, Long materialMasterId, Date searchTime, BigDecimal qty, Map<String, String> bomResultCacheMap, Long org) {
        String cacheValue;
        long startdate = System.currentTimeMillis();
        String resStr = this.getFilterParamKeyString(configRoteJs, searchTime, qty, materialMasterId, org);
        if (bomResultCacheMap == null) {
            bomResultCacheMap = new HashMap<String, String>(16);
        }
        if (!StringUtils.isEmpty((String)(cacheValue = bomResultCacheMap.get(resStr)))) {
            long enddate = System.currentTimeMillis() - startdate;
            logger.info("pdm-getExpandBomResult.....cost:" + enddate + "ms,from bomResultCacheMap");
            return JSONObject.parseObject((String)cacheValue);
        }
        JSONObject paramObject = this.getBomFilterJson(configRoteJs, searchTime, qty, materialMasterId, org);
        JSONObject returnJsonObject = (JSONObject)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"pdm", (String)"proConfigListQueryService", (String)"getConfigBomForWorkOrder", (Object[])new Object[]{paramObject.toString()});
        if (!"success".equalsIgnoreCase(returnJsonObject.getString("status"))) {
            String errorInfo = returnJsonObject.getString("msg");
            logger.info("-------------getExpandBomResult error:" + errorInfo + ",paramObject=" + paramObject.toString());
            throw new KDBizException(new ErrorCode("configbomexpanderror", errorInfo), new Object[0]);
        }
        long enddate = System.currentTimeMillis() - startdate;
        logger.info("pdm-getExpandConfigBom.....cost:" + enddate + "ms,from mservice");
        Set configIdsTmp = configRoteJs.keySet();
        JSONObject data = returnJsonObject.getJSONObject("data").getJSONObject(String.valueOf(configIdsTmp.iterator().next()));
        if ("failed".equalsIgnoreCase(data.getString("status"))) {
            String errorInfo = data.getString("msg");
            if (errorInfo == null || "".equals(errorInfo)) {
                errorInfo = data.getString("errorMsg");
            }
            logger.info(String.format("-------------getExpandBomResult errorInfo:%s,configCodeId:%s,stackTrace:%s", errorInfo, configRoteJs, data.getString("StackTrace")));
            throw new KDBizException(new ErrorCode("configbomexpanderror", errorInfo), new Object[0]);
        }
        bomResultCacheMap.put(resStr, data.toJSONString());
        return data;
    }

    private List<BomBaseData> convetToObject(String res) {
        if (StringUtils.isEmpty((String)res)) {
            return new ArrayList<BomBaseData>(16);
        }
        JSONArray resArray = JSONArray.parseArray((String)res);
        ArrayList<BomBaseData> bbdList = new ArrayList<BomBaseData>(resArray.size());
        if (!resArray.isEmpty()) {
            for (int i = 0; i < resArray.size(); ++i) {
                JSONObject resJson = (JSONObject)resArray.get(i);
                bbdList.add(CreateStockByBomUtils.getBomBaseData((JSONObject)resJson));
            }
        }
        return bbdList;
    }

    private String getFilterParamKeyString(JSONObject configRoteJs, Date searchTime, BigDecimal qty, Long materialMasterId, Long org) {
        boolean isBomExpandTime = MmcCommonHelper.IsBomExpandTime();
        if (!isBomExpandTime) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            return configRoteJs.toJSONString() + "-" + qty + "-" + sdf.format(searchTime) + "-" + materialMasterId + "-" + org;
        }
        return configRoteJs.toJSONString() + "-" + qty + "-" + searchTime.getTime() + "-" + materialMasterId + "-" + org;
    }

    private JSONObject getBomFilterJson(JSONObject configRoteJs, Date searchTime, BigDecimal qty, Long materialMasterId, Long orgId) {
        JSONObject paramObject = new JSONObject();
        paramObject.put("searchTime", (Object)searchTime);
        paramObject.put("configCodeList", (Object)configRoteJs);
        paramObject.put("model", (Object)"model_pom");
        paramObject.put("num", (Object)qty);
        paramObject.put("isNeedProRoute", (Object)false);
        paramObject.put("matId", (Object)materialMasterId);
        paramObject.put("bomVer", null);
        paramObject.put("purchaseExpand", (Object)false);
        paramObject.put("org", (Object)orgId);
        return paramObject;
    }
}

