/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.business.ecoplatform;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bd.mpdm.common.mftorder.utils.CreateStockByBomUtils;
import kd.bd.mpdm.common.mftorderbom.utils.BomBaseData;
import kd.bd.mpdm.common.query.helper.TransactionTypeQueryHelper;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.mmc.pdm.common.util.MMCUtils;

public class ExpandBomByMulType {
    private static final Log logger = LogFactory.getLog(ExpandBomByMulType.class);

    public List<BomBaseData> expandBom(Long bomId, Long orgId, BigDecimal qty, Date expendbomtime, String type, Long routeId, Long productMaterialMasterId, Long configeCodeId, Long transactionType, Long childMaterialMasterId, Map<String, String> bomResultCacheMap) {
        String result = this.getExpandBomResult(bomId, orgId, qty, expendbomtime, type, routeId, productMaterialMasterId, configeCodeId, transactionType, bomResultCacheMap);
        if (kd.bos.util.StringUtils.isEmpty((String)result)) {
            return new ArrayList<BomBaseData>(16);
        }
        JSONArray resArray = JSONArray.parseArray((String)result);
        ArrayList<BomBaseData> bbdList = new ArrayList<BomBaseData>(16);
        boolean isTopQuery = childMaterialMasterId.equals(productMaterialMasterId);
        BigDecimal parentFz = BigDecimal.ONE;
        BigDecimal parentFm = BigDecimal.ONE;
        HashSet<Long> pidSet = new HashSet<Long>(64);
        if (resArray != null) {
            for (int i = 0; i < resArray.size(); ++i) {
                JSONObject resJson = (JSONObject)resArray.get(i);
                BomBaseData bbd = CreateStockByBomUtils.getBomBaseData((JSONObject)resJson);
                if (!isTopQuery) {
                    Long childMaterialId = resJson.getLong("entrymaterialId");
                    Long parentMaterialId = resJson.getLong("materialId");
                    if (childMaterialMasterId.equals(childMaterialId)) {
                        parentFz = (BigDecimal)bbd.getQtynumerator();
                        parentFm = (BigDecimal)bbd.getQtydenominator();
                        pidSet.add(childMaterialId);
                    }
                    if (!pidSet.contains(parentMaterialId)) continue;
                    pidSet.add(childMaterialId);
                    BigDecimal bbdfz = (BigDecimal)bbd.getQtynumerator();
                    bbd.setQtynumerator((Object)MMCUtils.multiplyAndDivide((BigDecimal)bbdfz, (BigDecimal)parentFm, (BigDecimal)parentFz));
                    bbdList.add(bbd);
                    continue;
                }
                bbdList.add(bbd);
            }
        }
        return bbdList;
    }

    private Long getBomExpandConfigId(Long transactionTypeId, Map<String, String> bomResultCacheMap) {
        String cachekeyString = "getBomExpandConfigId_" + transactionTypeId;
        String cacheValue = bomResultCacheMap.get(cachekeyString);
        if (kd.bos.util.StringUtils.isEmpty((String)cacheValue)) {
            DynamicObject trans = TransactionTypeQueryHelper.getDataCacheByID((Object)transactionTypeId);
            DynamicObject bomexpandconfig = trans.getDynamicObject("bomexpandconfig");
            Long configId = bomexpandconfig == null ? 0L : bomexpandconfig.getLong("id");
            cacheValue = String.valueOf(configId);
            bomResultCacheMap.put(cachekeyString, cacheValue);
            return configId;
        }
        return Long.parseLong(cacheValue);
    }

    private String getExpandBomResult(Long bomId, Long orgId, BigDecimal qty, Date expendbomtime, String type, Long routeId, Long materialMasterId, Long configeCodeId, Long transactionType, Map<String, String> bomResultCacheMap) {
        if (bomResultCacheMap == null) {
            bomResultCacheMap = new HashMap<String, String>(16);
        }
        Long bomExpandConfigId = this.getBomExpandConfigId(transactionType, bomResultCacheMap);
        JSONObject paramObject = new JSONObject(16);
        paramObject.put("bomId", (Object)bomId);
        paramObject.put("materialid", (Object)materialMasterId);
        paramObject.put("searchDate", (Object)expendbomtime);
        paramObject.put("configcode", (Object)configeCodeId);
        paramObject.put("expandConfig", (Object)bomExpandConfigId);
        paramObject.put("org", (Object)orgId);
        paramObject.put("num", (Object)qty);
        paramObject.put("showtype", (Object)type);
        paramObject.put("purexpand", (Object)false);
        paramObject.put("model", (Object)"model_pom");
        String resStr = this.getFilterParamKeyString(paramObject);
        if (bomResultCacheMap.containsKey(resStr)) {
            String result = bomResultCacheMap.get(resStr);
            logger.info("getbomresultfrommap\uff1a" + result);
            return result;
        }
        Long startdate = System.currentTimeMillis();
        JSONArray filterArray = new JSONArray(16);
        filterArray.add((Object)paramObject);
        String bomResult = (String)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"pdm", (String)"BOMSearchService", (String)"bomExpandForMulType", (Object[])new Object[]{filterArray.toString()});
        Long enddate = System.currentTimeMillis() - startdate;
        logger.info(String.format("ExpandBomByMulType.getExpandBomResult params:%s,cost:%s,result:%s", paramObject.toString(), enddate, bomResult));
        JSONArray result = JSON.parseArray((String)bomResult);
        JSONObject data = (JSONObject)result.get(0);
        if (StringUtils.equalsIgnoreCase((CharSequence)"false", (CharSequence)data.getString("success"))) {
            String errorInfo = data.getString("msg");
            if (errorInfo == null || "".equals(errorInfo)) {
                errorInfo = data.getString("errorMsg");
            }
            throw new KDBizException(new ErrorCode("multypeBomexpanderror", errorInfo), new Object[0]);
        }
        String res = "";
        if (result.toString().indexOf("true") >= 0) {
            DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("mmc-fmm-bomsearch");
            res = (String)cache.get(resStr);
            logger.info("getmulbomresultfrombomexpand\uff1a" + res);
            bomResultCacheMap.put(resStr, res);
            cache.remove(resStr);
        }
        return res;
    }

    private String getFilterParamKeyString(JSONObject jsonParams) {
        return CreateStockByBomUtils.getMulBomFilterStr((JSONObject)jsonParams);
    }
}

