/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.business.ecoplatform;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.formula.platform.engine.RunFormulaException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.UnitConvertHelper;
import kd.bos.util.StringUtils;
import kd.mmc.pdm.business.ecoplatform.AddEffectOrderBillBusiness;
import kd.mmc.pdm.business.ecoplatform.EcoCommonBusiness;
import kd.mmc.pdm.business.ecoplatform.EcoFilterFormulaBusiness;
import kd.mmc.pdm.business.ecoplatform.EcoRouteUtils;
import kd.mmc.pdm.business.ecoplatform.log.LogUtils;
import kd.mmc.pdm.common.bom.ecoplatform.OrderMutexLockUtils;
import kd.mmc.pdm.common.bom.ecoplatform.PlatformUtils;
import kd.mmc.pdm.common.util.MMCUtils;

public class GetEcoEffectManuftechBusiness
extends EcoCommonBusiness {
    private static final Log log = LogFactory.getLog(GetEcoEffectManuftechBusiness.class);
    private static final int EFFECTORDERBATCHMAXSIZE = 100;
    private static GetEcoEffectManuftechBusiness impl;

    public static GetEcoEffectManuftechBusiness getInstance() {
        if (impl == null) {
            impl = new GetEcoEffectManuftechBusiness();
        }
        return impl;
    }

    public List<Map<String, Object>> genDiffManuftechData(Set<Long> routeIdSet, Set<Long> ecoBillIdSet, Set<Long> ecoRouteEntryIdSet, String pageCacheOption) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(128);
        if (PlatformUtils.isNullSet(routeIdSet) || PlatformUtils.isNullSet(ecoBillIdSet) || PlatformUtils.isNullSet(ecoRouteEntryIdSet)) {
            return resultList;
        }
        this.initLogs();
        if (this.isShowDetialLog()) {
            LogUtils.genLogs0(this.logs);
        }
        long startTime = System.currentTimeMillis();
        Map<Object, DynamicObject> filterMap = this.getEcoFilterMap("B");
        if (filterMap == null || filterMap.isEmpty()) {
            if (this.isShowDetialLog()) {
                LogUtils.genLogs92(this.logs);
            }
            return resultList;
        }
        HashSet<Long> routeEntryIdSet = new HashSet<Long>(16);
        ArrayList<Long> sortEntryIdList = new ArrayList<Long>(16);
        Set<String> filterExtFieldSet = this.getSrcMatchFieldSet(filterMap);
        Map<Long, DynamicObject> ecoRouteEntryMap = this.getEcoRouteEntryData(ecoRouteEntryIdSet, routeEntryIdSet, sortEntryIdList, filterExtFieldSet);
        Map<String, Date> minMaxDateMap = this.getMinMaxActtime(ecoRouteEntryMap);
        Date minActTime = this.getDate(minMaxDateMap, "min");
        Date maxActTime = this.getDate(minMaxDateMap, "max");
        Date hisMinActTime = null;
        if (this.isShowDetialLog()) {
            LogUtils.genLogs101(this.logs, ecoRouteEntryMap, ecoRouteEntryIdSet, routeEntryIdSet, minActTime, maxActTime, hisMinActTime);
        }
        int allCount = 0;
        int indexInt = 0;
        if (!StringUtils.isEmpty((String)pageCacheOption)) {
            allCount = this.getAllBillCount(ecoRouteEntryMap);
            PageCache pageCache = new PageCache(pageCacheOption);
            pageCache.put("dealnum", Integer.toString(allCount));
            pageCache.put("steptitlename", ResManager.loadKDString((String)"\u6b63\u5728\u8fdb\u884c\u6570\u636e\u67e5\u8be2\u5206\u6790\u3002", (String)"GetEcoEffectOrderBusiness_15", (String)"mmc-pdm-business", (Object[])new Object[0]));
        }
        Map<Long, DynamicObject> routeEntryMap = this.getRouteEntryData(routeEntryIdSet);
        Map<Long, DynamicObject> changeBillMap = this.getEcoChangeBillData(ecoBillIdSet);
        HashSet<Long> queryDbRouteIdSet = new HashSet<Long>(16);
        HashSet<Long> queryDbRouteEntryIdSet = new HashSet<Long>(16);
        this.initUnAuditEntrys(ecoRouteEntryMap, routeEntryMap, changeBillMap);
        boolean hasBackFlow = this.isContainBackFlow(filterMap);
        for (Long l : sortEntryIdList) {
            DynamicObject dynamicObject = ecoRouteEntryMap.get(l);
            Long newProcessEntryID = dynamicObject.getLong("newprocessentryid");
            if (PlatformUtils.isNullLong((Long)newProcessEntryID)) continue;
            DynamicObject routeEntry = routeEntryMap.get(newProcessEntryID);
            Long routeId = routeEntry == null ? 0L : routeEntry.getLong("routeid");
            if (this.isAddMode(dynamicObject) || hasBackFlow && this.isDisableModifyMode(dynamicObject)) {
                queryDbRouteIdSet.add(routeId);
            }
            queryDbRouteEntryIdSet.add(newProcessEntryID);
        }
        if (!StringUtils.isEmpty((String)pageCacheOption)) {
            PageCache pageCache = new PageCache(pageCacheOption);
            pageCache.put("opProgressPro", String.valueOf(0));
            pageCache.put("steptitlename", "");
        }
        int allStep = ecoRouteEntryMap.size();
        allCount *= filterMap.size();
        for (Map.Entry<Object, DynamicObject> entry : filterMap.entrySet()) {
            DynamicObject filterObj = entry.getValue();
            long loopStartTime = System.currentTimeMillis();
            boolean isForward = this.isForward(filterObj);
            String techEntityNumber = (String)filterObj.getDynamicObject("objectentity").getPkValue();
            if (this.isShowDetialLog()) {
                LogUtils.genLogs96(this.logs, filterObj);
            }
            ArrayList<Map<String, Object>> techDataList = new ArrayList<Map<String, Object>>(128);
            QFilter addOtherFilter = this.genDateQueryFilter(maxActTime, minActTime, hisMinActTime, filterObj, Boolean.TRUE);
            QFilter editOtherFilter = this.genDateQueryFilter(maxActTime, minActTime, hisMinActTime, filterObj, Boolean.FALSE);
            List<Map<String, Object>> addTechList = null;
            List<Map<String, Object>> editTechList = null;
            if (!queryDbRouteIdSet.isEmpty()) {
                addTechList = this.getManuftechDataByRouteId(queryDbRouteIdSet, addOtherFilter, filterObj);
            }
            if (!queryDbRouteEntryIdSet.isEmpty()) {
                editTechList = this.getManuftechDataByRouteEntryId(queryDbRouteEntryIdSet, editOtherFilter, filterObj);
            }
            if (!PlatformUtils.isNullList(addTechList)) {
                techDataList.addAll(addTechList);
            }
            if (!PlatformUtils.isNullList(editTechList)) {
                techDataList.addAll(editTechList);
            }
            if (this.isShowDetialLog()) {
                LogUtils.genLogs193(this.logs, filterObj, techEntityNumber, isForward, addOtherFilter, editOtherFilter, queryDbRouteIdSet, queryDbRouteEntryIdSet, addTechList, editTechList);
            }
            if (PlatformUtils.isNullList(techDataList)) continue;
            if (this.isAddMutexLock()) {
                HashMap<String, Set<Long>> successIdMaps = new HashMap<String, Set<Long>>(16);
                String lockErrorMsg = OrderMutexLockUtils.addAllLocks(techDataList, successIdMaps, this.getAddMutexRepeatKeySet(), (String)"B");
                this.dealMutexLockResult(successIdMaps, lockErrorMsg);
                if (!StringUtils.isEmpty((String)lockErrorMsg)) {
                    OrderMutexLockUtils.clearAllLocks(successIdMaps, (String)"B");
                    log.info("-----genDiffTechData.addMutexLock Failed,\u6570\u636e\u6e90=" + filterObj.getString("name") + ",techDataList.size=" + techDataList.size() + ",lockErrorMsg=" + (String)lockErrorMsg);
                    continue;
                }
            }
            Map<String, String> xTechMap = this.getXTechDataMap(techDataList);
            for (Long ecoRouteEntryId : sortEntryIdList) {
                Long routeEntryId;
                DynamicObject ecoRouteEntry = ecoRouteEntryMap.get(ecoRouteEntryId);
                if (this.isAfterModifyMode(ecoRouteEntry) || PlatformUtils.isNullLong((Long)(routeEntryId = Long.valueOf(ecoRouteEntry.getLong("newprocessentryid"))))) continue;
                DynamicObject routeEntry = routeEntryMap.get(routeEntryId);
                Long ecoRouteId = ecoRouteEntry.getLong("ecorouteid");
                DynamicObject changeBill = changeBillMap.get(ecoRouteId);
                Long routeId = routeEntry.getLong("routeid");
                ++indexInt;
                if (!StringUtils.isEmpty((String)pageCacheOption)) {
                    PageCache pageCache = new PageCache(pageCacheOption);
                    int stepProgress = (indexInt - 1) * 100 / allCount;
                    if (stepProgress >= 100) {
                        stepProgress = 99;
                    }
                    pageCache.put("opProgressPro", String.valueOf(stepProgress));
                    if (PlatformUtils.isStop((String)pageCacheOption)) {
                        return new ArrayList<Map<String, Object>>(16);
                    }
                }
                DynamicObject ecoRouteEntryAfter = null;
                Long afterRouteEntryId = 0L;
                if (this.isBeforeModifyMode(ecoRouteEntry) && (ecoRouteEntryAfter = this.getEcoRouteEntryAfter(ecoRouteEntryMap, ecoRouteEntry)) != null) {
                    afterRouteEntryId = ecoRouteEntryAfter.getLong("newprocessentryid");
                }
                List<Map<String, Object>> currentTechDataList = null;
                HashSet<Long> currentRouteEntryIdset = new HashSet<Long>(16);
                currentRouteEntryIdset.add(routeEntryId);
                List<Map<String, Object>> currentGridList = null;
                if (this.isAddMode(ecoRouteEntry)) {
                    if (isForward) {
                        currentTechDataList = this.filterCurrentList(techDataList, routeId, null, ecoRouteEntry, filterObj, null);
                        currentGridList = this.getAddDataManuftech(currentTechDataList, routeEntryMap, ecoRouteEntry, changeBill, xTechMap, filterObj);
                    } else {
                        currentTechDataList = this.filterCurrentList(techDataList, routeId, currentRouteEntryIdset, ecoRouteEntry, filterObj, null);
                        currentGridList = this.getDisbaleDataManuftech(currentTechDataList, routeEntry, ecoRouteEntry, changeBill, xTechMap, filterObj);
                    }
                } else if (this.isDisableModifyMode(ecoRouteEntry)) {
                    currentTechDataList = this.filterCurrentList(techDataList, routeId, currentRouteEntryIdset, ecoRouteEntry, filterObj, null);
                    if (isForward) {
                        currentGridList = this.getDisbaleDataManuftech(currentTechDataList, routeEntry, ecoRouteEntry, changeBill, xTechMap, filterObj);
                    } else {
                        Set<String> existDelOpSet = this.queryExistsXTechAuditDelData(techDataList, routeEntryId);
                        currentTechDataList = this.filterCurrentList(techDataList, routeId, null, ecoRouteEntry, filterObj, existDelOpSet);
                        currentGridList = this.getAddDataManuftech(currentTechDataList, routeEntryMap, ecoRouteEntry, changeBill, xTechMap, filterObj);
                    }
                } else {
                    currentRouteEntryIdset.add(afterRouteEntryId);
                    currentTechDataList = this.filterCurrentList(techDataList, routeId, currentRouteEntryIdset, ecoRouteEntry, filterObj, null);
                    if (isForward) {
                        currentGridList = this.getEditDataManuftech(currentTechDataList, routeEntryMap, ecoRouteEntry, ecoRouteEntryAfter, changeBill, xTechMap, filterObj);
                    } else if (ecoRouteEntryAfter != null) {
                        currentGridList = this.getEditDataManuftech(currentTechDataList, routeEntryMap, ecoRouteEntryAfter, ecoRouteEntry, changeBill, xTechMap, filterObj);
                    }
                }
                if (PlatformUtils.isNullList(currentGridList)) continue;
                resultList.addAll(currentGridList);
            }
            if (this.isShowDetialLog()) {
                LogUtils.genLogs97(this.logs, filterObj);
            }
            long loopEnddate = System.currentTimeMillis() - loopStartTime;
            log.info("mmc-pdm-genDiffTechData,loopCost:" + loopEnddate + "ms,techEntityNumber=" + techEntityNumber + ",isForward=" + isForward + ",sortEntryIdList.size=" + sortEntryIdList.size());
        }
        long l = System.currentTimeMillis() - startTime;
        log.info("mmc-pdm-genDiffTechData,allCost:" + l + "ms,resultList.size=" + resultList.size() + ",allStep=" + allStep);
        if (this.isShowDetialLog()) {
            LogUtils.genLogs100(this.logs);
        }
        return resultList;
    }

    private List<Map<String, Object>> getAddDataManuftech(List<Map<String, Object>> techDataList, Map<Long, DynamicObject> routeEntryMap, DynamicObject ecoRouteEntry, DynamicObject changeBill, Map<String, String> xtechMap, DynamicObject filterObj) {
        Long routeEntryId = ecoRouteEntry.getLong("newprocessentryid");
        DynamicObject routeEntry = routeEntryMap.get(routeEntryId);
        Long routeId = routeEntry.getLong("routeid");
        ArrayList<Map<String, Object>> refTechDataMapList = new ArrayList<Map<String, Object>>(techDataList.size());
        int techDataSize = techDataList.size();
        HashSet<String> techIdSet = new HashSet<String>(techDataSize);
        Set<String> techExistAddIdSet = this.getExistsTechAddData(techDataList, routeEntryId);
        log.info("getAddDataManuftech+getExistsTechAddData,techExistAddIdSet=" + (techExistAddIdSet == null ? "null" : techExistAddIdSet.toString()));
        boolean isForward = this.isForward(filterObj);
        for (int i = 0; i < techDataSize; ++i) {
            Map<String, Object> techDataMap = techDataList.get(i);
            Long opRouteId = this.getLongValue(techDataMap, "processroute");
            if (!routeId.equals(opRouteId)) continue;
            Long techId = this.getLongValue(techDataMap, "id");
            String orderType = this.getStringValue(techDataMap, "ordertype");
            boolean isExistsData = techExistAddIdSet.contains(techId + "_" + routeEntryId + "_" + orderType);
            if (this.isShowDetialLog()) {
                LogUtils.genLogs104(this.logs, techDataMap, routeEntry, isExistsData);
            }
            if (isExistsData) continue;
            String xTechString = this.genXTechKeyString("A", String.valueOf(techId), orderType, String.valueOf(routeEntryId));
            if (xtechMap.containsKey(xTechString)) {
                if (!this.isShowDetialLog()) continue;
                LogUtils.genLogs105(this.logs, routeEntry, xtechMap.get(xTechString));
                continue;
            }
            if (!techIdSet.add(orderType + "_" + String.valueOf(techId))) continue;
            refTechDataMapList.add(techDataMap);
        }
        if (refTechDataMapList.isEmpty()) {
            return new ArrayList<Map<String, Object>>(16);
        }
        techDataSize = refTechDataMapList.size();
        ArrayList<Map<String, Object>> gridList = new ArrayList<Map<String, Object>>(16);
        String remark = ResManager.loadKDString((String)"\u65b0\u589e\u5de5\u5e8f\u6570\u636e", (String)"GetEcoEffectManuftechBusiness_2", (String)"mmc-pdm-business", (Object[])new Object[0]);
        ORM orm = ORM.create();
        for (int i = 0; i < techDataSize; ++i) {
            Map refTechDataMap = (Map)refTechDataMapList.get(i);
            Date planBeginTime = this.getDateValue(refTechDataMap, "planstarttime");
            if (isForward && !this.isValidDate(planBeginTime, routeEntry)) {
                if (!this.isShowDetialLog()) continue;
                LogUtils.genLogs111(this.logs, planBeginTime, routeEntry);
                continue;
            }
            Map<String, Object> gridMap = this.genGrideDataMap(refTechDataMap, ecoRouteEntry, null, changeBill, "A", filterObj);
            gridMap.put("remarksfc", remark);
            gridMap.put("techentryidsfc", this.genLongId(orm, this.getTechEntryEntityName(this.getStringValue(gridMap, "ordertypesfc"))));
            gridList.add(gridMap);
        }
        if (this.isShowDetialLog()) {
            LogUtils.genLogs109(this.logs, gridList);
        }
        return gridList;
    }

    private List<Map<String, Object>> getDisbaleDataManuftech(List<Map<String, Object>> techDataList, DynamicObject routeEntry, DynamicObject ecoRouteEntry, DynamicObject changeBill, Map<String, String> xTechMap, DynamicObject filterObj) {
        Long routeEntryId = ecoRouteEntry.getLong("newprocessentryid");
        String changeType = "C";
        ArrayList<Map<String, Object>> gridList = new ArrayList<Map<String, Object>>(techDataList.size());
        String remark = ResManager.loadKDString((String)"\u5931\u6548\u5de5\u5e8f\u6570\u636e", (String)"GetEcoEffectManuftechBusiness_3", (String)"mmc-pdm-business", (Object[])new Object[0]);
        for (int i = 0; i < techDataList.size(); ++i) {
            Map<String, Object> techDataMap = techDataList.get(i);
            Long stockRouteEntryId = this.getRouteEntryId(techDataMap);
            if (!stockRouteEntryId.equals(routeEntryId)) continue;
            int isDisabledValue = this.chkIsDisabled(techDataMap, xTechMap);
            if (this.isShowDetialLog()) {
                LogUtils.genLogs131(this.logs, techDataMap, routeEntry, isDisabledValue, xTechMap);
            }
            if (isDisabledValue != 0) {
                log.info("getDisbaleDataManuftech,chkIsDisabled = true routeEntryId=" + routeEntryId);
                continue;
            }
            Map<String, Object> gridMap = this.genGrideDataMap(techDataMap, ecoRouteEntry, null, changeBill, changeType, filterObj);
            gridMap.put("remarksfc", remark);
            gridList.add(gridMap);
        }
        if (this.isShowDetialLog()) {
            LogUtils.genLogs135(this.logs, gridList);
        }
        return gridList;
    }

    private List<Map<String, Object>> getEditDataManuftech(List<Map<String, Object>> techDataList, Map<Long, DynamicObject> routeEntryMap, DynamicObject ecoRouteEntry, DynamicObject ecoRouteEntryAfter, DynamicObject changeBill, Map<String, String> xTechMap, DynamicObject filterObj) {
        Long beforeRouteEntryId = ecoRouteEntry.getLong("newprocessentryid");
        DynamicObject routeEntryBefore = routeEntryMap.get(beforeRouteEntryId);
        ArrayList<Map<String, Object>> gridList = new ArrayList<Map<String, Object>>(128);
        String changeType = "B";
        String remark = ResManager.loadKDString((String)"\u4fee\u6539\u5de5\u5e8f\u6570\u636e", (String)"GetEcoEffectManuftechBusiness_4", (String)"mmc-pdm-business", (Object[])new Object[0]);
        for (Map<String, Object> techDataMap : techDataList) {
            Long techRouteEntryId = this.getRouteEntryId(techDataMap);
            if (!techRouteEntryId.equals(beforeRouteEntryId)) continue;
            Long techEntryId = this.getLongValue(techDataMap, "oprentryentity");
            String orderType = this.getStringValue(techDataMap, "ordertype");
            String xTechString = this.genXTechKeyString("B", String.valueOf(techEntryId), orderType, "");
            if (xTechMap.containsKey(xTechString)) {
                log.info("getEditDataManuftech,xTechMap.containsKey(xTechString) ,xTechString = " + xTechString);
                if (!this.isShowDetialLog()) continue;
                LogUtils.genLogs136(this.logs, techDataMap, routeEntryBefore, xTechMap);
                continue;
            }
            Map<String, Object> gridMap = this.genGrideDataMap(techDataMap, ecoRouteEntry, ecoRouteEntryAfter, changeBill, changeType, filterObj);
            gridMap.put("remarksfc", remark);
            gridList.add(gridMap);
        }
        if (this.isShowDetialLog()) {
            LogUtils.genLogs152(this.logs, gridList);
        }
        return gridList;
    }

    private int chkIsDisabled(Map<String, Object> techDataMap, Map<String, String> xTechMap) {
        String orderType;
        boolean isInvalid = this.getBooleanValue(techDataMap, "oprentryentity.oprinvalid");
        if (isInvalid) {
            return 1;
        }
        String techEntryId = String.valueOf(this.getLongValue(techDataMap, "oprentryentity"));
        String xTechString = this.genXTechKeyString("B", techEntryId, orderType = this.getStringValue(techDataMap, "ordertype"), "");
        if (xTechMap.containsKey(xTechString)) {
            return 2;
        }
        return 0;
    }

    private Map<String, Object> genGrideDataMap(Map<String, Object> techDataMap, DynamicObject ecoRouteEntry, DynamicObject ecoRouteEntryAfter, DynamicObject ecoBill, String changeType, DynamicObject filterObj) {
        HashMap<String, Object> gridMap = new HashMap<String, Object>(128);
        boolean isForward = this.isForward(filterObj);
        boolean isAddEntryMode = this.isAddMode(ecoRouteEntry);
        boolean isDisableEntryMode = this.isDisableModifyMode(ecoRouteEntry);
        boolean isAdd = isAddEntryMode && isForward || isDisableEntryMode && !isForward;
        boolean isDisable = isAddEntryMode && !isForward || isDisableEntryMode && isForward;
        gridMap.put("techidsfc", techDataMap.get("id"));
        gridMap.put("techentryidsfc", techDataMap.get("oprentryentity"));
        gridMap.put("technosfc", techDataMap.get("billno"));
        gridMap.put("processroutesfc", techDataMap.get("processroute"));
        gridMap.put("beforeoprparentsfc", isAdd ? "" : techDataMap.get("oprentryentity.oprparent"));
        gridMap.put("afteroprparentsfc", isDisable ? "" : this.getEcoRouteFieldValue(ecoRouteEntry, ecoRouteEntryAfter, "parent"));
        gridMap.put("beforeoprnosfc", isAdd ? "" : techDataMap.get("oprentryentity.oprno"));
        gridMap.put("afteroprnosfc", isDisable ? "" : this.getEcoRouteFieldValue(ecoRouteEntry, ecoRouteEntryAfter, "operationno"));
        gridMap.put("beforeoproperationsfc", isAdd ? Long.valueOf(0L) : techDataMap.get("oprentryentity.oproperation"));
        gridMap.put("afteroproperationsfc", isDisable ? Long.valueOf(0L) : this.getEcoRouteFieldValue(ecoRouteEntry, ecoRouteEntryAfter, "operation"));
        gridMap.put("beforeopdescsfc", isAdd ? "" : techDataMap.get("oprentryentity.oprdescription"));
        gridMap.put("afteropdescsfc", isDisable ? "" : this.getEcoRouteFieldValue(ecoRouteEntry, ecoRouteEntryAfter, "operationdesc"));
        gridMap.put("beforemachiningtypesfc", isAdd ? "" : techDataMap.get("oprentryentity.machiningtype"));
        gridMap.put("aftermachiningtypesfc", isDisable ? "" : this.getEcoRouteFieldValue(ecoRouteEntry, ecoRouteEntryAfter, "machiningtype"));
        gridMap.put("beforeoprorgsfc", isAdd ? Long.valueOf(0L) : techDataMap.get("oprentryentity.oprorg"));
        gridMap.put("afteroprorgsfc", isDisable ? Long.valueOf(0L) : this.getEcoRouteFieldValue(ecoRouteEntry, ecoRouteEntryAfter, "productionorg"));
        gridMap.put("beforeoprworkcentersfc", isAdd ? Long.valueOf(0L) : techDataMap.get("oprentryentity.oprworkcenter"));
        gridMap.put("afteroprworkcentersfc", isDisable ? Long.valueOf(0L) : this.getEcoRouteFieldValue(ecoRouteEntry, ecoRouteEntryAfter, "workcenter"));
        gridMap.put("beforeoprctrlstrategysfc", isAdd ? Long.valueOf(0L) : techDataMap.get("oprentryentity.oprctrlstrategy"));
        gridMap.put("afteroprctrlstrategysfc", isDisable ? Long.valueOf(0L) : this.getEcoRouteFieldValue(ecoRouteEntry, ecoRouteEntryAfter, "oprctrlstrategy"));
        gridMap.put("beforestoragepointsfc", isAdd ? Boolean.FALSE : techDataMap.get("oprentryentity.storagepoint"));
        gridMap.put("afterstoragepointsfc", isDisable ? Boolean.FALSE : this.getEcoRouteFieldValue(ecoRouteEntry, ecoRouteEntryAfter, "storagepoint"));
        gridMap.put("beforecollaborativesfc", isAdd ? Boolean.FALSE : techDataMap.get("oprentryentity.collaborative"));
        gridMap.put("aftercollaborativesfc", isDisable ? Boolean.FALSE : this.getEcoRouteFieldValue(ecoRouteEntry, ecoRouteEntryAfter, "collaborative"));
        gridMap.put("beforeismilestonesfc", isAdd ? Boolean.FALSE : techDataMap.get("oprentryentity.ismilestoneprocess"));
        gridMap.put("afterismilestonesfc", isDisable ? Boolean.FALSE : this.getEcoRouteFieldValue(ecoRouteEntry, ecoRouteEntryAfter, "ismilestoneprocess"));
        gridMap.put("oprplanbegintimesfc", techDataMap.get("oprentryentity.oprplanbegintime"));
        gridMap.put("oprplanfinishtimesfc", techDataMap.get("oprentryentity.oprplanfinishtime"));
        gridMap.put("operationqtysfc", isDisable ? techDataMap.get("oprentryentity.operationqty") : this.getEcoRouteFieldValue(ecoRouteEntry, ecoRouteEntryAfter, "operationqty"));
        gridMap.put("headqtysfc", isDisable ? techDataMap.get("oprentryentity.headqty") : this.getEcoRouteFieldValue(ecoRouteEntry, ecoRouteEntryAfter, "headqty"));
        gridMap.put("headunitsfc", isDisable ? techDataMap.get("oprentryentity.headunit") : this.getEcoRouteFieldValue(ecoRouteEntry, ecoRouteEntryAfter, "headunit"));
        gridMap.put("basebatchqtysfc", isDisable ? techDataMap.get("oprentryentity.basebatchqty") : this.getEcoRouteFieldValue(ecoRouteEntry, ecoRouteEntryAfter, "basebatchqty"));
        gridMap.put("oprunitsfc", isDisable ? techDataMap.get("oprentryentity.oprunit") : this.getEcoRouteFieldValue(ecoRouteEntry, ecoRouteEntryAfter, "operationunit"));
        gridMap.put("oprsourceentryidsfc", this.getEcoRouteFieldValue(ecoRouteEntry, ecoRouteEntryAfter, "newprocessentryid"));
        gridMap.put("oldoprsourceentryidsfc", this.getEcoRouteFieldValue(ecoRouteEntry, ecoRouteEntryAfter, "oldprocessentryid"));
        gridMap.put("oprstatussfc", isAdd ? "A" : techDataMap.get("oprentryentity.oprstatus"));
        gridMap.put("entryseqsfc", isAdd ? Integer.valueOf(0) : techDataMap.get("oprentryentity.seq"));
        gridMap.put("orgsfc", techDataMap.get("org"));
        gridMap.put("ecochangebillnosfc", ecoBill.get("billno"));
        gridMap.put("ecochangebillstatussfc", ecoBill.get("billstatus"));
        gridMap.put("orderbillnosfc", techDataMap.get("mftentryseq.headbillno"));
        gridMap.put("entrymodesfc", "C".equals(ecoRouteEntry.getString("entrymode")) ? "B" : ecoRouteEntry.getString("entrymode"));
        gridMap.put("changetypesfc", changeType);
        gridMap.put("productmaterialsfc", techDataMap.get("material"));
        gridMap.put("productunitsfc", techDataMap.get("baseunit"));
        gridMap.put("orderqtysfc", techDataMap.get("qty"));
        gridMap.put("acttimesfc", this.getEcoRouteFieldValue(ecoRouteEntry, ecoRouteEntryAfter, "acttime"));
        gridMap.put("transactiontypesfc", techDataMap.get("transactiontype"));
        gridMap.put("ordertypesfc", techDataMap.get("ordertype"));
        gridMap.put("orderidsfc", techDataMap.get("manufactureorderid"));
        gridMap.put("orderentryidsfc", techDataMap.get("mftentryseq"));
        gridMap.put("ecoidsfc", ecoBill.getLong("id"));
        gridMap.put("ecopentyridsfc", this.getEcoPEntryId(ecoBill, ecoRouteEntry.getLong("ecorouteid")));
        gridMap.put("ecorouteentryidsfc", ecoRouteEntry.get("entryid"));
        gridMap.put("afterecorouteentryidsfc", ecoRouteEntryAfter == null ? Long.valueOf(0L) : ecoRouteEntryAfter.get("entryid"));
        gridMap.put("remarksfc", this.getStringValue(techDataMap, "remark"));
        gridMap.put("ecorequirefiltersfc", filterObj.getPkValue());
        gridMap.put("islocksfc", Boolean.FALSE);
        gridMap.put("oprqtysfc", isDisable ? techDataMap.get("oprentryentity.oprqty") : this.getOprQty(gridMap));
        return gridMap;
    }

    private Object getEcoRouteFieldValue(DynamicObject ecoRouteEntry, DynamicObject ecoRouteEntryAfter, String fieldNumber) {
        Object data;
        Object object = data = ecoRouteEntryAfter == null ? ecoRouteEntry.get(fieldNumber) : ecoRouteEntryAfter.get(fieldNumber);
        if (data instanceof DynamicObject) {
            return ((DynamicObject)data).getPkValue();
        }
        return data;
    }

    private BigDecimal getOprQty(Map<String, Object> dataMap) {
        BigDecimal orderQty = this.getBigDecimalValue(dataMap, "orderqtysfc");
        Long headUnitId = this.getLongValue(dataMap, "headunitsfc");
        Long oprUnitId = this.getLongValue(dataMap, "oprunitsfc");
        Long materialId = this.getLongValue(dataMap, "productmaterialsfc");
        BigDecimal headQty = this.getBigDecimalValue(dataMap, "headqtysfc");
        BigDecimal operationQty = this.getBigDecimalValue(dataMap, "operationqtysfc");
        BigDecimal batchQty = UnitConvertHelper.calculateNewQty((BigDecimal)orderQty, (Long)oprUnitId, (Long)headUnitId, (Long)materialId, (StringBuilder)new StringBuilder());
        return MMCUtils.multiplyAndDivide((BigDecimal)batchQty, (BigDecimal)operationQty, (BigDecimal)headQty);
    }

    private String getTechEntryEntityName(String orderType) {
        if ("A".equals(orderType)) {
            return "sfc_manftech.oprentryentity";
        }
        return "om_mfttechnics.oprentryentity";
    }

    private Set<String> getExistsTechAddData(List<Map<String, Object>> techDataList, Long routeEntryId) {
        long startTime = System.currentTimeMillis();
        HashMap<String, HashSet<Object>> techIdMap = new HashMap<String, HashSet<Object>>(16);
        for (int i = 0; i < techDataList.size(); ++i) {
            Map<String, Object> techDataMap = techDataList.get(i);
            Long techId = this.getLongValue(techDataMap, "id");
            String string = this.getStringValue(techDataMap, "ordertype");
            HashSet<Object> techIdSet = (HashSet<Object>)techIdMap.get(string);
            if (techIdSet == null) {
                techIdSet = new HashSet<Object>(techDataList.size());
            }
            techIdSet.add(techId);
            techIdMap.put(string, techIdSet);
        }
        HashSet<String> existTechIdSet = new HashSet<String>(techDataList.size());
        HashSet<Long> routeEntryIdSet = new HashSet<Long>(16);
        routeEntryIdSet.add(routeEntryId);
        for (Map.Entry entry : techIdMap.entrySet()) {
            String orderType = (String)entry.getKey();
            Set techIdSet = (Set)entry.getValue();
            this.queryTechAddData(techIdSet, orderType, existTechIdSet, routeEntryIdSet);
        }
        long enddate = System.currentTimeMillis() - startTime;
        log.info("getExistsTechAddData,cost:" + enddate + "ms,techDataList.size=" + techDataList.size());
        return existTechIdSet;
    }

    private void queryTechAddData(Set<Long> techIdSet, String orderType, Set<String> existTechIdSet, Set<Long> routeEntryIdSet) {
        if (techIdSet == null || techIdSet.isEmpty()) {
            return;
        }
        int techSize = techIdSet.size();
        int routeEntrySize = routeEntryIdSet.size();
        ArrayList<Object> paramList = new ArrayList<Object>(techSize + routeEntrySize + 1);
        StringBuilder sb = new StringBuilder();
        int seq = 0;
        sb.append(" select ");
        sb.append(" a.foprsourceentryid ").append(" as ").append("frouteentryid");
        sb.append(" , a.fid ").append(" as ").append("ftechid");
        if ("A".equals(orderType)) {
            sb.append(" from t_pom_manftechentry a ");
        } else {
            sb.append(" from t_om_mfttechnicse3 a ");
        }
        sb.append(" where a.fid in ( ");
        for (Long techId : techIdSet) {
            paramList.add(techId);
            sb.append(" ? ");
            if (++seq == techSize) continue;
            sb.append(" , ");
        }
        sb.append(" ) ");
        sb.append(" and a.foprsourceentryid in (  ");
        seq = 0;
        for (Long routeEntryId : routeEntryIdSet) {
            paramList.add(String.valueOf(routeEntryId));
            sb.append(" ? ");
            if (++seq == routeEntrySize) continue;
            sb.append(" , ");
        }
        sb.append(" ) ");
        try (DataSet ds = DB.queryDataSet((String)this.getAlgoxKeyString("queryTechAddData"), (DBRoute)scmDBRoute, (String)sb.toString(), (Object[])paramList.toArray());){
            for (Row row : ds) {
                Long ftechId = row.getLong("ftechid");
                String frouteEntryid = row.getString("frouteentryid");
                existTechIdSet.add(ftechId + "_" + frouteEntryid + "_" + orderType);
            }
        }
    }

    public Map<Long, DynamicObject> getEcoRouteEntryData(Set<Long> ecoRouteEntryIdSet, Set<Long> routeEntryIdSet, List<Long> sortEntryIdList, Set<String> filterExtFieldSet) {
        long startTime = System.currentTimeMillis();
        HashMap<Long, DynamicObject> dataMap = new HashMap<Long, DynamicObject>(16);
        QFilter filter = new QFilter("id", "in", ecoRouteEntryIdSet);
        QFilter[] qFilters = new QFilter[]{filter};
        String selectProperties = this.getEcoRouteEntryDataSelectProperties(filterExtFieldSet);
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"pdm_ecoroute_entryf7", (String)selectProperties, (QFilter[])qFilters, (String)"ecorouteid,entryseq");
        for (DynamicObject dy : coll) {
            Long routeEntryId;
            sortEntryIdList.add(dy.getLong("entryid"));
            dataMap.put(dy.getLong("entryid"), dy);
            if (routeEntryIdSet == null || PlatformUtils.isNullLong((Long)(routeEntryId = Long.valueOf(dy.getLong("newprocessentryid"))))) continue;
            routeEntryIdSet.add(routeEntryId);
        }
        long enddate = System.currentTimeMillis() - startTime;
        log.info("getEcoRouteEntryData,cost:" + enddate + "ms,ecoRouteEntryIdSet.size=" + ecoRouteEntryIdSet.size());
        return dataMap;
    }

    private String getEcoRouteEntryDataSelectProperties(Set<String> filterExtFieldSet) {
        Set<String> fields = this.getECNEntryFields(filterExtFieldSet);
        return GetEcoEffectManuftechBusiness.genStringBySet(fields);
    }

    private Set<String> getECNEntryFields(Set<String> filterExtFieldSet) {
        HashSet<String> queryFieldSet = new HashSet<String>(64);
        queryFieldSet.add("id");
        queryFieldSet.add("entryid");
        queryFieldSet.add("entrymode");
        queryFieldSet.add("parent");
        queryFieldSet.add("operationno");
        queryFieldSet.add("machiningtype");
        queryFieldSet.add("productionorg");
        queryFieldSet.add("workcenter");
        queryFieldSet.add("operation");
        queryFieldSet.add("operationdesc");
        queryFieldSet.add("oprctrlstrategy");
        queryFieldSet.add("basebatchqty");
        queryFieldSet.add("operationunit");
        queryFieldSet.add("collaborative");
        queryFieldSet.add("ismilestoneprocess");
        queryFieldSet.add("storagepoint");
        queryFieldSet.add("headqty");
        queryFieldSet.add("headunit");
        queryFieldSet.add("operationqty");
        queryFieldSet.add("entryvaliddate");
        queryFieldSet.add("entryinvaliddate");
        queryFieldSet.add("ecorouteid");
        queryFieldSet.add("acttime");
        queryFieldSet.add("oldprocessentryid");
        queryFieldSet.add("newprocessentryid");
        queryFieldSet.add("esremark");
        queryFieldSet.add("entryseq");
        queryFieldSet.add("estimatestatus");
        if (!PlatformUtils.isNullSet(filterExtFieldSet)) {
            queryFieldSet.addAll(filterExtFieldSet);
        }
        return queryFieldSet;
    }

    private String getRouteEntrySelectProperties() {
        StringBuilder sb = new StringBuilder();
        sb.append("id ");
        sb.append(",entryid ");
        sb.append(",entryseq ");
        sb.append(",entryvaliddate ");
        sb.append(",entryinvaliddate ");
        sb.append(",operation ");
        sb.append(",parent ");
        sb.append(",operationno ");
        sb.append(",machiningtype ");
        sb.append(",productionorg ");
        sb.append(",workcenter ");
        sb.append(",operationdesc ");
        sb.append(",oprctrlstrategy ");
        sb.append(",operationqty ");
        sb.append(",operationunit ");
        sb.append(",collaborative ");
        sb.append(",ismilestoneprocess ");
        sb.append(",storagepoint ");
        sb.append(",routeid ");
        sb.append(",headqty ");
        sb.append(",basebatchqty ");
        sb.append(",headunit ");
        return sb.toString();
    }

    public Map<Long, DynamicObject> getRouteEntryData(Set<Long> routeEntryIdSet) {
        if (routeEntryIdSet.isEmpty()) {
            return new HashMap<Long, DynamicObject>(16);
        }
        long startTime = System.currentTimeMillis();
        HashMap<Long, DynamicObject> dataMap = new HashMap<Long, DynamicObject>(routeEntryIdSet.size());
        QFilter filter = new QFilter("entryid", "in", routeEntryIdSet);
        QFilter[] qFilters = new QFilter[]{filter};
        String selectProperties = this.getRouteEntrySelectProperties();
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"pdm_route_processentry", (String)selectProperties, (QFilter[])qFilters);
        for (DynamicObject dy : coll) {
            dataMap.put(dy.getLong("entryid"), dy);
        }
        long enddate = System.currentTimeMillis() - startTime;
        log.info("getRouteEntryData,cost:" + enddate + "ms,routeEntryIdSet.size=" + routeEntryIdSet.size());
        return dataMap;
    }

    @Override
    public String getAlgoxKeyString(String paramString) {
        return GetEcoEffectManuftechBusiness.class.getName() + "_" + paramString;
    }

    private QFilter genDateQueryFilter(Date maxActTime, Date minActTime, Date hisMinActTime, DynamicObject filterObj, boolean isAdd) {
        QFilter otherFilter = null;
        if (isAdd) {
            String addMode = filterObj.getString("datematchbysfc");
            if ("A".equals(addMode)) {
                if (minActTime != null) {
                    otherFilter = new QFilter("planstarttime", ">=", (Object)minActTime);
                }
            } else if ("B".equals(addMode) || "C".equals(addMode)) {
                otherFilter = new QFilter("oprentryentity.oprplanbegintime", ">=", (Object)this.getMinDateByDelay(filterObj, hisMinActTime));
            }
        } else {
            String editMode = filterObj.getString("datematchbysfc");
            if ("A".equals(editMode)) {
                if (minActTime != null) {
                    otherFilter = new QFilter("oprentryentity.oprplanbegintime", ">=", (Object)minActTime);
                }
            } else if ("B".equals(editMode) || "C".equals(editMode)) {
                otherFilter = new QFilter("oprentryentity.oprplanbegintime", ">=", (Object)this.getMinDateByDelay(filterObj, hisMinActTime));
            }
        }
        return otherFilter;
    }

    private List<Map<String, Object>> getManuftechDataByRouteEntryId(Set<Long> routeEntryIdSet, QFilter otherFilter, DynamicObject filterObject) {
        QFilter qFilter = new QFilter("oprentryentity.oprsourceentryid", "in", (Object)PlatformUtils.ParseLongToStringSet(routeEntryIdSet));
        if (otherFilter != null) {
            qFilter.and(otherFilter);
        }
        qFilter.and(this.getCommonQuery(filterObject));
        String manuftechEntityNumber = (String)filterObject.getDynamicObject("objectentity").getPkValue();
        Set<String> filterExtFieldSet = this.getMatchFieldSet(filterObject, manuftechEntityNumber);
        DataSet manuftechDataSet = this.getManuftechDataSet(qFilter, manuftechEntityNumber, filterExtFieldSet);
        List techDataList = MMCUtils.parseToList((DataSet)manuftechDataSet);
        log.info("getManuftechDataByRouteEntryId,qFilter=" + qFilter.toString() + ",techDataList=" + (techDataList == null ? "null" : techDataList.toString()));
        manuftechDataSet.close();
        if (this.isShowDetialLog()) {
            LogUtils.genLogs103(this.logs, techDataList, qFilter, manuftechEntityNumber);
        }
        return techDataList;
    }

    @Override
    public int getIdBatchMaxSize() {
        return 1000;
    }

    private List<Map<String, Object>> getManuftechDataByRouteId(Set<Long> routeIdSet, QFilter otherFilter, DynamicObject filterObject) {
        QFilter qFilter = new QFilter("processroute", "in", routeIdSet);
        if (otherFilter != null) {
            qFilter.and(otherFilter);
        }
        ArrayList<Map<String, Object>> techDataList = new ArrayList<Map<String, Object>>(64);
        qFilter.and(this.getCommonQuery(filterObject));
        String techEntityNumber = (String)filterObject.getDynamicObject("objectentity").getPkValue();
        List<Long> techEntryIdList = this.transIdQFilter(qFilter, techEntityNumber);
        List<List<Long>> splits = this.splitIdData(techEntryIdList);
        if (!splits.isEmpty()) {
            Set<String> filterExtFieldSet = this.getMatchFieldSet(filterObject, techEntityNumber);
            for (List<Long> list : splits) {
                QFilter filters;
                DataSet manuftechDataSet;
                if (list == null || list.isEmpty() || (manuftechDataSet = this.getManuftechDataSet(filters = new QFilter("oprentryentity.id", "in", (Object)list.toArray()), techEntityNumber, filterExtFieldSet)) == null) continue;
                List toList = MMCUtils.parseToList((DataSet)manuftechDataSet);
                if (toList != null && !toList.isEmpty()) {
                    techDataList.addAll(toList);
                }
                manuftechDataSet.close();
            }
        }
        if (this.isShowDetialLog()) {
            LogUtils.genLogs102(this.logs, techDataList, qFilter, techEntityNumber);
        }
        return techDataList;
    }

    private DataSet getManuftechDataSet(QFilter qFilter, String techEntityNumber, Set<String> filterExtFieldSet) {
        String selectProperties = GetEcoEffectManuftechBusiness.getTechSelectProperties(techEntityNumber, filterExtFieldSet);
        return this.getManuftechDataSet(qFilter, techEntityNumber, selectProperties);
    }

    private DataSet getManuftechDataSet(QFilter qFilter, String techEntityNumber, String selectProperties) {
        long startTime = System.currentTimeMillis();
        DataSet mftstockDataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoxKeyString("getManuftechDataSet"), (String)techEntityNumber, (String)selectProperties, (QFilter[])new QFilter[]{qFilter}, (String)"");
        String orderType = "'" + this.getManuftechTag(techEntityNumber) + "'";
        mftstockDataSet = mftstockDataSet.addField(orderType, "ordertype");
        long enddate = System.currentTimeMillis() - startTime;
        log.info("queryMftStockDataSet,cost:" + enddate + "ms,techEntityNumber=" + techEntityNumber + ",selectProperties=" + selectProperties + ",qFilter=" + qFilter.toString());
        return mftstockDataSet;
    }

    private String getManuftechTag(String techEntityNumber) {
        return "sfc_manftech".equals(techEntityNumber) ? "A" : "B";
    }

    public static String getTechSelectProperties(String entityNumber, Set<String> filterExtFieldSet) {
        Set<String> fields = GetEcoEffectManuftechBusiness.getTechFields(entityNumber, filterExtFieldSet);
        return GetEcoEffectManuftechBusiness.genStringBySet(fields);
    }

    private static Set<String> getTechFields(String entityNumber, Set<String> extFieldSet) {
        HashSet<String> queryFieldSet = new HashSet<String>(64);
        queryFieldSet.add("id");
        queryFieldSet.add("org");
        queryFieldSet.add("billno");
        queryFieldSet.add("material");
        queryFieldSet.add("configuredcode");
        queryFieldSet.add("baseunit");
        queryFieldSet.add("qty");
        queryFieldSet.add("transactiontype");
        queryFieldSet.add("processroute");
        queryFieldSet.add("mftentryseq.headbillno");
        queryFieldSet.add("manufactureorderid");
        queryFieldSet.add("mftentryseq");
        queryFieldSet.add("mftentryseq.planstatus");
        queryFieldSet.add("mftentryseq.pickstatus");
        queryFieldSet.add("mftentryseq.bizstatus");
        queryFieldSet.add("planstarttime");
        queryFieldSet.add("planfinishtime");
        queryFieldSet.add("oprentryentity");
        queryFieldSet.add("oprentryentity.oprparent");
        queryFieldSet.add("oprentryentity.oprno");
        queryFieldSet.add("oprentryentity.machiningtype");
        queryFieldSet.add("oprentryentity.oprorg");
        queryFieldSet.add("oprentryentity.oprworkcenter");
        queryFieldSet.add("oprentryentity.oproperation");
        queryFieldSet.add("oprentryentity.oprdescription");
        queryFieldSet.add("oprentryentity.oprctrlstrategy");
        queryFieldSet.add("oprentryentity.oprqty");
        queryFieldSet.add("oprentryentity.operationqty");
        queryFieldSet.add("oprentryentity.oprunit");
        queryFieldSet.add("oprentryentity.headqty");
        queryFieldSet.add("oprentryentity.basebatchqty");
        queryFieldSet.add("oprentryentity.headunit");
        queryFieldSet.add("oprentryentity.oprplanbegintime");
        queryFieldSet.add("oprentryentity.oprplanfinishtime");
        queryFieldSet.add("oprentryentity.storagepoint");
        queryFieldSet.add("oprentryentity.collaborative");
        queryFieldSet.add("oprentryentity.ismilestoneprocess");
        queryFieldSet.add("oprentryentity.oprsourceentryid");
        queryFieldSet.add("oprentryentity.oprstatus");
        queryFieldSet.add("oprentryentity.oprinvalid");
        queryFieldSet.add("oprentryentity.seq");
        if (!PlatformUtils.isNullSet(extFieldSet)) {
            queryFieldSet.addAll(extFieldSet);
        }
        return queryFieldSet;
    }

    private List<Long> transIdQFilter(QFilter oldQFilter, String entityName) {
        long startTime = System.currentTimeMillis();
        String selectProperties = "id,oprentryentity.id entryid";
        String[] groups = new String[]{"id"};
        ArrayList<Long> entryIdList = new ArrayList<Long>(64);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoxKeyString("transIdQFilter"), (String)entityName, (String)selectProperties, (QFilter[])new QFilter[]{oldQFilter}, (String)"").groupBy(groups).max("entryid").finish();){
            while (dataSet.hasNext()) {
                Row arow = dataSet.next();
                entryIdList.add(arow.getLong("entryid"));
            }
        }
        long enddate = System.currentTimeMillis() - startTime;
        log.info("transIdQFilter,cost:" + enddate + "ms,entryIdList.size=" + entryIdList.size());
        return entryIdList;
    }

    private Map<String, String> getXTechDataMap(List<Map<String, Object>> techDataList) {
        String orderType;
        long startTime = System.currentTimeMillis();
        HashMap<String, HashSet<Long>> techIdMap = new HashMap<String, HashSet<Long>>(16);
        HashMap<String, HashSet<Long>> techEntryIdMap = new HashMap<String, HashSet<Long>>(16);
        for (int i = 0; i < techDataList.size(); ++i) {
            Iterator techDataMap = techDataList.get(i);
            Long techId = this.getLongValue((Map<String, Object>)((Object)techDataMap), "id");
            Long techEntryId = this.getLongValue((Map<String, Object>)((Object)techDataMap), "oprentryentity");
            String orderType2 = this.getStringValue((Map<String, Object>)((Object)techDataMap), "ordertype");
            HashSet<Long> techIdSet = (HashSet<Long>)techIdMap.get(orderType2);
            if (techIdSet == null) {
                techIdSet = new HashSet<Long>(techDataList.size());
            }
            techIdSet.add(techId);
            techIdMap.put(orderType2, techIdSet);
            HashSet<Long> techEntryIdSet = (HashSet<Long>)techEntryIdMap.get(orderType2);
            if (techEntryIdSet == null) {
                techEntryIdSet = new HashSet<Long>(techDataList.size());
            }
            techEntryIdSet.add(techEntryId);
            techEntryIdMap.put(orderType2, techEntryIdSet);
        }
        HashMap<String, String> xMap = new HashMap<String, String>(128);
        for (Map.Entry entrys : techEntryIdMap.entrySet()) {
            orderType = (String)entrys.getKey();
            Set techEntryIdSet = (Set)entrys.getValue();
            this.queryXTechNoAuditData(techEntryIdSet, orderType, xMap);
        }
        for (Map.Entry entrys : techIdMap.entrySet()) {
            orderType = (String)entrys.getKey();
            Set techIdSet = (Set)entrys.getValue();
            this.queryXTechNoAuditAddData(techIdSet, orderType, xMap);
        }
        long enddate = System.currentTimeMillis() - startTime;
        log.info("getXTechDataMap,cost:" + enddate + "ms,techDataList.size=" + techDataList.size());
        return xMap;
    }

    private Map<String, String> queryXTechNoAuditData(Set<Long> techEntryIdSet, String orderType, Map<String, String> xTechMap) {
        if (techEntryIdSet == null || techEntryIdSet.isEmpty()) {
            return Collections.emptyMap();
        }
        String xHeadTable = "t_sfc_xmftorderentry_m";
        String xEntryTable = "t_sfc_xmanftechentry";
        SqlBuilder sb = new SqlBuilder();
        sb.append(" select", new Object[0]);
        sb.append(" s.fbillno ", new Object[0]).append(" as ", new Object[0]).append("fxbillno", new Object[0]);
        sb.append(",b.foprentryid ", new Object[0]).append(" as ", new Object[0]).append("ftechentryid", new Object[0]);
        sb.append(" from ", new Object[0]).append(xHeadTable, new Object[0]).append(" s ", new Object[0]);
        sb.append(" inner join ", new Object[0]).append(xEntryTable, new Object[0]).append(" b on b.fid = s.fid  ", new Object[0]);
        sb.append(" where s.fbillstatus in('A','B') and ", new Object[0]);
        sb.appendIn("b.foprentryid", techEntryIdSet.toArray());
        try (DataSet ds = DB.queryDataSet((String)this.getAlgoxKeyString("queryXTechNoAuditData"), (DBRoute)scmDBRoute, (SqlBuilder)sb);){
            for (Row row : ds) {
                String fxbillno = row.getString("fxbillno");
                String ftechEntryId = row.getString("ftechentryid");
                String keyString = this.genXTechKeyString("B", ftechEntryId, orderType, "");
                xTechMap.put(keyString, fxbillno);
            }
        }
        return xTechMap;
    }

    private Map<String, String> queryXTechNoAuditAddData(Set<Long> techIdSet, String orderType, Map<String, String> xTechMap) {
        if (techIdSet == null || techIdSet.isEmpty()) {
            return Collections.emptyMap();
        }
        String xHeadTable = "t_sfc_xmftorderentry_m";
        String xEntryTable = "t_sfc_xmanftechentry";
        SqlBuilder sb = new SqlBuilder();
        sb.append(" select", new Object[0]);
        sb.append(" s.fbillno ", new Object[0]).append(" as ", new Object[0]).append("fxbillno", new Object[0]);
        sb.append(",a.foprmanftechid ", new Object[0]).append(" as ", new Object[0]).append("ftechid", new Object[0]);
        sb.append(",a.foprsourceentryid ", new Object[0]).append(" as ", new Object[0]).append("frouteentryid", new Object[0]);
        sb.append(" from ", new Object[0]).append(xHeadTable, new Object[0]).append(" s ", new Object[0]);
        sb.append(" inner join ", new Object[0]).append(xEntryTable, new Object[0]).append(" a on a.fid  = s.fid   ", new Object[0]);
        sb.append(" where s.fbillstatus in('A','B') and ", new Object[0]);
        sb.append(" a.foprchangetype = 'A' and ", new Object[0]);
        sb.appendIn("a.foprmanftechid", techIdSet.toArray());
        try (DataSet ds = DB.queryDataSet((String)this.getAlgoxKeyString("queryXTechNoAuditAddData"), (DBRoute)scmDBRoute, (SqlBuilder)sb);){
            for (Row row : ds) {
                String fxbillno = row.getString("fxbillno");
                String ftechid = row.getString("ftechid");
                String frouteEntryid = row.getString("frouteentryid");
                String keyString = this.genXTechKeyString("A", ftechid, orderType, frouteEntryid);
                xTechMap.put(keyString, fxbillno);
            }
        }
        return xTechMap;
    }

    private Set<Long> getTechIdSet(List<Map<String, Object>> techDataList) {
        if (techDataList == null || techDataList.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Long> techIdSet = new HashSet<Long>(16);
        for (Map<String, Object> techDataMap : techDataList) {
            techIdSet.add(this.getLongValue(techDataMap, "id"));
        }
        return techIdSet;
    }

    private Set<String> queryExistsXTechAuditDelData(List<Map<String, Object>> techDataList, Long routeEntryId) {
        Set<Long> techIdSet = this.getTechIdSet(techDataList);
        HashSet<String> xTechSet = new HashSet<String>(16);
        if (techIdSet == null || techIdSet.isEmpty()) {
            return xTechSet;
        }
        String xHeadTable = "t_sfc_xmftorderentry_m";
        String xEntryTable = "t_sfc_xmanftechentry";
        StringBuilder sb = new StringBuilder();
        sb.append(" select");
        sb.append(" a.foprmanftechid ").append(" as ").append("ftechid");
        sb.append(",a.foprsourceentryid ").append(" as ").append("frouteentryid");
        sb.append(" from ").append(xHeadTable).append(" s ");
        sb.append(" inner join ").append(xEntryTable).append(" a on a.fid  = s.fid   ");
        sb.append(" where s.fbillstatus = 'C' and ");
        sb.append(" a.foprchangetype = 'C' and ");
        sb.append(" a.foprmanftechid in (");
        for (Long id : techIdSet) {
            sb.append(id).append(",");
        }
        sb.append("-1 )");
        sb.append(" and a.foprsourceentryid = '").append(routeEntryId).append("'");
        try (DataSet ds = DB.queryDataSet((String)this.getAlgoxKeyString("queryXTechNoAuditAddData"), (DBRoute)scmDBRoute, (String)sb.toString());){
            for (Row row : ds) {
                String ftechid = row.getString("ftechid");
                String frouteEntryid = row.getString("frouteentryid");
                String keyString = this.genXTechKeyString("A", ftechid, "A", frouteEntryid);
                xTechSet.add(keyString);
            }
        }
        return xTechSet;
    }

    private String genXTechKeyString(String queryType, String techId, String orderType, String routeEntryId) {
        return this.getUnionString(queryType, techId, orderType, routeEntryId);
    }

    private DynamicObject getEcoRouteEntryAfter(Map<Long, DynamicObject> ecoRouteEntryMap, DynamicObject ecoRouteEntryBefore) {
        Long routeEntryId = ecoRouteEntryBefore.getLong("oldprocessentryid");
        Long ecoRouteId = ecoRouteEntryBefore.getLong("ecorouteid");
        for (Map.Entry<Long, DynamicObject> entrys : ecoRouteEntryMap.entrySet()) {
            DynamicObject ecoRouteEntry = entrys.getValue();
            if (!this.isAfterModifyMode(ecoRouteEntry) || !routeEntryId.equals(ecoRouteEntry.getLong("oldprocessentryid")) || !ecoRouteId.equals(ecoRouteEntry.getLong("ecorouteid"))) continue;
            return ecoRouteEntry;
        }
        return null;
    }

    private boolean isDateMatch(Map<String, Object> techData, DynamicObject ecoRouteEntry, DynamicObject filterObj, Date minActtime) {
        Date acttime = ecoRouteEntry.getDate("acttime");
        Date planBeginTime = this.getDateValue(techData, "planstarttime");
        Date oprPlanBeginTime = this.getDateValue(techData, "oprentryentity.oprplanbegintime");
        boolean isAdd = this.isAddMode(ecoRouteEntry);
        if (isAdd) {
            String addMode = filterObj.getString("datematchbysfc");
            if ("A".equals(addMode)) {
                return acttime.compareTo(planBeginTime) <= 0;
            }
            if ("B".equals(addMode)) {
                if (minActtime == null) {
                    return acttime.compareTo(oprPlanBeginTime) > 0;
                }
                return acttime.compareTo(oprPlanBeginTime) > 0 && minActtime.compareTo(oprPlanBeginTime) <= 0;
            }
            if ("C".equals(addMode) && minActtime != null) {
                return minActtime.compareTo(oprPlanBeginTime) <= 0;
            }
        } else {
            String editMode = filterObj.getString("datematchbysfc");
            if ("A".equals(editMode)) {
                return acttime.compareTo(oprPlanBeginTime) <= 0;
            }
            if ("B".equals(editMode)) {
                if (minActtime == null) {
                    return acttime.compareTo(oprPlanBeginTime) > 0;
                }
                return acttime.compareTo(oprPlanBeginTime) > 0 && minActtime.compareTo(oprPlanBeginTime) <= 0;
            }
            if ("C".equals(editMode) && minActtime != null) {
                return minActtime.compareTo(oprPlanBeginTime) <= 0;
            }
        }
        return true;
    }

    private boolean isAfterTransmitStatus(Map<String, Object> techData) {
        String oprStatus = this.getStringValue(techData, "oprentryentity.oprstatus");
        return "D".equals(oprStatus) || "E".equals(oprStatus) || "F".equals(oprStatus) || "G".equals(oprStatus);
    }

    private List<Map<String, Object>> filterCurrentList(List<Map<String, Object>> techDataList, Long routeId, Set<Long> currentRouteEntryIdset, DynamicObject ecoRouteEntry, DynamicObject filterObj, Set<String> existDelOpSet) {
        ArrayList<Map<String, Object>> currentTechDataList = new ArrayList<Map<String, Object>>(techDataList.size());
        HashSet<String> techSet = new HashSet<String>(techDataList.size());
        HashSet<String> techEntrySet = new HashSet<String>(techDataList.size());
        Date minActtime = this.getMinDateByDelay(filterObj, null);
        boolean isforward = this.isForward(filterObj);
        boolean isDelete = this.isDisableModifyMode(ecoRouteEntry);
        boolean isAdd = this.isAddMode(ecoRouteEntry);
        for (int i = 0; i < techDataList.size(); ++i) {
            Map<String, Object> techData = techDataList.get(i);
            if (isforward && this.isAfterTransmitStatus(techData) && (isforward && isDelete || !isforward && isAdd)) {
                if (!this.isShowDetialLog()) continue;
                LogUtils.genLogs196(this.logs, filterObj, techData, ecoRouteEntry);
                continue;
            }
            Long techId = this.getLongValue(techData, "id");
            String orderType = this.getStringValue(techData, "ordertype");
            if (existDelOpSet != null) {
                Long routeEntryId = ecoRouteEntry.getLong("newprocessentryid");
                String keyString = this.genXTechKeyString("A", String.valueOf(techId), orderType, String.valueOf(routeEntryId));
                if (!existDelOpSet.contains(keyString)) {
                    if (!this.isShowDetialLog()) continue;
                    LogUtils.genLogs197(this.logs, filterObj, techData, ecoRouteEntry);
                    continue;
                }
            }
            if (!this.isDateMatch(techData, ecoRouteEntry, filterObj, minActtime)) {
                if (!this.isShowDetialLog()) continue;
                LogUtils.genLogs194(this.logs, filterObj, techData, ecoRouteEntry);
                continue;
            }
            Long oprRouteId = this.getLongValue(techData, "processroute");
            Long techEntryId = this.getLongValue(techData, "oprentryentity");
            boolean isMatch = true;
            boolean isSameRoute = oprRouteId.equals(routeId);
            if (isSameRoute && techEntrySet.add(techId + "_" + orderType + "_" + techEntryId)) {
                if (PlatformUtils.isNullSet(currentRouteEntryIdset)) {
                    if (!techSet.contains(techId + "_" + orderType) && (isMatch = this.isMatchTechByEcoRouteEntry(techData, ecoRouteEntry, filterObj))) {
                        currentTechDataList.add(techData);
                        techSet.add(techId + "_" + orderType);
                    }
                } else {
                    Long routeEntryId = this.getRouteEntryId(techData);
                    if (currentRouteEntryIdset.contains(routeEntryId) && (isMatch = this.isMatchTechByEcoRouteEntry(techData, ecoRouteEntry, filterObj))) {
                        currentTechDataList.add(techData);
                    }
                }
            }
            if (!isMatch && this.isShowDetialLog()) {
                LogUtils.genLogs195(this.logs, filterObj, techData, ecoRouteEntry);
            }
            if (isSameRoute || !this.isShowDetialLog()) continue;
            LogUtils.genLogs198(this.logs, filterObj, techData, ecoRouteEntry);
        }
        return currentTechDataList;
    }

    private boolean isMatchTechByEcoRouteEntry(Map<String, Object> techData, DynamicObject ecoRouteEntry, DynamicObject filterObj) {
        try {
            return EcoFilterFormulaBusiness.getInstance().chkIsMatch(ecoRouteEntry, techData, filterObj);
        }
        catch (RunFormulaException e) {
            log.error((Throwable)e);
            String entryMode = ecoRouteEntry.getString("entrymode");
            Long ecoRouteId = ecoRouteEntry.getLong("ecorouteid");
            String ecnBillNo = this.getEcnBillNo(ecoRouteId);
            throw new KDBizException(new ErrorCode("FromaulCheck", String.format(ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u5355[%1$s]\u4e0b\u884c\u6807\u8bc6[%2$s]\u4e0e\u5de5\u5e8f\u8ba1\u5212[%3$s]\u5728\u8fdb\u884c\u5339\u914d\u7ef4\u5ea6\u516c\u5f0f\u6821\u9a8c\u65f6\u51fa\u9519\uff1a%4$s\u3002", (String)"GetEcoEffectManuftechBusiness_1", (String)"mmc-pdm-business", (Object[])new Object[0]), ecnBillNo, entryMode, this.getTechDesc(techData), e.getMessage())), new Object[0]);
        }
    }

    private String getEcnBillNo(Long ecoRouteId) {
        HashMap<String, Object> cacheMap = new HashMap<String, Object>(16);
        return EcoRouteUtils.getEcoBillNo(ecoRouteId, cacheMap);
    }

    private String getTechDesc(Map<String, Object> techs) {
        return String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u5355\u53f7\uff1a%1$s\uff0c\u5de5\u5e8f\u5e8f\u53f7\uff1a%2$s\uff0c\u5de5\u5e8f\u53f7\uff1a%3$s", (String)"GetEcoEffectManuftechBusiness_5", (String)"mmc-pdm-business", (Object[])new Object[0]), techs.get("billno"), techs.get("oprentryentity.seq"), techs.get("oprentryentity.oprno"));
    }

    public boolean isValidDate(Date planStartTime, DynamicObject routeEntry) {
        Date validDate = routeEntry.getDate("entryvaliddate");
        Date inValidDate = routeEntry.getDate("entryinvaliddate");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String planStartTimes = sdf.format(planStartTime);
        String validDates = sdf.format(validDate);
        String inValidDates = sdf.format(inValidDate);
        return planStartTimes.compareTo(validDates) >= 0 && planStartTimes.compareTo(inValidDates) <= 0;
    }

    public String genDiffManuftechDataWithLog(Set<Long> routeIdSet, Set<Long> ecoBillIdSet, Set<Long> ecoRouteEntryIdSet, String pageCacheOption) {
        this.setIsShowDetialLog(Boolean.TRUE);
        this.setIsAddMutexLock(Boolean.FALSE);
        try {
            this.genDiffManuftechData(routeIdSet, ecoBillIdSet, ecoRouteEntryIdSet, pageCacheOption);
        }
        catch (Exception e) {
            this.logs.append(PlatformUtils.getExceptionString((Exception)e));
        }
        this.setIsShowDetialLog(Boolean.FALSE);
        return this.logs.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> autoCreateManuftechChange(Set<Long> allRouteIdSet, Set<Long> allEcoBillIdSet, Set<Long> allEcoRouteEntryIdSet, String srcType) {
        HashMap<String, Object> allResultMap = new HashMap<String, Object>(16);
        this.setIsAddMutexLock(this.isWithLockMutex(srcType));
        this.initAddMutexLockCache();
        try {
            List<Map<String, Object>> gridDataList = this.genDiffManuftechData(allRouteIdSet, allEcoBillIdSet, allEcoRouteEntryIdSet, null);
            if (this.allMutexLockErrors.length() > 0) {
                allResultMap.put("errormsg", this.allMutexLockErrors.toString());
                HashMap<String, Object> hashMap = allResultMap;
                return hashMap;
            }
            int allSize = gridDataList.size();
            List<Map<String, Object>> listData = gridDataList;
            log.info("------GetEcoEffectOrderBusiness----autoCreateManuftechChange------listData.size = " + listData.size());
            List<List<Map<String, Object>>> splitList = this.splitEffectData(listData);
            for (int i = 0; i < splitList.size(); ++i) {
                List<Map<String, Object>> subList = splitList.get(i);
                Map<String, Object> resultMap = new HashMap<String, Object>(16);
                AddEffectOrderBillBusiness addBusiness = new AddEffectOrderBillBusiness();
                List<Object> resultList = addBusiness.addData(subList, "B");
                if (resultList != null && !resultList.isEmpty()) {
                    try {
                        resultMap = addBusiness.genNextBillData(resultList, "B");
                        this.submitAndAuditXTech(resultMap);
                    }
                    catch (Exception e) {
                        log.error((Throwable)e);
                        addBusiness.deleteNextBillData(resultList);
                        resultMap.put("errormsg", e.getMessage());
                    }
                }
                this.mergeMap(allResultMap, resultMap);
            }
            allResultMap.put("allSize", allSize);
            HashMap<String, Object> hashMap = allResultMap;
            return hashMap;
        }
        finally {
            OrderMutexLockUtils.clearAllLocks(this.getAllMutexLockSuccessIds(), (String)"B");
            this.initAddMutexLockCache();
            this.setIsAddMutexLock(Boolean.FALSE);
        }
    }

    public Map<String, Object> submitAndAuditXTech(Map<String, Object> resultMap) {
        if (!this.isAutoSubmit()) {
            return resultMap;
        }
        List saveSuccessPkIds = PlatformUtils.getPkIdsFromMap(resultMap, (String)"xsfcmanftechids_sfc");
        Map<String, Object> dataMap = this.submitAndAuditXBill(saveSuccessPkIds, "sfc_xmanftech");
        this.setReturnMap(resultMap, dataMap);
        return resultMap;
    }

    public void mergeMap(Map<String, Object> allResultMap, Map<String, Object> resultMap) {
        String errormsg = resultMap.get("errormsg") == null ? "" : resultMap.get("errormsg").toString();
        this.mergeMsgString(errormsg, allResultMap);
        List xSfcManftechids2 = PlatformUtils.getPkIdsFromMap(resultMap, (String)"xsfcmanftechids_sfc");
        int allSize2 = resultMap.get("allSize") == null ? 0 : Integer.parseInt(resultMap.get("allSize").toString());
        List xSfcManftechids1 = PlatformUtils.getPkIdsFromMap(allResultMap, (String)"xsfcmanftechids_sfc");
        int allSize = allResultMap.get("allSize") == null ? 0 : Integer.parseInt(allResultMap.get("allSize").toString());
        List<Object> xSfcManftechids = this.mergeList(xSfcManftechids1, xSfcManftechids2);
        allResultMap.put("xsfcmanftechids_sfc", xSfcManftechids);
        int successSize = xSfcManftechids == null ? 0 : xSfcManftechids.size();
        allResultMap.put("allSize", allSize += allSize2);
        allResultMap.put("successSize", successSize);
        allResultMap.put("unSuccessSize", allSize - successSize);
    }

    public Map<String, Set<Long>> getEffectAllData(Set<Long> ecoRouteEntryIdSet, boolean isAll, boolean isShowUnAudit) {
        Set<Long> allEntryIdSet = ecoRouteEntryIdSet;
        if (isAll) {
            allEntryIdSet = EcoRouteUtils.getAllEcoRouteEntryIdSet(ecoRouteEntryIdSet);
        }
        if (allEntryIdSet == null || allEntryIdSet.isEmpty()) {
            return new HashMap<String, Set<Long>>(16);
        }
        HashSet<Long> routeIdSet = new HashSet<Long>(16);
        HashSet<Long> ecoBillIdSet = new HashSet<Long>(16);
        HashSet<Long> allEcoRouteEntryIdSet = new HashSet<Long>(16);
        SqlBuilder sb = new SqlBuilder();
        sb.append(" select", new Object[0]);
        sb.append(" h.fid ", new Object[0]);
        sb.append(",d2.fentryid as fecorouteentryid ", new Object[0]);
        sb.append(",d.frouteid as frouteid ", new Object[0]);
        sb.append(" from t_pdm_bom_eco h ", new Object[0]);
        sb.append(" inner join t_pdm_bomecopentry d on h.fid = d.fid  ", new Object[0]);
        sb.append(" inner join t_pdm_ecorouteoperation d2 on d2.fid = d.fecorouteid  ", new Object[0]);
        sb.append(" where  ", new Object[0]);
        sb.appendIn("d2.fentryid", allEntryIdSet.toArray());
        if (!isShowUnAudit) {
            sb.append(" and h.fbillstatus = 'C' ", new Object[0]);
        }
        sb.append(" and d.fentryversioncontrol = 'A'  ", new Object[0]);
        try (DataSet ds = DB.queryDataSet((String)this.getAlgoxKeyString("getRefEcoRouteEntryData"), (DBRoute)scmDBRoute, (SqlBuilder)sb);){
            for (Row row : ds) {
                Long ecobillid = row.getLong("fid");
                Long frouteid = row.getLong("frouteid");
                Long fecorouteentryid = row.getLong("fecorouteentryid");
                routeIdSet.add(frouteid);
                ecoBillIdSet.add(ecobillid);
                allEcoRouteEntryIdSet.add(fecorouteentryid);
            }
        }
        HashMap<String, Set<Long>> dataMap = new HashMap<String, Set<Long>>(16);
        dataMap.put("ecoBillIdSet", ecoBillIdSet);
        dataMap.put("routeIdSet", routeIdSet);
        dataMap.put("allEcoRouteEntryIdSet", allEcoRouteEntryIdSet);
        return dataMap;
    }

    private Map<String, Object> updateByAllData(Set<Long> ecoRouteEntryIdSet, boolean isAll) {
        Map<String, Set<Long>> allData = this.getEffectAllData(ecoRouteEntryIdSet, isAll, false);
        if (allData == null || allData.isEmpty()) {
            return new HashMap<String, Object>(16);
        }
        Set<Long> ecoBillIdSet = allData.get("ecoBillIdSet");
        Set<Long> routeIdSet = allData.get("routeIdSet");
        Set<Long> allEcoRouteEntryIdSet = allData.get("allEcoRouteEntryIdSet");
        return this.autoCreateManuftechChange(routeIdSet, ecoBillIdSet, allEcoRouteEntryIdSet, "updateByAllData");
    }

    public Map<String, Object> createManuftechChangeByPentryId(Set<Long> pentryIdSet) {
        if (pentryIdSet.isEmpty()) {
            return new HashMap<String, Object>(16);
        }
        SqlBuilder sb = new SqlBuilder();
        sb.append(" select", new Object[0]);
        sb.append(" h.fid ", new Object[0]);
        sb.append(",d2.fentryid as fecorouteentryid ", new Object[0]);
        sb.append(",d.frouteid as frouteid ", new Object[0]);
        sb.append(",h.fauditdate as fauditdate ", new Object[0]);
        sb.append(",d2.facttime as facttime ", new Object[0]);
        sb.append(",d.fseq as fpseq ", new Object[0]);
        sb.append(" from t_pdm_bom_eco h ", new Object[0]);
        sb.append(" inner join t_pdm_bomecopentry d on h.fid = d.fid  ", new Object[0]);
        sb.append(" inner join t_pdm_ecorouteoperation d2 on d2.fid = d.fecorouteid  ", new Object[0]);
        sb.append(" where  ", new Object[0]);
        sb.appendIn("d.fentryid", pentryIdSet.toArray());
        sb.append(" and d.fentryversioncontrol = 'A'  ", new Object[0]);
        HashMap splitMap = new HashMap(16);
        ArrayList<String> sortKetList = new ArrayList<String>(16);
        try (DataSet ds = DB.queryDataSet((String)this.getAlgoxKeyString("createManuftechChangeByPentryId"), (DBRoute)scmDBRoute, (SqlBuilder)sb).orderBy(new String[]{"facttime", "fauditdate", "fid", "fpseq"});){
            for (Row row : ds) {
                Long ecobillid = row.getLong("fid");
                Long frouteid = row.getLong("frouteid");
                Long fecorouteentryid = row.getLong("fecorouteentryid");
                String keyString = String.valueOf(frouteid);
                HashMap<String, HashSet> aMap = (HashMap<String, HashSet>)splitMap.get(keyString);
                if (aMap == null) {
                    aMap = new HashMap<String, HashSet>(16);
                }
                HashSet routeIdSet = aMap.get("routeIdSet") == null ? new HashSet(16) : (HashSet)aMap.get("routeIdSet");
                HashSet ecoBillIdSet = aMap.get("ecoBillIdSet") == null ? new HashSet(16) : (HashSet)aMap.get("ecoBillIdSet");
                HashSet ecoRouteEntryIdSet = aMap.get("ecoRouteEntryIdSet") == null ? new HashSet(16) : (HashSet)aMap.get("ecoRouteEntryIdSet");
                routeIdSet.add(frouteid);
                ecoBillIdSet.add(ecobillid);
                ecoRouteEntryIdSet.add(fecorouteentryid);
                aMap.put("routeIdSet", routeIdSet);
                aMap.put("ecoBillIdSet", ecoBillIdSet);
                aMap.put("ecoRouteEntryIdSet", ecoRouteEntryIdSet);
                splitMap.put(keyString, aMap);
                if (sortKetList.contains(keyString)) continue;
                sortKetList.add(keyString);
            }
        }
        HashMap<String, Object> allResultMap = new HashMap<String, Object>(16);
        for (int i = 0; i < sortKetList.size(); ++i) {
            String keyString = (String)sortKetList.get(i);
            Map aMap = (Map)splitMap.get(keyString);
            HashSet routeIdSet = aMap.get("routeIdSet") == null ? new HashSet(16) : (HashSet)aMap.get("routeIdSet");
            HashSet ecoBillIdSet = aMap.get("ecoBillIdSet") == null ? new HashSet(16) : (HashSet)aMap.get("ecoBillIdSet");
            HashSet ecoRouteEntryIdSet = aMap.get("ecoRouteEntryIdSet") == null ? new HashSet(16) : (HashSet)aMap.get("ecoRouteEntryIdSet");
            Map<String, Object> aResultMap = this.autoCreateManuftechChange(routeIdSet, ecoBillIdSet, ecoRouteEntryIdSet, "createManuftechChangeByPentryId");
            this.mergeMap(allResultMap, aResultMap);
        }
        return allResultMap;
    }

    public Map<String, Object> createManftechChangeByKey(Set<Long> ecoRouteEntryIdSet, boolean isAll) {
        if (ecoRouteEntryIdSet.isEmpty()) {
            return new HashMap<String, Object>(16);
        }
        return this.updateByAllData(ecoRouteEntryIdSet, isAll);
    }

    public List<List<Map<String, Object>>> splitEffectData(List<Map<String, Object>> lists) {
        ArrayList<List<Map<String, Object>>> splitList = new ArrayList<List<Map<String, Object>>>(16);
        int size = lists.size();
        if (size <= 100) {
            splitList.add(lists);
            return splitList;
        }
        ArrayList<Map<String, Object>> childList = new ArrayList<Map<String, Object>>(100);
        for (int i = 0; i < size; ++i) {
            Map<String, Object> datas = lists.get(i);
            childList.add(datas);
            int childSize = childList.size();
            if (childSize < 100) continue;
            splitList.add(childList);
            childList = new ArrayList(100);
        }
        if (!childList.isEmpty()) {
            splitList.add(childList);
        }
        log.info("-----------splitEffectOrderData------splitList.size=" + splitList.size() + ",lists.size = " + lists.size());
        return splitList;
    }

    private void initUnAuditEntrys(Map<Long, DynamicObject> ecoRouteEntryMap, Map<Long, DynamicObject> routeEntryMap, Map<Long, DynamicObject> changeBillMap) {
        for (Map.Entry<Long, DynamicObject> ecoEntryMaps : ecoRouteEntryMap.entrySet()) {
            DynamicObject processEntry;
            DynamicObject ecoRouteEntry = ecoEntryMaps.getValue();
            Long newProcessEntryId = ecoRouteEntry.getLong("newprocessentryid");
            Long ecoRouteId = ecoRouteEntry.getLong("ecorouteid");
            DynamicObject changeBill = changeBillMap.get(ecoRouteId);
            boolean isAuditChangeBill = this.isAuditStatus(changeBill);
            if (isAuditChangeBill || (processEntry = routeEntryMap.get(newProcessEntryId)) != null) continue;
            Long routeId = this.getRouteId(changeBill, processEntry, ecoRouteId);
            processEntry = this.buildProcessEntry(ecoRouteEntry, routeId);
            newProcessEntryId = processEntry.getLong("entryid");
            routeEntryMap.put(newProcessEntryId, processEntry);
            ecoRouteEntry.set("newprocessentryid", (Object)newProcessEntryId);
        }
    }

    public DynamicObject buildProcessEntry(DynamicObject ecoRouteEntry, Long routeId) {
        DynamicObject routeEntry = BusinessDataServiceHelper.newDynamicObject((String)"pdm_route_processentry");
        Long entryID = ID.genLongId();
        routeEntry.set("id", (Object)entryID);
        routeEntry.set("entryid", (Object)entryID);
        routeEntry.set("entryseq", (Object)0);
        routeEntry.set("entryvaliddate", ecoRouteEntry.get("entryvaliddate"));
        routeEntry.set("entryinvaliddate", ecoRouteEntry.get("entryinvaliddate"));
        routeEntry.set("operation", ecoRouteEntry.get("operation"));
        routeEntry.set("parent", ecoRouteEntry.get("parent"));
        routeEntry.set("operationno", ecoRouteEntry.get("operationno"));
        routeEntry.set("machiningtype", ecoRouteEntry.get("machiningtype"));
        routeEntry.set("productionorg", ecoRouteEntry.get("productionorg"));
        routeEntry.set("workcenter", ecoRouteEntry.get("workcenter"));
        routeEntry.set("operationdesc", ecoRouteEntry.get("operationdesc"));
        routeEntry.set("oprctrlstrategy", ecoRouteEntry.get("oprctrlstrategy"));
        routeEntry.set("operationqty", ecoRouteEntry.get("operationqty"));
        routeEntry.set("operationunit", ecoRouteEntry.get("operationunit"));
        routeEntry.set("collaborative", ecoRouteEntry.get("collaborative"));
        routeEntry.set("ismilestoneprocess", ecoRouteEntry.get("ismilestoneprocess"));
        routeEntry.set("storagepoint", ecoRouteEntry.get("storagepoint"));
        routeEntry.set("routeid", (Object)routeId);
        routeEntry.set("headqty", ecoRouteEntry.get("headqty"));
        routeEntry.set("basebatchqty", ecoRouteEntry.get("basebatchqty"));
        routeEntry.set("headunit", ecoRouteEntry.get("headunit"));
        return routeEntry;
    }

    public Long getRouteEntryId(Map<String, Object> techData) {
        Long routeEntryId = 0L;
        String routeEntryIds = this.getStringValue(techData, "oprentryentity.oprsourceentryid");
        if (routeEntryIds != null && !"".equals(routeEntryIds)) {
            routeEntryId = Long.parseLong(routeEntryIds);
        }
        return routeEntryId;
    }
}

