/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.business.ecoplatform;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.mftorderbom.utils.BomBaseData;
import kd.bd.mpdm.common.query.helper.MaterialMftQueryHelper;
import kd.bd.mpdm.common.query.helper.MaterialQueryHelper;
import kd.bd.mpdm.common.query.helper.TransactionTypeQueryHelper;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.formula.platform.engine.RunFormulaException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.mmc.pdm.business.ecoplatform.AddEffectOrderBillBusiness;
import kd.mmc.pdm.business.ecoplatform.EcoCommonBusiness;
import kd.mmc.pdm.business.ecoplatform.EcoFilterFormulaBusiness;
import kd.mmc.pdm.business.ecoplatform.EcoUtils;
import kd.mmc.pdm.business.ecoplatform.ExpandBomByConfigBom;
import kd.mmc.pdm.business.ecoplatform.ExpandBomByMulType;
import kd.mmc.pdm.business.ecoplatform.log.LogUtils;
import kd.mmc.pdm.common.bom.bean.Fraction;
import kd.mmc.pdm.common.bom.ecoplatform.OrderMutexLockUtils;
import kd.mmc.pdm.common.bom.ecoplatform.PlatformUtils;
import kd.mmc.pdm.common.util.MMCUtils;
import kd.mmc.pdm.common.util.PdmParamSetHelper;

public class GetEcoEffectOrderBusiness
extends EcoCommonBusiness {
    private static final Log log = LogFactory.getLog(GetEcoEffectOrderBusiness.class);
    private static final int EFFECTORDERBATCHMAXSIZE = 100;
    private String EXPANDBOMTIMEMODE = "";
    private static GetEcoEffectOrderBusiness impl;

    public static GetEcoEffectOrderBusiness getInstance() {
        if (impl == null) {
            impl = new GetEcoEffectOrderBusiness();
        }
        return impl;
    }

    public List<Map<String, Object>> genDiffStockData(Set<Long> childBomIdSet, Set<Long> ecoBillIdSet, Set<Long> ecoBomEntryIdSet, String pageCacheOption) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(128);
        if (PlatformUtils.isNullSet(childBomIdSet) || PlatformUtils.isNullSet(ecoBillIdSet) || PlatformUtils.isNullSet(ecoBomEntryIdSet)) {
            return resultList;
        }
        this.EXPANDBOMTIMEMODE = null;
        this.initLogs();
        if (this.isShowDetialLog()) {
            LogUtils.genLogs0(this.logs);
        }
        long startTime = System.currentTimeMillis();
        Map<Object, DynamicObject> filterMap = this.getEcoFilterMap("A");
        if (filterMap == null || filterMap.isEmpty()) {
            if (this.isShowDetialLog()) {
                LogUtils.genLogs92(this.logs);
            }
            return resultList;
        }
        HashSet<Long> mftBomEntryIdSet = new HashSet<Long>(16);
        HashSet<Long> childMaterialIdSet = new HashSet<Long>(16);
        ArrayList<Long> sortEntryIdList = new ArrayList<Long>(16);
        Set<String> filterExtFieldSet = this.getSrcMatchFieldSet(filterMap);
        Map<Long, DynamicObject> ecobomEntryMap = this.getEcoBomEntryData(ecoBomEntryIdSet, mftBomEntryIdSet, childMaterialIdSet, sortEntryIdList, filterExtFieldSet);
        Map<String, Date> minMaxDateMap = this.getMinMaxActtime(ecobomEntryMap);
        Date minActTime = this.getDate(minMaxDateMap, "min");
        Date maxActTime = this.getDate(minMaxDateMap, "max");
        Date hisMinActTime = null;
        if (this.isShowDetialLog()) {
            LogUtils.genLogs1(this.logs, ecobomEntryMap, ecoBomEntryIdSet, mftBomEntryIdSet, childMaterialIdSet, minActTime, maxActTime, hisMinActTime);
        }
        int allCount = 0;
        int indexInt = 0;
        if (!StringUtils.isEmpty((String)pageCacheOption)) {
            allCount = this.getAllBillCount(ecobomEntryMap);
            PageCache pageCache = new PageCache(pageCacheOption);
            pageCache.put("dealnum", Integer.toString(allCount));
            pageCache.put("steptitlename", ResManager.loadKDString((String)"\u6b63\u5728\u8fdb\u884c\u6570\u636e\u67e5\u8be2\u5206\u6790\u3002", (String)"GetEcoEffectOrderBusiness_15", (String)"mmc-pdm-business", (Object[])new Object[0]));
        }
        Map<Long, DynamicObject> mftBomEntryMap = this.getMftBomEntryData(mftBomEntryIdSet);
        Map<Long, DynamicObject> changeBillMap = this.getEcoChangeBillData(ecoBillIdSet);
        Map<Object, DynamicObject> mftBomMap = this.getMftBomData(childBomIdSet);
        HashSet<Long> queryDbBomIdSet = new HashSet<Long>(16);
        HashSet<Long> queryDbBomEntryIdSet = new HashSet<Long>(16);
        this.initUnAuditEntrys(ecobomEntryMap, mftBomEntryMap, changeBillMap);
        boolean hasBackFlow = this.isContainBackFlow(filterMap);
        for (Long ecoBomEntryId : sortEntryIdList) {
            DynamicObject ecoBomEntry = ecobomEntryMap.get(ecoBomEntryId);
            Long bomentryId = ecoBomEntry.getLong("bomentry");
            Long ecoBomId = ecoBomEntry.getLong("ecobomid");
            DynamicObject changeBill = changeBillMap.get(ecoBomId);
            boolean bl = this.isAuditStatus(changeBill);
            if (bl && PlatformUtils.isNullLong((Long)bomentryId)) continue;
            DynamicObject bomEntry = mftBomEntryMap.get(bomentryId);
            Long bomId = this.getBomId(changeBill, bomEntry, ecoBomId);
            if (bl) {
                this.valideBomEntryExists(bomEntry, bomentryId, changeBill, this.getLongId(ecoBomEntry, "entrymaterial"), this.getLongId(ecoBomEntry, "featuretype"));
            }
            if (this.isAddMode(ecoBomEntry) || hasBackFlow && this.isDisableModifyMode(ecoBomEntry)) {
                queryDbBomIdSet.add(bomId);
            }
            queryDbBomEntryIdSet.add(bomentryId);
        }
        if (!StringUtils.isEmpty((String)pageCacheOption)) {
            PageCache pageCache = new PageCache(pageCacheOption);
            pageCache.put("opProgressPro", String.valueOf(0));
            pageCache.put("steptitlename", "");
        }
        HashMap<Long, Boolean> charaRuleMap = new HashMap<Long, Boolean>(16);
        this.initCharaRuleno(queryDbBomEntryIdSet, queryDbBomIdSet, charaRuleMap);
        HashMap<String, List<Map<String, Object>>> pmaterialCacheMap = new HashMap<String, List<Map<String, Object>>>(16);
        HashMap<String, String> bomResultCacheMap = new HashMap<String, String>(16);
        int allStep = ecobomEntryMap.size();
        HashMap<String, Set<Long>> dataCacheMap = new HashMap<String, Set<Long>>(16);
        allCount *= filterMap.size();
        for (Map.Entry entry : filterMap.entrySet()) {
            DynamicObject filterObj = (DynamicObject)entry.getValue();
            long loopStartTime = System.currentTimeMillis();
            boolean isForward = this.isForward(filterObj);
            String stockEntityNumber = (String)filterObj.getDynamicObject("objectentity").getPkValue();
            if (this.isShowDetialLog()) {
                LogUtils.genLogs96(this.logs, filterObj);
            }
            ArrayList<Map<String, Object>> stockDataList = new ArrayList<Map<String, Object>>(128);
            QFilter addOtherFilter = this.genDateQueryFilter(maxActTime, minActTime, hisMinActTime, filterObj, Boolean.TRUE);
            QFilter editOtherFilter = this.genDateQueryFilter(maxActTime, minActTime, hisMinActTime, filterObj, Boolean.FALSE);
            List<Map<String, Object>> addStockList = null;
            List<Map<String, Object>> editStockList = null;
            if (!queryDbBomIdSet.isEmpty()) {
                addStockList = this.getMftStockDataByBomId(queryDbBomIdSet, addOtherFilter, filterObj);
            }
            if (!queryDbBomEntryIdSet.isEmpty()) {
                editStockList = this.getMftStockDataByBomEntryId(queryDbBomEntryIdSet, editOtherFilter, filterObj);
            }
            if (!PlatformUtils.isNullList(addStockList)) {
                stockDataList.addAll(addStockList);
            }
            if (!PlatformUtils.isNullList(editStockList)) {
                if (stockDataList.isEmpty()) {
                    stockDataList.addAll(editStockList);
                } else {
                    Set stockEntryIdSet = stockDataList.stream().map(p -> Long.parseLong(p.get("stockentry").toString())).collect(Collectors.toSet());
                    for (Map<String, Object> data : editStockList) {
                        Long stockEntryId = this.getLongValue(data, "stockentry");
                        if (stockEntryIdSet.contains(stockEntryId)) continue;
                        stockDataList.add(data);
                    }
                }
            }
            if (this.isShowDetialLog()) {
                LogUtils.genLogs93(this.logs, filterObj, stockEntityNumber, isForward, addOtherFilter, editOtherFilter, queryDbBomIdSet, queryDbBomEntryIdSet, addStockList, editStockList);
            }
            if (PlatformUtils.isNullList(stockDataList)) continue;
            HashMap<Long, List<Map<String, Object>>> wsMap = new HashMap<Long, List<Map<String, Object>>>(16);
            if (this.isAddMutexLock()) {
                HashMap<String, Set<Long>> successIdMaps = new HashMap<String, Set<Long>>(16);
                String lockErrorMsg = OrderMutexLockUtils.addAllLocks(stockDataList, successIdMaps, this.getAddMutexRepeatKeySet(), (String)"A");
                this.dealMutexLockResult(successIdMaps, lockErrorMsg);
                if (!StringUtils.isEmpty((String)lockErrorMsg)) {
                    OrderMutexLockUtils.clearAllLocks(successIdMaps, (String)"A");
                    log.info("-----genDiffStockData.addMutexLock Failed,\u6570\u636e\u6e90=" + filterObj.getString("name") + ",stockDataList.size=" + stockDataList.size() + ",lockErrorMsg=" + (String)lockErrorMsg);
                    continue;
                }
            }
            Map<String, String> xStockMap = this.getXStockDataMap(stockDataList);
            for (Long ecoBomEntryId : sortEntryIdList) {
                Set<String> existsEditKeySet;
                Long bomentryId;
                DynamicObject ecoBomEntry = ecobomEntryMap.get(ecoBomEntryId);
                if (this.isAfterModifyMode(ecoBomEntry) || PlatformUtils.isNullLong((Long)(bomentryId = Long.valueOf(ecoBomEntry.getLong("bomentry"))))) continue;
                DynamicObject bomEntry = mftBomEntryMap.get(bomentryId);
                Long ecoBomId = ecoBomEntry.getLong("ecobomid");
                DynamicObject changeBill = changeBillMap.get(ecoBomId);
                Long bomId = bomEntry.getLong("bomid");
                ++indexInt;
                if (!StringUtils.isEmpty((String)pageCacheOption)) {
                    PageCache pageCache = new PageCache(pageCacheOption);
                    int stepProgress = (indexInt - 1) * 100 / allCount;
                    if (stepProgress >= 100) {
                        stepProgress = 99;
                    }
                    pageCache.put("opProgressPro", String.valueOf(stepProgress));
                    if (PlatformUtils.isStop((String)pageCacheOption)) {
                        return new ArrayList<Map<String, Object>>(16);
                    }
                }
                DynamicObject ecoBomEntryAfter = null;
                Long afterBomentryId = 0L;
                if (this.isBeforeModifyMode(ecoBomEntry) && (ecoBomEntryAfter = this.getEcoBomEntryAfter(ecobomEntryMap, ecoBomEntry)) != null) {
                    afterBomentryId = ecoBomEntryAfter.getLong("bomentry");
                }
                List<Map<String, Object>> currentStockDataList = null;
                HashSet<Long> currentBomentryIdset = new HashSet<Long>(16);
                currentBomentryIdset.add(bomentryId);
                List<Map<String, Object>> currentGridList = null;
                if (this.isAddMode(ecoBomEntry)) {
                    if (isForward) {
                        existsEditKeySet = null;
                        List<Map<String, Object>> existStockDataList = this.filterCurrentList(stockDataList, bomId, currentBomentryIdset, ecoBomEntry, filterObj, Boolean.TRUE);
                        if (!PlatformUtils.isNullList(existStockDataList)) {
                            DynamicObject initeEoBomEntry = this.initBomEntry(ecoBomEntry);
                            currentGridList = this.getEditDataStock(existStockDataList, mftBomEntryMap, initeEoBomEntry, ecoBomEntry, changeBill, mftBomMap, xStockMap, bomResultCacheMap, wsMap, dataCacheMap, charaRuleMap, pmaterialCacheMap, filterObj);
                            if (!PlatformUtils.isNullList(currentGridList)) {
                                resultList.addAll(currentGridList);
                            }
                            existsEditKeySet = this.getAddExistsKeySet(existStockDataList);
                            currentGridList = null;
                        }
                        currentStockDataList = this.filterCurrentList(stockDataList, bomId, null, ecoBomEntry, filterObj, Boolean.FALSE);
                        currentStockDataList = this.removeExistsStockData(currentStockDataList, existsEditKeySet);
                        currentGridList = this.getAddDataStock(currentStockDataList, mftBomEntryMap, ecoBomEntry, changeBill, mftBomMap, xStockMap, bomResultCacheMap, 0L, wsMap, dataCacheMap, charaRuleMap, pmaterialCacheMap, 0L, filterObj);
                    } else {
                        currentStockDataList = this.filterCurrentList(stockDataList, bomId, currentBomentryIdset, ecoBomEntry, filterObj, Boolean.FALSE);
                        currentGridList = this.getDisableDataStock(currentStockDataList, bomEntry, ecoBomEntry, changeBill, xStockMap, 0L, filterObj);
                    }
                } else if (this.isDisableModifyMode(ecoBomEntry)) {
                    currentStockDataList = this.filterCurrentList(stockDataList, bomId, currentBomentryIdset, ecoBomEntry, filterObj, Boolean.FALSE);
                    if (isForward) {
                        currentGridList = this.getDisableDataStock(currentStockDataList, bomEntry, ecoBomEntry, changeBill, xStockMap, 0L, filterObj);
                    } else {
                        existsEditKeySet = null;
                        if (!PlatformUtils.isNullList(currentStockDataList)) {
                            DynamicObject initeEoBomEntry = this.initBomEntry(ecoBomEntry);
                            currentGridList = this.getEditDataStock(currentStockDataList, mftBomEntryMap, initeEoBomEntry, ecoBomEntry, changeBill, mftBomMap, xStockMap, bomResultCacheMap, wsMap, dataCacheMap, charaRuleMap, pmaterialCacheMap, filterObj);
                            if (!PlatformUtils.isNullList(currentGridList)) {
                                resultList.addAll(currentGridList);
                            }
                            existsEditKeySet = this.getAddExistsKeySet(currentStockDataList);
                            currentGridList = null;
                        }
                        if (!PlatformUtils.isNullList(currentStockDataList = this.filterCurrentList(stockDataList, bomId, null, ecoBomEntry, filterObj, Boolean.TRUE))) {
                            currentStockDataList = this.removeExistsStockData(currentStockDataList, existsEditKeySet);
                            currentGridList = this.getAddDataStock(currentStockDataList, mftBomEntryMap, ecoBomEntry, changeBill, mftBomMap, xStockMap, bomResultCacheMap, 0L, wsMap, dataCacheMap, charaRuleMap, pmaterialCacheMap, 0L, filterObj);
                        }
                    }
                } else {
                    currentBomentryIdset.add(afterBomentryId);
                    currentStockDataList = this.filterCurrentList(stockDataList, bomId, currentBomentryIdset, ecoBomEntry, filterObj, Boolean.FALSE);
                    currentGridList = isForward ? this.getEditDataStock(currentStockDataList, mftBomEntryMap, ecoBomEntry, ecoBomEntryAfter, changeBill, mftBomMap, xStockMap, bomResultCacheMap, wsMap, dataCacheMap, charaRuleMap, pmaterialCacheMap, filterObj) : this.getEditDataStock(currentStockDataList, mftBomEntryMap, ecoBomEntryAfter, ecoBomEntry, changeBill, mftBomMap, xStockMap, bomResultCacheMap, wsMap, dataCacheMap, charaRuleMap, pmaterialCacheMap, filterObj);
                }
                if (PlatformUtils.isNullList(currentGridList)) continue;
                resultList.addAll(currentGridList);
            }
            if (this.isShowDetialLog()) {
                LogUtils.genLogs97(this.logs, filterObj);
            }
            long loopEnddate = System.currentTimeMillis() - loopStartTime;
            log.info("mmc-pdm-genDiffStockData,loopCost:" + loopEnddate + "ms,stockEntityNumber=" + stockEntityNumber + ",isForward=" + isForward + ",sortEntryIdList.size=" + sortEntryIdList.size());
        }
        long enddate = System.currentTimeMillis() - startTime;
        log.info("mmc-pdm-genDiffStockData,allCost:" + enddate + "ms,resultList.size=" + resultList.size() + ",allStep=" + allStep);
        List<Map<String, Object>> resultAllList = this.repeatResultData(resultList);
        if (this.isShowDetialLog()) {
            LogUtils.genLogs100(this.logs);
        }
        return resultAllList;
    }

    public DynamicObject initBomEntry(DynamicObject entry) {
        DynamicObject copy = PlatformUtils.copyDynamicObject((DynamicObject)entry);
        copy.set("entryqtynumerator", (Object)BigDecimal.ZERO);
        return copy;
    }

    public String genDiffStockDataWithLog(Set<Long> childBomIdSet, Set<Long> ecoBillIdSet, Set<Long> ecoBomEntryIdSet, String pageCacheOption) {
        this.setIsShowDetialLog(Boolean.TRUE);
        this.setIsAddMutexLock(Boolean.FALSE);
        try {
            this.genDiffStockData(childBomIdSet, ecoBillIdSet, ecoBomEntryIdSet, pageCacheOption);
        }
        catch (Exception e) {
            this.logs.append(PlatformUtils.getExceptionString((Exception)e));
        }
        this.setIsShowDetialLog(Boolean.FALSE);
        return this.logs.toString();
    }

    private List<Map<String, Object>> repeatResultData(List<Map<String, Object>> resultList) {
        int size = resultList.size();
        HashSet<String> repeatKeySet = new HashSet<String>(size);
        ArrayList<Map<String, Object>> repeatResultList = new ArrayList<Map<String, Object>>(size);
        for (int i = 0; i < size; ++i) {
            Map<String, Object> dataMap = resultList.get(i);
            if (!repeatKeySet.add(this.getRepeatKeyString(dataMap))) continue;
            repeatResultList.add(dataMap);
        }
        if (this.isShowDetialLog() && repeatResultList.size() != size) {
            LogUtils.genLogs91(this.logs, size, repeatResultList.size());
        }
        return repeatResultList;
    }

    private String getRepeatKeyString(Map<String, Object> dataMap) {
        StringBuilder sf = new StringBuilder();
        sf.append(this.getLongValue(dataMap, "stockid"));
        sf.append("_");
        if ("C".equals(this.getStringValue(dataMap, "changetype"))) {
            sf.append(this.getLongValue(dataMap, "bomentryid"));
        } else {
            sf.append(this.getLongValue(dataMap, "stockentryid"));
        }
        sf.append("_");
        sf.append(this.getStringValue(dataMap, "materialmasterid"));
        sf.append("_");
        sf.append(this.getStringValue(dataMap, "changetype"));
        sf.append("_");
        sf.append(this.getStringValue(dataMap, "ordertype"));
        sf.append("_");
        sf.append(this.getLongValue(dataMap, "ecopentyrid"));
        return sf.toString();
    }

    private List<Map<String, Object>> filterCurrentList(List<Map<String, Object>> stockDataList, Long bomId, Set<Long> currentBomentryIdset, DynamicObject ecoBomEntry, DynamicObject filterObj, boolean isZero) {
        ArrayList<Map<String, Object>> currentStockDataList = new ArrayList<Map<String, Object>>(stockDataList.size());
        HashSet<String> stockSet = new HashSet<String>(stockDataList.size());
        HashSet<String> stockEntrySet = new HashSet<String>(stockDataList.size());
        Date minActtime = this.getMinDateByDelay(filterObj, null);
        for (int i = 0; i < stockDataList.size(); ++i) {
            Map<String, Object> stockData = stockDataList.get(i);
            if (isZero && currentBomentryIdset != null && this.getBigDecimalValue(stockData, "stockentry.qtynumerator").compareTo(BigDecimal.ZERO) != 0) continue;
            if (!this.isDateMatch(stockData, ecoBomEntry, filterObj, minActtime)) {
                if (!this.isShowDetialLog()) continue;
                LogUtils.genLogs94(this.logs, filterObj, stockData, ecoBomEntry);
                continue;
            }
            Long childBomId = this.getLongValue(stockData, "stockentry.childbomid");
            Long bomEntryId = this.getLongValue(stockData, "stockentry.bomentryid");
            Long stockId = this.getLongValue(stockData, "id");
            Long stockEntryId = this.getLongValue(stockData, "stockentry");
            String orderType = this.getStringValue(stockData, "ordertype");
            boolean isMatch = true;
            boolean isSameBom = childBomId.equals(bomId);
            if (isSameBom && stockEntrySet.add(stockId + "_" + orderType + "_" + stockEntryId)) {
                if (PlatformUtils.isNullSet(currentBomentryIdset)) {
                    if (!stockSet.contains(stockId + "_" + orderType) && (isMatch = this.isMatchStockByEcoBomEntry(stockData, ecoBomEntry, filterObj))) {
                        currentStockDataList.add(stockData);
                        stockSet.add(stockId + "_" + orderType);
                    }
                } else if (currentBomentryIdset.contains(bomEntryId) && (isMatch = this.isMatchStockByEcoBomEntry(stockData, ecoBomEntry, filterObj))) {
                    currentStockDataList.add(stockData);
                }
            }
            if (!isMatch && this.isShowDetialLog()) {
                LogUtils.genLogs95(this.logs, filterObj, stockData, ecoBomEntry);
            }
            if (isSameBom || !this.isShowDetialLog()) continue;
            LogUtils.genLogs98(this.logs, filterObj, stockData, ecoBomEntry);
        }
        return currentStockDataList;
    }

    private Set<String> getAddExistsKeySet(List<Map<String, Object>> stockDataList) {
        HashSet<String> stockEntrySet = new HashSet<String>(stockDataList.size());
        for (int i = 0; i < stockDataList.size(); ++i) {
            Map<String, Object> stockData = stockDataList.get(i);
            Long childBomId = this.getLongValue(stockData, "stockentry.childbomid");
            Long stockId = this.getLongValue(stockData, "id");
            String orderType = this.getStringValue(stockData, "ordertype");
            String addKeyString = this.getUnionString(stockId, orderType, childBomId, "");
            stockEntrySet.add(addKeyString);
        }
        return stockEntrySet;
    }

    private List<Map<String, Object>> removeExistsStockData(List<Map<String, Object>> stockDataList, Set<String> existsKeySet) {
        if (PlatformUtils.isNullSet(existsKeySet)) {
            return stockDataList;
        }
        ArrayList<Map<String, Object>> newStockDataList = new ArrayList<Map<String, Object>>(stockDataList.size());
        for (int i = 0; i < stockDataList.size(); ++i) {
            String orderType;
            Map<String, Object> stockData = stockDataList.get(i);
            Long childBomId = this.getLongValue(stockData, "stockentry.childbomid");
            Long stockId = this.getLongValue(stockData, "id");
            String addKeyString = this.getUnionString(stockId, orderType = this.getStringValue(stockData, "ordertype"), childBomId, "");
            if (existsKeySet.contains(addKeyString)) continue;
            newStockDataList.add(stockData);
        }
        return newStockDataList;
    }

    private boolean isMatchStockByEcoBomEntry(Map<String, Object> stockData, DynamicObject ecoBomEntry, DynamicObject filterObj) {
        try {
            return EcoFilterFormulaBusiness.getInstance().chkIsMatch(ecoBomEntry, stockData, filterObj);
        }
        catch (RunFormulaException e) {
            log.error((Throwable)e);
            String entryMode = ecoBomEntry.getString("entrymode");
            Long ecoBomId = ecoBomEntry.getLong("ecobomid");
            String ecnBillNo = this.getEcnBillNo(ecoBomId);
            throw new KDBizException(new ErrorCode("FromaulCheck", String.format(ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u5355\u201c%1$s\u201d\u4e0b\u884c\u6807\u8bc6\u201c%2$s\u201d\u4e0e\u7ec4\u4ef6\u6e05\u5355\u201c%3$s\u201d\u5728\u8fdb\u884c\u5339\u914d\u7ef4\u5ea6\u516c\u5f0f\u6821\u9a8c\u65f6\u51fa\u9519\uff1a%4$s\u3002", (String)"GetEcoEffectOrderBusiness_24", (String)"mmc-pdm-business", (Object[])new Object[0]), ecnBillNo, entryMode, this.getStockDesc(stockData), e.getMessage())), new Object[0]);
        }
    }

    private String getEcnBillNo(Long ecoBomId) {
        HashMap<String, Object> cacheMap = new HashMap<String, Object>(16);
        return EcoUtils.getEcoBillNo(ecoBomId, cacheMap);
    }

    private String getStockDesc(Map<String, Object> stocks) {
        return String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355\u53f7\uff1a%1$s\uff0c\u7ec4\u4ef6\u5e8f\u53f7\uff1a%2$s\uff0c\u7ec4\u4ef6\u7f16\u7801\uff1a%3$s", (String)"GetEcoEffectOrderBusiness_32", (String)"mmc-pdm-business", (Object[])new Object[0]), stocks.get("billno"), stocks.get("stockentry.seq"), this.getMaterialNumberById(stocks.get("stockentry.materielmasterid")));
    }

    private String getMaterialNumberById(Object materialId) {
        DynamicObject material = BusinessDataServiceHelper.loadSingleFromCache((Object)materialId, (String)"bd_material", (String)"number");
        return material.getString("number");
    }

    private boolean isDateMatch(Map<String, Object> stockData, DynamicObject ecoBomEntry, DynamicObject filterObj, Date minActtime) {
        Date acttime = ecoBomEntry.getDate("acttime");
        Date demandDate = this.getDateValue(stockData, "stockentry.demanddate");
        Date planBeginTime = this.getDateValue(stockData, "orderentryid.planbegintime");
        boolean isAdd = this.isAddMode(ecoBomEntry);
        if (isAdd) {
            String addMode = filterObj.getString("datematchadd");
            if ("A".equals(addMode)) {
                return acttime.compareTo(planBeginTime) <= 0;
            }
            if ("B".equals(addMode)) {
                if (minActtime == null) {
                    return acttime.compareTo(demandDate) > 0;
                }
                return acttime.compareTo(demandDate) > 0 && minActtime.compareTo(demandDate) <= 0;
            }
            if ("C".equals(addMode) && minActtime != null) {
                return minActtime.compareTo(demandDate) <= 0;
            }
        } else {
            String editMode = filterObj.getString("datematchedit");
            if ("A".equals(editMode)) {
                return acttime.compareTo(demandDate) <= 0;
            }
            if ("B".equals(editMode)) {
                if (minActtime == null) {
                    return acttime.compareTo(demandDate) > 0;
                }
                return acttime.compareTo(demandDate) > 0 && minActtime.compareTo(demandDate) <= 0;
            }
            if ("C".equals(editMode) && minActtime != null) {
                return minActtime.compareTo(demandDate) <= 0;
            }
        }
        return true;
    }

    private Date getExpandBomDate(DynamicObject ecoBomEntry, Map<String, Object> stockDataMap) {
        if (this.EXPANDBOMTIMEMODE == null || "".equals(this.EXPANDBOMTIMEMODE)) {
            this.EXPANDBOMTIMEMODE = PdmParamSetHelper.getStringParamValue((String)"ECN_ExpandBomTimeMode");
        }
        if ("B".equals(this.EXPANDBOMTIMEMODE)) {
            return this.getDateValue(stockDataMap, "stockentry.demanddate");
        }
        if ("C".equals(this.EXPANDBOMTIMEMODE)) {
            return this.getDateValue(stockDataMap, "orderentryid.expendbomtime");
        }
        Date actTime = ecoBomEntry.getDate("acttime");
        return actTime;
    }

    private List<Map<String, Object>> getAddDataStock(List<Map<String, Object>> stockDataList, Map<Long, DynamicObject> mftBomEntryMap, DynamicObject ecoBomEntry, DynamicObject changeBill, Map<Object, DynamicObject> mftBomMap, Map<String, String> xstockMap, Map<String, String> bomResultCacheMap, Long parentSameBatchId, Map<Long, List<Map<String, Object>>> wsMap, Map<String, Set<Long>> dataCacheMap, Map<Long, Boolean> charaRuleMap, Map<String, List<Map<String, Object>>> pmaterialCacheMap, Long materialId, DynamicObject filterObj) {
        Long bomentryId = ecoBomEntry.getLong("bomentry");
        DynamicObject bomentry = mftBomEntryMap.get(bomentryId);
        Long bomMaterialId = this.getLongId(ecoBomEntry, "entrymaterial");
        if (!PlatformUtils.isNullLong((Long)materialId)) {
            bomMaterialId = materialId;
        }
        Long featureType = this.getLongId(ecoBomEntry, "featuretype");
        this.valideBomEntryExists(bomentry, bomentryId, changeBill, bomMaterialId, featureType);
        Long bomId = bomentry.getLong("bomid");
        DynamicObject childBom = mftBomMap.get(bomId);
        ArrayList<Map<String, Object>> refStockDataMapList = new ArrayList<Map<String, Object>>(stockDataList.size());
        int stockDataSize = stockDataList.size();
        HashSet<String> stockIdSet = new HashSet<String>(stockDataSize);
        Set<String> stockExistAddIdSet = this.getExistsStockAddData(stockDataList, bomentryId);
        log.info("getAddDataStock+getExistsStockAddData,,stockExistAddIdSet=" + (stockExistAddIdSet == null ? "null" : stockExistAddIdSet.toString()));
        HashMap<String, List<DynamicObject>> bomEntryXXMap = new HashMap<String, List<DynamicObject>>(16);
        boolean isForward = this.isForward(filterObj);
        for (int i = 0; i < stockDataSize; ++i) {
            Map<String, Object> stockDataMap = stockDataList.get(i);
            Long childBomId = this.getLongValue(stockDataMap, "stockentry.childbomid");
            if (!bomId.equals(childBomId)) continue;
            Date expandBomDate = this.getExpandBomDate(ecoBomEntry, stockDataMap);
            Long stockId = this.getLongValue(stockDataMap, "id");
            String orderType = this.getStringValue(stockDataMap, "ordertype");
            List<DynamicObject> bomEntryList = this.getFeatureMaterialBomEntryList(bomEntryXXMap, bomentry, stockDataMap, bomResultCacheMap, expandBomDate, childBom, charaRuleMap, null, materialId);
            if (PlatformUtils.isNullList(bomEntryList)) continue;
            for (DynamicObject bomentryData : bomEntryList) {
                Long childMaterialId = this.getLongId(bomentryData, "entrymaterialid");
                boolean isExistsData = stockExistAddIdSet.contains(stockId + "_" + bomentryId + "_" + orderType + "_" + childMaterialId);
                if (this.isShowDetialLog()) {
                    LogUtils.genLogs4(this.logs, stockDataMap, bomentryData, isExistsData);
                }
                if (isExistsData) continue;
                String xStockString = this.genXStockKeyString("A", String.valueOf(stockId), orderType, String.valueOf(bomentryId), String.valueOf(childMaterialId));
                if (xstockMap.containsKey(xStockString)) {
                    if (!this.isShowDetialLog()) continue;
                    LogUtils.genLogs5(this.logs, bomentry, xstockMap.get(xStockString));
                    continue;
                }
                if (!stockIdSet.add(orderType + "_" + String.valueOf(stockId))) continue;
                refStockDataMapList.add(stockDataMap);
            }
        }
        if (refStockDataMapList.isEmpty()) {
            return new ArrayList<Map<String, Object>>(16);
        }
        stockDataSize = refStockDataMapList.size();
        ArrayList<Map<String, Object>> addStockDataList = new ArrayList<Map<String, Object>>(16);
        Set<String> existsSet = this.genExistsStockDataSet(stockDataList, 0L, null);
        ArrayList<Map<String, Object>> editGridList = new ArrayList<Map<String, Object>>(16);
        for (int i = 0; i < stockDataSize; ++i) {
            Date expandBomDate;
            List<DynamicObject> bomEntryList;
            Map refStockDataMap = (Map)refStockDataMapList.get(i);
            boolean isConfigBom = this.isConfigBom(refStockDataMap);
            String stockNumber = this.getStringValue(refStockDataMap, "billno");
            Long sameBatchId = parentSameBatchId;
            if (parentSameBatchId.equals(0L)) {
                sameBatchId = ID.genLongId();
            }
            if (PlatformUtils.isNullList(bomEntryList = this.getFeatureMaterialBomEntryList(bomEntryXXMap, bomentry, refStockDataMap, bomResultCacheMap, expandBomDate = this.getExpandBomDate(ecoBomEntry, refStockDataMap), childBom, charaRuleMap, null, materialId))) {
                log.info("getAddDataStock,bomEntryList is null ,continue ,stockBillno=" + stockNumber);
                continue;
            }
            for (int p = 0; p < bomEntryList.size(); ++p) {
                DynamicObject newBomentry = bomEntryList.get(p);
                if (isForward && !this.isValidDate(expandBomDate, newBomentry)) {
                    if (!this.isShowDetialLog()) continue;
                    LogUtils.genLogs11(this.logs, expandBomDate, newBomentry);
                    continue;
                }
                ArrayList<Map<String, Object>> wsList = new ArrayList<Map<String, Object>>(16);
                List<Map<String, Object>> parentMaterialList = this.getparentQtyData(this.getLongId(childBom, "materialid"), this.getLongId(childBom, "version"), this.getLongId(childBom, "auxproperty"), stockDataList, refStockDataMap, bomResultCacheMap, pmaterialCacheMap, null);
                if (PlatformUtils.isNullList(parentMaterialList)) {
                    if (!this.isShowDetialLog()) continue;
                    LogUtils.genLogs12(this.logs, this.getLongId(childBom, "materialid"), this.getLongId(childBom, "version"), this.getLongId(childBom, "auxproperty"), refStockDataMap, newBomentry, "getAddDataStock.getparentQtyData.parentMaterialList is null");
                    continue;
                }
                for (Map<String, Object> parentMaterialMap : parentMaterialList) {
                    Long pMaterialMasterId;
                    Map<String, Object> addStockDataMap;
                    List<BomBaseData> bbdList;
                    Long pstockEntryId = this.getLongValue(parentMaterialMap, "stockentry");
                    BigDecimal parentFz = this.getBigDecimalValue(parentMaterialMap, "stockentry.qtynumerator");
                    BigDecimal parentFm = this.getBigDecimalValue(parentMaterialMap, "stockentry.qtydenominator");
                    if (parentFz.compareTo(BigDecimal.ZERO) <= 0) {
                        if (!this.isShowDetialLog()) continue;
                        LogUtils.genLogs12(this.logs, this.getLongId(childBom, "materialid"), this.getLongId(childBom, "version"), this.getLongId(childBom, "auxproperty"), refStockDataMap, newBomentry, "getAddDataStock.getparentQtyData.parentFz <= 0");
                        continue;
                    }
                    List<Map<String, Object>> addStockDataMapList = this.putAddStockDataMap(refStockDataMap, newBomentry, wsList, changeBill, ecoBomEntry, childBom, parentFz, parentFm, addStockDataList, sameBatchId, existsSet, pstockEntryId);
                    if (PlatformUtils.isNullList(addStockDataMapList) || !newBomentry.getBoolean("entryisjumplevel") || PlatformUtils.isNullList(bbdList = this.getBomExpandBbdList(isConfigBom, addStockDataMap = addStockDataMapList.get(0), expandBomDate, bomResultCacheMap, newBomentry, pMaterialMasterId = this.getLongValue(addStockDataMap, "stockentry.materielmasterid"), false))) continue;
                    for (Map<String, Object> pStockDataMap : addStockDataMapList) {
                        this.addBomNextResultToStock(refStockDataMap, bbdList, addStockDataList, pStockDataMap, sameBatchId, existsSet, ecoBomEntry, changeBill, filterObj, editGridList);
                    }
                }
            }
        }
        List<Map<String, Object>> gridList = this.convertAddData(addStockDataList, ecoBomEntry, changeBill, filterObj);
        if (!editGridList.isEmpty()) {
            gridList.addAll(editGridList);
        }
        if (this.isShowDetialLog()) {
            LogUtils.genLogs9(this.logs, gridList);
        }
        return gridList;
    }

    private List<Map<String, Object>> convertAddData(List<Map<String, Object>> addStockDataList, DynamicObject ecoBomEntry, DynamicObject changeBill, DynamicObject filterObj) {
        ArrayList<Map<String, Object>> gridList = new ArrayList<Map<String, Object>>(addStockDataList.size());
        String changeType = "C";
        for (int i = 0; i < addStockDataList.size(); ++i) {
            Map<String, Object> stockDataMap = addStockDataList.get(i);
            Map<String, Object> gridMap = this.genGrideDataMap(stockDataMap, ecoBomEntry, null, changeBill, null, null, null, changeType, this.getBigDecimalValue(stockDataMap, "stockentry.qtynumerator"), this.getBigDecimalValue(stockDataMap, "stockentry.qtydenominator"), this.getBigDecimalValue(stockDataMap, "stockentry.standqty"), filterObj);
            gridMap.put("entryqtynumerator", BigDecimal.ZERO);
            gridMap.put("entryqtynumerator2", gridMap.get("changeqtynumerator"));
            gridMap.put("entryqtydenominator2", gridMap.get("changeqtydenominator"));
            gridList.add(gridMap);
        }
        return gridList;
    }

    private boolean isSameMaterial(DynamicObject bomEntryBefore, DynamicObject bomEntryAfter) {
        String entryType = bomEntryAfter.getString("entrytype");
        if ("A".equals(entryType)) {
            return this.getLongId(bomEntryBefore, "entrymaterialid").equals(this.getLongId(bomEntryAfter, "entrymaterialid"));
        }
        return this.getLongId(bomEntryBefore, "featuretype").equals(this.getLongId(bomEntryAfter, "featuretype"));
    }

    private void valideBomEntryExists(DynamicObject bomentry, Long bomentryId, DynamicObject changeBill, Long materialId, Long featureTypeId) {
        if (bomentry == null) {
            if (!PlatformUtils.isNullLong((Long)materialId)) {
                DynamicObject material = MaterialQueryHelper.getDataCacheByID((Object)materialId);
                throw new KDBizException(new ErrorCode("valideBomEntryExists", String.format(ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u5355\u201c%1$s\u201d\u4e0b\u7684\u7269\u6599\u201c%2$s\u201d\uff0c\u5176BOM\u5206\u5f55\u7684ID\u201c%3$s\u201d\u5bf9\u5e94\u7684\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u5904\u7406\u3002", (String)"GetEcoEffectOrderBusiness_01", (String)"mmc-pdm-business", (Object[])new Object[0]), changeBill.getString("billno"), material.getString("number"), bomentryId)), new Object[0]);
            }
            if (!PlatformUtils.isNullLong((Long)featureTypeId)) {
                DynamicObject featureType = BusinessDataServiceHelper.loadSingleFromCache((Object)featureTypeId, (String)"mpdm_featuretype", (String)"id,number");
                throw new KDBizException(new ErrorCode("valideBomEntryExists", String.format(ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u5355\u201c%1$s\u201d\u4e0b\u7684\u7279\u5f81\u7c7b\u201c%2$s\u201d\uff0c\u5176BOM\u5206\u5f55\u7684ID\u201c%3$s\u201d\u5bf9\u5e94\u7684\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u5904\u7406\u3002", (String)"GetEcoEffectOrderBusiness_23", (String)"mmc-pdm-business", (Object[])new Object[0]), changeBill.getString("billno"), featureType.getString("number"), bomentryId)), new Object[0]);
            }
            throw new KDBizException(new ErrorCode("valideBomEntryExists", String.format(ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u5355\u201c%1$s\u201d\u4e0b\u7684\u7269\u6599\u201c%2$s\u201d\uff0c\u5176BOM\u5206\u5f55\u7684ID\u201c%3$s\u201d\u5bf9\u5e94\u7684\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u5904\u7406\u3002", (String)"GetEcoEffectOrderBusiness_01", (String)"mmc-pdm-business", (Object[])new Object[0]), changeBill.getString("billno"), "null", bomentryId)), new Object[0]);
        }
    }

    private BigDecimal getDiffQty(DynamicObject bomEntryBefore, DynamicObject bomEntryAfter, List<Map<String, Object>> wsBeforeList, List<Map<String, Object>> wsAfterList) {
        BigDecimal fz1 = BigDecimal.ZERO;
        if (bomEntryBefore != null) {
            fz1 = MMCUtils.divide((BigDecimal)bomEntryBefore.getBigDecimal("entryqtynumerator"), (BigDecimal)bomEntryBefore.getBigDecimal("entryqtydenominator"));
        }
        BigDecimal fz2 = BigDecimal.ZERO;
        if (bomEntryAfter != null) {
            fz2 = MMCUtils.divide((BigDecimal)bomEntryAfter.getBigDecimal("entryqtynumerator"), (BigDecimal)bomEntryAfter.getBigDecimal("entryqtydenominator"));
        }
        return fz2.subtract(fz1);
    }

    private boolean chkWsHasDiff(List<Map<String, Object>> wsList1, List<Map<String, Object>> wsList2) {
        return false;
    }

    private Fraction getStockUnitQty(List<Map<String, Object>> beforeStockDataList, List<Map<String, Object>> afterStockDataList) {
        Fraction sumFraction = this.getSumStockUnitQty(beforeStockDataList, BigDecimal.ZERO, BigDecimal.ONE);
        sumFraction = this.getSumStockUnitQty(afterStockDataList, sumFraction.getMole(), sumFraction.getDone());
        return sumFraction;
    }

    private Fraction getSumStockUnitQty(List<Map<String, Object>> stockDataList, BigDecimal sumFz, BigDecimal sumFm) {
        BigDecimal tmpSumFz = sumFz;
        BigDecimal tmpSumFm = sumFm;
        if (!PlatformUtils.isNullList(stockDataList)) {
            for (int i = 0; i < stockDataList.size(); ++i) {
                BigDecimal fz = this.getBigDecimalValue(stockDataList.get(i), "stockentry.qtynumerator");
                BigDecimal fm = this.getBigDecimalValue(stockDataList.get(i), "stockentry.qtydenominator");
                Fraction fraction = PlatformUtils.qtyAdd((BigDecimal)tmpSumFz, (BigDecimal)tmpSumFm, (BigDecimal)fz, (BigDecimal)fm);
                tmpSumFz = fraction.getMole();
                tmpSumFm = fraction.getDone();
            }
        }
        return new Fraction(tmpSumFz, tmpSumFm);
    }

    private List<Map<String, Object>> genStockEditDiffData(DynamicObject bomEntryBefore, DynamicObject bomEntryAfter, List<Map<String, Object>> wsBeforeList, List<Map<String, Object>> wsAfterList, List<Map<String, Object>> beforeFilterStockDataList, List<Map<String, Object>> afterFilterStockDataList, BigDecimal parentQtyFz, BigDecimal parentQtyFm, DynamicObject ecoBomEntryBefore, DynamicObject ecoBomEntryAfter, DynamicObject changeBill, DynamicObject childBom, String orderType, Map<String, String> xstockMap, Long sameBatchId, Long materialId, boolean isDisable, DynamicObject filterObj) {
        int allSize = beforeFilterStockDataList.size() + afterFilterStockDataList.size();
        ArrayList<Map<String, Object>> gridList = new ArrayList<Map<String, Object>>(allSize);
        HashSet<String> usedStockEntryIdSet = new HashSet<String>(allSize);
        this.genNullWsList(wsAfterList, bomEntryAfter);
        if (PlatformUtils.isNullLong((Long)sameBatchId)) {
            sameBatchId = ID.genLongId();
        }
        for (int i = 0; i < wsAfterList.size(); ++i) {
            Map<String, Object> gridMap;
            String remark;
            Map<String, Object> dataMap;
            Map<String, Object> wsMap = wsAfterList.get(i);
            Long bomWorkCenter = this.getLongValue(wsMap, "fworkcenter");
            Long bomWorkStation = this.getLongValue(wsMap, "fworkstation");
            BigDecimal workqtyFz = this.getBigDecimalValue(wsMap, "fworkentryqtyfz");
            BigDecimal workqtyFm = this.getBigDecimalValue(wsMap, "fworkentryqtyfm");
            Fraction fraction = PlatformUtils.qtyMul((BigDecimal)parentQtyFz, (BigDecimal)parentQtyFm, (BigDecimal)workqtyFz, (BigDecimal)workqtyFm);
            BigDecimal newUnitFz = fraction.getMole();
            BigDecimal newUnitFm = fraction.getDone();
            List<Map<String, Object>> afterStockDataList = this.getStockListObject(afterFilterStockDataList, usedStockEntryIdSet, orderType);
            List<Map<String, Object>> beforeStockDataList = this.getStockListObject(beforeFilterStockDataList, usedStockEntryIdSet, orderType);
            Fraction stockQtyFraction = this.getStockUnitQty(beforeStockDataList, afterStockDataList);
            BigDecimal stockUnitFzQty = stockQtyFraction.getMole();
            BigDecimal stockUnitFmQty = stockQtyFraction.getDone();
            BigDecimal stockUnitQty = MMCUtils.divide((BigDecimal)stockUnitFzQty, (BigDecimal)stockUnitFmQty);
            Fraction diffQtyFraction = PlatformUtils.qtySub((BigDecimal)stockUnitFzQty, (BigDecimal)stockUnitFmQty, (BigDecimal)newUnitFz, (BigDecimal)newUnitFm);
            BigDecimal diffQtyFz = diffQtyFraction.getMole();
            BigDecimal diffQtyFm = diffQtyFraction.getDone();
            BigDecimal diffFzQty = MMCUtils.divide((BigDecimal)newUnitFz, (BigDecimal)newUnitFm).subtract(stockUnitQty).setScale(10, 4);
            log.info("getEditDataStock,genStockEditDiffData ,materialId = " + materialId + ",i = " + i + ",bomWorkStation=" + bomWorkStation.toString() + ",workqtyFz=" + workqtyFz.toString() + ",parentQtyFz=" + parentQtyFz.toString() + ",newUnitFz=" + newUnitFz.toString() + ",newUnitFm=" + newUnitFm.toString() + "i = " + i + ",stockUnitQty=" + stockUnitQty.toString() + ",diffFzQty=" + diffFzQty.toString());
            ArrayList<Map<String, Object>> updateStockList = new ArrayList<Map<String, Object>>(beforeStockDataList.size() + afterStockDataList.size());
            updateStockList.addAll(afterStockDataList);
            updateStockList.addAll(beforeStockDataList);
            for (int j = 0; j < updateStockList.size(); ++j) {
                String changeType;
                Map stockDataMap = (Map)updateStockList.get(j);
                Long stockEntryId = this.getLongValue(stockDataMap, "stockentry");
                Long bomEntryId = this.getLongValue(stockDataMap, "stockentry.bomentryid");
                String xStockString = this.genXStockKeyString("B", String.valueOf(stockEntryId), orderType, "", String.valueOf(materialId));
                if (xstockMap.containsKey(xStockString)) {
                    diffFzQty = BigDecimal.ZERO;
                    log.info("getEditDataStock,genStockEditDiffData,xstockMap.containsKey(xStockString) ,xStockString = " + xStockString);
                    continue;
                }
                BigDecimal orderQty = this.getBigDecimalValue(stockDataMap, "qty");
                usedStockEntryIdSet.add(orderType + "_" + this.getLongValue(stockDataMap, "stockentry"));
                if (diffFzQty.compareTo(BigDecimal.ZERO) > 0) {
                    changeType = "A";
                    BigDecimal changeUnitFz = diffFzQty;
                    BigDecimal changeStandQty = MMCUtils.multiply((BigDecimal)changeUnitFz, (BigDecimal)orderQty);
                    dataMap = this.copyMap(stockDataMap);
                    dataMap.put("samebatchid", sameBatchId);
                    remark = String.format(ResManager.loadKDString((String)"\u589e\u52a0\u5355\u4f4d\u6570\u91cf\uff1a\u201c%1$s\u201d\u3002", (String)"GetEcoEffectOrderBusiness_07", (String)"mmc-pdm-business", (Object[])new Object[0]), changeUnitFz);
                    dataMap.put("remark", remark);
                    gridMap = this.genGrideDataMap(dataMap, ecoBomEntryBefore, ecoBomEntryAfter, changeBill, bomEntryAfter, childBom, wsMap, changeType, diffQtyFz, diffQtyFm, changeStandQty, filterObj);
                    gridList.add(gridMap);
                    diffFzQty = BigDecimal.ZERO;
                    this.setQtyValue(stockDataMap, gridMap);
                    continue;
                }
                if (diffFzQty.compareTo(BigDecimal.ZERO) < 0) {
                    BigDecimal stockFz;
                    changeType = "B";
                    BigDecimal changeUnitFz = stockFz = MMCUtils.divide((BigDecimal)this.getBigDecimalValue(stockDataMap, "stockentry.qtynumerator"), (BigDecimal)this.getBigDecimalValue(stockDataMap, "stockentry.qtydenominator"));
                    BigDecimal changeFz = this.getBigDecimalValue(stockDataMap, "stockentry.qtynumerator");
                    BigDecimal changeFm = this.getBigDecimalValue(stockDataMap, "stockentry.qtydenominator");
                    if (diffFzQty.abs().compareTo(stockFz) >= 0) {
                        diffFzQty = diffFzQty.add(stockFz);
                    } else {
                        changeUnitFz = diffFzQty.abs();
                        diffFzQty = BigDecimal.ZERO;
                        Fraction changeFraction = PlatformUtils.convertToFraction((BigDecimal)changeUnitFz);
                        changeFz = changeFraction.getMole();
                        changeFm = changeFraction.getDone();
                    }
                    BigDecimal changeStandQty = MMCUtils.multiply((BigDecimal)changeUnitFz, (BigDecimal)orderQty);
                    Map<String, Object> dataMap2 = this.copyMap(stockDataMap);
                    dataMap2.put("samebatchid", sameBatchId);
                    String remark2 = String.format(ResManager.loadKDString((String)"\u51cf\u5c11\u5355\u4f4d\u6570\u91cf\u201c%1$s\u201d\u3002", (String)"GetEcoEffectOrderBusiness_08", (String)"mmc-pdm-business", (Object[])new Object[0]), changeUnitFz);
                    if (isDisable) {
                        remark2 = String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u7269\u6599\u5728BOM\u5c55\u5f00\u4e2d\u5df2\u4e0d\u5b58\u5728\uff0c\u8fdb\u884c\u5931\u6548\u5904\u7406\uff0c\u51cf\u5c11\u5355\u4f4d\u6570\u91cf\u201c%1$s\u201d\u3002", (String)"GetEcoEffectOrderBusiness_19", (String)"mmc-pdm-business", (Object[])new Object[0]), changeUnitFz);
                    }
                    dataMap2.put("remark", remark2);
                    Map<String, Object> gridMap2 = this.genGrideDataMap(dataMap2, ecoBomEntryBefore, ecoBomEntryAfter, changeBill, bomEntryAfter, childBom, wsMap, changeType, changeFz, changeFm, changeStandQty, filterObj);
                    gridList.add(gridMap2);
                    this.setQtyValue(stockDataMap, gridMap2);
                    continue;
                }
                if (!bomEntryId.equals(bomEntryBefore.getLong("entryid")) || bomEntryId.equals(bomEntryAfter.getLong("entryid"))) continue;
                changeType = "D";
                BigDecimal changeQty = BigDecimal.ZERO;
                BigDecimal changeFz = BigDecimal.ZERO;
                BigDecimal changeFm = BigDecimal.ONE;
                Map<String, Object> dataMap3 = this.copyMap(stockDataMap);
                dataMap3.put("samebatchid", sameBatchId);
                gridMap = this.genGrideDataMap(dataMap3, ecoBomEntryBefore, ecoBomEntryAfter, changeBill, bomEntryAfter, childBom, wsMap, changeType, changeFz, changeFm, changeQty, filterObj);
                gridList.add(gridMap);
            }
            if (diffFzQty.compareTo(BigDecimal.ZERO) > 0) {
                Map<String, Object> beforeStockDataMap = beforeFilterStockDataList.get(0);
                Long stockId = this.getLongValue(beforeStockDataMap, "id");
                String xStockString = this.genXStockKeyString("A", String.valueOf(stockId), orderType, String.valueOf(bomEntryAfter.getLong("entryid")), String.valueOf(materialId));
                if (xstockMap.containsKey(xStockString)) continue;
                String changeType = "C";
                BigDecimal orderQty = this.getBigDecimalValue(beforeStockDataMap, "qty");
                BigDecimal changeStandQty = MMCUtils.multiply((BigDecimal)diffFzQty, (BigDecimal)orderQty);
                Fraction diffFraction = PlatformUtils.convertToFraction((BigDecimal)diffFzQty);
                BigDecimal changeFz = diffFraction.getMole();
                BigDecimal changeFm = diffFraction.getDone();
                dataMap = this.copyMap(beforeStockDataMap);
                this.setAddStockMapValue(dataMap, bomEntryAfter, changeFz, changeFm, changeStandQty, changeType, bomWorkCenter, bomWorkStation, sameBatchId);
                dataMap.put("stockentry.entryconfiguredcode", beforeStockDataMap.get("stockentry.entryconfiguredcode"));
                remark = ResManager.loadKDString((String)"BOM\u62c6\u5206\u65b0\u589e\u7269\u6599\u3002", (String)"GetEcoEffectOrderBusiness_14", (String)"mmc-pdm-business", (Object[])new Object[0]);
                dataMap.put("remark", remark);
                gridMap = this.genGrideDataMap(dataMap, ecoBomEntryBefore, ecoBomEntryAfter, changeBill, bomEntryAfter, childBom, wsMap, changeType, changeFz, changeFm, changeStandQty, filterObj);
                gridList.add(gridMap);
                continue;
            }
            if (diffFzQty.compareTo(BigDecimal.ZERO) >= 0) continue;
            log.info(" diffFzQty =" + diffFzQty + ", no stock substract");
        }
        this.dealDisableData(afterFilterStockDataList, usedStockEntryIdSet, gridList, bomEntryAfter, ecoBomEntryAfter, changeBill, xstockMap, sameBatchId, filterObj);
        this.dealDisableData(beforeFilterStockDataList, usedStockEntryIdSet, gridList, bomEntryBefore, ecoBomEntryBefore, changeBill, xstockMap, sameBatchId, filterObj);
        return gridList;
    }

    private void dealDisableData(List<Map<String, Object>> stockDataList, Set<String> usedStockEntryIdSet, List<Map<String, Object>> gridList, DynamicObject bomEntryAfter, DynamicObject ecoBomEntryAfter, DynamicObject changeBill, Map<String, String> xstockMap, Long sameBatchId, DynamicObject filterObj) {
        List<Map<String, Object>> disableGridList;
        List<Map<String, Object>> disableList = this.getNoUsedStockDataList(stockDataList, usedStockEntryIdSet);
        if (!disableList.isEmpty() && !(disableGridList = this.getDisableDataStock(disableList, bomEntryAfter, ecoBomEntryAfter, changeBill, xstockMap, sameBatchId, filterObj)).isEmpty()) {
            gridList.addAll(disableGridList);
        }
    }

    private List<Map<String, Object>> getNoUsedStockDataList(List<Map<String, Object>> stockDataList, Set<String> usedStockEntryIdSet) {
        ArrayList<Map<String, Object>> disableList = new ArrayList<Map<String, Object>>(stockDataList.size());
        for (int i = 0; i < stockDataList.size(); ++i) {
            Map<String, Object> stockDataMap = stockDataList.get(i);
            Long stockEntryId = this.getLongValue(stockDataMap, "stockentry");
            String orderType = this.getStringValue(stockDataMap, "ordertype");
            if (stockEntryId.equals(0L) || usedStockEntryIdSet.contains(orderType + "_" + stockEntryId)) continue;
            disableList.add(stockDataMap);
        }
        return disableList;
    }

    private List<Map<String, Object>> getStockListObject(List<Map<String, Object>> filterStockDataList, Set<String> usedStockEntryIdSet, String orderType) {
        ArrayList<Map<String, Object>> ppList = new ArrayList<Map<String, Object>>(16);
        if (!filterStockDataList.isEmpty()) {
            int size = filterStockDataList.size();
            for (int i = 0; i < size; ++i) {
                Map<String, Object> stockData = filterStockDataList.get(i);
                Long stockEntryId = this.getLongValue(stockData, "stockentry");
                if (usedStockEntryIdSet.contains(orderType + "_" + stockEntryId)) continue;
                ppList.add(stockData);
            }
        }
        return ppList;
    }

    private List<Map<String, Object>> getEditDataStock(List<Map<String, Object>> stockDataList, Map<Long, DynamicObject> mftBomEntryMap, DynamicObject ecoBomEntry, DynamicObject ecoBomEntryAfter, DynamicObject changeBill, Map<Object, DynamicObject> mftBomMap, Map<String, String> xstockMap, Map<String, String> bomResultCacheMap, Map<Long, List<Map<String, Object>>> wsMap, Map<String, Set<Long>> dataCacheMap, Map<Long, Boolean> charaRuleMap, Map<String, List<Map<String, Object>>> pmaterialCacheMap, DynamicObject filterObj) {
        Long beforeBomentryId = ecoBomEntry.getLong("bomentry");
        DynamicObject bomEntryBefore = mftBomEntryMap.get(beforeBomentryId);
        this.valideBomEntryExists(bomEntryBefore, beforeBomentryId, changeBill, this.getLongId(ecoBomEntry, "entrymaterial"), this.getLongId(ecoBomEntry, "featuretype"));
        Long bomId = bomEntryBefore.getLong("bomid");
        DynamicObject childBom = mftBomMap.get(bomId);
        Long afterBomentryId = ecoBomEntryAfter.getLong("bomentry");
        DynamicObject bomEntryAfter = mftBomEntryMap.get(afterBomentryId);
        boolean isSameEcoBomEntry = beforeBomentryId.equals(afterBomentryId);
        if (!isSameEcoBomEntry) {
            this.valideBomEntryExists(bomEntryAfter, afterBomentryId, changeBill, this.getLongId(ecoBomEntryAfter, "entrymaterial"), this.getLongId(ecoBomEntry, "featuretype"));
        } else if (ecoBomEntry.getBigDecimal("entryqtynumerator").compareTo(BigDecimal.ZERO) == 0) {
            bomEntryBefore = this.initBomEntry(bomEntryBefore);
        }
        ArrayList<Map<String, Object>> gridList = new ArrayList<Map<String, Object>>(128);
        HashMap<String, List<DynamicObject>> bomEntryXXMap = new HashMap<String, List<DynamicObject>>(16);
        Set<String> existsSet = this.genExistsStockDataSet(stockDataList, 0L, null);
        if (!this.isSameMaterial(bomEntryBefore, bomEntryAfter)) {
            log.info("getEditDataStock,isSameMaterial = false");
            if (this.isShowDetialLog()) {
                LogUtils.genLogs51(this.logs, bomEntryBefore, bomEntryAfter, childBom);
            }
            Long sameBatchId = ID.genLongId();
            gridList.addAll(this.getDisableDataStock(stockDataList, bomEntryBefore, ecoBomEntry, changeBill, xstockMap, sameBatchId, filterObj));
            gridList.addAll(this.getAddDataStock(stockDataList, mftBomEntryMap, ecoBomEntryAfter, changeBill, mftBomMap, xstockMap, bomResultCacheMap, sameBatchId, wsMap, dataCacheMap, charaRuleMap, pmaterialCacheMap, 0L, filterObj));
            return gridList;
        }
        Set<String> stockIdSet = this.getStockIdSet(stockDataList);
        Long materialMasterId = this.getLongId(childBom, "materialid");
        Long versionId = this.getLongId(childBom, "version");
        Long auxpropertyId = this.getLongId(childBom, "auxproperty");
        boolean isFroward = this.isForward(filterObj);
        boolean isConverToUnXN = this.isConvertUnXN(ecoBomEntry, ecoBomEntryAfter);
        boolean needExpandBom = this.needExpandBom(bomEntryBefore, bomEntryAfter, charaRuleMap);
        String convertXNRemark = ResManager.loadKDString((String)"\u53d8\u66f4\u540e\u7684\u7ec4\u4ef6\u4e3a\u8df3\u5c42\u4ef6,\u9700\u8fdb\u884cBOM\u4e0b\u5c42\u5c55\u5f00.", (String)"GetEcoEffectOrderBusiness_21", (String)"mmc-pdm-business", (Object[])new Object[0]);
        for (String stockIdStr : stockIdSet) {
            Long materialId;
            HashSet<Long> materialIdSet;
            List<Map<String, Object>> beforeStockList = this.getStocDataByBomEntryId(stockDataList, beforeBomentryId, stockIdStr, materialIdSet = new HashSet<Long>(16));
            if (PlatformUtils.isNullList(beforeStockList)) {
                log.info("getEditDataStock,stockIdStr = " + stockIdStr + ",beforeStockList is null,beforeBomentryId=" + beforeBomentryId);
                continue;
            }
            List<Object> afterStockList = new ArrayList(16);
            if (!isSameEcoBomEntry) {
                afterStockList = this.getStocDataByBomEntryId(stockDataList, afterBomentryId, stockIdStr, null);
            }
            log.info("getEditDataStock,stockIdStr = " + stockIdStr + ",afterStockList=" + (afterStockList == null ? "null" : afterStockList.toString()));
            if (materialIdSet.isEmpty() && !PlatformUtils.isNullLong((Long)(materialId = this.getLongId(bomEntryAfter, "entrymaterialid")))) {
                materialIdSet.add(materialId);
            }
            if (materialIdSet.isEmpty()) continue;
            Long sameBatchId = ID.genLongId();
            List<Map<String, Object>> editList = null;
            boolean isConfigBom = this.isConfigBom(beforeStockList.get(0));
            boolean isMulMaterial = materialIdSet.size() > 1;
            HashSet<Long> addNewMaterialIdSet = new HashSet<Long>(16);
            for (Long materialId2 : materialIdSet) {
                List<Map<String, Object>> newBeforeStockList = this.filterStockListByMaterial(beforeStockList, materialId2, isMulMaterial);
                List<Map<String, Object>> newAfterStockList = this.filterStockListByMaterial(afterStockList, materialId2, isMulMaterial);
                if (newBeforeStockList.isEmpty()) continue;
                Set<Long> pstockEntryIdSet = this.getPStockEntryIdSet(newBeforeStockList);
                Map<String, Object> firstMap = newBeforeStockList.get(0);
                Long stockId = this.getLongValue(firstMap, "id");
                String orderType = this.getStringValue(firstMap, "ordertype");
                BigDecimal parentQtyFz = BigDecimal.ONE;
                BigDecimal parentQtyFm = BigDecimal.ONE;
                ArrayList<Map<String, Object>> beforeWsList = new ArrayList<Map<String, Object>>(16);
                ArrayList<Map<String, Object>> afterWsList = new ArrayList<Map<String, Object>>(16);
                Map<String, BigDecimal> parentMap = this.getparentQty(materialMasterId, versionId, auxpropertyId, newBeforeStockList, firstMap, bomResultCacheMap, pmaterialCacheMap, pstockEntryIdSet);
                parentQtyFz = parentMap.get("stockentry.qtynumerator");
                parentQtyFm = parentMap.get("stockentry.qtydenominator");
                boolean isNullWs = PlatformUtils.isNullList(beforeWsList) && PlatformUtils.isNullList(afterWsList);
                BigDecimal totalDiffQty = this.getDiffQty(bomEntryBefore, bomEntryAfter, beforeWsList, afterWsList);
                boolean isWsDiff = this.chkWsHasDiff(beforeWsList, afterWsList);
                log.info("getEditDataStock,stockIdStr = " + stockIdStr + ",totalDiffQty=" + totalDiffQty.toString() + ",isWsDiff=" + String.valueOf(isWsDiff));
                boolean isDisable = false;
                Set<Object> bomMaterialIdSet = new HashSet(16);
                if (isFroward) {
                    List<DynamicObject> bomEntryList = new ArrayList<DynamicObject>(16);
                    if (needExpandBom) {
                        Date date = this.getExpandBomDate(ecoBomEntryAfter, newBeforeStockList.get(0));
                        bomEntryList = this.getFeatureMaterialBomEntryList(bomEntryXXMap, bomEntryAfter, newBeforeStockList.get(0), bomResultCacheMap, date, childBom, charaRuleMap, bomEntryBefore, 0L);
                    } else {
                        bomEntryList.add(bomEntryAfter);
                    }
                    bomMaterialIdSet = this.getBomEntryFeatureMaterialSet(bomEntryList);
                    boolean bl = isDisable = !bomMaterialIdSet.contains(materialId2);
                    if (isDisable) {
                        log.info("getEditDataStock,stockIdStr = " + stockIdStr + ",isDisable=true,isDisable=" + isDisable);
                        parentQtyFz = BigDecimal.ZERO;
                    }
                }
                if (!(editList = this.genStockEditDiffData(bomEntryBefore, bomEntryAfter, beforeWsList, afterWsList, newBeforeStockList, newAfterStockList, parentQtyFz, parentQtyFm, ecoBomEntry, ecoBomEntryAfter, changeBill, childBom, orderType, xstockMap, sameBatchId, materialId2, isDisable, filterObj)).isEmpty()) {
                    gridList.addAll(editList);
                }
                if (isNullWs && !PlatformUtils.isNullList(editList) && !PlatformUtils.isNullList(newBeforeStockList)) {
                    for (int i = 0; i < newBeforeStockList.size(); ++i) {
                        Map<String, Object> map = newBeforeStockList.get(i);
                        Long stockEntryId = this.getLongValue(map, "stockentry");
                        String xStockString = this.genXStockKeyString("B", String.valueOf(stockEntryId), orderType, "", String.valueOf(materialId2));
                        if (xstockMap.containsKey(xStockString)) continue;
                        boolean isConverToXN = this.isConvertXN(map, ecoBomEntry, ecoBomEntryAfter);
                        if (isConverToXN && isFroward) {
                            Long pMaterialMasterId = materialId2;
                            Date expandBomDate = this.getExpandBomDate(ecoBomEntryAfter, map);
                            List<BomBaseData> bbdList = this.getBomExpandBbdList(isConfigBom, map, expandBomDate, bomResultCacheMap, bomEntryAfter, pMaterialMasterId, false);
                            if (!PlatformUtils.isNullList(bbdList)) {
                                ArrayList<Map<String, Object>> addStockDataList = new ArrayList<Map<String, Object>>(bbdList.size());
                                this.addBomNextResultToStock(map, bbdList, addStockDataList, map, sameBatchId, existsSet, ecoBomEntryAfter, changeBill, filterObj, gridList);
                                if (!addStockDataList.isEmpty()) {
                                    this.resetRemark(addStockDataList, convertXNRemark);
                                    gridList.addAll(this.convertAddData(addStockDataList, ecoBomEntryAfter, changeBill, filterObj));
                                }
                            }
                        }
                        if (totalDiffQty.compareTo(BigDecimal.ZERO) == 0) {
                            totalDiffQty = isFroward ? this.getDiffQty(null, bomEntryAfter, beforeWsList, afterWsList) : this.getDiffQty(bomEntryBefore, null, beforeWsList, afterWsList);
                        }
                        if (!isConverToUnXN && !isDisable && totalDiffQty.compareTo(BigDecimal.ZERO) == 0) continue;
                        stockId = this.getLongValue(map, "id");
                        log.info("getEditDataStock,isjumplevel ,begin update nextdata,stockId = " + stockId + ",stockDataMap=" + map.toString());
                        if (this.isShowDetialLog()) {
                            LogUtils.genLogs53(this.logs, map);
                        }
                        this.updateStockNextData(sameBatchId, MMCUtils.multiply((BigDecimal)totalDiffQty, (BigDecimal)parentQtyFz), parentQtyFm, stockId, orderType, map, gridList, 1, ecoBomEntry, ecoBomEntryAfter, changeBill, isConverToUnXN, isDisable, filterObj);
                    }
                }
                if (bomMaterialIdSet.isEmpty()) continue;
                for (Long l : bomMaterialIdSet) {
                    if (materialIdSet.contains(l)) continue;
                    addNewMaterialIdSet.add(l);
                }
            }
            if (addNewMaterialIdSet.isEmpty()) continue;
            Map addMaterial = BusinessDataServiceHelper.loadFromCache((String)"bd_material", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "in", addNewMaterialIdSet)});
            for (Long material : addNewMaterialIdSet) {
                String addFeatureMaterialRemark = String.format(ResManager.loadKDString((String)"\u65b0\u589e\u7279\u5f81\u7269\u6599\u201c%1$s\u201d\u540e\u8fdb\u884c\u4e0b\u5c42\u5c55\u5f00\u65f6\u589e\u52a0\u3002", (String)"GetEcoEffectOrderBusiness_22", (String)"mmc-pdm-business", (Object[])new Object[0]), ((DynamicObject)addMaterial.get(material)).getString("number"));
                List<Map<String, Object>> addStockDataList = this.getAddDataStock(beforeStockList, mftBomEntryMap, ecoBomEntryAfter, changeBill, mftBomMap, xstockMap, bomResultCacheMap, sameBatchId, wsMap, dataCacheMap, charaRuleMap, pmaterialCacheMap, material, filterObj);
                if (addStockDataList.isEmpty()) continue;
                this.resetRemark(addStockDataList, addFeatureMaterialRemark);
                gridList.addAll(addStockDataList);
            }
        }
        if (this.isShowDetialLog()) {
            LogUtils.genLogs52(this.logs, gridList);
        }
        return gridList;
    }

    private void updateStockNextData(Long sameBatchId, BigDecimal parentChangeQtyFz, BigDecimal parentChangeQtyFm, Long stockId, String orderType, Map<String, Object> parentStockMap, List<Map<String, Object>> gridList, int level, DynamicObject ecoBomEntryBefore, DynamicObject ecoBomEntryAfter, DynamicObject changeBill, boolean isConvertToUnXN, boolean isDisable, DynamicObject filterObj) {
        log.info("mmc-pdm-updateStockNextData:level =" + level + ",stockId=" + stockId + ",orderType=" + orderType + ",parentStockMap=" + parentStockMap.toString() + ",isConvertToUnXN = " + isConvertToUnXN + ",isDisable = " + isDisable + ",filterObj = " + filterObj.getString("number"));
        if (level > 15) {
            String billno = this.getStringValue(parentStockMap, "billno");
            int parentseq = this.getIntValue(parentStockMap, "stockentry.seq");
            String errorString = String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355\u201c%1$s\u201d\u5728\u8fdb\u884c\u4e0b\u5c42\u5e8f\u53f7\u201c%2$s\u201d\u67e5\u627e\u65f6\u5b58\u5728\u6b7b\u5faa\u73af\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"GetEcoEffectOrderBusiness_25", (String)"mmc-pdm-business", (Object[])new Object[0]), billno, parentseq);
            throw new KDBizException(errorString);
        }
        ++level;
        Long stockEntryId = this.getLongValue(parentStockMap, "stockentry");
        List<Map<String, Object>> stockDataList = this.getMftStockDataByParent(stockId, orderType, stockEntryId);
        log.info("mmc-pdm-updateStockNextData:parentStockEntryId =" + stockEntryId + ",stockId=" + stockId + ",orderType=" + orderType + ",stockDataList=" + stockDataList.toString());
        if (this.isShowDetialLog()) {
            String billno = this.getStringValue(parentStockMap, "billno");
            Long parentMaterialMasterId = this.getLongValue(parentStockMap, "stockentry.materielmasterid");
            LogUtils.genLogs54(this.logs, billno, orderType, stockEntryId, parentMaterialMasterId, stockDataList);
        }
        if (PlatformUtils.isNullList(stockDataList)) {
            return;
        }
        BigDecimal oldParentFz = this.getBigDecimalValue(parentStockMap, "oldqtynumerator");
        BigDecimal oldParentFm = this.getBigDecimalValue(parentStockMap, "oldqtydenominator");
        BigDecimal newParentFz = this.getBigDecimalValue(parentStockMap, "stockentry.qtynumerator");
        Long parentStockEntryId = this.getParentStockEntryId(parentStockMap);
        Set<Long> bomEntryIdSet = this.getBomEntryIdSetFromStockList(stockDataList);
        Map<Long, Fraction> bomEntryMap = this.queryBomEntryQty(bomEntryIdSet);
        boolean isParentZero = newParentFz.compareTo(BigDecimal.ZERO) == 0;
        for (int i = 0; i < stockDataList.size(); ++i) {
            Map<String, Object> stockDataMap = stockDataList.get(i);
            stockDataMap.put("samebatchid", sameBatchId);
            BigDecimal orderQty = this.getBigDecimalValue(stockDataMap, "qty");
            Fraction totalDiffFraction = this.getNextStockDiffQty(stockDataMap, isParentZero, oldParentFz, oldParentFm, parentChangeQtyFz, parentChangeQtyFm, bomEntryMap, isDisable || isConvertToUnXN);
            BigDecimal totalDiffFz = totalDiffFraction.getMole();
            BigDecimal totalDiffFm = totalDiffFraction.getDone();
            log.info("mmc-pdm-updateStockNextData:i =" + i + ",totalDiffFz=" + totalDiffFz.toString() + ",totalDiffFm=" + totalDiffFm.toString() + ",oldParentFz=" + oldParentFz.toString() + ",oldParentFm=" + oldParentFm.toString() + ",parentChangeQtyFz=" + parentChangeQtyFz.toString() + ",parentChangeQtyFm=" + parentChangeQtyFm.toString() + ",stockDataMap=" + (stockDataMap == null ? "null" : stockDataMap.toString()));
            if (totalDiffFz.compareTo(BigDecimal.ZERO) == 0) continue;
            String changeType = totalDiffFz.compareTo(BigDecimal.ZERO) > 0 ? "A" : "B";
            BigDecimal changeFz = totalDiffFz.abs();
            BigDecimal changeFm = totalDiffFm;
            BigDecimal changeStandQty = MMCUtils.multiplyAndDivide((BigDecimal)changeFz, (BigDecimal)orderQty, (BigDecimal)changeFm);
            Map<String, Object> dataMap = this.copyMap(stockDataMap);
            String remark = String.format(ResManager.loadKDString((String)"\u4e0a\u5c42\u4e3a\u8df3\u5c42\u4ef6\uff0c\u5b50\u5c42\u589e\u52a0\u5206\u5b50\u6570\u91cf\u201c%1$s\u201d\u3002", (String)"GetEcoEffectOrderBusiness_26", (String)"mmc-pdm-business", (Object[])new Object[0]), changeFz);
            if (changeFz.compareTo(BigDecimal.ZERO) < 0) {
                remark = String.format(ResManager.loadKDString((String)"\u4e0a\u5c42\u4e3a\u8df3\u5c42\u4ef6\uff0c\u5b50\u5c42\u5206\u5b50\u6570\u91cf\u51cf\u5c11\u4e86\u201c%1$s\u201d\u3002", (String)"GetEcoEffectOrderBusiness_27", (String)"mmc-pdm-business", (Object[])new Object[0]), changeFz);
            }
            if (isConvertToUnXN) {
                remark = String.format(ResManager.loadKDString((String)"\u4e0a\u5c42\u7269\u6599\u4ece\u8df3\u5c42\u4ef6\u53d8\u66f4\u4e3a\u975e\u8df3\u5c42\u4ef6\uff0c\u5c06\u5b50\u5c42\u6570\u636e\u8fdb\u884c\u5931\u6548\u64cd\u4f5c\uff0c\u51cf\u5c11\u5206\u5b50\u6570\u91cf[%1$s]", (String)"GetEcoEffectOrderBusiness_18", (String)"mmc-pdm-business", (Object[])new Object[0]), changeFz);
            }
            if (isDisable) {
                remark = String.format(ResManager.loadKDString((String)"\u4e0a\u5c42\u7269\u6599\u4e0d\u5b58\u5728\u4e8eBOM\u5c55\u5f00\u6e05\u5355\u4e2d\uff0c\u5c06\u5b50\u5c42\u6570\u636e\u8fdb\u884c\u5931\u6548\u64cd\u4f5c\uff0c\u51cf\u5c11\u5206\u5b50\u6570\u91cf[%1$s]", (String)"GetEcoEffectOrderBusiness_20", (String)"mmc-pdm-business", (Object[])new Object[0]), changeFz);
            }
            dataMap.put("remark", remark);
            dataMap.put("parentstockentryid", parentStockEntryId);
            Map<String, Object> gridMap = this.genGrideDataMap(dataMap, ecoBomEntryBefore, ecoBomEntryAfter, changeBill, null, null, null, changeType, changeFz, changeFm, changeStandQty, filterObj);
            gridList.add(gridMap);
            if (!this.getBooleanValue(stockDataMap, "stockentry.isjumplevel")) continue;
            this.updateStockNextData(sameBatchId, totalDiffFz, totalDiffFm, stockId, orderType, stockDataMap, gridList, level, ecoBomEntryBefore, ecoBomEntryAfter, changeBill, isConvertToUnXN, isDisable, filterObj);
        }
    }

    private Map<Long, Fraction> queryBomEntryQty(Set<Long> bomEntryIdSet) {
        HashMap<Long, Fraction> entryQtyMap = new HashMap<Long, Fraction>(16);
        Map<Long, DynamicObject> bomEntryMap = this.getMftBomEntryData(bomEntryIdSet);
        for (Map.Entry<Long, DynamicObject> maps : bomEntryMap.entrySet()) {
            DynamicObject bomEntry = maps.getValue();
            entryQtyMap.put(bomEntry.getLong("entryid"), new Fraction(bomEntry.getBigDecimal("entryqtynumerator"), bomEntry.getBigDecimal("entryqtydenominator")));
        }
        return entryQtyMap;
    }

    private Fraction getNextStockDiffQty(Map<String, Object> stockDataMap, boolean isParentZero, BigDecimal parentFz, BigDecimal parentFm, BigDecimal parentChangeQtyFz, BigDecimal parentChangeQtyFm, Map<Long, Fraction> bomEntryMap, boolean isDisable) {
        BigDecimal fz = this.getBigDecimalValue(stockDataMap, "stockentry.qtynumerator");
        BigDecimal fm = this.getBigDecimalValue(stockDataMap, "stockentry.qtydenominator");
        if (isDisable) {
            log.info("---getNextStockDiffQty----parentFz = 0,childChangeQty = 0");
            return new Fraction(BigDecimal.ZERO.subtract(fz), fm);
        }
        BigDecimal unitDiffFz = BigDecimal.ZERO;
        BigDecimal unitDiffFm = BigDecimal.ONE;
        if ((fz.compareTo(BigDecimal.ZERO) == 0 || isParentZero) && parentChangeQtyFz.compareTo(BigDecimal.ZERO) > 0) {
            Long bomentryId = this.getLongValue(stockDataMap, "stockentry.bomentryid");
            Fraction bomEntryFraction = bomEntryMap.get(bomentryId);
            unitDiffFz = MMCUtils.multiply((BigDecimal)parentChangeQtyFz, (BigDecimal)bomEntryFraction.getMole());
            unitDiffFm = MMCUtils.multiply((BigDecimal)parentChangeQtyFm, (BigDecimal)bomEntryFraction.getDone());
        } else {
            unitDiffFz = MMCUtils.multiply((BigDecimal)parentChangeQtyFz, (BigDecimal)MMCUtils.multiply((BigDecimal)fz, (BigDecimal)parentFm));
            unitDiffFm = MMCUtils.multiply((BigDecimal)parentChangeQtyFm, (BigDecimal)MMCUtils.multiply((BigDecimal)fm, (BigDecimal)parentFz));
        }
        return PlatformUtils.getDivideComQty((BigDecimal)unitDiffFz, (BigDecimal)unitDiffFm);
    }

    private Set<Long> getBomEntryIdSetFromStockList(List<Map<String, Object>> stockDataList) {
        HashSet<Long> bomentryIdSet = new HashSet<Long>(16);
        for (Map<String, Object> stockDataMap : stockDataList) {
            bomentryIdSet.add(this.getLongValue(stockDataMap, "stockentry.bomentryid"));
        }
        return bomentryIdSet;
    }

    private void genNullWsList(List<Map<String, Object>> wsList, DynamicObject bomentry) {
        if (wsList.isEmpty()) {
            HashMap<String, Number> wsMap = new HashMap<String, Number>(16);
            wsMap.put("fworkentryqtyfz", bomentry.getBigDecimal("entryqtynumerator"));
            wsMap.put("fworkentryqtyfm", bomentry.getBigDecimal("entryqtydenominator"));
            wsMap.put("fworkstation", 0L);
            wsMap.put("fworkcenter", 0L);
            wsMap.put("fentryid", 0L);
            wsList.add(wsMap);
        }
    }

    private String getStockEntryEntityName(String orderType) {
        if ("A".equals(orderType)) {
            return "pom_mftstock.stockentry";
        }
        return "om_mftstock.stockentry";
    }

    private List<Map<String, Object>> putAddStockDataMap(Map<String, Object> refStockDataMap, DynamicObject bomentry, List<Map<String, Object>> wsList, DynamicObject changeBill, DynamicObject ecoBomEntry, DynamicObject bom, BigDecimal parentQtyFz, BigDecimal parentQtyFm, List<Map<String, Object>> addStockDataList, Long sameBatchId, Set<String> existsSet, Long pStockEntryId) {
        this.genNullWsList(wsList, bomentry);
        ArrayList<Map<String, Object>> currentAddStockDataList = new ArrayList<Map<String, Object>>(16);
        Long childMaterialId = this.getLongId(bomentry, "entrymaterialid");
        for (int i = 0; i < wsList.size(); ++i) {
            Map<String, Object> dataMap = this.copyMap(refStockDataMap);
            Map<String, Object> wsMap = wsList.get(i);
            Long bomWorkCenter = this.getLongValue(wsMap, "fworkcenter");
            Long bomWorkStation = this.getLongValue(wsMap, "fworkstation");
            String orderType = this.getStringValue(dataMap, "ordertype");
            Long stockId = this.getLongValue(refStockDataMap, "id");
            String stockNo = this.getStringValue(dataMap, "billno");
            String existsKeySting = this.genExistsStockDataKeyString(orderType, stockId, bomentry.getLong("entryid"), childMaterialId);
            if (existsSet.contains(existsKeySting = this.getUnionString(existsKeySting, this.nullValue(pStockEntryId)))) {
                log.info("getAddDataStock,putAddStockDataMap,existsSet.contains(existsKeySting),stockNo=" + stockNo + ",childMaterialId=" + childMaterialId + ",existsKeySting=" + existsKeySting);
                if (!this.isShowDetialLog()) continue;
                LogUtils.genLogs13(this.logs, refStockDataMap, ecoBomEntry, childMaterialId);
                continue;
            }
            BigDecimal workEntryQtyFz = this.getBigDecimalValue(wsMap, "fworkentryqtyfz");
            BigDecimal orderQty = this.getBigDecimalValue(dataMap, "qty");
            BigDecimal fm = bomentry.getBigDecimal("entryqtydenominator");
            Fraction fraction = PlatformUtils.qtyMul((BigDecimal)parentQtyFz, (BigDecimal)parentQtyFm, (BigDecimal)workEntryQtyFz, (BigDecimal)fm);
            BigDecimal fz = fraction.getMole();
            fm = fraction.getDone();
            BigDecimal standqty = MMCUtils.multiplyAndDivide((BigDecimal)orderQty, (BigDecimal)fz, (BigDecimal)fm);
            dataMap.put("stockentry.oprworkcenter", bomWorkCenter);
            dataMap.put("stockentry.workstation", bomWorkStation);
            this.setAddStockMapValue(dataMap, bomentry, fz, fm, standqty, bomentry.getString("entryqtytype"), bomWorkCenter, bomWorkStation, sameBatchId);
            String remark = ResManager.loadKDString((String)"\u65b0\u589e\u7ec4\u4ef6\u6570\u636e", (String)"GetEcoEffectOrderBusiness_03", (String)"mmc-pdm-business", (Object[])new Object[0]);
            dataMap.put("remark", remark);
            dataMap.put("parentstockentryid", 0L);
            dataMap.put("stockentry", this.genLongId(orm, this.getStockEntryEntityName(orderType)));
            dataMap.put("stockentry.pstockentryid", pStockEntryId);
            addStockDataList.add(dataMap);
            currentAddStockDataList.add(dataMap);
            log.info("getAddDataStock,stockNo=" + stockNo + ",childMaterialId=" + childMaterialId + ",workEntryQtyFz=" + (workEntryQtyFz == null ? "null" : workEntryQtyFz.toString()) + ",fz=" + (fz == null ? "null" : fz.toString()) + ",fm=" + (fm == null ? "null" : fm.toString()) + ",bomWorkStation=" + (bomWorkStation == null ? "null" : bomWorkStation.toString()));
        }
        return currentAddStockDataList;
    }

    private int chkIsDisabled(Map<String, Object> stockDataMap, Map<String, String> xstockMap) {
        String materialId;
        String orderType;
        BigDecimal actIssueQty;
        BigDecimal demandQty = this.getBigDecimalValue(stockDataMap, "stockentry.demandqty");
        if (demandQty.compareTo(actIssueQty = this.getBigDecimalValue(stockDataMap, "stockentry.actissueqty")) <= 0) {
            return 1;
        }
        BigDecimal fz = this.getBigDecimalValue(stockDataMap, "stockentry.qtynumerator");
        if (fz.compareTo(BigDecimal.ZERO) <= 0) {
            return 2;
        }
        String stockEntryId = String.valueOf(this.getLongValue(stockDataMap, "stockentry"));
        String xStockString = this.genXStockKeyString("B", stockEntryId, orderType = this.getStringValue(stockDataMap, "ordertype"), "", materialId = String.valueOf(this.getLongValue(stockDataMap, "stockentry.materielmasterid")));
        if (xstockMap.containsKey(xStockString)) {
            return 3;
        }
        return 0;
    }

    private Set<String> genExistsStockDataSet(List<Map<String, Object>> stockDataList, Long parentEntryId, Map<String, List<Map<String, Object>>> childStockListMap) {
        int size = stockDataList.size();
        HashSet<String> existsSet = new HashSet<String>(size);
        HashSet<Long> thisNextEntryIdSet = new HashSet<Long>(16);
        if (!PlatformUtils.isNullLong((Long)parentEntryId)) {
            boolean isfind;
            int loop = 0;
            thisNextEntryIdSet.add(parentEntryId);
            do {
                isfind = false;
                for (int i = 0; i < size; ++i) {
                    Map<String, Object> stockDataMap = stockDataList.get(i);
                    Long stockEntryId = this.getLongValue(stockDataMap, "stockentry");
                    Long pstockEntryId = this.getLongValue(stockDataMap, "stockentry.pstockentryid");
                    if (!thisNextEntryIdSet.contains(pstockEntryId) || !thisNextEntryIdSet.add(stockEntryId)) continue;
                    isfind = true;
                }
            } while (isfind && ++loop <= 10);
        }
        for (int i = 0; i < size; ++i) {
            Map<String, Object> stockDataMap = stockDataList.get(i);
            String orderType = this.getStringValue(stockDataMap, "ordertype");
            Long stockId = this.getLongValue(stockDataMap, "id");
            Long bomentryId = this.getLongValue(stockDataMap, "stockentry.bomentryid");
            Long materialId = this.getLongValue(stockDataMap, "stockentry.materielmasterid");
            Long pstockEntryId = this.getLongValue(stockDataMap, "stockentry.pstockentryid");
            String keyString = this.genExistsStockDataKeyString(orderType, stockId, bomentryId, materialId);
            String keyStringFull = this.getUnionString(keyString, this.nullValue(pstockEntryId));
            if (existsSet.add(keyStringFull)) {
                this.addStockMapToList(childStockListMap, keyStringFull, stockDataMap);
            }
            if (!thisNextEntryIdSet.contains(pstockEntryId) || !existsSet.add(keyStringFull = this.getUnionString(keyString, this.nullValue(parentEntryId)))) continue;
            this.addStockMapToList(childStockListMap, keyStringFull, stockDataMap);
        }
        return existsSet;
    }

    private void addStockMapToList(Map<String, List<Map<String, Object>>> childStockListMap, String keyString, Map<String, Object> valueMap) {
        if (childStockListMap == null) {
            return;
        }
        List<Map<String, Object>> list = childStockListMap.get(keyString);
        if (list == null) {
            list = new ArrayList<Map<String, Object>>(16);
        }
        list.add(valueMap);
        childStockListMap.put(keyString, list);
    }

    private List<Map<String, Object>> getDisableDataStock(List<Map<String, Object>> stockDataList, DynamicObject bomEntry, DynamicObject ecoBomEntry, DynamicObject changeBill, Map<String, String> xstockMap, Long parentSameBatchId, DynamicObject filterObj) {
        Long bomentryId = ecoBomEntry.getLong("bomentry");
        ArrayList<Map<String, Object>> disableDataStockList = new ArrayList<Map<String, Object>>(16);
        String changeType = "B";
        HashMap<String, Long> bomentrySameBatchIdMap = new HashMap<String, Long>(16);
        for (int i = 0; i < stockDataList.size(); ++i) {
            Long topStockEntryId;
            Map<String, Object> stockDataMap = stockDataList.get(i);
            Long stockBomentryId = this.getLongValue(stockDataMap, "stockentry.bomentryid");
            if (!stockBomentryId.equals(bomentryId)) continue;
            int isDisabledValue = this.chkIsDisabled(stockDataMap, xstockMap);
            if (this.isShowDetialLog()) {
                LogUtils.genLogs31(this.logs, stockDataMap, bomEntry, ecoBomEntry, isDisabledValue, xstockMap);
            }
            if (isDisabledValue != 0) {
                log.info("getDisableDataStock,chkIsDisabled = true bomentryId=" + bomentryId.toString());
                continue;
            }
            Long stockId = this.getLongValue(stockDataMap, "id");
            String keys = PlatformUtils.getUnionString((Object)stockId, (Object)bomentryId);
            Long sameBatchId = parentSameBatchId;
            if (!parentSameBatchId.equals(0L)) {
                this.initStockDataSameBatchId(stockDataMap, parentSameBatchId);
                sameBatchId = parentSameBatchId;
            } else {
                sameBatchId = this.initStockDataSameBatchId(stockDataMap, null);
            }
            Long sameBatchId2 = (Long)bomentrySameBatchIdMap.get(keys);
            if (PlatformUtils.isNullLong((Long)sameBatchId2)) {
                bomentrySameBatchIdMap.put(keys, sameBatchId2);
            } else {
                sameBatchId = sameBatchId2;
            }
            stockDataMap.put("samebatchid", sameBatchId);
            disableDataStockList.add(stockDataMap);
            String remark = ResManager.loadKDString((String)"\u5931\u6548\u7ec4\u4ef6\u6570\u636e", (String)"GetEcoEffectOrderBusiness_05", (String)"mmc-pdm-business", (Object[])new Object[0]);
            stockDataMap.put("remark", remark);
            stockDataMap.put("parentstockentryid", 0L);
            stockDataMap.put("samebatchid", sameBatchId);
            if (!this.getBooleanValue(stockDataMap, "stockentry.isjumplevel")) continue;
            log.info("getDisableDataStock,isjumplevel = true bomentryId=" + bomentryId.toString());
            stockId = this.getLongValue(stockDataMap, "id");
            String orderType = this.getStringValue(stockDataMap, "ordertype");
            Long currentStockEntryId = topStockEntryId = this.getLongValue(stockDataMap, "stockentry");
            if (this.isShowDetialLog()) {
                LogUtils.genLogs32(this.logs, stockDataMap);
            }
            this.findNextStockData(stockDataList, stockId, orderType, currentStockEntryId, disableDataStockList, 0, sameBatchId, topStockEntryId);
        }
        ArrayList<Map<String, Object>> gridList = new ArrayList<Map<String, Object>>(disableDataStockList.size());
        for (int i = 0; i < disableDataStockList.size(); ++i) {
            Map stockDataMap = (Map)disableDataStockList.get(i);
            Map<String, Object> gridMap = this.genGrideDataMap(stockDataMap, ecoBomEntry, null, changeBill, null, null, null, changeType, this.getBigDecimalValue(stockDataMap, "stockentry.qtynumerator"), this.getBigDecimalValue(stockDataMap, "stockentry.qtydenominator"), this.getBigDecimalValue(stockDataMap, "stockentry.standqty"), filterObj);
            gridMap.put("qtynumerator", BigDecimal.ZERO);
            gridMap.put("demandqty", BigDecimal.ZERO);
            gridMap.put("entryqtynumerator2", BigDecimal.ZERO);
            gridList.add(gridMap);
        }
        if (this.isShowDetialLog()) {
            LogUtils.genLogs35(this.logs, gridList);
        }
        return gridList;
    }

    private Map<String, Object> genGrideDataMap(Map<String, Object> stockDataMap, DynamicObject ecoBomEntry, DynamicObject ecoBomEntryAfter, DynamicObject ecoBill, DynamicObject bomEntry, DynamicObject bom, Map<String, Object> workStationEntryMap, String changeType, BigDecimal changeQtyFz, BigDecimal changeQtyFm, BigDecimal changeStandQty, DynamicObject filterObj) {
        HashMap<String, Object> gridMap = new HashMap<String, Object>(128);
        gridMap.put("org", stockDataMap.get("org"));
        gridMap.put("ecochangebillno", ecoBill.get("billno"));
        gridMap.put("ecochangebillstatus", ecoBill.get("billstatus"));
        gridMap.put("orderbillno", stockDataMap.get("orderno"));
        gridMap.put("entrymode", "C".equals(ecoBomEntry.getString("entrymode")) ? "B" : ecoBomEntry.getString("entrymode"));
        gridMap.put("changetype", changeType);
        gridMap.put("changeqtynumerator", changeQtyFz);
        gridMap.put("changeqtydenominator", changeQtyFm);
        gridMap.put("changestandqty", changeStandQty);
        gridMap.put("material", stockDataMap.get("stockentry.materialid"));
        gridMap.put("materialmasterid", stockDataMap.get("stockentry.materielmasterid"));
        gridMap.put("unit", stockDataMap.get("stockentry.materialunitid"));
        gridMap.put("qtynumerator", stockDataMap.get("stockentry.qtynumerator"));
        gridMap.put("qtydenominator", stockDataMap.get("stockentry.qtydenominator"));
        gridMap.put("productmaterialmft", stockDataMap.get("productid"));
        gridMap.put("productunit", stockDataMap.get("unitid"));
        gridMap.put("orderqty", stockDataMap.get("qty"));
        gridMap.put("fixscrap", stockDataMap.get("stockentry.fixscrap"));
        gridMap.put("scraprate", stockDataMap.get("stockentry.scraprate"));
        gridMap.put("demandqty", stockDataMap.get("stockentry.demandqty"));
        gridMap.put("unissueqty", "C".equals(changeType) ? BigDecimal.ZERO : stockDataMap.get("stockentry.unissueqty"));
        gridMap.put("actissueqty", "C".equals(changeType) ? BigDecimal.ZERO : stockDataMap.get("stockentry.actissueqty"));
        gridMap.put("childbomid", bomEntry == null ? stockDataMap.get("stockentry.childbomid") : bomEntry.get("bomid"));
        gridMap.put("demanddate", stockDataMap.get("stockentry.demanddate"));
        gridMap.put("acttime", ecoBomEntryAfter == null ? ecoBomEntry.get("acttime") : ecoBomEntryAfter.get("acttime"));
        gridMap.put("workcenter", stockDataMap.get("stockentry.oprworkcenter"));
        gridMap.put("bomworkcenter", this.getBomWorkCenterId(bomEntry, workStationEntryMap, stockDataMap));
        gridMap.put("workstation", stockDataMap.get("stockentry.workstation"));
        gridMap.put("bomworkstation", this.getBomWorkStationId(bomEntry, workStationEntryMap, stockDataMap));
        gridMap.put("parentmaterial", this.getParenaMaterialMftId(stockDataMap, bom));
        gridMap.put("isjumplevel", bomEntry == null ? stockDataMap.get("stockentry.isjumplevel") : bomEntry.get("entryisjumplevel"));
        gridMap.put("stockno", stockDataMap.get("billno"));
        gridMap.put("configuredcode", stockDataMap.get("stockentry.entryconfiguredcode"));
        gridMap.put("mftbom", this.getEcoPEntryBomId(ecoBill, ecoBomEntry.getLong("ecobomid")));
        gridMap.put("productbom", stockDataMap.get("bomid"));
        gridMap.put("productconfiguredcode", stockDataMap.get("configuredcode"));
        gridMap.put("productworkcenter", stockDataMap.get("orderentryid.workcenter"));
        gridMap.put("transactiontype", stockDataMap.get("transactiontypeid"));
        gridMap.put("ordertype", stockDataMap.get("ordertype"));
        gridMap.put("stockseq", stockDataMap.get("stockentry.seq"));
        gridMap.put("entryqtytype", bomEntry == null ? stockDataMap.get("stockentry.qtytype") : bomEntry.get("entryqtytype"));
        gridMap.put("entryqtynumerator", ecoBomEntry.get("entryqtynumerator"));
        gridMap.put("entryqtynumerator2", ecoBomEntryAfter == null ? ecoBomEntry.get("entryqtynumerator") : ecoBomEntryAfter.get("entryqtynumerator"));
        gridMap.put("entryqtydenominator", ecoBomEntry.get("entryqtydenominator"));
        gridMap.put("entryqtydenominator2", ecoBomEntryAfter == null ? ecoBomEntry.get("entryqtydenominator") : ecoBomEntryAfter.get("entryqtydenominator"));
        gridMap.put("stockid", stockDataMap.get("id"));
        gridMap.put("stockentryid", stockDataMap.get("stockentry"));
        gridMap.put("orderid", stockDataMap.get("orderid"));
        gridMap.put("orderentryid", stockDataMap.get("orderentryid"));
        gridMap.put("bomentryid", bomEntry == null ? stockDataMap.get("stockentry.bomentryid") : Long.valueOf(bomEntry.getLong("entryid")));
        gridMap.put("oldbomentryid", stockDataMap.get("stockentry.bomentryid"));
        gridMap.put("ecoid", ecoBill.getLong("id"));
        gridMap.put("ecopentyrid", this.getEcoPEntryId(ecoBill, ecoBomEntry.getLong("ecobomid")));
        gridMap.put("ecobomentryid", ecoBomEntry.get("entryid"));
        gridMap.put("afterecobomentryid", ecoBomEntryAfter == null ? Long.valueOf(0L) : ecoBomEntryAfter.get("entryid"));
        gridMap.put("xstockbillno", this.getXStockBillNo(stockDataMap));
        gridMap.put("samebatchid", stockDataMap.get("samebatchid"));
        gridMap.put("remark", this.getStringValue(stockDataMap, "remark"));
        gridMap.put("parentstockentryid", this.getLongValue(stockDataMap, "parentstockentryid"));
        gridMap.put("pstockentryid", this.getLongValue(stockDataMap, "stockentry.pstockentryid"));
        gridMap.put("remark", this.getRemarkFromGridMap(gridMap));
        Long changeMaterialId = this.getChangeMaterial(ecoBomEntry, ecoBomEntryAfter);
        if (PlatformUtils.isNullLong((Long)changeMaterialId)) {
            changeMaterialId = this.getLongValue(stockDataMap, "stockentry.materielmasterid");
        }
        gridMap.put("changematerial", changeMaterialId);
        gridMap.put("stockmaterial", "C".equals(changeType) ? Long.valueOf(0L) : stockDataMap.get("stockentry.materialid"));
        gridMap.put("stockmaterialunit", "C".equals(changeType) ? Long.valueOf(0L) : stockDataMap.get("stockentry.materialunitid"));
        gridMap.put("stockqtynumerator", "C".equals(changeType) ? BigDecimal.ZERO : stockDataMap.get("stockentry.qtynumerator"));
        gridMap.put("stockqtydenominator", "C".equals(changeType) ? BigDecimal.ZERO : stockDataMap.get("stockentry.qtydenominator"));
        gridMap.put("entrygroupno", ecoBomEntry.get("entrygroupno"));
        gridMap.put("entryrefno", ecoBomEntry.get("entryrefno"));
        gridMap.put("bomchildversion", bomEntry == null ? this.getLongValue(stockDataMap, "stockentry.bomreversion") : this.getLongId(bomEntry, "entryversion"));
        gridMap.put("auxproperties", bomEntry == null ? this.getLongValue(stockDataMap, "stockentry.childauxpropertyid") : this.getLongId(bomEntry, "auxpropertyid"));
        gridMap.put("afterreplaceplan", bomEntry == null ? this.getLongValue(stockDataMap, "stockentry.replaceplan") : this.getLongId(bomEntry, "entryreplaceplan"));
        gridMap.put("afterreppriority", bomEntry == null ? this.getIntValue(stockDataMap, "stockentry.priority") : bomEntry.getInt("reppriority"));
        gridMap.put("afterisreplaceplanmm", bomEntry == null ? this.getBooleanValue(stockDataMap, "stockentry.ismainreplace") : bomEntry.getBoolean("entryisreplaceplanmm"));
        gridMap.put("entrytype", ecoBomEntry.getString("entrytype"));
        gridMap.put("changeentrynumber", this.getChangeEntry(ecoBomEntry, ecoBomEntryAfter, "number"));
        gridMap.put("changeentryname", this.getChangeEntry(ecoBomEntry, ecoBomEntryAfter, "name"));
        gridMap.put("featuretype", bomEntry == null ? this.getLongId(ecoBomEntry, "featuretype") : this.getLongId(bomEntry, "featuretype"));
        gridMap.put("ecorequirefilter", filterObj.getPkValue());
        gridMap.put("islock", Boolean.FALSE);
        this.reCalNewStockQty(gridMap);
        return gridMap;
    }

    private void reCalNewStockQty(Map<String, Object> gridMap) {
        BigDecimal stockEntryfz = PlatformUtils.getBigDecimalValue(gridMap, (String)"stockqtynumerator");
        BigDecimal stockEntryfm = PlatformUtils.getBigDecimalValue(gridMap, (String)"stockqtydenominator");
        BigDecimal changefz = PlatformUtils.getBigDecimalValue(gridMap, (String)"changeqtynumerator");
        BigDecimal changefm = PlatformUtils.getBigDecimalValue(gridMap, (String)"changeqtydenominator");
        BigDecimal orderQty = PlatformUtils.getBigDecimalValue(gridMap, (String)"orderqty");
        BigDecimal newfz = BigDecimal.ZERO;
        BigDecimal newfm = BigDecimal.ONE;
        String changeType = PlatformUtils.getStringValue(gridMap, (String)"changetype");
        if ("C".equals(changeType)) {
            newfz = changefz;
            newfm = changefm;
        } else if ("D".equals(changeType)) {
            newfz = stockEntryfz;
            newfm = stockEntryfm;
        } else {
            if ("B".equals(changeType)) {
                changefz = BigDecimal.ZERO.subtract(changefz);
            }
            Fraction fraction = PlatformUtils.qtyAdd((BigDecimal)stockEntryfz, (BigDecimal)stockEntryfm, (BigDecimal)changefz, (BigDecimal)changefm);
            newfz = fraction.getMole();
            newfm = fraction.getDone();
        }
        if (newfz.compareTo(BigDecimal.ZERO) < 0) {
            newfz = BigDecimal.ZERO;
        }
        gridMap.put("qtynumerator", newfz);
        gridMap.put("qtydenominator", newfm);
        gridMap.put("demandqty", MMCUtils.multiplyAndDivide((BigDecimal)orderQty, (BigDecimal)newfz, (BigDecimal)newfm));
    }

    private Long getChangeMaterial(DynamicObject ecoBomEntry, DynamicObject ecoBomEntryAfter) {
        return ecoBomEntryAfter == null ? this.getLongId(ecoBomEntry, "entrymaterial") : this.getLongId(ecoBomEntryAfter, "entrymaterial");
    }

    private Object getChangeEntry(DynamicObject ecoBomEntry, DynamicObject ecoBomEntryAfter, String fieldNumber) {
        if ("B".equals(ecoBomEntry.getString("entrytype"))) {
            Long featureTypeId = ecoBomEntryAfter == null ? ecoBomEntry.getLong("featuretype") : ecoBomEntryAfter.getLong("featuretype");
            DynamicObject featureType = BusinessDataServiceHelper.loadSingleFromCache((Object)featureTypeId, (String)"mpdm_featuretype", (String)"id,number,name");
            return featureType.getString(fieldNumber);
        }
        Long materialId = ecoBomEntryAfter == null ? ecoBomEntry.getLong("entrymaterial") : ecoBomEntryAfter.getLong("entrymaterial");
        DynamicObject material = BusinessDataServiceHelper.loadSingleFromCache((Object)materialId, (String)"bd_material", (String)"id,number,name");
        return material.getString(fieldNumber);
    }

    private String getRemarkFromGridMap(Map<String, Object> gridMap) {
        Long bomentryId2;
        Long bomentryId1;
        if (gridMap == null) {
            return "";
        }
        String remark = this.getStringValue(gridMap, "remark");
        String changeType = this.getStringValue(gridMap, "changetype");
        if ((changeType.equals("A") || changeType.equals("B") || changeType.equals("D")) && !(bomentryId1 = this.getLongValue(gridMap, "bomentryid")).equals(bomentryId2 = this.getLongValue(gridMap, "oldbomentryid"))) {
            String remark1 = ResManager.loadKDString((String)"BOM\u5206\u5f55ID\u8fdb\u884c\u4e86\u8c03\u6574\u3002", (String)"GetEcoEffectOrderBusiness_10", (String)"mmc-pdm-business", (Object[])new Object[0]);
            remark = "".equals(remark) ? remark1 : remark + "," + remark1;
        }
        return remark;
    }

    private Long getBomWorkCenterId(DynamicObject bomentry, Map<String, Object> workStationEntryMap, Map<String, Object> stockDataMap) {
        return this.getLongValue(stockDataMap, "stockentry.oprworkcenter");
    }

    private Long getBomWorkStationId(DynamicObject bomentry, Map<String, Object> workStationEntryMap, Map<String, Object> stockDataMap) {
        return this.getLongValue(stockDataMap, "stockentry.workstation");
    }

    private Object getParenaMaterialMftId(Map<String, Object> stockDataMap, DynamicObject bom) {
        if (bom == null) {
            return stockDataMap.get("stockentry.parentmaterial");
        }
        DynamicObject materialMft = bom.getDynamicObject("material");
        if (materialMft == null) {
            DynamicObject material = bom.getDynamicObject("materialid");
            return this.getMateriaMftId(material.getLong("id"), this.getLongValue(stockDataMap, "org"));
        }
        return materialMft.getPkValue();
    }

    private String getXStockBillNo(Map<String, Object> stockDataMap) {
        return "";
    }

    private Long initStockDataSameBatchId(Map<String, Object> stockDataMap, Long sameBatchId) {
        if (PlatformUtils.isNullLong((Long)sameBatchId)) {
            if (stockDataMap.containsKey("samebatchid")) {
                sameBatchId = this.getLongValue(stockDataMap, "samebatchid");
            }
            if (PlatformUtils.isNullLong((Long)sameBatchId)) {
                sameBatchId = ID.genLongId();
            }
            stockDataMap.put("samebatchid", sameBatchId);
        } else {
            stockDataMap.put("samebatchid", sameBatchId);
        }
        return sameBatchId;
    }

    private void findNextStockData(List<Map<String, Object>> stockDataList, Long stockId, String orderType, Long pStockEntryId, List<Map<String, Object>> returnDataStockList, int loopcount, Long sameBatchId, Long topStockEntryId) {
        if (loopcount > 2000) {
            String billno = this.getStockBillNo(stockDataList, stockId, orderType);
            String errorString = String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355\u201c%1$s\u201d\u5728\u8fdb\u884c\u4e0b\u5c42\u5206\u5f55ID\u201c%2$s\u201d\u67e5\u627e\u65f6\u5b58\u5728\u6b7b\u5faa\u73af\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"GetEcoEffectOrderBusiness_02", (String)"mmc-pdm-business", (Object[])new Object[0]), billno, pStockEntryId);
            throw new KDBizException(errorString);
        }
        List<Map<String, Object>> nextStockDataList = this.getMftStockDataByParent(stockId, orderType, pStockEntryId);
        log.info("getDisableDataStock,findNextStockData , stockId=" + String.valueOf(stockId) + ", orderType=" + orderType + ", pStockEntryId=" + pStockEntryId);
        log.info("getDisableDataStock,findNextStockData , loopcount=" + ++loopcount + ",nextStockDataList=" + nextStockDataList.toString());
        if (this.isShowDetialLog()) {
            String billno = this.getStockBillNo(stockDataList, stockId, orderType);
            LogUtils.genLogs33(this.logs, billno, orderType, pStockEntryId, nextStockDataList);
        }
        if (PlatformUtils.isNullList(nextStockDataList)) {
            return;
        }
        Map<String, String> nextXStockMap = this.getXStockDataMap(nextStockDataList);
        for (int i = 0; i < nextStockDataList.size(); ++i) {
            Map<String, Object> stockDataMap = nextStockDataList.get(i);
            int isDisabledValue = this.chkIsDisabled(stockDataMap, nextXStockMap);
            if (isDisabledValue != 0) {
                if (!this.isShowDetialLog()) continue;
                LogUtils.genLogs34(this.logs, isDisabledValue, nextXStockMap, stockDataMap);
                continue;
            }
            String remark = ResManager.loadKDString((String)"\u7236\u9879\u4e3a\u8df3\u5c42\u4ef6\uff0c\u5b50\u5c42\u7ec4\u4ef6\u6570\u636e\u5931\u6548\u3002", (String)"GetEcoEffectOrderBusiness_06", (String)"mmc-pdm-business", (Object[])new Object[0]);
            stockDataMap.put("remark", remark);
            stockDataMap.put("parentstockentryid", topStockEntryId);
            stockDataMap.put("samebatchid", sameBatchId);
            returnDataStockList.add(stockDataMap);
            if (!this.getBooleanValue(stockDataMap, "stockentry.isjumplevel")) continue;
            Long currentStockId = this.getLongValue(stockDataMap, "stockentry");
            if (this.isShowDetialLog()) {
                LogUtils.genLogs32(this.logs, stockDataMap);
            }
            this.findNextStockData(stockDataList, stockId, orderType, currentStockId, returnDataStockList, loopcount, sameBatchId, topStockEntryId);
        }
    }

    private String getStockBillNo(List<Map<String, Object>> stockDataList, Long stockId, String orderType) {
        for (int i = 0; i < stockDataList.size(); ++i) {
            Map<String, Object> stockDataMap = stockDataList.get(i);
            if (!stockId.equals(this.getLongValue(stockDataMap, "id")) || !orderType.equals(this.getStringValue(stockDataMap, "ordertype"))) continue;
            return this.getStringValue(stockDataMap, "billno");
        }
        return "";
    }

    private Set<Long> getBomEntryIdSetFrombbdList(List<BomBaseData> bbdList) {
        int size = bbdList.size();
        HashSet<Long> entryIdSet = new HashSet<Long>(size);
        for (int i = 0; i < size; ++i) {
            BomBaseData bbd = bbdList.get(i);
            Long bomEntryId = bbd.getBomEntryId();
            entryIdSet.add(bomEntryId);
        }
        return entryIdSet;
    }

    private Long getParentStockEntryId(Map<String, Object> parentMap) {
        Long parentStockEntryId = this.getLongValue(parentMap, "parentstockentryid");
        if (PlatformUtils.isNullLong((Long)parentStockEntryId)) {
            parentStockEntryId = this.getLongValue(parentMap, "stockentry");
        }
        return parentStockEntryId;
    }

    private void initBomEntryMaterial(DynamicObject bomentry, Long materialMasterId, Long orgId) {
        Long oldMasterId;
        if ("B".equals(bomentry.getString("entrytype")) && !materialMasterId.equals(oldMasterId = this.getLongId(bomentry, "entrymaterialid"))) {
            DynamicObject mft = this.getMateriaMftDynamicObject(orgId, materialMasterId);
            bomentry.set("entrymaterialid", (Object)materialMasterId);
            bomentry.set("entrymaterial", (Object)mft.getLong("id"));
            bomentry.set("entrymaterialattr", (Object)mft.getString("materialattr"));
            bomentry.set("entryunit", (Object)mft.getDynamicObject("mftunit").getLong("id"));
        }
    }

    private void addNextDataToSet(Map<String, Object> refStockMap, Set<Long> bomentryIdSet, Set<String> existsSet, Long pStockEntryId, Map<String, List<Map<String, Object>>> childStockListMap) {
        Set<String> nextSet;
        Long stockId = this.getLongValue(refStockMap, "id");
        String orderType = this.getStringValue(refStockMap, "ordertype");
        QFilter qFilter = new QFilter("id", "=", (Object)stockId);
        qFilter.and(new QFilter("stockentry.bomentryid", "in", bomentryIdSet));
        List<Map<String, Object>> nextMapList = this.getMftStockData(qFilter, orderType);
        if (!PlatformUtils.isNullList(nextMapList) && !PlatformUtils.isNullSet(nextSet = this.genExistsStockDataSet(nextMapList, pStockEntryId, childStockListMap))) {
            existsSet.addAll(nextSet);
        }
    }

    private void addBomNextResultToStock(Map<String, Object> refStockMap, List<BomBaseData> bbdList, List<Map<String, Object>> addStockDataList, Map<String, Object> parentMap, Long sameBatchId, Set<String> existsSet, DynamicObject ecoBomEntry, DynamicObject changeBill, DynamicObject filterObj, List<Map<String, Object>> editGridList) {
        int size = bbdList.size();
        BigDecimal parentQtyFz = this.getBigDecimalValue(parentMap, "stockentry.qtynumerator");
        BigDecimal parentQtyFm = this.getBigDecimalValue(parentMap, "stockentry.qtydenominator");
        Set<Long> bomEntryIdSet = this.getBomEntryIdSetFrombbdList(bbdList);
        Map<Long, DynamicObject> bomEntryMap = this.getMftBomEntryData(bomEntryIdSet);
        Long stockId = this.getLongValue(refStockMap, "id");
        Long orgId = this.getLongValue(refStockMap, "org");
        String orderType = this.getStringValue(refStockMap, "ordertype");
        Long parentStockEntryId = this.getParentStockEntryId(parentMap);
        BigDecimal orderQty = this.getBigDecimalValue(parentMap, "qty");
        Long pStockEntryId = this.getLongValue(parentMap, "stockentry");
        Long materialMftId = this.getLongValue(parentMap, "stockentry.materialid");
        HashMap<Long, Long> pmStockEntryIdMap = new HashMap<Long, Long>(16);
        pmStockEntryIdMap.put(materialMftId, pStockEntryId);
        HashMap<String, List<Map<String, Object>>> childStockListMap = new HashMap<String, List<Map<String, Object>>>(16);
        this.addNextDataToSet(refStockMap, bomEntryIdSet, existsSet, pStockEntryId, childStockListMap);
        ArrayList<Map<String, Object>> thisAddStockDataList = new ArrayList<Map<String, Object>>(16);
        for (int i = 0; i < size; ++i) {
            BomBaseData bbd = bbdList.get(i);
            Long l = bbd.getBomEntryId();
            DynamicObject bomentry = bomEntryMap.get(l);
            if (bomentry == null) continue;
            Long materialMasterId = bbd.getMaterilID();
            this.initBomEntryMaterial(bomentry, materialMasterId, orgId);
            Long bomWorkCenter = bbd.getWorkCenterId();
            Long bomWorkStation = bbd.getWorkStationId();
            String existsKeySting = this.genExistsStockDataKeyString(orderType, stockId, l, materialMasterId);
            existsKeySting = this.getUnionString(existsKeySting, this.nullValue(pStockEntryId));
            BigDecimal workEntryQty = (BigDecimal)bbd.getQtynumerator();
            BigDecimal fm = (BigDecimal)bbd.getQtydenominator();
            Fraction fraction = PlatformUtils.qtyMul((BigDecimal)parentQtyFz, (BigDecimal)parentQtyFm, (BigDecimal)workEntryQty, (BigDecimal)fm);
            BigDecimal fz = fraction.getMole();
            fm = fraction.getDone();
            BigDecimal standqty = MMCUtils.multiplyAndDivide((BigDecimal)orderQty, (BigDecimal)fz, (BigDecimal)fm);
            if (existsSet.contains(existsKeySting)) {
                List<Map<String, Object>> currentEditGridList;
                List childStockEntryList = (List)childStockListMap.get(existsKeySting);
                Fraction diffFraction = this.getDiffFractionByList(childStockEntryList, fraction);
                if (diffFraction.getMole().compareTo(BigDecimal.ZERO) == 0 || PlatformUtils.isNullList((List)childStockEntryList)) {
                    log.info("getAddDataStock,addBomNextResultToStock,existsSet existsKeySting=" + existsKeySting);
                    if (!this.isShowDetialLog()) continue;
                    LogUtils.genLogs8(this.logs, refStockMap, bomentry, bomWorkCenter, bomWorkStation);
                    continue;
                }
                if (this.isShowDetialLog()) {
                    LogUtils.genLogs15(this.logs, refStockMap, childStockEntryList, materialMasterId, diffFraction);
                }
                if (PlatformUtils.isNullList(currentEditGridList = this.updateChildStockDataQty(sameBatchId, childStockEntryList, ecoBomEntry, changeBill, filterObj, diffFraction, parentStockEntryId))) continue;
                editGridList.addAll(currentEditGridList);
                continue;
            }
            Long parentMaterialMftId = bbd.getPMaterialid();
            Map<String, Object> dataMap = this.copyMap(refStockMap);
            this.setAddStockMapValue(dataMap, bomentry, fz, fm, standqty, (String)bbd.getQtytype(), bomWorkCenter, bomWorkStation, sameBatchId);
            String remark = ResManager.loadKDString((String)"\u7236\u9879\u4e3a\u8df3\u5c42\u4ef6\uff0c\u65b0\u589e\u5b50\u5c42\u7ec4\u4ef6\u6570\u636e\u3002", (String)"GetEcoEffectOrderBusiness_04", (String)"mmc-pdm-business", (Object[])new Object[0]);
            dataMap.put("remark", remark);
            dataMap.put("parentstockentryid", parentStockEntryId);
            dataMap.put("stockentry.entryconfiguredcode", bbd.getConfigedCodeId());
            dataMap.put("stockentry.parentmaterial", parentMaterialMftId);
            dataMap.put("stockentry", this.genLongId(orm, this.getStockEntryEntityName(orderType)));
            dataMap.put("stockentry.pstockentryid", pmStockEntryIdMap.get(parentMaterialMftId));
            pmStockEntryIdMap.put(this.getLongValue(dataMap, "stockentry.materialid"), this.getLongValue(dataMap, "stockentry"));
            thisAddStockDataList.add(dataMap);
        }
        if (!thisAddStockDataList.isEmpty()) {
            Map<String, String> xStockMap = this.getXStockDataMap(thisAddStockDataList);
            for (Map map : thisAddStockDataList) {
                Long bomentryId = this.getLongValue(map, "stockentry.bomentryid");
                Long childMaterialId = this.getLongValue(map, "stockentry.materielmasterid");
                String xStockString = this.genXStockKeyString("A", String.valueOf(stockId), orderType, String.valueOf(bomentryId), String.valueOf(childMaterialId));
                if (xStockMap.containsKey(xStockString)) {
                    if (!this.isShowDetialLog()) continue;
                    LogUtils.genLogs14(this.logs, map, xStockMap.get(xStockString));
                    continue;
                }
                addStockDataList.add(map);
            }
        }
    }

    private boolean isConfigureMaterial(Long materialId) {
        if (PlatformUtils.isNullLong((Long)materialId)) {
            return false;
        }
        DynamicObject material = MaterialQueryHelper.getDataCacheByID((Object)materialId);
        String configproperties = material.getString("configproperties") == null ? "" : material.getString("configproperties");
        return "2".equals(configproperties) || "3".equals(configproperties);
    }

    private Long getConfigureCode(Map<String, Object> dataMap, DynamicObject bomentry) {
        Long materialMaster = bomentry.getLong("entrymaterialid");
        if (this.isConfigureMaterial(materialMaster)) {
            return this.getLongValue(dataMap, "configuredcode");
        }
        return this.getLongId(bomentry, "entryconfiguredcode");
    }

    private void setAddStockMapValue(Map<String, Object> dataMap, DynamicObject bomentry, BigDecimal fz, BigDecimal fm, BigDecimal standqty, String qtyType, Long bomWorkCenter, Long bomWorkStation, Long sameBatchId) {
        dataMap.put("stockentry.materialid", this.getMateriaMftByMasterId(this.getLongValue(dataMap, "org"), bomentry));
        dataMap.put("stockentry.materielmasterid", this.getLongId(bomentry, "entrymaterialid"));
        dataMap.put("stockentry.entryconfiguredcode", this.getConfigureCode(dataMap, bomentry));
        dataMap.put("stockentry.qtynumerator", fz);
        dataMap.put("stockentry.qtydenominator", fm);
        dataMap.put("stockentry.materialunitid", this.getLongId(bomentry, "entryunit"));
        dataMap.put("stockentry.qtytype", qtyType);
        dataMap.put("stockentry.standqty", standqty);
        dataMap.put("stockentry.demandqty", standqty);
        dataMap.put("stockentry.actissueqty", BigDecimal.ZERO);
        dataMap.put("stockentry.unissueqty", standqty);
        dataMap.put("stockentry.childbomid", bomentry.getLong("bomid"));
        dataMap.put("stockentry.bomentryid", bomentry.getLong("entryid"));
        dataMap.put("stockentry.isjumplevel", bomentry.getBoolean("entryisjumplevel"));
        if (!PlatformUtils.isNullLong((Long)bomWorkCenter)) {
            dataMap.put("stockentry.oprworkcenter", bomWorkCenter);
        }
        if (!PlatformUtils.isNullLong((Long)bomWorkStation)) {
            dataMap.put("stockentry.workstation", bomWorkStation);
        }
        dataMap.put("stockentry.scraprate", bomentry.get("entryscraprate"));
        dataMap.put("stockentry.fixscrap", bomentry.get("entryfixscrap"));
        dataMap.put("stockentry.seq", 0);
        dataMap.put("samebatchid", sameBatchId);
        dataMap.put("stockentry.bomreversion", this.getLongId(bomentry, "entryversion"));
        dataMap.put("stockentry.childauxpropertyid", this.getLongId(bomentry, "auxpropertyid"));
        dataMap.put("stockentry.replaceplan", this.getLongId(bomentry, "entryreplaceplan"));
        dataMap.put("stockentry.ismainreplace", bomentry.getBoolean("entryisreplaceplanmm"));
        dataMap.put("stockentry.priority", bomentry.getInt("reppriority"));
    }

    private List<Map<String, Object>> getMftStockDataByBomEntryId(Set<Long> mftBomEntryIdSet, QFilter otherFilter, DynamicObject filterObject) {
        QFilter qFilter = new QFilter("stockentry.bomentryid", "in", mftBomEntryIdSet);
        if (otherFilter != null) {
            qFilter.and(otherFilter);
        }
        qFilter.and(this.getCommonQuery(filterObject));
        String stockEntityNumber = (String)filterObject.getDynamicObject("objectentity").getPkValue();
        Set<String> filterExtFieldSet = this.getMatchFieldSet(filterObject, stockEntityNumber);
        DataSet mftstockDataSet = this.getMftStockDataSet(qFilter, stockEntityNumber, filterExtFieldSet);
        List stockDataList = MMCUtils.parseToList((DataSet)mftstockDataSet);
        log.info("getMftStockDataByBomEntryId,qFilter=" + qFilter.toString() + ",stockDataList=" + (stockDataList == null ? "null" : stockDataList.toString()));
        mftstockDataSet.close();
        if (this.isShowDetialLog()) {
            LogUtils.genLogs3(this.logs, stockDataList, qFilter, stockEntityNumber);
        }
        return stockDataList;
    }

    private List<Map<String, Object>> getMftStockDataByBomId(Set<Long> childBomIdSet, QFilter otherFilter, DynamicObject filterObject) {
        QFilter qFilter = new QFilter("stockentry.childbomid", "in", childBomIdSet);
        if (otherFilter != null) {
            qFilter.and(otherFilter);
        }
        ArrayList<Map<String, Object>> stockDataList = new ArrayList<Map<String, Object>>(64);
        qFilter.and(this.getCommonQuery(filterObject));
        String stockEntityNumber = (String)filterObject.getDynamicObject("objectentity").getPkValue();
        List<Long> stockEntryIdList = this.transIdQFilter(qFilter, stockEntityNumber);
        List<List<Long>> splits = this.splitIdData(stockEntryIdList);
        if (!splits.isEmpty()) {
            Set<String> filterExtFieldSet = this.getMatchFieldSet(filterObject, stockEntityNumber);
            for (List<Long> list : splits) {
                QFilter filters;
                DataSet mftstockDataSet;
                if (list == null || list.isEmpty() || (mftstockDataSet = this.getMftStockDataSet(filters = new QFilter("stockentry.id", "in", (Object)list.toArray()), stockEntityNumber, filterExtFieldSet)) == null) continue;
                List toList = MMCUtils.parseToList((DataSet)mftstockDataSet);
                if (toList != null && !toList.isEmpty()) {
                    stockDataList.addAll(toList);
                }
                mftstockDataSet.close();
            }
        }
        if (this.isShowDetialLog()) {
            LogUtils.genLogs2(this.logs, stockDataList, qFilter, stockEntityNumber);
        }
        return stockDataList;
    }

    private DataSet getMftStockDataSet(QFilter qFilter, String stockEntityNumber, Set<String> filterExtFieldSet) {
        String selectProperties = GetEcoEffectOrderBusiness.getStockSelectProperties(stockEntityNumber, filterExtFieldSet);
        DataSet ds = this.queryMftStockDataSet(qFilter, stockEntityNumber, selectProperties);
        return ds;
    }

    private DataSet queryMftStockDataSet(QFilter qFilter, String stockEntityNumber, String selectProperties) {
        long startTime = System.currentTimeMillis();
        DataSet mftstockDataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoxKeyString("getMftStockDataSet"), (String)stockEntityNumber, (String)selectProperties, (QFilter[])new QFilter[]{qFilter}, (String)"");
        String orderType = "'" + this.getMftStockTag(stockEntityNumber) + "'";
        mftstockDataSet = mftstockDataSet.addField(orderType, "ordertype");
        long enddate = System.currentTimeMillis() - startTime;
        log.info("queryMftStockDataSet,cost:" + enddate + "ms,stockEntityNumber=" + stockEntityNumber + ",selectProperties=" + selectProperties + ",qFilter=" + qFilter.toString());
        return mftstockDataSet;
    }

    private String getMftStockTag(String stockEntityNumber) {
        return "pom_mftstock".equals(stockEntityNumber) ? "A" : "B";
    }

    private List<Map<String, Object>> getMftStockDataByParent(Long stockId, String orderType, Long pStockEntryId) {
        QFilter qFilter = new QFilter("id", "=", (Object)stockId);
        if (!PlatformUtils.isNullLong((Long)pStockEntryId)) {
            qFilter.and(new QFilter("stockentry.pstockentryid", "=", (Object)pStockEntryId));
        }
        return this.getMftStockData(qFilter, orderType);
    }

    private List<Map<String, Object>> getMftStockData(QFilter qFilter, String orderType) {
        DataSet ds = null;
        ds = "A".equals(orderType) ? this.getMftStockDataSet(qFilter, "pom_mftstock", null) : this.getMftStockDataSet(qFilter, "om_mftstock", null);
        List stockDataList = MMCUtils.parseToList((DataSet)ds);
        ds.close();
        return stockDataList;
    }

    public static String getStockSelectProperties(String entityNumber, Set<String> filterExtFieldSet) {
        Set<String> fields = GetEcoEffectOrderBusiness.getStockFields(entityNumber, filterExtFieldSet);
        return GetEcoEffectOrderBusiness.genStringBySet(fields);
    }

    private static Set<String> getStockFields(String entityNumber, Set<String> extFieldSet) {
        HashSet<String> queryFieldSet = new HashSet<String>(64);
        queryFieldSet.add("id");
        queryFieldSet.add("org");
        queryFieldSet.add("billno");
        queryFieldSet.add("productid");
        queryFieldSet.add("productmasterid");
        queryFieldSet.add("configuredcode");
        queryFieldSet.add("unitid");
        queryFieldSet.add("qty");
        queryFieldSet.add("transactiontypeid");
        queryFieldSet.add("bomid");
        queryFieldSet.add("processroute");
        queryFieldSet.add("orderno");
        queryFieldSet.add("orderid");
        queryFieldSet.add("orderentryid");
        queryFieldSet.add("orderentryid.planstatus");
        queryFieldSet.add("orderentryid.pickstatus");
        queryFieldSet.add("orderentryid.bizstatus");
        queryFieldSet.add("orderentryid.workcenter");
        queryFieldSet.add("orderentryid.expendbomtime");
        queryFieldSet.add("orderentryid.planbegintime");
        queryFieldSet.add("stockentry");
        queryFieldSet.add("stockentry.entryconfiguredcode");
        queryFieldSet.add("stockentry.materialid");
        queryFieldSet.add("stockentry.materielmasterid");
        queryFieldSet.add("stockentry.qtynumerator");
        queryFieldSet.add("stockentry.qtydenominator");
        queryFieldSet.add("stockentry.materialunitid");
        queryFieldSet.add("stockentry.qtytype");
        queryFieldSet.add("stockentry.standqty");
        queryFieldSet.add("stockentry.demandqty");
        queryFieldSet.add("stockentry.actissueqty");
        queryFieldSet.add("stockentry.unissueqty");
        queryFieldSet.add("stockentry.childbomid");
        queryFieldSet.add("stockentry.demanddate");
        queryFieldSet.add("stockentry.parentmaterial");
        queryFieldSet.add("stockentry.bomentryid");
        queryFieldSet.add("stockentry.isjumplevel");
        queryFieldSet.add("stockentry.oprworkcenter");
        queryFieldSet.add("stockentry.workstation");
        queryFieldSet.add("stockentry.seq");
        queryFieldSet.add("stockentry.bomreversion");
        queryFieldSet.add("stockentry.childauxpropertyid");
        queryFieldSet.add("stockentry.fixscrap");
        queryFieldSet.add("stockentry.scraprate");
        queryFieldSet.add("stockentry.pstockentryid");
        queryFieldSet.add("stockentry.replaceplan");
        queryFieldSet.add("stockentry.priority");
        queryFieldSet.add("stockentry.ismainreplace");
        if (!PlatformUtils.isNullSet(extFieldSet)) {
            queryFieldSet.addAll(extFieldSet);
        }
        return queryFieldSet;
    }

    @Override
    public String getAlgoxKeyString(String paramString) {
        return GetEcoEffectOrderBusiness.class.getName() + "_" + paramString;
    }

    private String getEcoBomEntryDataSelectProperties(Set<String> filterExtFieldSet) {
        Set<String> fields = this.getECNEntryFields(filterExtFieldSet);
        return GetEcoEffectOrderBusiness.genStringBySet(fields);
    }

    private Set<String> getECNEntryFields(Set<String> filterExtFieldSet) {
        HashSet<String> queryFieldSet = new HashSet<String>(64);
        queryFieldSet.add("id");
        queryFieldSet.add("entryid");
        queryFieldSet.add("entrymode");
        queryFieldSet.add("entrytype");
        queryFieldSet.add("entrymaterial");
        queryFieldSet.add("entrymaterialmft");
        queryFieldSet.add("featuretype");
        queryFieldSet.add("entryunit");
        queryFieldSet.add("tranqty");
        queryFieldSet.add("transtartdate");
        queryFieldSet.add("acttime");
        queryFieldSet.add("entryvaliddate");
        queryFieldSet.add("entryinvaliddate");
        queryFieldSet.add("entrymaterialattr");
        queryFieldSet.add("entryqtynumerator");
        queryFieldSet.add("entryqtydenominator");
        queryFieldSet.add("entryfixscrap");
        queryFieldSet.add("entryscraprate");
        queryFieldSet.add("entryconfiguredcode");
        queryFieldSet.add("entryqtytype");
        queryFieldSet.add("entryauxproperty");
        queryFieldSet.add("bomentry");
        queryFieldSet.add("entrybomentryid");
        queryFieldSet.add("ecobomid");
        queryFieldSet.add("entryisjumplevel");
        queryFieldSet.add("entrygroupno");
        queryFieldSet.add("entryrefno");
        queryFieldSet.add("continuouspoint");
        queryFieldSet.add("iscanestimate");
        queryFieldSet.add("entryisreplace");
        queryFieldSet.add("entryreplaceplan");
        queryFieldSet.add("entryisreplaceplanmm");
        queryFieldSet.add("reppriority");
        queryFieldSet.add("entryseq");
        queryFieldSet.add("minacttime");
        queryFieldSet.add("entryversion");
        if (!PlatformUtils.isNullSet(filterExtFieldSet)) {
            queryFieldSet.addAll(filterExtFieldSet);
        }
        return queryFieldSet;
    }

    public Map<Long, DynamicObject> getEcoBomEntryData(Set<Long> ecoBomEntryIdSet, Set<Long> bomentryIdSet, Set<Long> childMaterialIdSet, List<Long> sortEntryIdList, Set<String> filterExtFieldSet) {
        long startTime = System.currentTimeMillis();
        HashMap<Long, DynamicObject> dataMap = new HashMap<Long, DynamicObject>(16);
        QFilter filter = new QFilter("id", "in", ecoBomEntryIdSet);
        QFilter[] qFilters = new QFilter[]{filter};
        String selectProperties = this.getEcoBomEntryDataSelectProperties(filterExtFieldSet);
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"pdm_ecobom_entryf7", (String)selectProperties, (QFilter[])qFilters, (String)"ecobomid,entryseq");
        for (DynamicObject dy : coll) {
            Long materialId;
            Long bomentryId;
            sortEntryIdList.add(dy.getLong("entryid"));
            dataMap.put(dy.getLong("entryid"), dy);
            if (bomentryIdSet != null && !PlatformUtils.isNullLong((Long)(bomentryId = Long.valueOf(dy.getLong("bomentry"))))) {
                bomentryIdSet.add(bomentryId);
            }
            if (childMaterialIdSet == null || PlatformUtils.isNullLong((Long)(materialId = Long.valueOf(dy.getLong("entrymaterial"))))) continue;
            childMaterialIdSet.add(materialId);
        }
        long enddate = System.currentTimeMillis() - startTime;
        log.info("getEcoBomEntryData,cost:" + enddate + "ms,ecoBomEntryIdSet.size=" + ecoBomEntryIdSet.size());
        return dataMap;
    }

    private String getMftBomEntrySelectProperties() {
        StringBuilder sb = new StringBuilder();
        sb.append("id ");
        sb.append(",entryid ");
        sb.append(",entryseq ");
        sb.append(",entryvaliddate ");
        sb.append(",entryinvaliddate ");
        sb.append(",entrymaterialattr ");
        sb.append(",entrymaterial ");
        sb.append(",entryunit ");
        sb.append(",entryqtytype ");
        sb.append(",entryqtynumerator ");
        sb.append(",entryqtydenominator ");
        sb.append(",entryisjumplevel ");
        sb.append(",bomid ");
        sb.append(",entryconfiguredcode ");
        sb.append(",entrymaterialid ");
        sb.append(",entryversion ");
        sb.append(",auxpropertyid ");
        sb.append(",entryfixscrap ");
        sb.append(",entryscraprate ");
        sb.append(",entrytype ");
        sb.append(",entryisreplace ");
        sb.append(",entryreplaceplan ");
        sb.append(",entryisreplaceplanmm ");
        sb.append(",reppriority ");
        sb.append(",featuretype ");
        return sb.toString();
    }

    public Map<Long, DynamicObject> getMftBomEntryData(Set<Long> mftBomEntryIdSet) {
        if (mftBomEntryIdSet.isEmpty()) {
            return new HashMap<Long, DynamicObject>(16);
        }
        long startTime = System.currentTimeMillis();
        HashMap<Long, DynamicObject> dataMap = new HashMap<Long, DynamicObject>(mftBomEntryIdSet.size());
        QFilter filter = new QFilter("entryid", "in", mftBomEntryIdSet);
        QFilter[] qFilters = new QFilter[]{filter};
        String selectProperties = this.getMftBomEntrySelectProperties();
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"pdm_mftbomentry", (String)selectProperties, (QFilter[])qFilters);
        for (DynamicObject dy : coll) {
            dataMap.put(dy.getLong("entryid"), dy);
        }
        long enddate = System.currentTimeMillis() - startTime;
        log.info("getMftBomEntryData,cost:" + enddate + "ms,mftBomEntryIdSet.size=" + mftBomEntryIdSet.size());
        return dataMap;
    }

    private Long getMateriaMftId(Long org, Long materialMasterId) {
        DynamicObject mft = this.getMateriaMftDynamicObject(org, materialMasterId);
        return mft.getLong("id");
    }

    private DynamicObject getMateriaMftDynamicObject(Long org, Long materialMasterId) {
        HashSet<Long> masterIdSet = new HashSet<Long>(16);
        masterIdSet.add(materialMasterId);
        Map mft = MaterialMftQueryHelper.getDataCacheByMaterialSet(masterIdSet, (Long)org);
        if (mft == null || mft.get(materialMasterId) == null) {
            DynamicObject orgDy = this.getOrgDy(org);
            DynamicObject materialDy = this.getMaterialDy(materialMasterId);
            throw new KDBizException(new ErrorCode("valideMaterialMftInfo", String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%1$s\u201d\u5728\u751f\u4ea7\u7ec4\u7ec7\u201c%2$s\u201d\u4e0b\u4e0d\u5b58\u5728\u7269\u6599\u751f\u4ea7\u4fe1\u606f\uff0c\u8bf7\u5148\u7ef4\u62a4\u597d\u57fa\u7840\u6570\u636e\u3002", (String)"GetEcoEffectOrderBusiness_13", (String)"mmc-pdm-business", (Object[])new Object[0]), materialDy == null ? String.valueOf(materialMasterId) : materialDy.getString("number"), orgDy.getString("number"))), new Object[0]);
        }
        return (DynamicObject)mft.get(materialMasterId);
    }

    private Long getMateriaMftByMasterId(Long org, DynamicObject bomentry) {
        Long mftId = this.getLongId(bomentry, "entrymaterial");
        if (PlatformUtils.isNullLong((Long)mftId)) {
            Long masterId = this.getLongId(bomentry, "entrymaterialid");
            return this.getMateriaMftId(org, masterId);
        }
        return mftId;
    }

    private Map<Object, DynamicObject> getMftBomData(Set<Long> mftBomIdSet) {
        if (mftBomIdSet.isEmpty()) {
            return new HashMap<Object, DynamicObject>(16);
        }
        long startTime = System.currentTimeMillis();
        QFilter filter = new QFilter("id", "in", mftBomIdSet);
        QFilter[] qFilters = new QFilter[]{filter};
        String selectProperties = "id,material,materialid,createorg,number,version,auxproperty,replaceno";
        Map map = BusinessDataServiceHelper.loadFromCache((String)"pdm_mftbom", (String)selectProperties, (QFilter[])qFilters);
        long enddate = System.currentTimeMillis() - startTime;
        log.info("getMftBomEntryData,cost:" + enddate + "ms,mftBomEntryIdSet.size=" + mftBomIdSet.size());
        return map;
    }

    private List<BomBaseData> expandConfigBom(JSONObject configCodeJs, Long materialMasterId, Date searchTime, BigDecimal qty, Map<String, String> bomResultCacheMap, Long pMaterialMasterId, Long productOrgId, boolean includeParent) {
        ExpandBomByConfigBom business = new ExpandBomByConfigBom();
        return business.expandBom(configCodeJs, materialMasterId, searchTime, qty, bomResultCacheMap, pMaterialMasterId, productOrgId, includeParent);
    }

    private List<BomBaseData> expandMulTypeBom(Long bomId, Long orgId, BigDecimal qty, Date expendbomtime, String type, Long routeId, Long productMaterialMasterId, Long configeCodeId, Long transactionType, Long childMaterialMasterId, Map<String, String> bomResultCacheMap) {
        ExpandBomByMulType business = new ExpandBomByMulType();
        return business.expandBom(bomId, orgId, qty, expendbomtime, type, routeId, productMaterialMasterId, configeCodeId, transactionType, childMaterialMasterId, bomResultCacheMap);
    }

    private DynamicObject getEcoBomEntryAfter(Map<Long, DynamicObject> ecobomEntryMap, DynamicObject ecoBomEntryBefore) {
        Long bomentryId = ecoBomEntryBefore.getLong("entrybomentryid");
        Long ecoBomId = ecoBomEntryBefore.getLong("ecobomid");
        for (Map.Entry<Long, DynamicObject> entrys : ecobomEntryMap.entrySet()) {
            DynamicObject ecoBomEntry = entrys.getValue();
            if (!this.isAfterModifyMode(ecoBomEntry) || !bomentryId.equals(ecoBomEntry.getLong("entrybomentryid")) || !ecoBomId.equals(ecoBomEntry.getLong("ecobomid"))) continue;
            return ecoBomEntry;
        }
        return null;
    }

    private String genStockIdKey(Long stockId, String orderType) {
        return this.getUnionString(stockId, orderType);
    }

    private List<Map<String, Object>> getparentQtyData(Long materialMatserId, Long bomVersionId, Long auxPropertyId, List<Map<String, Object>> stockDataList, Map<String, Object> refStockDataMap, Map<String, String> bomResultCacheMap, Map<String, List<Map<String, Object>>> cacheMap, Set<Long> pStockEntryIdSet) {
        Long orderMaterialMasterId = this.getLongValue(refStockDataMap, "productmasterid");
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(16);
        if (orderMaterialMasterId.equals(materialMatserId)) {
            log.info("getAddDataStock-getparentQtyData,orderMaterialMasterId.equals(materialMatserId)");
            HashMap<String, Number> resultMap = new HashMap<String, Number>(16);
            resultMap.put("stockentry.qtynumerator", BigDecimal.ONE);
            resultMap.put("stockentry.qtydenominator", BigDecimal.ONE);
            resultMap.put("stockentry", 0L);
            resultList.add(resultMap);
            return resultList;
        }
        Long stockId = this.getLongValue(refStockDataMap, "id");
        String orderType = this.getStringValue(refStockDataMap, "ordertype");
        String KeyString = "parentQtyCache_" + stockId + "_" + orderType + "_" + materialMatserId + "_" + bomVersionId + "_" + auxPropertyId;
        if (cacheMap.containsKey(KeyString)) {
            return cacheMap.get(KeyString);
        }
        String stockEntryTable = "t_pom_manustockentry";
        if ("B".equals(orderType)) {
            stockEntryTable = "t_om_mftstockentry";
        }
        ArrayList<Long> paramList = new ArrayList<Long>(16);
        StringBuilder sb = new StringBuilder();
        sb.append(" select");
        sb.append(" fdetailid ");
        sb.append(",fqtynumerator ");
        sb.append(",fqtydenominator ");
        sb.append(" from ").append(stockEntryTable).append(" b ");
        sb.append(" where fentryid = ? ");
        sb.append(" and fmaterielmasterid = ? ");
        paramList.add(stockId);
        paramList.add(materialMatserId);
        if (!PlatformUtils.isNullSet(pStockEntryIdSet)) {
            sb.append(" and fdetailid in ( ");
            int size = pStockEntryIdSet.size();
            int loop = 0;
            for (Long pstockEntryId : pStockEntryIdSet) {
                sb.append(" ? ");
                if (++loop < size) {
                    sb.append(" , ");
                }
                paramList.add(pstockEntryId);
            }
            sb.append(" ) ");
        }
        try (DataSet ds = DB.queryDataSet((String)this.getAlgoxKeyString("getparentQtyData"), (DBRoute)scmDBRoute, (String)sb.toString(), (Object[])paramList.toArray());){
            for (Row row : ds) {
                BigDecimal fz = row.getBigDecimal("fqtynumerator");
                BigDecimal fm = row.getBigDecimal("fqtydenominator");
                Long stockEntryId = row.getLong("fdetailid");
                HashMap<String, Number> resultMap = new HashMap<String, Number>(16);
                resultMap.put("stockentry.qtynumerator", fz);
                resultMap.put("stockentry.qtydenominator", fm);
                resultMap.put("stockentry", stockEntryId);
                resultList.add(resultMap);
                log.info("getAddDataStock-getparentQtyData-LOOP,fz=" + (fz == null ? "null" : fz.toString()) + ",fm=" + (fm == null ? "null" : fm.toString()) + ",stockentryid=" + stockEntryId.toString());
            }
        }
        cacheMap.put(KeyString, resultList);
        return resultList;
    }

    private Map<String, BigDecimal> getparentQty(Long materialMatserId, Long bomVersionId, Long auxPropertyId, List<Map<String, Object>> stockDataList, Map<String, Object> refStockDataMap, Map<String, String> bomResultCacheMap, Map<String, List<Map<String, Object>>> cacheMap, Set<Long> pStockEntryIdSet) {
        List<Map<String, Object>> parentMaterialList = this.getparentQtyData(materialMatserId, bomVersionId, auxPropertyId, stockDataList, refStockDataMap, bomResultCacheMap, cacheMap, pStockEntryIdSet);
        HashMap<String, BigDecimal> parentMap = new HashMap<String, BigDecimal>(16);
        parentMap.put("stockentry.qtynumerator", BigDecimal.ONE);
        parentMap.put("stockentry.qtydenominator", BigDecimal.ONE);
        if (PlatformUtils.isNullList(parentMaterialList)) {
            return parentMap;
        }
        BigDecimal qtyFz = BigDecimal.ZERO;
        BigDecimal qtyFm = BigDecimal.ZERO;
        for (Map<String, Object> parentMaterialMap : parentMaterialList) {
            BigDecimal parentFz = this.getBigDecimalValue(parentMaterialMap, "stockentry.qtynumerator");
            BigDecimal parentFm = this.getBigDecimalValue(parentMaterialMap, "stockentry.qtydenominator");
            if (parentFz.compareTo(BigDecimal.ZERO) <= 0 || parentFm.compareTo(BigDecimal.ZERO) <= 0) continue;
            if (qtyFm.compareTo(BigDecimal.ZERO) == 0) {
                qtyFm = parentFm;
                qtyFz = parentFz;
                continue;
            }
            Fraction fraction = PlatformUtils.qtyAdd((BigDecimal)parentFz, (BigDecimal)parentFm, (BigDecimal)qtyFz, (BigDecimal)qtyFm);
            qtyFz = fraction.getMole();
            qtyFm = fraction.getDone();
        }
        parentMap.put("stockentry.qtynumerator", qtyFz);
        parentMap.put("stockentry.qtydenominator", qtyFm);
        return parentMap;
    }

    private Map<String, String> queryXStockNoAuditData(Set<String> stockEntryIdSet, String orderType, Map<String, String> xStockMap) {
        if (stockEntryIdSet == null || stockEntryIdSet.isEmpty()) {
            return Collections.emptyMap();
        }
        String xStockHeadTable = "t_pom_xmftorderentry_s";
        String xStockEntryTable = "t_pom_xmanustockentry_b";
        String xStockEntryTable2 = "t_pom_xmanustockentry";
        if ("B".equals(orderType)) {
            xStockHeadTable = "t_om_xmftorderentry_s";
            xStockEntryTable = "t_om_xmftstockentry_a";
            xStockEntryTable2 = "t_om_xmftstockentry";
        }
        SqlBuilder sb = new SqlBuilder();
        sb.append(" select", new Object[0]);
        sb.append(" s.fbillno ", new Object[0]).append(" as ", new Object[0]).append("fxbillno", new Object[0]);
        sb.append(",b.fstockentryid ", new Object[0]).append(" as ", new Object[0]).append("fstockentryid", new Object[0]);
        sb.append(",b2.fmaterielmasterid ", new Object[0]).append(" as ", new Object[0]).append("fmaterialid", new Object[0]);
        sb.append(" from ", new Object[0]).append(xStockEntryTable, new Object[0]).append(" b ", new Object[0]);
        sb.append(" inner join ", new Object[0]).append(xStockHeadTable, new Object[0]).append(" s on b.fentryid = s.fentryid  ", new Object[0]);
        sb.append(" inner join ", new Object[0]).append(xStockEntryTable2, new Object[0]).append(" b2 on b2.fdetailid =  b.fdetailid  ", new Object[0]);
        sb.append(" where s.fbillstatus in('A','B') and ", new Object[0]);
        sb.appendIn("b.fstockentryid", stockEntryIdSet.toArray());
        try (DataSet ds = DB.queryDataSet((String)this.getAlgoxKeyString("getXStockNoAuditData"), (DBRoute)scmDBRoute, (SqlBuilder)sb);){
            for (Row row : ds) {
                String fxbillno = row.getString("fxbillno");
                String fstockentryid = row.getString("fstockentryid");
                String fmaterialId = row.getString("fmaterialid");
                String keyString = this.genXStockKeyString("B", fstockentryid, orderType, "", fmaterialId);
                xStockMap.put(keyString, fxbillno);
            }
        }
        return xStockMap;
    }

    private Map<String, String> queryXStockNoAuditAddData(Set<String> stockIdSet, String orderType, Map<String, String> xStockMap) {
        if (stockIdSet == null || stockIdSet.isEmpty()) {
            return Collections.emptyMap();
        }
        SqlBuilder sb = new SqlBuilder();
        sb.append(" select", new Object[0]);
        if ("B".equals(orderType)) {
            sb.append(" s.fbillno ", new Object[0]).append(" as ", new Object[0]).append("fxbillno", new Object[0]);
            sb.append(",b.fstockid ", new Object[0]).append(" as ", new Object[0]).append("fstockid", new Object[0]);
            sb.append(",a.fbomentryid ", new Object[0]).append(" as ", new Object[0]).append("fbomentryid", new Object[0]);
            sb.append(",a.fmaterielmasterid ", new Object[0]).append(" as ", new Object[0]).append("fmaterialid", new Object[0]);
            sb.append(" from t_om_xmftstockentry_a b ", new Object[0]);
            sb.append(" inner join t_om_xmftstockentry a on a.fdetailid  = b.fdetailid   ", new Object[0]);
            sb.append(" inner join t_om_xmftorderentry_s s on b.fentryid = s.fentryid    ", new Object[0]);
            sb.append(" where s.fbillstatus in('A','B') and ", new Object[0]);
            sb.append(" b.fentrychangetype = 'A' and ", new Object[0]);
            sb.appendIn("b.fstockid", stockIdSet.toArray());
        } else {
            sb.append(" s.fbillno ", new Object[0]).append(" as ", new Object[0]).append("fxbillno", new Object[0]);
            sb.append(",b.fstockid ", new Object[0]).append(" as ", new Object[0]).append("fstockid", new Object[0]);
            sb.append(",a.fbomentryid ", new Object[0]).append(" as ", new Object[0]).append("fbomentryid", new Object[0]);
            sb.append(",c.fmaterielmasterid ", new Object[0]).append(" as ", new Object[0]).append("fmaterialid", new Object[0]);
            sb.append(" from t_pom_xmanustockentry_b b ", new Object[0]);
            sb.append(" inner join t_pom_xmanustockentry_a a on a.fdetailid  = b.fdetailid   ", new Object[0]);
            sb.append(" inner join t_pom_xmanustockentry c on c.fdetailid  = b.fdetailid   ", new Object[0]);
            sb.append(" inner join t_pom_xmftorderentry_s s on b.fentryid = s.fentryid    ", new Object[0]);
            sb.append(" where s.fbillstatus in('A','B') and ", new Object[0]);
            sb.append(" a.fentrychangetype = 'A' and ", new Object[0]);
            sb.appendIn("b.fstockid", stockIdSet.toArray());
        }
        try (DataSet ds = DB.queryDataSet((String)this.getAlgoxKeyString("getXStockNoAuditAddData"), (DBRoute)scmDBRoute, (SqlBuilder)sb);){
            for (Row row : ds) {
                String fxbillno = row.getString("fxbillno");
                String fstockid = row.getString("fstockid");
                String fbomentryid = row.getString("fbomentryid");
                String fmaterialid = row.getString("fmaterialid");
                String keyString = this.genXStockKeyString("A", fstockid, orderType, fbomentryid, fmaterialid);
                xStockMap.put(keyString, fxbillno);
            }
        }
        return xStockMap;
    }

    private void queryStockAddData(Set<Long> stockIdSet, String orderType, Set<String> existStockIdSet, Set<Long> bomentryIdSet) {
        if (stockIdSet == null || stockIdSet.isEmpty()) {
            return;
        }
        int stockSize = stockIdSet.size();
        int bomentrySize = bomentryIdSet.size();
        ArrayList<Long> paramList = new ArrayList<Long>(stockSize + bomentrySize + 1);
        StringBuilder sb = new StringBuilder();
        int seq = 0;
        sb.append(" select");
        sb.append(" a.fentryid ").append(" as ").append("fstockid");
        sb.append(" ,a.fbomentryid ").append(" as ").append("fbomentryid");
        if ("A".equals(orderType)) {
            sb.append(" ,b.fmaterielmasterid ").append(" as ").append("fmaterialid");
            sb.append(" from t_pom_manustockentry_a a ");
            sb.append(" inner join t_pom_manustockentry b on a.fdetailid = b.fdetailid ");
        } else {
            sb.append(" ,a.fmaterielmasterid ").append(" as ").append("fmaterialid");
            sb.append(" from t_om_mftstockentry a ");
        }
        sb.append(" where a.fentryid in ( ");
        for (Long stockId : stockIdSet) {
            paramList.add(stockId);
            sb.append(" ? ");
            if (++seq == stockSize) continue;
            sb.append(" , ");
        }
        sb.append(" ) ");
        sb.append(" and a.fbomentryid in (  ");
        seq = 0;
        for (Long bomentryId : bomentryIdSet) {
            paramList.add(bomentryId);
            sb.append(" ? ");
            if (++seq == bomentrySize) continue;
            sb.append(" , ");
        }
        sb.append(" ) ");
        try (DataSet ds = DB.queryDataSet((String)this.getAlgoxKeyString("queryStockAddData"), (DBRoute)scmDBRoute, (String)sb.toString(), (Object[])paramList.toArray());){
            for (Row row : ds) {
                Long fstockid = row.getLong("fstockid");
                Long fbomentryid = row.getLong("fbomentryid");
                Long fmaterialId = row.getLong("fmaterialid");
                existStockIdSet.add(fstockid + "_" + fbomentryid + "_" + orderType + "_" + fmaterialId);
            }
        }
    }

    private String genXStockKeyString(String queryType, String stockId, String orderType, String bomentryId, String materialId) {
        return this.getUnionString(queryType, stockId, orderType, bomentryId, materialId);
    }

    private String genExistsStockDataKeyString(String orderType, Long stockId, Long bomentryId, Long materialId) {
        return this.getUnionString(orderType, this.nullValue(stockId), this.nullValue(bomentryId), this.nullValue(materialId));
    }

    private Map<String, String> getXStockDataMap(List<Map<String, Object>> stockDataList) {
        String orderType;
        long startTime = System.currentTimeMillis();
        HashMap<String, HashSet<String>> stockIdMap = new HashMap<String, HashSet<String>>(16);
        HashMap<String, HashSet<String>> stockEntryIdMap = new HashMap<String, HashSet<String>>(16);
        for (int i = 0; i < stockDataList.size(); ++i) {
            Iterator stockDataMap = stockDataList.get(i);
            Long stockId = this.getLongValue((Map<String, Object>)((Object)stockDataMap), "id");
            Long stockEntryId = this.getLongValue((Map<String, Object>)((Object)stockDataMap), "stockentry");
            String orderType2 = this.getStringValue((Map<String, Object>)((Object)stockDataMap), "ordertype");
            HashSet<String> stockIdSet = (HashSet<String>)stockIdMap.get(orderType2);
            if (stockIdSet == null) {
                stockIdSet = new HashSet<String>(stockDataList.size());
            }
            stockIdSet.add(String.valueOf(stockId));
            stockIdMap.put(orderType2, stockIdSet);
            HashSet<String> stockEntryIdSet = (HashSet<String>)stockEntryIdMap.get(orderType2);
            if (stockEntryIdSet == null) {
                stockEntryIdSet = new HashSet<String>(stockDataList.size());
            }
            stockEntryIdSet.add(String.valueOf(stockEntryId));
            stockEntryIdMap.put(orderType2, stockEntryIdSet);
        }
        HashMap<String, String> xMap = new HashMap<String, String>(128);
        for (Map.Entry entrys : stockEntryIdMap.entrySet()) {
            orderType = (String)entrys.getKey();
            Set stockEntryIdSet = (Set)entrys.getValue();
            this.queryXStockNoAuditData(stockEntryIdSet, orderType, xMap);
        }
        for (Map.Entry entrys : stockIdMap.entrySet()) {
            orderType = (String)entrys.getKey();
            Set stockIdSet = (Set)entrys.getValue();
            this.queryXStockNoAuditAddData(stockIdSet, orderType, xMap);
        }
        long enddate = System.currentTimeMillis() - startTime;
        log.info("getXStockDataMap,cost:" + enddate + "ms,stockDataList.size=" + stockDataList.size());
        return xMap;
    }

    private Set<String> getExistsStockAddData(List<Map<String, Object>> stockDataList, Long bomentryId) {
        long startTime = System.currentTimeMillis();
        HashMap<String, HashSet<Object>> stockIdMap = new HashMap<String, HashSet<Object>>(16);
        for (int i = 0; i < stockDataList.size(); ++i) {
            Map<String, Object> stockDataMap = stockDataList.get(i);
            Long stockId = this.getLongValue(stockDataMap, "id");
            String string = this.getStringValue(stockDataMap, "ordertype");
            HashSet<Object> stockIdSet = (HashSet<Object>)stockIdMap.get(string);
            if (stockIdSet == null) {
                stockIdSet = new HashSet<Object>(stockDataList.size());
            }
            stockIdSet.add(stockId);
            stockIdMap.put(string, stockIdSet);
        }
        HashSet<String> existStockIdSet = new HashSet<String>(stockDataList.size());
        HashSet<Long> bomentryIdSet = new HashSet<Long>(16);
        bomentryIdSet.add(bomentryId);
        for (Map.Entry entry : stockIdMap.entrySet()) {
            String orderType = (String)entry.getKey();
            Set stockIdSet = (Set)entry.getValue();
            this.queryStockAddData(stockIdSet, orderType, existStockIdSet, bomentryIdSet);
        }
        long enddate = System.currentTimeMillis() - startTime;
        log.info("getExistsStockAddData,cost:" + enddate + "ms,stockDataList.size=" + stockDataList.size());
        return existStockIdSet;
    }

    private Set<String> getStockIdSet(List<Map<String, Object>> stockDataList) {
        HashSet<String> stockIdSet = new HashSet<String>(16);
        for (int i = 0; i < stockDataList.size(); ++i) {
            Map<String, Object> stockDataMap = stockDataList.get(i);
            Long stockId = this.getLongValue(stockDataMap, "id");
            String orderType = this.getStringValue(stockDataMap, "ordertype");
            stockIdSet.add(this.genStockIdKey(stockId, orderType));
        }
        return stockIdSet;
    }

    private List<Map<String, Object>> getStocDataByBomEntryId(List<Map<String, Object>> stockDataList, Long bomentryId, String stockIdStr, Set<Long> materialIdSet) {
        ArrayList<Map<String, Object>> resultDataList = new ArrayList<Map<String, Object>>(16);
        for (int i = 0; i < stockDataList.size(); ++i) {
            Map<String, Object> stockDataMap = stockDataList.get(i);
            Long stockId = this.getLongValue(stockDataMap, "id");
            String orderType = this.getStringValue(stockDataMap, "ordertype");
            Long stockBomentryId = this.getLongValue(stockDataMap, "stockentry.bomentryid");
            Long stockMaterialId = this.getLongValue(stockDataMap, "stockentry.materielmasterid");
            if (!stockIdStr.equals(this.genStockIdKey(stockId, orderType)) || !stockBomentryId.equals(bomentryId)) continue;
            if (materialIdSet != null) {
                materialIdSet.add(stockMaterialId);
            }
            resultDataList.add(stockDataMap);
        }
        return resultDataList;
    }

    private boolean materialIsConfig(DynamicObject productMaterial) {
        return "2".equals(productMaterial.get("configproperties"));
    }

    private boolean containSuperBomType(List<Object> bomTypeIDList) {
        QFilter qfilter = new QFilter("id", "in", bomTypeIDList);
        qfilter.and(new QFilter("purpose", "=", (Object)"B"));
        Map bomMap = BusinessDataServiceHelper.loadFromCache((String)"mpdm_bomtype", (String)"id", (QFilter[])new QFilter[]{qfilter});
        return bomMap != null && !bomMap.isEmpty();
    }

    private boolean transactionTypeChkSuperBom(DynamicObject transactionType) {
        DynamicObjectCollection bomtypes;
        if (transactionType != null && CollectionUtils.isNotEmpty((Collection)(bomtypes = transactionType.getDynamicObjectCollection("bomtypes")))) {
            ArrayList<Object> pkValues = new ArrayList<Object>(bomtypes.size());
            for (DynamicObject dyn : bomtypes) {
                pkValues.add(dyn.get("fbasedataid_id"));
            }
            if (this.containSuperBomType(pkValues)) {
                return true;
            }
        }
        return false;
    }

    private boolean isConfigBomInterface(Long transactionTypeId, Long materialId, Long configcodeId) {
        if (PlatformUtils.isNullLong((Long)configcodeId)) {
            return false;
        }
        DynamicObject material = this.getMaterialDy(materialId);
        if (!this.materialIsConfig(material)) {
            return false;
        }
        DynamicObject transactionType = TransactionTypeQueryHelper.getDataCacheByID((Object)transactionTypeId);
        return this.transactionTypeChkSuperBom(transactionType);
    }

    public static Map<String, Object> convertMap(Map<String, Object> dataMap) {
        HashMap<String, Object> convertDataMap = new HashMap<String, Object>(128);
        convertDataMap.put("ordertype", dataMap.get("ordertype"));
        convertDataMap.put("stockid", PlatformUtils.getLongValue(dataMap, (String)"stockid"));
        convertDataMap.put("stockentryid", PlatformUtils.getLongValue(dataMap, (String)"stockentryid"));
        BigDecimal newfz = PlatformUtils.getBigDecimalValue(dataMap, (String)"qtynumerator");
        BigDecimal newfm = PlatformUtils.getBigDecimalValue(dataMap, (String)"qtydenominator");
        String changeType = PlatformUtils.getStringValue(dataMap, (String)"changetype");
        convertDataMap.put("changeType", "B");
        if ("C".equals(changeType)) {
            convertDataMap.put("changeType", "A");
        }
        convertDataMap.put("materialmftid", dataMap.get("material"));
        convertDataMap.put("materialid", dataMap.get("materialmasterid"));
        convertDataMap.put("ecobillno", dataMap.get("ecochangebillno"));
        convertDataMap.put("qtynumerator", newfz);
        convertDataMap.put("qtydenominator", newfm);
        convertDataMap.put("qtytype", dataMap.get("entryqtytype"));
        convertDataMap.put("scraprate", dataMap.get("scraprate"));
        convertDataMap.put("fixscrap", dataMap.get("fixscrap"));
        convertDataMap.put("isjumplevel", dataMap.get("isjumplevel"));
        convertDataMap.put("bomentryid", dataMap.get("bomentryid"));
        convertDataMap.put("parentmaterial", dataMap.get("parentmaterial"));
        convertDataMap.put("childbomid", dataMap.get("childbomid"));
        convertDataMap.put("entryconfiguredcode", dataMap.get("configuredcode"));
        Long workStationId = PlatformUtils.getLongValue(dataMap, (String)"bomworkstation");
        Long workCenterId = PlatformUtils.getLongValue(dataMap, (String)"bomworkcenter");
        if (PlatformUtils.isNullLong((Long)workStationId) && PlatformUtils.isNullLong((Long)workCenterId)) {
            workCenterId = PlatformUtils.getLongValue(dataMap, (String)"workcenter");
        }
        convertDataMap.put("workcenterId", workCenterId);
        convertDataMap.put("workStationId", workStationId);
        convertDataMap.put("bomreversion", dataMap.get("bomchildversion"));
        convertDataMap.put("childauxpropertyid", dataMap.get("auxproperties"));
        convertDataMap.put("pstockentryid", dataMap.get("pstockentryid"));
        convertDataMap.put("ecobomentryid", dataMap.get("ecobomentryid"));
        convertDataMap.put("samebatchid", dataMap.get("samebatchid"));
        return convertDataMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> autoCreateStockChange(Set<Long> allChildBomIdSet, Set<Long> allEcoBillIdSet, Set<Long> allEcoBomEntryIdSet, String srcType) {
        HashMap<String, Object> allResultMap = new HashMap<String, Object>(16);
        this.setIsAddMutexLock(this.isWithLockMutex(srcType));
        this.initAddMutexLockCache();
        try {
            List<Map<String, Object>> gridDataList = this.genDiffStockData(allChildBomIdSet, allEcoBillIdSet, allEcoBomEntryIdSet, null);
            if (this.allMutexLockErrors.length() > 0) {
                allResultMap.put("errormsg", this.allMutexLockErrors.toString());
                HashMap<String, Object> hashMap = allResultMap;
                return hashMap;
            }
            int allSize = gridDataList.size();
            List<Object> listData = new ArrayList(allSize);
            listData = gridDataList;
            log.info("------GetEcoEffectOrderBusiness----autoCreateStockChange------listData.size = " + listData.size());
            List<List<Map<String, Object>>> splitList = this.splitEffectOrderData(listData);
            for (int i = 0; i < splitList.size(); ++i) {
                List<Map<String, Object>> subList = splitList.get(i);
                Map<String, Object> resultMap = new HashMap<String, Object>(16);
                AddEffectOrderBillBusiness addBusiness = new AddEffectOrderBillBusiness();
                List<Object> resultList = addBusiness.addData(subList, "A");
                if (resultList != null && !resultList.isEmpty()) {
                    try {
                        resultMap = addBusiness.genNextBillData(resultList, "A");
                        this.submitAndAuditXStock(resultMap);
                    }
                    catch (Exception e) {
                        log.error((Throwable)e);
                        addBusiness.deleteNextBillData(resultList);
                        resultMap.put("errormsg", e.getMessage());
                    }
                }
                this.mergeMap(allResultMap, resultMap);
            }
            allResultMap.put("allSize", allSize);
            HashMap<String, Object> hashMap = allResultMap;
            return hashMap;
        }
        finally {
            OrderMutexLockUtils.clearAllLocks(this.getAllMutexLockSuccessIds(), (String)"A");
            this.initAddMutexLockCache();
            this.setIsAddMutexLock(Boolean.FALSE);
        }
    }

    public void mergeMap(Map<String, Object> allResultMap, Map<String, Object> resultMap) {
        String errormsg = resultMap.get("errormsg") == null ? "" : resultMap.get("errormsg").toString();
        this.mergeMsgString(errormsg, allResultMap);
        List xstockids_pom2 = PlatformUtils.getPkIdsFromMap(resultMap, (String)"xstockids_pom");
        List xstockids_om2 = PlatformUtils.getPkIdsFromMap(resultMap, (String)"xstockids_om");
        List stockids_pom2 = PlatformUtils.getPkIdsFromMap(resultMap, (String)"stockids_pom");
        List stockids_om2 = PlatformUtils.getPkIdsFromMap(resultMap, (String)"stockids_om");
        int allSize2 = resultMap.get("allSize") == null ? 0 : Integer.parseInt(resultMap.get("allSize").toString());
        List xstockids_pom = PlatformUtils.getPkIdsFromMap(allResultMap, (String)"xstockids_pom");
        List xstockids_om = PlatformUtils.getPkIdsFromMap(allResultMap, (String)"xstockids_om");
        List stockids_pom = PlatformUtils.getPkIdsFromMap(allResultMap, (String)"stockids_pom");
        List stockids_om = PlatformUtils.getPkIdsFromMap(allResultMap, (String)"stockids_om");
        int allSize = allResultMap.get("allSize") == null ? 0 : Integer.parseInt(allResultMap.get("allSize").toString());
        List<Object> xstockids_pomAll = this.mergeList(xstockids_pom, xstockids_pom2);
        List<Object> xstockids_omAll = this.mergeList(xstockids_om, xstockids_om2);
        List<Object> stockids_pomAll = this.mergeList(stockids_pom, stockids_pom2);
        List<Object> stockids_omAll = this.mergeList(stockids_om, stockids_om2);
        allResultMap.put("xstockids_pom", xstockids_pomAll);
        allResultMap.put("xstockids_om", xstockids_omAll);
        allResultMap.put("stockids_pom", stockids_pomAll);
        allResultMap.put("stockids_om", stockids_omAll);
        int successSize = (xstockids_pomAll == null ? 0 : xstockids_pomAll.size()) + (xstockids_omAll == null ? 0 : xstockids_omAll.size()) + (stockids_pomAll == null ? 0 : stockids_pomAll.size()) + (stockids_omAll == null ? 0 : stockids_omAll.size());
        allResultMap.put("allSize", allSize += allSize2);
        allResultMap.put("successSize", successSize);
        allResultMap.put("unSuccessSize", allSize - successSize);
    }

    public Map<String, Set<Long>> getEffectAllData(Set<Long> ecoBomEntryIdSet, boolean isAll, boolean isShowUnAudit) {
        Set<Long> allEntryIdSet = ecoBomEntryIdSet;
        if (isAll) {
            allEntryIdSet = EcoUtils.getAllEcoBomEntryIdSet(ecoBomEntryIdSet);
        }
        if (allEntryIdSet == null || allEntryIdSet.isEmpty()) {
            return new HashMap<String, Set<Long>>(16);
        }
        HashSet<Long> childBomIdSet = new HashSet<Long>(16);
        HashSet<Long> ecoBillIdSet = new HashSet<Long>(16);
        HashSet<Long> allEcoBomEntryIdSet = new HashSet<Long>(16);
        SqlBuilder sb = new SqlBuilder();
        sb.append(" select", new Object[0]);
        sb.append(" h.fid ", new Object[0]);
        sb.append(",d2.fentryid as fecobomentryid ", new Object[0]);
        sb.append(",d.fbomid as fbomid ", new Object[0]);
        sb.append(" from t_pdm_bom_eco h ", new Object[0]);
        sb.append(" inner join t_pdm_bomecopentry d on h.fid = d.fid  ", new Object[0]);
        sb.append(" inner join t_fmm_ecobomentry d2 on d2.fid = d.fecobomid  ", new Object[0]);
        sb.append(" where  ", new Object[0]);
        sb.appendIn("d2.fentryid", allEntryIdSet.toArray());
        if (!isShowUnAudit) {
            sb.append(" and h.fbillstatus = 'C' ", new Object[0]);
        }
        sb.append(" and d.fentryversioncontrol = 'A'  ", new Object[0]);
        try (DataSet ds = DB.queryDataSet((String)this.getAlgoxKeyString("getRefEcoBomEntryData"), (DBRoute)scmDBRoute, (SqlBuilder)sb);){
            for (Row row : ds) {
                Long ecobillid = row.getLong("fid");
                Long fbomid = row.getLong("fbomid");
                Long fecobomentryid = row.getLong("fecobomentryid");
                childBomIdSet.add(fbomid);
                ecoBillIdSet.add(ecobillid);
                allEcoBomEntryIdSet.add(fecobomentryid);
            }
        }
        HashMap<String, Set<Long>> dataMap = new HashMap<String, Set<Long>>(16);
        dataMap.put("ecoBillIdSet", ecoBillIdSet);
        dataMap.put("childBomIdSet", childBomIdSet);
        dataMap.put("allEcoBomEntryIdSet", allEcoBomEntryIdSet);
        return dataMap;
    }

    public Map<String, Map<Long, Long>> getEcoBomEntryRefMap(Set<Long> ecoBomEntryIdSet) {
        if (ecoBomEntryIdSet == null || ecoBomEntryIdSet.isEmpty()) {
            return new HashMap<String, Map<Long, Long>>(16);
        }
        HashMap<Long, Long> bomIdMap = new HashMap<Long, Long>(16);
        HashMap<Long, Long> ecoIdMap = new HashMap<Long, Long>(16);
        HashMap<Long, Long> pentryIdMap = new HashMap<Long, Long>(16);
        SqlBuilder sb = new SqlBuilder();
        sb.append(" select", new Object[0]);
        sb.append(" h.fid ", new Object[0]);
        sb.append(",d.fentryid as fpentryid ", new Object[0]);
        sb.append(",d2.fentryid as fecobomentryid ", new Object[0]);
        sb.append(",d.fbomid as fbomid ", new Object[0]);
        sb.append(" from t_pdm_bom_eco h ", new Object[0]);
        sb.append(" inner join t_pdm_bomecopentry d on h.fid = d.fid  ", new Object[0]);
        sb.append(" inner join t_fmm_ecobomentry d2 on d2.fid = d.fecobomid  ", new Object[0]);
        sb.append(" where  ", new Object[0]);
        sb.appendIn("d2.fentryid", ecoBomEntryIdSet.toArray());
        sb.append(" and h.fbillstatus = 'C' ", new Object[0]);
        sb.append(" and d.fentryversioncontrol = 'A'  ", new Object[0]);
        try (DataSet ds = DB.queryDataSet((String)this.getAlgoxKeyString("getRefEcoBomEntryData"), (DBRoute)scmDBRoute, (SqlBuilder)sb);){
            for (Row row : ds) {
                Long ecobillid = row.getLong("fid");
                Long fbomid = row.getLong("fbomid");
                Long fecobomentryid = row.getLong("fecobomentryid");
                Long fpentryid = row.getLong("fpentryid");
                bomIdMap.put(fecobomentryid, fbomid);
                ecoIdMap.put(fecobomentryid, ecobillid);
                pentryIdMap.put(fecobomentryid, fpentryid);
            }
        }
        HashMap<String, Map<Long, Long>> dataMap = new HashMap<String, Map<Long, Long>>(16);
        dataMap.put("bomIdMap", bomIdMap);
        dataMap.put("ecoIdMap", ecoIdMap);
        dataMap.put("pentryIdMap", pentryIdMap);
        return dataMap;
    }

    private Map<String, Object> updateByAllData(Set<Long> ecoBomEntryIdSet, boolean isAll) {
        Map<String, Set<Long>> allData = this.getEffectAllData(ecoBomEntryIdSet, isAll, false);
        if (allData == null || allData.isEmpty()) {
            return new HashMap<String, Object>(16);
        }
        HashSet ecoBillIdSet = allData.get("ecoBillIdSet");
        HashSet childBomIdSet = allData.get("childBomIdSet");
        Set<Long> allEcoBomEntryIdSet = allData.get("allEcoBomEntryIdSet");
        if (childBomIdSet.size() == 1 && ecoBillIdSet.size() == 1) {
            return this.autoCreateStockChange(childBomIdSet, ecoBillIdSet, allEcoBomEntryIdSet, "updateByAllData");
        }
        List<List<Long>> splitList = this.splitEcoBomData(allEcoBomEntryIdSet);
        Map<String, Map<Long, Long>> refMap = this.getEcoBomEntryRefMap(allEcoBomEntryIdSet);
        List<List<Long>> loopList = this.splitEcoBomDataMerge(splitList, refMap);
        int size = loopList.size();
        HashMap<String, Object> allResultMap = new HashMap<String, Object>(16);
        for (int i = 0; i < size; ++i) {
            List<Long> batchList = loopList.get(i);
            Map<String, Set<Long>> aMap = this.getMapset(batchList, 0L, refMap);
            childBomIdSet = aMap.get("childBomIdSet") == null ? new HashSet(16) : (HashSet)aMap.get("childBomIdSet");
            ecoBillIdSet = aMap.get("ecoBillIdSet") == null ? new HashSet(16) : (HashSet)aMap.get("ecoBillIdSet");
            ecoBomEntryIdSet = aMap.get("ecoBomEntryIdSet") == null ? new HashSet(16) : (HashSet)aMap.get("ecoBomEntryIdSet");
            Map<String, Object> aResultMap = this.autoCreateStockChange(childBomIdSet, ecoBillIdSet, ecoBomEntryIdSet, "updateByAllData");
            this.mergeMap(allResultMap, aResultMap);
        }
        return allResultMap;
    }

    private String getSameKeys(Long oneEcoBomEntryId, Map<String, Map<Long, Long>> refMap) {
        Map<Long, Long> bomIdMap = refMap == null ? null : refMap.get("bomIdMap");
        Map<Long, Long> ecoIdMap = refMap == null ? null : refMap.get("ecoIdMap");
        Long bomId = bomIdMap == null || bomIdMap.isEmpty() ? Long.valueOf(0L) : bomIdMap.get(oneEcoBomEntryId);
        Long ecoId = ecoIdMap == null || ecoIdMap.isEmpty() ? Long.valueOf(0L) : ecoIdMap.get(oneEcoBomEntryId);
        return PlatformUtils.getUnionString((Object)ecoId, (Object)bomId);
    }

    private Map<String, Set<Long>> getMapset(List<Long> batchList, Long oneEcoBomEntryId, Map<String, Map<Long, Long>> refMap) {
        Map<Long, Long> ecoIdMap;
        HashMap<String, Set<Long>> aMap = new HashMap<String, Set<Long>>(16);
        HashSet<Long> childBomIdSet = new HashSet<Long>(16);
        HashSet<Long> ecoBillIdSet = new HashSet<Long>(16);
        HashSet<Long> ecoBomEntryIdSet = new HashSet<Long>(16);
        Map<Long, Long> bomIdMap = refMap == null ? null : refMap.get("bomIdMap");
        Map<Long, Long> map = ecoIdMap = refMap == null ? null : refMap.get("ecoIdMap");
        if (PlatformUtils.isNullList(batchList)) {
            Long bomId = 0L;
            Long ecoId = 0L;
            if (bomIdMap != null && !bomIdMap.isEmpty()) {
                bomId = bomIdMap.get(oneEcoBomEntryId);
            }
            if (ecoIdMap != null && !ecoIdMap.isEmpty()) {
                ecoId = ecoIdMap.get(oneEcoBomEntryId);
            }
            if (!PlatformUtils.isNullLong((Long)oneEcoBomEntryId)) {
                ecoBomEntryIdSet.add(oneEcoBomEntryId);
            }
            if (!PlatformUtils.isNullLong((Long)bomId)) {
                childBomIdSet.add(bomId);
            }
            if (!PlatformUtils.isNullLong((Long)ecoId)) {
                ecoBillIdSet.add(ecoId);
            }
        } else {
            for (int i = 0; i < batchList.size(); ++i) {
                Long ecoBomEntryId = batchList.get(i);
                Long bomId = 0L;
                Long ecoId = 0L;
                if (bomIdMap != null && !bomIdMap.isEmpty()) {
                    bomId = bomIdMap.get(ecoBomEntryId);
                }
                if (ecoIdMap != null && !ecoIdMap.isEmpty()) {
                    ecoId = ecoIdMap.get(ecoBomEntryId);
                }
                if (!PlatformUtils.isNullLong((Long)ecoBomEntryId)) {
                    ecoBomEntryIdSet.add(ecoBomEntryId);
                }
                if (!PlatformUtils.isNullLong((Long)bomId)) {
                    childBomIdSet.add(bomId);
                }
                if (PlatformUtils.isNullLong((Long)ecoId)) continue;
                ecoBillIdSet.add(ecoId);
            }
        }
        aMap.put("childBomIdSet", childBomIdSet);
        aMap.put("ecoBillIdSet", ecoBillIdSet);
        aMap.put("ecoBomEntryIdSet", ecoBomEntryIdSet);
        return aMap;
    }

    public Map<String, Object> createStockChangeByPentryId(Set<Long> pentryIdSet) {
        if (pentryIdSet.isEmpty()) {
            return new HashMap<String, Object>(16);
        }
        SqlBuilder sb = new SqlBuilder();
        sb.append(" select", new Object[0]);
        sb.append(" h.fid ", new Object[0]);
        sb.append(",d2.fentryid as fecobomentryid ", new Object[0]);
        sb.append(",d.fbomid as fbomid ", new Object[0]);
        sb.append(",h.fauditdate as fauditdate ", new Object[0]);
        sb.append(",d2.facttime as facttime ", new Object[0]);
        sb.append(",d.fseq as fpseq ", new Object[0]);
        sb.append(" from t_pdm_bom_eco h ", new Object[0]);
        sb.append(" inner join t_pdm_bomecopentry d on h.fid = d.fid  ", new Object[0]);
        sb.append(" inner join t_fmm_ecobomentry d2 on d2.fid = d.fecobomid  ", new Object[0]);
        sb.append(" where  ", new Object[0]);
        sb.appendIn("d.fentryid", pentryIdSet.toArray());
        sb.append(" and d.fentryversioncontrol = 'A'  ", new Object[0]);
        HashMap splitMap = new HashMap(16);
        ArrayList<String> sortKetList = new ArrayList<String>(16);
        try (DataSet ds = DB.queryDataSet((String)this.getAlgoxKeyString("createStockChangeByPentryId"), (DBRoute)scmDBRoute, (SqlBuilder)sb).orderBy(new String[]{"facttime", "fauditdate", "fid", "fpseq"});){
            for (Row row : ds) {
                Long ecobillid = row.getLong("fid");
                Long childBomId = row.getLong("fbomid");
                Long fecobomentryid = row.getLong("fecobomentryid");
                String keyString = String.valueOf(childBomId);
                HashMap<String, HashSet> aMap = (HashMap<String, HashSet>)splitMap.get(keyString);
                if (aMap == null) {
                    aMap = new HashMap<String, HashSet>(16);
                }
                HashSet childBomIdSet = aMap.get("childBomIdSet") == null ? new HashSet(16) : (HashSet)aMap.get("childBomIdSet");
                HashSet ecoBillIdSet = aMap.get("ecoBillIdSet") == null ? new HashSet(16) : (HashSet)aMap.get("ecoBillIdSet");
                HashSet ecoBomEntryIdSet = aMap.get("ecoBomEntryIdSet") == null ? new HashSet(16) : (HashSet)aMap.get("ecoBomEntryIdSet");
                childBomIdSet.add(childBomId);
                ecoBillIdSet.add(ecobillid);
                ecoBomEntryIdSet.add(fecobomentryid);
                aMap.put("childBomIdSet", childBomIdSet);
                aMap.put("ecoBillIdSet", ecoBillIdSet);
                aMap.put("ecoBomEntryIdSet", ecoBomEntryIdSet);
                splitMap.put(keyString, aMap);
                if (sortKetList.contains(keyString)) continue;
                sortKetList.add(keyString);
            }
        }
        HashMap<String, Object> allResultMap = new HashMap<String, Object>(16);
        for (int i = 0; i < sortKetList.size(); ++i) {
            String keyString = (String)sortKetList.get(i);
            Map aMap = (Map)splitMap.get(keyString);
            HashSet childBomIdSet = aMap.get("childBomIdSet") == null ? new HashSet(16) : (HashSet)aMap.get("childBomIdSet");
            HashSet ecoBillIdSet = aMap.get("ecoBillIdSet") == null ? new HashSet(16) : (HashSet)aMap.get("ecoBillIdSet");
            HashSet ecoBomEntryIdSet = aMap.get("ecoBomEntryIdSet") == null ? new HashSet(16) : (HashSet)aMap.get("ecoBomEntryIdSet");
            Map<String, Object> aResultMap = this.autoCreateStockChange(childBomIdSet, ecoBillIdSet, ecoBomEntryIdSet, "createStockChangeByPentryId");
            this.mergeMap(allResultMap, aResultMap);
        }
        return allResultMap;
    }

    public Map<String, Object> createStockChangeByKey(Set<Long> ecoBomEntryIdSet, boolean isAll) {
        if (ecoBomEntryIdSet.isEmpty()) {
            return new HashMap<String, Object>(16);
        }
        return this.updateByAllData(ecoBomEntryIdSet, isAll);
    }

    public Map<String, Object> createStockChangeLoop(List<Long> ecoBomEntryIdList) {
        if (ecoBomEntryIdList.isEmpty()) {
            return new HashMap<String, Object>(16);
        }
        int size = ecoBomEntryIdList.size();
        HashMap<String, Object> allResultMap = new HashMap<String, Object>(16);
        Map<String, Map<Long, Long>> refMap = this.getEcoBomEntryRefMap(new HashSet<Long>(ecoBomEntryIdList));
        HashMap<String, ArrayList<Long>> groupMap = new HashMap<String, ArrayList<Long>>(16);
        ArrayList<String> sortList = new ArrayList<String>(16);
        for (int i = 0; i < size; ++i) {
            Long ecoBomEntryId = ecoBomEntryIdList.get(i);
            String oneKeys = this.getSameKeys(ecoBomEntryId, refMap);
            ArrayList<Long> gList = (ArrayList<Long>)groupMap.get(oneKeys);
            if (gList == null) {
                gList = new ArrayList<Long>(16);
            }
            gList.add(ecoBomEntryId);
            groupMap.put(oneKeys, gList);
            if (sortList.contains(oneKeys)) continue;
            sortList.add(oneKeys);
        }
        for (String oneKeys : sortList) {
            List subList = (List)groupMap.get(oneKeys);
            Map<String, Set<Long>> aMap = this.getMapset(subList, 0L, refMap);
            HashSet childBomIdSet = aMap.get("childBomIdSet") == null ? new HashSet(16) : (HashSet)aMap.get("childBomIdSet");
            HashSet ecoBillIdSet = aMap.get("ecoBillIdSet") == null ? new HashSet(16) : (HashSet)aMap.get("ecoBillIdSet");
            HashSet ecoBomEntryIdSet = aMap.get("ecoBomEntryIdSet") == null ? new HashSet(16) : (HashSet)aMap.get("ecoBomEntryIdSet");
            Map<String, Object> aResultMap = this.autoCreateStockChange(childBomIdSet, ecoBillIdSet, ecoBomEntryIdSet, "createStockChangeLoop");
            this.mergeMap(allResultMap, aResultMap);
        }
        return allResultMap;
    }

    private boolean isCharaRuleno(Map<Long, Boolean> cacheMap, Long bomentryId) {
        return cacheMap.containsKey(bomentryId);
    }

    private void initCharaRuleno(Set<Long> bomentryIdSet, Set<Long> bomIdSet, Map<Long, Boolean> cacheMap) {
        Throwable throwable;
        SqlBuilder sb;
        long startTime;
        if (!bomIdSet.isEmpty()) {
            startTime = System.currentTimeMillis();
            sb = new SqlBuilder();
            sb.append(" select d.fentryid as fbomentryid ", new Object[0]);
            sb.append(" from t_pdm_mftbomentry d ", new Object[0]);
            sb.append(" where ", new Object[0]);
            sb.appendIn("d.fid", bomIdSet.toArray());
            sb.append(" and exists(Select 1 from t_pdm_superbomchrulentry a where a.fentryid = d.fentryid and a.fchararuleid > 0) ", new Object[0]);
            throwable = null;
            try (DataSet ds = DB.queryDataSet((String)this.getAlgoxKeyString("initCharaRuleno"), (DBRoute)scmDBRoute, (SqlBuilder)sb);){
                for (Row row : ds) {
                    cacheMap.put(row.getLong("fbomentryid"), Boolean.TRUE);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            long enddate = System.currentTimeMillis() - startTime;
            log.info("initCharaRuleno1,cost:" + enddate + "ms,bomIdSet.size=" + bomIdSet.size());
        }
        if (!bomentryIdSet.isEmpty()) {
            startTime = System.currentTimeMillis();
            sb = new SqlBuilder();
            sb.append(" select fentryid as fbomentryid ", new Object[0]);
            sb.append(" from t_pdm_superbomchrulentry ", new Object[0]);
            sb.append(" where ", new Object[0]);
            sb.appendIn(" fentryid", bomentryIdSet.toArray());
            sb.append(" and fchararuleid > 0 ", new Object[0]);
            throwable = null;
            try (DataSet ds = DB.queryDataSet((String)this.getAlgoxKeyString("initCharaRuleno"), (DBRoute)scmDBRoute, (SqlBuilder)sb);){
                for (Row row : ds) {
                    cacheMap.put(row.getLong("fbomentryid"), Boolean.TRUE);
                }
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            long enddate = System.currentTimeMillis() - startTime;
            log.info("initCharaRuleno2,cost:" + enddate + "ms,bomentryIdSet.size=" + bomentryIdSet.size());
        }
    }

    private List<DynamicObject> initMftBomEntryFeatureData(DynamicObject bomentry, Map<String, Object> refStockDataMap, Map<String, String> bomResultCacheMap, Date expandBomDate, DynamicObject childBom, Map<Long, Boolean> charaRuleMap, DynamicObject bomentryBefore) {
        ArrayList<DynamicObject> bomentryList = new ArrayList<DynamicObject>(16);
        if (!"B".equals(bomentry.getString("entrytype"))) {
            boolean existCharaRulenoA = this.isCharaRuleno(charaRuleMap, bomentry.getLong("id"));
            boolean existCharaRulenoB = false;
            if (bomentryBefore != null) {
                existCharaRulenoB = this.isCharaRuleno(charaRuleMap, bomentryBefore.getLong("id"));
            }
            if (!existCharaRulenoA && !existCharaRulenoB) {
                bomentryList.add(bomentry);
                return bomentryList;
            }
        }
        Long initBomEntryId = bomentry.getLong("entryid");
        List<BomBaseData> bbdList = null;
        Long transactionType = this.getLongValue(refStockDataMap, "transactiontypeid");
        Long configeCodeId = this.getLongValue(refStockDataMap, "configuredcode");
        Long productMaterialMasterId = this.getLongValue(refStockDataMap, "productmasterid");
        Long routingId = this.getLongValue(refStockDataMap, "processroute");
        String orderNo = this.getStringValue(refStockDataMap, "orderno");
        if (this.isConfigBomInterface(transactionType, productMaterialMasterId, configeCodeId)) {
            log.info("getAddDataStock,initMftBomEntryFeatureData,isConfigBomInterface");
            Long productOrgId = this.getLongValue(refStockDataMap, "org");
            JSONObject configCodeJs = new JSONObject();
            configCodeJs.put(String.valueOf(configeCodeId), (Object)String.valueOf(routingId));
            BigDecimal qty = this.getBigDecimalValue(refStockDataMap, "qty");
            bbdList = this.expandConfigBom(configCodeJs, productMaterialMasterId, expandBomDate, qty, bomResultCacheMap, productMaterialMasterId, productOrgId, false);
            if (this.isShowDetialLog()) {
                LogUtils.genLogs55(this.logs, configeCodeId, productMaterialMasterId, transactionType, qty, routingId, bbdList, productOrgId, expandBomDate, "initMftBomEntryFeatureData");
            }
            if (!PlatformUtils.isNullList(bbdList)) {
                int size = bbdList.size();
                for (int i = 0; i < size; ++i) {
                    BomBaseData bbd = bbdList.get(i);
                    Long bomEntryId = bbd.getBomEntryId();
                    if (!bomEntryId.equals(initBomEntryId)) continue;
                    Long materialMasterId = bbd.getMaterilID();
                    DynamicObject mft = this.getMateriaMftDynamicObject(productOrgId, materialMasterId);
                    DynamicObject splitBomentry = PlatformUtils.copyDynamicObject((DynamicObject)bomentry);
                    this.reSetBomEntryMaterial(splitBomentry, mft, materialMasterId);
                    bomentryList.add(splitBomentry);
                }
            }
        } else {
            if (this.isShowDetialLog()) {
                LogUtils.genLogs9(this.logs, refStockDataMap);
            }
            log.error("getAddDataStock,initMftBomEntryFeatureData,orderNo = " + orderNo + ",is not ConfigBomInterface,data error ");
        }
        if (!bomentryList.isEmpty()) {
            for (int i = 0; i < bomentryList.size(); ++i) {
                DynamicObject cb = (DynamicObject)bomentryList.get(i);
                Long materialMftId = this.getLongId(cb, "entrymaterial");
                Long materialId = this.getLongId(cb, "entrymaterialid");
                if (!PlatformUtils.isNullLong((Long)materialMftId) && !PlatformUtils.isNullLong((Long)materialId)) continue;
                log.info("getAddDataStock,initMftBomEntryFeatureData,material is null,not find");
                log.info("getAddDataStock,initMftBomEntryFeatureData,materialmft=" + cb.get("entrymaterial"));
                log.info("getAddDataStock,initMftBomEntryFeatureData,materialid=" + cb.get("entrymaterialid"));
                throw new KDBizException(new ErrorCode("initMftBomEntryFeatureData", String.format(ResManager.loadKDString((String)"BOM\u201c%1$s\u201d\u4e0b\u7684\u7ec4\u4ef6\u5206\u5f55\u5e8f\u53f7\u201c%2$s\u201d\u4e3a\u9009\u9879\u4ef6\uff0c\u5728\u5de5\u5355\u201c%3$s\u201d\u4e0b\u65e0\u6cd5\u5339\u914d\u5230\u51c6\u786e\u7684\u7269\u6599\u4fe1\u606f\u53ca\u7269\u6599\u751f\u4ea7\u4fe1\u606f\u3002", (String)"GetEcoEffectOrderBusiness_17", (String)"mmc-pdm-business", (Object[])new Object[0]), childBom.getString("number"), cb.get("entryseq"), orderNo)), new Object[0]);
            }
        }
        if (this.isShowDetialLog()) {
            LogUtils.genLogs10(this.logs, bomentryList, bomentry);
        }
        return bomentryList;
    }

    private void reSetBomEntryMaterial(DynamicObject bomentry, DynamicObject mft, Long matserid) {
        bomentry.set("entrymaterial", (Object)mft.getLong("id"));
        bomentry.set("entrymaterialid", (Object)matserid);
        bomentry.set("entrymaterialattr", (Object)mft.getString("materialattr"));
        bomentry.set("entryunit", (Object)mft.getDynamicObject("mftunit").getLong("id"));
    }

    private List<Long> transIdQFilter(QFilter oldQFilter, String entityName) {
        long startTime = System.currentTimeMillis();
        String selectProperties = "id,stockentry.id entryid,stockentry.childbomid childbomid";
        String[] groups = new String[]{"id", "childbomid"};
        ArrayList<Long> entryIdList = new ArrayList<Long>(64);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoxKeyString("transIdQFilter"), (String)entityName, (String)selectProperties, (QFilter[])new QFilter[]{oldQFilter}, (String)"").groupBy(groups).max("entryid").finish();){
            while (dataSet.hasNext()) {
                Row arow = dataSet.next();
                entryIdList.add(arow.getLong("entryid"));
            }
        }
        long enddate = System.currentTimeMillis() - startTime;
        log.info("getPomMftStockDataSet,cost:" + enddate + "ms,entryIdList.size=" + entryIdList.size());
        return entryIdList;
    }

    public Map<String, Object> submitAndAuditXStock(Map<String, Object> resultMap) {
        if (!this.isAutoSubmit()) {
            return resultMap;
        }
        List savePomSuccessPkIds = PlatformUtils.getPkIdsFromMap(resultMap, (String)"xstockids_pom");
        List saveOmSuccessPkIds = PlatformUtils.getPkIdsFromMap(resultMap, (String)"xstockids_om");
        Map<String, Object> pomMap = this.submitAndAuditXBill(savePomSuccessPkIds, "pom_xmftstock");
        this.setReturnMap(resultMap, pomMap);
        Map<String, Object> omMap = this.submitAndAuditXBill(saveOmSuccessPkIds, "om_xmftstock");
        this.setReturnMap(resultMap, omMap);
        return resultMap;
    }

    private void getChilidBomMap(Set<Long> childBomIdSet, QFilter otherFilter, DynamicObject filterObj, Map<Long, Set<Long>> childMap) {
        if (PlatformUtils.isNullSet(childBomIdSet)) {
            return;
        }
        HashMap<Long, Set<Long>> bomMap = new HashMap<Long, Set<Long>>(childBomIdSet.size());
        for (Long childbomid : childBomIdSet) {
            this.addLongDataToMap(childMap, childbomid, childbomid);
        }
        String selectProperties = "stockentry.childbomid as childbomid,bomid as bomid";
        QFilter qFilter = new QFilter("stockentry.childbomid", "in", childBomIdSet);
        if (otherFilter != null) {
            qFilter.and(otherFilter);
        }
        long startTime = System.currentTimeMillis();
        qFilter.and(this.getCommonQuery(filterObj));
        String[] groups = new String[]{"bomid", "childbomid"};
        String stockEntityNumber = (String)filterObj.getDynamicObject("objectentity").getPkValue();
        try (DataSet omMftstockDataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoxKeyString("getChilidBomMap"), (String)stockEntityNumber, (String)selectProperties, (QFilter[])new QFilter[]{qFilter}, (String)"").groupBy(groups).finish();){
            while (omMftstockDataSet.hasNext()) {
                Row arow = omMftstockDataSet.next();
                Long bomId = arow.getLong("bomid");
                Long childbomid = arow.getLong("childbomid");
                this.addLongDataToMap(bomMap, bomId, childbomid);
            }
        }
        long enddate = System.currentTimeMillis() - startTime;
        log.info("getChilidBomMap,getStockDatacost:" + enddate + "ms,qFilter=" + qFilter.toString() + ",stockEntityNumber=" + stockEntityNumber);
    }

    private boolean isUnionSet(Set<Long> setA, Set<Long> setB) {
        HashSet<Long> resSet = new HashSet<Long>(16);
        resSet.addAll(setA);
        resSet.retainAll(setB);
        return !resSet.isEmpty();
    }

    public Date getMinActTime(Set<Long> allEcoBomEntryIdSet) {
        Date minDate = null;
        SqlBuilder sb = new SqlBuilder();
        sb.append(" select", new Object[0]);
        sb.append(" facttime ", new Object[0]);
        sb.append(" from t_fmm_ecobomentry a ", new Object[0]);
        sb.append(" where  ", new Object[0]);
        sb.appendIn("a.fentryid", allEcoBomEntryIdSet.toArray());
        try (DataSet ds = DB.queryDataSet((String)(GetEcoEffectOrderBusiness.class.getName() + "_getMinActTime"), (DBRoute)scmDBRoute, (SqlBuilder)sb);){
            for (Row row : ds) {
                Date acttime = row.getDate("facttime");
                if (minDate != null && !minDate.after(acttime)) continue;
                minDate = acttime;
            }
        }
        return minDate;
    }

    public Map<String, Object> getBomIdSetByEco(Set<Long> allEcoBomEntryIdSet) {
        Date minDate = null;
        Date maxDate = null;
        HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
        HashSet<Long> bomIdset = new HashSet<Long>(16);
        HashSet<Long> pentryIdSet = new HashSet<Long>(16);
        ArrayList<Long> sortEcoBomEntryIdList = new ArrayList<Long>(allEcoBomEntryIdSet.size());
        try (DataSet ds = this.getSortEcoBomData(allEcoBomEntryIdSet);){
            for (Row row : ds) {
                Date acttime = row.getDate("facttime");
                if (minDate == null || minDate.after(acttime)) {
                    minDate = acttime;
                }
                if (maxDate == null || maxDate.before(acttime)) {
                    maxDate = acttime;
                }
                bomIdset.add(row.getLong("fbomid"));
                sortEcoBomEntryIdList.add(row.getLong("fecobomentryid"));
                pentryIdSet.add(row.getLong("fpentryid"));
            }
        }
        dataMap.put("pentryIdSet", pentryIdSet);
        dataMap.put("minacttime", minDate);
        dataMap.put("maxacttime", maxDate);
        dataMap.put("bomidset", bomIdset);
        dataMap.put("sortecobomentryidlist", sortEcoBomEntryIdList);
        return dataMap;
    }

    public String getKeyString(Set<Long> set) {
        TreeSet<Long> ts = new TreeSet<Long>(set);
        ts.comparator();
        StringBuilder sb = new StringBuilder();
        for (Long id : ts) {
            sb.append(id).append("_");
        }
        return sb.toString();
    }

    public Map<Long, Integer> initBomSetGroup(Map<Long, Set<Long>> childMap) {
        HashMap<Long, Integer> keyMap = new HashMap<Long, Integer>(childMap.size());
        for (Map.Entry<Long, Set<Long>> entrys : childMap.entrySet()) {
            Long childBomIdA = entrys.getKey();
            Set<Long> parentBomSetA = entrys.getValue();
            for (Map.Entry<Long, Set<Long>> entrys2 : childMap.entrySet()) {
                Set<Long> parentBomSetB;
                Long childBomIdB = entrys2.getKey();
                if (childBomIdB.equals(childBomIdA) || !this.isUnionSet(parentBomSetA, parentBomSetB = entrys2.getValue())) continue;
                parentBomSetA.addAll(parentBomSetB);
            }
        }
        for (Map.Entry<Long, Set<Long>> entrys : childMap.entrySet()) {
            Long childBomId = entrys.getKey();
            Set<Long> parentBomSet = entrys.getValue();
            String keyString = this.getKeyString(parentBomSet);
            keyMap.put(childBomId, keyString.hashCode());
            log.info("----GetEcoEffectOrderBusiness-----initBomSetGroup--------childBomId:" + childBomId + ",keyString=" + keyString);
        }
        return keyMap;
    }

    public List<DynamicObject> getFeatureMaterialBomEntryList(Map<String, List<DynamicObject>> cacheMap, DynamicObject bomentry, Map<String, Object> stockDataMap, Map<String, String> bomResultCacheMap, Date expandBomDate, DynamicObject childBom, Map<Long, Boolean> charaRuleMap, DynamicObject bomentryBefore, Long materialId) {
        if (!PlatformUtils.isNullLong((Long)materialId)) {
            ArrayList<DynamicObject> bomEntryList = new ArrayList<DynamicObject>(16);
            Long productOrgId = this.getLongValue(stockDataMap, "org");
            DynamicObject mft = this.getMateriaMftDynamicObject(productOrgId, materialId);
            this.reSetBomEntryMaterial(bomentry, mft, materialId);
            bomEntryList.add(bomentry);
            return bomEntryList;
        }
        Long stockId = this.getLongValue(stockDataMap, "id");
        String orderType = this.getStringValue(stockDataMap, "ordertype");
        String keyString = this.getUnionString(this.getUnionString(bomentry.getLong("entryid"), stockId), orderType);
        List<DynamicObject> bomEntryList = cacheMap.get(keyString);
        if (bomEntryList == null) {
            bomEntryList = this.initMftBomEntryFeatureData(bomentry, stockDataMap, bomResultCacheMap, expandBomDate, childBom, charaRuleMap, bomentryBefore);
            if (bomEntryList == null) {
                bomEntryList = new ArrayList<DynamicObject>(16);
            }
            cacheMap.put(keyString, bomEntryList);
        }
        return bomEntryList;
    }

    public Set<Long> getBomEntryFeatureMaterialSet(List<DynamicObject> bomEntryList) {
        HashSet<Long> materialIdSet = new HashSet<Long>(bomEntryList.size());
        for (DynamicObject bomentry : bomEntryList) {
            materialIdSet.add(this.getLongId(bomentry, "entrymaterialid"));
        }
        return materialIdSet;
    }

    public List<Map<String, Object>> filterStockListByMaterial(List<Map<String, Object>> stockDataList, Long materialMasterId, boolean isMulMaterial) {
        if (!isMulMaterial || PlatformUtils.isNullList(stockDataList)) {
            return stockDataList;
        }
        int size = stockDataList.size();
        ArrayList<Map<String, Object>> filterList = new ArrayList<Map<String, Object>>(size);
        for (int i = 0; i < size; ++i) {
            Map<String, Object> stockDataMap = stockDataList.get(i);
            Long stockMaterialMasterId = this.getLongValue(stockDataMap, "stockentry.materielmasterid");
            if (!stockMaterialMasterId.equals(materialMasterId)) continue;
            filterList.add(stockDataMap);
        }
        return filterList;
    }

    public boolean isConvertXN(Map<String, Object> stockDataMap, DynamicObject ecoBomEntry, DynamicObject ecoBomEntryAfter) {
        boolean isJumpLevel = this.getBooleanValue(stockDataMap, "stockentry.isjumplevel");
        if (isJumpLevel) {
            return isJumpLevel;
        }
        boolean isJumpLevel2 = ecoBomEntryAfter.getBoolean("entryisjumplevel");
        return isJumpLevel2;
    }

    public boolean isConvertUnXN(DynamicObject ecoBomEntry, DynamicObject ecoBomEntryAfter) {
        boolean isJumpLevel = ecoBomEntry.getBoolean("entryisjumplevel");
        boolean isJumpLevel2 = ecoBomEntryAfter.getBoolean("entryisjumplevel");
        return isJumpLevel && !isJumpLevel2;
    }

    public boolean needExpandBom(DynamicObject bomEntryBefore, DynamicObject bomEntryAfter, Map<Long, Boolean> charaRuleMap) {
        String entryType = bomEntryBefore.getString("entrytype");
        if ("B".equals(entryType)) {
            return true;
        }
        Long bomentryId = bomEntryBefore.getLong("entryid");
        if (this.isCharaRuleno(charaRuleMap, bomentryId)) {
            return true;
        }
        if (bomEntryAfter != null) {
            bomentryId = bomEntryAfter.getLong("entryid");
            if (this.isCharaRuleno(charaRuleMap, bomentryId)) {
                return true;
            }
            if (bomEntryAfter.getBoolean("entryisjumplevel")) {
                return true;
            }
        }
        return false;
    }

    public Set<Long> getPStockEntryIdSet(List<Map<String, Object>> stockDataList) {
        HashSet<Long> pstockEntryIdSet = new HashSet<Long>(16);
        int size = stockDataList.size();
        for (int i = 0; i < size; ++i) {
            Map<String, Object> stockDataMap = stockDataList.get(i);
            Long pstockEntryId = this.getLongValue(stockDataMap, "stockentry.pstockentryid");
            pstockEntryIdSet.add(pstockEntryId);
        }
        return pstockEntryIdSet;
    }

    public boolean isConfigBom(Map<String, Object> stockDataMap) {
        Long transactionType = this.getLongValue(stockDataMap, "transactiontypeid");
        Long configeCodeId = this.getLongValue(stockDataMap, "configuredcode");
        Long productMaterialMasterId = this.getLongValue(stockDataMap, "productmasterid");
        return this.isConfigBomInterface(transactionType, productMaterialMasterId, configeCodeId);
    }

    public List<BomBaseData> getBomExpandBbdList(boolean isConfigBom, Map<String, Object> stockDataMap, Date expandBomDate, Map<String, String> bomResultCacheMap, DynamicObject bomentry, Long pMaterialMasterId, boolean includeParent) {
        List<BomBaseData> bbdList = null;
        Long routingId = this.getLongValue(stockDataMap, "processroute");
        Long configeCodeId = this.getLongValue(stockDataMap, "configuredcode");
        BigDecimal qty = this.getBigDecimalValue(stockDataMap, "qty");
        Long transactionType = this.getLongValue(stockDataMap, "transactiontypeid");
        log.info("getAddDataStock,isNewBomExpandInterface");
        Long bomId = this.getLongValue(stockDataMap, "bomid");
        Long productOrgId = this.getLongValue(stockDataMap, "org");
        Long materialMasterId = this.getLongValue(stockDataMap, "productmasterid");
        if (bomentry != null && PlatformUtils.isNullLong((Long)pMaterialMasterId)) {
            pMaterialMasterId = this.getLongId(bomentry, "entrymaterialid");
        }
        bbdList = this.expandMulTypeBom(bomId, productOrgId, qty, expandBomDate, "E", routingId, materialMasterId, configeCodeId, transactionType, pMaterialMasterId, bomResultCacheMap);
        if (this.isShowDetialLog()) {
            LogUtils.genLogs17(this.logs, configeCodeId, materialMasterId, transactionType, qty, routingId, bbdList, productOrgId, pMaterialMasterId, includeParent, expandBomDate, bomId);
        }
        return bbdList;
    }

    public void resetRemark(List<Map<String, Object>> stockDataList, String addRemark) {
        int size = stockDataList.size();
        for (int i = 0; i < size; ++i) {
            Map<String, Object> stockDataMap = stockDataList.get(i);
            String remark = this.getStringValue(stockDataMap, "remark");
            stockDataMap.put("remark", addRemark + " " + remark);
        }
    }

    private DataSet getSortEcoBomData(Set<Long> ecoBomEntryIdSet) {
        SqlBuilder sb = new SqlBuilder();
        sb.append(" select", new Object[0]);
        sb.append(" h.fid ", new Object[0]);
        sb.append(",d.fid as fpentryid ", new Object[0]);
        sb.append(",d2.fentryid as fecobomentryid ", new Object[0]);
        sb.append(",d.fbomid as fbomid ", new Object[0]);
        sb.append(",h.fauditdate as fauditdate ", new Object[0]);
        sb.append(",d2.facttime as facttime ", new Object[0]);
        sb.append(",d.fseq as fpseq ", new Object[0]);
        sb.append(" from t_pdm_bom_eco h ", new Object[0]);
        sb.append(" inner join t_pdm_bomecopentry d on h.fid = d.fid  ", new Object[0]);
        sb.append(" inner join t_fmm_ecobomentry d2 on d2.fid = d.fecobomid  ", new Object[0]);
        sb.append(" where  ", new Object[0]);
        sb.appendIn("d2.fentryid", ecoBomEntryIdSet.toArray());
        return DB.queryDataSet((String)this.getAlgoxKeyString("splitEcoBomData"), (DBRoute)scmDBRoute, (SqlBuilder)sb).orderBy(new String[]{"facttime", "fauditdate", "fid", "fpseq"});
    }

    public List<List<Long>> splitEcoBomData(Set<Long> ecoBomEntryIdSet) {
        ArrayList<List<Long>> splitList = new ArrayList<List<Long>>(16);
        if (ecoBomEntryIdSet.isEmpty()) {
            return splitList;
        }
        boolean effectOrderLoopMode = PdmParamSetHelper.getBooleanParamValue((String)"ECN_EffectOrderLoopMode");
        if (!effectOrderLoopMode || ecoBomEntryIdSet.size() == 1) {
            splitList.add(new ArrayList<Long>(ecoBomEntryIdSet));
            return splitList;
        }
        Map<String, Object> bomMap = this.getBomIdSetByEco(ecoBomEntryIdSet);
        HashSet childBomIdSet = (HashSet)bomMap.get("bomidset");
        if (log.isInfoEnabled()) {
            log.info("----GetEcoEffectOrderBusiness-----splitEcoBomData--------ecoBomEntryIdSet.size:" + ecoBomEntryIdSet.size() + ",childBomIdSet.size =" + childBomIdSet.size());
        }
        if (childBomIdSet.size() == 1) {
            ArrayList sortEcoBomEntryIdList = (ArrayList)bomMap.get("sortecobomentryidlist");
            splitList.add(sortEcoBomEntryIdList);
            return splitList;
        }
        Map<Object, DynamicObject> filterMap = this.getEcoFilterMap("A");
        if (filterMap == null || filterMap.isEmpty()) {
            return splitList;
        }
        HashMap<Long, Set<Long>> childMap = new HashMap<Long, Set<Long>>(16);
        for (Map.Entry<Object, DynamicObject> filters : filterMap.entrySet()) {
            DynamicObject filterObj = filters.getValue();
            this.getChilidBomMap(childBomIdSet, null, filterObj, childMap);
        }
        if (log.isInfoEnabled()) {
            log.info("----GetEcoEffectOrderBusiness-----splitEcoBomData--------childMap.size:" + childMap.size());
        }
        Map<Long, Integer> bomKeyMap = this.initBomSetGroup(childMap);
        HashMap<Integer, ArrayList<Long>> splitMap = new HashMap<Integer, ArrayList<Long>>(16);
        try (DataSet ds = this.getSortEcoBomData(ecoBomEntryIdSet);){
            for (Row row : ds) {
                ArrayList<Long> aList;
                Long childBomId = row.getLong("fbomid");
                Long fecobomentryid = row.getLong("fecobomentryid");
                int keyHashCode = bomKeyMap.get(childBomId);
                if (keyHashCode == 0) {
                    keyHashCode = String.valueOf(childBomId).hashCode();
                }
                if ((aList = (ArrayList<Long>)splitMap.get(keyHashCode)) == null) {
                    aList = new ArrayList<Long>(16);
                }
                aList.add(fecobomentryid);
                splitMap.put(keyHashCode, aList);
            }
        }
        for (Map.Entry entrys : splitMap.entrySet()) {
            splitList.add((List<Long>)entrys.getValue());
        }
        return splitList;
    }

    public List<List<Long>> splitEcoBomDataMerge(List<List<Long>> splitList, Map<String, Map<Long, Long>> refMap) {
        if (PlatformUtils.isNullList(splitList)) {
            return splitList;
        }
        int size = splitList.size();
        ArrayList<List<Long>> mergeList = new ArrayList<List<Long>>(size);
        ArrayList<Long> oneMergeList = new ArrayList<Long>(size);
        HashMap<String, ArrayList<Long>> groupMap = new HashMap<String, ArrayList<Long>>(16);
        for (int i = 0; i < size; ++i) {
            List<Long> oneList = splitList.get(i);
            if (PlatformUtils.isNullList(oneList)) continue;
            if (oneList.size() == 1) {
                oneMergeList.addAll(oneList);
                continue;
            }
            groupMap = new HashMap(16);
            for (int j = 0; j < oneList.size(); ++j) {
                Long id = oneList.get(j);
                String oneKeys = this.getSameKeys(id, refMap);
                ArrayList<Long> gList = (ArrayList<Long>)groupMap.get(oneKeys);
                if (gList == null) {
                    gList = new ArrayList<Long>(16);
                }
                gList.add(id);
                groupMap.put(oneKeys, gList);
            }
            for (Map.Entry es : groupMap.entrySet()) {
                mergeList.add((List<Long>)es.getValue());
            }
        }
        mergeList.add(oneMergeList);
        return mergeList;
    }

    public List<List<Map<String, Object>>> splitEffectOrderData(List<Map<String, Object>> lists) {
        ArrayList<List<Map<String, Object>>> splitList = new ArrayList<List<Map<String, Object>>>(16);
        int size = lists.size();
        if (size <= 100) {
            splitList.add(lists);
            return splitList;
        }
        HashMap<String, ArrayList<Map<String, Object>>> groupMap = new HashMap<String, ArrayList<Map<String, Object>>>(16);
        for (int i = 0; i < size; ++i) {
            Map<String, Object> datas = lists.get(i);
            Long stockId = this.getLongValue(datas, "stockid");
            Long ecoBomEntryId = this.getLongValue(datas, "ecobomentryid");
            Long sameBatchId = this.getLongValue(datas, "samebatchid");
            String orderType = this.getStringValue(datas, "ordertype");
            String keyString = orderType + "_" + stockId + "_" + ecoBomEntryId + "_" + sameBatchId;
            ArrayList<Map<String, Object>> groupList = (ArrayList<Map<String, Object>>)groupMap.get(keyString);
            if (groupList == null) {
                groupList = new ArrayList<Map<String, Object>>(16);
            }
            groupList.add(datas);
            groupMap.put(keyString, groupList);
        }
        ArrayList mergeList = new ArrayList(100);
        for (Map.Entry entrys : groupMap.entrySet()) {
            List childList = (List)entrys.getValue();
            mergeList.addAll(childList);
            int childSize = mergeList.size();
            if (childSize < 100) continue;
            splitList.add(mergeList);
            mergeList = new ArrayList(100);
        }
        if (mergeList.size() > 0) {
            splitList.add(mergeList);
        }
        log.info("-----------splitEffectOrderData------splitList.size=" + splitList.size() + ",lists.size = " + lists.size());
        return splitList;
    }

    public boolean isValidDate(Date expandBomDate, DynamicObject bomentry) {
        Date validDate = bomentry.getDate("entryvaliddate");
        Date inValidDate = bomentry.getDate("entryinvaliddate");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String expandBomDates = sdf.format(expandBomDate);
        String validDates = sdf.format(validDate);
        String inValidDates = sdf.format(inValidDate);
        return expandBomDates.compareTo(validDates) >= 0 && expandBomDates.compareTo(inValidDates) <= 0;
    }

    private QFilter genDateQueryFilter(Date maxActTime, Date minActTime, Date hisMinActTime, DynamicObject filterObj, boolean isAdd) {
        QFilter otherFilter = null;
        if (isAdd) {
            String addMode = filterObj.getString("datematchadd");
            if ("A".equals(addMode)) {
                if (minActTime != null) {
                    otherFilter = new QFilter("orderentryid.planbegintime", ">=", (Object)minActTime);
                }
            } else if ("B".equals(addMode) || "C".equals(addMode)) {
                otherFilter = new QFilter("stockentry.demanddate", ">=", (Object)this.getMinDateByDelay(filterObj, hisMinActTime));
            }
        } else {
            String editMode = filterObj.getString("datematchedit");
            if ("A".equals(editMode)) {
                if (minActTime != null) {
                    otherFilter = new QFilter("stockentry.demanddate", ">=", (Object)minActTime);
                }
            } else if ("B".equals(editMode) || "C".equals(editMode)) {
                otherFilter = new QFilter("stockentry.demanddate", ">=", (Object)this.getMinDateByDelay(filterObj, hisMinActTime));
            }
        }
        return otherFilter;
    }

    private void setQtyValue(Map<String, Object> stockDataMap, Map<String, Object> gridMap) {
        stockDataMap.put("oldqtynumerator", stockDataMap.get("stockentry.qtynumerator"));
        stockDataMap.put("oldqtydenominator", stockDataMap.get("stockentry.qtydenominator"));
        stockDataMap.put("stockentry.qtynumerator", gridMap.get("qtynumerator"));
        stockDataMap.put("stockentry.qtydenominator", gridMap.get("qtydenominator"));
    }

    private Fraction getDiffFractionByList(List<Map<String, Object>> stockDataMapList, Fraction newfraction) {
        BigDecimal oldMole = BigDecimal.ZERO;
        BigDecimal oldDone = BigDecimal.ONE;
        if (!PlatformUtils.isNullList(stockDataMapList)) {
            for (Map<String, Object> stockDataMap : stockDataMapList) {
                BigDecimal stockfz = this.getBigDecimalValue(stockDataMap, "stockentry.qtynumerator");
                BigDecimal stockfm = this.getBigDecimalValue(stockDataMap, "stockentry.qtydenominator");
                Fraction sumFraction = PlatformUtils.qtyAdd((BigDecimal)oldMole, (BigDecimal)oldDone, (BigDecimal)stockfz, (BigDecimal)stockfm);
                oldMole = sumFraction.getMole();
                oldDone = sumFraction.getDone();
            }
        }
        BigDecimal newMole = newfraction.getMole();
        BigDecimal newDone = newfraction.getDone();
        return PlatformUtils.qtySub((BigDecimal)oldMole, (BigDecimal)oldDone, (BigDecimal)newMole, (BigDecimal)newDone);
    }

    private List<Map<String, Object>> updateChildStockDataQty(Long sameBatchId, List<Map<String, Object>> updateStockList, DynamicObject ecoBomEntryAfter, DynamicObject changeBill, DynamicObject filterObj, Fraction totalDiffFraction, Long parentStockEntryId) {
        BigDecimal diffQtyFz = totalDiffFraction.getMole();
        BigDecimal diffQtyFm = totalDiffFraction.getDone();
        log.info("mmc-pdm-updateChildStockDataQty,stockData is Exists ,this addQty,diffQtyFz=" + diffQtyFz + ",diffQtyFm=" + diffQtyFm + ",filterObj = " + filterObj.getString("number"));
        Map<String, String> xStockMap = this.getXStockDataMap(updateStockList);
        BigDecimal diffFzQty = MMCUtils.divide((BigDecimal)diffQtyFz, (BigDecimal)diffQtyFm);
        ArrayList<Map<String, Object>> gridList = new ArrayList<Map<String, Object>>(16);
        for (int j = 0; j < updateStockList.size(); ++j) {
            BigDecimal stockFz;
            String changeType;
            Map<String, Object> stockDataMap = updateStockList.get(j);
            Long stockEntryId = this.getLongValue(stockDataMap, "stockentry");
            String orderType = this.getStringValue(stockDataMap, "ordertype");
            Long materialId = this.getLongValue(stockDataMap, "stockentry.materielmasterid");
            String xStockString = this.genXStockKeyString("B", String.valueOf(stockEntryId), orderType, "", String.valueOf(materialId));
            if (xStockMap.containsKey(xStockString)) {
                diffFzQty = BigDecimal.ZERO;
                log.info("getEditDataStock,updateChildStockDataQty,xstockMap.containsKey(xStockString) ,xStockString = " + xStockString);
                if (!this.isShowDetialLog()) continue;
                LogUtils.genLogs16(this.logs, stockDataMap, xStockMap.get(xStockString));
                continue;
            }
            BigDecimal orderQty = this.getBigDecimalValue(stockDataMap, "qty");
            if (diffFzQty.compareTo(BigDecimal.ZERO) > 0) {
                changeType = "A";
                BigDecimal changeUnitFz = diffFzQty;
                BigDecimal changeStandQty = MMCUtils.multiply((BigDecimal)changeUnitFz, (BigDecimal)orderQty);
                Map<String, Object> dataMap = this.copyMap(stockDataMap);
                dataMap.put("samebatchid", sameBatchId);
                dataMap.put("parentstockentryid", parentStockEntryId);
                String remark = String.format(ResManager.loadKDString((String)"\u7236\u9879\u4e3a\u8df3\u5c42\u4ef6\u65b0\u589e\u7269\u6599\uff0c\u5b50\u9879\u540c\u6b65\u589e\u52a0\u65f6\uff0c\u7531\u4e8e\u5df2\u5b58\u5728\u4e8e\u7ec4\u4ef6\u6e05\u5355\u4e2d\uff0c\u672c\u6b21\u6267\u884c\u4fee\u6539\u64cd\u4f5c\uff0c\u589e\u52a0\u5355\u4f4d\u6570\u91cf\u201c%1$s\u201d\u3002", (String)"GetEcoEffectOrderBusiness_30", (String)"mmc-pdm-business", (Object[])new Object[0]), changeUnitFz);
                dataMap.put("remark", remark);
                Map<String, Object> gridMap = this.genGrideDataMap(dataMap, ecoBomEntryAfter, ecoBomEntryAfter, changeBill, null, null, null, changeType, diffQtyFz, diffQtyFm, changeStandQty, filterObj);
                gridList.add(gridMap);
                diffFzQty = BigDecimal.ZERO;
                this.setQtyValue(stockDataMap, gridMap);
                continue;
            }
            if (diffFzQty.compareTo(BigDecimal.ZERO) >= 0) continue;
            changeType = "B";
            BigDecimal changeUnitFz = stockFz = MMCUtils.divide((BigDecimal)this.getBigDecimalValue(stockDataMap, "stockentry.qtynumerator"), (BigDecimal)this.getBigDecimalValue(stockDataMap, "stockentry.qtydenominator"));
            BigDecimal changeFz = this.getBigDecimalValue(stockDataMap, "stockentry.qtynumerator");
            BigDecimal changeFm = this.getBigDecimalValue(stockDataMap, "stockentry.qtydenominator");
            if (diffFzQty.abs().compareTo(stockFz) >= 0) {
                diffFzQty = diffFzQty.add(stockFz);
            } else {
                changeUnitFz = diffFzQty.abs();
                diffFzQty = BigDecimal.ZERO;
                Fraction changeFraction = PlatformUtils.convertToFraction((BigDecimal)changeUnitFz);
                changeFz = changeFraction.getMole();
                changeFm = changeFraction.getDone();
            }
            BigDecimal changeStandQty = MMCUtils.multiply((BigDecimal)changeUnitFz, (BigDecimal)orderQty);
            Map<String, Object> dataMap = this.copyMap(stockDataMap);
            dataMap.put("samebatchid", sameBatchId);
            dataMap.put("parentstockentryid", parentStockEntryId);
            String remark = String.format(ResManager.loadKDString((String)"\u7236\u9879\u4e3a\u8df3\u5c42\u4ef6\u65b0\u589e\u7269\u6599\uff0c\u5b50\u9879\u540c\u6b65\u589e\u52a0\u65f6\uff0c\u7531\u4e8e\u5df2\u5b58\u5728\u4e8e\u7ec4\u4ef6\u6e05\u5355\u4e2d\uff0c\u672c\u6b21\u6267\u884c\u4fee\u6539\u64cd\u4f5c\uff0c\u51cf\u5c11\u5355\u4f4d\u6570\u91cf\u201c%1$s\u201d\u3002", (String)"GetEcoEffectOrderBusiness_31", (String)"mmc-pdm-business", (Object[])new Object[0]), changeUnitFz);
            dataMap.put("remark", remark);
            Map<String, Object> gridMap = this.genGrideDataMap(dataMap, ecoBomEntryAfter, ecoBomEntryAfter, changeBill, null, null, null, changeType, changeFz, changeFm, changeStandQty, filterObj);
            gridList.add(gridMap);
            this.setQtyValue(stockDataMap, gridMap);
        }
        return gridList;
    }

    @Override
    public int getIdBatchMaxSize() {
        return 50000;
    }

    private void initUnAuditEntrys(Map<Long, DynamicObject> ecobomEntryMap, Map<Long, DynamicObject> mftBomEntryMap, Map<Long, DynamicObject> changeBillMap) {
        for (Map.Entry<Long, DynamicObject> ecoEntryMaps : ecobomEntryMap.entrySet()) {
            DynamicObject bomEntry;
            DynamicObject ecoBomEntry = ecoEntryMaps.getValue();
            Long bomentryId = ecoBomEntry.getLong("bomentry");
            Long ecoBomId = ecoBomEntry.getLong("ecobomid");
            DynamicObject changeBill = changeBillMap.get(ecoBomId);
            boolean isAuditChangeBill = this.isAuditStatus(changeBill);
            if (isAuditChangeBill || (bomEntry = mftBomEntryMap.get(bomentryId)) != null) continue;
            Long bomId = this.getBomId(changeBill, bomEntry, ecoBomId);
            bomEntry = this.buildBomEntry(ecoBomEntry, bomId);
            bomentryId = bomEntry.getLong("entryid");
            mftBomEntryMap.put(bomentryId, bomEntry);
            ecoBomEntry.set("bomentry", (Object)bomentryId);
        }
    }

    public DynamicObject buildBomEntry(DynamicObject ecoBomEntry, Long bomId) {
        DynamicObject bomEntry = BusinessDataServiceHelper.newDynamicObject((String)"pdm_mftbomentry");
        Long entryID = ID.genLongId();
        bomEntry.set("id", (Object)entryID);
        bomEntry.set("entryid", (Object)entryID);
        bomEntry.set("entryseq", (Object)0);
        bomEntry.set("entryvaliddate", ecoBomEntry.get("entryvaliddate"));
        bomEntry.set("entryinvaliddate", ecoBomEntry.get("entryinvaliddate"));
        bomEntry.set("entrymaterialattr", ecoBomEntry.get("entrymaterialattr"));
        bomEntry.set("entrymaterial", ecoBomEntry.get("entrymaterialmft"));
        bomEntry.set("entryunit", ecoBomEntry.get("entryunit"));
        bomEntry.set("entryqtytype", ecoBomEntry.get("entryqtytype"));
        bomEntry.set("entryqtynumerator", ecoBomEntry.get("entryqtynumerator"));
        bomEntry.set("entryqtydenominator", ecoBomEntry.get("entryqtydenominator"));
        bomEntry.set("entryisjumplevel", ecoBomEntry.get("entryisjumplevel"));
        bomEntry.set("bomid", (Object)bomId);
        bomEntry.set("entryconfiguredcode", ecoBomEntry.get("entryconfiguredcode"));
        bomEntry.set("entrymaterialid", ecoBomEntry.get("entrymaterial"));
        bomEntry.set("entryversion", ecoBomEntry.get("entryversion"));
        bomEntry.set("auxpropertyid", ecoBomEntry.get("entryauxproperty"));
        bomEntry.set("entryfixscrap", ecoBomEntry.get("entryfixscrap"));
        bomEntry.set("entryscraprate", ecoBomEntry.get("entryscraprate"));
        bomEntry.set("entrytype", ecoBomEntry.get("entrytype"));
        bomEntry.set("entryisreplace", ecoBomEntry.get("entryisreplace"));
        bomEntry.set("entryreplaceplan", ecoBomEntry.get("entryreplaceplan"));
        bomEntry.set("entryisreplaceplanmm", ecoBomEntry.get("entryisreplaceplanmm"));
        bomEntry.set("reppriority", ecoBomEntry.get("reppriority"));
        bomEntry.set("featuretype", ecoBomEntry.get("featuretype"));
        return bomEntry;
    }
}

