/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.business.ecoplatform.estimate;

import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.operate.MutexHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class EstimateStartBusiness {
    private static final String PLANGRAMENTITY = "pdm_planprogram_eco";
    private static final String CACULATE_LOG = "mrp_caculate_log";

    public String start(Long planOrgId, Long schedulingSchemeId, String paramA, String paramB) {
        if (!this.addDataMutex(schedulingSchemeId)) {
            DynamicObject program = BusinessDataServiceHelper.loadSingleFromCache((Object)schedulingSchemeId, (String)PLANGRAMENTITY, (String)"number");
            throw new KDBizException(new ErrorCode("start", String.format(ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u8bc4\u4f30\u8fd0\u7b97\u65b9\u6848\u201c%1$s\u201d\u5b58\u5728\u6b63\u5728\u8fd0\u884c\u7684\u8ba1\u5212\uff0c\u8bf7\u7b49\u5f85\u6216\u7ec8\u6b62\u8fd0\u7b97\u540e\u518d\u8ba1\u7b97\u3002", (String)"EstimateStartBusiness_01", (String)"mmc-pdm-business", (Object[])new Object[0]), program.getString("number"))), new Object[0]);
        }
        try {
            Long logid = (Long)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msplan", (String)"IMRPCalcRuntimeService", (String)"initRuntime", (Object[])new Object[]{CACULATE_LOG});
            DynamicObject log = this.writeLog(logid, planOrgId, schedulingSchemeId);
            this.execSchedulingScheme(logid, planOrgId);
            return log.getString("number");
        }
        catch (Exception exception) {
            this.release(schedulingSchemeId);
            throw exception;
        }
    }

    private void execSchedulingScheme(long ctxId, Long orgId) {
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (String)"bos_org");
        String title = ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u8bc4\u4f30", (String)"EstimateStartBusiness_02", (String)"mmc-pdm-business", (Object[])new Object[0]);
        DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msplan", (String)"IMRPCalcRuntimeService", (String)"startCalc", (Object[])new Object[]{ctxId, null, org.getLong("id"), org.getString("name"), "pdm_ecoestimate_exec", title, CACULATE_LOG});
    }

    private boolean addDataMutex(Long schedulingSchemeId) {
        StringBuilder errMsg = new StringBuilder();
        return MutexHelper.require((String)PLANGRAMENTITY, (Object)String.valueOf(schedulingSchemeId), (String)"releasemutex", (boolean)true, (StringBuilder)errMsg);
    }

    private DynamicObject writeLog(Long ctxId, Long orgId, Long programId) {
        String title = ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u8bc4\u4f30", (String)"EstimateStartBusiness_02", (String)"mmc-pdm-business", (Object[])new Object[0]);
        DynamicObject schedulingScheme = BusinessDataServiceHelper.loadSingleFromCache((Object)programId, (String)PLANGRAMENTITY);
        DynamicObject caculateLog = BusinessDataServiceHelper.loadSingle((Object)ctxId, (String)CACULATE_LOG);
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (String)"bos_org");
        if ("B".equals(schedulingScheme.getString("estimatetype"))) {
            title = ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u5f71\u54cd\u8303\u56f4\u8ba1\u7b97\u3002", (String)"EstimateStartBusiness_03", (String)"mmc-pdm-business", (Object[])new Object[0]);
        }
        caculateLog.set("createorg", (Object)org);
        caculateLog.set("useorg", (Object)org);
        caculateLog.set("status", (Object)"C");
        caculateLog.set("enable", (Object)"1");
        caculateLog.set("plantype", (Object)title);
        caculateLog.set("plangram", (Object)schedulingScheme.getLong("id"));
        caculateLog.set("programname", (Object)schedulingScheme.getString("name"));
        caculateLog.set("programnumber", (Object)schedulingScheme.getString("number"));
        caculateLog.set("plangramentity", (Object)PLANGRAMENTITY);
        caculateLog.set("plandate", (Object)new Date());
        caculateLog.set("creator", (Object)RequestContext.get().getCurrUserId());
        caculateLog.set("startdate", (Object)new Date());
        caculateLog.set("operatmode", (Object)title);
        caculateLog.set("operatmodekey", (Object)"pdm_ecoestimate_exec");
        caculateLog.set("runtype", (Object)"ECO");
        if ("B".equals(schedulingScheme.getString("estimatetype"))) {
            caculateLog.set("runtype", (Object)"ER");
        }
        SaveServiceHelper.update((DynamicObject)caculateLog);
        return caculateLog;
    }

    private void release(Long schedulingSchemeId) {
        MutexHelper.release((String)PLANGRAMENTITY, (String)"releasemutex", (String)String.valueOf(schedulingSchemeId));
    }
}

