/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.business.ecoplatform.estimate.step;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mmc.pdm.business.ecoplatform.estimate.step.EcoEstimateBaseStep;
import kd.mmc.pdm.business.ecoplatform.estimate.step.batchtask.EstimateBatchTaskEvent;
import kd.mmc.pdm.business.ecoplatform.estimate.step.exec.EffectRangeGetSupplyDataImpl;
import kd.mmc.pdm.common.bom.ecoplatform.PlatformUtils;
import kd.mpscmm.msplan.mservice.service.batchtask.BatchTask;
import kd.mpscmm.msplan.mservice.service.mrp.ExecutionEnv;

public class EcoEffectRangeGetSupplyData
extends EcoEstimateBaseStep {
    private static final Log log = LogFactory.getLog(EcoEffectRangeGetSupplyData.class);
    private static final int MATERIALBATCHSIZE = 100;

    @Override
    public String doWork(ExecutionEnv env, int stepIdx) {
        super.doWork(env, stepIdx);
        try {
            String materialIds = this.getCacheValue(this.getMaterialIdCacheString());
            String supAndReqKeys = this.getCacheValue(this.getReqSupCacheString());
            Set allMaterialIdSet = PlatformUtils.ParseStringToLongSet((String)materialIds);
            if (allMaterialIdSet == null || allMaterialIdSet.isEmpty()) {
                return ResManager.loadKDString((String)"\u9700\u6c42\u7269\u6599\u4e3a\u7a7a", (String)"EcoEffectRangeGetSupplyData_0", (String)"mmc-pdm-business", (Object[])new Object[0]);
            }
            Set supAndReqKeySet = PlatformUtils.ParseStringToSet((String)supAndReqKeys);
            int dataAmount = 0;
            DynamicObject planProgram = this.getPlanProgram();
            log.info("-------EcoEffectRangeGetSupplyData------allMaterialIdSet =" + allMaterialIdSet.size());
            DynamicObjectCollection collection = planProgram.getDynamicObjectCollection("scentryentity");
            List<Long> modelIds = collection.stream().filter(o -> o.getBoolean("entryisscmrpoperat")).map(o -> o.getLong("resourceregisters.id")).collect(Collectors.toList());
            if (modelIds.isEmpty()) {
                log.info("-------EcoEffectRangeGetSupplyData------entryisscmrpoperat is null ");
                this.updateLogCount(stepIdx, dataAmount);
                String resultStr = ResManager.loadKDString((String)"\u672a\u627e\u5230\u4f9b\u5e94\u6570\u636e\u6e90\uff0c\u4f9b\u5e94\u5339\u914d\u6570\u4e3a0\u3002", (String)"EcoEffectRangeGetSupplyData_1", (String)"mmc-pdm-business", (Object[])new Object[0]);
                return resultStr;
            }
            List<Set<Long>> splitMaterialIds = this.splitData(env, allMaterialIdSet);
            dataAmount = this.batchExecute(env, splitMaterialIds, supAndReqKeySet, planProgram, modelIds);
            this.updateLogCount(stepIdx, dataAmount);
            String resultStr = String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u201c%1$s\u201d\u6761\uff0c\u7269\u6599\u6570\u201c%2$s\u201d\u6761\u3002", (String)"EcoEffectRangeGetSupplyData_2", (String)"mmc-pdm-business", (Object[])new Object[0]), dataAmount, allMaterialIdSet.size());
            log.info("------EcoEffectRangeGetSupplyData---end-----resultStr = " + resultStr);
            return resultStr;
        }
        catch (Exception e) {
            this.clearCacheValue(env);
            log.error((Throwable)e);
            throw e;
        }
    }

    public List<Set<Long>> splitData(ExecutionEnv env, Set<Long> allMaterialIdSet) {
        boolean isBatchCompute = this.isBatchCompute();
        int subSize = 100;
        if (isBatchCompute && (subSize = this.getMateriaBatchCount()) == 0) {
            subSize = 100;
        }
        ArrayList<Set<Long>> splitMaterialIds = new ArrayList<Set<Long>>(16);
        int i = 0;
        HashSet<Long> subMaterialIdSet = new HashSet<Long>(subSize);
        for (Long materialId : allMaterialIdSet) {
            if (i == 0 || subMaterialIdSet.size() >= subSize) {
                subMaterialIdSet = new HashSet(subSize);
                splitMaterialIds.add(subMaterialIdSet);
            }
            ++i;
            subMaterialIdSet.add(materialId);
        }
        log.info("-----------EcoEffectRangeGetSupplyData-----splitData---------subSize:" + subSize + ",allMaterialIdSet.size=" + allMaterialIdSet.size() + ",splitMaterialIds.size=" + splitMaterialIds.size());
        return splitMaterialIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int batchExecute(ExecutionEnv env, List<Set<Long>> splitMaterialIds, Set<String> supAndReqKeySet, DynamicObject planProgram, List<Long> modelIds) {
        boolean isBatchCompute = this.isBatchCompute();
        int dataAmount = 0;
        int size = splitMaterialIds.size();
        if (!isBatchCompute || this.getMateriaBatchCount() <= 0) {
            for (int i = 0; i < size; ++i) {
                Set<Long> materialIdSet = splitMaterialIds.get(i);
                dataAmount += EffectRangeGetSupplyDataImpl.getInstance().exec(env, planProgram, null, null, supAndReqKeySet, materialIdSet, modelIds, false);
            }
            return dataAmount;
        }
        BatchTask task = BatchTask.create((String)"EcoEffectRangeGetSupplyData");
        String taskId = task.getCalcId();
        task.setQueueName(this.getConsumerQueue());
        task.registBizClass(EstimateBatchTaskEvent.class);
        task.setTimeOut(TASKTIMEOUTLONG.longValue());
        int batch = 0;
        int allDataSize = 0;
        for (int i = 0; i < size; ++i) {
            Set<Long> materialIdSet = splitMaterialIds.get(i);
            ++batch;
            allDataSize += materialIdSet.size();
            HashMap<String, Object> batchParams = new HashMap<String, Object>(16);
            batchParams.put("materialidset", materialIdSet);
            batchParams.put("supAndReqKeySet", supAndReqKeySet);
            batchParams.put("planProgram", planProgram);
            batchParams.put("modelIds", modelIds);
            batchParams.put("runLog", env.getRunLog());
            batchParams.put("envCacheMap", env.getParams());
            batchParams.put("taskname", "EffectRange_GetSupplyData");
            batchParams.put("batch", batch);
            task.addEvent(batchParams);
        }
        this.addTaskLog(taskId);
        long startTime = System.currentTimeMillis();
        boolean successful = true;
        String errorMsg = "";
        try {
            log.info(String.format(ResManager.loadKDString((String)"EcoEffectRangeGetSupplyData_BatchTask\u5206\u5e03\u5f0f\u8ba1\u7b97\u8c03\u5ea6\u5f00\u59cb\uff0c[%1$s]\u4e2a\u7269\u6599\u5206\u53d1\u4e3a\u5171[%2$s]\u4e2a\u4efb\u52a1...", (String)"EcoEffectRangeGetSupplyData_4", (String)"mmc-pdm-business", (Object[])new Object[0]), allDataSize, batch));
            log.info(String.format(ResManager.loadKDString((String)"EcoEffectRangeGetSupplyData_BatchTask\u5206\u5e03\u5f0f\u8ba1\u7b97\u8c03\u5ea6\u5f00\u59cb\uff0c[%1$s]\u4e2a\u7269\u6599\u5206\u53d1\u4e3a\u5171[%2$s]\u4e2a\u4efb\u52a1...", (String)"EcoEffectRangeGetSupplyData_4", (String)"mmc-pdm-business", (Object[])new Object[0]), allDataSize, batch));
            task.startTask();
            log.info(ResManager.loadKDString((String)"EcoEffectRangeGetSupplyData_BatchTask\u5206\u5e03\u5f0f\u8ba1\u7b97\u8c03\u5ea6\u7ed3\u675f...", (String)"EcoEffectRangeGetSupplyData_5", (String)"mmc-pdm-business", (Object[])new Object[0]));
            log.info(ResManager.loadKDString((String)"EcoEffectRangeGetSupplyData_BatchTask\u5206\u5e03\u5f0f\u8ba1\u7b97\u8c03\u5ea6\u7ed3\u675f...", (String)"EcoEffectRangeGetSupplyData_5", (String)"mmc-pdm-business", (Object[])new Object[0]));
        }
        catch (Exception e) {
            log.error(ResManager.loadKDString((String)"EcoEffectRangeGetSupplyData_BatchTask\u5206\u5e03\u5f0f\u8ba1\u7b97\u51fa\u9519\uff1a", (String)"EcoEffectRangeGetSupplyData_6", (String)"mmc-pdm-business", (Object[])new Object[0]) + e.getMessage(), (Throwable)e);
            log.error(ResManager.loadKDString((String)"EcoEffectRangeGetSupplyData_BatchTask\u5206\u5e03\u5f0f\u8ba1\u7b97\u51fa\u9519\uff1a", (String)"EcoEffectRangeGetSupplyData_6", (String)"mmc-pdm-business", (Object[])new Object[0]) + e.getMessage(), (Throwable)e);
            successful = false;
            errorMsg = PlatformUtils.getExceptionString((Exception)e);
        }
        finally {
            task.terminate();
        }
        if (!successful) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u5f71\u54cd\u8303\u56f4\u8fd0\u7b97\u7684\u4f9b\u5e94\u6570\u636e\u5b58\u5728\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\uff1a\u201c%1$s\u201d\u3002", (String)"EcoEffectRangeGetSupplyData_3", (String)"mmc-pdm-business", (Object[])new Object[0]), errorMsg));
        }
        long enddate = System.currentTimeMillis() - startTime;
        log.info(String.format(ResManager.loadKDString((String)"EcoEffectRangeGetSupplyData_BatchTask\u5206\u5e03\u5f0f\u8ba1\u7b97\u5b8c\u6bd5,allDataSize.size =%1$s,cost: %2$s ms", (String)"EcoEffectRangeGetSupplyData_7", (String)"mmc-pdm-business", (Object[])new Object[0]), allDataSize, enddate));
        log.info(String.format(ResManager.loadKDString((String)"EcoEffectRangeGetSupplyData_BatchTask\u5206\u5e03\u5f0f\u8ba1\u7b97\u5b8c\u6bd5,allDataSize.size =%1$s,cost: %2$s ms", (String)"EcoEffectRangeGetSupplyData_7", (String)"mmc-pdm-business", (Object[])new Object[0]), allDataSize, enddate));
        return this.getIntegerCacheValue(this.getRequireDataAmountCacheString());
    }
}

