/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.business.ecoplatform.estimate.step;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dlock.DLock;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.mmc.pdm.business.ecoplatform.estimate.step.EstimateUtils;
import kd.mmc.pdm.common.bom.ecoplatform.PlatformUtils;
import kd.mmc.pdm.common.util.PdmParamSetHelper;
import kd.mpscmm.msplan.mservice.service.mrp.ExecutionEnv;
import kd.mpscmm.msplan.mservice.service.mrp.step.ICalcStep;

public class EcoEstimateBaseStep
implements ICalcStep {
    DistributeSessionlessCache redisCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("mmc-pdm-ecoestimate");
    private Long logId = 0L;
    private String SPLITCHAR = ";";
    public String IS_REDISBYTEMODE = null;
    private DynamicObject runLog;
    public static final DBRoute scmDBRoute = new DBRoute("scm");
    private static final Log log = LogFactory.getLog(EcoEstimateBaseStep.class);
    public static final String SUCCESSFUL_VALUE = "ok";
    public static final String ENTITY_PLANPROGRAM = "pdm_planprogram_eco";
    public static final String ENTITY_LOG = "mrp_caculate_log";
    public static final Long TASKTIMEOUTLONG = 3600000L;

    public String doWork(ExecutionEnv paramExecutionEnv, int paramInt) {
        this.init(paramExecutionEnv);
        return SUCCESSFUL_VALUE;
    }

    public void init(ExecutionEnv paramExecutionEnv) {
        this.logId = paramExecutionEnv.getCtxId();
        this.runLog = paramExecutionEnv.getRunLog();
    }

    public void init(DynamicObject runlog) {
        this.logId = runlog.getLong("id");
        this.runLog = runlog;
    }

    public DynamicObject getPlanProgram() {
        if (PlatformUtils.isNullLong((Long)this.logId) || this.runLog == null) {
            return null;
        }
        if (this.runLog.containsProperty("plangram")) {
            return this.getPlanProgram(this.runLog.getLong("plangram"));
        }
        DynamicObject log = BusinessDataServiceHelper.loadSingleFromCache((Object)this.logId, (String)ENTITY_LOG, (String)"plangram");
        return this.getPlanProgram(log.getLong("plangram"));
    }

    public DynamicObject getPlanProgram(ExecutionEnv env) {
        Long logId = env.getCtxId();
        DynamicObject runLog = env.getRunLog();
        if (runLog.containsProperty("plangram")) {
            return this.getPlanProgram(runLog.getLong("plangram"));
        }
        DynamicObject log = BusinessDataServiceHelper.loadSingleFromCache((Object)logId, (String)ENTITY_LOG, (String)"plangram");
        return this.getPlanProgram(log.getLong("plangram"));
    }

    public DataSet formatEntryEntity(DataSet dataSet) {
        String[] fieldNames = dataSet.getRowMeta().getFieldNames();
        for (int i = 0; i < fieldNames.length; ++i) {
            String field = fieldNames[i];
            if (!field.contains("entryentity.")) continue;
            fieldNames[i] = field + " as " + field.replace("entryentity.", "");
        }
        return dataSet.select(fieldNames);
    }

    public DynamicObject getPlanProgram(Long planId) {
        return BusinessDataServiceHelper.loadSingleFromCache((Object)planId, (String)ENTITY_PLANPROGRAM);
    }

    public String getEstimateKey() {
        return String.format("ecoestimate-%d", this.logId);
    }

    public String getMaterialIdCacheString() {
        return this.getEstimateKey() + "-mids";
    }

    public String getReqSupCacheString() {
        return this.getEstimateKey() + "-sr-keys";
    }

    public String getMinSupplyDateCacheString() {
        return this.getEstimateKey() + "-min-sdate";
    }

    public String getRequireCacheString(String keyString) {
        return this.getEstimateKey() + "-r-" + keyString;
    }

    public String getSupplyCacheString(String keyString) {
        return this.getEstimateKey() + "-s-" + keyString;
    }

    public String getCacheValue(String keyString) {
        if (this.getRedisByteMode()) {
            byte[] bs = this.redisCache.getByteValue(keyString);
            return PlatformUtils.decodeToString((byte[])bs);
        }
        return (String)this.redisCache.get(keyString);
    }

    public boolean isExceptionError(JSONObject supObject) {
        return "C".equals(supObject.getString("exceptiontype"));
    }

    public boolean isExceptionNormal(JSONObject supObject) {
        return "A".equals(supObject.getString("exceptiontype"));
    }

    public boolean isExceptionRepeat(JSONObject supObject) {
        return "B".equals(supObject.getString("exceptiontype"));
    }

    public boolean isExceptionError(DynamicObject result) {
        return "C".equals(result.getString("exceptiontype"));
    }

    public boolean isExceptionNormal(DynamicObject result) {
        return "A".equals(result.getString("exceptiontype"));
    }

    public boolean isExceptionRepeat(DynamicObject result) {
        return "B".equals(result.getString("exceptiontype"));
    }

    public String getPlatMapKey() {
        return "ecocachekey";
    }

    public String unionStr(String stra, String strb) {
        return stra + this.SPLITCHAR + strb;
    }

    public void setCacheValue(ExecutionEnv env, String keyString, String value, int timeLong) {
        this.setCacheValue(env == null ? null : env.getParams(), keyString, value, timeLong);
    }

    public void clearCacheValue(ExecutionEnv env) {
        Map envCacheMap = env.getParams();
        String cacheValue = (String)envCacheMap.get(this.getPlatMapKey());
        if (!StringUtils.isEmpty((String)cacheValue)) {
            String[] array = cacheValue.split(this.SPLITCHAR);
            for (int i = 0; i < array.length; ++i) {
                String keyString = array[i];
                this.removeCacheValue(keyString);
            }
        }
    }

    public void removeCacheValue(String keyString) {
        this.redisCache.remove(keyString);
    }

    public void updateLogCount(int stepIdx, int count) {
        DynamicObject runlog = BusinessDataServiceHelper.loadSingle((Object)this.logId, (String)ENTITY_LOG, (String)"id,entryentity,entryentity.entrystepseq,entryentity.entryprocessdata");
        DynamicObjectCollection entryentity = runlog.getDynamicObjectCollection("entryentity");
        List list = entryentity.stream().filter(o -> String.valueOf(stepIdx).equals(o.getString("entrystepseq"))).collect(Collectors.toList());
        if (list.size() > 0) {
            ((DynamicObject)list.get(0)).set("entryprocessdata", (Object)count);
            SaveServiceHelper.update((DynamicObject)runlog);
        }
    }

    public int getPlanOutLook(DynamicObject plan) {
        return plan.getInt("planoutlook");
    }

    public boolean isEstimateStatus(DynamicObject plan) {
        return true;
    }

    public String getShiftingType(DynamicObject plan) {
        return plan.getString("shiftingtype");
    }

    public String getRefPkType(DynamicObject plan) {
        return plan.getString("refpktype");
    }

    public String getGroupPkType(DynamicObject plan) {
        return plan.getString("grouppktype");
    }

    public boolean isRefEco(DynamicObject plan) {
        return plan.getBoolean("isrefeco");
    }

    private Set<Long> getOrgs(DynamicObject plan) {
        HashSet<Long> orgSet = new HashSet<Long>(16);
        DynamicObjectCollection orgs = plan.getDynamicObjectCollection("orgentryentity");
        for (DynamicObject org : orgs) {
            DynamicObject rOrg = org.getDynamicObject("entrydemandorg");
            Long orgId = rOrg.getLong("id");
            orgSet.add(orgId);
        }
        return orgSet;
    }

    public Set<Long> getRequirorgs(DynamicObject plan) {
        return this.getOrgs(plan);
    }

    public Set<Long> getSupplyOrgs(DynamicObject plan) {
        return this.getOrgs(plan);
    }

    public int getRequireDelayPeriod(DynamicObject plan) {
        if ("1".equalsIgnoreCase(plan.getString("outofdate"))) {
            return -1;
        }
        return plan.getInt("day");
    }

    public int getSupplyDelayPeriod(DynamicObject plan) {
        if ("1".equalsIgnoreCase(plan.getString("scoutofdate"))) {
            return -1;
        }
        return plan.getInt("scday");
    }

    public String getUnionString(String stra, String strb) {
        return stra + "_" + strb;
    }

    public String getAlgoxString(String stra) {
        return EcoEstimateBaseStep.class.getName() + "_" + stra;
    }

    public String[] getRequireCacheRedisKeyField(DynamicObject plan) {
        return this.getSRKeyField(plan, true);
    }

    public String[] getDefaultRequireFields() {
        return new String[]{"productionorgunit", "material", "bomreversion", "materialflexprops"};
    }

    public String[] getSupplyCacheRedisKeyField(DynamicObject plan) {
        return this.getSRKeyField(plan, false);
    }

    public String[] getSRKeyField(DynamicObject plan, boolean isRequire) {
        DynamicObject ts = plan.getDynamicObject("relativetransfer");
        if (ts == null) {
            if (isRequire) {
                return this.getDefaultRequireFields();
            }
            return this.getDefaultSupplyFields();
        }
        List<String> fsList = EstimateUtils.getSRFields(ts.getLong("id"), isRequire);
        if (PlatformUtils.isNullList(fsList)) {
            if (isRequire) {
                return this.getDefaultRequireFields();
            }
            return this.getDefaultSupplyFields();
        }
        int size = fsList.size();
        String[] fieldArray = new String[size];
        for (int i = 0; i < size; ++i) {
            String field = fsList.get(i);
            if (field.contains("entryentity.")) {
                field = field.replace("entryentity.", "");
            }
            fieldArray[i] = field;
        }
        return fieldArray;
    }

    public String[] getDefaultSupplyFields() {
        return new String[]{"supplyorgunit", "material", "bomreversion", "materialflexprops"};
    }

    public String getRowKeyString(Row arow, String[] keyFieldNames, Long materialId) {
        StringBuilder sb = new StringBuilder();
        int size = keyFieldNames.length;
        for (int keySize = 0; keySize < size; ++keySize) {
            String fieldName = keyFieldNames[keySize];
            Object value = arow.get(fieldName);
            if (keySize > 0) {
                sb.append("-");
            }
            if (fieldName.equals("material") && materialId != null && !materialId.equals(0L) && (value == null || "".equals(value.toString()) || "0".equals(value.toString()))) {
                value = materialId;
            }
            sb.append(value == null ? "" : value.toString());
        }
        return sb.toString();
    }

    public Date getDate(Date date, boolean isfirst) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        if (isfirst) {
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
        } else {
            calendar.set(10, 23);
            calendar.set(12, 59);
            calendar.set(13, 59);
            calendar.set(14, 999);
        }
        return calendar.getTime();
    }

    public Map<Long, String> getSrcEntityName(List<Long> modelIdList) {
        HashMap<Long, String> dsSrcEntityMap = new HashMap<Long, String>(modelIdList.size());
        QFilter qfilter = new QFilter("id", "in", modelIdList);
        String selectProperties = "id,billfieldtransfer,billfieldtransfer.srcbill";
        Map mrpDsMap = BusinessDataServiceHelper.loadFromCache((String)"mrp_resource_dataconfig", (String)selectProperties, (QFilter[])new QFilter[]{qfilter});
        for (Map.Entry entrys : mrpDsMap.entrySet()) {
            DynamicObject mrpDs = (DynamicObject)entrys.getValue();
            Long modelId = mrpDs.getLong("id");
            DynamicObject billfieldtransfer = mrpDs.getDynamicObject("billfieldtransfer");
            DynamicObject srcbill = billfieldtransfer.getDynamicObject("srcbill");
            MainEntityType srcType = MetadataServiceHelper.getDataEntityType((String)srcbill.getString("id"));
            dsSrcEntityMap.put(modelId, srcType.getName());
        }
        return dsSrcEntityMap;
    }

    public Map<Long, String> getSupplyDateSrcFieldMap(List<Long> modelIdList) {
        return this.getSrcFieldMap(modelIdList, "entryentity.billdate");
    }

    public Map<Long, String> getOrgSrcFieldMap(List<Long> modelIdList) {
        return this.getSrcFieldMap(modelIdList, "entryentity.supplyorgunit");
    }

    public Map<Long, String> getMaterialSrcFieldMap(List<Long> modelIdList) {
        return this.getComputeFieldMap(modelIdList, "entryentity.material");
    }

    public Map<Long, String> getReqOrgSrcFieldMap(List<Long> modelIdList) {
        return this.getSrcFieldMap(modelIdList, "entryentity.productionorgunit");
    }

    public Map<Long, String> getSrcFieldMap(List<Long> modelIdList, String destfieldFlag) {
        HashMap<Long, String> dsFieldMap = new HashMap<Long, String>(modelIdList.size());
        QFilter qfilter = new QFilter("id", "in", modelIdList);
        qfilter.and(new QFilter("billfieldtransfer.entryentity.destfieldflag", "=", (Object)destfieldFlag));
        qfilter.and(new QFilter("billfieldtransfer.entryentity.converttype", "=", (Object)"0"));
        String selectProperties = "id,billfieldtransfer.entryentity.sourcefieldflag sourcefieldflag ";
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"mrp_resource_dataconfig", (String)selectProperties, (QFilter[])new QFilter[]{qfilter});
        for (DynamicObject dy : coll) {
            dsFieldMap.put(dy.getLong("id"), dy.getString("sourcefieldflag"));
        }
        return dsFieldMap;
    }

    public Map<Long, String> getComputeFieldMap(List<Long> modelIdList, String destfieldFlag) {
        HashMap<Long, String> dsFieldMap = new HashMap<Long, String>(modelIdList.size());
        QFilter qfilter = new QFilter("id", "in", modelIdList);
        qfilter.and(new QFilter("billfieldtransfer.entryentity.destfieldflag", "=", (Object)destfieldFlag));
        qfilter.and(new QFilter("billfieldtransfer.entryentity.converttype", "=", (Object)"1"));
        String selectProperties = "id,billfieldtransfer.entryentity.calculateexc calculateexc ";
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"mrp_resource_dataconfig", (String)selectProperties, (QFilter[])new QFilter[]{qfilter});
        for (DynamicObject dy : coll) {
            dsFieldMap.put(dy.getLong("id"), dy.getString("calculateexc"));
        }
        return dsFieldMap;
    }

    public Date getDate(Object dates) {
        if (dates != null) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                return sdf.parse(dates.toString());
            }
            catch (ParseException e) {
                log.error((Throwable)e);
            }
        }
        return null;
    }

    public Map<String, Object> executeOperation(Set<Long> pkIdSet, String operatekey, String entityname) {
        if (!pkIdSet.isEmpty()) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("ignorewarn", String.valueOf(true));
            operateOption.setVariableValue("ignoreinteraction", String.valueOf(true));
            operateOption.setVariableValue("strictvalidation", String.valueOf(true));
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)operatekey, (String)entityname, (Object[])pkIdSet.toArray(), (OperateOption)operateOption);
            String errorMsg = PlatformUtils.getErrorMsg((OperationResult)operationResult);
            HashMap<String, Object> returnMap = new HashMap<String, Object>(16);
            returnMap.put("msg", errorMsg == null ? "" : errorMsg);
            returnMap.put("successpkids", operationResult.getSuccessPkIds());
            return returnMap;
        }
        return null;
    }

    public int getRedisTimeLong() {
        return EstimateUtils.getRedisTimeLong();
    }

    public boolean isBatchCompute() {
        return PdmParamSetHelper.getBooleanParamValue((String)"ECNEstimate_IsBatchCompute");
    }

    public String getConsumerQueue() {
        return PdmParamSetHelper.getStringParamValue((String)"ECNEstimate_ConsumerQueue");
    }

    public int getMateriaBatchCount() {
        return PdmParamSetHelper.getIntParamValue((String)"ECNEstimate_OneBatchCount");
    }

    public int getSRBatchCount() {
        return PdmParamSetHelper.getIntParamValue((String)"ECNEstimateSR_OneBatchCount");
    }

    public int getEffectOrderBatchCount() {
        return PdmParamSetHelper.getIntParamValue((String)"ECNEstimateEffOrder_OneBatchCount");
    }

    public String getRequireDataAmountCacheString() {
        return this.getEstimateKey() + "-requiredataamount";
    }

    public String getSRResultCacheString01() {
        return this.getEstimateKey() + "-srresult-01";
    }

    public String getSRResultCacheString02() {
        return this.getEstimateKey() + "-srresult-02";
    }

    public String getSRResultCacheString03() {
        return this.getEstimateKey() + "-srresult-03";
    }

    public String getSRResultCacheString04() {
        return this.getEstimateKey() + "-srresult-04";
    }

    public String getEffectOrderIdCacheString() {
        return this.getEstimateKey() + "-effectorder-ecobomentry";
    }

    public String getEffectOrderSucessCacheString() {
        return this.getEstimateKey() + "-effectorder-successsize";
    }

    public String getEffectOrderAllSizeCacheString() {
        return this.getEstimateKey() + "-effectorder-allsize";
    }

    public String getEffectOrderMsgCacheString() {
        return this.getEstimateKey() + "-effectorder-errormsg";
    }

    public JSONArray getAllSupplyArray(Set<String> supAndReqKeySet) {
        JSONArray allSupplyArray = new JSONArray(16);
        if (supAndReqKeySet == null || supAndReqKeySet.isEmpty()) {
            return allSupplyArray;
        }
        for (String cacheKeyString : supAndReqKeySet) {
            String supplyKeys = this.getSupplyCacheString(cacheKeyString);
            String supplys = this.getCacheValue(supplyKeys);
            JSONArray supplyArray = JSONObject.parseArray((String)supplys);
            if (supplyArray == null || supplyArray.isEmpty()) continue;
            allSupplyArray.addAll((Collection)supplyArray);
        }
        return allSupplyArray;
    }

    public JSONArray getAllRequireArray(Set<String> supAndReqKeySet) {
        JSONArray allRequireArray = new JSONArray(16);
        if (supAndReqKeySet == null || supAndReqKeySet.isEmpty()) {
            return allRequireArray;
        }
        for (String cacheKeyString : supAndReqKeySet) {
            String supplyKeys = this.getRequireCacheString(cacheKeyString);
            String requires = this.getCacheValue(supplyKeys);
            JSONArray requireArray = JSONObject.parseArray((String)requires);
            if (requireArray == null || requireArray.isEmpty()) continue;
            allRequireArray.addAll((Collection)requireArray);
        }
        return allRequireArray;
    }

    public Date getDefaultDate() {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return sdf.parse("2999-12-31 59:59:59");
        }
        catch (ParseException e) {
            log.error((Throwable)e);
            return null;
        }
    }

    public int getIntegerCacheValue(String keyString) {
        String value = this.getCacheValue(keyString);
        return StringUtils.isEmpty((String)value) ? 0 : Integer.parseInt(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getAndSetAddCacheValueLock(Map<String, String> envCacheMap, String keyString, Object value, int redisTimeLong) {
        String lockKeys = "mmc_pdm_ecoestimate_getAndSetCacheValueLock_" + keyString;
        DLock lock = DLock.create((String)lockKeys, (String)lockKeys);
        lock.lock();
        try {
            if (value instanceof String) {
                String oldValue = this.getCacheValue(keyString);
                String newValue = (oldValue == null ? "" : oldValue) + " " + value;
                this.setCacheValue(envCacheMap, keyString, newValue, redisTimeLong);
            } else if (value instanceof Integer) {
                int oldValue = this.getIntegerCacheValue(keyString);
                int newValue = (Integer)value + oldValue;
                this.setCacheValue(envCacheMap, keyString, String.valueOf(newValue), redisTimeLong);
            }
        }
        finally {
            lock.unlock();
        }
    }

    public void setCacheValue(Map<String, String> envCacheMap, String keyString, String value, int timeLong) {
        if (timeLong <= 0) {
            timeLong = this.getRedisTimeLong();
        }
        if (this.getRedisByteMode()) {
            byte[] bs = PlatformUtils.encode((Object)value);
            this.redisCache.put(keyString, bs, timeLong);
        } else {
            this.redisCache.put(keyString, (Object)value, timeLong);
        }
        if (envCacheMap != null) {
            String cacheValue = envCacheMap.get(this.getPlatMapKey());
            if (!StringUtils.isEmpty((String)(cacheValue = this.unionStr(cacheValue, keyString)))) {
                envCacheMap.put(this.getPlatMapKey(), this.unionStr(cacheValue, keyString));
            }
        }
    }

    public void addTaskLog(String taskId) {
        Long id = ORM.create().genLongId("pdm_ecoestimate_result");
        String insertSql = "insert into T_PDM_ESTIMATELOGTASK (fid, flogid,ftaskid) values (?, ?,?)";
        DB.execute((DBRoute)scmDBRoute, (String)insertSql, (Object[])new Object[]{id, this.logId, taskId});
    }

    public boolean getRedisByteMode() {
        if (this.IS_REDISBYTEMODE == null) {
            boolean mode = EstimateUtils.getRedisByteMode();
            this.IS_REDISBYTEMODE = mode ? "true" : "false";
        }
        return "true".equalsIgnoreCase(this.IS_REDISBYTEMODE);
    }

    public String saveResult(List<DynamicObject> resultList) {
        String errorString;
        OperateOption option = this.getOperateOption();
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"pdm_ecoestimate_result", (DynamicObject[])resultList.toArray(new DynamicObject[resultList.size()]), (OperateOption)option);
        if (saveResult.getAllErrorOrValidateInfo() != null && !StringUtils.isEmpty((String)(errorString = PlatformUtils.getErrorMsg((OperationResult)saveResult)))) {
            String errorStr = String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u8fd0\u7b97\u7ed3\u679c\u65f6\u53d1\u751f\u9519\u8bef\uff1a%1$s\u3002", (String)"EcoEstimateBaseStep_0", (String)"mmc-pdm-business", (Object[])new Object[0]), errorString);
            throw new KDBizException(errorStr);
        }
        return "";
    }

    public OperateOption getOperateOption() {
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("ignorewarn", "true");
        option.setVariableValue("ignoreinteraction", "true");
        option.setVariableValue("batchop_batchsize", "50");
        return option;
    }

    public void genMulMaterialValue(Long materialId, DynamicObject head) {
        DynamicObjectCollection dyColl = head.getDynamicObjectCollection("mulmaterial");
        if (dyColl == null) {
            dyColl = new DynamicObjectCollection();
        }
        for (int i = 0; i < dyColl.size(); ++i) {
            DynamicObject dy = (DynamicObject)dyColl.get(i);
            Long existsMaterialId = (Long)dy.getDynamicObject("fbasedataid").getPkValue();
            if (!existsMaterialId.equals(materialId)) continue;
            return;
        }
        DynamicObjectType dynamicObjectType = dyColl.getDynamicObjectType();
        DynamicObject mulBasedataDy = new DynamicObject(dynamicObjectType);
        DynamicObject payBizActDy = BusinessDataServiceHelper.newDynamicObject((String)"bd_material");
        payBizActDy.set("id", (Object)materialId);
        mulBasedataDy.set("fbasedataid", (Object)payBizActDy);
        dyColl.add((Object)mulBasedataDy);
        head.set("mulmaterial", (Object)dyColl);
    }

    public String getBillTypeName(Long billId) {
        if (PlatformUtils.isNullLong((Long)billId)) {
            return ResManager.loadKDString((String)"\u5373\u65f6\u5e93\u5b58", (String)"EcoEstimateBaseStep_01", (String)"mmc-pdm-business", (Object[])new Object[0]);
        }
        DynamicObject dy = BusinessDataServiceHelper.loadSingleFromCache((Object)billId, (String)"bos_billtype", (String)"name");
        if (dy != null) {
            return dy.getString("name");
        }
        return "";
    }

    public boolean isMergeRquireData() {
        return PdmParamSetHelper.getBooleanParamValue((String)"ECNEstimate_IsMergeRequireData");
    }

    public boolean isClearRquireEntryData() {
        return PdmParamSetHelper.getBooleanParamValue((String)"ECNEstimate_IsClearRequireEntryData");
    }
}

