/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.business.ecoplatform.estimate.step;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.mmc.pdm.business.ecoplatform.EcoUtils;
import kd.mmc.pdm.business.ecoplatform.estimate.step.EcoEstimateBaseStep;
import kd.mmc.pdm.business.ecoplatform.estimate.step.EcoExceptionModel;
import kd.mmc.pdm.common.bom.ecoplatform.PlatformUtils;
import kd.mpscmm.msplan.mservice.service.datafetch.util.DataSourceFetchDataUtil;
import kd.mpscmm.msplan.mservice.service.mrp.ExecutionEnv;

public class EcoEstimateGetSupplyData
extends EcoEstimateBaseStep {
    private static final Log log = LogFactory.getLog(EcoEstimateGetSupplyData.class);
    private static final String NULLREFNOVALUE = "nullvalue";
    private static final String APPNUM = "mmc-pdm-business";

    @Override
    public String doWork(ExecutionEnv env, int stepIdx) {
        super.doWork(env, stepIdx);
        try {
            int dataAmount = 0;
            DynamicObject planProgram = this.getPlanProgram();
            DataSet dataSet = this.fetchDataBySetId(planProgram);
            if (dataSet == null) {
                return ResManager.loadKDString((String)"\u672a\u627e\u5230\u4f9b\u5e94\u6570\u636e\u3002", (String)"EcoEstimateGetSupplyData_12", (String)APPNUM, (Object[])new Object[0]);
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            dataSet = this.formatEntryEntity(dataSet);
            Set<Object> materialIdSet = new HashSet(128);
            HashSet<String> rsSet = new HashSet<String>(128);
            HashSet<String> rs2Set = new HashSet<String>(128);
            JSONObject supObject = new JSONObject();
            RowMeta rowMeta = dataSet.getRowMeta();
            String[] fieldNames = rowMeta.getFieldNames();
            String[] keyFieldNames = this.getSupplyCacheRedisKeyField(planProgram);
            Date minSupplyDate = null;
            HashMap<String, Set<Long>> featureMaterialCacheMap = new HashMap<String, Set<Long>>(16);
            boolean supQtyZeroIsException = this.chkSupQtyZeroIsException(planProgram);
            HashSet<Long> allmIdSet = new HashSet<Long>(64);
            HashSet<Long> allEcoBomEntryIdSet = new HashSet<Long>(64);
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                if (row.getDate("billdate") == null) continue;
                Long featureType = row.getLong("featuretype");
                Long orgId = row.getLong("supplyorgunit");
                Set<Object> fmIdSet = new HashSet<Long>(16);
                if (!PlatformUtils.isNullLong((Long)featureType)) {
                    fmIdSet = this.getFeatureMaterial(featureType, orgId, featureMaterialCacheMap);
                } else {
                    fmIdSet.add(row.getLong("material"));
                }
                if (fmIdSet.isEmpty()) {
                    log.info("---------EcoEstimateGetSupplyData not find material -------------row:" + row.toString());
                    continue;
                }
                for (Long l : fmIdSet) {
                    String cacheKeyString = this.getRowKeyString(row, keyFieldNames, l);
                    JSONObject dataObject = new JSONObject();
                    for (int keySize = 0; keySize < fieldNames.length; ++keySize) {
                        String fieldName = fieldNames[keySize];
                        Object value = row.get(fieldName);
                        dataObject.put(fieldName, value);
                    }
                    dataObject.put("exceptiontype", (Object)"A");
                    dataObject.put("exceptioninfo", (Object)"");
                    dataObject.put("exceptionkeyset", null);
                    dataObject.put("material", (Object)l);
                    dataObject.put("supandreqkey", (Object)cacheKeyString);
                    JSONArray list = supObject.getJSONArray(cacheKeyString);
                    if (list == null) {
                        list = new JSONArray();
                    }
                    list.add((Object)dataObject);
                    supObject.put(cacheKeyString, (Object)list);
                    rsSet.add(cacheKeyString);
                    if (supQtyZeroIsException) {
                        if (dataObject.getBigDecimal("qty").compareTo(BigDecimal.ZERO) > 0) {
                            rs2Set.add(cacheKeyString);
                        }
                    } else {
                        rs2Set.add(cacheKeyString);
                    }
                    if (minSupplyDate == null) {
                        minSupplyDate = dataObject.getDate("billdate");
                    } else if (minSupplyDate.after(dataObject.getDate("billdate"))) {
                        minSupplyDate = dataObject.getDate("billdate");
                    }
                    allEcoBomEntryIdSet.add(dataObject.getLong("ecobomentryid"));
                }
                allmIdSet.addAll(fmIdSet);
                ++dataAmount;
            }
            dataSet.close();
            int redisTimeLong = this.getRedisTimeLong();
            Map<String, Integer> errorMap = this.exceptionDeal(rs2Set, rsSet, supObject, supQtyZeroIsException, allmIdSet, allEcoBomEntryIdSet);
            materialIdSet = this.getNormalMaterialIdSet(rsSet, supObject);
            this.setCacheValue(env, this.getMaterialIdCacheString(), materialIdSet.toString(), redisTimeLong);
            this.setCacheValue(env, this.getReqSupCacheString(), ((Object)rsSet).toString(), redisTimeLong);
            this.setCacheValue(env, this.getMinSupplyDateCacheString(), minSupplyDate == null ? "" : sdf.format(minSupplyDate), redisTimeLong);
            for (String cacheKeyString : rsSet) {
                JSONArray list = supObject.getJSONArray(cacheKeyString);
                if (list == null || list.isEmpty()) continue;
                this.setCacheValue(env, this.getSupplyCacheString(cacheKeyString), list.toJSONString(), redisTimeLong);
            }
            this.updateLogCount(stepIdx, dataAmount);
            int errorCount = errorMap == null ? 0 : errorMap.get("errorCount");
            int repeatCount = errorMap == null ? 0 : errorMap.get("repeatCount");
            String resultStr = String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u201c%1$s\u201d\u6761\u3002\u4f8b\u5916\u201c%2$s\u201d\u6761\u3002\u91cd\u590d\u201c%3$s\u201d\u6761\u3002", (String)"EcoEstimateGetSupplyData_13", (String)APPNUM, (Object[])new Object[0]), dataAmount, errorCount, repeatCount);
            return resultStr;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            this.clearCacheValue(env);
            throw e;
        }
    }

    public Set<Long> getNormalMaterialIdSet(Set<String> rsSet, JSONObject supObject) {
        HashSet<Long> materialIdSet = new HashSet<Long>(64);
        for (String keyStrig : rsSet) {
            JSONArray supArray = supObject.getJSONArray(keyStrig);
            if (supArray == null || supArray.isEmpty()) continue;
            int supSize = supArray.size();
            for (int i = 0; i < supSize; ++i) {
                JSONObject ecoObject = supArray.getJSONObject(i);
                Long materialId = ecoObject.getLong("material");
                if (this.isExceptionError(ecoObject)) continue;
                materialIdSet.add(materialId);
            }
        }
        return materialIdSet;
    }

    public Map<Long, String> getNotExistsMftBomEntryMap(Set<Long> ecoBomEntryIdSet) {
        HashMap<Long, String> errorMap = new HashMap<Long, String>(16);
        Set<Long> allEcoBomEntryIdSet = EcoUtils.getAllEcoBomEntryIdSet(ecoBomEntryIdSet);
        QFilter filter = new QFilter("entryid", "in", allEcoBomEntryIdSet);
        HashMap<Long, Long> mftBom2EcoBomMap = new HashMap<Long, Long>(allEcoBomEntryIdSet.size());
        DynamicObjectCollection ecoBomEntryColl = QueryServiceHelper.query((String)"pdm_ecobom_entryf7", (String)"entryid,bomentry", (QFilter[])new QFilter[]{filter});
        for (DynamicObject ecoBomEntry : ecoBomEntryColl) {
            mftBom2EcoBomMap.put(ecoBomEntry.getLong("bomentry"), ecoBomEntry.getLong("entryid"));
        }
        HashSet<Long> errorEcoBomEntryIdSet = new HashSet<Long>(16);
        Set mftBomEntryIdSetA = ecoBomEntryColl.stream().map(p -> p.getLong("bomentry")).collect(Collectors.toSet());
        if (!mftBomEntryIdSetA.isEmpty()) {
            DynamicObjectCollection mftBomEntryColl = QueryServiceHelper.query((String)"pdm_mftbom", (String)"entry.id entryid", (QFilter[])new QFilter[]{new QFilter("entry.id", "in", mftBomEntryIdSetA)});
            Set mftBomEntryIdSetB = mftBomEntryColl.stream().map(p -> p.getLong("entryid")).collect(Collectors.toSet());
            for (Long mftBomEntryId : mftBomEntryIdSetA) {
                Long ecoBomEntryId;
                if (mftBomEntryIdSetB.contains(mftBomEntryId) || (ecoBomEntryId = (Long)mftBom2EcoBomMap.get(mftBomEntryId)) == null) continue;
                errorEcoBomEntryIdSet.add(ecoBomEntryId);
            }
        }
        if (!errorEcoBomEntryIdSet.isEmpty()) {
            HashMap<Long, Set<Long>> cacheAllRefIdMap = new HashMap<Long, Set<Long>>(16);
            Map<Long, String> descMap = this.getNotMftBomDesc(errorEcoBomEntryIdSet);
            for (Long ecoBomEntryId : ecoBomEntryIdSet) {
                String desc = descMap.get(ecoBomEntryId);
                if (!errorEcoBomEntryIdSet.contains(ecoBomEntryId)) {
                    Set<Long> refEntryIdSet = EcoUtils.getAllEcoBomEntryIdSet(ecoBomEntryId, cacheAllRefIdMap);
                    desc = this.getRefDesc(refEntryIdSet, errorEcoBomEntryIdSet, descMap);
                }
                if (StringUtils.isEmpty((String)desc)) continue;
                errorMap.put(ecoBomEntryId, desc);
            }
        }
        return errorMap;
    }

    public String getRefDesc(Set<Long> refEntryIdSet, Set<Long> errorEcoBomEntryIdSet, Map<Long, String> descMap) {
        StringBuilder msg = new StringBuilder();
        for (Long id : refEntryIdSet) {
            String desc;
            if (!errorEcoBomEntryIdSet.contains(id) || StringUtils.isEmpty((String)(desc = descMap.get(id)))) continue;
            msg.append(desc);
        }
        return msg.toString();
    }

    public Map<Long, String> getNotMftBomDesc(Set<Long> ecoBomEntryIdSet) {
        HashMap<Long, String> descMap = new HashMap<Long, String>(ecoBomEntryIdSet.size());
        HashMap<Long, DynamicObject> billNoMap = new HashMap<Long, DynamicObject>(16);
        QFilter filter = new QFilter("entryid", "in", ecoBomEntryIdSet);
        String sp = "entrymaterial.number materialnumber,entryid,entrymode,featuretype.number featurenumber,ecobomid";
        DynamicObjectCollection ecoBomEntryColl = QueryServiceHelper.query((String)"pdm_ecobom_entryf7", (String)sp, (QFilter[])new QFilter[]{filter});
        String msg = ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u5355%1$s\u7684\u7ec4\u4ef6\u5206\u5f55\u4e2d\uff08\u884c\u6807\u8bc6\u4e3a\u201c%2$s\u201d\uff09\uff0c\u7ec4\u4ef6\u7f16\u7801%3$s\u5bf9\u5e94\u7684BOM\u7ef4\u62a4\u6570\u636e\uff08%4$s\uff09\u4e0d\u5b58\u5728\u3002", (String)"EcoEstimateGetSupplyData_18", (String)APPNUM, (Object[])new Object[0]);
        for (DynamicObject ecoBomEntry : ecoBomEntryColl) {
            DynamicObject ecnBill = EcoUtils.getEcoBillDynamicObject(ecoBomEntry.getLong("ecobomid"), billNoMap);
            String materialNumber = ecoBomEntry.getString("materialnumber");
            String featurenumber = ecoBomEntry.getString("featurenumber");
            String ecnBillno = ecnBill.getString("billno");
            DynamicObject pentry = EcoUtils.getEcoPEntry(ecnBill, ecoBomEntry.getLong("ecobomid"));
            String bomNumber = pentry == null || pentry.getDynamicObject("pentrybom") == null ? "" : pentry.getDynamicObject("pentrybom").getString("number");
            String desc = String.format(msg, ecnBillno, this.getEntryModeMsg(ecoBomEntry.getString("entrymode")), StringUtils.isEmpty((String)materialNumber) ? featurenumber : materialNumber, bomNumber);
            descMap.put(ecoBomEntry.getLong("entryid"), desc);
        }
        return descMap;
    }

    private String getEntryModeMsg(String entryMode) {
        return "E".equals(entryMode) ? ResManager.loadKDString((String)"\u5931\u6548", (String)"EcoEstimateGetSupplyData_19", (String)APPNUM, (Object[])new Object[0]) : ("A".equals(entryMode) ? ResManager.loadKDString((String)"\u65b0\u589e", (String)"EcoEstimateGetSupplyData_20", (String)APPNUM, (Object[])new Object[0]) : ("B".equals(entryMode) ? ResManager.loadKDString((String)"\u4fee\u6539\u524d", (String)"EcoEstimateGetSupplyData_21", (String)APPNUM, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4fee\u6539\u540e", (String)"EcoEstimateGetSupplyData_22", (String)APPNUM, (Object[])new Object[0])));
    }

    public Map<String, Integer> exceptionDeal(Set<String> rsSet, Set<String> rsSetAll, JSONObject supObject, boolean supQtyZeroIsException, Set<Long> allmIdSet, Set<Long> ecoBomEntryIdSet) {
        String entryRefno;
        Long ecoPentryid;
        String entryMode;
        String entryGroupNo;
        Long ecoBomEntryId;
        JSONObject ecoObject;
        int i;
        int supSize;
        JSONArray supArray;
        HashMap<String, String> chk1Map = new HashMap<String, String>(16);
        HashMap chk2Map = new HashMap(16);
        HashMap<String, JSONObject> repeatDataMap = new HashMap<String, JSONObject>(16);
        HashMap<String, EcoExceptionModel> chk3Map = new HashMap<String, EcoExceptionModel>(16);
        HashSet<Long> errorCountSet = new HashSet<Long>(16);
        HashSet<Long> repeatCountSet = new HashSet<Long>(16);
        HashMap<String, HashSet<String>> chk4Map = new HashMap<String, HashSet<String>>(16);
        HashMap<String, String> chk5Map = new HashMap<String, String>(16);
        HashMap<String, EcoExceptionModel> errorGroupKeyMap = new HashMap<String, EcoExceptionModel>(16);
        HashMap<String, EcoExceptionModel> errorRefKeyMap = new HashMap<String, EcoExceptionModel>(16);
        HashMap<String, EcoExceptionModel> errorKeyMap = new HashMap<String, EcoExceptionModel>(16);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        HashMap<String, Boolean> hasGroupKeyMap = new HashMap<String, Boolean>(16);
        HashMap<String, Boolean> hasRefKeyMap = new HashMap<String, Boolean>(16);
        HashMap<String, EcoExceptionModel> errorMaterialSMap = new HashMap<String, EcoExceptionModel>(16);
        String repeatMsgInfo = ResManager.loadKDString((String)"\u53bb\u91cd\u5904\u7406", (String)"EcoEstimateGetSupplyData_07", (String)APPNUM, (Object[])new Object[0]);
        Map<Object, DynamicObject> materialMap = this.getMaterialMap(allmIdSet);
        Map<Long, String> notMftBomMap = this.getNotExistsMftBomEntryMap(ecoBomEntryIdSet);
        for (String keyStrig : rsSet) {
            supArray = supObject.getJSONArray(keyStrig);
            if (supArray == null || supArray.isEmpty()) continue;
            supSize = supArray.size();
            for (i = 0; i < supSize; ++i) {
                EcoExceptionModel exceptionModel;
                String exceptionInfo;
                ecoObject = supArray.getJSONObject(i);
                ecoBomEntryId = ecoObject.getLong("ecobomentryid");
                entryGroupNo = ecoObject.getString("entrygroupno");
                String entryRefNo = ecoObject.getString("entryrefno");
                Long ecoPentryid2 = ecoObject.getLong("billentryid");
                entryMode = ecoObject.getString("entrymode");
                BigDecimal supplyQty = ecoObject.getBigDecimal("qty");
                Date tranStartDate = ecoObject.getDate("billdate");
                boolean isRefKey = ecoObject.getBoolean("refkey");
                boolean isGroupKey = ecoObject.getBoolean("groupkey");
                boolean isCanEstimate = ecoObject.getBoolean("iscanestimate");
                boolean isEffectSameKeyString = supQtyZeroIsException && supplyQty.compareTo(BigDecimal.ZERO) <= 0;
                String materialNumber = this.getMaterialNumber(materialMap, ecoObject);
                if (notMftBomMap.containsKey(ecoBomEntryId)) {
                    exceptionInfo = notMftBomMap.get(ecoBomEntryId);
                    String exceptionKey = "EcoEstimateGetSupplyData_00";
                    exceptionModel = new EcoExceptionModel(exceptionInfo, exceptionKey);
                    this.setResultErrorData(ecoObject, exceptionModel);
                    errorCountSet.add(ecoBomEntryId);
                }
                if (!PlatformUtils.isNullString((String)entryGroupNo)) {
                    HashSet<String> entryModeSet;
                    String groupKeyString = PlatformUtils.getUnionString((Object)ecoPentryid2, (Object)entryGroupNo);
                    if (!PlatformUtils.isNullString((String)entryRefNo)) {
                        String refNo = (String)chk1Map.get(groupKeyString);
                        if (PlatformUtils.isNullString((String)refNo)) {
                            chk1Map.put(groupKeyString, entryRefNo);
                            refNo = entryRefNo;
                        }
                        if (!(PlatformUtils.isNullString((String)refNo) || PlatformUtils.isNullString((String)entryRefNo) || refNo.equals(entryRefNo))) {
                            String exceptionInfo2 = String.format(ResManager.loadKDString((String)"\u540c\u7ec4\u7269\u6599\uff08%1$s\uff09\u5173\u8054\u5b9e\u65bd\u53f7\uff08%2$s\u3001%3$s\uff09\u4e0d\u4e00\u6837\uff0c\u4e0d\u8fdb\u884c\u8bc4\u4f30\u3002", (String)"EcoEstimateGetSupplyData_01", (String)APPNUM, (Object[])new Object[0]), materialNumber, refNo.replace(NULLREFNOVALUE, ""), entryRefNo.replace(NULLREFNOVALUE, ""));
                            String exceptionKey = "EcoEstimateGetSupplyData_01";
                            EcoExceptionModel exceptionModel2 = new EcoExceptionModel(exceptionInfo2, exceptionKey);
                            this.setResultErrorData(ecoObject, exceptionModel2);
                            errorGroupKeyMap.put(groupKeyString, exceptionModel2);
                            errorRefKeyMap.put(entryRefNo, exceptionModel2);
                            errorCountSet.add(ecoBomEntryId);
                        }
                    }
                    if ((entryModeSet = (HashSet<String>)chk4Map.get(groupKeyString)) == null) {
                        entryModeSet = new HashSet<String>(16);
                    }
                    entryModeSet.add(entryMode);
                    chk4Map.put(groupKeyString, entryModeSet);
                    if (!hasGroupKeyMap.containsKey(groupKeyString)) {
                        hasGroupKeyMap.put(groupKeyString, false);
                    }
                    if (isGroupKey) {
                        hasGroupKeyMap.put(groupKeyString, true);
                    }
                }
                if (!PlatformUtils.isNullString((String)entryRefNo)) {
                    if (!hasRefKeyMap.containsKey(entryRefNo)) {
                        hasRefKeyMap.put(entryRefNo, false);
                    }
                    if (isRefKey) {
                        hasRefKeyMap.put(entryRefNo, true);
                    }
                }
                if (supSize > 1) {
                    String materialKeyString;
                    String refNo;
                    String oldEntryRefNo = entryRefNo;
                    if (PlatformUtils.isNullString((String)entryRefNo)) {
                        entryRefNo = NULLREFNOVALUE;
                    }
                    if (PlatformUtils.isNullString((String)(refNo = (String)chk5Map.get(materialKeyString = PlatformUtils.getUnionString((Object)keyStrig, (Object)entryMode))))) {
                        chk5Map.put(materialKeyString, entryRefNo);
                        refNo = entryRefNo;
                    }
                    if (!(PlatformUtils.isNullString((String)refNo) || PlatformUtils.isNullString((String)entryRefNo) || refNo.equals(entryRefNo))) {
                        String exceptionInfo3 = String.format(ResManager.loadKDString((String)"\u540c\u4e00\u7269\u6599\uff08%1$s\uff09\u53ca\u884c\u6807\u8bc6\u4e0b\uff0c\u5173\u8054\u53d8\u66f4\uff08%2$s\u3001%3$s\uff09\u4e0d\u7edf\u4e00\uff0c\u4e0d\u8fdb\u884c\u8bc4\u4f30\u3002", (String)"EcoEstimateGetSupplyData_04", (String)APPNUM, (Object[])new Object[0]), materialNumber, refNo, entryRefNo);
                        String exceptionKey = "EcoEstimateGetSupplyData_04";
                        EcoExceptionModel exceptionModel3 = new EcoExceptionModel(exceptionInfo3, exceptionKey);
                        this.setResultErrorData(ecoObject, exceptionModel3);
                        if (!isEffectSameKeyString) {
                            errorMaterialSMap.put(materialKeyString, exceptionModel3);
                        }
                        errorRefKeyMap.put(refNo, exceptionModel3);
                        errorRefKeyMap.put(entryRefNo, exceptionModel3);
                        if (!PlatformUtils.isNullString((String)entryGroupNo)) {
                            String groupKeyString = PlatformUtils.getUnionString((Object)ecoPentryid2, (Object)entryGroupNo);
                            errorGroupKeyMap.put(groupKeyString, exceptionModel3);
                        }
                        errorCountSet.add(ecoBomEntryId);
                    }
                    entryRefNo = oldEntryRefNo;
                }
                if (supSize > 1) {
                    HashMap<String, Comparable<BigDecimal>> existsMap = (HashMap<String, Comparable<BigDecimal>>)chk2Map.get(keyStrig);
                    boolean isfirst = Boolean.FALSE;
                    if (existsMap == null) {
                        existsMap = new HashMap<String, Comparable<BigDecimal>>(16);
                        existsMap.put("qty", supplyQty);
                        existsMap.put("billdate", tranStartDate);
                        existsMap.put("ecobomentryid", ecoBomEntryId);
                        chk2Map.put(keyStrig, existsMap);
                        repeatDataMap.put(keyStrig, ecoObject);
                        isfirst = Boolean.TRUE;
                    } else {
                        Long ecoBomEntryId2;
                        Date sameTranStartDate;
                        BigDecimal sameTranQty = (BigDecimal)existsMap.get("qty");
                        if (sameTranQty == null) {
                            existsMap.put("qty", supplyQty);
                            sameTranQty = supplyQty;
                        }
                        if ((sameTranStartDate = (Date)existsMap.get("billdate")) == null) {
                            existsMap.put("billdate", tranStartDate);
                            sameTranStartDate = tranStartDate;
                        }
                        if (!(ecoBomEntryId2 = Long.valueOf(Long.parseLong(existsMap.get("ecobomentryid").toString()))).equals(ecoBomEntryId)) {
                            EcoExceptionModel exceptionModel4;
                            String exceptionKey;
                            String exceptionInfo4;
                            boolean isTranQtyDiff = this.isTranQtyDifferent(sameTranQty, supplyQty);
                            boolean isTranStartDateDiff = this.isTranStartDateDifferent(sameTranStartDate, tranStartDate, sdf);
                            if (isTranQtyDiff) {
                                exceptionInfo4 = String.format(ResManager.loadKDString((String)"\u5b58\u5728\u4e00\u6837\u7684\u8fc7\u6e21\u7269\u6599\uff08%1$s\uff09\uff0c\u5f85\u6d88\u8017\u6570\u91cf\u4e0d\u4e00\u6837\uff08%2$s\u3001%3$s\uff09\uff0c\u4e0d\u8fdb\u884c\u8bc4\u4f30\u3002", (String)"EcoEstimateGetSupplyData_05", (String)APPNUM, (Object[])new Object[0]), materialNumber, sameTranQty, supplyQty);
                                exceptionKey = "EcoEstimateGetSupplyData_05";
                                exceptionModel4 = new EcoExceptionModel(exceptionInfo4, exceptionKey);
                                this.addTranDiffException(exceptionModel4, errorKeyMap, ecoObject, keyStrig, errorRefKeyMap, errorGroupKeyMap, errorCountSet);
                            }
                            if (isTranStartDateDiff) {
                                exceptionInfo4 = String.format(ResManager.loadKDString((String)"\u5b58\u5728\u4e00\u6837\u7684\u8fc7\u6e21\u7269\u6599\uff08%1$s\uff09\uff0c\u5f00\u59cb\u8fc7\u6e21\u65f6\u95f4\u4e0d\u4e00\u6837\uff08%2$s\u3001%3$s\uff09\uff0c\u4e0d\u8fdb\u884c\u8bc4\u4f30\u3002", (String)"EcoEstimateGetSupplyData_15", (String)APPNUM, (Object[])new Object[0]), materialNumber, sdf.format(sameTranStartDate), sdf.format(tranStartDate));
                                exceptionKey = "EcoEstimateGetSupplyData_15";
                                exceptionModel4 = new EcoExceptionModel(exceptionInfo4, exceptionKey);
                                this.addTranDiffException(exceptionModel4, errorKeyMap, ecoObject, keyStrig, errorRefKeyMap, errorGroupKeyMap, errorCountSet);
                            }
                            if (!(isTranQtyDiff || isTranStartDateDiff || isfirst)) {
                                JSONObject repeatData = ecoObject;
                                if (ecoObject.getBoolean("refkey").booleanValue() || ecoObject.getBoolean("groupkey").booleanValue()) {
                                    if (repeatDataMap.get(keyStrig) != null) {
                                        repeatData = (JSONObject)repeatDataMap.get(keyStrig);
                                    }
                                    repeatDataMap.put(keyStrig, ecoObject);
                                }
                                repeatData.put("exceptiontype", (Object)"B");
                                repeatData.put("exceptioninfo", (Object)repeatMsgInfo);
                                repeatCountSet.add(repeatData.getLong("ecobomentryid"));
                            }
                        }
                    }
                }
                if (isCanEstimate) continue;
                exceptionInfo = String.format(ResManager.loadKDString((String)"\u540c\u7ec4\u6570\u636e\u4e2d\u7269\u6599\uff08%1$s\uff09\u5b58\u5728\u8fde\u7eed\u65ad\u70b9\u6570\u636e\uff0c\u4e0d\u8fdb\u884c\u8bc4\u4f30\u3002", (String)"EcoEstimateGetSupplyData_11", (String)APPNUM, (Object[])new Object[0]), materialNumber);
                String exceptionKey = "EcoEstimateGetSupplyData_11";
                exceptionModel = new EcoExceptionModel(exceptionInfo, exceptionKey);
                this.setResultErrorData(ecoObject, exceptionModel);
                if (!PlatformUtils.isNullString((String)entryRefNo)) {
                    errorRefKeyMap.put(entryRefNo, exceptionModel);
                }
                if (!PlatformUtils.isNullString((String)entryGroupNo)) {
                    String groupKeyString = PlatformUtils.getUnionString((Object)ecoPentryid2, (Object)entryGroupNo);
                    errorGroupKeyMap.put(groupKeyString, exceptionModel);
                }
                errorCountSet.add(ecoBomEntryId);
            }
        }
        for (String keyStrig : rsSet) {
            supArray = supObject.getJSONArray(keyStrig);
            if (supArray == null || supArray.isEmpty()) continue;
            supSize = supArray.size();
            for (i = 0; i < supSize; ++i) {
                String materialKeyString;
                EcoExceptionModel exceptionModel;
                String exceptionKey;
                String exceptionInfo;
                EcoExceptionModel exceptionModel5;
                String exceptionKey2;
                String groupkeyString;
                ecoObject = supArray.getJSONObject(i);
                ecoBomEntryId = ecoObject.getLong("ecobomentryid");
                entryGroupNo = ecoObject.getString("entrygroupno");
                ecoPentryid = ecoObject.getLong("billentryid");
                entryRefno = ecoObject.getString("entryrefno");
                entryMode = ecoObject.getString("entrymode");
                String ecoDesc = this.getEcoBillDesc(materialMap, ecoObject);
                if (!PlatformUtils.isNullString((String)entryGroupNo)) {
                    EcoExceptionModel exceptionModel6;
                    String exceptionKey3;
                    String exceptionInfo5;
                    EcoExceptionModel srcModel;
                    boolean hasGroupKey;
                    groupkeyString = ecoPentryid + "_" + entryGroupNo;
                    Set entrymodeSet = (Set)chk4Map.get(groupkeyString);
                    if (entrymodeSet != null && (entrymodeSet.contains("B") || entrymodeSet.contains("C"))) {
                        String exceptionInfo6 = String.format(ResManager.loadKDString((String)"%1$s\u5b58\u5728\u6210\u7ec4\u53f7\uff0c\u4f46\u884c\u6807\u8bc6\u4e0d\u4e3a\u65b0\u589e\u6216\u5931\u6548\u3002", (String)"EcoEstimateGetSupplyData_17", (String)APPNUM, (Object[])new Object[0]), ecoDesc);
                        exceptionKey2 = "EcoEstimateGetSupplyData_17";
                        exceptionModel5 = new EcoExceptionModel(exceptionInfo6, exceptionKey2);
                        chk3Map.put(groupkeyString, exceptionModel5);
                    }
                    if (!(hasGroupKey = ((Boolean)hasGroupKeyMap.get(groupkeyString)).booleanValue())) {
                        exceptionInfo = String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u6210\u7ec4\u4e3b\u952e\u6570\u636e\u3002", (String)"EcoEstimateGetSupplyData_09", (String)APPNUM, (Object[])new Object[0]), entryGroupNo);
                        exceptionKey = "EcoEstimateGetSupplyData_09";
                        exceptionModel = new EcoExceptionModel(exceptionInfo, exceptionKey);
                        this.setResultErrorData(ecoObject, exceptionModel);
                        chk3Map.put(groupkeyString, exceptionModel);
                        errorCountSet.add(ecoBomEntryId);
                    }
                    if (this.isGroupError(chk3Map, groupkeyString)) {
                        srcModel = (EcoExceptionModel)chk3Map.get(groupkeyString);
                        exceptionInfo5 = String.format(ResManager.loadKDString((String)"\u540c\u7ec4(\u6210\u7ec4\u53f7)\u5b58\u5728\u6570\u636e\u4e0d\u6ee1\u8db3\u8bc4\u4f30\u8981\u6c42\uff08%1$s\uff09\uff0c\u4e0d\u8fdb\u884c\u8bc4\u4f30\u3002", (String)"EcoEstimateGetSupplyData_06", (String)APPNUM, (Object[])new Object[0]), srcModel.getExceptionInfo());
                        exceptionKey3 = "EcoEstimateGetSupplyData_06";
                        exceptionModel6 = new EcoExceptionModel(exceptionInfo5, exceptionKey3);
                        this.setResultErrorData(ecoObject, exceptionModel6, srcModel);
                        errorCountSet.add(ecoBomEntryId);
                    }
                    if (this.isExceptionError(ecoObject) && !this.isGroupError(chk3Map, groupkeyString)) {
                        this.addGroupErrorMsg(chk3Map, groupkeyString, this.genExceptionModel(ecoObject));
                    }
                    if (errorGroupKeyMap.containsKey(groupkeyString)) {
                        srcModel = (EcoExceptionModel)errorGroupKeyMap.get(groupkeyString);
                        exceptionInfo5 = String.format(ResManager.loadKDString((String)"\u540c\u7ec4(\u6210\u7ec4\u53f7)\u5b58\u5728\u6570\u636e\u4e0d\u6ee1\u8db3\u8bc4\u4f30\u8981\u6c42\uff08%1$s\uff09\uff0c\u4e0d\u8fdb\u884c\u8bc4\u4f30\u3002", (String)"EcoEstimateGetSupplyData_06", (String)APPNUM, (Object[])new Object[0]), srcModel.getExceptionInfo());
                        exceptionKey3 = "EcoEstimateGetSupplyData_06";
                        exceptionModel6 = new EcoExceptionModel(exceptionInfo5, exceptionKey3);
                        this.setResultErrorData(ecoObject, exceptionModel6, srcModel);
                        errorCountSet.add(ecoBomEntryId);
                        this.addGroupErrorMsg(chk3Map, groupkeyString, exceptionModel6);
                    }
                    if (this.isGroupError(chk3Map, groupkeyString) && !PlatformUtils.isNullString((String)entryRefno)) {
                        groupkeyString = "refvalide_" + entryRefno;
                        chk3Map.put(groupkeyString, (EcoExceptionModel)chk3Map.get(groupkeyString));
                    }
                }
                if (!PlatformUtils.isNullString((String)entryRefno)) {
                    groupkeyString = "refvalide_" + entryRefno;
                    boolean hasRefKey = (Boolean)hasRefKeyMap.get(entryRefno);
                    if (!hasRefKey) {
                        String exceptionInfo7 = String.format(ResManager.loadKDString((String)"\u5173\u8054\u5b9e\u65bd\u53f7\uff08%1$s\uff09\u4e0d\u5b58\u5728\u5173\u8054\u4e3b\u952e\u6570\u636e\u3002", (String)"EcoEstimateGetSupplyData_10", (String)APPNUM, (Object[])new Object[0]), entryRefno);
                        exceptionKey2 = "EcoEstimateGetSupplyData_10";
                        exceptionModel5 = new EcoExceptionModel(exceptionInfo7, exceptionKey2);
                        this.setResultErrorData(ecoObject, exceptionModel5);
                        chk3Map.put(groupkeyString, exceptionModel5);
                        errorCountSet.add(ecoBomEntryId);
                    }
                    if (this.isGroupError(chk3Map, groupkeyString)) {
                        EcoExceptionModel srcErrModel = (EcoExceptionModel)chk3Map.get(groupkeyString);
                        exceptionInfo = String.format(ResManager.loadKDString((String)"\u540c\u7ec4(\u5173\u8054\u5b9e\u65bd\u53f7)\u5b58\u5728\u6570\u636e\u4e0d\u6ee1\u8db3\u8bc4\u4f30\u8981\u6c42\uff08%1$s\uff09\uff0c\u4e0d\u8fdb\u884c\u8bc4\u4f30\u3002", (String)"EcoEstimateGetSupplyData_08", (String)APPNUM, (Object[])new Object[0]), srcErrModel.getExceptionInfo());
                        exceptionKey = "EcoEstimateGetSupplyData_10";
                        exceptionModel = new EcoExceptionModel(exceptionInfo, exceptionKey);
                        this.setResultErrorData(ecoObject, exceptionModel, srcErrModel);
                        errorCountSet.add(ecoBomEntryId);
                    }
                    if (this.isExceptionError(ecoObject) && !this.isGroupError(chk3Map, groupkeyString)) {
                        this.addGroupErrorMsg(chk3Map, groupkeyString, this.genExceptionModel(ecoObject));
                    }
                    if (errorRefKeyMap.containsKey(entryRefno)) {
                        EcoExceptionModel srcErrModel = (EcoExceptionModel)errorRefKeyMap.get(entryRefno);
                        exceptionInfo = String.format(ResManager.loadKDString((String)"\u540c\u7ec4(\u5173\u8054\u5b9e\u65bd\u53f7)\u5b58\u5728\u6570\u636e\u4e0d\u6ee1\u8db3\u8bc4\u4f30\u8981\u6c42\uff08%1$s\uff09\uff0c\u4e0d\u8fdb\u884c\u8bc4\u4f30\u3002", (String)"EcoEstimateGetSupplyData_08", (String)APPNUM, (Object[])new Object[0]), srcErrModel.getExceptionInfo());
                        exceptionKey = "EcoEstimateGetSupplyData_08";
                        exceptionModel = new EcoExceptionModel(exceptionInfo, exceptionKey);
                        this.setResultErrorData(ecoObject, exceptionModel, srcErrModel);
                        errorCountSet.add(ecoBomEntryId);
                        this.addGroupErrorMsg(chk3Map, groupkeyString, exceptionModel);
                    }
                    if (this.isGroupError(chk3Map, groupkeyString) && !PlatformUtils.isNullString((String)entryGroupNo)) {
                        String refkeyString = ecoPentryid + "_" + entryGroupNo;
                        chk3Map.put(refkeyString, (EcoExceptionModel)chk3Map.get(groupkeyString));
                    }
                }
                if (errorMaterialSMap.containsKey(materialKeyString = PlatformUtils.getUnionString((Object)keyStrig, (Object)entryMode))) {
                    EcoExceptionModel model = (EcoExceptionModel)errorMaterialSMap.get(materialKeyString);
                    this.setResultErrorData(ecoObject, model);
                    errorCountSet.add(ecoBomEntryId);
                }
                if (!errorKeyMap.containsKey(keyStrig)) continue;
                EcoExceptionModel model = (EcoExceptionModel)errorKeyMap.get(keyStrig);
                this.setResultErrorData(ecoObject, model);
                errorCountSet.add(ecoBomEntryId);
            }
        }
        if (chk3Map != null && !chk3Map.isEmpty()) {
            for (String keyStrig : rsSetAll) {
                supArray = supObject.getJSONArray(keyStrig);
                if (supArray == null || supArray.isEmpty()) continue;
                supSize = supArray.size();
                for (i = 0; i < supSize; ++i) {
                    EcoExceptionModel exceptionModel;
                    String exceptionKey;
                    String exceptionInfo;
                    String groupkeyString;
                    ecoObject = supArray.getJSONObject(i);
                    if (this.isExceptionError(ecoObject)) continue;
                    ecoBomEntryId = ecoObject.getLong("ecobomentryid");
                    entryGroupNo = ecoObject.getString("entrygroupno");
                    ecoPentryid = ecoObject.getLong("billentryid");
                    entryRefno = ecoObject.getString("entryrefno");
                    if (!PlatformUtils.isNullString((String)entryGroupNo) && this.isGroupError(chk3Map, groupkeyString = ecoPentryid + "_" + entryGroupNo)) {
                        exceptionInfo = String.format(ResManager.loadKDString((String)"\u540c\u7ec4(\u6210\u7ec4\u53f7)\u5b58\u5728\u6570\u636e\u4e0d\u6ee1\u8db3\u8bc4\u4f30\u8981\u6c42\uff08%1$s\uff09\uff0c\u4e0d\u8fdb\u884c\u8bc4\u4f30\u3002", (String)"EcoEstimateGetSupplyData_06", (String)APPNUM, (Object[])new Object[0]), chk3Map.get(groupkeyString));
                        exceptionKey = "EcoEstimateGetSupplyData_06";
                        exceptionModel = new EcoExceptionModel(exceptionInfo, exceptionKey);
                        this.setResultErrorData(ecoObject, exceptionModel);
                        errorCountSet.add(ecoBomEntryId);
                    }
                    if (PlatformUtils.isNullString((String)entryRefno) || !this.isGroupError(chk3Map, groupkeyString = "refvalide_" + entryRefno)) continue;
                    exceptionInfo = String.format(ResManager.loadKDString((String)"\u540c\u7ec4(\u5173\u8054\u5b9e\u65bd\u53f7)\u5b58\u5728\u6570\u636e\u4e0d\u6ee1\u8db3\u8bc4\u4f30\u8981\u6c42\uff08%1$s\uff09\uff0c\u4e0d\u8fdb\u884c\u8bc4\u4f30\u3002", (String)"EcoEstimateGetSupplyData_08", (String)APPNUM, (Object[])new Object[0]), chk3Map.get(groupkeyString));
                    exceptionKey = "EcoEstimateGetSupplyData_08";
                    exceptionModel = new EcoExceptionModel(exceptionInfo, exceptionKey);
                    this.setResultErrorData(ecoObject, exceptionModel);
                    errorCountSet.add(ecoBomEntryId);
                }
            }
        }
        HashMap<String, Integer> errorMap = new HashMap<String, Integer>(16);
        errorMap.put("errorCount", errorCountSet.size());
        errorMap.put("repeatCount", repeatCountSet.size());
        return errorMap;
    }

    private Set<String> getExceptionKeySet(JSONObject ecoObject) {
        Object obj = ecoObject.get((Object)"exceptionkeyset");
        if (obj == null) {
            return new HashSet<String>(16);
        }
        return (HashSet)ecoObject.get((Object)"exceptionkeyset");
    }

    private void setResultErrorData(JSONObject ecoObject, EcoExceptionModel model) {
        Set<String> exceptionKeySet = this.getExceptionKeySet(ecoObject);
        if (exceptionKeySet.add(model.getExceptionType())) {
            ecoObject.put("exceptiontype", (Object)"C");
            String oldExceptionInfo = ecoObject.getString("exceptioninfo");
            String newExceptionInfo = model.getExceptionInfo();
            int count = exceptionKeySet.size();
            newExceptionInfo = String.format(ResManager.loadKDString((String)"%1$s %2$s\u3001%3$s", (String)"EcoEstimateGetSupplyData_14", (String)APPNUM, (Object[])new Object[0]), oldExceptionInfo, count, newExceptionInfo);
            ecoObject.put("exceptioninfo", (Object)newExceptionInfo);
            ecoObject.put("exceptionkeyset", exceptionKeySet);
        }
    }

    private void setResultErrorData(JSONObject ecoObject, EcoExceptionModel model, EcoExceptionModel srcModel) {
        Set<String> exceptionKeySet;
        if (!srcModel.getExceptionType().equals(model.getExceptionType()) && (exceptionKeySet = this.getExceptionKeySet(ecoObject)).contains(srcModel.getExceptionType())) {
            return;
        }
        this.setResultErrorData(ecoObject, model);
    }

    private DataSet fetchDataBySetId(DynamicObject planProgram) {
        DataSet dataSet = null;
        DynamicObjectCollection collection = planProgram.getDynamicObjectCollection("scentryentity");
        List modelIds = collection.stream().filter(o -> o.getBoolean("entryisscmrpoperat")).map(o -> o.getLong("resourceregisters.id")).collect(Collectors.toList());
        if (modelIds.isEmpty()) {
            return dataSet;
        }
        int planOutLookDay = this.getPlanOutLook(planProgram);
        int supplyDelayPeriod = this.getSupplyDelayPeriod(planProgram);
        Set<Long> supplyOrgs = this.getSupplyOrgs(planProgram);
        Date currentDate = new Date();
        Date toDate = PlatformUtils.addDay((Date)currentDate, (int)planOutLookDay);
        Date fromDate = PlatformUtils.addDay((Date)currentDate, (int)(0 - supplyDelayPeriod));
        QFilter qfilter = new QFilter("org", "in", supplyOrgs);
        if (!"1".equals(planProgram.getString("scoutofdate"))) {
            qfilter.and(new QFilter("createtime", ">=", (Object)fromDate));
            qfilter.and(new QFilter("createtime", "<=", (Object)toDate));
        }
        for (Long modelId : modelIds) {
            DataSet dsItem = null;
            dsItem = DataSourceFetchDataUtil.getDataSetByModel((Long)modelId, null, (QFilter)qfilter);
            dsItem = dsItem.addField("cast (" + modelId + " as long) ", "srcdatasource");
            if (dataSet == null) {
                dataSet = dsItem;
                continue;
            }
            RowMeta leftRowMeta = dataSet.getRowMeta();
            RowMeta rightRowMeta = dsItem.getRowMeta();
            Field[] leftFields = leftRowMeta.getFields();
            Field[] rightFields = rightRowMeta.getFields();
            HashSet<String> allFieldName = new HashSet<String>(16);
            HashSet<String> leftName = new HashSet<String>(16);
            HashSet<String> rightName = new HashSet<String>(16);
            for (Field leftField : leftFields) {
                allFieldName.add(leftField.getName());
                leftName.add(leftField.getName());
            }
            for (Field rightField : rightFields) {
                allFieldName.add(rightField.getName());
                rightName.add(rightField.getName());
            }
            for (String fieldName : allFieldName) {
                if (!leftName.contains(fieldName)) {
                    dataSet = dataSet.addNullField(fieldName);
                }
                if (rightName.contains(fieldName)) continue;
                dsItem = dsItem.addNullField(fieldName);
            }
            dataSet = dataSet.select(allFieldName.toArray(new String[0]));
            dsItem = dsItem.select(allFieldName.toArray(new String[0]));
            dataSet = dataSet.union(dsItem);
        }
        return dataSet;
    }

    private Set<Long> getFeatureMaterial(Long featureTypeId, Long orgId, Map<String, Set<Long>> featureMaterialCacheMap) {
        String keyString = featureTypeId + "_" + orgId;
        if (featureMaterialCacheMap.containsKey(keyString)) {
            return featureMaterialCacheMap.get(keyString);
        }
        HashSet<Long> materialIdSet = new HashSet<Long>(16);
        String selectProperties = "masterid";
        QFilter filter = new QFilter("featureinfo.featuretype", "=", (Object)featureTypeId);
        filter.and(new QFilter("enable", "=", (Object)"1"));
        filter.and(new QFilter("status", "=", (Object)"C"));
        filter.and(BaseDataServiceHelper.getBaseDataFilter((String)"pdm_proconfigscheme", (Long)orgId));
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)(EcoEstimateGetSupplyData.class.getName() + "_getFeatureMaterial"), (String)"pdm_proconfigscheme", (String)selectProperties, (QFilter[])new QFilter[]{filter}, (String)"");){
            while (ds.hasNext()) {
                Row arow = ds.next();
                Long materialId = arow.getLong("masterid");
                materialIdSet.add(materialId);
            }
        }
        featureMaterialCacheMap.put(keyString, materialIdSet);
        return materialIdSet;
    }

    private boolean chkSupQtyZeroIsException(DynamicObject planProgram) {
        String type = planProgram.getString("suppqtyexceptiontype");
        return "B".equals(type);
    }

    private Map<Object, DynamicObject> getMaterialMap(Set<Long> allmIdSet) {
        return BusinessDataServiceHelper.loadFromCache((String)"bd_material", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("id", "in", allmIdSet)});
    }

    private String getEcoBillDesc(Map<Object, DynamicObject> cacheMap, JSONObject ecoObject) {
        Long materialId = ecoObject.getLong("material");
        DynamicObject material = cacheMap.get(materialId);
        String ecnBill = ecoObject.getString("billnumber");
        String desc = String.format(ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u5355\u53f7\uff1a%1$s\uff0c\u7269\u6599\u7f16\u7801\uff1a%2$s", (String)"EcoEstimateGetSupplyData_16", (String)APPNUM, (Object[])new Object[0]), ecnBill, material == null ? String.valueOf(materialId) : material.getString("number"));
        return desc;
    }

    private String getMaterialNumber(Map<Object, DynamicObject> cacheMap, JSONObject ecoObject) {
        Long materialId = ecoObject.getLong("material");
        DynamicObject material = cacheMap.get(materialId);
        return material == null ? String.valueOf(materialId) : material.getString("number");
    }

    private boolean isTranQtyDifferent(BigDecimal sameTranQty, BigDecimal supplyQty) {
        return sameTranQty != null && supplyQty != null && supplyQty.compareTo(sameTranQty) != 0;
    }

    private boolean isTranStartDateDifferent(Date sameTranStartDate, Date tranStartDate, SimpleDateFormat sdf) {
        return sameTranStartDate != null && tranStartDate != null && !sdf.format(sameTranStartDate).equals(sdf.format(tranStartDate));
    }

    private void addTranDiffException(EcoExceptionModel exceptionModel, Map<String, EcoExceptionModel> errorKeyMap, JSONObject ecoObject, String keyStrig, Map<String, EcoExceptionModel> errorRefKeyMap, Map<String, EcoExceptionModel> errorGroupKeyMap, Set<Long> errorCountSet) {
        Long ecoBomEntryId = ecoObject.getLong("ecobomentryid");
        String entryGroupNo = ecoObject.getString("entrygroupno");
        String entryRefNo = ecoObject.getString("entryrefno");
        Long ecoPentryid = ecoObject.getLong("billentryid");
        errorKeyMap.put(keyStrig, exceptionModel);
        this.setResultErrorData(ecoObject, exceptionModel);
        if (!PlatformUtils.isNullString((String)entryRefNo)) {
            errorRefKeyMap.put(entryRefNo, exceptionModel);
        }
        if (!PlatformUtils.isNullString((String)entryGroupNo)) {
            String groupKeyString = PlatformUtils.getUnionString((Object)ecoPentryid, (Object)entryGroupNo);
            errorGroupKeyMap.put(groupKeyString, exceptionModel);
        }
        errorCountSet.add(ecoBomEntryId);
    }

    private boolean isGroupError(Map<String, EcoExceptionModel> chk3Map, String groupkeyString) {
        return chk3Map.get(groupkeyString) != null;
    }

    private void addGroupErrorMsg(Map<String, EcoExceptionModel> chk3Map, String groupkeyString, EcoExceptionModel model) {
        if (!this.isGroupError(chk3Map, groupkeyString)) {
            chk3Map.put(groupkeyString, model);
        }
    }

    private EcoExceptionModel genExceptionModel(JSONObject ecoObject) {
        String exceptionInfo = ecoObject.getString("exceptioninfo");
        Set<String> exceptionKeySet = this.getExceptionKeySet(ecoObject);
        String exceptionType = exceptionKeySet.iterator().next();
        return new EcoExceptionModel(exceptionInfo, exceptionType);
    }
}

