/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.business.ecoplatform.estimate.step;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.mmc.pdm.business.ecoplatform.EcoUtils;
import kd.mmc.pdm.business.ecoplatform.GetEcoEffectOrderBusiness;
import kd.mmc.pdm.business.ecoplatform.estimate.step.EcoEstimateBaseStep;
import kd.mmc.pdm.business.ecoplatform.estimate.step.batchtask.EstimateBatchTaskEvent;
import kd.mmc.pdm.business.ecoplatform.estimate.step.exec.EffectOrderExecImpl;
import kd.mmc.pdm.common.bom.ecoplatform.PlatformUtils;
import kd.mpscmm.msplan.mservice.service.batchtask.BatchTask;
import kd.mpscmm.msplan.mservice.service.mrp.ExecutionEnv;

public class EcoEstimateUpdateOrder
extends EcoEstimateBaseStep {
    private static final Log log = LogFactory.getLog(EcoEstimateUpdateOrder.class);
    private static final int DEFBATCHSIZE = 10;

    @Override
    public String doWork(ExecutionEnv env, int stepIdx) {
        super.doWork(env, stepIdx);
        try {
            String ecoBomEntryIds = this.getCacheValue(this.getEffectOrderIdCacheString());
            if (StringUtils.isEmpty((String)ecoBomEntryIds)) {
                return ResManager.loadKDString((String)"\u6682\u65e0\u9700\u8981\u5f71\u54cd\u8ba2\u5355\u7684\u6570\u636e.", (String)"EcoEstimateUpdateOrder_0", (String)"mmc-pdm-business", (Object[])new Object[0]);
            }
            Set ecoBomEntryIdSet = PlatformUtils.ParseStringToLongSet((String)ecoBomEntryIds);
            if (ecoBomEntryIdSet == null || ecoBomEntryIdSet.isEmpty()) {
                return ResManager.loadKDString((String)"\u6682\u65e0\u9700\u8981\u5f71\u54cd\u8ba2\u5355\u7684\u6570\u636e.", (String)"EcoEstimateUpdateOrder_0", (String)"mmc-pdm-business", (Object[])new Object[0]);
            }
            String resultStr = "";
            try {
                Set<Long> allEntryIdSet = EcoUtils.getAllEcoBomEntryIdSet(ecoBomEntryIdSet);
                List<List<Long>> splitList = this.splitData(allEntryIdSet);
                Map<String, Object> resultMap = this.batchExecute(env, splitList);
                String errorMsg = resultMap.get("errormsg") == null ? "" : resultMap.get("errormsg").toString();
                int allSize = resultMap.get("allSize") == null ? 0 : Integer.parseInt(resultMap.get("allSize").toString());
                int successSize = resultMap.get("successSize") == null ? 0 : Integer.parseInt(resultMap.get("successSize").toString());
                resultStr = String.format(ResManager.loadKDString((String)"\u6210\u529f\u751f\u6210\u7ec4\u4ef6\u6e05\u5355\u53d8\u66f4\u6570:\u201c%1$s\u201d,\u9519\u8bef\u4fe1\u606f:\u201c%2$s\u201d\u3002", (String)"EcoEstimateUpdateOrder_1", (String)"mmc-pdm-business", (Object[])new Object[0]), successSize, errorMsg);
                this.updateLogCount(stepIdx, allSize);
                log.info("------EcoEstimateUpdateOrder---end-----resultStr = " + resultStr);
            }
            catch (Exception e) {
                log.error((Throwable)e);
                resultStr = String.format(ResManager.loadKDString((String)"\u8ba2\u5355\u66f4\u65b0\u53d1\u751f\u9519\u8bef\uff1a\u201c%1$s\u201d\u3002", (String)"EcoEstimateUpdateOrder_2", (String)"mmc-pdm-business", (Object[])new Object[0]), e.getMessage());
            }
            return resultStr;
        }
        catch (Exception e) {
            this.clearCacheValue(env);
            log.error((Throwable)e);
            throw e;
        }
    }

    public List<List<Long>> initSameGroupData(Set<Long> allEntryIdSet) {
        List<List<Long>> splitList = GetEcoEffectOrderBusiness.getInstance().splitEcoBomData(allEntryIdSet);
        return splitList;
    }

    public List<List<Long>> splitData(Set<Long> allEntryIdSet) {
        List<List<Long>> splitList = this.initSameGroupData(allEntryIdSet);
        ArrayList<List<Long>> splitKeys = new ArrayList<List<Long>>(64);
        boolean isBatchCompute = this.isBatchCompute();
        int subSize = 10;
        if (isBatchCompute && (subSize = this.getEffectOrderBatchCount()) == 0) {
            subSize = 10;
        }
        ArrayList<Long> splitEntryIdList = new ArrayList<Long>(subSize);
        int i = 0;
        int size = splitList.size();
        for (int t = 0; t < size; ++t) {
            List<Long> oneList = splitList.get(t);
            splitEntryIdList.addAll(oneList);
            if (++i != subSize) continue;
            splitKeys.add(splitEntryIdList);
            splitEntryIdList = new ArrayList(subSize);
            i = 0;
        }
        if (!splitEntryIdList.isEmpty()) {
            splitKeys.add(splitEntryIdList);
        }
        log.info("-----------EcoEstimateUpdateOrder-----splitData---------subSize:" + subSize + ",splitList.size =" + splitList.size() + ",splitKeys.size=" + splitKeys.size() + ",allEntryIdSet.size=" + allEntryIdSet.size());
        return splitKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> batchExecute(ExecutionEnv env, List<List<Long>> splitList) {
        boolean isBatchCompute = this.isBatchCompute();
        HashMap<String, Object> retMap = new HashMap<String, Object>(16);
        int size = splitList.size();
        int successSize = 0;
        int allSize = 0;
        StringBuilder sbString = new StringBuilder();
        if (!isBatchCompute || this.getEffectOrderBatchCount() <= 0) {
            for (int i = 0; i < size; ++i) {
                List<Long> ecoBomEntryIdList = splitList.get(i);
                Map<String, Object> resultMap = EffectOrderExecImpl.getInstance().exec(env, null, null, ecoBomEntryIdList, false);
                String errormsg = resultMap.get("errormsg") == null ? "" : resultMap.get("errormsg").toString();
                allSize += resultMap.get("allSize") == null ? 0 : Integer.parseInt(resultMap.get("allSize").toString());
                successSize += resultMap.get("successSize") == null ? 0 : Integer.parseInt(resultMap.get("successSize").toString());
                if (StringUtils.isEmpty((String)errormsg)) continue;
                sbString.append(errormsg).append("\r\n");
            }
            retMap.put("errormsg", sbString.toString());
            retMap.put("successSize", successSize);
            retMap.put("allSize", allSize);
            return retMap;
        }
        BatchTask task = BatchTask.create((String)"EcoEstimateEffectOrder");
        String taskId = task.getCalcId();
        task.setQueueName(this.getConsumerQueue());
        task.registBizClass(EstimateBatchTaskEvent.class);
        task.setTimeOut(TASKTIMEOUTLONG.longValue());
        int batch = 0;
        int allDataSize = 0;
        for (int i = 0; i < size; ++i) {
            List<Long> ecoBomEntryIdList = splitList.get(i);
            ++batch;
            allDataSize += ecoBomEntryIdList.size();
            HashMap<String, Object> batchParams = new HashMap<String, Object>(16);
            batchParams.put("ecoBomEntryIdList", ecoBomEntryIdList);
            batchParams.put("runLog", env.getRunLog());
            batchParams.put("envCacheMap", env.getParams());
            batchParams.put("taskname", "Estimate_EffectOrder");
            batchParams.put("batch", batch);
            task.addEvent(batchParams);
        }
        this.addTaskLog(taskId);
        long startTime = System.currentTimeMillis();
        boolean successful = true;
        String errorMsg = "";
        try {
            log.info(String.format(ResManager.loadKDString((String)"EcoEstimateUpdateOrder_BatchTask\u5206\u5e03\u5f0f\u8ba1\u7b97\u8c03\u5ea6\u5f00\u59cb\uff0c[%1$s]\u4e2a\u5de5\u7a0b\u53d8\u66f4\u5206\u5f55ID\u5206\u53d1\u4e3a\u5171[%2$s]\u4e2a\u4efb\u52a1...", (String)"EcoEstimateUpdateOrder_4", (String)"mmc-pdm-business", (Object[])new Object[0]), allDataSize, batch));
            log.info(String.format(ResManager.loadKDString((String)"EcoEstimateUpdateOrder_BatchTask\u5206\u5e03\u5f0f\u8ba1\u7b97\u8c03\u5ea6\u5f00\u59cb\uff0c[%1$s]\u4e2a\u5de5\u7a0b\u53d8\u66f4\u5206\u5f55ID\u5206\u53d1\u4e3a\u5171[%2$s]\u4e2a\u4efb\u52a1...", (String)"EcoEstimateUpdateOrder_4", (String)"mmc-pdm-business", (Object[])new Object[0]), allDataSize, batch));
            task.startTask();
            log.info(ResManager.loadKDString((String)"EcoEstimateUpdateOrder_BatchTask\u5206\u5e03\u5f0f\u8ba1\u7b97\u8c03\u5ea6\u7ed3\u675f...", (String)"EcoEstimateUpdateOrder_5", (String)"mmc-pdm-business", (Object[])new Object[0]));
            log.info(ResManager.loadKDString((String)"EcoEstimateUpdateOrder_BatchTask\u5206\u5e03\u5f0f\u8ba1\u7b97\u8c03\u5ea6\u7ed3\u675f...", (String)"EcoEstimateUpdateOrder_5", (String)"mmc-pdm-business", (Object[])new Object[0]));
        }
        catch (Exception e) {
            log.error(ResManager.loadKDString((String)"EcoEstimateUpdateOrder_BatchTask\u5206\u5e03\u5f0f\u8ba1\u7b97\u51fa\u9519\uff1a", (String)"EcoEstimateUpdateOrder_6", (String)"mmc-pdm-business", (Object[])new Object[0]) + e.getMessage(), (Throwable)e);
            log.error(ResManager.loadKDString((String)"EcoEstimateUpdateOrder_BatchTask\u5206\u5e03\u5f0f\u8ba1\u7b97\u51fa\u9519\uff1a", (String)"EcoEstimateUpdateOrder_6", (String)"mmc-pdm-business", (Object[])new Object[0]) + e.getMessage(), (Throwable)e);
            successful = false;
            errorMsg = PlatformUtils.getExceptionString((Exception)e);
        }
        finally {
            task.terminate();
        }
        if (!successful) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u66f4\u65b0\u8ba2\u5355\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"EcoEstimateUpdateOrder_3", (String)"mmc-pdm-business", (Object[])new Object[0]), errorMsg));
        }
        long enddate = System.currentTimeMillis() - startTime;
        log.info(String.format(ResManager.loadKDString((String)"EcoEstimateUpdateOrder_BatchTask\u5206\u5e03\u5f0f\u8ba1\u7b97\u5b8c\u6bd5,allDataSize.size = %1$s ,cost: %2$s ms", (String)"EcoEstimateUpdateOrder_7", (String)"mmc-pdm-business", (Object[])new Object[0]), allDataSize, enddate));
        log.info(String.format(ResManager.loadKDString((String)"EcoEstimateUpdateOrder_BatchTask\u5206\u5e03\u5f0f\u8ba1\u7b97\u5b8c\u6bd5,allDataSize.size = %1$s ,cost: %2$s ms", (String)"EcoEstimateUpdateOrder_7", (String)"mmc-pdm-business", (Object[])new Object[0]), allDataSize, enddate));
        errorMsg = this.getCacheValue(this.getEffectOrderMsgCacheString());
        successSize = this.getIntegerCacheValue(this.getEffectOrderSucessCacheString());
        allSize = this.getIntegerCacheValue(this.getEffectOrderAllSizeCacheString());
        retMap.put("errormsg", errorMsg);
        retMap.put("successSize", successSize);
        retMap.put("allSize", allSize);
        log.info(String.format(ResManager.loadKDString((String)"EcoEstimateUpdateOrder_errorMsg = %1$s ,successSize: %2$s ,allSize: %3$s ", (String)"EcoEstimateUpdateOrder_8", (String)"mmc-pdm-business", (Object[])new Object[0]), errorMsg, successSize, allSize));
        log.info(String.format(ResManager.loadKDString((String)"EcoEstimateUpdateOrder_errorMsg = %1$s ,successSize: %2$s ,allSize: %3$s ", (String)"EcoEstimateUpdateOrder_8", (String)"mmc-pdm-business", (Object[])new Object[0]), errorMsg, successSize, allSize));
        return retMap;
    }
}

