/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.business.ecoplatform.estimate.step;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mmc.pdm.common.bom.ecoplatform.PlatformUtils;
import kd.mmc.pdm.common.util.PdmParamSetHelper;

public class EstimateUtils {
    public static final String REDIS_PATCH = "mmc-pdm-ecoestimate";

    public static List<String> getSRFields(Long bftransferId, boolean isfrom) {
        if (PlatformUtils.isNullLong((Long)bftransferId)) {
            return new ArrayList<String>(16);
        }
        DynamicObject fs = BusinessDataServiceHelper.loadSingleFromCache((Object)bftransferId, (String)"mrp_billfieldtransfer");
        DynamicObjectCollection relations = fs.getDynamicObjectCollection("entryentity");
        String fromKey = "sourcefieldflag";
        String toKey = "destfieldflag";
        ArrayList<String> ret = new ArrayList<String>();
        for (DynamicObject relation : relations) {
            if (isfrom) {
                ret.add(relation.getString(fromKey));
                continue;
            }
            ret.add(relation.getString(toKey));
        }
        return ret;
    }

    public static String genRedisEcoBomEntryIdKey(Long logId) {
        return "ecneffectrange_ecobomentryids_" + String.valueOf(logId);
    }

    public static String genRedisEcoBomCopEntryIdKey(Long logId) {
        return "ecneffectrange_ecobomcopentryids_" + String.valueOf(logId);
    }

    public static String genRedisEcnPEntryIdKey(Long logId) {
        return "ecneffectrange_ecnpentryids_" + String.valueOf(logId);
    }

    public static String genRedisIsParentQueryKey(Long logId) {
        return "ecneffectrange_parentquery_" + String.valueOf(logId);
    }

    public static boolean getRedisByteMode() {
        return PdmParamSetHelper.getBooleanParamValue((String)"ECN_RedisByteMode");
    }

    public static int getRedisTimeLong() {
        int paramValue = PdmParamSetHelper.getIntParamValue((String)"ECNEstimate_RedisTimeOutLong");
        if (paramValue <= 0) {
            paramValue = 1200;
        }
        return paramValue;
    }
}

