/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.business.ecoplatform.estimate.step.batchtask;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.BroadcastTask;
import kd.bos.schedule.api.ShardingUtil;
import kd.bos.schedule.executor.AbstractTask;
import kd.mmc.pdm.business.ecoplatform.estimate.step.exec.EffectOrderExecImpl;
import kd.mmc.pdm.business.ecoplatform.estimate.step.exec.EffectRangeGetSupplyDataImpl;
import kd.mmc.pdm.business.ecoplatform.estimate.step.exec.EffectRangeSRMatchExecImpl;
import kd.mmc.pdm.business.ecoplatform.estimate.step.exec.GetRequireDataExecImpl;
import kd.mmc.pdm.business.ecoplatform.estimate.step.exec.SRBalanceExecImpl;
import kd.mmc.pdm.common.bom.ecoplatform.PlatformUtils;

public class EstimateBatchTask
extends AbstractTask
implements BroadcastTask {
    protected static final Log log = LogFactory.getLog(EstimateBatchTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> params, ShardingUtil.BroadcastVO broadcastVO) throws KDException {
        int index = broadcastVO.getIndex();
        int total = broadcastVO.getTotal();
        total = Math.max(total, 1);
        params.put("total", total);
        params.put("index", index);
        this.execute(requestContext, params);
    }

    public void execute(RequestContext ctx, Map<String, Object> paramMap) throws KDException {
        if (this.isEstimateGetRequireData(paramMap)) {
            Set<Long> materialIdSet = this.getLongSet(paramMap, "materialidset");
            Set<String> supAndReqKeySet = this.getStringSet(paramMap, "supAndReqKeySet");
            DynamicObject planProgram = this.getDynamicObject(paramMap, "planProgram");
            DynamicObject runLog = this.getDynamicObject(paramMap, "runLog");
            Date minSupplyDate = this.getMinSupplyDate(paramMap);
            List<Long> modelIds = this.getModelIds(paramMap);
            Map<String, String> envCacheMap = this.getEnvCacheMap(paramMap);
            String executeBatch = paramMap.get("batch").toString();
            log.info("EstimateBatchTask-executeBatch=" + executeBatch + ",materialIdSet=" + materialIdSet.toString());
            GetRequireDataExecImpl.getInstance().exec(null, planProgram, runLog, envCacheMap, supAndReqKeySet, materialIdSet, minSupplyDate, modelIds, true);
        } else if (this.isEstimateSRBalance(paramMap)) {
            Map<String, String> envCacheMap = this.getEnvCacheMap(paramMap);
            Set<String> supAndReqKeySet = this.getStringSet(paramMap, "subKeySet");
            DynamicObject planProgram = this.getDynamicObject(paramMap, "planProgram");
            DynamicObject runLog = this.getDynamicObject(paramMap, "runLog");
            String executeBatch = paramMap.get("batch").toString();
            log.info("EstimateBatchTask-executeBatch=" + executeBatch + ",supAndReqKeySet=" + supAndReqKeySet.toString());
            SRBalanceExecImpl.getInstance().exec(null, planProgram, runLog, envCacheMap, supAndReqKeySet, true);
        } else if (this.isEstimateEffectOrder(paramMap)) {
            List<Long> ecoBomEntryIdList = this.getLongList(paramMap, "ecoBomEntryIdList");
            DynamicObject runLog = this.getDynamicObject(paramMap, "runLog");
            Map<String, String> envCacheMap = this.getEnvCacheMap(paramMap);
            String executeBatch = paramMap.get("batch").toString();
            log.info("EstimateBatchTask-executeBatch=" + executeBatch + ",ecoBomEntryIdList=" + ecoBomEntryIdList.toString());
            EffectOrderExecImpl.getInstance().exec(null, runLog, envCacheMap, ecoBomEntryIdList, true);
        } else if (this.isEffectRangeGetSupplyData(paramMap)) {
            Set<Long> materialIdSet = this.getLongSet(paramMap, "materialidset");
            Set<String> supAndReqKeySet = this.getStringSet(paramMap, "supAndReqKeySet");
            DynamicObject planProgram = this.getDynamicObject(paramMap, "planProgram");
            DynamicObject runLog = this.getDynamicObject(paramMap, "runLog");
            List<Long> modelIds = this.getModelIds(paramMap);
            Map<String, String> envCacheMap = this.getEnvCacheMap(paramMap);
            String executeBatch = paramMap.get("batch").toString();
            log.info("EstimateBatchTask-executeBatch=" + executeBatch + ",materialIdSet=" + materialIdSet.toString());
            EffectRangeGetSupplyDataImpl.getInstance().exec(null, planProgram, runLog, envCacheMap, supAndReqKeySet, materialIdSet, modelIds, true);
        } else if (this.isEffectRangeSRMatch(paramMap)) {
            Map<String, String> envCacheMap = this.getEnvCacheMap(paramMap);
            Set<String> supAndReqKeySet = this.getStringSet(paramMap, "subKeySet");
            DynamicObject planProgram = this.getDynamicObject(paramMap, "planProgram");
            DynamicObject runLog = this.getDynamicObject(paramMap, "runLog");
            String executeBatch = paramMap.get("batch").toString();
            log.info("EstimateBatchTask-executeBatch=" + executeBatch + ",supAndReqKeySet=" + supAndReqKeySet.toString());
            EffectRangeSRMatchExecImpl.getInstance().exec(null, planProgram, runLog, envCacheMap, supAndReqKeySet, true);
        }
    }

    public boolean isEstimateGetRequireData(Map<String, Object> paramMap) throws KDException {
        return "Estimate_GetRequireData".equals(paramMap.get("taskname").toString());
    }

    public boolean isEstimateSRBalance(Map<String, Object> paramMap) throws KDException {
        return "Estimate_SRBalance".equals(paramMap.get("taskname").toString());
    }

    public boolean isEstimateEffectOrder(Map<String, Object> paramMap) throws KDException {
        return "Estimate_EffectOrder".equals(paramMap.get("taskname").toString());
    }

    public boolean isEffectRangeGetSupplyData(Map<String, Object> paramMap) throws KDException {
        return "EffectRange_GetSupplyData".equals(paramMap.get("taskname").toString());
    }

    public boolean isEffectRangeSRMatch(Map<String, Object> paramMap) throws KDException {
        return "EffectRange_SRMatch".equals(paramMap.get("taskname").toString());
    }

    private Set<Long> getLongSet(Map<String, Object> paramMap, String paramName) throws KDException {
        Object obj = paramMap.get(paramName);
        if (obj == null) {
            return new HashSet<Long>(16);
        }
        if (obj instanceof Set) {
            return (Set)obj;
        }
        if (obj instanceof HashSet) {
            return (HashSet)obj;
        }
        return PlatformUtils.ParseStringToLongSet((String)obj.toString());
    }

    private List<Long> getLongList(Map<String, Object> paramMap, String paramName) throws KDException {
        Object obj = paramMap.get(paramName);
        if (obj == null) {
            return new ArrayList<Long>(16);
        }
        if (obj instanceof List) {
            return (List)obj;
        }
        if (obj instanceof ArrayList) {
            return (ArrayList)obj;
        }
        return PlatformUtils.ParseStringToLongList((String)obj.toString());
    }

    private Set<String> getStringSet(Map<String, Object> paramMap, String paramName) throws KDException {
        Object obj = paramMap.get(paramName);
        if (obj == null) {
            return new HashSet<String>(16);
        }
        if (obj instanceof Set) {
            return (Set)obj;
        }
        if (obj instanceof HashSet) {
            return (HashSet)obj;
        }
        return PlatformUtils.ParseStringToSet((String)obj.toString());
    }

    private DynamicObject getDynamicObject(Map<String, Object> paramMap, String paramName) throws KDException {
        return paramMap.get(paramName) == null ? null : (DynamicObject)paramMap.get(paramName);
    }

    private Date getMinSupplyDate(Map<String, Object> paramMap) throws KDException {
        return paramMap.get("minSupplyDate") == null ? null : (Date)paramMap.get("minSupplyDate");
    }

    private List<Long> getModelIds(Map<String, Object> paramMap) throws KDException {
        return paramMap.get("modelIds") == null ? new ArrayList(16) : (List)paramMap.get("modelIds");
    }

    private Map<String, String> getEnvCacheMap(Map<String, Object> paramMap) throws KDException {
        return paramMap.get("envCacheMap") == null ? new HashMap(16) : (HashMap)paramMap.get("envCacheMap");
    }
}

