/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.business.ecoplatform.estimate.step.exec;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.mmc.pdm.business.ecoplatform.estimate.step.EcoEstimateBaseStep;
import kd.mmc.pdm.common.bom.ecoplatform.PlatformUtils;
import kd.mpscmm.msplan.mservice.service.datafetch.util.DataSourceFetchDataUtil;
import kd.mpscmm.msplan.mservice.service.mrp.ExecutionEnv;

public class EffectRangeGetSupplyDataImpl
extends EcoEstimateBaseStep {
    private static final Log log = LogFactory.getLog(EffectRangeGetSupplyDataImpl.class);
    private static EffectRangeGetSupplyDataImpl impl;

    public static EffectRangeGetSupplyDataImpl getInstance() {
        if (impl == null) {
            impl = new EffectRangeGetSupplyDataImpl();
        }
        return impl;
    }

    public int exec(ExecutionEnv env, DynamicObject planProgram, DynamicObject runLog, Map<String, String> envCacheMap, Set<String> supAndReqKeySet, Set<Long> materialIdSet, List<Long> modelIds, boolean isCache) {
        if (env != null) {
            this.init(env);
            envCacheMap = env.getParams();
        } else {
            this.init(runLog);
        }
        int planOutLookDay = this.getPlanOutLook(planProgram);
        int supplyDelayPeriod = this.getSupplyDelayPeriod(planProgram);
        Set<Long> supplyOrgs = this.getSupplyOrgs(planProgram);
        Date currentDate = new Date();
        Date toDate = PlatformUtils.addDay((Date)currentDate, (int)planOutLookDay);
        Date fromDate = PlatformUtils.addDay((Date)currentDate, (int)(0 - supplyDelayPeriod));
        Date toMinDate = this.getDate(fromDate, true);
        Date toMaxDate = this.getDate(toDate, false);
        int dataAmount = 0;
        String[] keyFieldNames = this.getSupplyCacheRedisKeyField(planProgram);
        int redisTimeLong = this.getRedisTimeLong();
        JSONObject supObject = new JSONObject();
        Map<Long, String> srcEntityNameMap = this.getSrcEntityName(modelIds);
        Map<Long, String> srcDateFieldMap = this.getSupplyDateSrcFieldMap(modelIds);
        Map<Long, String> srcOrgFieldMap = this.getOrgSrcFieldMap(modelIds);
        DynamicObjectCollection collection = planProgram.getDynamicObjectCollection("scentryentity");
        HashMap<Long, String> rsTypeMap = new HashMap<Long, String>(16);
        for (DynamicObject entry : collection) {
            Long rsId = entry.getLong("resourceregisters.id");
            DynamicObjectCollection dsColl = entry.getDynamicObjectCollection("entryppdemandds");
            if (PlatformUtils.isNullCollection((DynamicObjectCollection)dsColl)) continue;
            HashSet<Long> srcDsIdSet = new HashSet<Long>(16);
            for (DynamicObject mulData : dsColl) {
                srcDsIdSet.add(mulData.getLong("fbasedataid_id"));
            }
            rsTypeMap.put(rsId, ((Object)srcDsIdSet).toString());
        }
        for (Long modelId : modelIds) {
            String srcEntityName = srcEntityNameMap.get(modelId);
            DataSet dsItem = null;
            QFilter filter = null;
            String orgFieldNumber = srcOrgFieldMap.get(modelId);
            if (StringUtils.isEmpty((String)orgFieldNumber)) {
                log.info("------------EffectRangeGetSupplyDataImpl------dsItem is null -------modelId=" + modelId + ",orgFieldNumber is null ,continue ");
                continue;
            }
            QFilter orgQFilter = new QFilter(orgFieldNumber, "in", supplyOrgs);
            if (!"1".equals(planProgram.getString("scoutofdate"))) {
                String srcBillDate = srcDateFieldMap.get(modelId);
                if (!StringUtils.isEmpty((String)srcBillDate)) {
                    filter = new QFilter(srcBillDate, ">=", (Object)toMinDate);
                    filter.and(new QFilter(srcBillDate, "<=", (Object)toMaxDate));
                    dsItem = DataSourceFetchDataUtil.getDataSetByModel((Long)modelId, materialIdSet, (QFilter)filter.and(orgQFilter));
                } else {
                    dsItem = DataSourceFetchDataUtil.getDataSetByModel((Long)modelId, materialIdSet, (QFilter)orgQFilter);
                }
            } else {
                dsItem = DataSourceFetchDataUtil.getDataSetByModel((Long)modelId, materialIdSet, (QFilter)orgQFilter);
            }
            if (dsItem == null) {
                log.info("------------EffectRangeGetSupplyDataImpl------dsItem is null -------modelId=" + modelId + ",srcEntityName=" + srcEntityName + ",materialIdSet=" + materialIdSet.toString());
                if (filter != null) {
                    log.info("------------EffectRangeGetSupplyDataImpl------dsItem is null -------filter=" + filter);
                }
                log.info("------------EffectRangeGetSupplyDataImpl------dsItem is null -------orgQFilter=" + orgQFilter);
                continue;
            }
            dsItem = this.formatEntryEntity(dsItem);
            RowMeta rowMeta = dsItem.getRowMeta();
            String[] fieldNames = rowMeta.getFieldNames();
            String srcDsIds = (String)rsTypeMap.get(modelId);
            while (dsItem.hasNext()) {
                String cacheKeyString;
                Row row = dsItem.next();
                BigDecimal supQty = row.getBigDecimal("qty");
                if (supQty.compareTo(BigDecimal.ZERO) == 0 || !supAndReqKeySet.contains(cacheKeyString = this.getRowKeyString(row, keyFieldNames, null))) continue;
                JSONObject dataObject = new JSONObject();
                for (int keySize = 0; keySize < fieldNames.length; ++keySize) {
                    String fieldName = fieldNames[keySize];
                    Object value = row.get(fieldName);
                    dataObject.put(fieldName, value);
                }
                dataObject.put("srcdatasourceids", (Object)srcDsIds);
                JSONArray list = supObject.getJSONArray(cacheKeyString);
                if (list == null) {
                    list = new JSONArray();
                }
                list.add((Object)dataObject);
                supObject.put(cacheKeyString, (Object)list);
                ++dataAmount;
            }
            dsItem.close();
        }
        for (String cacheKeyString : supAndReqKeySet) {
            JSONArray list = supObject.getJSONArray(cacheKeyString);
            if (list == null || list.isEmpty()) continue;
            this.setCacheValue(envCacheMap, this.getSupplyCacheString(cacheKeyString), list.toJSONString(), redisTimeLong);
        }
        if (isCache) {
            String requireDataAmountCacheStr = this.getRequireDataAmountCacheString();
            this.getAndSetAddCacheValueLock(envCacheMap, requireDataAmountCacheStr, dataAmount, redisTimeLong);
        }
        return dataAmount;
    }
}

