/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.business.formula;

import java.util.ArrayList;
import java.util.List;
import kd.mmc.pdm.business.formula.IToken;
import kd.mmc.pdm.business.formula.ParseException;
import kd.mmc.pdm.business.formula.enums.ConnectType;
import kd.mmc.pdm.business.formula.enums.OperatorType;
import kd.mmc.pdm.business.formula.enums.TokenType;
import kd.mmc.pdm.business.formula.token.AttributeFetchToken;
import kd.mmc.pdm.business.formula.token.CalculatorToken;
import kd.mmc.pdm.business.formula.token.ColumnToken;
import kd.mmc.pdm.business.formula.token.ConnectToken;
import kd.mmc.pdm.business.formula.token.ConstToken;
import kd.mmc.pdm.business.formula.token.FieldToken;
import kd.mmc.pdm.business.formula.token.IFToken;
import kd.mmc.pdm.business.formula.token.MethodToken;
import kd.mmc.pdm.business.formula.token.OperatorToken;
import kd.mmc.pdm.business.formula.token.ParamToken;
import kd.mmc.pdm.business.formula.token.TableToken;

public class FormulaParseBusiness {
    private char[] chars;
    private int pos;
    private String type;
    private boolean isTable = false;
    private List<IToken> tokens = new ArrayList<IToken>();

    public FormulaParseBusiness(String exprStr) {
        this.chars = exprStr.toCharArray();
    }

    public FormulaParseBusiness(String exprStr, String ruleType) {
        this.chars = exprStr.toCharArray();
        this.type = ruleType;
    }

    private String nextToken() {
        boolean isTokenFound = false;
        int wordStart = -1;
        block4: while (this.pos != this.chars.length) {
            char c = this.chars[this.pos++];
            switch (c) {
                case '%': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case ';': 
                case '<': 
                case '=': 
                case '>': {
                    --this.pos;
                    if (!isTokenFound) continue block4;
                    return new String(this.chars, wordStart, this.pos - wordStart);
                }
                case '\n': 
                case '\r': 
                case ' ': {
                    if (!isTokenFound) continue block4;
                    return new String(this.chars, wordStart, this.pos - wordStart - 1);
                }
            }
            if (isTokenFound) continue;
            wordStart = this.pos - 1;
            isTokenFound = true;
        }
        return new String(this.chars, wordStart, this.pos - wordStart);
    }

    private String nextPhrase() {
        boolean isTokenFound = false;
        int wordStart = -1;
        while (true) {
            switch (this.chars[this.pos++]) {
                case '\"': 
                case '\'': {
                    if (!isTokenFound) {
                        isTokenFound = true;
                        wordStart = this.pos - 1;
                        break;
                    }
                    return new String(this.chars, wordStart, this.pos - wordStart);
                }
            }
        }
    }

    public List<IToken> parse() throws ParseException {
        ColumnToken col = null;
        ParamToken param = null;
        AttributeFetchToken current = null;
        IFToken ifToken = null;
        this.pos = 0;
        block24: while (this.pos < this.chars.length) {
            char c = this.chars[this.pos];
            switch (c) {
                case '\n': 
                case ' ': 
                case ';': {
                    ++this.pos;
                    break;
                }
                case '(': {
                    ++this.pos;
                    this.tokens.add(new ConstToken("(", TokenType.LEFTBRACKET));
                    break;
                }
                case ')': {
                    ++this.pos;
                    this.tokens.add(new ConstToken(")", TokenType.RIGHTBRACKET));
                    this.isTable = false;
                    break;
                }
                case 'A': 
                case 'a': {
                    String word = this.nextToken();
                    if ("and".equalsIgnoreCase(word)) {
                        this.tokens.add(new ConnectToken(ConnectType.AND));
                        break;
                    }
                    col = this.createColAndParams(word, col, current, param);
                    break;
                }
                case 'O': 
                case 'o': {
                    String word = this.nextToken();
                    if ("or".equalsIgnoreCase(word)) {
                        this.tokens.add(new ConnectToken(ConnectType.OR));
                        break;
                    }
                    col = this.createColAndParams(word, col, current, param);
                    break;
                }
                case 'I': 
                case 'i': {
                    String word = this.nextToken();
                    if ("in".equalsIgnoreCase(word)) {
                        this.tokens.add(new OperatorToken(OperatorType.IN));
                        break;
                    }
                    if ("is".equalsIgnoreCase(word)) {
                        word = this.nextToken();
                        if ("not".equalsIgnoreCase(word)) {
                            word = this.nextToken();
                            if (!"null".equalsIgnoreCase(word)) continue block24;
                            this.tokens.add(new OperatorToken(OperatorType.ISNOTNULL));
                            break;
                        }
                        if (!"null".equalsIgnoreCase(word)) continue block24;
                        this.tokens.add(new OperatorToken(OperatorType.ISNULL));
                        break;
                    }
                    if ("if".equalsIgnoreCase(word)) {
                        ifToken = new IFToken();
                        this.tokens.add(ifToken);
                        break;
                    }
                    col = this.createColAndParams(word, col, current, param);
                    break;
                }
                case 'N': 
                case 'n': {
                    String word = this.nextToken();
                    if ("not".equalsIgnoreCase(word)) {
                        this.tokens.add(new OperatorToken(OperatorType.NOT));
                        break;
                    }
                    col = this.createColAndParams(word, col, current, param);
                    break;
                }
                case 'S': 
                case 's': {
                    String word = this.nextToken();
                    if ("set_default".equals(word)) {
                        this.tokens.add(new MethodToken(word));
                        break;
                    }
                    col = this.createColAndParams(word, col, current, param);
                    break;
                }
                case 'T': 
                case 't': {
                    String word = this.nextToken();
                    if ("table".equalsIgnoreCase(word)) {
                        word = this.nextToken();
                        this.tokens.add(new TableToken(word));
                        this.isTable = true;
                        break;
                    }
                    col = this.createColAndParams(word, col, current, param);
                    break;
                }
                case '\"': 
                case '\'': {
                    String word = this.nextPhrase();
                    this.tokens.add(new ConstToken(word, TokenType.CONST));
                    break;
                }
                case '=': {
                    ++this.pos;
                    if (ifToken == null) {
                        if ("3".equals(this.type)) {
                            this.tokens.add(new OperatorToken(OperatorType.SETVAL));
                            break;
                        }
                        this.tokens.add(new OperatorToken(OperatorType.EQUALS));
                        break;
                    }
                    this.tokens.add(new OperatorToken(OperatorType.EQUALS));
                    break;
                }
                case '<': {
                    ++this.pos;
                    if (this.chars[this.pos] == '=') {
                        this.tokens.add(new OperatorToken(OperatorType.EQUALSLESS));
                        ++this.pos;
                        break;
                    }
                    if (this.chars[this.pos] == '>') {
                        this.tokens.add(new OperatorToken(OperatorType.NOTEQUALS));
                        ++this.pos;
                        break;
                    }
                    this.tokens.add(new OperatorToken(OperatorType.LESS));
                    break;
                }
                case '>': {
                    if (this.chars[++this.pos] == '=') {
                        this.tokens.add(new OperatorToken(OperatorType.EQUALSOVER));
                        break;
                    }
                    this.tokens.add(new OperatorToken(OperatorType.OVER));
                    break;
                }
                case '+': {
                    ++this.pos;
                    this.tokens.add(new CalculatorToken(OperatorType.PLUS));
                    break;
                }
                case '-': {
                    String word;
                    ++this.pos;
                    if (this.tokens.size() > 0 && this.tokens.get(this.tokens.size() - 1).getType() == TokenType.OPERATOR || this.tokens.isEmpty()) {
                        word = this.nextToken();
                        if (word.startsWith("@")) {
                            col = new ColumnToken(word, true);
                            break;
                        }
                        if (word.startsWith("#")) {
                            param = new ParamToken(word, true);
                            break;
                        }
                        this.tokens.add(new ConstToken("-" + word, TokenType.NUMBER));
                        break;
                    }
                    this.tokens.add(new CalculatorToken(OperatorType.MINUS));
                    break;
                }
                case '*': {
                    ++this.pos;
                    this.tokens.add(new CalculatorToken(OperatorType.MULTIPLE));
                    break;
                }
                case '/': {
                    ++this.pos;
                    this.tokens.add(new CalculatorToken(OperatorType.DIVIDE));
                    break;
                }
                case '%': {
                    ++this.pos;
                    this.tokens.add(new CalculatorToken(OperatorType.REMAINDER));
                    break;
                }
                case ',': {
                    ++this.pos;
                    this.tokens.add(new ConstToken(",", TokenType.COMMA));
                    this.createField();
                    break;
                }
                case '$': {
                    String word = this.nextToken();
                    if ("$set_default".equalsIgnoreCase(word)) {
                        this.tokens.add(new MethodToken(word));
                        break;
                    }
                    if (this.isField(word)) {
                        this.tokens.add(new FieldToken(word));
                        break;
                    }
                    if (this.isTable && "$self".equalsIgnoreCase(word)) {
                        col = new ColumnToken("field", false);
                        break;
                    }
                    col = new ColumnToken("params", false);
                    break;
                }
                case '.': {
                    String word;
                    ++this.pos;
                    if (this.pos == this.chars.length) break;
                    String colName = "";
                    if (col != null) {
                        colName = col.getColName();
                    }
                    if ("field".equalsIgnoreCase(colName) && this.isTable) {
                        word = this.nextToken();
                        this.tokens.add(new FieldToken(word));
                        break;
                    }
                    current = new AttributeFetchToken();
                    this.tokens.add(current);
                    current.setCol(col);
                    word = this.nextToken();
                    param = new ParamToken(word, false);
                    if (current == null) continue block24;
                    current.setParam(param);
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    String word = this.nextToken();
                    int index = this.pos;
                    if (this.chars.length - 1 >= this.pos + 1 && '.' == this.chars[this.pos]) {
                        ++this.pos;
                        String word2 = this.nextToken();
                        String str = "^[0-9]*$";
                        if (word2 != null && word2.matches(str)) {
                            word = word + "." + word2;
                        } else {
                            this.pos = index;
                        }
                    }
                    this.tokens.add(new ConstToken(word, TokenType.NUMBER));
                    break;
                }
                default: {
                    String word;
                    String str = "[a-zA-Z0-9]";
                    String c1 = String.valueOf(c);
                    if (c1.matches(str)) {
                        word = this.nextToken();
                        col = this.createColAndParams(word, col, current, param);
                        break;
                    }
                    throw new ParseException("unknown character");
                }
            }
        }
        return this.tokens;
    }

    private boolean isField(String word) {
        char c;
        String c1;
        boolean retFlag = false;
        int index = this.pos;
        int length = this.chars.length;
        StringBuilder sb = new StringBuilder();
        while (index < length && !",".equals(c1 = String.valueOf(c = this.chars[index++]))) {
            sb.append(c1);
        }
        sb.append(word);
        String tarObj = sb.toString();
        int tarLength = tarObj.trim().length();
        if (tarLength == word.trim().length()) {
            retFlag = true;
        }
        return retFlag;
    }

    private void createField() {
        String str = "[a-zA-Z0-9]";
        int length = this.chars.length;
        boolean flag = true;
        for (int index = this.pos; index < length; ++index) {
            char c = this.chars[index];
            String c1 = String.valueOf(c);
            if (!("_".equals(c1) || ",".equals(c1) || " ".equals(c1) || c1.matches(str))) {
                flag = false;
                return;
            }
            if (!",".equals(c1)) continue;
            flag = true;
            break;
        }
        if (flag) {
            String word = this.nextToken();
            if (word != null) {
                word = word.trim();
            }
            this.tokens.add(new FieldToken(word));
        }
    }

    private ColumnToken createColAndParams(String word, ColumnToken col, AttributeFetchToken current, ParamToken param) {
        if (this.pos <= this.chars.length - 1 && this.chars[this.pos] == '.') {
            col = new ColumnToken("params", false);
            return col;
        }
        col = new ColumnToken("params", false);
        current = new AttributeFetchToken();
        this.tokens.add(current);
        current.setCol(col);
        param = new ParamToken(word, false);
        if (current != null) {
            current.setParam(param);
        }
        return null;
    }
}

