/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.business.formula.token;

import com.alibaba.fastjson.JSONArray;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import kd.mmc.pdm.business.formula.ExprContext;
import kd.mmc.pdm.business.formula.IToken;
import kd.mmc.pdm.business.formula.enums.OperatorType;
import kd.mmc.pdm.business.formula.enums.TokenType;

public class CalculatorToken
implements IToken {
    private OperatorType type;
    private int level = 1;

    public CalculatorToken(OperatorType type) {
        this.type = type;
        switch (type) {
            case PLUS: {
                this.level = 1;
                break;
            }
            case MINUS: {
                this.level = 1;
                break;
            }
            case MULTIPLE: {
                this.level = 2;
                break;
            }
            case DIVIDE: {
                this.level = 2;
                break;
            }
            case REMAINDER: {
                this.level = 2;
            }
        }
    }

    @Override
    public void action(ExprContext ctx) {
        JSONArray array;
        Object rightOperand = ctx.getStack().pop();
        Object leftOperand = ctx.getStack().pop();
        Object compareValue = new Object();
        if (leftOperand != null && leftOperand.getClass().isArray()) {
            leftOperand = Array.get(leftOperand, 0);
        } else if (leftOperand instanceof List) {
            leftOperand = ((List)leftOperand).get(0);
        } else if (leftOperand instanceof JSONArray) {
            array = (JSONArray)leftOperand;
            leftOperand = array.size() > 0 ? ((JSONArray)leftOperand).get(0) : null;
        }
        if (rightOperand != null && rightOperand.getClass().isArray()) {
            rightOperand = Array.get(rightOperand, 0);
        } else if (leftOperand != null && rightOperand instanceof JSONArray) {
            array = (JSONArray)rightOperand;
            rightOperand = array.size() > 0 ? ((JSONArray)rightOperand).get(0) : null;
        }
        if (rightOperand == null && leftOperand == null) {
            ctx.getStack().push(null);
            return;
        }
        switch (this.type) {
            case PLUS: {
                if (leftOperand instanceof String || rightOperand instanceof String) {
                    compareValue = String.valueOf(leftOperand) + String.valueOf(rightOperand);
                    break;
                }
                try {
                    BigDecimal leftVal = new BigDecimal(leftOperand == null ? "0" : leftOperand.toString());
                    BigDecimal rightVal = new BigDecimal(rightOperand == null ? "0" : rightOperand.toString());
                    compareValue = leftVal.add(rightVal);
                }
                catch (NumberFormatException e) {
                    compareValue = String.valueOf(leftOperand) + String.valueOf(rightOperand);
                }
                break;
            }
            case MINUS: {
                compareValue = this.getBigDecimal(leftOperand).add(this.getBigDecimal(rightOperand).negate());
                break;
            }
            case MULTIPLE: {
                BigDecimal leftQty = this.getBigDecimal(leftOperand);
                BigDecimal rightQty = this.getBigDecimal(rightOperand);
                compareValue = leftQty.multiply(rightQty);
                break;
            }
            case DIVIDE: {
                BigDecimal rightBigDecimal = this.getBigDecimal(rightOperand);
                compareValue = this.getBigDecimal(leftOperand).divide(rightBigDecimal, 10, RoundingMode.UP);
                break;
            }
            case REMAINDER: {
                int left = this.getBigDecimal(leftOperand).intValue();
                int right = this.getBigDecimal(rightOperand).intValue();
                compareValue = new BigDecimal(left % right);
                break;
            }
        }
        ctx.getStack().push(compareValue);
    }

    private BigDecimal getBigDecimal(Object operand) {
        if (operand == null || "".equals(operand)) {
            return new BigDecimal("0");
        }
        if (operand.getClass().isArray()) {
            Object first = Array.get(operand, 0);
            return new BigDecimal(first.toString());
        }
        return new BigDecimal(operand.toString());
    }

    public OperatorType getOperatorType() {
        return this.type;
    }

    public int getLevel() {
        return this.level;
    }

    @Override
    public TokenType getType() {
        return TokenType.CALCULATOR;
    }

    @Override
    public void setIsFieldOp(boolean isFieldOp) {
    }

    public String toString() {
        switch (this.type) {
            case PLUS: {
                return " + ";
            }
            case MINUS: {
                return " - ";
            }
            case MULTIPLE: {
                return " * ";
            }
            case DIVIDE: {
                return " / ";
            }
            case REMAINDER: {
                return " % ";
            }
        }
        return " __UNRESOLVED_OPERATOR_TYPE__";
    }
}

