/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.business.formula.token;

import java.math.BigDecimal;
import kd.mmc.pdm.business.formula.ExprContext;
import kd.mmc.pdm.business.formula.IToken;
import kd.mmc.pdm.business.formula.enums.TokenType;

public class ConstToken
implements IToken {
    private String phrase;
    private TokenType type;

    public ConstToken(String phrase, TokenType type) {
        this.phrase = phrase;
        this.type = type;
    }

    @Override
    public void action(ExprContext ctx) {
        if (this.type == TokenType.CONST) {
            ctx.getStack().push(this.phrase.substring(1, this.phrase.length() - 1));
        } else if (this.type == TokenType.NUMBER) {
            ctx.getStack().push(new BigDecimal(this.phrase));
        } else if (this.type != TokenType.COMMA && this.type == TokenType.PLACEHOLD) {
            ctx.getStack().push(" ");
        }
    }

    @Override
    public TokenType getType() {
        return this.type;
    }

    public String toString() {
        return this.phrase;
    }

    @Override
    public void setIsFieldOp(boolean isFieldOp) {
    }
}

