/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.business.init.impl;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bd.mpdm.common.query.helper.OrgQueryHelper;
import kd.bd.mpdm.common.utils.DynamicObjDataUtil;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataService;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.pdm.business.ecoplatform.EcoCommonBusiness;
import kd.mmc.pdm.business.init.IPdmInitBase;
import kd.mmc.pdm.common.bom.ecoplatform.PlatformUtils;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;

public class AbstractInitBaseImpl
implements IPdmInitBase {
    private static final Log log = LogFactory.getLog(AbstractInitBaseImpl.class);
    private String entityNumber = "";
    private String initBaseNumber = "";
    private String initBaseName = "";
    private Long orgId = 0L;

    public void init(Long orgId, String initBaseNumber, String initBaseName, String entityNumber) {
        this.setEntityNumber(entityNumber);
        this.setInitBaseNumber(initBaseNumber);
        this.setInitBaseName(initBaseName);
        this.setOrgId(orgId);
    }

    public String getEntityNumber() {
        return this.entityNumber;
    }

    public void setEntityNumber(String entitynumber) {
        this.entityNumber = entitynumber;
    }

    public String getInitBaseNumber() {
        return this.initBaseNumber;
    }

    public void setInitBaseNumber(String initbasenumber) {
        this.initBaseNumber = initbasenumber;
    }

    public String getInitBaseName() {
        return this.initBaseName;
    }

    public void setInitBaseName(String initbasename) {
        this.initBaseName = initbasename;
    }

    public Long getOrgId() {
        return this.orgId;
    }

    public void setOrgId(Long orgid) {
        this.orgId = orgid;
    }

    @Override
    public String checkData() {
        return "";
    }

    public Long getDynamicObjectId(String entityNumber, Long orgId, String number) {
        QFilter qfilter = new QFilter("createorg", "=", (Object)orgId);
        qfilter.and(new QFilter("number", "=", (Object)number));
        DynamicObjectCollection coll = QueryServiceHelper.query((String)entityNumber, (String)"id", (QFilter[])new QFilter[]{qfilter});
        if (coll != null && !coll.isEmpty()) {
            return ((DynamicObject)coll.get(0)).getLong("id");
        }
        return 0L;
    }

    public boolean checkIsEnable(String entityNumber, Long id) {
        QFilter qfilter = new QFilter("id", "=", (Object)id);
        qfilter.and(new QFilter("status", "=", (Object)"C"));
        qfilter.and(new QFilter("enable", "=", (Object)"1"));
        return QueryServiceHelper.exists((String)entityNumber, (QFilter[])new QFilter[]{qfilter});
    }

    public DynamicObject getDynamicObject(String entityNumber, Long orgId, String number) {
        Long id = this.getDynamicObjectId(entityNumber, orgId, number);
        if (id != null && !id.equals(0L)) {
            return BusinessDataServiceHelper.loadSingle((Object)id, (String)entityNumber);
        }
        return null;
    }

    public DynamicObject getDynamicObject(String number) {
        return this.getDynamicObject(this.getEntityNumber(), this.getOrgId(), number);
    }

    public DynamicObject getOrg() {
        return BusinessDataServiceHelper.loadSingleFromCache((Object)this.getOrgId(), (String)"bos_org");
    }

    @Override
    public String execInitData() {
        return null;
    }

    public DynamicObject buildDefault(String entityNumber, DynamicObject newObject) {
        Long currentUserId = RequestContext.get().getCurrUserId();
        Date currentDate = new Date();
        if (newObject == null) {
            newObject = BusinessDataServiceHelper.newDynamicObject((String)entityNumber);
            newObject.set("id", (Object)ORM.create().genLongId(entityNumber));
            newObject.set("masterid", newObject.get("id"));
            newObject.set("creator", (Object)currentUserId);
            newObject.set("createtime", (Object)currentDate);
        }
        newObject.set("ctrlstrategy", (Object)"7");
        newObject.set("enable", (Object)"1");
        newObject.set("status", (Object)"C");
        newObject.set("modifier", (Object)currentUserId);
        newObject.set("modifytime", (Object)currentDate);
        return newObject;
    }

    public String getDbKey(String entity) {
        return ORM.create().getDataEntityType(entity).getDBRouteKey();
    }

    public void saveData(DynamicObject newObject) {
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newObject});
    }

    public void saveDataByOperator(DynamicObject newObject, boolean isSubmitAudit) {
        String errorString;
        OperateOption option = this.getOperateOption();
        String entityNumber = newObject.getDataEntityType().getName();
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)entityNumber, (DynamicObject[])new DynamicObject[]{newObject}, (OperateOption)option);
        if (saveResult.getAllErrorOrValidateInfo() != null && !kd.bos.util.StringUtils.isEmpty((String)(errorString = PlatformUtils.getErrorMsg((OperationResult)saveResult)))) {
            String errorStr = String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u6570\u636e\u65f6\u53d1\u751f\u9519\u8bef\uff1a%1$s", (String)"AbstractInitBaseImpl_01", (String)"mmc-pdm-business", (Object[])new Object[0]), errorString);
            throw new KDBizException(errorStr);
        }
        if (isSubmitAudit) {
            List successDataList = saveResult.getSuccessPkIds();
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"submit", (String)entityNumber, (Object[])successDataList.toArray(), (OperateOption)this.getOperateOption());
            String errorMsg = EcoCommonBusiness.getErrorMsg(operationResult);
            if (!kd.bos.util.StringUtils.isEmpty((String)errorMsg)) {
                String errorStr = String.format(ResManager.loadKDString((String)"\u63d0\u4ea4\u6570\u636e\u65f6\u53d1\u751f\u9519\u8bef\uff1a%1$s", (String)"AbstractInitBaseImpl_02", (String)"mmc-pdm-business", (Object[])new Object[0]), errorMsg);
                throw new KDBizException(errorStr);
            }
            List submitSuccessPkList = operationResult.getSuccessPkIds();
            errorMsg = EcoCommonBusiness.getErrorMsg(operationResult = OperationServiceHelper.executeOperate((String)"audit", (String)entityNumber, (Object[])submitSuccessPkList.toArray(), (OperateOption)this.getOperateOption()));
            if (!kd.bos.util.StringUtils.isEmpty((String)errorMsg)) {
                String errorStr = String.format(ResManager.loadKDString((String)"\u5ba1\u6838\u6570\u636e\u65f6\u53d1\u751f\u9519\u8bef\uff1a%1$s", (String)"AbstractInitBaseImpl_03", (String)"mmc-pdm-business", (Object[])new Object[0]), errorMsg);
                throw new KDBizException(errorStr);
            }
        }
    }

    public OperateOption getOperateOption() {
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("ignorewarn", "true");
        option.setVariableValue("ignoreinteraction", "true");
        option.setVariableValue("batchop_batchsize", "50");
        option.setVariableValue("needlog", String.valueOf(true));
        return option;
    }

    public static boolean isEn_US() {
        return StringUtils.equalsIgnoreCase((CharSequence)ResManager.getLanguage(), (CharSequence)"en_US");
    }

    public String enName(String fileName) {
        return fileName + "_en";
    }

    public String getXmlString(String fileName) {
        SAXReader saxReader = new SAXReader();
        String xmlString = "";
        String fullFileName = fileName + ".xml";
        try (InputStream input = AbstractInitBaseImpl.class.getResourceAsStream("/" + fullFileName);){
            Document document = saxReader.read(input);
            xmlString = document.asXML();
        }
        catch (Exception e) {
            log.error((Throwable)e);
            xmlString = "";
            String errorStr = String.format(ResManager.loadKDString((String)"\u8bfb\u53d6%1$s\u6587\u4ef6\u5931\u8d25\uff1a%2$s", (String)"AbstractInitBaseImpl_04", (String)"mmc-pdm-business", (Object[])new Object[0]), fullFileName, e.getMessage());
            throw new KDBizException(errorStr);
        }
        return xmlString;
    }

    public String getSqlString(String fileName) {
        return this.getUTF8String(fileName + ".sql");
    }

    public String getTxtString(String fileName) {
        return this.getUTF8String(fileName);
    }

    public String getUTF8String(String fullFileName) {
        StringBuilder sqlFiels = new StringBuilder();
        try (InputStream input = AbstractInitBaseImpl.class.getResourceAsStream("/" + fullFileName);){
            if (input != null) {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(input, "UTF-8"));
                while ((line = reader.readLine()) != null) {
                    sqlFiels.append(line);
                }
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            String errorStr = String.format(ResManager.loadKDString((String)"\u8bfb\u53d6%1$s\u6587\u4ef6\u5931\u8d25\uff1a%2$s", (String)"AbstractInitBaseImpl_04", (String)"mmc-pdm-business", (Object[])new Object[0]), fullFileName, e.getMessage());
            throw new KDBizException(errorStr);
        }
        return sqlFiels.toString();
    }

    public String getOrgName(Long orgId) {
        DynamicObject org = OrgQueryHelper.getDataCacheByID((Object)orgId);
        return org.getString("name");
    }

    public boolean isPrivateCtrl(String ctrl) {
        return "7".equals(ctrl);
    }

    public String getDefaultCt(String entityNumber, String orgId) {
        String ctrlStrategy = BaseDataServiceHelper.getBdCtrlStrgy((String)entityNumber, (String)orgId);
        if (kd.bos.util.StringUtils.isEmpty((String)ctrlStrategy)) {
            DynamicObject defCtrlStrDO = BaseDataServiceHelper.getDefaultCtrlStrtgy((String)entityNumber);
            ctrlStrategy = defCtrlStrDO == null ? "5" : DynamicObjDataUtil.getDynamicObjectStringData((DynamicObject)defCtrlStrDO, (String)"defaultctrlstrategy");
        }
        return ctrlStrategy;
    }

    public DBRoute getDBRoute() {
        return new DBRoute(this.getDbKey(this.getEntityNumber()));
    }

    public DBRoute getScmDBRoute() {
        return new DBRoute("scm");
    }

    public void clearCache() {
        this.clearCache(this.getEntityNumber());
    }

    public void clearCache(String entityNumber) {
        BaseDataService baseDataService = new BaseDataService();
        baseDataService.clearBaseDataFilterCache(entityNumber, this.getOrgId());
        ArrayList<Long> orgIDList = new ArrayList<Long>(1);
        orgIDList.add(this.getOrgId());
        BaseDataServiceHelper.refreshBaseDataUseRange((String)entityNumber, orgIDList);
    }

    @Override
    public String execSqlData() {
        return null;
    }

    @Override
    public boolean checkIsExistsData() {
        return false;
    }

    public int execSqlFieldData(DBRoute dbRoute, String fileName, int sqlLoop, boolean isSplit) {
        String[] sqls;
        String sqlFiles = this.getSqlString(fileName);
        int currentSeq = sqlLoop;
        if (!isSplit) {
            if (this.execSql(dbRoute, sqlFiles)) {
                ++currentSeq;
                log.info("---mmc.pdm.AbstractInitBaseImpl.execSqlData,seq=" + sqlLoop + ",orgId = " + this.getOrgId() + ",fileName=" + fileName + ",sql=" + sqlFiles);
            }
            return currentSeq;
        }
        for (String sql : sqls = sqlFiles.split(";")) {
            if (!this.execSql(dbRoute, sql)) continue;
            ++currentSeq;
            log.info("---mmc.pdm.AbstractInitBaseImpl.execSqlData,seq=" + sqlLoop + ",orgId = " + this.getOrgId() + ",fileName=" + fileName + ",sql=" + sql);
        }
        return currentSeq;
    }

    public long getDataTablePkId(DBRoute dbRoute, String sql, String number, Long orgId) {
        long id = 0L;
        try (DataSet ds = DB.queryDataSet((String)(AbstractInitBaseImpl.class.getName() + "_getDataTablePkId"), (DBRoute)dbRoute, (String)sql, (Object[])new Object[]{number, orgId});){
            while (ds.hasNext()) {
                Row arow = ds.next();
                id = arow.getLong("fid");
            }
        }
        return id;
    }

    private boolean execSql(DBRoute dbRoute, String sql) {
        if (kd.bos.util.StringUtils.isEmpty((String)(sql = sql.trim()))) {
            return false;
        }
        if (sql.startsWith("//") || sql.startsWith("--")) {
            return false;
        }
        DB.execute((DBRoute)dbRoute, (String)sql);
        return true;
    }
}

