/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.business.init.impl;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.mmc.pdm.business.init.InitDataUtils;
import kd.mmc.pdm.business.init.impl.AbstractInitBaseImpl;
import kd.mmc.pdm.common.bom.init.InitConsts;

public class ResourceModelInitImpl
extends AbstractInitBaseImpl {
    private static final Log log = LogFactory.getLog(ResourceModelInitImpl.class);

    public static ResourceModelInitImpl getInstance(Long org) {
        return new ResourceModelInitImpl(org);
    }

    @Override
    public String checkData() {
        String msg = super.checkData();
        if (!InitDataUtils.isRootOrg(this.getOrgId())) {
            msg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u751f\u4ea7\u7ec4\u7ec7\u4e0d\u662f\u6839\u7ec4\u7ec7[%1$s]\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u5168\u5c40\u5171\u4eab\u7c7b\u6570\u636e\u7684\u521d\u59cb\u5316\u8bbe\u7f6e\u3002", (String)"ResourceModelInitImpl_01", (String)"mmc-pdm-business", (Object[])new Object[0]), this.getOrgName(InitDataUtils.getRootOrg()));
            return msg;
        }
        return msg;
    }

    public static Set<String> getBillFieldTransferNumberSet() {
        HashSet<String> numberSet = new HashSet<String>(64);
        numberSet.add("er_cop_pdm_eco_S");
        numberSet.add("er_c_pdm_eco_S");
        numberSet.add("er_inv_realbala_S");
        numberSet.add("er_mrp_planorder_cp_S");
        numberSet.add("er_mrp_planorder_S");
        numberSet.add("er_om_mftorder_S");
        numberSet.add("er_om_purorder_S");
        numberSet.add("er_pm_purapply_S");
        numberSet.add("er_pm_purorder_S");
        numberSet.add("er_pom_mftorder_S");
        numberSet.add("er_p_pdm_eco_S");
        numberSet.add("er_s_r_S");
        numberSet.add("estimate_om_stock_S");
        numberSet.add("estimate_pdm_eco_S");
        numberSet.add("estimate_pom_stock_S");
        numberSet.add("estimate_s_r_S");
        return numberSet;
    }

    public static Set<String> getResourceRegisterNumberSet() {
        HashSet<String> numberSet = new HashSet<String>(64);
        numberSet.add("eco_effectrange_demand_S");
        numberSet.add("eco_effectrange_supply_S");
        numberSet.add("eco_estimate_require_S");
        numberSet.add("eco_estimate_sypply_S");
        return numberSet;
    }

    public static Set<String> getDataSourceNumberSet() {
        HashSet<String> numberSet = new HashSet<String>(64);
        numberSet.add("DS_er_cop_pdm_eco_S");
        numberSet.add("DS_er_c_pdm_eco_S");
        numberSet.add("DS_er_p_pdm_eco_S");
        numberSet.add("DS_er_inv_realbala_S");
        numberSet.add("DS_er_mrp_planorder_cp_S");
        numberSet.add("DS_er_mrp_planorder_S");
        numberSet.add("DS_er_om_mftorder_S");
        numberSet.add("DS_er_om_purorder_S");
        numberSet.add("DS_er_pm_purapply_S");
        numberSet.add("DS_er_pm_purorder_S");
        numberSet.add("DS_er_pom_mftorder_S");
        numberSet.add("DS_estimate_om_mftstock_S");
        numberSet.add("DS_estimate_pom_mftstock_S");
        numberSet.add("DS_estimate_pdm_eco_S");
        return numberSet;
    }

    public static Set<String> getAlgoRegisterNumberSet() {
        HashSet<String> numberSet = new HashSet<String>(64);
        numberSet.add("ecoeffectrange_getrequire_S");
        numberSet.add("ecoeffectrange_getsupply_S");
        numberSet.add("ecoeffectrange_srmatch_S");
        numberSet.add("ecoestimate_effectorder_S");
        numberSet.add("ecoestimate_getrequire_S");
        numberSet.add("ecoestimate_getsupply_S");
        numberSet.add("ecoestimate_srbalance_S");
        numberSet.add("ecoestimate_writedata_S");
        numberSet.add("ecoestimate_clearhisdata_S");
        return numberSet;
    }

    @Override
    public boolean checkIsExistsData() {
        QFilter qfilter = new QFilter("number", "in", ResourceModelInitImpl.getBillFieldTransferNumberSet());
        qfilter.and(new QFilter("createorg", "=", (Object)this.getOrgId()));
        boolean exists = QueryServiceHelper.exists((String)"mrp_billfieldtransfer", (QFilter[])new QFilter[]{qfilter});
        if (!exists) {
            qfilter = new QFilter("number", "in", ResourceModelInitImpl.getResourceRegisterNumberSet());
            qfilter.and(new QFilter("createorg", "=", (Object)this.getOrgId()));
            exists = QueryServiceHelper.exists((String)"mrp_resourceregister_cf", (QFilter[])new QFilter[]{qfilter});
        }
        if (!exists) {
            qfilter = new QFilter("number", "in", ResourceModelInitImpl.getDataSourceNumberSet());
            exists = QueryServiceHelper.exists((String)"mrp_resourceregister_cf", (QFilter[])new QFilter[]{qfilter});
        }
        if (!exists) {
            qfilter = new QFilter("number", "in", ResourceModelInitImpl.getAlgoRegisterNumberSet());
            qfilter.and(new QFilter("createorg", "=", (Object)this.getOrgId()));
            exists = QueryServiceHelper.exists((String)"mrp_algoregister", (QFilter[])new QFilter[]{qfilter});
        }
        return exists;
    }

    public ResourceModelInitImpl(Long orgId) {
        this.setOrgId(orgId);
    }

    @Override
    public String execSqlData() {
        String errorMsg = "";
        try (TXHandle required = TX.requiresNew((String)"ResourceModelInitBusiness-execSqlData");){
            try {
                errorMsg = this.updateModelSqlData();
                if (!StringUtils.isEmpty((String)errorMsg)) {
                    required.markRollback();
                }
            }
            catch (Exception e) {
                log.error((Throwable)e);
                errorMsg = "error:" + e.getMessage();
                required.markRollback();
            }
        }
        if (StringUtils.isEmpty((String)errorMsg)) {
            this.clearCache("mrp_algoregister");
            this.clearCache("mrp_billfieldtransfer");
            this.clearCache("mrp_resourceregister_cf");
            this.clearCache("mrp_resource_dataconfig");
        }
        return errorMsg;
    }

    private String updateModelSqlData() {
        long defBizId;
        Set<String> numberSet;
        String errorMsg = "";
        int sqlLoop = 0;
        String fileName = "";
        DBRoute dbRoute = this.getScmDBRoute();
        Date currentTime = new Date();
        Long currentUserId = RequestContext.get().getCurrUserId();
        Long orgId = InitDataUtils.getRootOrg();
        Long defOrgId = InitConsts.DEFROOTORGID;
        boolean isSameRootOrg = orgId.equals(defOrgId);
        try {
            numberSet = ResourceModelInitImpl.getBillFieldTransferNumberSet();
            for (String number : numberSet) {
                fileName = "billfieldtransfer_" + number;
                sqlLoop = this.execSqlFieldData(dbRoute, fileName, sqlLoop, true);
                if (!isSameRootOrg) {
                    defBizId = this.getDataTablePkId(dbRoute, "select fid from t_mrp_bftransfer  where fnumber = ? And FCREATEORGID = ? ", number, defOrgId);
                    DB.execute((DBRoute)dbRoute, (String)"update t_mrp_bftransfer set FORGID = ?,FCREATEORGID = ?,FMODIFIERID = ?,FMODIFYTIME = ? where fid = ?  ", (Object[])new Object[]{orgId, orgId, currentUserId, currentTime, defBizId});
                    continue;
                }
                DB.execute((DBRoute)dbRoute, (String)"update t_mrp_bftransfer set FMODIFIERID = ?,FMODIFYTIME = ? where fnumber = ? And FCREATEORGID = ? ", (Object[])new Object[]{currentUserId, currentTime, number, defOrgId});
            }
            String pomLargeUpdateFieldNumber = "billfieldtransfer_estimate_pom_stock_S_updatelargetext";
            String omLargeUpdateFieldNumber = "billfieldtransfer_estimate_om_stock_S_updatelargetext";
            sqlLoop = this.execSqlFieldData(dbRoute, pomLargeUpdateFieldNumber, sqlLoop, false);
            sqlLoop = this.execSqlFieldData(dbRoute, omLargeUpdateFieldNumber, sqlLoop, false);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            errorMsg = String.format(ResManager.loadKDString((String)"\u6267\u884c\u5b9e\u4f53\u5b57\u6bb5\u6620\u5c04\u811a\u672c\u6587\u4ef6[%1$s]\u91cc\u7684\u521d\u59cb\u5316\u8bed\u53e5\u5931\u8d25\uff0c\u5f53\u524d\u6267\u884c\u5e8f\u53f7\uff1a%2$s\uff0c\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a%3$s", (String)"ResourceModelInitImpl_02", (String)"mmc-pdm-business", (Object[])new Object[0]), fileName, sqlLoop, e.getMessage());
            return errorMsg;
        }
        try {
            numberSet = ResourceModelInitImpl.getResourceRegisterNumberSet();
            for (String number : numberSet) {
                fileName = "resourceregister_" + number;
                sqlLoop = this.execSqlFieldData(dbRoute, fileName, sqlLoop, true);
                if (!isSameRootOrg) {
                    defBizId = this.getDataTablePkId(dbRoute, "select fid from t_mrp_rsregister where fnumber = ? And FCREATEORGID = ? ", number, defOrgId);
                    DB.execute((DBRoute)dbRoute, (String)"update t_mrp_rsregister set FORGID = ?,FCREATEORGID = ? ,FMODIFIERID = ?,FMODIFYTIME = ? where fid = ? ", (Object[])new Object[]{orgId, orgId, currentUserId, currentTime, defBizId});
                    continue;
                }
                DB.execute((DBRoute)dbRoute, (String)"update t_mrp_rsregister set FMODIFIERID = ?,FMODIFYTIME = ? where fnumber = ? And FCREATEORGID = ? ", (Object[])new Object[]{currentUserId, currentTime, number, orgId});
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            errorMsg = String.format(ResManager.loadKDString((String)"\u6267\u884c\u8d44\u6e90\u6ce8\u518c\u6a21\u578b\u811a\u672c\u6587\u4ef6[%1$s]\u91cc\u7684\u521d\u59cb\u5316\u8bed\u53e5\u5931\u8d25\uff0c\u5f53\u524d\u6267\u884c\u5e8f\u53f7\uff1a%2$s\uff0c\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a%3$s", (String)"ResourceModelInitImpl_03", (String)"mmc-pdm-business", (Object[])new Object[0]), fileName, sqlLoop, e.getMessage());
            return errorMsg;
        }
        try {
            numberSet = ResourceModelInitImpl.getDataSourceNumberSet();
            for (String number : numberSet) {
                fileName = "datasource_" + number;
                sqlLoop = this.execSqlFieldData(dbRoute, fileName, sqlLoop, true);
                DB.execute((DBRoute)dbRoute, (String)"update t_mrp_rsdataconfig set FMODIFIERID = ?,FMODIFYTIME = ? where fnumber = ? ", (Object[])new Object[]{currentUserId, currentTime, number});
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            errorMsg = String.format(ResManager.loadKDString((String)"\u6267\u884c\u6570\u636e\u6e90\u811a\u672c\u6587\u4ef6[%1$s]\u91cc\u7684\u521d\u59cb\u5316\u8bed\u53e5\u5931\u8d25\uff0c\u5f53\u524d\u6267\u884c\u5e8f\u53f7\uff1a%2$s\uff0c\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a%3$s", (String)"ResourceModelInitImpl_04", (String)"mmc-pdm-business", (Object[])new Object[0]), fileName, sqlLoop, e.getMessage());
            return errorMsg;
        }
        try {
            numberSet = ResourceModelInitImpl.getAlgoRegisterNumberSet();
            for (String number : numberSet) {
                fileName = "algoregister_" + number;
                sqlLoop = this.execSqlFieldData(dbRoute, fileName, sqlLoop, true);
                if (!isSameRootOrg) {
                    defBizId = this.getDataTablePkId(dbRoute, "select fid from t_mrp_algoregister  where fnumber = ? And FCREATEORGID = ? ", number, defOrgId);
                    DB.execute((DBRoute)dbRoute, (String)"update t_mrp_algoregister set FORGID = ?,FCREATEORGID = ? ,FMODIFIERID = ?,FMODIFYTIME = ?  where fid = ?  ", (Object[])new Object[]{orgId, orgId, currentUserId, currentTime, defBizId});
                    continue;
                }
                DB.execute((DBRoute)dbRoute, (String)"update t_mrp_algoregister set FMODIFIERID = ?,FMODIFYTIME = ? where fnumber = ? And FCREATEORGID = ? ", (Object[])new Object[]{currentUserId, currentTime, number, orgId});
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            errorMsg = String.format(ResManager.loadKDString((String)"\u6267\u884c\u7b97\u6cd5\u6ce8\u518c\u914d\u7f6e\u811a\u672c\u6587\u4ef6[%1$s]\u91cc\u7684\u521d\u59cb\u5316\u8bed\u53e5\u5931\u8d25\uff0c\u5f53\u524d\u6267\u884c\u5e8f\u53f7\uff1a%2$s\uff0c\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a%3$s", (String)"ResourceModelInitImpl_05", (String)"mmc-pdm-business", (Object[])new Object[0]), fileName, sqlLoop, e.getMessage());
            return errorMsg;
        }
        return "";
    }
}

