/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.business.mftbom.bomsearch;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.pdm.common.util.MMCUtils;

public class BomUnitConvertBusiness {
    public BigDecimal convert(DynamicObject unitObj, BigDecimal covertData, boolean isBackWard) {
        BigDecimal retData = covertData;
        if (unitObj == null) {
            return covertData;
        }
        BigDecimal denominator = unitObj.getBigDecimal("denominator");
        BigDecimal numerator = unitObj.getBigDecimal("numerator");
        retData = MMCUtils.divide((BigDecimal)numerator, (BigDecimal)denominator);
        if (isBackWard) {
            retData = MMCUtils.divide((BigDecimal)denominator, (BigDecimal)numerator);
        }
        return retData;
    }

    private boolean isNullSet(Set<Long> set) {
        return set == null || set.isEmpty();
    }

    private Map<String, DynamicObject> getMultiTypeUnit(Set<Long> materialIdSet, Set<Long> unitSet, Map<String, DynamicObject> unitMap) {
        if (this.isNullSet(materialIdSet) || this.isNullSet(unitSet)) {
            return unitMap;
        }
        String fields = "materialid,measureunitid,denominator,numerator";
        QFilter filter1 = new QFilter("measureunitid", "in", unitSet);
        QFilter filter2 = new QFilter("converttype", "=", (Object)"1");
        QFilter filter3 = new QFilter("materialid", "in", materialIdSet);
        DynamicObjectCollection col = QueryServiceHelper.query((String)"bd_multimeasureunit", (String)fields, (QFilter[])new QFilter[]{filter3, filter1, filter2});
        for (int i = 0; i < col.size(); ++i) {
            DynamicObject obj = (DynamicObject)col.get(i);
            long matId = obj.getLong("materialid");
            long unitId = obj.getLong("measureunitid");
            String dataKey = matId + "-" + unitId;
            unitMap.put(dataKey, obj);
        }
        return unitMap;
    }

    public DynamicObject getMultiTypeUnit(String materialKeys, boolean isFirstLoad, Map<String, DynamicObject> dataMap, Set<Long> materialIdSet, Set<Long> unitSet) {
        if (isFirstLoad) {
            this.getMultiTypeUnit(materialIdSet, unitSet, dataMap);
        }
        return dataMap.get(materialKeys);
    }

    public Map<String, DynamicObject> getAllCommonConvertRule(Set<Long> unitSet) {
        if (this.isNullSet(unitSet)) {
            return new HashMap<String, DynamicObject>(2);
        }
        HashMap<String, DynamicObject> retMap = new HashMap<String, DynamicObject>(unitSet.size());
        QFilter filterA = new QFilter("srcmuid", "in", unitSet);
        QFilter filterB = new QFilter("desmuid", "in", unitSet);
        String fields = "srcmuid,denominator,desmuid,numerator";
        DynamicObjectCollection objCol = QueryServiceHelper.query((String)"bd_measureunitconv", (String)fields, (QFilter[])new QFilter[]{filterA.or(filterB)});
        for (int i = 0; i < objCol.size(); ++i) {
            DynamicObject obj = (DynamicObject)objCol.get(i);
            long srcmuid = obj.getLong("srcmuid");
            long desmuid = obj.getLong("desmuid");
            String dataKey = srcmuid + "-" + desmuid;
            retMap.put(dataKey, obj);
        }
        return retMap;
    }
}

