/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.business.proconfig.configMatrix;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.exception.KDBizException;
import kd.mmc.pdm.common.util.MMCUtils;

public class ConfigMatrixSearchBusiness {
    private String tableName;

    public ConfigMatrixSearchBusiness(String tableName) {
        this.tableName = tableName;
    }

    public Map<String, List<Object>> findConfigMatrixByFieldAndVal(Object[] params) {
        HashMap<String, List<Object>> retMap = new HashMap<String, List<Object>>(64);
        List<Map<String, Object>> retList = this.getConfigMatrix(params);
        if (retList == null || retList.isEmpty()) {
            return retMap;
        }
        for (int i = 0; i < retList.size(); ++i) {
            ArrayList<Object> featureNumList;
            Map<String, Object> entryObj = retList.get(i);
            String featureNum = String.valueOf(entryObj.get("FEATURENUM"));
            String featureValType = String.valueOf(entryObj.get("FEATUREVALTYPE"));
            Object featurevalue = entryObj.get("FEATUREVALUE");
            if ("B".equals(featureValType)) {
                Object object = featurevalue = featurevalue == null || "".equals(featurevalue) ? null : new BigDecimal(featurevalue.toString());
            }
            if ((featureNumList = (ArrayList<Object>)retMap.get(featureNum)) == null) {
                featureNumList = new ArrayList<Object>(32);
            }
            if (!"".equals(String.valueOf(featurevalue))) {
                featureNumList.add(featurevalue);
            }
            retMap.put(featureNum, featureNumList);
        }
        return retMap;
    }

    public List<Map<String, Object>> getConfigMatrix(Object[] params) {
        int i;
        ArrayList<Map<String, Object>> retList = new ArrayList<Map<String, Object>>(64);
        if (params == null) {
            return retList;
        }
        List<Map<String, Object>> matrixMap = this.searchConfigMatrix();
        if (matrixMap == null || matrixMap.isEmpty()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u914d\u7f6e\u77e9\u9635%s\u4e0d\u5b58\u5728\u3002", (String)"ConfigMatrixSearchBusiness_0", (String)"mmc-pdm-business", (Object[])new Object[0]), this.tableName));
        }
        List<Map<String, Object>> matrixMapTmp = matrixMap;
        for (i = 0; i < params.length; ++i) {
            JSONObject obj = JSONObject.parseObject((String)params[i].toString());
            boolean isFieldOp = obj.getBoolean("isFieldOp");
            if (isFieldOp) continue;
            matrixMapTmp = this.filterMatrix(matrixMapTmp, obj);
        }
        for (i = 0; i < matrixMapTmp.size(); ++i) {
            Map<String, Object> entryObj = matrixMapTmp.get(i);
            String groupNo = String.valueOf(entryObj.get("FEATUREGROUP"));
            List<Map<String, Object>> sameGroupData = this.getTheSameGroupData(matrixMapTmp, groupNo);
            if (sameGroupData.isEmpty()) continue;
            retList.addAll(sameGroupData);
            break;
        }
        return retList;
    }

    private List<Map<String, Object>> getTheSameGroupData(List<Map<String, Object>> matrixMap, String groupNo) {
        ArrayList<Map<String, Object>> retList = new ArrayList<Map<String, Object>>(128);
        if (matrixMap.isEmpty()) {
            return retList;
        }
        for (int i = 0; i < matrixMap.size(); ++i) {
            Map<String, Object> entryObj = matrixMap.get(i);
            String group = String.valueOf(entryObj.get("FEATUREGROUP"));
            if (groupNo == null || !groupNo.equals(group)) continue;
            retList.add(entryObj);
        }
        return retList;
    }

    private List<Map<String, Object>> filterMatrix(List<Map<String, Object>> matrixMap, JSONObject reqObj) {
        ArrayList<Map<String, Object>> retMap = new ArrayList<Map<String, Object>>(128);
        String field = reqObj.getString("field");
        Object valueStr = reqObj.get((Object)"value");
        String[] valArray = this.getValArray(valueStr);
        if (valArray.length <= 0) {
            return retMap;
        }
        String value = valArray[0];
        for (int i = 0; i < matrixMap.size(); ++i) {
            List<Map<String, Object>> sameGroupData;
            boolean retFlag;
            Map<String, Object> entryObj = matrixMap.get(i);
            String featureNum = String.valueOf(entryObj.get("FEATURENUM"));
            String featurevalue = String.valueOf(entryObj.get("FEATUREVALUE"));
            String groupNo = String.valueOf(entryObj.get("FEATUREGROUP"));
            if (field == null || value == null || !field.equals(featureNum) || !value.equals(featurevalue) || !(retFlag = this.filterGroupData(sameGroupData = this.getTheSameGroupData(matrixMap, groupNo), field, valArray))) continue;
            retMap.addAll(sameGroupData);
        }
        return retMap;
    }

    private boolean filterGroupData(List<Map<String, Object>> sameGroupData, String field, String[] valArray) {
        boolean retFlag = false;
        if (sameGroupData.isEmpty() || valArray.length <= 0) {
            return retFlag;
        }
        int count = this.getFieldValCount(sameGroupData, field);
        if (valArray.length != count) {
            return retFlag;
        }
        for (int i = 0; i < valArray.length; ++i) {
            boolean flag = false;
            String val = valArray[i].trim();
            for (Map<String, Object> map : sameGroupData) {
                String featurenum = String.valueOf(map.get("FEATURENUM"));
                String featurevalue = String.valueOf(map.get("FEATUREVALUE"));
                if (!featurenum.equals(field) || "".equals(featurevalue) || !val.equals(featurevalue)) continue;
                flag = true;
                break;
            }
            if (!flag) {
                retFlag = false;
                break;
            }
            retFlag = true;
        }
        return retFlag;
    }

    private int getFieldValCount(List<Map<String, Object>> sameGroupData, String field) {
        HashSet<String> retSet = new HashSet<String>(16);
        if (sameGroupData.isEmpty()) {
            return 0;
        }
        for (Map<String, Object> map : sameGroupData) {
            String featurenum = String.valueOf(map.get("FEATURENUM"));
            String featurevalue = String.valueOf(map.get("FEATUREVALUE"));
            if (!featurenum.equals(field) || "".equals(featurevalue)) continue;
            retSet.add(featurevalue);
        }
        return retSet.size();
    }

    private String[] getValArray(Object value) {
        ArrayList retList = new ArrayList(10);
        if (value == null) {
            return retList.toArray(new String[0]);
        }
        if (value instanceof JSONArray) {
            JSONArray list = (JSONArray)value;
            return list.toArray(new String[list.size()]);
        }
        String valueStr = value.toString();
        String valueTmp = valueStr.replace("[", "").replace("]", "");
        if (valueTmp == null || "".equals(valueTmp)) {
            return retList.toArray(new String[0]);
        }
        return valueTmp.split(",");
    }

    private List<Map<String, Object>> searchConfigMatrix() {
        ArrayList<String> numSet = new ArrayList<String>(8);
        numSet.add(this.tableName);
        SqlBuilder sb = new SqlBuilder();
        sb.append(" select", new Object[0]);
        sb.append(" a.fnumber matrixnumber,c.fnumber featurenum,c.ffeaturetype featurevaltype,b.ffeaturevalue featurevalue,b.frowindex rowindex,b.fgroup featureGroup", new Object[0]);
        sb.append(" from t_mpdm_confmatrix a ", new Object[0]);
        sb.append(" inner join t_mpdm_confmatrixentryval b on a.fid =b.fid ", new Object[0]);
        sb.append(" inner join t_pdm_featuredefinition c on b.ffeaturecolumnid = c.fid ", new Object[0]);
        sb.append(" where  ", new Object[0]);
        sb.appendIn("a.fnumber", numSet);
        DataSet dataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)new DBRoute("scm"), (SqlBuilder)sb);
        List retMap = MMCUtils.parseToList((DataSet)dataSet);
        return retMap;
    }
}

