/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.business.proconfig.event;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.EntityEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.log4j.Logger;

public class ProConfigListSynStatus
implements IEventServicePlugin {
    private static final Logger logger = Logger.getLogger(ProConfigListSynStatus.class);

    public Object handleEvent(KDBizEvent evt) {
        EntityEvent entityEvent = (EntityEvent)evt;
        String entityNumber = entityEvent.getEntityNumber();
        List businessKeys = entityEvent.getBusinesskeys();
        String entryFiled = "";
        String configCodeField = "";
        if ("audit".equals(entityEvent.getOperation()) || "unaudit".equals(entityEvent.getOperation()) || "bizvalid".equals(entityEvent.getOperation())) {
            if ("sm_salorder".equals(entityNumber) || "sm_xssalorder".equals(entityNumber)) {
                entryFiled = "billentry";
                configCodeField = "configuredcode";
            }
            logger.info((Object)("form_id\uff1a" + entityEvent.getOperation()));
            ArrayList salorderPkList = new ArrayList();
            businessKeys.stream().forEach(pkValueStr -> {
                if (StringUtils.isNotEmpty((CharSequence)pkValueStr) && Pattern.matches("^[0-9]*$", pkValueStr)) {
                    salorderPkList.add(Long.parseLong(pkValueStr));
                }
            });
            DynamicObjectCollection entryDOC = QueryServiceHelper.query((String)entityNumber, (String)("id," + entryFiled + "." + configCodeField), (QFilter[])new QFilter[]{new QFilter("id", "in", salorderPkList)});
            String finalEntryFiled = entryFiled + "." + configCodeField;
            ArrayList confCodeList = new ArrayList(8);
            DataEntityPropertyCollection properties = entryDOC.getDynamicObjectType().getProperties();
            entryDOC.stream().forEach(entryDO -> {
                long configCodePk;
                if (properties.containsKey((Object)finalEntryFiled) && (configCodePk = entryDO.getLong(finalEntryFiled)) > 0L) {
                    confCodeList.add(configCodePk);
                }
            });
            if (confCodeList.isEmpty()) {
                return businessKeys;
            }
            DynamicObject[] proConfigures = BusinessDataServiceHelper.load((String)"pdm_productconfigure", (String)this.getProConfigureProp(), (QFilter[])new QFilter[]{new QFilter("masterconfigcode", "in", confCodeList)});
            if (proConfigures != null) {
                for (int i = 0; i < proConfigures.length; ++i) {
                    long saleOrderBomId;
                    DynamicObject proConfigure = proConfigures[i];
                    if ("audit".equals(entityEvent.getOperation()) || "bizvalid".equals(entityEvent.getOperation())) {
                        proConfigure.set("status", (Object)"C");
                        continue;
                    }
                    if (!"unaudit".equals(entityEvent.getOperation()) || QueryServiceHelper.exists((String)"pdm_mftbom", (Object)(saleOrderBomId = proConfigure.getLong("treeentryentity.bomid")))) continue;
                    proConfigure.set("status", (Object)"A");
                }
            }
            if (proConfigures != null && proConfigures.length != 0) {
                SaveServiceHelper.update((DynamicObject[])proConfigures);
            }
        }
        return businessKeys;
    }

    private String getProConfigureProp() {
        StringBuilder propBuilder = new StringBuilder();
        propBuilder.append("id,");
        propBuilder.append("masterconfigcode,");
        propBuilder.append("status,");
        propBuilder.append("treeentryentity.id,");
        propBuilder.append("treeentryentity.bomid");
        return propBuilder.toString();
    }
}

