/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.business.proconfig.proconfiglist;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.mmc.pdm.business.mftbom.bomsearch.BOMExpandConfigBusiness;
import kd.mmc.pdm.business.mftbom.bomsearch.BOMVersionFilterBusiness;
import kd.mmc.pdm.business.proconfig.proconfiglist.PDMFormulaRunBusiness;
import kd.mmc.pdm.business.proconfig.proconfiglist.WorkStationSplitBusiness;
import kd.mmc.pdm.common.bom.ecoplatform.PlatformUtils;
import kd.mmc.pdm.common.util.MMCUtils;
import org.apache.log4j.Logger;

public class ParseFeatureListToMatListBusiness {
    private static Logger logger = Logger.getLogger(ParseFeatureListToMatListBusiness.class);
    private String model;
    private Date dateTime = new Date();
    private BigDecimal num;
    private long workCenterId;
    private Set<Long> workCenterSet;
    private Map<Long, Set<Long>> workStationMap;
    private boolean isNeedProRoute;
    private static final DBRoute scmDBRoute = new DBRoute("scm");
    private boolean jumplevelExpand = true;
    private int levelCount = 30;
    public Set<Long> featureMatSet = new HashSet<Long>(128);
    public Set<Long> featureUnitSet = new HashSet<Long>(128);
    public Map<String, String> matAttrMap;

    public ParseFeatureListToMatListBusiness(String model, Date dateTime, BigDecimal num, long workCenterId, boolean isNeedProRoute) {
        this.model = model;
        this.dateTime = dateTime;
        this.num = num;
        this.workCenterId = workCenterId;
        this.isNeedProRoute = isNeedProRoute;
        this.levelCount = 30;
    }

    public ParseFeatureListToMatListBusiness(String model, Date dateTime, BigDecimal num, long workCenterId, boolean isNeedProRoute, boolean jumplevelexpand, int levelcount) {
        this.model = model;
        this.dateTime = dateTime;
        this.num = num;
        this.workCenterId = workCenterId;
        this.isNeedProRoute = isNeedProRoute;
        this.jumplevelExpand = jumplevelexpand;
        this.levelCount = levelcount;
    }

    public ParseFeatureListToMatListBusiness(String model, Date dateTime, BigDecimal num, Set<Long> workCenterSet, Map<Long, Set<Long>> workStationMap) {
        this.model = model;
        this.dateTime = dateTime;
        this.num = num;
        this.workCenterSet = workCenterSet;
        this.workStationMap = workStationMap;
        this.levelCount = 30;
    }

    public DataSet parase(Row proConfigListObj, DataSet superBomSet, Map<String, List<Map<String, Object>>> newFeatureDefAndValueColls, List<Map<String, Object>> newfeatureDefs, OperateOption operateOption, boolean purchaseExpand, Map<String, TreeMap<Integer, Object>> bomExpandMap, String searchOrgId, long replaceNo, long wbsId, long bomVerId) throws Exception {
        Object configObj;
        this.featureMatSet.clear();
        this.featureUnitSet.clear();
        Map<String, List<Object>> varValues = this.ormDefNumAndFeeatureVal(newfeatureDefs, newFeatureDefAndValueColls);
        superBomSet = superBomSet.addNullField(new String[]{"workcenter", "workstation", "workentryqty", "longmaterialids"});
        Algo algo = Algo.create((String)this.getClass().getName());
        RowMeta rowMeta = superBomSet.getRowMeta();
        DataSetBuilder builder = algo.createDataSetBuilder(rowMeta);
        long prodorgid = -1L;
        if (searchOrgId != null && !"".equals(searchOrgId)) {
            prodorgid = Long.parseLong(searchOrgId);
        }
        long headConfigcode = (configObj = proConfigListObj.get("masterconfigcode")) == null ? 0L : (configObj instanceof Long ? (Long)configObj : Long.parseLong(configObj.toString()));
        List<Map<String, Object>> superBomList = MMCUtils.parseNonSyncronizedToList((DataSet)superBomSet);
        Long pmaterial = 0L;
        if (!superBomList.isEmpty()) {
            pmaterial = (Long)((Map)superBomList.get(0)).get("pmaterial");
        }
        String purpose = this.getPurposeByMaterial(pmaterial);
        superBomList = BOMExpandConfigBusiness.firstLevelPriorityFilterByType(superBomList, bomExpandMap, purpose, "");
        superBomList = BOMExpandConfigBusiness.firstLevelPriorityFilterByWBS(superBomList, bomExpandMap, wbsId, "");
        Date searchDate = this.dateTime;
        String verConfig = BOMExpandConfigBusiness.getExpandVerConfig(bomExpandMap);
        if ("B".equals(verConfig) && bomVerId == 0L) {
            long verId = BOMVersionFilterBusiness.getTheLastVerOfMaterial(superBomList, searchDate, "");
            if (verId != 0L && !BOMVersionFilterBusiness.isVerEnable(verId, searchDate, "")) {
                verId = -1L;
            }
            superBomList = BOMVersionFilterBusiness.versionFilter(superBomList, verId, searchDate, "");
        } else {
            if (bomVerId != 0L && !BOMVersionFilterBusiness.isVerEnable(bomVerId, searchDate, "")) {
                bomVerId = -1L;
            }
            superBomList = BOMVersionFilterBusiness.versionFilter(superBomList, bomVerId, searchDate, "");
        }
        superBomList = BOMExpandConfigBusiness.firstLevelPriorityFilterByReplaceNo(superBomList, bomExpandMap, replaceNo, "");
        superBomList = BOMExpandConfigBusiness.replaceGroupFilter(superBomList, searchDate, "");
        long firstLevelId = ORM.create().genLongId("pdm_mftbom");
        DataSet firstDataSet = this.createrRootNode(superBomList, firstLevelId, rowMeta, headConfigcode, prodorgid);
        superBomList = this.setFirstLevel(superBomList, firstLevelId, newFeatureDefAndValueColls, newfeatureDefs, varValues, 0L, prodorgid);
        DataSet newSuperBom = MMCUtils.parseToDataSet(this.getClass(), superBomList, (RowMeta)rowMeta);
        DataSet auxBom = null;
        if (bomExpandMap != null) {
            HashSet<Long> pMatSet = new HashSet<Long>(1);
            pMatSet.add(pmaterial);
            auxBom = this.getAuxBom(pMatSet, bomExpandMap, headConfigcode);
            QFilter sonMaterialStatus = new QFilter("status", "=", (Object)"C");
            QFilter sonMaterialEnable = new QFilter("enable", "=", (Object)"1");
            QFilter sonMaterialOrg = BaseDataServiceHelper.getBaseDataFilter((String)"pdm_mftbom", (Long)prodorgid);
            QFilter[] filters = new QFilter[]{sonMaterialStatus, sonMaterialEnable, sonMaterialOrg};
            builder = this.expandChildBom(newSuperBom.copy(), builder, newfeatureDefs, newFeatureDefAndValueColls, varValues, "1", bomExpandMap, purchaseExpand, filters, prodorgid, headConfigcode, replaceNo, wbsId);
        }
        this.setMatAttrMap();
        DataSet childDataSet = builder.build();
        if (auxBom != null && auxBom.hasNext()) {
            Set auxBomTmpSet = MMCUtils.parseToSet(auxBom);
            List<Map<String, Object>> auxBomList = this.setAuxBom(auxBomTmpSet, superBomList.size(), this.num, String.valueOf(firstLevelId), "1");
            auxBom = MMCUtils.parseToDataSet(this.getClass(), auxBomList, (RowMeta)auxBom.getRowMeta());
            newSuperBom = newSuperBom.union(auxBom);
        }
        DataSet retDataSet = null;
        retDataSet = firstDataSet == null ? newSuperBom.union(childDataSet).orderBy(new String[]{"longnumber asc"}) : firstDataSet.union(newSuperBom).union(childDataSet).orderBy(new String[]{"longnumber asc"});
        return retDataSet;
    }

    private void setMatAttrMap() {
        if (this.featureMatSet.isEmpty()) {
            return;
        }
        this.matAttrMap = new HashMap<String, String>(128);
        QFilter matFilter = new QFilter("masterid", "in", this.featureMatSet);
        String fields = "id,createorg,masterid,materialattr";
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_materialmftinfo", (String)fields, (QFilter[])new QFilter[]{matFilter}, null);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            long masterid = row.getLong("masterid");
            long createorg = row.getLong("createorg");
            String materialAttr = row.getString("materialattr");
            String keySet = createorg + "-" + masterid;
            this.matAttrMap.put(keySet, materialAttr);
        }
    }

    public Map<String, String> getMatAttrMap() {
        if (this.matAttrMap == null) {
            this.matAttrMap = new HashMap<String, String>(128);
        }
        return this.matAttrMap;
    }

    public Set<Long> getFeatureTypeMaterial() {
        if (this.featureMatSet == null) {
            this.featureMatSet = new HashSet<Long>(128);
        }
        return this.featureMatSet;
    }

    public Set<Long> getFeatureTypeUnit() {
        if (this.featureUnitSet == null) {
            this.featureUnitSet = new HashSet<Long>(128);
        }
        return this.featureUnitSet;
    }

    private DataSet createrRootNode(List<Map<String, Object>> superBomList, long firstLevelId, RowMeta rowMeta, long headConfigcode, long proOrgId) {
        if (superBomList.isEmpty()) {
            return null;
        }
        Map<String, Object> firstBomHead = superBomList.get(0);
        Algo algo = Algo.create((String)this.getClass().getName());
        DataSetBuilder builder = algo.createDataSetBuilder(rowMeta);
        String[] fieldNames = rowMeta.getFieldNames();
        Object[] objArray = new Object[fieldNames.length];
        block30: for (int i = 0; i < fieldNames.length; ++i) {
            String fieldName;
            switch (fieldName = fieldNames[i]) {
                case "seq": {
                    objArray[i] = 1;
                    continue block30;
                }
                case "entryseq": {
                    objArray[i] = 1;
                    continue block30;
                }
                case "entrymaterial_id": {
                    objArray[i] = firstBomHead.get("pmaterial");
                    continue block30;
                }
                case "entrymaterial": {
                    objArray[i] = firstBomHead.get("pmaterialmftinfo");
                    continue block30;
                }
                case "entryscraprate": {
                    objArray[i] = 0;
                    continue block30;
                }
                case "entryfixscrap": {
                    objArray[i] = 0;
                    continue block30;
                }
                case "entryqty": {
                    objArray[i] = 0;
                    continue block30;
                }
                case "entryqtydenominator": {
                    objArray[i] = 1;
                    continue block30;
                }
                case "entryqtynumerator": {
                    objArray[i] = 1;
                    continue block30;
                }
                case "configproperties": {
                    objArray[i] = Character.valueOf('2');
                    continue block30;
                }
                case "entryauxproperty": {
                    objArray[i] = 0L;
                    continue block30;
                }
                case "pid": {
                    objArray[i] = 0L;
                    continue block30;
                }
                case "id": {
                    objArray[i] = firstLevelId;
                    continue block30;
                }
            }
        }
        builder.append(objArray);
        List<Map<String, Object>> rootList = MMCUtils.parseToList((DataSet)builder.build());
        if (this.isNeedProRoute) {
            HashMap<String, Map<String, Object>> proVerMap = new HashMap<String, Map<String, Object>>(1);
            Map<String, Map<String, Object>> routeMap = this.getRouteDataFromRoute(rootList, proOrgId, proVerMap, headConfigcode);
            rootList = this.routeIdSet(rootList, proVerMap, routeMap, headConfigcode, proOrgId);
        }
        return MMCUtils.parseToDataSet(this.getClass(), (List)rootList, (RowMeta)rowMeta);
    }

    private List<Map<String, Object>> setFirstLevel(List<Map<String, Object>> superBomList, long pid, Map<String, List<Map<String, Object>>> newFeatureDefAndValueColls, List<Map<String, Object>> newfeatureDefs, Map<String, List<Object>> varValues, long headConfigcode, long proOrgId) {
        if (superBomList == null || superBomList.isEmpty()) {
            return superBomList;
        }
        List<Map<String, Object>> retList = new ArrayList<Map<String, Object>>(superBomList.size());
        Set<Long> bomIdSet = this.getBomIds(superBomList);
        List<Map<String, Object>> bomRuleEntryList = this.getBomRuleEntry(bomIdSet);
        Map<Long, Set<Long>> enrtyMap = this.getEntryRuleIds(bomRuleEntryList);
        List<Map<String, Object>> bomRuleList = this.getRuleList(bomRuleEntryList);
        Map<Long, Set<String>> checkRuleMap = this.getEntryformula(enrtyMap, bomRuleList, "2");
        Map<Long, Set<String>> oprRuleMap = this.getEntryformula(enrtyMap, bomRuleList, "3");
        ORM orm = ORM.create();
        long[] pks = orm.genLongIds("pdm_mftbom", superBomList.size());
        for (int i = 0; i < superBomList.size(); ++i) {
            String entryType;
            Map<String, Object> map = superBomList.get(i);
            Date entryinvaliddate = (Date)map.get("entryinvaliddate");
            Date entryvaliddate = (Date)map.get("entryvaliddate");
            if (this.dateTime != null && (this.dateTime.before(entryvaliddate) || this.dateTime.after(entryinvaliddate))) continue;
            String id = String.valueOf(pks[i]);
            Object tmp = map.get("entryid");
            long entryId = tmp instanceof Long ? (Long)tmp : Long.parseLong(tmp.toString());
            boolean isSelected = this.isEntryChecked(checkRuleMap, entryId, varValues);
            if (!isSelected) continue;
            map.put("pid", pid);
            map.put("id", id);
            map.put("entryseq", "1." + map.get("entryseq"));
            map.put("parentqty", this.num);
            map.put("longmaterialids", WorkStationSplitBusiness.genLongMaterialIds(null, map));
            JSONObject opFieldObj = this.getFormulaVal(oprRuleMap, entryId, varValues);
            isSelected = this.setFieldVal(map, opFieldObj);
            if (!isSelected) continue;
            Object entryTypeObj = map.get("entrytype");
            String string = entryType = entryTypeObj == null ? "A" : entryTypeObj.toString();
            if ("B".equals(entryType)) {
                List<Map<String, Object>> featureBomList = this.featureTypeToMaterial(map, newFeatureDefAndValueColls, newfeatureDefs, null);
                retList.addAll(featureBomList);
                continue;
            }
            retList.add(map);
        }
        if (this.isNeedProRoute) {
            Map<String, Map<String, Object>> proVerMap = this.getRouteDataFromProVer(superBomList, proOrgId, headConfigcode);
            Map<String, Map<String, Object>> routeMap = this.getRouteDataFromRoute(superBomList, proOrgId, proVerMap, headConfigcode);
            retList = this.routeIdSet(retList, proVerMap, routeMap, headConfigcode, proOrgId);
        }
        if ("model_pom".equals(this.model)) {
            retList = WorkStationSplitBusiness.splitWorkStation(retList, this.workCenterSet, this.workStationMap, this.num, this.num);
        }
        return retList;
    }

    private boolean setFieldVal(Map<String, Object> map, JSONObject opFieldObj) {
        if (opFieldObj == null || opFieldObj.isEmpty()) {
            return true;
        }
        BigDecimal parentqty = (BigDecimal)map.get("parentqty");
        Set entrySet = opFieldObj.entrySet();
        HashSet<String> fetureNumSet = new HashSet<String>(opFieldObj.size());
        for (Map.Entry entry : entrySet) {
            String featureNum = (String)entry.getKey();
            fetureNumSet.add(featureNum);
        }
        QFilter filter = new QFilter("number", "in", fetureNumSet);
        DataSet datatSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"pdm_featuredefinition", (String)"number,fieldname", (QFilter[])new QFilter[]{filter}, null);
        while (datatSet.hasNext()) {
            BigDecimal entryqtynumerator;
            Row row = datatSet.next();
            String featureNum = row.getString("number");
            String fieldname = row.getString("fieldname");
            Object val = opFieldObj.get((Object)featureNum);
            if (val == null || "".equals(val)) continue;
            if (val instanceof JSONArray) {
                JSONArray array = (JSONArray)val;
                if (array.size() <= 0) continue;
                val = array.get(0);
            }
            if ("entryqtynumerator".equals(fieldname) && BigDecimal.ZERO.compareTo(entryqtynumerator = new BigDecimal(val.toString())) >= 0) {
                return false;
            }
            if (!map.containsKey(fieldname)) continue;
            map.put(fieldname, val);
        }
        BigDecimal entryqtynumerator = new BigDecimal(map.get("entryqtynumerator").toString());
        BigDecimal entryqtydenominator = new BigDecimal(map.get("entryqtydenominator").toString());
        BigDecimal entryQty = MMCUtils.multiplyAndDivide((BigDecimal)parentqty, (BigDecimal)entryqtynumerator, (BigDecimal)entryqtydenominator);
        String childqtytype = String.valueOf(map.get("entryqtytype"));
        if ("B".equals(childqtytype)) {
            entryQty = MMCUtils.divide((BigDecimal)entryqtynumerator, (BigDecimal)entryqtydenominator);
        }
        map.put("entryqty", entryQty);
        return true;
    }

    private Set<Long> getBomIds(List<Map<String, Object>> superBomList) {
        HashSet<Long> bomIdSet = new HashSet<Long>(64);
        if (superBomList == null || superBomList.isEmpty()) {
            return bomIdSet;
        }
        for (int i = 0; i < superBomList.size(); ++i) {
            Map<String, Object> map = superBomList.get(i);
            Object tmp = map.get("superbomid");
            long supeBomId = tmp instanceof Long ? (Long)tmp : Long.parseLong(tmp.toString());
            bomIdSet.add(supeBomId);
        }
        return bomIdSet;
    }

    private DataSet getAuxBom(Set<Long> pMatSet, Map<String, TreeMap<Integer, Object>> bomExpandMap, long headConfigcode) {
        if (pMatSet == null || pMatSet.isEmpty()) {
            return null;
        }
        TreeMap<Integer, Object> auxMap = bomExpandMap.get("auxbomtype");
        if (auxMap == null) {
            return null;
        }
        long auxBomType = auxMap.get(1) == null ? 0L : Long.parseLong(auxMap.get(1).toString());
        QFilter matFilter = new QFilter("materialid", "in", pMatSet);
        QFilter typeFilter = new QFilter("type", "=", (Object)auxBomType);
        QFilter effect = new QFilter("entry.entryvaliddate", "<=", (Object)this.dateTime);
        QFilter invalid = new QFilter("entry.entryinvaliddate", ">=", (Object)this.dateTime);
        QFilter configCodeFilter = new QFilter("configuredcode", "=", (Object)headConfigcode);
        QFilter status = new QFilter("status", "=", (Object)"C");
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        QFilter[] filterArray = new QFilter[]{matFilter, typeFilter, configCodeFilter, status, enable, effect, invalid};
        DataSet auxBomDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"pdm_mftbom", (String)ParseFeatureListToMatListBusiness.getPropertiesWithQuerySuperBom(this.num), (QFilter[])filterArray, (String)"entry.seq");
        if (auxBomDataSet.copy().isEmpty() && headConfigcode != 0L) {
            configCodeFilter = new QFilter("configuredcode", "=", (Object)0L);
            filterArray = new QFilter[]{matFilter, typeFilter, configCodeFilter, status, enable, effect, invalid};
            auxBomDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"pdm_mftbom", (String)ParseFeatureListToMatListBusiness.getPropertiesWithQuerySuperBom(this.num), (QFilter[])filterArray, (String)"entry.seq");
        }
        auxBomDataSet = auxBomDataSet.addNullField(new String[]{"workcenter", "workstation", "workentryqty", "longmaterialids"});
        return auxBomDataSet;
    }

    private DataSet getBomExpandConifg(long proConfigPlanId) {
        if (proConfigPlanId == 0L) {
            return null;
        }
        QFilter expandIdFilter = new QFilter("id", "=", (Object)proConfigPlanId);
        QFilter status = new QFilter("status", "=", (Object)"C");
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        String fields = "bomexpandconfig.id id,bomexpandconfig.superbomtype superbomtype,bomexpandconfig.probomtype probomtype,bomexpandconfig.orderbomtype orderbomtype,bomexpandconfig.auxbomtype auxbomtype";
        DataSet bomExpand = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"pdm_proconfigscheme", (String)fields, (QFilter[])new QFilter[]{expandIdFilter, status, enable}, (String)"id", (int)1);
        return bomExpand;
    }

    private Map<String, Long> getBomType(DataSet bomExpandConfigSet) {
        HashMap<String, Long> retMap = new HashMap<String, Long>(10);
        try (DataSet expandDataSet = bomExpandConfigSet.copy();){
            while (expandDataSet.hasNext()) {
                Row bomExpandConfig = expandDataSet.next();
                long superbomtype = bomExpandConfig.getLong("superbomtype");
                long probomtype = bomExpandConfig.getLong("probomtype");
                long orderbomtype = bomExpandConfig.getLong("orderbomtype");
                long auxBomType = bomExpandConfig.getLong("auxbomtype");
                retMap.put("superbomtype", superbomtype);
                retMap.put("probomtype", probomtype);
                retMap.put("orderbomtype", orderbomtype);
                retMap.put("auxbomtype", auxBomType);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.toString());
            throw e;
        }
        return retMap;
    }

    public DataSet searchData(QFilter[] filters) {
        return QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"pdm_mftbom", (String)ParseFeatureListToMatListBusiness.getPropertiesWithQuerySuperBom(this.num), (QFilter[])filters, null).orderBy(new String[]{"entryseq"});
    }

    private DataSetBuilder expandChildBom(DataSet parentBom, DataSetBuilder builder, List<Map<String, Object>> newfeatureDefs, Map<String, List<Map<String, Object>>> newFeatureDefAndValueColls, Map<String, List<Object>> varValues, String bomIdStr, Map<String, TreeMap<Integer, Object>> bomExpandMap, boolean purchaseExpand, QFilter[] commomFilter, long proOrgId, long headConfigcode, long replaceNo, long wbsId) {
        Long entryVserion;
        List<Map<String, Object>> retChildBomList = new ArrayList<Map<String, Object>>(100);
        RowMeta rowMeta = parentBom.getRowMeta();
        DataSet pBomEntrySet = parentBom.copy();
        HashSet<Long> entryMatIdSet = new HashSet<Long>(128);
        HashSet<Long> bomVersionIds = new HashSet<Long>(64);
        try {
            while (pBomEntrySet.hasNext()) {
                Row row = pBomEntrySet.next();
                String isAuxBom = row.getString("isauxbom");
                if ("1".equals(isAuxBom)) continue;
                if (this.isRepeatBom(row)) {
                    break;
                }
                String entryseq = row.getString("entryseq");
                int level = ParseFeatureListToMatListBusiness.countOccurrences(entryseq, ".");
                if (level >= this.levelCount && !this.jumplevelExpand) continue;
                long entrymaterialid = row.getLong("entrymaterial_id");
                String entryMaterialAttar = row.getString("entrymaterialattr");
                String entryisjumplevel = row.getString("entryisjumplevel");
                if (entrymaterialid == 0L || !purchaseExpand && "10040".equals(entryMaterialAttar) || ("model_pom".equals(this.model) || "model_mrp".equals(this.model) || this.jumplevelExpand && level >= this.levelCount) && "false".equals(entryisjumplevel)) continue;
                entryMatIdSet.add(entrymaterialid);
                entryVserion = row.getLong("entryversion");
                if (entryVserion == null || entryVserion.equals(0L)) continue;
                bomVersionIds.add(entryVserion);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.toString());
            throw e;
        }
        finally {
            pBomEntrySet.close();
        }
        if (entryMatIdSet.isEmpty()) {
            return builder;
        }
        ArrayList<Map<String, Object>> retChildList = new ArrayList<Map<String, Object>>(100);
        QFilter sonMaterialId = new QFilter("materialid", "in", entryMatIdSet);
        QFilter[] filters = (QFilter[])ArrayUtils.add((Object[])commomFilter, (Object)sonMaterialId);
        DataSet childDataSet = this.searchData(filters);
        DataSet entryAuxBom = this.getAuxBom(entryMatIdSet, bomExpandMap, headConfigcode);
        List childAuxBomList = MMCUtils.parseNonSyncronizedToList((DataSet)entryAuxBom);
        HashSet<Long> childBomIdSet = new HashSet<Long>(64);
        try {
            childDataSet = childDataSet.addNullField(new String[]{"workcenter", "workstation", "workentryqty", "longmaterialids"});
            List childBomList = MMCUtils.parseNonSyncronizedToList((DataSet)childDataSet);
            if (childBomList.isEmpty()) {
                entryVserion = builder;
                return entryVserion;
            }
            Map<String, List<Map<String, Object>>> childDataMap = this.buildMap(childBomList, bomVersionIds, childBomIdSet);
            Set<Long> enableVersionIds = BOMVersionFilterBusiness.getIsEnableVersionIdSet(bomVersionIds, this.dateTime);
            while (parentBom.hasNext()) {
                Row row = parentBom.next();
                long entrymaterialId = row.getLong("entrymaterial_id");
                long entryauxproperty = row.getLong("entryauxproperty");
                String keyString = this.buildKeyString(entrymaterialId, entryauxproperty);
                List<Map<String, Object>> newChildList = childDataMap.get(keyString);
                if (newChildList == null) {
                    newChildList = new ArrayList<Map<String, Object>>(16);
                }
                List<Map<String, Object>> retList = this.filterChildBom(row, newChildList, bomExpandMap, childAuxBomList, replaceNo, wbsId, enableVersionIds);
                retChildList.addAll(retList);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            throw e;
        }
        finally {
            childDataSet.close();
        }
        List<Map<String, Object>> bomRuleEntryList = this.getBomRuleEntry(childBomIdSet);
        Map<Long, Set<Long>> enrtyMap = this.getEntryRuleIds(bomRuleEntryList);
        List<Map<String, Object>> bomRuleList = this.getRuleList(bomRuleEntryList);
        Map<Long, Set<String>> entryRuleMap = this.getEntryformula(enrtyMap, bomRuleList, "2");
        Map<Long, Set<String>> oprRuleMap = this.getEntryformula(enrtyMap, bomRuleList, "3");
        for (int i = 0; i < retChildList.size(); ++i) {
            JSONObject opFieldObj;
            Map superBomEntry = (Map)retChildList.get(i);
            Object tmp = superBomEntry.get("entryid");
            long entryid = tmp instanceof Long ? (Long)tmp : Long.parseLong(tmp.toString());
            String entryType = String.valueOf(superBomEntry.get("entrytype"));
            String parentLongMaterialIds = superBomEntry.get("longmaterialids").toString();
            boolean isSelected = this.isEntryChecked(entryRuleMap, entryid, varValues);
            if (!isSelected || !(isSelected = this.setFieldVal(superBomEntry, opFieldObj = this.getFormulaVal(oprRuleMap, entryid, varValues)))) continue;
            if ("B".equals(entryType)) {
                List<Map<String, Object>> newSuperBomEntry = this.featureTypeToMaterial(superBomEntry, newFeatureDefAndValueColls, newfeatureDefs, parentLongMaterialIds);
                retChildBomList.addAll(newSuperBomEntry);
                continue;
            }
            retChildBomList.add(superBomEntry);
        }
        if (this.isNeedProRoute) {
            Map<String, Map<String, Object>> proVerMap = this.getRouteDataFromProVer(retChildBomList, proOrgId, 0L);
            Map<String, Map<String, Object>> routeMap = this.getRouteDataFromRoute(retChildBomList, proOrgId, proVerMap, 0L);
            retChildBomList = this.routeIdSet(retChildBomList, proVerMap, routeMap, 0L, proOrgId);
        }
        if ("model_pom".equals(this.model)) {
            retChildBomList = WorkStationSplitBusiness.splitWorkStation(retChildBomList, this.workCenterSet, this.workStationMap, this.num, this.num);
        }
        if (retChildBomList == null || retChildBomList.isEmpty()) {
            return builder;
        }
        DataSetBuilder curbuilder = this.unionDataChild(retChildBomList, rowMeta, builder);
        try (DataSet childBomSet = curbuilder.build();){
            builder = this.expandChildBom(childBomSet, builder, newfeatureDefs, newFeatureDefAndValueColls, varValues, bomIdStr, bomExpandMap, purchaseExpand, commomFilter, proOrgId, headConfigcode, replaceNo, wbsId);
        }
        return builder;
    }

    public Map<String, Map<String, Object>> getRouteDataFromProVer(List<Map<String, Object>> childMapList, long prodOrg, Long headConfigcode) {
        HashMap<String, Map<String, Object>> retProVerMap = new HashMap<String, Map<String, Object>>();
        if (childMapList == null || childMapList.isEmpty()) {
            return retProVerMap;
        }
        QFilter orgFilter = new QFilter("createorg", "=", (Object)prodOrg);
        HashSet<Long> matIds = new HashSet<Long>(childMapList.size());
        for (int i = 0; i < childMapList.size(); ++i) {
            Map<String, Object> childMap = childMapList.get(i);
            Object entryMatInfoObj = childMap.get("entrymaterial");
            long matId = entryMatInfoObj == null ? 0L : (entryMatInfoObj instanceof Long ? (Long)entryMatInfoObj : Long.parseLong(entryMatInfoObj.toString()));
            matIds.add(matId);
        }
        QFilter matFilter = new QFilter("material", "in", matIds);
        QFilter statusFilter = new QFilter("status", "in", (Object)"C");
        QFilter enableFilter = new QFilter("enable", "in", (Object)"1");
        String fields = "id,material,createorg,processroute,audittime";
        try (DataSet proVerSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"pdm_manuversion", (String)fields, (QFilter[])new QFilter[]{orgFilter, matFilter, statusFilter, enableFilter}, (String)"");){
            while (proVerSet.hasNext()) {
                Row row = proVerSet.next();
                long matId = row.getLong("material");
                long createOrgId = row.getLong("createorg");
                long routeId = row.getLong("processroute");
                Date auditTime = row.getDate("audittime");
                String dataKey = "" + matId + createOrgId;
                HashMap<String, Comparable<Long>> routeIdMap = (HashMap<String, Comparable<Long>>)retProVerMap.get(dataKey);
                if (routeIdMap == null) {
                    routeIdMap = new HashMap<String, Comparable<Long>>();
                    routeIdMap.put("routeId", Long.valueOf(routeId));
                    routeIdMap.put("auditTime", auditTime);
                } else {
                    Date existDate = (Date)routeIdMap.get("auditTime");
                    if (existDate != null && auditTime.after(existDate)) {
                        routeIdMap.put("routeId", Long.valueOf(routeId));
                        routeIdMap.put("auditTime", auditTime);
                    }
                }
                retProVerMap.put(dataKey, routeIdMap);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            throw e;
        }
        return retProVerMap;
    }

    public Map<String, Map<String, Object>> getRouteDataFromRoute(List<Map<String, Object>> childMapList, long prodOrg, Map<String, Map<String, Object>> proVerMap, Long configCode) {
        HashMap<String, Map<String, Object>> retRouteMap = new HashMap<String, Map<String, Object>>(10);
        if (childMapList == null || childMapList.isEmpty()) {
            return retRouteMap;
        }
        QFilter orgFilter = new QFilter("createorg", "=", (Object)prodOrg);
        HashSet<Long> matIds = new HashSet<Long>(100);
        for (int i = 0; i < childMapList.size(); ++i) {
            Map<String, Object> childMap = childMapList.get(i);
            Object entryMatInfoObj = childMap.get("entrymaterial_id");
            long matId = entryMatInfoObj == null ? 0L : (entryMatInfoObj instanceof Long ? (Long)entryMatInfoObj : Long.parseLong(entryMatInfoObj.toString()));
            Object entryMatMftInfoObj = childMap.get("entrymaterial");
            long matMftId = entryMatMftInfoObj == null ? 0L : (entryMatMftInfoObj instanceof Long ? (Long)entryMatMftInfoObj : Long.parseLong(entryMatMftInfoObj.toString()));
            String matInfoDataKey = "" + matMftId + prodOrg + configCode;
            if (proVerMap != null && proVerMap.get(matInfoDataKey) != null) continue;
            matIds.add(matId);
        }
        QFilter matFilter = new QFilter("material", "in", matIds);
        QFilter statusFilter = new QFilter("status", "in", (Object)"C");
        QFilter enableFilter = new QFilter("enable", "in", (Object)"1");
        try (DataSet routeSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"pdm_route", (String)"id,material,createorg,configcode,audittime", (QFilter[])new QFilter[]{orgFilter, matFilter, statusFilter, enableFilter}, (String)"");){
            while (routeSet.hasNext()) {
                Date existDate;
                Row row = routeSet.next();
                long matId = row.getLong("material");
                long createOrgId = row.getLong("createorg");
                long configcodeId = row.getLong("configcode");
                long routeId = row.getLong("id");
                Date auditTime = row.getDate("audittime");
                String dataKey = "" + matId + createOrgId + configcodeId;
                HashMap<String, Comparable<Long>> routeIdMap = (HashMap<String, Comparable<Long>>)retRouteMap.get(dataKey);
                if (routeIdMap == null) {
                    routeIdMap = new HashMap<String, Comparable<Long>>();
                    routeIdMap.put("routeId", Long.valueOf(routeId));
                    routeIdMap.put("auditTime", auditTime);
                }
                if (auditTime.after(existDate = (Date)routeIdMap.get("auditTime"))) {
                    routeIdMap.put("routeId", Long.valueOf(routeId));
                    routeIdMap.put("auditTime", auditTime);
                }
                retRouteMap.put(dataKey, routeIdMap);
            }
        }
        return retRouteMap;
    }

    public List<Map<String, Object>> routeIdSet(List<Map<String, Object>> childMapList, Map<String, Map<String, Object>> proVerMap, Map<String, Map<String, Object>> routeMap, Long configCode, long prodOrg) {
        if (childMapList == null || childMapList.isEmpty()) {
            return childMapList;
        }
        ArrayList<Map<String, Object>> retMapList = new ArrayList<Map<String, Object>>(childMapList.size());
        for (int i = 0; i < childMapList.size(); ++i) {
            Object routeObj;
            Map<String, Object> childObjMap = childMapList.get(i);
            Object matInfoObj = childObjMap.get("entrymaterial");
            Object matObj = childObjMap.get("entrymaterial_id");
            String matId = matObj == null ? "" : matObj.toString();
            String matInfoId = matInfoObj == null ? "" : matInfoObj.toString();
            String matDataKey = "" + matId + prodOrg + configCode;
            String matInfoDataKey = "" + matInfoId + prodOrg;
            Map<String, Object> verMap = proVerMap.get(matInfoDataKey);
            long routeId = 0L;
            if (verMap == null) {
                verMap = routeMap.get(matDataKey);
            }
            if (verMap != null) {
                routeObj = verMap.get("routeId");
                long l = routeObj == null ? 0L : (routeId = routeObj instanceof Long ? (Long)routeObj : Long.parseLong(routeObj.toString()));
            }
            if (routeId == 0L && configCode != 0L) {
                matDataKey = "" + matId + prodOrg + "0";
                matInfoDataKey = "" + matInfoId + prodOrg;
                verMap = proVerMap.get(matInfoDataKey);
                if (verMap == null) {
                    verMap = routeMap.get(matDataKey);
                }
                if (verMap != null) {
                    routeObj = verMap.get("routeId");
                    routeId = routeObj == null ? 0L : (routeObj instanceof Long ? (Long)routeObj : Long.parseLong(routeObj.toString()));
                }
            }
            childObjMap.put("routeId", String.valueOf(routeId));
            retMapList.add(childObjMap);
        }
        return retMapList;
    }

    public DataSetBuilder unionDataChild(List<Map<String, Object>> childList, RowMeta rowMeta, DataSetBuilder builder) {
        Algo algo = Algo.create((String)this.getClass().getName());
        DataSetBuilder curbuilder = algo.createDataSetBuilder(rowMeta);
        if (!childList.isEmpty()) {
            String[] names = rowMeta.getFieldNames();
            for (int i = 0; i < childList.size(); ++i) {
                Map<String, Object> map = childList.get(i);
                Object[] objArray = new Object[map.size()];
                for (int k = 0; k < names.length; ++k) {
                    Object value;
                    String fiedName = names[k];
                    objArray[k] = value = map.get(fiedName);
                }
                builder.append(objArray);
                curbuilder.append(objArray);
            }
        }
        return curbuilder;
    }

    public List<Map<String, Object>> filterChildBom(Row row, List<Map<String, Object>> childBomList, Map<String, TreeMap<Integer, Object>> bomExpandMap, List<Map<String, Object>> childAuxBomList, long replaceNo, long wbsId, Set<Long> enableVersionIds) {
        int bomVserionIdSize;
        List<Map<String, Object>> retList = new ArrayList<Map<String, Object>>();
        if (row == null || childBomList == null || childBomList.isEmpty()) {
            return retList;
        }
        long entryMatId = row.getLong("entrymaterial_id");
        long entryversion = row.getLong("entryversion");
        long entryAuxp = row.getLong("entryauxproperty");
        String configproperties = row.getString("configproperties");
        String id = row.getString("id");
        BigDecimal entryqty = row.getBigDecimal("entryqty");
        String entrySeq = row.getString("entryseq");
        String longnumber = row.getString("longnumber");
        String longMaterialIds = row.getString("longmaterialids");
        String entryqtytype = row.getString("entryqtytype");
        String childPurpose = "B";
        if ("1".equals(configproperties) || "".equals(configproperties)) {
            childPurpose = "A";
        }
        long entryBomTypeId = BOMExpandConfigBusiness.getPriorityBomType(childBomList, entryMatId, entryAuxp, 0L, bomExpandMap, childPurpose, "");
        String verConfig = BOMExpandConfigBusiness.getExpandVerConfig(bomExpandMap);
        Date searchDate = this.dateTime;
        HashSet<Map<String, Object>> retAuxBomList = new HashSet<Map<String, Object>>(64);
        int auxSeq = 0;
        int size = childBomList.size();
        ORM orm = ORM.create();
        long[] pks = orm.genLongIds("pdm_mftbom", size);
        HashSet<Long> bomVserionIdSet = new HashSet<Long>(size);
        for (int i = 0; i < size; ++i) {
            Map<String, Object> childBomMap = childBomList.get(i);
            Date entryinvaliddate = (Date)childBomMap.get("entryinvaliddate");
            Date entryvaliddate = (Date)childBomMap.get("entryvaliddate");
            if (this.dateTime != null && (this.dateTime.before(entryvaliddate) || this.dateTime.after(entryinvaliddate))) continue;
            long childMatId = BOMExpandConfigBusiness.getLongValue(childBomMap.get("pmaterial"));
            long childVerId = BOMExpandConfigBusiness.getLongValue(childBomMap.get("pversion"));
            long childAuxp = BOMExpandConfigBusiness.getLongValue(childBomMap.get("pauxproperty"));
            long childTypeId = BOMExpandConfigBusiness.getLongValue(childBomMap.get("type"));
            String childqtytype = String.valueOf(childBomMap.get("entryqtytype"));
            BigDecimal childqtydenominator = (BigDecimal)childBomMap.get("entryqtydenominator");
            BigDecimal childqtynumerator = (BigDecimal)childBomMap.get("entryqtynumerator");
            String childSeq = String.valueOf(childBomMap.get("entryseq"));
            String entryStrId = String.valueOf(childBomMap.get("entryStrId"));
            boolean isOne = childqtydenominator.compareTo(BigDecimal.ONE) == 0;
            BigDecimal childQty = MMCUtils.multiplyAndDivide((BigDecimal)entryqty, (BigDecimal)childqtynumerator, (BigDecimal)childqtydenominator);
            String entryQtyStr = childQty.toPlainString();
            int pointIndex = entryQtyStr.indexOf(".");
            if (pointIndex > 13) {
                String number = (String)childBomMap.get("number");
                throw new KDBizException(String.format(ResManager.loadKDString((String)"BOM\u5728\u201c%s\u201d\u5904\uff0c\u6570\u503c\u5927\u4e8e\u201c9999999999999\u201d\uff0c\u8bf7\u4fee\u6539", (String)"ParseFeatureListToMatListBusiness_1", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), number));
            }
            if ("B".equals(childqtytype)) {
                childQty = MMCUtils.divide((BigDecimal)childqtynumerator, (BigDecimal)childqtydenominator);
            }
            childSeq = entrySeq + "." + childSeq;
            if (entryMatId != childMatId || entryAuxp != childAuxp || entryBomTypeId != childTypeId) continue;
            String seq = String.valueOf(childBomMap.get("entryseq"));
            int tmpAuxSeq = Integer.parseInt(seq);
            if (auxSeq < tmpAuxSeq) {
                auxSeq = tmpAuxSeq;
            }
            Map copyChildBomMap = MMCUtils.mapCopy(childBomMap);
            String treeNodeId = String.valueOf(pks[i]);
            copyChildBomMap.put("pid", id);
            copyChildBomMap.put("id", treeNodeId);
            copyChildBomMap.put("entryqty", childQty);
            copyChildBomMap.put("entryseq", childSeq);
            copyChildBomMap.put("longnumber", longnumber + entryStrId);
            copyChildBomMap.put("parentqty", entryqty);
            copyChildBomMap.put("parentfxd", entryqtytype);
            Long entryMaterialId = PlatformUtils.getLongValue((Map)copyChildBomMap, (String)"entrymaterial_id");
            if (PlatformUtils.isNullLong((Long)entryMaterialId)) {
                copyChildBomMap.put("longmaterialids", longMaterialIds);
            } else {
                String currentLongMaterialIds = longMaterialIds + "%" + entryMaterialId;
                copyChildBomMap.put("longmaterialids", currentLongMaterialIds);
            }
            List<Map<String, Object>> auxBomList = this.filterMatAuxBom(childAuxBomList, childMatId, longnumber);
            retAuxBomList.addAll(auxBomList);
            retList.add(copyChildBomMap);
            bomVserionIdSet.add(childVerId);
        }
        retList = BOMExpandConfigBusiness.firstLevelPriorityFilterByWBS(retList, bomExpandMap, wbsId, "");
        long verId = entryversion;
        if ("B".equals(verConfig)) {
            verId = BOMVersionFilterBusiness.getTheLastVerOfMaterial(retList, searchDate, "", enableVersionIds);
            if (verId != 0L && !enableVersionIds.contains(verId)) {
                retList.clear();
            }
            if ((bomVserionIdSize = bomVserionIdSet.size()) > 1 || bomVserionIdSize == 1 && !bomVserionIdSet.contains(verId)) {
                retList = BOMVersionFilterBusiness.versionFilter(retList, verId, searchDate, "");
            }
        } else {
            if (verId != 0L && !enableVersionIds.contains(verId)) {
                retList.clear();
            }
            if ((bomVserionIdSize = bomVserionIdSet.size()) > 1 || bomVserionIdSize == 1 && !bomVserionIdSet.contains(verId)) {
                retList = BOMVersionFilterBusiness.versionFilter(retList, verId, searchDate, "");
            }
        }
        retList = BOMExpandConfigBusiness.replaceNoFilter(retList, bomExpandMap, replaceNo);
        retList = BOMExpandConfigBusiness.replaceGroupFilter(retList, searchDate, "");
        List<Map<String, Object>> auxBomList = this.setAuxBom(retAuxBomList, auxSeq, entryqty, id, entrySeq);
        retList.addAll(auxBomList);
        return retList;
    }

    private List<Map<String, Object>> setAuxBom(Set<Map<String, Object>> retAuxBomList, int index, BigDecimal pEntryQty, String pId, String pSeq) {
        ArrayList<Map<String, Object>> retList = new ArrayList<Map<String, Object>>(retAuxBomList.size());
        if (retAuxBomList.isEmpty()) {
            return retList;
        }
        int i = 0;
        ORM orm = ORM.create();
        long[] pks = orm.genLongIds("pdm_mftbom", retAuxBomList.size());
        for (Map<String, Object> auxBomMap : retAuxBomList) {
            String treeNodeId = String.valueOf(pks[i]);
            BigDecimal childqtydenominator = (BigDecimal)auxBomMap.get("entryqtydenominator");
            BigDecimal childqtynumerator = (BigDecimal)auxBomMap.get("entryqtynumerator");
            String childqtytype = String.valueOf(auxBomMap.get("entryqtytype"));
            BigDecimal childQty = MMCUtils.multiplyAndDivide((BigDecimal)pEntryQty, (BigDecimal)childqtynumerator, (BigDecimal)childqtydenominator);
            if ("B".equals(childqtytype)) {
                childQty = MMCUtils.divide((BigDecimal)childqtynumerator, (BigDecimal)childqtydenominator);
            }
            String auxSeq = pSeq + "." + (index + (i + 1));
            auxBomMap.put("entryseq", auxSeq);
            auxBomMap.put("entryqty", childQty);
            auxBomMap.put("parentqty", pEntryQty);
            auxBomMap.put("pid", pId);
            auxBomMap.put("id", treeNodeId);
            auxBomMap.put("isauxbom", "1");
            auxBomMap.put("longmaterialids", "");
            retList.add(auxBomMap);
            ++i;
        }
        return retList;
    }

    private List<Map<String, Object>> filterMatAuxBom(List<Map<String, Object>> childAuxBomList, long childProMatId, String longnumber) {
        ArrayList<Map<String, Object>> retList = new ArrayList<Map<String, Object>>(64);
        if (childAuxBomList == null || childAuxBomList.isEmpty()) {
            return retList;
        }
        for (int i = 0; i < childAuxBomList.size(); ++i) {
            long childAuxBomMatId;
            Map<String, Object> childAuxBomMap = childAuxBomList.get(i);
            Object tmp = childAuxBomMap.get("pmaterial");
            long l = childAuxBomMatId = tmp instanceof Long ? (Long)tmp : Long.parseLong(tmp.toString());
            if (childProMatId != childAuxBomMatId) continue;
            Map copyChildBomMap = MMCUtils.mapCopy(childAuxBomMap);
            String entryStrId = String.valueOf(childAuxBomMap.get("entryStrId"));
            copyChildBomMap.put("longnumber", longnumber + entryStrId);
            retList.add(copyChildBomMap);
        }
        return retList;
    }

    private boolean isEntryChecked(Map<Long, Set<String>> entryRuleMap, long entryid, Map<String, List<Object>> varValues) {
        Object runFormulaRet;
        boolean isSelected = false;
        if (entryRuleMap == null || entryRuleMap.isEmpty()) {
            isSelected = true;
            return isSelected;
        }
        Set<String> entryFormula = entryRuleMap.get(entryid);
        isSelected = entryFormula == null || entryFormula.isEmpty() ? true : (runFormulaRet = PDMFormulaRunBusiness.getInstance().runFormula("2", entryFormula, varValues)) instanceof Boolean && (Boolean)runFormulaRet != false;
        return isSelected;
    }

    private JSONObject getFormulaVal(Map<Long, Set<String>> entryRuleMap, long entryId, Map<String, List<Object>> varValues) {
        if (entryRuleMap == null || entryRuleMap.isEmpty()) {
            return null;
        }
        Set<String> entryFormula = entryRuleMap.get(entryId);
        if (entryFormula == null || entryFormula.isEmpty()) {
            return null;
        }
        JSONObject retObj = (JSONObject)PDMFormulaRunBusiness.getInstance().runFormula("3", entryFormula, varValues);
        return retObj;
    }

    private List<Map<String, Object>> getBomRuleEntry(Set<Long> bomIdSet) {
        SqlBuilder sb = new SqlBuilder();
        sb.append(" select", new Object[0]);
        sb.append(" B.FEntryId entryid ", new Object[0]);
        sb.append(",C.fchararuleid chararuleno ", new Object[0]);
        sb.append(" from t_pdm_mftbomentry B ", new Object[0]);
        sb.append(" inner join t_pdm_superbomchrulentry C ON C.FEntryId=B.FEntryId ", new Object[0]);
        sb.append(" where  ", new Object[0]);
        sb.appendIn(" B.fid", bomIdSet.toArray());
        DataSet entryDataSet = DB.queryDataSet((String)ParseFeatureListToMatListBusiness.class.getName(), (DBRoute)scmDBRoute, (SqlBuilder)sb);
        return MMCUtils.parseToList((DataSet)entryDataSet);
    }

    private List<Map<String, Object>> getRuleList(List<Map<String, Object>> ruleEntryList) {
        ArrayList<Map<String, Object>> retList = new ArrayList<Map<String, Object>>(128);
        HashSet<Long> ruleIdSet = new HashSet<Long>(64);
        if (ruleEntryList == null || ruleEntryList.isEmpty()) {
            return retList;
        }
        for (int i = 0; i < ruleEntryList.size(); ++i) {
            long ruleId;
            Map<String, Object> ruleMap = ruleEntryList.get(i);
            Object ruleObj = ruleMap.get("CHARARULENO");
            long l = ruleObj == null ? 0L : (ruleId = ruleObj instanceof Long ? (Long)ruleObj : Long.parseLong(ruleObj.toString()));
            if (ruleId == 0L) continue;
            ruleIdSet.add(ruleId);
        }
        if (ruleIdSet.isEmpty()) {
            return retList;
        }
        QFilter filter = new QFilter("id", "in", ruleIdSet);
        DataSet ruleDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"pdm_chararule", (String)"id,type,formula", (QFilter[])new QFilter[]{filter}, null);
        return MMCUtils.parseToList((DataSet)ruleDataSet);
    }

    private Map<Long, Set<Long>> getEntryRuleIds(List<Map<String, Object>> ruleEntryList) {
        HashMap<Long, Set<Long>> enrtyMap = new HashMap<Long, Set<Long>>(64);
        if (ruleEntryList == null || ruleEntryList.isEmpty()) {
            return enrtyMap;
        }
        for (int i = 0; i < ruleEntryList.size(); ++i) {
            long entryId;
            long ruleId;
            Map<String, Object> ruleMap = ruleEntryList.get(i);
            Object entryObj = ruleMap.get("ENTRYID");
            Object ruleObj = ruleMap.get("CHARARULENO");
            long l = ruleObj == null ? 0L : (ruleId = ruleObj instanceof Long ? (Long)ruleObj : Long.parseLong(ruleObj.toString()));
            long l2 = entryObj == null ? 0L : (entryId = entryObj instanceof Long ? (Long)entryObj : Long.parseLong(entryObj.toString()));
            if (ruleId == 0L) continue;
            HashSet<Long> ruleSet = (HashSet<Long>)enrtyMap.get(entryId);
            if (ruleSet == null) {
                ruleSet = new HashSet<Long>(64);
            }
            ruleSet.add(ruleId);
            enrtyMap.put(entryId, ruleSet);
        }
        return enrtyMap;
    }

    private Map<Long, Set<String>> getEntryformula(Map<Long, Set<Long>> enrtyMap, List<Map<String, Object>> ruleList, String formulaType) {
        HashMap<Long, Set<String>> entryRuleMap = new HashMap<Long, Set<String>>(100);
        Set<Map.Entry<Long, Set<Long>>> entrySet = enrtyMap.entrySet();
        for (int i = 0; i < ruleList.size(); ++i) {
            String type;
            Map<String, Object> ruleData = ruleList.get(i);
            Object ruleIdObj = ruleData.get("id");
            Object formulaObj = ruleData.get("formula");
            Object typeObj = ruleData.get("type");
            long ruleId = ruleIdObj == null ? 0L : (ruleIdObj instanceof Long ? (Long)ruleIdObj : Long.parseLong(ruleIdObj.toString()));
            String formula = formulaObj == null ? "" : formulaObj.toString();
            String string = type = typeObj == null ? "" : typeObj.toString();
            if (type != null && !"".equals(type) && !type.equals(formulaType) || formulaType == null || type == null || "".equals(formulaType) || "".equals(type)) continue;
            for (Map.Entry<Long, Set<Long>> mapEntry : entrySet) {
                long entryId = mapEntry.getKey();
                Set<Long> ruleSet = mapEntry.getValue();
                if (!ruleSet.contains(ruleId)) continue;
                HashSet<String> formulaSet = (HashSet<String>)entryRuleMap.get(entryId);
                if (formulaSet == null) {
                    formulaSet = new HashSet<String>(64);
                }
                formulaSet.add(formula);
                entryRuleMap.put(entryId, formulaSet);
            }
        }
        return entryRuleMap;
    }

    private boolean isRepeatBom(Row row) {
        boolean retFlag = false;
        long entryId = row.getLong("entryid");
        String longnumber = row.getString("longnumber");
        String lastEntryId = String.valueOf(entryId);
        int lastEntryIndex = longnumber.lastIndexOf(lastEntryId);
        if (longnumber.indexOf(lastEntryId) < lastEntryIndex) {
            QFilter filter = new QFilter("id", "=", (Object)row.getLong("pmaterial"));
            try (DataSet materialMtfDataSet = QueryServiceHelper.queryDataSet((String)"BomFowordSearchReportTreePlugin", (String)"bd_material", (String)"id,number", (QFilter[])new QFilter[]{filter}, null);){
                if (materialMtfDataSet.hasNext()) {
                    Row tmpRow = materialMtfDataSet.next();
                    String number = tmpRow.getString("number");
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"BOM\u5728\u201c%s\u201d\u5904\u51fa\u73b0\u6b7b\u5faa\u73af\u3002", (String)"ParseFeatureListToMatListBusiness_0", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), number));
                }
            }
            catch (Exception e) {
                logger.error((Object)e.toString());
                throw e;
            }
        }
        return retFlag;
    }

    private Map<String, List<Object>> ormDefNumAndFeeatureVal(List<Map<String, Object>> newfeatureDefs, Map<String, List<Map<String, Object>>> newFeatureDefAndValueColls) {
        HashMap<String, List<Object>> varValues = new HashMap<String, List<Object>>(4);
        if (newFeatureDefAndValueColls == null) {
            return varValues;
        }
        Set<Map.Entry<String, List<Map<String, Object>>>> defAndValueSet = newFeatureDefAndValueColls.entrySet();
        for (Map.Entry<String, List<Map<String, Object>>> defAndValue : defAndValueSet) {
            List<Map<String, Object>> valList = defAndValue.getValue();
            if (valList == null || valList.isEmpty()) continue;
            for (int i = 0; i < valList.size(); ++i) {
                Map<String, Object> valEntry = valList.get(i);
                Object featureDefNumObj = valEntry.get("featuredefnum");
                if (featureDefNumObj == null) {
                    featureDefNumObj = valEntry.get("featureNum");
                }
                String featureDefNum = featureDefNumObj == null ? "" : featureDefNumObj.toString();
                Object featureValObj = valEntry.get("entryvalue");
                String value = featureValObj == null ? "" : featureValObj.toString();
                ArrayList<String> retList = (ArrayList<String>)varValues.get(featureDefNum);
                if (retList == null) {
                    retList = new ArrayList<String>();
                }
                retList.add(String.valueOf(value));
                varValues.put(featureDefNum, retList);
            }
        }
        return varValues;
    }

    /*
     * WARNING - void declaration
     */
    public List<Map<String, Object>> featureTypeToMaterial(Map<String, Object> superBomEntry, Map<String, List<Map<String, Object>>> newFeatureDefAndValueColls, List<Map<String, Object>> newfeatureDefs, String parentLongMaterialIds) {
        void var19_22;
        long entryunit;
        ArrayList<Map<String, Object>> matList = new ArrayList<Map<String, Object>>(16);
        if (newFeatureDefAndValueColls == null || newfeatureDefs == null) {
            return matList;
        }
        String pkVal = String.valueOf(superBomEntry.get("featuretype"));
        long l = entryunit = superBomEntry.get("entryunit") == null ? 0L : Long.parseLong(superBomEntry.get("entryunit").toString());
        if (entryunit != 0L) {
            this.featureUnitSet.add(entryunit);
        }
        QFilter filter = null;
        Set<Map.Entry<String, List<Map<String, Object>>>> valueSet = newFeatureDefAndValueColls.entrySet();
        QFilter featureTypeFilter = new QFilter("featureinfo.featuretype", "=", (Object)Long.valueOf(pkVal));
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter status = new QFilter("status", "=", (Object)"C");
        HashSet<String> ppSet = new HashSet<String>(64);
        ORM orm = ORM.create();
        for (Map.Entry<String, List<Map<String, Object>>> featureVal : valueSet) {
            String featureDef = featureVal.getKey();
            List<Map<String, Object>> list = featureVal.getValue();
            if (list == null) continue;
            for (int i = 0; i < list.size(); ++i) {
                Map<String, Object> featureConfigVal = list.get(i);
                Object entryValueObj = featureConfigVal.get("entryvalue");
                String entryvalue = entryValueObj == null ? "" : entryValueObj.toString();
                ppSet.add((String)featureDef + "_" + entryvalue);
            }
        }
        filter = featureTypeFilter.and(status).and(enableFilter);
        Map<Long, Set<JSONObject>> schemeMap = this.getConfigSchemeMap(filter);
        Set<Map.Entry<Long, Set<JSONObject>>> entrySet = schemeMap.entrySet();
        for (Map.Entry entry : entrySet) {
            long matId = 0L;
            boolean isFormat = false;
            Set schemeFeatureSet = (Set)entry.getValue();
            for (JSONObject entryVal : schemeFeatureSet) {
                String featureid = entryVal.getString("featureid");
                String featurevalue = entryVal.getString("featurevalue");
                if (!ppSet.contains(featureid + "_" + featurevalue)) {
                    isFormat = false;
                    break;
                }
                matId = entryVal.getLong("matId");
                isFormat = true;
            }
            if (!isFormat) continue;
            Map newSuperbomEntryMap = MMCUtils.mapCopy(superBomEntry);
            newSuperbomEntryMap.put("entrymaterial_id", matId);
            newSuperbomEntryMap.put("longmaterialids", WorkStationSplitBusiness.genLongMaterialIds(parentLongMaterialIds, newSuperbomEntryMap));
            matList.add(newSuperbomEntryMap);
            this.featureMatSet.add(matId);
        }
        long[] pks = orm.genLongIds("pdm_mftbom", matList.size());
        boolean bl = false;
        while (var19_22 < matList.size()) {
            Map newSuperbomEntryMap = (Map)matList.get((int)var19_22);
            String treeNodeId = String.valueOf(pks[var19_22]);
            newSuperbomEntryMap.put("id", treeNodeId);
            ++var19_22;
        }
        return matList;
    }

    private Map<Long, Set<JSONObject>> getConfigSchemeMap(QFilter filter) {
        HashMap<Long, Set<JSONObject>> retMap = new HashMap<Long, Set<JSONObject>>(128);
        try (DataSet planData = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"pdm_proconfigscheme", (String)"id,materielnum,featureinfo.subentryentity.featureid featureid,featureinfo.subentryentity.featurevalue featurevalue ", (QFilter[])new QFilter[]{filter}, (String)"id");){
            while (planData.hasNext()) {
                Row planRow = planData.next();
                long schemeId = planRow.getLong("id");
                HashSet<JSONObject> schemeSet = (HashSet<JSONObject>)retMap.get(schemeId);
                if (schemeSet == null) {
                    schemeSet = new HashSet<JSONObject>(128);
                }
                JSONObject valueObj = new JSONObject();
                valueObj.put("matId", (Object)planRow.getLong("materielnum"));
                valueObj.put("featureid", planRow.get("featureid"));
                valueObj.put("featurevalue", planRow.get("featurevalue"));
                schemeSet.add(valueObj);
                retMap.put(schemeId, schemeSet);
            }
        }
        return retMap;
    }

    public static String getPropertiesWithQuerySuperBom(BigDecimal num) {
        StringBuilder sb = new StringBuilder();
        sb.append("concat('',id) as id");
        sb.append(",id as superbomid");
        sb.append(",number as number");
        sb.append(",materialid as pmaterial");
        sb.append(",material as pmaterialmftinfo");
        sb.append(",createorg as createorg");
        sb.append(",'0' as routeId");
        sb.append(",'0' as isauxbom");
        sb.append(",'A' as parentfxd");
        sb.append(",version as pversion");
        sb.append(",auxproperty pauxproperty ");
        sb.append(",replaceno replaceno ");
        sb.append(",wbs as wbs ");
        sb.append(",type as type");
        sb.append(",modifytime as modifytime");
        sb.append(",0.0 as parentqty");
        sb.append(",'0' as pid");
        sb.append(",'false' as issolid");
        sb.append(",entry.entrymaterial as entrymaterial");
        sb.append(",entry.id as entryid");
        sb.append(",entry.id as superbomentryid");
        sb.append(",concat('-',entry.id) entryStrId");
        sb.append(",concat('',entry.id) longnumber");
        sb.append(",concat('',entry.seq) as entryseq");
        sb.append(",entry.entrymaterialid as entrymaterial_id");
        sb.append(",entry.featuretype as featuretype");
        sb.append(",entry.entryqtytype as entryqtytype");
        sb.append(",entry.entryscraprate as entryscraprate");
        sb.append(",entry.entryinvaliddate as entryinvaliddate");
        sb.append(",entry.entrymaterialattr as entrymaterialattr");
        sb.append(",entry.entryunit as entryunit");
        sb.append(",entry.entryfixscrap as entryfixscrap");
        sb.append(",entry.entryvaliddate as entryvaliddate");
        sb.append(",entry.entryisjumplevel as entryisjumplevel");
        sb.append(",entry.entrytype as entrytype");
        sb.append(",entry.entryqtynumerator as entryqtynumerator");
        sb.append(",entry.entryqtydenominator as entryqtydenominator");
        sb.append(",0.0 as entryunitqty");
        sb.append(",1.0 convertrate");
        sb.append(',');
        sb.append(num);
        sb.append("*entry.entryqtynumerator/entry.entryqtydenominator as entryqty");
        sb.append(",entry.entryversion as entryversion");
        sb.append(",entry.entryauxproperty as entryauxproperty");
        sb.append(",entry.configproperties as configproperties");
        sb.append(",entry.entryisreplace as entryisreplace");
        sb.append(",entry.entryreplaceplan as entryreplaceplan");
        sb.append(",entry.entryisreplaceplanmm as entryisreplaceplanmm");
        sb.append(",entry.entryreplacegroup as entryreplacegroup");
        sb.append(",entry.reppriority as reppriority");
        return sb.toString();
    }

    public static String getHeadFields() {
        StringBuilder sb = new StringBuilder("id");
        sb.append(",number");
        sb.append(",createorg");
        sb.append(",superbom");
        sb.append(",prodorgid");
        sb.append(",materielno");
        sb.append(",productconfigplan");
        sb.append(",masterconfigcode");
        return sb.toString();
    }

    public static int countOccurrences(String str, String regex) {
        regex = "[.]";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(str);
        int count = 0;
        while (m.find()) {
            ++count;
        }
        return count;
    }

    private Map<String, List<Map<String, Object>>> buildMap(List<Map<String, Object>> childList, Set<Long> bomVersionIds, Set<Long> childBomIdSet) {
        int size = childList.size();
        HashMap<String, List<Map<String, Object>>> dataMap = new HashMap<String, List<Map<String, Object>>>(64);
        for (int i = 0; i < size; ++i) {
            Object tmp;
            Map<String, Object> childMap = childList.get(i);
            long childMaterialId = (Long)childMap.get("pmaterial");
            long auxproperty = (Long)childMap.get("pauxproperty");
            String keyString = this.buildKeyString(childMaterialId, auxproperty);
            ArrayList<Map<String, Object>> list = (ArrayList<Map<String, Object>>)dataMap.get(keyString);
            if (list == null) {
                list = new ArrayList<Map<String, Object>>(16);
            }
            list.add(childMap);
            dataMap.put(keyString, list);
            long bomVerId = BOMExpandConfigBusiness.getLongValue(childMap.get("pversion"));
            if (bomVerId != 0L) {
                bomVersionIds.add(bomVerId);
            }
            long supeBomId = (tmp = childMap.get("superbomid")) instanceof Long ? (Long)tmp : Long.parseLong(tmp.toString());
            childBomIdSet.add(supeBomId);
        }
        return dataMap;
    }

    private String buildKeyString(Long childMaterialId, Long auxproperty) {
        return childMaterialId + "_" + auxproperty;
    }

    private String getPurposeByMaterial(Long childMaterialId) {
        DynamicObject material = QueryServiceHelper.queryOne((String)"bd_material", (String)"configproperties", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)childMaterialId)});
        if (material != null && ("1".equals(material.getString("configproperties")) || "".equals(material.getString("configproperties")))) {
            return "A";
        }
        return "B";
    }
}

