/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.business.proconfig.proconfiglist;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.log4j.Logger;

public class ProductConifgFeatureListBusiness {
    private static Logger logger = Logger.getLogger(ProductConifgFeatureListBusiness.class);
    private static volatile ProductConifgFeatureListBusiness productConifgFeatureListBusiness;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ProductConifgFeatureListBusiness getInstance() {
        if (productConifgFeatureListBusiness != null) return productConifgFeatureListBusiness;
        Class<ProductConifgFeatureListBusiness> clazz = ProductConifgFeatureListBusiness.class;
        synchronized (ProductConifgFeatureListBusiness.class) {
            if (productConifgFeatureListBusiness != null) return productConifgFeatureListBusiness;
            productConifgFeatureListBusiness = new ProductConifgFeatureListBusiness();
            // ** MonitorExit[var0] (shouldn't be in output)
            return productConifgFeatureListBusiness;
        }
    }

    public Map<String, Object> getJsonProdConfigFeatureList(boolean isPricerelation, List<Long> configCodeList) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        if (configCodeList == null || configCodeList.isEmpty()) {
            resultMap.put("status", Boolean.FALSE);
            resultMap.put("erroMsg", ResManager.loadKDString((String)"\u4f20\u5165\u7684\u914d\u7f6e\u53f7ID\u96c6\u5408\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\u3002", (String)"ProductConifgFeatureListBusiness_3", (String)"mmc-pdm-business", (Object[])new Object[0]));
            resultMap.put("data", null);
            return resultMap;
        }
        logger.info((Object)("config_code: " + Arrays.toString(configCodeList.toArray())));
        try {
            QFilter configCode = new QFilter("masterconfigcode", "in", configCodeList);
            Map retMap = BusinessDataServiceHelper.loadFromCache((String)"pdm_productconfigure", (String)this.getSelectFields(), (QFilter[])new QFilter[]{configCode});
            return this.dealJsonData(configCodeList, isPricerelation, retMap);
        }
        catch (Exception e) {
            resultMap.put("status", Boolean.FALSE);
            resultMap.put("erroMsg", e.getMessage());
            resultMap.put("data", null);
            return resultMap;
        }
    }

    private JSONObject dealJsonData(List<Long> configCodeList, boolean isPriceRelation, Map<Object, DynamicObject> retMap) {
        JSONObject resultJson = new JSONObject();
        resultJson.put("status", (Object)Boolean.TRUE);
        resultJson.put("erroMsg", (Object)ResManager.loadKDString((String)"\u67e5\u8be2\u6210\u529f", (String)"ProductConifgFeatureListBusiness_2", (String)"mmc-pdm-business", (Object[])new Object[0]));
        if (retMap == null || retMap.isEmpty() || configCodeList == null) {
            resultJson.put("data", (Object)"");
            return resultJson;
        }
        Set<Map.Entry<Object, DynamicObject>> entrySet = retMap.entrySet();
        HashSet<Long> findCode = new HashSet<Long>(8);
        JSONArray dataJson = new JSONArray();
        for (Map.Entry<Object, DynamicObject> entry : entrySet) {
            DynamicObject entryObj = entry.getValue();
            DataEntityPropertyCollection parentprop = entryObj.getDataEntityType().getProperties();
            Long configCodePK = 0L;
            configCodePK = this.getFromTreeEntryConfigCode(entryObj, configCodeList);
            if (configCodePK != 0L) {
                findCode.add(configCodePK);
            }
            JSONObject configIDObj = new JSONObject();
            JSONObject configListObj = new JSONObject();
            JSONArray featureJSONArray = new JSONArray();
            if (configCodePK != 0L && parentprop.containsKey((Object)"entryentity")) {
                ArrayList<DynamicObject> featureValueInfoList;
                DynamicObjectCollection entityEntryDOC = entryObj.getDynamicObjectCollection("entryentity");
                HashMap<String, ArrayList<String>> featureValueMap = new HashMap<String, ArrayList<String>>(4);
                HashMap<String, ArrayList<DynamicObject>> featureValueInfoMap = new HashMap<String, ArrayList<DynamicObject>>(4);
                HashMap<String, String> featureNumberMap = new HashMap<String, String>(4);
                HashMap<String, String> featureNameMap = new HashMap<String, String>(4);
                for (int i = 0; i < entityEntryDOC.size(); ++i) {
                    ArrayList<String> featureValueList;
                    DynamicObject entityEntryDO = (DynamicObject)entityEntryDOC.get(i);
                    if (entityEntryDO == null) continue;
                    DynamicObject featureDO = entityEntryDO.getDynamicObject("featureid");
                    Long featurePk = 0L;
                    if (featureDO != null) {
                        featurePk = featureDO.getLong("id");
                        String featureNumber = featureDO.getString("number");
                        featureNumberMap.put(featurePk.toString(), featureNumber);
                        String featureName = featureDO.getString("name");
                        featureNameMap.put(featurePk.toString(), featureName);
                        boolean ispricerelation = featureDO.getBoolean("ispricerelation");
                        if (isPriceRelation && !ispricerelation) continue;
                        featureValueList = new ArrayList<String>(4);
                        featureValueInfoList = new ArrayList<DynamicObject>(4);
                    } else {
                        String featureNumberId = entityEntryDO.getString("featurenumberid");
                        if (Pattern.matches("^[0-9]*$", String.valueOf(featureNumberId))) {
                            featurePk = Long.parseLong(featureNumberId);
                        }
                        featureValueList = (ArrayList<String>)featureValueMap.get(featureNumberId);
                        featureValueInfoList = (ArrayList<DynamicObject>)featureValueInfoMap.get(featureNumberId);
                    }
                    String featureValue = entityEntryDO.getString("featurevalue");
                    if (featureValueList == null || featurePk <= 0L) continue;
                    featureValueList.add(featureValue);
                    featureValueInfoList.add(entityEntryDO);
                    featureValueMap.put(featurePk.toString(), featureValueList);
                    featureValueInfoMap.put(featurePk.toString(), featureValueInfoList);
                }
                for (Map.Entry feature : featureValueMap.entrySet()) {
                    String pkValue = (String)feature.getKey();
                    List value = (List)feature.getValue();
                    JSONObject featureJson = new JSONObject();
                    featureJson.put("featureid", (Object)pkValue);
                    featureJson.put("featurenumber", featureNumberMap.get(pkValue));
                    featureJson.put("featurename", featureNameMap.get(pkValue));
                    featureJson.put("featurevalue", (Object)value);
                    featureValueInfoList = (List)featureValueInfoMap.get(pkValue);
                    List<Map<String, String>> featureValueInfo = this.getFeatureInfoJson((List<DynamicObject>)featureValueInfoList);
                    featureJson.put("featurevalueinfo", featureValueInfo == null ? "" : featureValueInfo);
                    featureJSONArray.add((Object)featureJson);
                }
            }
            configListObj.put("status", (Object)Boolean.TRUE);
            String msg = "";
            msg = featureJSONArray == null || featureJSONArray.size() == 0 ? String.format(ResManager.loadKDString((String)"\u4ea7\u54c1\u914d\u7f6e\u53f7\u201c%1$s\u201d\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u4ea7\u54c1\u914d\u7f6e\u6e05\u5355\u3002", (String)"ProductConifgFeatureListBusiness_1", (String)"mmc-pdm-business", (Object[])new Object[0]), configCodePK) : ResManager.loadKDString((String)"\u67e5\u8be2\u6210\u529f", (String)"ProductConifgFeatureListBusiness_2", (String)"mmc-pdm-business", (Object[])new Object[0]);
            configListObj.put("erroMsg", (Object)msg);
            configListObj.put("featurelist", (Object)featureJSONArray);
            configIDObj.put(configCodePK.toString(), (Object)configListObj);
            dataJson.add((Object)configIDObj);
        }
        if (findCode.size() < configCodeList.size()) {
            for (int i = 0; i < configCodeList.size(); ++i) {
                Long cofigCode = configCodeList.get(i);
                if (cofigCode == null || findCode.contains(cofigCode)) continue;
                JSONObject configIDJson = new JSONObject();
                JSONObject configListObj = new JSONObject();
                configListObj.put("status", (Object)Boolean.TRUE);
                configListObj.put("erroMsg", (Object)String.format(ResManager.loadKDString((String)"\u4ea7\u54c1\u914d\u7f6e\u53f7\u201c%1$s\u201d\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u4ea7\u54c1\u914d\u7f6e\u6e05\u5355\u3002", (String)"ProductConifgFeatureListBusiness_1", (String)"mmc-pdm-business", (Object[])new Object[0]), cofigCode));
                configListObj.put("featurelist", (Object)new JSONArray());
                configIDJson.put(cofigCode.toString(), (Object)configListObj);
                dataJson.add((Object)configIDJson);
            }
        }
        resultJson.put("data", (Object)dataJson);
        logger.info((Object)("config_code result: " + resultJson == null ? "" : resultJson.toString()));
        return resultJson;
    }

    private List<Map<String, String>> getFeatureInfoJson(List<DynamicObject> entryList) {
        if (entryList == null || entryList.isEmpty()) {
            return null;
        }
        ArrayList<Map<String, String>> featureValueInfo = new ArrayList<Map<String, String>>(8);
        for (int i = 0; i < entryList.size(); ++i) {
            DynamicObject entityEntryDO = entryList.get(i);
            HashMap<String, String> featureValueInfoMap = new HashMap<String, String>(2);
            String featureValue = entityEntryDO.getString("featurevalue");
            String featureValueName = entityEntryDO.getString("featurevaluename");
            featureValueInfoMap.put("featurevalue", featureValue);
            featureValueInfoMap.put("featurevaluename", featureValueName);
            featureValueInfo.add(featureValueInfoMap);
            String featureNumber = "";
            DynamicObject featureDO = entityEntryDO.getDynamicObject("featureid");
            if (featureDO == null) continue;
            featureNumber = featureDO.getString("number");
        }
        return featureValueInfo;
    }

    private long getFromTreeEntryConfigCode(DynamicObject entryObj, List<Long> configCodeList) {
        long configCodeID;
        long configCodePK = 0L;
        if (entryObj == null || configCodeList == null || configCodeList.isEmpty()) {
            return configCodePK;
        }
        DynamicObject configCodeDO = entryObj.getDynamicObject("masterconfigcode");
        if (configCodeDO != null && configCodeList.contains(configCodeID = configCodeDO.getLong("id"))) {
            configCodePK = configCodeID;
        }
        return configCodePK;
    }

    private String getSelectFields() {
        StringBuilder sb = new StringBuilder("id,number,createorg");
        sb.append(',').append("masterconfigcode");
        sb.append(",treeentryentity.pid");
        sb.append(",treeentryentity.id");
        sb.append(",treeentryentity.entrymaterial");
        sb.append(",treeentryentity.configcode");
        sb.append(",entryentity.id");
        sb.append(",entryentity.featurenumberid");
        sb.append(",entryentity.featureid");
        sb.append(",entryentity.featurevalue");
        sb.append(",entryentity.featurevaluename");
        sb.append(",entryentity.featureid.ispricerelation");
        sb.append(",entryentity.featureid.number");
        sb.append(",entryentity.featureid.name");
        return sb.toString();
    }
}

