/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.business.proconfig.proconfiglist;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.pdm.business.mftbom.bomsearch.BOMExpandConfigBusiness;
import kd.mmc.pdm.business.proconfig.proconfiglist.ParseFeatureListToMatListBusiness;
import kd.mmc.pdm.business.proconfig.proconfiglist.ProductConfigCommonBusiness;

public class ProductConifgListBusiness
extends ProductConfigCommonBusiness {
    private static final Log logger = LogFactory.getLog(ProductConifgListBusiness.class);
    private static ProductConifgListBusiness productConifgListBusiness;

    public static ProductConifgListBusiness getInstance() {
        if (productConifgListBusiness == null) {
            productConifgListBusiness = new ProductConifgListBusiness();
        }
        return productConifgListBusiness;
    }

    public JSONObject getJsonProdConfigList(List<Long> configCodeList) {
        JSONObject res = new JSONObject();
        return res;
    }

    public JSONObject getProdConfigListByFeature(String params) {
        String logMsg = String.format(ResManager.loadKDString((String)"\u8c03\u7528\u63a5\u53e3\u5f00\u59cb\uff0c\u8c03\u7528\u53c2\u6570:%s\u3002", (String)"ProductConifgListBusiness_13", (String)"mmc-pdm-business", (Object[])new Object[0]), params);
        logger.info(logMsg);
        JSONObject res = new JSONObject();
        try {
            JSONObject paramsJson = JSONObject.parseObject((String)params);
            Date dateTime = paramsJson.getDate("searchTime");
            boolean isNeedProRoute = paramsJson.getBoolean("isNeedProRoute");
            String model = paramsJson.getString("model");
            String matIdStr = paramsJson.getString("matId");
            String bomVer = paramsJson.getString("bomVer");
            BigDecimal num = paramsJson.getBigDecimal("num");
            List configCodeList = JSONObject.parseArray((String)paramsJson.get((Object)"configCodeList").toString(), Long.class);
            String orgId = paramsJson.getString("org");
            String bomId = paramsJson.getString("bomId");
            long replaceNo = paramsJson.get((Object)"replaceNo") == null ? 0L : paramsJson.getLong("replaceNo");
            long wbsId = paramsJson.get((Object)"wbs") == null ? 0L : paramsJson.getLong("wbs");
            String workCenter = paramsJson.getString("workCenter");
            boolean purchaseExpand = true;
            if (paramsJson.containsKey((Object)"purchaseExpand")) {
                purchaseExpand = paramsJson.getBoolean("purchaseExpand");
            }
            boolean jumplevelExpand = false;
            if (paramsJson.containsKey((Object)"jumplevelExpand")) {
                jumplevelExpand = paramsJson.getBoolean("jumplevelExpand");
            }
            int levelCount = 30;
            if (paramsJson.containsKey((Object)"levelCount")) {
                levelCount = paramsJson.getIntValue("levelCount");
            }
            boolean isCacheRedis = false;
            if (paramsJson.containsKey((Object)"cacheRedis")) {
                isCacheRedis = paramsJson.getBoolean("cacheRedis");
            }
            Date searchTime = dateTime;
            if ("model_pom".equals(model) || num == null || BigDecimal.ZERO.compareTo(num) == 0) {
                num = BigDecimal.ONE;
            }
            long matId = -1L;
            if (matIdStr != null && !"".equals(matIdStr)) {
                matId = Long.parseLong(matIdStr);
            }
            QFilter configCode = new QFilter("masterconfigcode", "in", (Object)configCodeList);
            DataSet proConfigListDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"pdm_productconfigure", (String)ParseFeatureListToMatListBusiness.getHeadFields(), (QFilter[])new QFilter[]{configCode}, (String)"id");
            DataSet proConfigListDataSet = proConfigListDs.copy();
            HashSet<Long> proConfigListIdSet = new HashSet<Long>(configCodeList.size());
            HashMap<Long, Set<Long>> materialOrgMap = new HashMap<Long, Set<Long>>(16);
            this.initProConfigData(proConfigListDs, proConfigListIdSet, materialOrgMap);
            HashMap<Long, List<Map<String, Object>>> featureMap = new HashMap(16);
            HashMap<Long, List<Map<String, Object>>> featureValMap = new HashMap(16);
            if (!proConfigListIdSet.isEmpty()) {
                DataSet featureDataSet = this.getFeatureDataSet(proConfigListIdSet);
                DataSet featureValDataSet = this.getFeatureValueDataSet(proConfigListIdSet);
                featureMap = this.getProComfigFeature(featureDataSet);
                featureValMap = this.getProComfigFeature(featureValDataSet);
            }
            JSONObject resJson = null;
            try {
                resJson = this.dealJsonData(proConfigListDataSet, "featureCheck", searchTime, isNeedProRoute, matId, model, bomVer, num, workCenter, purchaseExpand, featureMap, featureValMap, materialOrgMap, bomId, orgId, replaceNo, levelCount, jumplevelExpand, wbsId);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                throw e;
            }
            finally {
                proConfigListDataSet.close();
            }
            if (resJson == null || resJson.isEmpty()) {
                res.put("status", (Object)"failed");
                res.put("data", (Object)new JSONObject());
                res.put("msg", (Object)ResManager.loadKDString((String)"\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u53f7\u6216\u67e5\u8be2\u65f6\u95f4\u3002", (String)"ProductConifgListBusiness_1", (String)"mmc-pdm-business", (Object[])new Object[0]));
            } else {
                res.put("status", (Object)"success");
                res.put("data", (Object)resJson);
                res.put("msg", (Object)ResManager.loadKDString((String)"\u67e5\u8be2\u6210\u529f", (String)"ProductConifgListBusiness_2", (String)"mmc-pdm-business", (Object[])new Object[0]));
                if (isCacheRedis) {
                    List<String> configIdKeyList = this.cacheRedisValue(resJson, paramsJson);
                    JSONObject ret = new JSONObject();
                    ret.put("configIdKeyList", configIdKeyList);
                    ret.put("redisCachePath", (Object)this.getRedisPath());
                    res.put("data", (Object)ret);
                }
            }
        }
        catch (Exception e) {
            res.put("status", (Object)"failed");
            res.put("msg", (Object)String.format(ResManager.loadKDString((String)"\u63a5\u53e3\u6267\u884c\u9519\u8bef\uff1a%s\u3002", (String)"ProductConifgListBusiness_3", (String)"mmc-pdm-business", (Object[])new Object[0]), e.toString()));
            res.put("data", (Object)new JSONObject());
            throw new KDBizException((Throwable)e, new ErrorCode("parseException", ResManager.loadKDString((String)"\u63a5\u53e3\u6267\u884c\u9519\u8bef\u3002", (String)"ProductConifgListBusiness_10", (String)"mmc-pdm-business", (Object[])new Object[0])), new Object[]{""});
        }
        String msg = String.format(ResManager.loadKDString((String)"\u8c03\u7528\u63a5\u53e3\u7ed3\u675f\uff0c\u8c03\u7528\u7ed3\u679c:%s\u3002", (String)"ProductConifgListBusiness_12", (String)"mmc-pdm-business", (Object[])new Object[0]), res.get((Object)"status"));
        logger.info(msg);
        return res;
    }

    private JSONObject dealJsonData(DataSet proConfigListDataSet, String type, Date dateTime, boolean isNeedProRoute, long matId, String model, String bomVer, BigDecimal num, String workCenter, boolean purchaseExpand, Map<Long, List<Map<String, Object>>> featureMap, Map<Long, List<Map<String, Object>>> featureValMap, Map<Long, Set<Long>> materialOrgMap, String bomId, String searchOrgId, long replaceNo, int levelCount, boolean jumpLevelExpand, Long wbsId) throws Exception {
        JSONObject resutJson = new JSONObject();
        if (proConfigListDataSet == null || proConfigListDataSet.isEmpty()) {
            return resutJson;
        }
        Map<String, Map<String, Object>> cpMap = this.getCofigPlan(matId, materialOrgMap);
        while (proConfigListDataSet.hasNext()) {
            Map<String, TreeMap<Integer, Object>> bomExpandMap;
            Set<Long> bomTypeSet;
            DataSet supBomSet;
            JSONObject configListObj = new JSONObject();
            Row row = proConfigListDataSet.next();
            String comfigCode = row.getString("masterconfigcode");
            long createOrgId = row.getLong("createorg");
            long headMaterialId = row.getLong("materielno");
            String cpKeyString = ProductConifgListBusiness.getKeyString(headMaterialId, createOrgId);
            Map<String, Object> cpDataMap = cpMap.get(cpKeyString);
            if (cpDataMap == null || cpDataMap.isEmpty()) {
                configListObj.put("status", (Object)"failed");
                configListObj.put("errorMsg", (Object)ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u5ba1\u6838\u4e14\u53ef\u7528\u7684\u4ea7\u54c1\u914d\u7f6e\u65b9\u6848\u3002", (String)"ProductConifgListBusiness_11", (String)"mmc-pdm-business", (Object[])new Object[0]));
                configListObj.put("StackTrace", (Object)new StackTraceElement[0]);
                resutJson.put(comfigCode, (Object)configListObj);
                continue;
            }
            long configPlanId = 0L;
            long bomExpandConfig = 0L;
            if (cpDataMap != null) {
                configPlanId = (Long)cpDataMap.get("id");
                bomExpandConfig = (Long)cpDataMap.get("bomExpandConfig");
                String configtype = String.valueOf(cpDataMap.get("configtype"));
                if (!"2".equals(configtype)) continue;
            }
            String purPose = "B";
            if (headMaterialId != matId && matId != -1L) {
                purPose = this.getPurposeByMaterial(matId);
            }
            if ((supBomSet = this.getSuperBom(searchOrgId, bomId, matId, row, bomVer, bomTypeSet = BOMExpandConfigBusiness.getBomTypeOfPurpose(bomExpandMap = BOMExpandConfigBusiness.getBomExpandConfig(bomExpandConfig), purPose), num, replaceNo)).isEmpty()) {
                Long materialId = matId == -1L ? row.getLong("materielno") : matId;
                DynamicObject material = BusinessDataServiceHelper.loadSingleFromCache((Object)materialId, (String)"bd_material", (String)"number");
                String materialNumber = material == null ? "" : material.getString("number");
                configListObj.put("status", (Object)"failed");
                configListObj.put("errorMsg", (Object)String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%1$s\u201d\u4e0d\u5b58\u5728\u5ba1\u6838\u4e14\u53ef\u7528\u7684BOM\u3002", (String)"ProductConifgListBusiness_9", (String)"mmc-pdm-business", (Object[])new Object[0]), materialNumber));
                configListObj.put("StackTrace", (Object)new StackTraceElement[0]);
                resutJson.put(comfigCode, (Object)configListObj);
                supBomSet.close();
                continue;
            }
            if (bomId != null && !"".equals(bomId)) {
                replaceNo = this.getReplaceNo(supBomSet);
            }
            if (!"featureCheck".equals(type)) continue;
            long workCenterId = -1L;
            if (workCenter != null && !"".equals(workCenter)) {
                workCenterId = Long.parseLong(workCenter);
            }
            Map<String, List<Map<String, Object>>> newFeatureDefAndValueColls = this.getSelectedFeatureVal(row, featureValMap);
            List<Map<String, Object>> newfeatureDefs = featureMap.get(row.getLong("id"));
            ParseFeatureListToMatListBusiness parseBusiness = new ParseFeatureListToMatListBusiness(model, dateTime, num, workCenterId, isNeedProRoute, jumpLevelExpand, levelCount);
            try {
                Long versionId = bomVer == null || "".equals(bomVer) ? 0L : Long.parseLong(bomVer);
                DataSet treeEntryDataSet = parseBusiness.parase(row, supBomSet, newFeatureDefAndValueColls, newfeatureDefs, null, purchaseExpand, bomExpandMap, searchOrgId, replaceNo, wbsId, versionId);
                Map<String, String> featureMatAttrMap = parseBusiness.getMatAttrMap();
                Set<Long> matIdSet = parseBusiness.getFeatureTypeMaterial();
                Set<Long> unitSet = parseBusiness.getFeatureTypeUnit();
                JSONArray treeEntryArray = this.createEntryRetVal(treeEntryDataSet, row, featureMatAttrMap, purchaseExpand, matId, num, matIdSet, unitSet);
                configListObj.put("treeentryentity", (Object)treeEntryArray);
                configListObj.put("status", (Object)"success");
                configListObj.put("errorMsg", (Object)"");
                configListObj.put("StackTrace", (Object)new StackTraceElement[0]);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                logger.error("\u914d\u7f6eBOM\u5c55\u5f00\u5931\u8d25\uff1a" + e.getCause());
                configListObj.put("treeentryentity", (Object)new JSONArray());
                configListObj.put("status", (Object)"failed");
                configListObj.put("errorMsg", (Object)e.getMessage());
                configListObj.put("StackTrace", (Object)e.getStackTrace());
            }
            resutJson.put(comfigCode, (Object)configListObj);
        }
        return resutJson;
    }

    private String getPurposeByMaterial(Long childMaterialId) {
        DynamicObject material = QueryServiceHelper.queryOne((String)"bd_material", (String)"configproperties", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)childMaterialId)});
        if (material != null && ("1".equals(material.getString("configproperties")) || "".equals(material.getString("configproperties")))) {
            return "A";
        }
        return "B";
    }
}

