/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.common.bom.ecoroute;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.mmc.pdm.common.bom.ecoplatform.PlatformUtils;

public class EcoCommonHelper {
    public static void putHeadProperties(DynamicObject srcObject, DynamicObject targetObject, Set<String> unIncludeFieldSet) {
        DataEntityPropertyCollection properties = srcObject.getDynamicObjectType().getProperties();
        String entityName = EcoCommonHelper.getEntityName(targetObject);
        for (IDataEntityProperty prop : properties) {
            String proname = prop.getName();
            if (StringUtils.isEmpty((String)proname) || unIncludeFieldSet != null && unIncludeFieldSet.contains(proname) || EcoCommonHelper.isMulLanguaueText(proname) || StringUtils.isEmpty((String)prop.getAlias()) || prop.getDisplayName() == null || prop instanceof EntryProp || !targetObject.containsProperty(proname)) continue;
            if (prop instanceof MulBasedataProp) {
                Object sourceData = srcObject.get(proname);
                DynamicObjectCollection targetData = null;
                if (sourceData instanceof MulBasedataDynamicObjectCollection) {
                    MulBasedataDynamicObjectCollection sourceColl = (MulBasedataDynamicObjectCollection)sourceData;
                    if (sourceColl.isEmpty()) {
                        targetData = sourceColl;
                    } else {
                        ArrayList<Object> baseDataObjectList = new ArrayList<Object>(sourceColl.size());
                        for (int i = 0; i < sourceColl.size(); ++i) {
                            DynamicObject dy = (DynamicObject)sourceColl.get(i);
                            baseDataObjectList.add(dy.getDynamicObject("fbasedataid"));
                        }
                        targetData = EcoCommonHelper.getEntryMulBaseDataDyColl(entityName, baseDataObjectList, proname, EcoCommonHelper.getSubCollEntityName(targetObject, prop));
                    }
                } else {
                    targetData = EcoCommonHelper.getNullColl();
                }
                targetObject.set(proname, (Object)targetData);
                continue;
            }
            targetObject.set(proname, srcObject.get(proname));
        }
    }

    public static DynamicObjectCollection getEntryMulBaseDataDyColl(String entityName, List<Object> fieldValueIds, String fieldName, String mulBasedataEntity) {
        DynamicObject paySchDy = ORM.create().newDynamicObject(entityName);
        DynamicObjectCollection dyColl = paySchDy.getDynamicObjectCollection(fieldName);
        DynamicObjectType dynamicObjectType = dyColl.getDynamicObjectType();
        for (int i = 0; i < fieldValueIds.size(); ++i) {
            DynamicObject mulBasedataDy = new DynamicObject(dynamicObjectType);
            DynamicObject payBizActDy = BusinessDataServiceHelper.newDynamicObject((String)mulBasedataEntity);
            DynamicObject data = (DynamicObject)fieldValueIds.get(i);
            if (data == null) continue;
            payBizActDy.set("id", data.getPkValue());
            mulBasedataDy.set("fbasedataid", (Object)payBizActDy);
            dyColl.add((Object)mulBasedataDy);
        }
        return dyColl;
    }

    private static DynamicObjectCollection getNullColl() {
        return new DynamicObjectCollection();
    }

    private static String getEntityName(DynamicObject targetObj) {
        return targetObj.getDataEntityType().getName();
    }

    private static String getSubCollEntityName(DynamicObject targetObj, IDataEntityProperty prop) {
        MulBasedataProp baseProp = (MulBasedataProp)prop;
        return baseProp.getBaseEntityId();
    }

    private static boolean isMulLanguaueText(String propName) {
        return "multilanguagetext".equalsIgnoreCase(propName);
    }

    public static void putAllProperties(DynamicObject srcObject, DynamicObject targetObject, Set<String> unIncludeFieldSet) {
        DataEntityPropertyCollection properties = srcObject.getDynamicObjectType().getProperties();
        String entityName = EcoCommonHelper.getEntityName(targetObject);
        for (IDataEntityProperty prop : properties) {
            String proname = prop.getName();
            if (StringUtils.isEmpty((String)proname) || unIncludeFieldSet != null && unIncludeFieldSet.contains(proname) || EcoCommonHelper.isMulLanguaueText(proname) || prop.getDisplayName() == null) continue;
            if (prop instanceof EntryProp) {
                DynamicObjectCollection subColl;
                Object subCollObj = srcObject.get(proname);
                if (!targetObject.containsProperty(proname) || !(subCollObj instanceof DynamicObjectCollection) || PlatformUtils.isNullCollection(subColl = (DynamicObjectCollection)subCollObj)) continue;
                for (DynamicObject srcSubObject : subColl) {
                    DynamicObject targetSubObject = targetObject.getDynamicObjectCollection(proname).addNew();
                    EcoCommonHelper.putAllProperties(srcSubObject, targetSubObject, unIncludeFieldSet);
                }
                continue;
            }
            if (!targetObject.containsProperty(proname)) continue;
            if (prop instanceof MulBasedataProp) {
                Object sourceData = srcObject.get(proname);
                DynamicObjectCollection targetData = null;
                if (sourceData instanceof MulBasedataDynamicObjectCollection) {
                    MulBasedataDynamicObjectCollection sourceColl = (MulBasedataDynamicObjectCollection)sourceData;
                    if (sourceColl.isEmpty()) {
                        targetData = sourceColl;
                    } else {
                        ArrayList<Object> baseDataObjectList = new ArrayList<Object>(sourceColl.size());
                        for (int i = 0; i < sourceColl.size(); ++i) {
                            DynamicObject dy = (DynamicObject)sourceColl.get(i);
                            baseDataObjectList.add(dy.getDynamicObject("fbasedataid"));
                        }
                        targetData = EcoCommonHelper.getEntryMulBaseDataDyColl(entityName, baseDataObjectList, proname, EcoCommonHelper.getSubCollEntityName(targetObject, prop));
                    }
                } else {
                    targetData = EcoCommonHelper.getNullColl();
                }
                targetObject.set(proname, (Object)targetData);
                continue;
            }
            targetObject.set(proname, srcObject.get(proname));
        }
    }

    public static Set<String> getEcoRouteHeadField() {
        HashSet<String> fields = new HashSet<String>(16);
        fields.add("id");
        fields.add("number");
        fields.add("name");
        fields.add("createorg");
        fields.add("version");
        fields.add("processtype");
        fields.add("material");
        fields.add("ismainprocess");
        fields.add("routereplace");
        fields.add("materialgroup");
        fields.add("unit");
        fields.add("auxproperty");
        fields.add("configcode");
        fields.add("group");
        fields.add("status");
        fields.add("enable");
        fields.add("pentryvaliddate");
        fields.add("productno");
        fields.add("routeid");
        fields.add("pentryvaliddate");
        fields.add("pentryvaliddate");
        fields.add("wbs");
        return fields;
    }

    public static String getEcoRouteHeadSelectProperties() {
        Set<String> headfields = EcoCommonHelper.getEcoRouteHeadField();
        StringBuilder sb = new StringBuilder();
        for (String fieldNumber : headfields) {
            sb.append(fieldNumber).append(",");
        }
        String sp = sb.toString();
        return sp.substring(0, sp.length() - 1);
    }

    public static boolean isDifferent(Object oldValue, Object newValue) {
        if (oldValue == null && newValue == null) {
            return Boolean.FALSE;
        }
        if (oldValue == null || newValue == null) {
            return Boolean.TRUE;
        }
        if (oldValue instanceof DynamicObject && newValue instanceof DynamicObject) {
            return PlatformUtils.isDiffDynamicObject((DynamicObject)oldValue, (DynamicObject)newValue);
        }
        if (oldValue instanceof Boolean && newValue instanceof Boolean) {
            return PlatformUtils.isDiffBoolean((Boolean)oldValue, (Boolean)newValue);
        }
        if (oldValue instanceof Date && newValue instanceof Date) {
            return PlatformUtils.isDiffDate((Date)oldValue, (Date)newValue);
        }
        if (oldValue instanceof String && newValue instanceof String) {
            return PlatformUtils.isDiffString((String)oldValue, (String)newValue);
        }
        if (oldValue instanceof Integer && newValue instanceof Integer) {
            return ((Integer)oldValue).equals(newValue);
        }
        return !oldValue.equals(newValue);
    }

    public static int getMaxOperationNo(Long routeId, String processSeq) {
        if (routeId == null || routeId.equals(0L)) {
            return 0;
        }
        QFilter qfilter = new QFilter("id", "=", (Object)routeId);
        qfilter.and(new QFilter("processentry.parent", "=", (Object)processSeq));
        String selectProperties = "id,processentry.parent parent,processentry.operationno operationno";
        int maxOp = 0;
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)(EcoCommonHelper.class.getName() + "_getMaxOperationNo"), (String)"pdm_route", (String)selectProperties, (QFilter[])new QFilter[]{qfilter}, (String)"");){
            while (ds.hasNext()) {
                int op = ds.next().getInteger("operationno");
                if (op <= maxOp) continue;
                maxOp = op;
            }
        }
        return maxOp;
    }
}

