/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.common.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.pdm.common.objectbeen.StepEntryObj;
import kd.mmc.pdm.common.util.ProMaterDTBUtil;

public class PDMProMaterDTHelper {
    public static final String INVALIDDATE = "invaliddate";
    private static final String BOM = "bom";
    private static final String PDM_BOM = "pdm_mftbom";
    private static final String MAIN_PRODUCT = "material";
    private static final String PRODUCT = "product";
    private static final String PROCESSROUTE = "processroute";
    private static final String WORKPROENTRY = "workprocedure";
    private static final String MATERIAL = "material";
    private static final String MASTERID = "masterid";
    private static final String QTYENTRY = "qtyentry";
    public static final String EFFECTDATE = "effectdate";
    public static final String ID = "id";

    public static DynamicObject queryBOMData(Object bomPk) {
        Objects.requireNonNull(bomPk, "BOM PK is null");
        return BusinessDataServiceHelper.loadSingle((Object)bomPk, (String)PDM_BOM, (String)PDMProMaterDTHelper.getSelectBOMField());
    }

    public static void setOtherFieldValueByBOM(IDataModel model, IFormView view, DynamicObject bomDyObj) {
        DynamicObject processRoute;
        DynamicObject version;
        DynamicObject product = bomDyObj.getDynamicObject("material");
        DynamicObject pro = (DynamicObject)model.getValue(PRODUCT);
        if (Objects.isNull(pro) || !StringUtils.equals((CharSequence)pro.getPkValue().toString(), (CharSequence)product.getPkValue().toString())) {
            model.setValue(PRODUCT, product.getPkValue());
        }
        view.setEnable(Boolean.FALSE, new String[]{PRODUCT});
        Object material = product.get(MASTERID);
        Object materId = product.getPkValue();
        if (material instanceof DynamicObject) {
            materId = ((DynamicObject)material).getPkValue();
        }
        if ((version = bomDyObj.getDynamicObject("version")) != null) {
            version = BusinessDataServiceHelper.loadSingle((Object)version.getPkValue(), (String)"bd_bomversion_new");
            model.beginInit();
            model.setValue(EFFECTDATE, (Object)version.getDate(EFFECTDATE));
            model.setValue(INVALIDDATE, (Object)version.getDate(INVALIDDATE));
            model.endInit();
        }
        Set<Long> proIds = ProMaterDTBUtil.getProIds(Long.valueOf(materId.toString()));
        HashSet<Long> ids = new HashSet<Long>(proIds.size());
        ids.addAll(proIds);
        Object effectDate = model.getValue(EFFECTDATE);
        Object invalidDate = model.getValue(INVALIDDATE);
        if (effectDate instanceof Date && invalidDate instanceof Date) {
            Date efDate = (Date)effectDate;
            Date inDate = (Date)invalidDate;
            Set<Long> betweenDatePRouteIds = ProMaterDTBUtil.getBetweenDatePRouteIds(efDate, inDate);
            ids.retainAll(betweenDatePRouteIds);
        }
        if (Objects.nonNull(processRoute = (DynamicObject)model.getValue(PROCESSROUTE)) && !ids.contains(processRoute.getLong(ID))) {
            model.setValue(PROCESSROUTE, null);
            if (model.getEntryEntity(WORKPROENTRY) != null) {
                model.deleteEntryData(WORKPROENTRY);
            }
        }
    }

    public static List<StepEntryObj> queryStepEntry(DynamicObject row, BigDecimal mole, BigDecimal deno) {
        ArrayList<StepEntryObj> objLs = new ArrayList<StepEntryObj>(16);
        if (Objects.nonNull(row)) {
            Long parentEntryId = row.getLong(ID);
            QFilter[] qf = new QFilter[]{new QFilter("entry.id", "=", (Object)parentEntryId)};
            StringBuilder sel = new StringBuilder();
            sel.append("entry.qtyentry.qtyentrybatchstartqty qtyentrybatchstartqty");
            sel.append(",entry.qtyentry.id qtyentryid");
            sel.append(",entry.qtyentry.qtyentrybatchendqty qtyentrybatchendqty");
            sel.append(",entry.qtyentry.qtyentryisstepfix qtyentryisstepfix");
            sel.append(",entry.qtyentry.qtyentryqtynumerator qtyentryqtynumerator");
            sel.append(",entry.qtyentry.qtyentryqtydenominator qtyentryqtydenominator");
            sel.append(",entry.qtyentry.qtyentryfixscrap qtyentryfixscrap");
            sel.append(",entry.qtyentry.qtyentryscraprate qtyentryscraprate");
            DynamicObjectCollection qtyEntry = QueryServiceHelper.query((String)PDM_BOM, (String)sel.toString(), (QFilter[])qf);
            for (DynamicObject entry : qtyEntry) {
                StepEntryObj stepEntry = new StepEntryObj();
                stepEntry.setId(entry.getLong("qtyentryid"));
                stepEntry.setParentEntryId(parentEntryId);
                stepEntry.setBatchStartQty(entry.getBigDecimal("qtyentrybatchstartqty"));
                stepEntry.setBatchEndQty(entry.getBigDecimal("qtyentrybatchendqty"));
                stepEntry.setStepFix(entry.getBoolean("qtyentryisstepfix"));
                BigDecimal qtyentryqtynumerator = BigDecimal.ZERO;
                if (entry.getBigDecimal("qtyentryqtynumerator") != null) {
                    qtyentryqtynumerator = entry.getBigDecimal("qtyentryqtynumerator");
                }
                BigDecimal qtyMole = mole.multiply(qtyentryqtynumerator);
                stepEntry.setQtyMole(qtyMole);
                BigDecimal qtyentryqtydenominator = BigDecimal.ZERO;
                if (entry.getBigDecimal("qtyentryqtydenominator") != null) {
                    qtyentryqtydenominator = entry.getBigDecimal("qtyentryqtydenominator");
                }
                stepEntry.setQtyDeno(deno.multiply(qtyentryqtydenominator));
                stepEntry.setMole(entry.getBigDecimal("qtyentryqtynumerator"));
                stepEntry.setDeno(entry.getBigDecimal("qtyentryqtydenominator"));
                stepEntry.setFixScrap(entry.getBigDecimal("qtyentryfixscrap"));
                stepEntry.setScrapRate(entry.getBigDecimal("qtyentryscraprate"));
                objLs.add(stepEntry);
            }
        }
        return objLs;
    }

    public static List<StepEntryObj> queryChildRowStepEntry(DynamicObject row, BigDecimal mole, BigDecimal deno) {
        ArrayList<StepEntryObj> objLs = new ArrayList<StepEntryObj>(16);
        if (Objects.nonNull(row)) {
            Long parentEntryId = row.getLong(ID);
            DynamicObjectCollection qtyEntry = row.getDynamicObjectCollection(QTYENTRY);
            for (DynamicObject entry : qtyEntry) {
                StepEntryObj stepEntry = new StepEntryObj();
                stepEntry.setId(entry.getLong(ID));
                stepEntry.setParentEntryId(parentEntryId);
                stepEntry.setBatchStartQty(entry.getBigDecimal("qtyentrybatchstartqty"));
                stepEntry.setBatchEndQty(entry.getBigDecimal("qtyentrybatchendqty"));
                stepEntry.setStepFix(entry.getBoolean("qtyentryisstepfix"));
                BigDecimal qtyMole = mole.divide(deno, 10, RoundingMode.HALF_UP).multiply(entry.getBigDecimal("qtyentryqtynumerator"));
                stepEntry.setQtyMole(qtyMole);
                stepEntry.setQtyDeno(entry.getBigDecimal("qtyentryqtydenominator"));
                stepEntry.setMole(entry.getBigDecimal("qtyentryqtynumerator"));
                stepEntry.setDeno(entry.getBigDecimal("qtyentryqtydenominator"));
                stepEntry.setFixScrap(entry.getBigDecimal("qtyentryfixscrap"));
                stepEntry.setScrapRate(entry.getBigDecimal("qtyentryscraprate"));
                objLs.add(stepEntry);
            }
        }
        return objLs;
    }

    public static String getSelectBOMField() {
        StringBuilder sb = new StringBuilder();
        sb.append(ID);
        sb.append(",number");
        sb.append(",type");
        sb.append(",group");
        sb.append(",createorg");
        sb.append(",status");
        sb.append(",enable");
        sb.append(",version");
        sb.append(",version.effectdate");
        sb.append(",version.invaliddate");
        sb.append(",replaceno");
        sb.append(",entry");
        sb.append(",entry.qtyentry");
        sb.append(",entry.dateentry");
        sb.append(",material.masterid");
        sb.append(",material.materialattr");
        sb.append(",entry.entrymaterial");
        sb.append(",entry.entryvaliddate");
        sb.append(",entry.entryinvaliddate");
        sb.append(",entry.entrymaterialattr");
        sb.append(",entry.entryunit");
        sb.append(",entry.entryversion");
        sb.append(",entry.entryqtytype");
        sb.append(",entry.entryqtynumerator");
        sb.append(",entry.entryqtydenominator");
        sb.append(",entry.entryqty");
        sb.append(",entry.entryfixscrap");
        sb.append(",entry.entryscraprate");
        sb.append(",entry.entryremark");
        sb.append(",entry.entryauxproperty");
        sb.append(",entry.entryisjumplevel");
        sb.append(",entry.entryisreplace");
        sb.append(",entry.entryreplaceplan");
        return sb.toString();
    }
}

