/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.common.util;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;

public class ChangeDataUtil {
    public static boolean isRealChanged(ChangeData changeSet) {
        boolean isRealChanged = true;
        if (StringUtils.isBlank((Object)changeSet)) {
            return false;
        }
        Object oldObject = changeSet.getOldValue();
        Object newObject = changeSet.getNewValue();
        if (oldObject != null && newObject != null && oldObject.getClass().toString().equals(newObject.getClass().toString())) {
            isRealChanged = ChangeDataUtil.isRealChanged(oldObject, newObject);
        }
        if (isRealChanged && StringUtils.equalsIgnoreCase((CharSequence)String.valueOf(oldObject), (CharSequence)String.valueOf(newObject))) {
            isRealChanged = false;
        }
        return isRealChanged;
    }

    private static boolean isRealChanged(Object oldObject, Object newObject) {
        boolean isRealChanged = true;
        if (newObject instanceof DynamicObject) {
            if (((DynamicObject)newObject).getPkValue().equals(((DynamicObject)oldObject).getPkValue())) {
                isRealChanged = false;
            }
        } else if (newObject instanceof BigDecimal && ((BigDecimal)newObject).compareTo((BigDecimal)oldObject) == 0) {
            isRealChanged = false;
        }
        return isRealChanged;
    }

    public static DynamicObject getDataEntity(ChangeData changeSet) {
        DynamicObject dataEntity = null;
        if (StringUtils.isBlank((Object)changeSet)) {
            return dataEntity;
        }
        return changeSet.getDataEntity();
    }

    public static Object getOldValue(ChangeData changeSet) {
        Object oldValue = null;
        if (StringUtils.isBlank((Object)changeSet)) {
            return oldValue;
        }
        oldValue = changeSet.getOldValue();
        return oldValue;
    }

    public static Object getNewValue(ChangeData changeSet) {
        Object newValue = null;
        if (StringUtils.isBlank((Object)changeSet)) {
            return newValue;
        }
        newValue = changeSet.getNewValue();
        return newValue;
    }
}

