/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.common.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bd.sbd.business.pdm.service.MFTBomValidateBusiness;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.mmc.pdm.common.enums.MFTBOMEntryQtyTypeEnum;
import kd.mmc.pdm.common.enums.MaterialAttrEnum;
import kd.mmc.pdm.common.util.MMCUtils;

public class CheckBOMUtils {
    private static StringBuffer errInfo = new StringBuffer();
    private static final String MASTERID = "masterid";
    private static final String NUMBER = "number";
    private static final String CHANGETYPE = "changetype";
    private static final String NEW_ENTRYMATERIAL = "new_entrymaterial";
    private static final String NEW_ENTRYMATERIALID = "new_entrymaterialid";
    private static final String NEW_ENTRYVERSION = "new_entryversion";
    private static final String NEW_ENTRYAUXPROPERTY = "new_entryauxproperty";
    private static final String CONFIG_CODE = "entryconfiguredcode";
    private static final String NEW_CONFIG_CODE = "new_entryconfiguredcode";

    public String getErrInfo() {
        return errInfo.toString();
    }

    public static List<Long> getOrgRanges(String entityType, String ctrlStrategy, Long parentId) {
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)entityType);
        Long viewId = 0L;
        viewId = ctrlView == null ? Long.valueOf(16L) : MMCUtils.getDynamicObjectPK(ctrlView);
        if (StringUtils.equalsIgnoreCase((CharSequence)ctrlStrategy, (CharSequence)"5")) {
            return OrgUnitServiceHelper.getAllOrgByViewId((long)viewId, (boolean)false);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)ctrlStrategy, (CharSequence)"6")) {
            ArrayList<Long> useorgList = new ArrayList<Long>();
            useorgList.add(parentId);
            return OrgUnitServiceHelper.getAllSubordinateOrgs((Long)viewId, useorgList, (boolean)true);
        }
        return new ArrayList<Long>();
    }

    public static String checkEntry(DynamicObject entry, boolean isVersion, int row, DynamicObject changeOrg) {
        StringBuilder entryErrMsg = new StringBuilder();
        if (entry == null) {
            entryErrMsg.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7ec4\u4ef6\u4fe1\u606f\u3002", (String)"CheckBOMUtils_1", (String)"mmc-pdm-common", (Object[])new Object[0]));
            return entryErrMsg.toString();
        }
        boolean useNewField = CheckBOMUtils.checkUseNewField(entry);
        String materialField = "entrymaterialid";
        String versionField = "entryversion";
        String newFlagStr = "";
        if (useNewField) {
            materialField = NEW_ENTRYMATERIALID;
            versionField = NEW_ENTRYVERSION;
            newFlagStr = ResManager.loadKDString((String)"\u65b0-", (String)"CheckBOMUtils_2", (String)"mmc-pdm-common", (Object[])new Object[0]);
        }
        String entryType = MMCUtils.getDynamicObjectStringData(entry, "entrytype");
        DynamicObject entrymaterial = MMCUtils.getDynamicObjectDynamicObjectData(entry, materialField);
        DynamicObject entryFeatureType = MMCUtils.getDynamicObjectDynamicObjectData(entry, "featuretype");
        if (StringUtils.equals((CharSequence)entryType, (CharSequence)"A") && entrymaterial == null) {
            entryErrMsg.append(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u5206\u5f55\u7b2c\u201c%1$s\u201d\u884c\uff0c\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u7ec4\u4ef6\u7f16\u7801\u201d\u3002", (String)"CheckBOMUtils_3", (String)"mmc-pdm-common", (Object[])new Object[0]), row));
            return entryErrMsg.toString();
        }
        if (StringUtils.equals((CharSequence)entryType, (CharSequence)"B") && entryFeatureType == null) {
            entryErrMsg.append(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u5206\u5f55\u7b2c\u201c%1$s\u201d\u884c\uff0c\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u7279\u5f81\u7c7b\u201d\u3002", (String)"CheckBOMUtils_4", (String)"mmc-pdm-common", (Object[])new Object[0]), row));
            return entryErrMsg.toString();
        }
        DynamicObject entrymaterialObj = entrymaterial;
        Boolean isenablematerialversion = MMCUtils.getDynamicObjectBooleanData(entrymaterialObj, "isenablematerialversion");
        String entrymaterialattr = MMCUtils.getDynamicObjectStringData(entry, "entrymaterialattr");
        String entryQtyType = MMCUtils.getDynamicObjectStringData(entry, "entryqtytype");
        boolean entryisjumplevel = true;
        if (MaterialAttrEnum.PURCHASEDPART.getValue().equalsIgnoreCase(entrymaterialattr)) {
            entryisjumplevel = false;
            entry.set("entryisjumplevel", (Object)entryisjumplevel);
        } else if (MaterialAttrEnum.PHANTOMPART.getValue().equalsIgnoreCase(entrymaterialattr)) {
            entryisjumplevel = true;
            entry.set("entryisjumplevel", (Object)entryisjumplevel);
            if (StringUtils.equalsIgnoreCase((CharSequence)entryQtyType, (CharSequence)MFTBOMEntryQtyTypeEnum.STEP.getValue())) {
                entryErrMsg.append(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u5206\u5f55\u7b2c\u201c%1$s\u201d\u884c\uff0c\u201c\u7269\u6599\u5c5e\u6027\u201d\u7b49\u4e8e\u201c\u865a\u62df\u201d\u65f6\uff0c\u201c\u7528\u91cf\u7c7b\u578b\u201d\u4e0d\u80fd\u7b49\u4e8e\u201c\u9636\u68af\u201d\u3002", (String)"CheckBOMUtils_5", (String)"mmc-pdm-common", (Object[])new Object[0]), row));
                return entryErrMsg.toString();
            }
        }
        String checkDateMsg = CheckBOMUtils.checkValidDate(entry, row);
        if (!StringUtils.isBlank((CharSequence)checkDateMsg)) {
            entryErrMsg.append(checkDateMsg);
            return entryErrMsg.toString();
        }
        BigDecimal entryqtynumerator = MMCUtils.getDynamicObjectBigDecimalData(entry, "entryqtynumerator");
        if (BigDecimal.ZERO.compareTo(entryqtynumerator) >= 0) {
            entryErrMsg.append(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u5206\u5f55\u7b2c\u201c%1$s\u201d\u884c\uff0c\u7528\u91cf\u5206\u5b50\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"CheckBOMUtils_6", (String)"mmc-pdm-common", (Object[])new Object[0]), row));
            return entryErrMsg.toString();
        }
        String auxpropertyStr = CheckBOMUtils.checkEntryAuxproperty(entry, row, changeOrg);
        if (!StringUtils.isBlank((CharSequence)auxpropertyStr)) {
            entryErrMsg.append(auxpropertyStr);
            return entryErrMsg.toString();
        }
        String jumpStr = CheckBOMUtils.checkJumplevel(entry, row);
        if (!StringUtils.isBlank((CharSequence)jumpStr)) {
            entryErrMsg.append(jumpStr);
            return entryErrMsg.toString();
        }
        String qtyEntryMsg = CheckBOMUtils.qtyEntryValidate(entry, row);
        if (!StringUtils.isBlank((CharSequence)qtyEntryMsg)) {
            entryErrMsg.append(qtyEntryMsg);
            return entryErrMsg.toString();
        }
        boolean workStationVal = CheckBOMUtils.workstationEntryVal(entryErrMsg, entry, row);
        if (!workStationVal) {
            return entryErrMsg.toString();
        }
        DynamicObject entryversion = MMCUtils.getDynamicObjectDynamicObjectData(entry, versionField);
        if (entryversion == null) {
            if (isenablematerialversion.booleanValue()) {
                entryErrMsg.append(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u5206\u5f55\u7b2c\u201c%1$s\u201d\u884c\uff0c\u8bf7\u586b\u5199\u201c%2$s\u201d\u7248\u672c\u53f7\u3002", (String)"CheckBOMUtils_7", (String)"mmc-pdm-common", (Object[])new Object[0]), row, newFlagStr));
                return entryErrMsg.toString();
            }
            if (!MaterialAttrEnum.PURCHASEDPART.getValue().equalsIgnoreCase(entrymaterialattr) && isVersion) {
                entryErrMsg.append(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u5206\u5f55\u7b2c\u201c%1$s\u201d\u884c\uff0c\u201c\u7269\u6599\u5c5e\u6027\u201d\u4e3a\u201c\u81ea\u5236\u201d\u3001\u201c\u59d4\u5916\u201d\u3001\u201c\u865a\u62df\u201d\uff0c\u8bf7\u586b\u5199\u201c%2$s\u201d\u7248\u672c\u53f7\u3002", (String)"CheckBOMUtils_8", (String)"mmc-pdm-common", (Object[])new Object[0]), row, newFlagStr));
                return entryErrMsg.toString();
            }
        }
        DynamicObject entrywarehouse = MMCUtils.getDynamicObjectDynamicObjectData(entry, "entrywarehouse");
        DynamicObject entrylocation = MMCUtils.getDynamicObjectDynamicObjectData(entry, "entrylocation");
        if (entrywarehouse != null) {
            Boolean isopenlocation = MMCUtils.getDynamicObjectBooleanData(entrywarehouse = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_warehouse", (String)"id,number,isopenlocation,entryentity.id,entryentity.location", (QFilter[])new QFilter[]{new QFilter("id", "=", entrywarehouse.getPkValue())}), "isopenlocation");
            if (!isopenlocation.booleanValue() || entrylocation != null) {
                if (isopenlocation.booleanValue()) {
                    DynamicObjectCollection entryentitys = entrywarehouse.getDynamicObjectCollection("entryentity");
                    boolean istrue = false;
                    for (int j = 0; j < entryentitys.size(); ++j) {
                        DynamicObject entryentity = (DynamicObject)entryentitys.get(j);
                        DynamicObject location = MMCUtils.getDynamicObjectDynamicObjectData(entryentity, "location");
                        if (!entrylocation.getPkValue().equals(location.getPkValue())) continue;
                        istrue = true;
                        break;
                    }
                    if (!istrue) {
                        entryErrMsg.append(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u5206\u5f55\u7b2c\u201c%1$s\u201d\u884c\uff0c\u9ed8\u8ba4\u53d1\u6599\u4ed3\u5e93\u201c%2$s\u201d\uff0c\u4e0d\u5b58\u5728\u4ed3\u4f4d\u201c%3$s\u201d\u3002", (String)"CheckBOMUtils_9", (String)"mmc-pdm-common", (Object[])new Object[0]), row, MMCUtils.getDynamicObjectStringData(entrywarehouse, "name"), MMCUtils.getDynamicObjectStringData(entrylocation, "name")));
                        return entryErrMsg.toString();
                    }
                } else if (entrylocation != null) {
                    entryErrMsg.append(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u5206\u5f55\u7b2c\u201c%1$s\u201d\u884c\uff0c\u9ed8\u8ba4\u53d1\u6599\u4ed3\u5e93\u672a\u542f\u7528\u4ed3\u4f4d\uff0c\u4e0d\u80fd\u586b\u5199\u4ed3\u4f4d\u3002", (String)"CheckBOMUtils_10", (String)"mmc-pdm-common", (Object[])new Object[0]), row));
                    return entryErrMsg.toString();
                }
            }
        } else if (entrylocation != null) {
            entryErrMsg.append(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u5206\u5f55\u7b2c\u201c%1$s\u201d\u884c\uff0c\u672a\u586b\u5199\u9ed8\u8ba4\u53d1\u6599\u4ed3\u5e93\uff0c\u4e0d\u80fd\u586b\u5199\u4ed3\u4f4d\u3002", (String)"CheckBOMUtils_11", (String)"mmc-pdm-common", (Object[])new Object[0]), row));
            return entryErrMsg.toString();
        }
        DynamicObject entryoutwarehouse = MMCUtils.getDynamicObjectDynamicObjectData(entry, "entryoutwarehouse");
        DynamicObject entryoutlocation = MMCUtils.getDynamicObjectDynamicObjectData(entry, "entryoutlocation");
        if (entryoutwarehouse != null) {
            QFilter qFilter = new QFilter("id", "=", entryoutwarehouse.getPkValue());
            entryoutwarehouse = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_warehouse", (String)"id,number,isopenlocation,entryentity.id,entryentity.location", (QFilter[])new QFilter[]{qFilter});
            Boolean isopenlocation = MMCUtils.getDynamicObjectBooleanData(entryoutwarehouse, "isopenlocation");
            if (!isopenlocation.booleanValue() || entryoutlocation != null) {
                if (isopenlocation.booleanValue()) {
                    DynamicObjectCollection entryentitys = entryoutwarehouse.getDynamicObjectCollection("entryentity");
                    Boolean istrue = Boolean.FALSE;
                    for (int j = 0; j < entryentitys.size(); ++j) {
                        DynamicObject entryentity = (DynamicObject)entryentitys.get(j);
                        DynamicObject location = MMCUtils.getDynamicObjectDynamicObjectData(entryentity, "location");
                        if (!entryoutlocation.getPkValue().equals(location.getPkValue())) continue;
                        istrue = Boolean.TRUE;
                        break;
                    }
                    if (!istrue.booleanValue()) {
                        entryErrMsg.append(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u5206\u5f55\u7b2c\u201c%1$s\u201d\u884c\uff0c\u8c03\u51fa\u4ed3\u5e93\u201c%2$s\u201d\uff0c\u4e0d\u5b58\u5728\u4ed3\u4f4d\u201c%3$s\u201d\u3002", (String)"CheckBOMUtils_12", (String)"mmc-pdm-common", (Object[])new Object[0]), row, MMCUtils.getDynamicObjectStringData(entryoutwarehouse, "name"), MMCUtils.getDynamicObjectStringData(entryoutlocation, "name")));
                        return entryErrMsg.toString();
                    }
                } else if (entryoutlocation != null) {
                    entryErrMsg.append(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u5206\u5f55\u7b2c\u201c%1$s\u201d\u884c\uff0c\u8c03\u51fa\u4ed3\u5e93\u672a\u542f\u7528\u4ed3\u4f4d\uff0c\u4e0d\u80fd\u586b\u5199\u4ed3\u4f4d\u3002", (String)"CheckBOMUtils_13", (String)"mmc-pdm-common", (Object[])new Object[0]), row));
                    return entryErrMsg.toString();
                }
            }
        } else if (entryoutlocation != null) {
            entryErrMsg.append(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u5206\u5f55\u7b2c\u201c%1$s\u201d\u884c\uff0c\u672a\u586b\u5199\u8c03\u51fa\u4ed3\u5e93\uff0c\u4e0d\u80fd\u586b\u5199\u4ed3\u4f4d\u3002", (String)"CheckBOMUtils_14", (String)"mmc-pdm-common", (Object[])new Object[0]), row));
            return entryErrMsg.toString();
        }
        DynamicObject entryreplaceplan = MMCUtils.getDynamicObjectDynamicObjectData(entry, "entryreplaceplan");
        Boolean entryisreplaceplanmm = MMCUtils.getDynamicObjectBooleanData(entry, "entryisreplaceplanmm");
        if (entryreplaceplan != null) {
            boolean bl = false;
        }
        return entryErrMsg.toString();
    }

    public static boolean checkBomTypeMatchMaterial(DynamicObject entrymaterialObj, DynamicObject bomTypeDO, int row, StringBuilder entryErrMsg) {
        boolean checkFlag = true;
        String purpose = "";
        if (bomTypeDO != null) {
            purpose = bomTypeDO.getString("purpose");
        }
        if (entrymaterialObj != null && entryErrMsg != null) {
            String confType = MMCUtils.getDynamicObjectStringData(entrymaterialObj, "configproperties");
            String materialNumber = MMCUtils.getDynamicObjectStringData(entrymaterialObj, NUMBER);
            if (StringUtils.equals((CharSequence)"A", (CharSequence)purpose) && StringUtils.equals((CharSequence)"3", (CharSequence)confType)) {
                entryErrMsg.append(String.format(ResManager.loadKDString((String)"\u5236\u9020BOM\u4e0d\u80fd\u65b0\u589e\u7279\u5f81\u4ef6%1$s\u3002", (String)"CheckBOMUtils_15", (String)"mmc-pdm-common", (Object[])new Object[0]), materialNumber));
                checkFlag = false;
            }
        }
        return checkFlag;
    }

    private static boolean workstationEntryVal(StringBuilder entryErrMsg, DynamicObject entry, int rowIndex) {
        boolean workStationVal = true;
        DynamicObjectCollection workEntryCol = entry.getDynamicObjectCollection("workstationentry");
        if (workEntryCol == null) {
            return workStationVal;
        }
        BigDecimal entryQty = entry.getBigDecimal("entryqty");
        BigDecimal entryQtyDenomtnator = entry.getBigDecimal("entryqtydenominator");
        BigDecimal qtyAcount = entryQty;
        if (entryQtyDenomtnator != BigDecimal.ZERO) {
            int scale = entryQtyDenomtnator.scale();
            qtyAcount = entryQty.divide(entryQtyDenomtnator, scale, 5);
        }
        HashMap<String, BigDecimal> qytMap = new HashMap<String, BigDecimal>(100);
        for (int i = 0; i < workEntryCol.size(); ++i) {
            DynamicObject workEntry = (DynamicObject)workEntryCol.get(i);
            DynamicObject workcenter = workEntry.getDynamicObject("workcenter");
            if (workcenter == null) {
                entryErrMsg.append(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u5206\u5f55\u7b2c%1$s\u884c\uff0c\u8bf7\u586b\u5199\u5de5\u4f5c\u4e2d\u5fc3\u3002", (String)"CheckBOMUtils_16", (String)"mmc-pdm-common", (Object[])new Object[0]), rowIndex + 1));
                return false;
            }
            BigDecimal wokrEntryQyt = workEntry.getBigDecimal("workentryqty");
            String workcenterId = workcenter.getPkValue().toString();
            String workcenterNum = workcenter.getString(NUMBER);
            BigDecimal totolCount = (BigDecimal)qytMap.get(workcenterId);
            if (totolCount == null) {
                if (wokrEntryQyt.compareTo(qtyAcount) > 0) {
                    entryErrMsg.append(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u5206\u5f55\u7b2c%1$s\u884c\uff0c\u5de5\u4f5c\u4e2d\u5fc3\u201c%2$s\u201d\u6570\u91cf\u603b\u548c\u5e94\u5c0f\u4e8e\u7ec4\u4ef6\u6570\u91cf\u3002", (String)"CheckBOMUtils_17", (String)"mmc-pdm-common", (Object[])new Object[0]), rowIndex + 1, workcenterNum));
                    return false;
                }
                qytMap.put(workcenterId, wokrEntryQyt);
                continue;
            }
            BigDecimal count = totolCount.add(wokrEntryQyt);
            if (count.compareTo(qtyAcount) > 0) {
                entryErrMsg.append(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u5206\u5f55\u7b2c%1$s\u884c\uff0c\u5de5\u4f5c\u4e2d\u5fc3\u201c%2$s\u201d\u6570\u91cf\u603b\u548c\u5e94\u5c0f\u4e8e\u7ec4\u4ef6\u6570\u91cf\u3002", (String)"CheckBOMUtils_17", (String)"mmc-pdm-common", (Object[])new Object[0]), rowIndex + 1, workcenterNum));
                return false;
            }
            qytMap.put(workcenterId, count);
        }
        return workStationVal;
    }

    private static String checkJumplevel(DynamicObject entry, int row) {
        StringBuilder entryErrMsg = new StringBuilder();
        if (entry == null) {
            return entryErrMsg.toString();
        }
        String qtyType = MMCUtils.getDynamicObjectStringData(entry, "entryqtytype");
        boolean jumpLevelFlag = MMCUtils.getDynamicObjectBooleanData(entry, "entryisjumplevel");
        if (jumpLevelFlag && "C".equals(qtyType)) {
            entryErrMsg.append(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u5206\u5f55\u7b2c%s\u884c\u201c\u7528\u91cf\u7c7b\u578b\u201d\u4e3a\u201c\u9636\u68af\u201d\uff0c\u4e0d\u80fd\u8bbe\u7f6e\u4e3a\u8df3\u5c42\u3002", (String)"CheckBOMUtils_18", (String)"mmc-pdm-common", (Object[])new Object[0]), row));
        }
        return entryErrMsg.toString();
    }

    public static String checkValidDate(DynamicObject entry, int row) {
        StringBuilder entryErrMsg = new StringBuilder();
        if (entry == null) {
            return entryErrMsg.toString();
        }
        Date entryValidDate = MMCUtils.getDynamicObjectDateData(entry, "entryvaliddate");
        Date entryInvalidDate = MMCUtils.getDynamicObjectDateData(entry, "entryinvaliddate");
        if (entryValidDate == null) {
            entryErrMsg.append(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u5206\u5f55\u7b2c%s\u884c\u201c\u751f\u6548\u65e5\u671f\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CheckBOMUtils_19", (String)"mmc-pdm-common", (Object[])new Object[0]), row));
        } else if (entryInvalidDate == null) {
            entryErrMsg.append(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u5206\u5f55\u7b2c%s\u884c\u201c\u5931\u6548\u65e5\u671f\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CheckBOMUtils_20", (String)"mmc-pdm-common", (Object[])new Object[0]), row));
        } else if (entryInvalidDate.before(entryValidDate)) {
            entryErrMsg.append(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u5206\u5f55\u7b2c%s\u884c\u201c\u5931\u6548\u65e5\u671f\u201d\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u201c\u751f\u6548\u65e5\u671f\u201d\u3002", (String)"CheckBOMUtils_21", (String)"mmc-pdm-common", (Object[])new Object[0]), row));
        }
        return entryErrMsg.toString();
    }

    public static boolean checkUseNewField(DynamicObject entry) {
        String type;
        if (entry == null) {
            return false;
        }
        DataEntityPropertyCollection properties = entry.getDataEntityType().getProperties();
        IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)CHANGETYPE);
        return property != null && StringUtils.equals((CharSequence)(type = MMCUtils.getDynamicObjectStringData(entry, CHANGETYPE)), (CharSequence)"C");
    }

    public static String qtyEntryValidate(DynamicObject entry, int i) {
        StringBuilder qtyEntryErrMsg = new StringBuilder();
        String qtyType = MMCUtils.getDynamicObjectStringData(entry, "entryqtytype");
        DynamicObjectCollection qtyentrys = entry.getDynamicObjectCollection("qtyentry");
        if (StringUtils.equals((CharSequence)qtyType, (CharSequence)"C")) {
            if (qtyentrys == null || qtyentrys.isEmpty()) {
                qtyEntryErrMsg.append(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u5206\u5f55\u7b2c%1$s\u884c\uff0c\u7528\u91cf\u7c7b\u578b\u4e3a\u9636\u68af\u7528\u91cf\uff0c\u8bf7\u586b\u5199\u9636\u68af\u7528\u91cf\u3002", (String)"CheckBOMUtils_22", (String)"mmc-pdm-common", (Object[])new Object[0]), i + 1));
                return qtyEntryErrMsg.toString();
            }
            for (int j = 0; j < qtyentrys.size(); ++j) {
                DynamicObject qtyentry = (DynamicObject)qtyentrys.get(j);
                BigDecimal qtyentryqtynumerator = MMCUtils.getDynamicObjectBigDecimalData(qtyentry, "qtyentryqtynumerator");
                BigDecimal qtyentryqtydenominator = MMCUtils.getDynamicObjectBigDecimalData(qtyentry, "qtyentryqtydenominator");
                if (qtyentryqtynumerator == null || BigDecimal.ZERO.compareTo(qtyentryqtynumerator) >= 0) {
                    qtyEntryErrMsg.append(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u5206\u5f55\u7b2c%1$s\u884c\uff0c\u201c\u7528\u91cf\uff1a\u5206\u5b50\u201d\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"CheckBOMUtils_23", (String)"mmc-pdm-common", (Object[])new Object[0]), i + 1));
                    return qtyEntryErrMsg.toString();
                }
                if (qtyentryqtydenominator != null && BigDecimal.ZERO.compareTo(qtyentryqtydenominator) < 0) continue;
                qtyEntryErrMsg.append(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u5206\u5f55\u7b2c%1$s\u884c\uff0c\u5bf9\u5e94\u9636\u68af\u7528\u91cf\u7b2c%2$s\u884c\uff0c\u201c\u7528\u91cf\uff1a\u5206\u6bcd\u201d\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"CheckBOMUtils_24", (String)"mmc-pdm-common", (Object[])new Object[0]), i + 1, j + 1));
                return qtyEntryErrMsg.toString();
            }
        } else if (qtyentrys != null && !qtyentrys.isEmpty()) {
            qtyentrys.clear();
        }
        return null;
    }

    public static String checkEntryAuxproperty(DynamicObject entry, int rowIndex, DynamicObject changeOrg) {
        StringBuilder msgStr = new StringBuilder();
        if (entry == null) {
            return msgStr.toString();
        }
        boolean useNewField = CheckBOMUtils.checkUseNewField(entry);
        String materialField = "entrymaterialid";
        String auxField = "entryauxproperty";
        String newFlagStr = "";
        if (useNewField) {
            materialField = NEW_ENTRYMATERIALID;
            auxField = NEW_ENTRYAUXPROPERTY;
            newFlagStr = ResManager.loadKDString((String)"\u65b0-", (String)"CheckBOMUtils_2", (String)"mmc-pdm-common", (Object[])new Object[0]);
        }
        DynamicObject entrymaterial = MMCUtils.getDynamicObjectDynamicObjectData(entry, materialField);
        boolean isuseauxpty = CheckBOMUtils.isAuxpMustInput(entrymaterial, null, changeOrg);
        DynamicObject entryauxproperty = MMCUtils.getDynamicObjectDynamicObjectData(entry, auxField);
        if (isuseauxpty && entryauxproperty == null) {
            String materilNumber = MMCUtils.getDynamicObjectStringData(entrymaterial, NUMBER);
            String msg = String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u5206\u5f55\u7b2c\u201c%1$s\u201d\u884c\uff0c\u7ec4\u4ef6\u7f16\u7801\u201c%2$s\u201d\u542f\u7528\u4e86\u8f85\u52a9\u5c5e\u6027\uff0c\u8bf7\u586b\u5199\u201c%3$s\u201d\u8f85\u52a9\u5c5e\u6027\u3002", (String)"CheckBOMUtils_25", (String)"mmc-pdm-common", (Object[])new Object[0]), rowIndex, newFlagStr, materilNumber, newFlagStr);
            msgStr.append(msg);
        }
        return msgStr.toString();
    }

    public static boolean isAuxpMustInput(DynamicObject matInfoObj, DynamicObject typeObj, DynamicObject createOrgObj) {
        return MFTBomValidateBusiness.isAuxpMustInput((DynamicObject)matInfoObj, null, (DynamicObject)createOrgObj);
    }

    public static String checkEntryMaterial(DynamicObject entry, int rowIndex) {
        DynamicObject replaceMateril;
        StringBuilder msgStr = new StringBuilder();
        if (entry == null) {
            return msgStr.toString();
        }
        boolean useNewField = CheckBOMUtils.checkUseNewField(entry);
        String entryType = MMCUtils.getDynamicObjectStringData(entry, "entrytype");
        DynamicObject entryMateril = MMCUtils.getDynamicObjectDynamicObjectData(entry, "entrymaterialid");
        DynamicObject featureType = MMCUtils.getDynamicObjectDynamicObjectData(entry, "featuretype");
        if (StringUtils.equals((CharSequence)"A", (CharSequence)entryType) && entryMateril == null) {
            msgStr.append(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u5206\u5f55\u7b2c%s\u884c\uff0c\u7ec4\u4ef6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CheckBOMUtils_26", (String)"mmc-pdm-common", (Object[])new Object[0]), rowIndex));
            return msgStr.toString();
        }
        if (StringUtils.equals((CharSequence)"B", (CharSequence)entryType) && featureType == null) {
            msgStr.append(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u5206\u5f55\u7b2c%s\u884c\uff0c\u7279\u5f81\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CheckBOMUtils_27", (String)"mmc-pdm-common", (Object[])new Object[0]), rowIndex));
            return msgStr.toString();
        }
        if (useNewField && (replaceMateril = MMCUtils.getDynamicObjectDynamicObjectData(entry, NEW_ENTRYMATERIALID)) == null) {
            msgStr.append(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u5206\u5f55\u7b2c%s\u884c\uff0c\u65b0\u7ec4\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CheckBOMUtils_28", (String)"mmc-pdm-common", (Object[])new Object[0]), rowIndex));
            return msgStr.toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkMaterialIsAudit(DynamicObject entry, Long changeOrg, String purpose) {
        if (entry == null) {
            return false;
        }
        boolean useNewField = CheckBOMUtils.checkUseNewField(entry);
        String materialField = "entrymaterialid";
        String materialInfoField = "entrymaterial";
        if (useNewField) {
            materialField = NEW_ENTRYMATERIALID;
            materialInfoField = NEW_ENTRYMATERIAL;
        }
        DynamicObject entryMaterialDO = MMCUtils.getDynamicObjectDynamicObjectData(entry, materialField);
        DynamicObject entryMatInfoDO = MMCUtils.getDynamicObjectDynamicObjectData(entry, materialInfoField);
        String entityName = "bd_material";
        if ("B".equals(purpose)) {
            entityName = "bd_material";
        } else {
            entityName = "bd_materialmftinfo";
            if (entryMatInfoDO == null) {
                return false;
            }
        }
        if (entryMaterialDO != null) {
            Long materialPk = MMCUtils.getDynamicObjectPK(entryMaterialDO);
            if (!"B".equals(purpose)) {
                materialPk = MMCUtils.getDynamicObjectPK(entryMatInfoDO);
            }
            QFilter nqfilter = new QFilter("id", "=", (Object)materialPk);
            QFilter enableQFilter = new QFilter("enable", "=", (Object)"1");
            QFilter isecnQFilter = new QFilter("status", "=", (Object)"C");
            QFilter qFilterOrg = BaseDataServiceHelper.getBaseDataFilter((String)entityName, (Long)changeOrg);
            try (DataSet dataSet = null;){
                dataSet = QueryServiceHelper.queryDataSet((String)"kd.mmc.pdm.common.util.CheckBOMUtils", (String)entityName, (String)"id", (QFilter[])new QFilter[]{nqfilter, enableQFilter, isecnQFilter, qFilterOrg}, (String)"id");
                if (dataSet.isEmpty()) {
                    boolean bl = true;
                    return bl;
                }
            }
        }
        return false;
    }

    public static String checkConfCodeMust(DynamicObject changeEntry, int i) {
        StringBuilder msg = new StringBuilder();
        if (changeEntry == null || i < 0) {
            return msg.toString();
        }
        DynamicObject entryMaterialDO = MMCUtils.getDynamicObjectDynamicObjectData(changeEntry, "entrymaterial");
        return msg.toString();
    }

    public boolean checkBomReplaceEntryNewEntry(DynamicObject bomObj, DynamicObjectCollection bomEntryCol, DynamicObject newEntry, String beforeReplaceGroup, Map<Long, String> failedMap) {
        boolean isRepeat = false;
        if (StringUtils.isEmpty((CharSequence)beforeReplaceGroup)) {
            return isRepeat;
        }
        long bomPk = bomObj.getLong("id");
        DynamicObject bomType = bomObj.getDynamicObject("type");
        String purpose = bomType == null ? "" : bomType.getString("purpose");
        String entryMatNumber = newEntry.getDynamicObject("entrymaterialid") != null ? newEntry.getDynamicObject("entrymaterialid").getString(NUMBER) : "";
        isRepeat = this.checkExistEntry(purpose, newEntry, bomEntryCol, beforeReplaceGroup);
        if (isRepeat && failedMap != null) {
            String errorMsg = String.format(ResManager.loadKDString((String)"%1$s\u5931\u8d25\uff0c\u4fdd\u7559\u66ff\u4ee3\u65b9\u6848\u65f6\u66ff\u6362\u540e\u7684\u7ec4\u4ef6[%2$s]\u4e0d\u80fd\u4e0e\u66ff\u4ee3\u6599\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u7ec4\u4ef6\u4e0e\u66ff\u4ee3\u6599\u7684\u8f85\u52a9\u5c5e\u6027\u3001\u7248\u672c\u3001\u914d\u7f6e\u53f7\u662f\u5426\u4e00\u81f4\u3002", (String)"BatchBomToECNBusiness_22", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), this.getOpTypeMsg("C"), entryMatNumber);
            failedMap.put(bomPk, errorMsg);
        }
        return isRepeat;
    }

    public boolean checkExistEntry(String purpose, DynamicObject newEntry, DynamicObjectCollection bomEntryCol, String beforeReplaceGroup) {
        boolean isRepeat = false;
        for (DynamicObject bomEntry : bomEntryCol) {
            boolean entryIsReplace;
            String bomEntryReplaceGroup = bomEntry.getString("entryreplacegroup");
            if (StringUtils.isBlank((CharSequence)bomEntryReplaceGroup) || StringUtils.isNotEmpty((CharSequence)beforeReplaceGroup) && !StringUtils.equals((CharSequence)bomEntryReplaceGroup, (CharSequence)beforeReplaceGroup) || !(entryIsReplace = bomEntry.getBoolean("entryisreplace")) || !this.checkTwoEntryConsistent(purpose, newEntry, bomEntry)) continue;
            isRepeat = true;
            break;
        }
        return isRepeat;
    }

    public boolean checkTwoEntryConsistent(String purpose, DynamicObject newEntry, DynamicObject bomEntry) {
        long changeEntryConigCodetId;
        long changeEntryMatId;
        long entryMatId;
        boolean isRepeat = false;
        if ("B".equals(purpose)) {
            DynamicObject entryMaterialID = newEntry.getDynamicObject("entrymaterialid");
            entryMatId = entryMaterialID == null ? 0L : entryMaterialID.getLong("id");
        } else {
            DynamicObject entryMat = newEntry.getDynamicObject("entrymaterial");
            DynamicObject masterID = entryMat == null ? null : entryMat.getDynamicObject(MASTERID);
            entryMatId = masterID == null ? 0L : masterID.getLong("id");
        }
        DynamicObject entryVer = newEntry.getDynamicObject("entryversion");
        long entryVerId = entryVer == null ? 0L : (Long)entryVer.getPkValue();
        DynamicObject entryAux = newEntry.getDynamicObject("entryauxproperty");
        long entryAuxpty = entryAux == null ? 0L : (Long)entryAux.getPkValue();
        DynamicObject entryConfigCode = newEntry.getDynamicObject(CONFIG_CODE);
        long entryconfigcodeId = entryConfigCode == null ? 0L : (Long)entryConfigCode.getPkValue();
        String bomEntryReplaceGroup = bomEntry.getString("entryreplacegroup");
        boolean entryIsReplace = bomEntry.getBoolean("entryisreplace");
        if ("B".equals(purpose)) {
            DynamicObject changeMaterialID = bomEntry.getDynamicObject("entrymaterialid");
            changeEntryMatId = changeMaterialID == null ? 0L : changeMaterialID.getLong("id");
        } else {
            DynamicObject changeEntryMat = bomEntry.getDynamicObject("entrymaterial");
            DynamicObject masterID = changeEntryMat == null ? null : changeEntryMat.getDynamicObject(MASTERID);
            changeEntryMatId = masterID == null ? 0L : masterID.getLong("id");
        }
        DynamicObject changeEntryVer = bomEntry.getDynamicObject("entryversion");
        long changeEntryVerId = changeEntryVer == null ? 0L : (Long)changeEntryVer.getPkValue();
        DynamicObject changeEntryAux = bomEntry.getDynamicObject("entryauxproperty");
        long changeEntryAuxId = changeEntryAux == null ? 0L : (Long)changeEntryAux.getPkValue();
        DynamicObject changeEntryConigCode = bomEntry.getDynamicObject(CONFIG_CODE);
        long l = changeEntryConigCodetId = changeEntryConigCode == null ? 0L : (Long)changeEntryConigCode.getPkValue();
        if (entryMatId == changeEntryMatId && entryVerId == changeEntryVerId && entryAuxpty == changeEntryAuxId && entryconfigcodeId == changeEntryConigCodetId) {
            isRepeat = true;
        }
        return isRepeat;
    }

    public String getOpTypeMsg(String opKey) {
        String tips = "";
        switch (opKey) {
            case "A": {
                tips = ResManager.loadKDString((String)"\u65b0\u589e\u7ec4\u4ef6", (String)"BatchBomToECNBusiness_14", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
                break;
            }
            case "B": {
                tips = ResManager.loadKDString((String)"\u4fee\u6539\u7ec4\u4ef6", (String)"BatchBomToECNBusiness_15", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
                break;
            }
            case "C": {
                tips = ResManager.loadKDString((String)"\u66ff\u6362\u7ec4\u4ef6", (String)"BatchBomToECNBusiness_16", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
                break;
            }
            case "D": {
                tips = ResManager.loadKDString((String)"\u5931\u6548\u7ec4\u4ef6", (String)"BatchBomToECNBusiness_17", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
                break;
            }
            case "E": {
                tips = ResManager.loadKDString((String)"\u5220\u9664\u7ec4\u4ef6", (String)"BatchBomToECNBusiness_18", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
                break;
            }
            case "F": {
                tips = ResManager.loadKDString((String)"\u65b0\u589e\u9009\u9879\u7c7b", (String)"BatchBomToECNBusiness_19", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
                break;
            }
            case "G": {
                tips = ResManager.loadKDString((String)"\u5220\u9664\u9009\u9879\u7c7b", (String)"BatchBomToECNBusiness_20", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
                break;
            }
            case "H": {
                tips = ResManager.loadKDString((String)"\u4fee\u6539\u9009\u9879\u7c7b", (String)"BatchBomToECNBusiness_21", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
            }
        }
        return tips;
    }
}

