/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.common.util;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mmc.pdm.common.enums.MaterialAttrEnum;
import org.apache.commons.lang.time.DateUtils;

public class CommonUtils {
    private static String[] parsePatterns = new String[]{"yyyy-MM-dd", ResManager.loadKDString((String)"yyyy\u5e74MM\u6708dd\u65e5", (String)"CommonUtils_0", (String)"mmc-pdm-common", (Object[])new Object[0]), "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy/MM/dd", "yyyy/MM/dd HH:mm:ss", "yyyy/MM/dd HH:mm", "yyyyMMdd"};

    public static boolean isNull(Object o) {
        return o == null ? true : (o instanceof String && ((String)o).length() == 0 ? true : (o instanceof StringBuffer && ((StringBuffer)o).length() == 0 ? true : (o instanceof List && ((List)o).size() == 0 ? true : (o instanceof Collection && ((Collection)o).size() == 0 ? true : (o instanceof Object[] && ((Object[])o).length == 0 ? true : o instanceof Map && ((Map)o).size() == 0)))));
    }

    public static boolean isRealChanged(ChangeData changeSet) {
        if (changeSet == null) {
            return false;
        }
        Object oldObject = changeSet.getNewValue();
        Object newObject = changeSet.getOldValue();
        if (oldObject == null && newObject == null) {
            return true;
        }
        if (oldObject == null && newObject != null) {
            return true;
        }
        if (oldObject != null && newObject == null) {
            return true;
        }
        if (oldObject.getClass().toString().equals(newObject.getClass().toString())) {
            if (newObject instanceof DynamicObject) {
                if (!((DynamicObject)newObject).getPkValue().equals(((DynamicObject)oldObject).getPkValue())) {
                    return true;
                }
            } else {
                if (!(newObject instanceof BigDecimal)) {
                    return !oldObject.equals(newObject);
                }
                if (((BigDecimal)newObject).compareTo((BigDecimal)oldObject) != 0) {
                    return true;
                }
            }
        }
        return false;
    }

    public static String getCodeErrorMessage(ErrorCode errorCode) {
        KDException kde = new KDException(errorCode, new Object[0]);
        return kde.getMessage();
    }

    public static String getCodeErrorMessage(ErrorCode errorCode, Object ... args) {
        KDException kde = new KDException(errorCode, args);
        return kde.getMessage();
    }

    public static String serializerDynamicObjectList(List<DynamicObject> list, IDataEntityType dt) {
        if (CommonUtils.isNull(list)) {
            return null;
        }
        DataEntitySerializerOption option = new DataEntitySerializerOption();
        String[] ss = DataEntitySerializer.serializerToListString((IDataEntityType)dt, list, (DataEntitySerializerOption)option);
        return SerializationUtils.toJsonString((Object)ss);
    }

    public static List<DynamicObject> deserializerDynamicObjectList(List<DynamicObject> list, IDataEntityType dt, String s) {
        String[] ss = (String[])SerializationUtils.fromJsonString((String)s, String[].class);
        DataEntitySerializer.deserializerFromListString(list, (IDataEntityType)dt, (String[])ss);
        return list;
    }

    public static List<Long> getIdList(DynamicObjectCollection colls) {
        ArrayList<Long> idList = new ArrayList<Long>();
        for (DynamicObject obj : colls) {
            idList.add(obj.getLong("id"));
        }
        return idList;
    }

    public static List<Long> getBomIds(List<QFilter> filters) {
        String string = "material.masterid,material.materialattr,id,number,entry,entry.entrymaterial,entry.entrymaterial.materialattr,entry.entrymaterialattr,entry.entryunit,entry.entryversion,entryqtytype,entryqtynumerator,entryqtydenominator,entryqty,entryfixscrap,entryscraprate,entryremark,entryversion,entryauxproperty,entry.dateentry,dateentry.dateentryvaliddate,dateentry.dateentryinvaliddate";
        DynamicObject bom = BusinessDataServiceHelper.loadSingle((String)"pdm_mftbom", (String)string, (QFilter[])filters.toArray(new QFilter[filters.size()]));
        ArrayList<Long> ids = new ArrayList<Long>();
        if (bom != null) {
            ids.add((Long)bom.getPkValue());
            DynamicObjectCollection col = bom.getDynamicObjectCollection("entry");
            for (DynamicObject entry : col) {
                DynamicObject mater = entry.getDynamicObject("entrymaterial");
                DynamicObject version = entry.getDynamicObject("entryversion");
                String attr = mater.getString("materialattr");
                if (!MaterialAttrEnum.PHANTOMPART.getValue().equals(attr)) continue;
                QFilter qFilterBOMVersion = new QFilter("version", "=", version == null ? Integer.valueOf(0) : version.getPkValue());
                QFilter qFilterMater = new QFilter("material", "=", mater.getPkValue());
                List<QFilter> qFilters = CommonUtils.getDefautQFilter();
                qFilters.add(qFilterBOMVersion);
                qFilters.add(qFilterMater);
                ids.addAll(CommonUtils.getBomIds(qFilters));
            }
        }
        return ids;
    }

    public static List<QFilter> getDefautQFilter() {
        QFilter qFilterStatus = new QFilter("status", "=", (Object)"C");
        QFilter qFilterEnable = new QFilter("enable", "=", (Object)"1");
        ArrayList<QFilter> list = new ArrayList<QFilter>(16);
        list.add(qFilterEnable);
        list.add(qFilterStatus);
        return list;
    }

    public static String selectBOMPropertites() {
        StringBuilder string = new StringBuilder("ecn,replaceno,type,status,enable,org,useorg,isintegrity,iscoproduct,version,createorg,material,material.masterid,entry.setupentry,creator,createtime,auditor,auditdate,material.materialattr,id,number,entry,entry.seq,entry.entrymaterial,material.masterid.materialattr,group,yieldrate,auxproperty,description,entry.qtyentry,entry.entrymaterialattr,entry.entryversion,entry.entryunit,entry.entryunit.id,entry.entryunit.precision,entry.entryqtytype,entry.entryqtynumerator,entry.entryecn,entry.entryqtydenominator,entry.entryfixscrap,entry.entryecnno,entry.entryscraprate,entry.entryremark,entry.entryleadtime,entry.entryisstockalloc,entry.entrytimeunit,entry.entrysupplymode,entry.entrywarehouse,entry.entryowner,entry.entryiskey,ctrlstrategy,qtyentry.qtyentryvaliddate,entry.entrylocation,entry.entryisbulkmaterial,entry.entryisbackflush,entry.entrysetuplocation,entry.entryoperationnumber,entry.entryprocessseq,entry.entryissuemode,qtyentry.qtyentryinvaliddate,entry.entryversion,entry.entryauxproperty,qtyentry.qtyentrymaterial,entry.entryisjumplevel,entry.entryownertype,qtyentry.qtyentryauxproperty,entry.entryvaliddate,entry.entryinvaliddate,entry.entrytype,entry.entryauxproperty,entry.entrysupplyorg,entry.entryoutorg,qtyentry.qtyentryauxproperty,qtyentry.qtyentrybatchstartqty,qtyentry.qtyentrybatchendqty,entry.entryoutwarehouse,entry.entryreplaceplan,qtyentry.qtyentryisstepfix,qtyentry.qtyentryqtynumerator,qtyentry.qtyentryqtydenominator,qtyentry.qtyentryisstepfix,entry.entryisreplaceplanmm,qtyentry.seq,setupentry.seq,qtyentry.qtyentryfixscrap,qtyentry.qtyentryscraprate,setupentry.setupentrysetuplocation,setupentry.setupentryremark,setupentry.setupentryqty,entry.dateentry,dateentry.dateentrymaterial,dateentry.dateentryvaliddate,dateentry.dateentryinvaliddate,material.masterid.isuseauxpty,copentry,copentry.copentrytype,copentry.copentryunit,copentry.copentrymaterial,copentry.copentryqty,copentry.copentryoperation,copentry.copentryvaliddate,copentry.copentryinvaliddate,copentry.copentryremark");
        return string.toString();
    }

    public static Date getDate(String date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            return sdf.parse(date);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date parseDate(String string) {
        if (string == null) {
            return null;
        }
        try {
            return DateUtils.parseDate((String)string, (String[])parsePatterns);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date getShortDateFormat(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            String dateStr = sdf.format(date);
            return sdf.parse(dateStr);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static boolean isNumber(String str) {
        Pattern pattern = Pattern.compile("^-?\\d+(\\.\\d+)?$");
        Matcher isNum = pattern.matcher(str);
        boolean bIsNum = false;
        if (isNum.matches()) {
            bIsNum = true;
        }
        return bIsNum;
    }
}

