/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.common.util;

import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.MetadataServiceHelper;

public class ControlUtil {
    private ControlUtil() {
    }

    public static void setOldValue(IFormView fv, IDataModel dm, DynamicObject propertyValueCDDE, String propertyName, Object oldObject) {
        dm.beginInit();
        if (propertyValueCDDE != null) {
            propertyValueCDDE.beginInit();
            propertyValueCDDE.set(propertyName, oldObject);
            propertyValueCDDE.endInit();
        }
        dm.endInit();
        fv.updateView(propertyName);
    }

    public static void setOldValue(IFormView fv, IDataModel dm, DynamicObject propertyValueCDDE, String propertyName, Object oldObject, int row) {
        dm.beginInit();
        if (propertyValueCDDE != null) {
            propertyValueCDDE.beginInit();
            propertyValueCDDE.set(propertyName, oldObject);
            propertyValueCDDE.endInit();
        }
        dm.endInit();
        fv.updateView(propertyName, row);
    }

    public static void setControlMustInput(IFormView fv, String controlName, String tip, boolean isMustInput) {
        FieldEdit fieldEdit = (FieldEdit)fv.getControl(controlName);
        if (fieldEdit == null) {
            return;
        }
        HashMap<String, String> itemMap = new HashMap<String, String>();
        HashMap<String, HashMap<String, String>> ctlMap = new HashMap<String, HashMap<String, String>>();
        fieldEdit.setMustInput(isMustInput);
        itemMap.put("emptytip", tip);
        ctlMap.put("item", itemMap);
        fv.updateControlMetadata(controlName, ctlMap);
    }

    public static void showEntityFieldForm(TreeNode entityNode, String formId, String customParmsName, String callbackKey, IFormView fv, IFormPlugin plugin) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(formId);
        String nodesJson = SerializationUtils.toJsonString((Object)entityNode);
        showParameter.getCustomParams().put(customParmsName, nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack(plugin, callbackKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        fv.showForm(showParameter);
    }

    public static MainEntityType getMainEntityType(DynamicObject entity) {
        if (entity != null) {
            Object billentityPkValue = entity.getPkValue();
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)billentityPkValue.toString());
            return dataEntityType;
        }
        return null;
    }

    public static FormShowParameter createFormShowParameter(String formID, ShowType showType, Map<String, Object> customParameters, CloseCallBack closeCallBack) {
        if (StringUtils.isNotBlank((CharSequence)formID) && showType != null) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId(formID);
            OpenStyle openStyle = formShowParameter.getOpenStyle();
            if (openStyle != null) {
                openStyle.setShowType(showType);
            }
            if (customParameters != null) {
                formShowParameter.setCustomParams(customParameters);
            }
            if (closeCallBack != null) {
                formShowParameter.setCloseCallBack(closeCallBack);
            }
            return formShowParameter;
        }
        return null;
    }

    public static BillShowParameter createBillShowParameter(String pkId, String formID, ShowType showType, OperationStatus operationStatus, Map<String, Object> customParameters, CloseCallBack closeCallBack) {
        if (StringUtils.isNotBlank((CharSequence)formID) && showType != null) {
            BillShowParameter billShowParameter = new BillShowParameter();
            billShowParameter.setFormId(formID);
            OpenStyle openStyle = billShowParameter.getOpenStyle();
            if (openStyle != null) {
                openStyle.setShowType(showType);
            }
            if (StringUtils.isNotBlank((CharSequence)pkId)) {
                billShowParameter.setPkId((Object)pkId);
            }
            if (operationStatus != null) {
                billShowParameter.setStatus(operationStatus);
            }
            if (customParameters != null) {
                billShowParameter.setCustomParams(customParameters);
            }
            if (closeCallBack != null) {
                billShowParameter.setCloseCallBack(closeCallBack);
            }
            return billShowParameter;
        }
        return null;
    }

    public static void showForm(String formId, Map<String, Object> customParams, String callbackKey, IFormView fv, IFormPlugin plugin, ShowType showType) {
        if (StringUtils.isBlank((CharSequence)formId)) {
            return;
        }
        FormShowParameter formshow = new FormShowParameter();
        formshow.setFormId(formId);
        formshow.setCustomParams(customParams);
        formshow.setCloseCallBack(new CloseCallBack(plugin, callbackKey));
        formshow.getOpenStyle().setShowType(showType);
        fv.showForm(formshow);
    }
}

