/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.common.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class DynamicObjUtils {
    public static DynamicObject getObjByID(DynamicObjectCollection dyncObjEntrys, Long sID) {
        DynamicObject dyncObj = null;
        if (StringUtils.isBlank((Object)dyncObjEntrys)) {
            return dyncObj;
        }
        for (DynamicObject dyncObjEntry : dyncObjEntrys) {
            Long id = dyncObjEntry.getLong("id");
            if (id <= 0L || !id.equals(sID)) continue;
            dyncObj = dyncObjEntry;
            break;
        }
        return dyncObj;
    }

    public static DynamicObject getObjByID(DynamicObject[] dyncObjEntrys, Long sID) {
        DynamicObject dyncRes = null;
        if (StringUtils.isNotBlank((Object)dyncObjEntrys) && sID > 0L) {
            for (int i = 0; i < dyncObjEntrys.length; ++i) {
                DynamicObject dyncObjEntry = dyncObjEntrys[i];
                Long id = dyncObjEntry.getLong("id");
                if (id <= 0L || !id.equals(sID)) continue;
                dyncRes = dyncObjEntry;
                break;
            }
        }
        return dyncRes;
    }

    public static List<DynamicObject> getListObj(DynamicObject[] dyncObjs, Map<String, String> mFilters) {
        ArrayList<DynamicObject> newDyncObjs = new ArrayList<DynamicObject>();
        for (DynamicObject dyncObj : dyncObjs) {
            int i = 0;
            for (Map.Entry<String, String> mFilter : mFilters.entrySet()) {
                String fKey = mFilter.getKey();
                String fVal = mFilter.getValue();
                Object valObj = dyncObj.get(fKey);
                if (!StringUtils.isNotBlank((Object)valObj) || !StringUtils.isNotBlank((CharSequence)fVal) || !StringUtils.equalsIgnoreCase((CharSequence)valObj.toString(), (CharSequence)fVal)) continue;
                ++i;
            }
            if (i != mFilters.size()) continue;
            newDyncObjs.add(dyncObj);
        }
        return newDyncObjs;
    }

    public static DynamicObject[] getArrayObj(DynamicObject[] dyncObjs, Map<String, String> mFilters) {
        List<DynamicObject> newDyncObjs = DynamicObjUtils.getListObj(dyncObjs, mFilters);
        DynamicObject[] arrayObjs = newDyncObjs.toArray(new DynamicObject[newDyncObjs.size()]);
        return arrayObjs;
    }

    public static List<Object> getValsByKey(DynamicObject[] dyncObjEntrys, String key) {
        ArrayList<Object> objVals = new ArrayList<Object>();
        if (StringUtils.isBlank((Object)dyncObjEntrys)) {
            return objVals;
        }
        for (int i = 0; i < dyncObjEntrys.length; ++i) {
            DynamicObject dyncObjEntry = dyncObjEntrys[i];
            Object objVal = dyncObjEntry.get(key);
            if (StringUtils.isBlank(objVals)) continue;
            objVals.add(objVal);
        }
        return objVals;
    }

    public static List<Object> getValsByKey(DynamicObjectCollection colls, String key) {
        ArrayList<Object> objVals = new ArrayList<Object>();
        if (StringUtils.isBlank((Object)colls)) {
            return objVals;
        }
        for (int i = 0; i < colls.size(); ++i) {
            DynamicObject coll = (DynamicObject)colls.get(i);
            Object objVal = coll.get(key);
            if (StringUtils.isBlank(objVals)) continue;
            objVals.add(objVal);
        }
        return objVals;
    }

    public static DynamicObject[] getLoadData(String entityName, QFilter[] qfilters) {
        DynamicObjectCollection objs = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])qfilters);
        List<Long> objids = DynamicObjUtils.getIDs(objs);
        DynamicObject[] resObjs = DynamicObjUtils.getLoadData(entityName, objids);
        return resObjs;
    }

    public static DynamicObject[] getLoadData(String entityName, List<Long> ids) {
        DynamicObject[] dyncObjs = null;
        if (ids.size() <= 0) {
            return dyncObjs;
        }
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entityName);
        dyncObjs = BusinessDataServiceHelper.load((Object[])ids.toArray(new Object[ids.size()]), (DynamicObjectType)entityType);
        return dyncObjs;
    }

    public static List<Long> getIDs(DynamicObjectCollection dyncObjs) {
        ArrayList<Long> lstID = new ArrayList<Long>();
        for (int i = 0; i < dyncObjs.size(); ++i) {
            DynamicObject dyncObj = (DynamicObject)dyncObjs.get(i);
            Long id = dyncObj.getLong("id");
            if (lstID.contains(id)) continue;
            lstID.add(id);
        }
        return lstID;
    }
}

