/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.common.util;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.pdm.common.bom.ecoplatform.PlatformUtils;

public class ECNNewUtil {
    private static Log log = LogFactory.getLog(ECNNewUtil.class);

    public static void refreshBomEntryCache(DynamicObject bom) {
        DynamicObjectCollection entryEntity = bom.getDynamicObjectCollection("entry");
        if (!entryEntity.isEmpty()) {
            IDataEntityType dataEntityType = ((DynamicObject)entryEntity.get(0)).getDataEntityType();
            DataEntityCacheManager cacheManager = new DataEntityCacheManager(dataEntityType);
            cacheManager.removeByDt();
        }
    }

    public static Date setDateSubOne(Date invalidDate) {
        if (invalidDate == null) {
            return null;
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(invalidDate);
        ((Calendar)calendar).add(13, -1);
        Date modifyDate = calendar.getTime();
        return modifyDate;
    }

    public static boolean updateEcoBomTransDate(DynamicObject ecoBom, int toDay, boolean isSave) {
        if (toDay == 0) {
            return Boolean.FALSE;
        }
        boolean isupdate = false;
        DynamicObjectCollection coll = ecoBom.getDynamicObjectCollection("entry");
        if (PlatformUtils.isNullCollection(coll)) {
            return Boolean.FALSE;
        }
        for (int i = 0; i < coll.size(); ++i) {
            DynamicObject entry = (DynamicObject)coll.get(i);
            Date oldTranstartdate = entry.getDate("transtartdate");
            if (oldTranstartdate == null) continue;
            Date newTranstartdate = PlatformUtils.addDay(oldTranstartdate, toDay);
            entry.set("transtartdate", (Object)newTranstartdate);
            isupdate = true;
        }
        if (isupdate && isSave) {
            SaveServiceHelper.update((DynamicObject)ecoBom);
        }
        return isupdate;
    }
}

