/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.common.util;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.basedata.cache.BaseDataCtrlCacheMrg;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataService;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.pdm.common.enums.ECOPEntryExecModeEnum;
import kd.mmc.pdm.common.util.BOMCopyUtils;

public class ECNUtil {
    private static Log log = LogFactory.getLog(ECNUtil.class);

    public static String getECNVersion(Object bomid) {
        if (bomid == null) {
            return null;
        }
        QFilter qFilter = new QFilter("bom", "=", bomid);
        String number = "ECN";
        String no = "";
        QFilter qFilter2 = null;
        for (int i = 1; i < 100; ++i) {
            no = i < 10 ? "0" + i : "" + i;
            qFilter2 = new QFilter("number", "=", (Object)(number + no));
            if (QueryServiceHelper.exists((String)"pdm_ecnversion", (QFilter[])new QFilter[]{qFilter, qFilter2})) continue;
            return number + no;
        }
        return null;
    }

    public static DynamicObject createECNVersion(DynamicObject org, DynamicObject bom, Date validdate, Date invaliddate, String enc) {
        DynamicObject ecnversion = ORM.create().newDynamicObject("pdm_ecnversion");
        if (bom == null || invaliddate == null || validdate == null) {
            return null;
        }
        QFilter qFilter = new QFilter("bom", "=", bom.getPkValue());
        QFilter qFilter2 = new QFilter("number", "=", (Object)enc);
        if (StringUtils.isBlank((CharSequence)enc) || QueryServiceHelper.exists((String)"pdm_ecnversion", (QFilter[])new QFilter[]{qFilter, qFilter2})) {
            enc = ECNUtil.getECNVersion(bom.getPkValue());
        }
        ecnversion.set("createorg", (Object)org);
        ecnversion.set("bom", (Object)bom);
        ecnversion.set("number", (Object)enc);
        ecnversion.set("validdate", (Object)validdate);
        ecnversion.set("invaliddate", (Object)invaliddate);
        ecnversion.set("status", (Object)"C");
        ecnversion.set("enable", (Object)"1");
        ecnversion.set("ctrlstrategy", (Object)"5");
        return ecnversion;
    }

    public static void deleteECNVersion(DynamicObject bom, String enc) {
        String selectProperties = "id,number,createorg,bom";
        QFilter[] filter = new QFilter[2];
        QFilter qFilter = new QFilter("bom", "=", bom.getPkValue());
        QFilter qFilter1 = new QFilter("number", "=", (Object)enc);
        filter[0] = qFilter;
        filter[1] = qFilter1;
        try {
            DeleteServiceHelper.delete((String)"pdm_ecnversion", (QFilter[])filter);
        }
        catch (Exception e1) {
            throw new KDBizException((Throwable)e1, new ErrorCode("delete-ecn-fail", String.format(ResManager.loadKDString((String)"\u5220\u9664ECN\u7248\u672c\u5931\u8d25\u3002", (String)"ECNUtil_0", (String)"mmc-pdm-common", (Object[])new Object[0]), new Object[0])), new Object[0]);
        }
    }

    public static DynamicObject addnewEntry(List<DynamicObject> entryCol, Object bomid, DynamicObject ECN, String ecnbillno, String ecnId, Date neweffectdate, boolean isECNVersion, Date pentryvaliddate) {
        if (bomid == null || entryCol == null || entryCol.size() == 0) {
            return null;
        }
        DynamicObject bom = BusinessDataServiceHelper.loadSingle((Object)bomid, (String)"pdm_mftbom");
        if (bom == null) {
            return null;
        }
        if (ECN == null) {
            return null;
        }
        bom.set("ecn", (Object)ECN);
        DynamicObjectCollection oldentrys = bom.getDynamicObjectCollection("entry");
        if (oldentrys == null) {
            return null;
        }
        Integer seq = oldentrys.size();
        for (DynamicObject newentry : entryCol) {
            Comparable<Date> oldDate;
            Object o;
            if (newentry.get("entryvaliddate") == null) {
                return null;
            }
            String entryBomEntryId = newentry.getString("entrybomentryid");
            Date entryvaliddate = newentry.getDate("entryvaliddate");
            int idx = ECNUtil.findBeforeEntryIdx(entryBomEntryId, oldentrys);
            String entryMode = newentry.getString("entrymode");
            if (StringUtils.equals((CharSequence)entryMode, (CharSequence)"E")) {
                if (idx < 0) continue;
                o = (DynamicObject)oldentrys.get(idx);
                oldDate = o.getDate("entryvaliddate");
                if (pentryvaliddate == null) {
                    pentryvaliddate = oldDate;
                }
                o.set("entryinvaliddate", (Object)ECNUtil.getSubtractSecondDate(pentryvaliddate, -1));
                o.set("entryecnno", (Object)ecnbillno);
                o.set("entryecnid", (Object)ecnId);
                continue;
            }
            if (isECNVersion) {
                entryvaliddate = neweffectdate;
            } else {
                ECNUtil.updateInValidDate(idx, oldentrys, newentry.getDate("entryvaliddate"));
            }
            o = seq;
            seq = seq + 1;
            oldDate = seq;
            DynamicObject oldentry = null;
            if (idx >= 0) {
                oldentry = new DynamicObject(oldentrys.getDynamicObjectType());
                oldentrys.add(idx + 1, oldentry);
            } else {
                oldentry = oldentrys.addNew();
            }
            oldentry.set("seq", (Object)seq);
            oldentry.set("entrytype", (Object)"A");
            if (newentry.get("entrymaterial") == null) {
                return null;
            }
            DynamicObject mater = newentry.getDynamicObject("entrymaterial");
            oldentry.set("entrymaterial", (Object)mater);
            Object masterid = mater.get("masterid");
            Long mid = 0L;
            mid = masterid instanceof DynamicObject ? (Long)((DynamicObject)masterid).getPkValue() : (Long)masterid;
            DynamicObject master = BusinessDataServiceHelper.loadSingle((Object)mid, (String)"bd_material");
            oldentry.set("entrymaterialid", (Object)master);
            if (newentry.get("entryunit") == null) {
                return null;
            }
            oldentry.set("entryunit", (Object)newentry.getDynamicObject("entryunit"));
            oldentry.set("entryversion", (Object)newentry.getDynamicObject("entryversion"));
            if (newentry.get("entryqtytype") == null) {
                return null;
            }
            oldentry.set("entryqtytype", newentry.get("entryqtytype"));
            oldentry.set("entryecn", (Object)ECN);
            if (newentry.get("entryqtynumerator") == null) {
                return null;
            }
            oldentry.set("entryqtynumerator", newentry.get("entryqtynumerator"));
            if (newentry.get("entryqtydenominator") == null) {
                return null;
            }
            oldentry.set("entryqtydenominator", newentry.get("entryqtydenominator"));
            oldentry.set("entryfixscrap", newentry.get("entryfixscrap"));
            oldentry.set("entryscraprate", newentry.get("entryscraprate"));
            oldentry.set("entryvaliddate", (Object)entryvaliddate);
            if (newentry.get("entryauxproperty") != null) {
                oldentry.set("entryauxproperty", (Object)newentry.getDynamicObject("entryauxproperty"));
            }
            oldentry.set("entryremark", newentry.get("entryremark"));
            if (newentry.get("entryinvaliddate") == null) {
                return null;
            }
            oldentry.set("entryinvaliddate", newentry.get("entryinvaliddate"));
            if (newentry.get("entrymaterialattr") == null) {
                return null;
            }
            oldentry.set("entrymaterialattr", newentry.get("entrymaterialattr"));
            oldentry.set("entryoperationnumber", newentry.get("entryoperationnumber"));
            oldentry.set("entryprocessseq", newentry.get("entryprocessseq"));
            oldentry.set("entrytimeunit", newentry.get("entrytimeunit"));
            oldentry.set("entrywarehouse", newentry.get("entrywarehouse"));
            oldentry.set("entrylocation", newentry.get("entrylocation"));
            oldentry.set("entryisbackflush", newentry.get("entryisbackflush"));
            oldentry.set("entryisbulkmaterial", newentry.get("entryisbulkmaterial"));
            oldentry.set("entryisjumplevel", newentry.get("entryisjumplevel"));
            oldentry.set("entrysupplyorg", newentry.get("entrysupplyorg"));
            oldentry.set("entryiskey", newentry.get("entryiskey"));
            oldentry.set("entryleadtime", newentry.get("entryleadtime"));
            oldentry.set("entryissuemode", newentry.get("entryissuemode"));
            oldentry.set("entryisstockalloc", newentry.get("entryisstockalloc"));
            oldentry.set("entryoutorg", newentry.get("entryoutorg"));
            oldentry.set("entryoutwarehouse", newentry.get("entryoutwarehouse"));
            oldentry.set("entryoutlocation", newentry.get("entryoutlocation"));
            oldentry.set("entryreplaceplan", newentry.get("entryreplaceplan"));
            oldentry.set("entryisreplaceplanmm", newentry.get("entryisreplaceplanmm"));
            oldentry.set("entryownertype", newentry.get("entryownertype"));
            oldentry.set("entryowner", newentry.get("entryowner"));
            if (StringUtils.isNotEmpty((CharSequence)ecnbillno)) {
                oldentry.set("entryecnno", (Object)ecnbillno);
            }
            oldentry.set("entryecnid", (Object)ecnId);
            String qtytype = oldentry.getString("entryqtytype");
            if (StringUtils.isNotBlank((CharSequence)qtytype) && StringUtils.equals((CharSequence)qtytype, (CharSequence)"C")) {
                DynamicObjectCollection oldqtyentrys = oldentry.getDynamicObjectCollection("qtyentry");
                DynamicObjectCollection newqtyentrys = newentry.getDynamicObjectCollection("qtyentry");
                oldqtyentrys.clear();
                for (DynamicObject newqtyentry : newqtyentrys) {
                    DynamicObject oldqtyentry = oldqtyentrys.addNew();
                    oldqtyentry.set("qtyentrybatchstartqty", newqtyentry.get("qtyentrybatchstartqty"));
                    oldqtyentry.set("qtyentrybatchendqty", newqtyentry.get("qtyentrybatchendqty"));
                    oldqtyentry.set("qtyentryqtynumerator", newqtyentry.get("qtyentryqtynumerator"));
                    oldqtyentry.set("qtyentryqtydenominator", newqtyentry.get("qtyentryqtydenominator"));
                    oldqtyentry.set("qtyentryfixscrap", newqtyentry.get("qtyentryfixscrap"));
                    oldqtyentry.set("qtyentryscraprate", newqtyentry.get("qtyentryscraprate"));
                    oldqtyentry.set("qtyentryisstepfix", newqtyentry.get("qtyentryisstepfix"));
                }
                continue;
            }
            DynamicObjectCollection oldsetupentrys = oldentry.getDynamicObjectCollection("setupentry");
            DynamicObjectCollection newsetupentrys = newentry.getDynamicObjectCollection("setupentry");
            Integer seqs = oldsetupentrys.size();
            for (DynamicObject newsetupentry : newsetupentrys) {
                Integer n = seqs;
                Integer n2 = seqs = Integer.valueOf(seqs + 1);
                DynamicObject oldsetupentry = oldsetupentrys.addNew();
                oldsetupentry.set("seq", (Object)seqs);
                oldsetupentry.set("setupentryremark", newsetupentry.get("setupentryremark"));
                oldsetupentry.set("setupentrysetuplocation", newsetupentry.get("setupentrysetuplocation"));
                oldsetupentry.set("setupentryqty", newsetupentry.get("setupentryqty"));
            }
        }
        for (int i = 0; i < oldentrys.size(); ++i) {
            DynamicObject oldentry = (DynamicObject)oldentrys.get(i);
            oldentry.set("seq", (Object)(i + 1));
        }
        return bom;
    }

    private static void updateInValidDate(int idx, DynamicObjectCollection entrys, Date validDate) {
        if (idx < 0 || validDate == null || idx >= entrys.size()) {
            return;
        }
        validDate = ECNUtil.getSubtractSecondDate(validDate, -1);
        DynamicObject entry = (DynamicObject)entrys.get(idx);
        entry.set("entryinvaliddate", (Object)validDate);
    }

    private static Date getSubtractSecondDate(Date date, int second) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        long time = date.getTime();
        time = time / 1000L * 1000L;
        calendar.setTimeInMillis(time);
        calendar.add(13, second);
        return calendar.getTime();
    }

    private static int findBeforeEntryIdx(String bomEntryId, DynamicObjectCollection entrys) {
        if (bomEntryId == null || bomEntryId.equals("0")) {
            return -1;
        }
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject entry = (DynamicObject)entrys.get(i);
            String id = entry.getString("id");
            if (!bomEntryId.equals(id)) continue;
            return i;
        }
        return -1;
    }

    public static DynamicObject updateEntry(List<DynamicObject> entryCol, Object bomid, DynamicObject ECN, Boolean isAdd, DynamicObject newbom, String ecnbillno, String ecnId, Date neweffectdate, boolean isECNVersion) {
        if (bomid == null || entryCol == null || entryCol.size() == 0) {
            return null;
        }
        DynamicObject bom = null;
        bom = isAdd != false ? newbom : BusinessDataServiceHelper.loadSingle((Object)bomid, (String)"pdm_mftbom");
        if (bom == null) {
            return null;
        }
        bom.set("ecn", (Object)ECN);
        DynamicObjectCollection oldentrys = bom.getDynamicObjectCollection("entry");
        block0: for (DynamicObject newentry : entryCol) {
            String bomentryid = newentry.getString("entrybomentryid");
            if (bomentryid == null) continue;
            for (DynamicObject oldentry : oldentrys) {
                DynamicObjectCollection oldqtyentrys;
                String qtytype;
                if (!StringUtils.equals((CharSequence)bomentryid, (CharSequence)oldentry.getString("id"))) continue;
                if (newentry.get("entryunit") != null) {
                    oldentry.set("entryunit", (Object)newentry.getDynamicObject("entryunit"));
                }
                if (newentry.get("entryversion") != null) {
                    oldentry.set("entryversion", (Object)newentry.getDynamicObject("entryversion"));
                }
                if (newentry.get("entryqtytype") != null) {
                    oldentry.set("entryqtytype", newentry.get("entryqtytype"));
                }
                if (StringUtils.isNotEmpty((CharSequence)ecnbillno)) {
                    oldentry.set("entryecnno", (Object)ecnbillno);
                }
                oldentry.set("entryecnid", (Object)ecnId);
                oldentry.set("entryecn", (Object)ECN);
                if (newentry.get("entryqtynumerator") != null) {
                    oldentry.set("entryqtynumerator", newentry.get("entryqtynumerator"));
                }
                if (newentry.get("entryqtydenominator") != null) {
                    oldentry.set("entryqtydenominator", newentry.get("entryqtydenominator"));
                }
                if (newentry.get("entryfixscrap") != null) {
                    oldentry.set("entryfixscrap", newentry.get("entryfixscrap"));
                }
                if (newentry.get("entryscraprate") != null) {
                    oldentry.set("entryscraprate", newentry.get("entryscraprate"));
                }
                if (newentry.get("entryvaliddate") != null) {
                    if (isECNVersion) {
                        oldentry.set("entryvaliddate", (Object)neweffectdate);
                    } else {
                        oldentry.set("entryvaliddate", (Object)newentry.getDate("entryvaliddate"));
                    }
                }
                if (newentry.get("entryauxproperty") != null) {
                    oldentry.set("entryauxproperty", (Object)newentry.getDynamicObject("entryauxproperty"));
                }
                if (newentry.get("entryinvaliddate") != null) {
                    oldentry.set("entryinvaliddate", (Object)newentry.getDate("entryinvaliddate"));
                }
                if (newentry.get("entryremark") != null) {
                    oldentry.set("entryremark", newentry.get("entryremark"));
                }
                if (newentry.get("entrymaterialattr") != null) {
                    oldentry.set("entrymaterialattr", newentry.get("entrymaterialattr"));
                }
                if (newentry.get("entryoperationnumber") != null) {
                    oldentry.set("entryoperationnumber", newentry.get("entryoperationnumber"));
                }
                if (newentry.get("entryprocessseq") != null) {
                    oldentry.set("entryprocessseq", newentry.get("entryprocessseq"));
                }
                if (newentry.get("entrytimeunit") != null) {
                    oldentry.set("entrytimeunit", newentry.get("entrytimeunit"));
                }
                if (newentry.get("entrywarehouse") != null) {
                    oldentry.set("entrywarehouse", newentry.get("entrywarehouse"));
                }
                if (newentry.get("entrylocation") != null) {
                    oldentry.set("entrylocation", newentry.get("entrylocation"));
                }
                if (newentry.get("entryisbackflush") != null) {
                    oldentry.set("entryisbackflush", newentry.get("entryisbackflush"));
                }
                if (newentry.get("entryisbulkmaterial") != null) {
                    oldentry.set("entryisbulkmaterial", newentry.get("entryisbulkmaterial"));
                }
                if (newentry.get("entryisjumplevel") != null) {
                    oldentry.set("entryisjumplevel", newentry.get("entryisjumplevel"));
                }
                if (newentry.get("entrysupplyorg") != null) {
                    oldentry.set("entrysupplyorg", newentry.get("entrysupplyorg"));
                }
                if (newentry.get("entryiskey") != null) {
                    oldentry.set("entryiskey", newentry.get("entryiskey"));
                }
                if (newentry.get("entryleadtime") != null) {
                    oldentry.set("entryleadtime", newentry.get("entryleadtime"));
                }
                if (newentry.get("entryissuemode") != null) {
                    oldentry.set("entryissuemode", newentry.get("entryissuemode"));
                }
                if (newentry.get("entryisstockalloc") != null) {
                    oldentry.set("entryisstockalloc", newentry.get("entryisstockalloc"));
                }
                if (newentry.get("entryoutorg") != null) {
                    oldentry.set("entryoutorg", newentry.get("entryoutorg"));
                }
                if (newentry.get("entryoutwarehouse") != null) {
                    oldentry.set("entryoutwarehouse", newentry.get("entryoutwarehouse"));
                }
                if (newentry.get("entryoutlocation") != null) {
                    oldentry.set("entryoutlocation", newentry.get("entryoutlocation"));
                }
                if (newentry.get("entryreplaceplan") != null) {
                    oldentry.set("entryreplaceplan", newentry.get("entryreplaceplan"));
                }
                if (newentry.get("entryisreplaceplanmm") != null) {
                    oldentry.set("entryisreplaceplanmm", newentry.get("entryisreplaceplanmm"));
                }
                if (newentry.get("entryownertype") != null) {
                    oldentry.set("entryownertype", newentry.get("entryownertype"));
                }
                if (newentry.get("entryowner") != null) {
                    oldentry.set("entryowner", newentry.get("entryowner"));
                }
                if (StringUtils.isNotBlank((CharSequence)(qtytype = oldentry.getString("entryqtytype"))) && StringUtils.equals((CharSequence)qtytype, (CharSequence)"C")) {
                    oldqtyentrys = oldentry.getDynamicObjectCollection("qtyentry");
                    DynamicObjectCollection newqtyentrys = newentry.getDynamicObjectCollection("qtyentry");
                    oldqtyentrys.clear();
                    for (DynamicObject newqtyentry : newqtyentrys) {
                        DynamicObject oldqtyentry = oldqtyentrys.addNew();
                        oldqtyentry.set("qtyentrybatchstartqty", newqtyentry.get("qtyentrybatchstartqty"));
                        oldqtyentry.set("qtyentrybatchendqty", newqtyentry.get("qtyentrybatchendqty"));
                        oldqtyentry.set("qtyentryqtynumerator", newqtyentry.get("qtyentryqtynumerator"));
                        oldqtyentry.set("qtyentryqtydenominator", newqtyentry.get("qtyentryqtydenominator"));
                        oldqtyentry.set("qtyentryfixscrap", newqtyentry.get("qtyentryfixscrap"));
                        oldqtyentry.set("qtyentryscraprate", newqtyentry.get("qtyentryscraprate"));
                        oldqtyentry.set("qtyentryisstepfix", newqtyentry.get("qtyentryisstepfix"));
                    }
                    continue block0;
                }
                if (StringUtils.equals((CharSequence)qtytype, (CharSequence)"C")) continue block0;
                oldqtyentrys = oldentry.getDynamicObjectCollection("qtyentry");
                oldqtyentrys.clear();
                DynamicObjectCollection oldsetupentrys = oldentry.getDynamicObjectCollection("setupentry");
                DynamicObjectCollection newsetupentrys = newentry.getDynamicObjectCollection("setupentry");
                Integer seq = oldsetupentrys.size();
                ArrayList<String> setupentrysrcids = new ArrayList<String>();
                block3: for (DynamicObject newsetupentry : newsetupentrys) {
                    Long setupentrysrcid = newsetupentry.getLong("setupentrysrcid");
                    if (setupentrysrcid == null || setupentrysrcid == 0L) {
                        Integer n = seq;
                        Integer n2 = seq = Integer.valueOf(seq + 1);
                        DynamicObject oldsetupentry = oldsetupentrys.addNew();
                        oldsetupentry.set("seq", (Object)seq);
                        oldsetupentry.set("setupentryremark", newsetupentry.get("setupentryremark"));
                        oldsetupentry.set("setupentrysetuplocation", newsetupentry.get("setupentrysetuplocation"));
                        oldsetupentry.set("setupentryqty", newsetupentry.get("setupentryqty"));
                        setupentrysrcids.add("0");
                        continue;
                    }
                    for (DynamicObject oldsetupentry : oldsetupentrys) {
                        if (!StringUtils.equals((CharSequence)setupentrysrcid.toString(), (CharSequence)oldsetupentry.getString("id"))) continue;
                        if (newsetupentry.get("setupentryremark") != null) {
                            oldsetupentry.set("setupentryremark", newsetupentry.get("setupentryremark"));
                        }
                        if (newsetupentry.get("setupentrysetuplocation") != null) {
                            oldsetupentry.set("setupentrysetuplocation", newsetupentry.get("setupentrysetuplocation"));
                        }
                        if (newsetupentry.get("setupentryqty") != null) {
                            oldsetupentry.set("setupentryqty", newsetupentry.get("setupentryqty"));
                        }
                        setupentrysrcids.add(setupentrysrcid.toString());
                        continue block3;
                    }
                }
                if (setupentrysrcids == null || setupentrysrcids.size() <= 0) continue block0;
                DynamicObjectCollection delsetupentrys = new DynamicObjectCollection();
                for (DynamicObject oldsetupentry : oldsetupentrys) {
                    if (setupentrysrcids.contains(oldsetupentry.getString("id"))) continue;
                    delsetupentrys.add((Object)oldsetupentry);
                }
                if (delsetupentrys.size() <= 0) continue block0;
                oldsetupentrys.removeAll((Collection)delsetupentrys);
                continue block0;
            }
        }
        return bom;
    }

    public static String getPreEcnVersion(String ecnversion) {
        String str = ecnversion;
        String numstr = str.substring(3);
        String number = "ECN";
        String no = "";
        int num = Integer.parseInt(numstr);
        if (num > 0) {
            no = --num < 10 ? "0" + num : "" + num;
            return number + no;
        }
        return "ECN00";
    }

    public static ValidationErrorInfo buildErrMessage(DynamicObject obj, KDBizException exp, int dataIndex, int rowIndex) {
        Object pkId = obj.getPkValue();
        ErrorLevel errorLevel = ErrorLevel.Error;
        String msg = exp.getMessage();
        ValidationErrorInfo info = new ValidationErrorInfo("", pkId, dataIndex, rowIndex, exp.getErrorCode().getCode(), "pdm_ecn", msg, errorLevel);
        return info;
    }

    public static String exeECNOp(DynamicObject dObject, boolean isImmediatelyExe, String opr) {
        String msg;
        String msg2;
        boolean isECNVersion;
        DynamicObjectCollection pentrys = dObject.getDynamicObjectCollection("pentry");
        DynamicObjectCollection entrys = dObject.getDynamicObjectCollection("entry");
        String ecnbillno = dObject.getString("billno");
        String ecnId = dObject.getString("id");
        ArrayList<Long> bomIds = new ArrayList<Long>();
        ArrayList<Object> syncCostbomIds = new ArrayList<Object>();
        HashMap<Long, DynamicObject> ECNmaps = new HashMap<Long, DynamicObject>();
        HashMap addNewmaps = new HashMap();
        HashMap updatemaps = new HashMap();
        HashMap<Long, DynamicObject> versionCtrl = new HashMap<Long, DynamicObject>();
        HashMap<Long, Date> validDataMaps = new HashMap<Long, Date>();
        DynamicObject org = dObject.getDynamicObject("org");
        Date newData = new Date();
        DynamicObject type = dObject.getDynamicObject("type");
        boolean bl = isECNVersion = type != null && type.getBoolean("isecnversion");
        if (!isECNVersion && isImmediatelyExe) {
            isImmediatelyExe = false;
        }
        StringBuilder error = new StringBuilder();
        for (int k = 0; k < pentrys.size(); ++k) {
            Object pbomPkObj;
            DynamicObject pentry = (DynamicObject)pentrys.get(k);
            DynamicObject pbom = pentry.getDynamicObject("pentrybom");
            DynamicObject product = pentry.getDynamicObject("proentrymaterial");
            if (product == null) {
                String msg3 = String.format(ResManager.loadKDString((String)"%1$s:\u7b2c%2$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u6570\u636e\u6821\u9a8c\u51fa\u9519\uff0c\u4ea7\u54c1\u7f16\u7801\u4e0d\u5b58\u5728\u3002", (String)"ECNUtil_1", (String)"mmc-pdm-common", (Object[])new Object[0]), ecnbillno, k + 1);
                throw new KDBizException(new ErrorCode("pdm-ecn", msg3), new Object[0]);
            }
            DynamicObject mater = product.getDynamicObject("masterid");
            String materialNum = mater.getString("number");
            String pentryexecmode = pentry.getString("pentryexecmode");
            String pentryexecstatus = pentry.getString("pentryexecstatus");
            if (!"A".equals(pentryexecstatus) || isImmediatelyExe && ECOPEntryExecModeEnum.DATE.getValue().equals(pentryexecmode)) continue;
            pentry.set("pentryexecstatus", (Object)"B");
            pentry.set("pentryexecdate", (Object)newData);
            if (pbom == null) {
                String msg4 = String.format(ResManager.loadKDString((String)"%1$s:\u7b2c%2$s\u6761\u4ea7\u54c1\u5206\u5f55\u6570\u636e\u68c0\u9a8c\u51fa\u9519\uff0c\u8be5\u4ea7\u54c1\u6240\u5c5eBOM\u53ef\u80fd\u4e0d\u5b58\u5728\u3002", (String)"ECNUtil_2", (String)"mmc-pdm-common", (Object[])new Object[0]), ecnbillno, k + 1);
                throw new KDBizException(new ErrorCode("pdm-ecn", msg4), new Object[0]);
            }
            String ECNVersion = pentry.getString("pentryecn");
            if (StringUtils.isBlank((CharSequence)ECNVersion)) {
                msg2 = String.format(ResManager.loadKDString((String)"%1$s:\u7b2c%2$s\u6761\u4ea7\u54c1\u5206\u5f55\u6570\u636e\u68c0\u9a8c\u51fa\u9519\uff0cECN\u7248\u672c\u4e3a\u7a7a\u3002", (String)"ECNUtil_3", (String)"mmc-pdm-common", (Object[])new Object[0]), ecnbillno, k + 1);
                throw new KDBizException(new ErrorCode("pdm-ecn", msg2), new Object[0]);
            }
            QFilter qFilter = null;
            QFilter qFilter1 = new QFilter("number", "=", (Object)ECNVersion);
            qFilter = !ECNVersion.equals("ECN00") ? new QFilter("bom", "=", pbom.getPkValue()) : new QFilter("bom", "=", (Object)0L);
            DynamicObject ECN = BusinessDataServiceHelper.loadSingle((String)"pdm_ecnversion", (String)"id,number,name,bom,validdate,invaliddate", (QFilter[])new QFilter[]{qFilter, qFilter1});
            if (ECN == null) {
                msg = String.format(ResManager.loadKDString((String)"%1$s:\u7b2c%2$s\u6761\u4ea7\u54c1\u5206\u5f55\u6570\u636e\u68c0\u9a8c\u51fa\u9519\uff0cECN\u7248\u672c\u53ef\u80fd\u4e0d\u5b58\u5728\u3002", (String)"ECNUtil_4", (String)"mmc-pdm-common", (Object[])new Object[0]), ecnbillno, k + 1);
                throw new KDBizException(new ErrorCode("pdm-ecn", msg), new Object[0]);
            }
            Date pentryvaliddate = pentry.getDate("pentryvaliddate");
            if (pentryvaliddate == null) {
                String msg5 = String.format(ResManager.loadKDString((String)"%1$s:\u7b2c%2$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u6570\u636e\u6821\u9a8c\u51fa\u9519\uff0cECN\u751f\u6548\u65e5\u671f\u4e3a\u7a7a\u3002", (String)"ECNUtil_5", (String)"mmc-pdm-common", (Object[])new Object[0]), ecnbillno, k + 1);
                throw new KDBizException(new ErrorCode("pdm-ecn", msg5), new Object[0]);
            }
            ArrayList<DynamicObject> addnewCol = new ArrayList<DynamicObject>();
            ArrayList<DynamicObject> updateCol = new ArrayList<DynamicObject>();
            String entryversioncontrol = pentry.getString("entryversioncontrol");
            DynamicObject pentrynewversion = pentry.getDynamicObject("pentrynewversion");
            if (pentrynewversion == null && !entryversioncontrol.equals("A")) {
                String msg6 = String.format(ResManager.loadKDString((String)"%1$s:\u7b2c%2$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u6570\u636e\u6821\u9a8c\u51fa\u9519\uff0c\u65b0\u7248\u672c\u4e3a\u7a7a\u3002", (String)"ECNUtil_6", (String)"mmc-pdm-common", (Object[])new Object[0]), ecnbillno, k + 1);
                throw new KDBizException(new ErrorCode("pdm-ecn", msg6), new Object[0]);
            }
            if (entryversioncontrol.equals("A")) {
                pentrynewversion = null;
            }
            if (!syncCostbomIds.contains(pbomPkObj = pbom.getPkValue())) {
                syncCostbomIds.add(pbomPkObj);
            }
            Long pbomPk = (Long)pbom.getPkValue();
            boolean flag = true;
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject entry = (DynamicObject)entrys.get(i);
                String entrymode = entry.getString("entrymode");
                if (StringUtils.isBlank((CharSequence)entrymode)) {
                    String msg7 = String.format(ResManager.loadKDString((String)"%1$s:\u7b2c%2$s\u6761\u7ec4\u4ef6\u5206\u5f55\u6570\u636e\u68c0\u9a8c\u51fa\u9519\uff0c\u884c\u6807\u8bc6\u4e3a\u7a7a\u3002", (String)"ECNUtil_7", (String)"mmc-pdm-common", (Object[])new Object[0]), ecnbillno, i + 1);
                    throw new KDBizException(new ErrorCode("pdm-ecn", msg7), new Object[0]);
                }
                if (!StringUtils.equals((CharSequence)"A", (CharSequence)entrymode) && !StringUtils.equals((CharSequence)"C", (CharSequence)entrymode) && !StringUtils.equals((CharSequence)"E", (CharSequence)entrymode)) continue;
                DynamicObject bom = entry.getDynamicObject("entrybom");
                if (!pbom.getPkValue().equals(bom.getPkValue())) continue;
                if (!addnewCol.contains(entry) && StringUtils.equals((CharSequence)"E", (CharSequence)entrymode)) {
                    addnewCol.add(entry);
                } else if (!addnewCol.contains(entry) && (StringUtils.equals((CharSequence)"A", (CharSequence)entrymode) || StringUtils.equals((CharSequence)"A", (CharSequence)entryversioncontrol))) {
                    addnewCol.add(entry);
                } else {
                    if (updateCol.contains(entry) || !StringUtils.equals((CharSequence)"C", (CharSequence)entrymode) || !StringUtils.equals((CharSequence)"B", (CharSequence)entryversioncontrol) && !StringUtils.equals((CharSequence)"C", (CharSequence)entryversioncontrol)) continue;
                    updateCol.add(entry);
                }
                Date invaliddate = entry.getDate("entryinvaliddate");
                if (invaliddate == null || invaliddate.compareTo(newData) >= 0) continue;
                error.append(String.format(ResManager.loadKDString((String)"%1$s:\u7b2c%2$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%3$s\u6761\u7ec4\u4ef6\u5206\u5f55\uff0c\u201c\u5931\u6548\u65e5\u671f\u201d\uff1c\u201c\u5f53\u524d\u65e5\u671f\u201d\uff0c\u4ea7\u54c1\u7f16\u7801%4$s\u5b9e\u65bd\u72b6\u6001\u4fee\u6539\u4e3a\u5df2\u5931\u6548\u3002", (String)"ECNUtil_8", (String)"mmc-pdm-common", (Object[])new Object[0]), ecnbillno, k + 1, i + 1, materialNum)).append("\r\n");
                pentry.set("pentryexecstatus", (Object)"C");
                pentry.set("pentryexecdate", null);
                flag = false;
            }
            if (!flag) continue;
            ECNmaps.put(pbomPk, ECN);
            bomIds.add(pbomPk);
            addNewmaps.put(pbomPk, addnewCol);
            updatemaps.put(pbomPk, updateCol);
            versionCtrl.put(pbomPk, pentrynewversion);
            validDataMaps.put(pbomPk, pentryvaliddate);
        }
        ArrayList<DynamicObject> listBom = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> copyBoms = new ArrayList<DynamicObject>();
        for (Long bomid : bomIds) {
            DynamicObject bom1;
            ArrayList<DynamicObject> addnewCol = addNewmaps.get(bomid) != null ? (List)addNewmaps.get(bomid) : new ArrayList();
            ArrayList<DynamicObject> updateCol = updatemaps.get(bomid) != null ? (List)updatemaps.get(bomid) : new ArrayList();
            DynamicObject ECN = (DynamicObject)ECNmaps.get(bomid);
            DynamicObject newVersion = (DynamicObject)versionCtrl.get(bomid);
            Date pentryvaliddate = (Date)validDataMaps.get(bomid);
            if (ECN == null) {
                msg2 = ResManager.loadKDString((String)"ECN\u7248\u672c\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u6b63\u786e\u6027\u3002", (String)"ECNUtil_9", (String)"mmc-pdm-common", (Object[])new Object[0]);
                throw new KDBizException(new ErrorCode("pdm-ecn", msg2), new Object[0]);
            }
            Boolean isAdd = Boolean.FALSE;
            DynamicObject bom = ECNUtil.addnewEntry(addnewCol, bomid, ECN, ecnbillno, ecnId, newData, isECNVersion, pentryvaliddate);
            if (bom == null && addnewCol.size() > 0) {
                String msg8 = ResManager.loadKDString((String)"\u6570\u636e\u68c0\u9a8c\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u7684\u6b63\u786e\u6027\u3002", (String)"ECNUtil_10", (String)"mmc-pdm-common", (Object[])new Object[0]);
                throw new KDBizException(new ErrorCode("pdm-ecn", msg8), new Object[0]);
            }
            if (addnewCol.size() > 0) {
                isAdd = Boolean.TRUE;
            }
            if ((bom1 = ECNUtil.updateEntry(updateCol, bomid, ECN, isAdd, bom, ecnbillno, ecnId, newData, isECNVersion)) == null && updateCol.size() > 0) {
                msg = ResManager.loadKDString((String)"\u6570\u636e\u68c0\u9a8c\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u7684\u6b63\u786e\u6027\u3002", (String)"ECNUtil_10", (String)"mmc-pdm-common", (Object[])new Object[0]);
                throw new KDBizException(new ErrorCode("pdm-ecn", msg), new Object[0]);
            }
            if (bom1 == null) {
                bom1 = bom;
            }
            if (newVersion != null) {
                DynamicObject copyBom = BOMCopyUtils.getCopyBom(bom1, newVersion);
                copyBoms.add(copyBom);
                continue;
            }
            listBom.add(bom1);
        }
        if (listBom.size() > 0 || copyBoms.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])listBom.toArray(new DynamicObject[listBom.size()]));
            SaveServiceHelper.save((DynamicObject[])copyBoms.toArray(new DynamicObject[copyBoms.size()]));
            String cacheType = BaseDataCtrlCacheMrg.getType4BaseDataFilter();
            String key = "pdm_mftbom" + org.getPkValue();
            BaseDataCtrlCacheMrg.clearCache((String)cacheType, (String)key);
            BaseDataService baseDataService = new BaseDataService();
            baseDataService.clearBaseDataFilterCache("pdm_mftbom", (Long)org.getPkValue());
        }
        SaveServiceHelper.update((DynamicObject)dObject);
        if ("audit".equals(opr)) {
            ECNUtil.syncCostBom(syncCostbomIds);
        }
        return error.toString();
    }

    public static void syncCostBom(List<Object> bomIds) {
        JSONObject params = new JSONObject();
        params.put("entity", (Object)"pdm_mftbom");
        params.put("bomIds", bomIds);
        try {
            DispatchServiceHelper.invokeBizService((String)"macc", (String)"cad", (String)"syncCostBomService", (String)"syncCostBom", (Object[])new Object[]{params.toJSONString()});
            log.warn("\u6210\u672cBOM\u540c\u6b65\u8c03\u7528\u6210\u529f");
        }
        catch (Exception ex) {
            log.warn("\u6210\u672cBOM\u540c\u6b65\u5931\u8d25\uff1a" + ex.getMessage());
        }
    }

    public static Long getDynamicObjectId(DynamicObject dy) {
        if (dy == null || dy.getPkValue() == null) {
            return 0L;
        }
        Object pkValue = dy.getPkValue();
        if (pkValue instanceof Long) {
            return (Long)pkValue;
        }
        return Long.parseLong(pkValue.toString());
    }
}

