/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.common.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.OrgProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.org.OrgViewServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.mmc.pdm.common.util.CommonUtils;
import org.apache.commons.lang3.StringUtils;

public class OrgHelper {
    public static List<Long> getHasPermissionOrg(String entityName) {
        String orgViewType = OrgHelper.getOrgViewType(entityName);
        return OrgHelper.getHasPermissionOrg(entityName, orgViewType);
    }

    public static List<Long> getHasPermissionOrg(String entityName, String orgViewType) {
        List hasPermissionOrgs = OrgViewServiceHelper.getAllPermissionOrgs((String)entityName, (String)orgViewType);
        if (CommonUtils.isNull(hasPermissionOrgs)) {
            return null;
        }
        Map tempInvStart = null;
        ArrayList<Long> orgIDs = new ArrayList<Long>();
        if ("05".equals(orgViewType)) {
            QFilter orgs = new QFilter("startstatus", "=", (Object)"B");
            tempInvStart = BusinessDataServiceHelper.loadFromCache((String)"im_invstart", (String)"id,org,startdate", (QFilter[])new QFilter[]{orgs});
            if (CommonUtils.isNull(tempInvStart)) {
                return null;
            }
            for (DynamicObject tempOrg : tempInvStart.values()) {
                DynamicObject tempOrgId = tempOrg.getDynamicObject("org");
                if (tempOrgId == null) continue;
                orgIDs.add((Long)tempOrgId.getPkValue());
            }
        }
        ArrayList<Long> orgs1 = new ArrayList<Long>();
        Iterator<Object> arg5 = hasPermissionOrgs.iterator();
        while (arg5.hasNext()) {
            Map tempOrg1 = (Map)arg5.next();
            Long tempOrgId1 = Long.valueOf((String)tempOrg1.get("id"));
            if (tempInvStart != null && orgIDs != null && orgIDs.size() >= 1 && !orgIDs.contains(tempOrgId1)) continue;
            orgs1.add(tempOrgId1);
        }
        return orgs1;
    }

    public static Long getDefaultOrg(String entityName) {
        String orgViewType = OrgHelper.getOrgViewType(entityName);
        return OrgHelper.getDefaultOrg(entityName, orgViewType);
    }

    public static Long getDefaultOrg(String entityName, String orgViewType) {
        long orgId = RequestContext.get().getOrgId();
        List<Long> orgs = OrgHelper.getHasPermissionOrg(entityName, orgViewType);
        return orgs == null ? null : (orgs != null && orgs.contains(orgId) ? Long.valueOf(orgId) : orgs.get(0));
    }

    private static String getOrgViewType(String entityName) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityName);
        OrgProp org = (OrgProp)dataEntityType.getProperty("org");
        if (org == null) {
            return null;
        }
        String orgViewType = org.getOrgFunc();
        if (StringUtils.isBlank((CharSequence)orgViewType)) {
            orgViewType = "15";
        }
        return orgViewType;
    }

    public static boolean checkPermission(String appid, String formId, String permissionItemId) {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        int result = PermissionServiceHelper.checkPermission((Long)userId, (Long)RequestContext.get().getOrgId(), (String)appid, (String)formId, (String)permissionItemId);
        return result == 1;
    }
}

