/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.common.util;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mmc.pdm.common.util.MMCUtils;

public class PDMMaterialHelper {
    private static final String IS_USE_AUXPTY = "isuseauxpty";
    private static final String IS_ENABLE_MATERIAL_VERSION = "isenablematerialversion";

    private PDMMaterialHelper() {
    }

    public static Boolean isUseAuxpty(DynamicObject material) {
        DynamicObjectType type;
        if (material == null) {
            return Boolean.FALSE;
        }
        Object masterid = MMCUtils.getDynamicObjectData(material, "masterid");
        DynamicObject mater = material;
        if (masterid instanceof DynamicObject) {
            mater = (DynamicObject)masterid;
        }
        if ((type = mater.getDynamicObjectType()) == null) {
            return Boolean.FALSE;
        }
        DataEntityPropertyCollection properties = type.getProperties();
        if (properties == null || properties.isEmpty()) {
            return Boolean.FALSE;
        }
        if (!properties.toString().contains(IS_USE_AUXPTY)) {
            mater = BusinessDataServiceHelper.loadSingle((Object)mater.getPkValue(), (String)"bd_material", (String)IS_USE_AUXPTY);
        }
        return MMCUtils.getDynamicObjectBooleanData(mater, IS_USE_AUXPTY);
    }

    public static Boolean isEnableMaterialVersion(DynamicObject material) {
        DynamicObjectType type;
        if (material == null) {
            return Boolean.FALSE;
        }
        Object masterid = MMCUtils.getDynamicObjectData(material, "masterid");
        DynamicObject mater = material;
        if (masterid instanceof DynamicObject) {
            mater = (DynamicObject)masterid;
        }
        if ((type = mater.getDynamicObjectType()) == null) {
            return Boolean.FALSE;
        }
        DataEntityPropertyCollection properties = type.getProperties();
        if (properties == null || properties.isEmpty()) {
            return Boolean.FALSE;
        }
        if (!properties.toString().contains(IS_ENABLE_MATERIAL_VERSION)) {
            mater = BusinessDataServiceHelper.loadSingle((Object)mater.getPkValue(), (String)"bd_material", (String)IS_ENABLE_MATERIAL_VERSION);
        }
        return MMCUtils.getDynamicObjectBooleanData(mater, IS_ENABLE_MATERIAL_VERSION);
    }
}

