/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.common.util;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.pdm.common.helper.PDMProMaterDTHelper;
import kd.mmc.pdm.common.util.BOMQueryObject;
import kd.mmc.pdm.common.util.PDMDateUtil;

public class ProMaterDTBUtil {
    private static final String WORKPROENTRY = "workprocedure";
    private static final String MAIN_PRODUCT = "material";
    private static final String QTYENTRY = "qtyentry";
    private static final String PDM_MFTBOM = "pdm_mftbom";
    private static final String PDM_ROUTE = "pdm_route";
    private static final String BD_BOMVERSION = "bd_bomversion";
    public static final String NALLOCATISJUMPLEVEL = "nallocatisjumplevel";

    public static BOMQueryObject geMaterDTBObject(DynamicObject bom, DynamicObject materEntry, Long parententryId, Long entryId, BigDecimal qtymole, BigDecimal qtydeno) {
        DynamicObject mainProduct = bom.getDynamicObject(MAIN_PRODUCT);
        String property = materEntry.getDataEntityType().getProperties().toString();
        BOMQueryObject bomQueryObject = new BOMQueryObject();
        bomQueryObject.setMater(property.contains("entrymaterial") ? materEntry.getLong("entrymaterial.id") : 0L);
        bomQueryObject.setMaterattr(property.contains("entrymaterialattr") ? materEntry.getString("entrymaterialattr") : "");
        bomQueryObject.setUnit(property.contains("entryunit") ? materEntry.getLong("entryunit.id") : 0L);
        bomQueryObject.setUsagetype(property.contains("entryqtytype") ? materEntry.getString("entryqtytype") : "");
        bomQueryObject.setMole(property.contains("entryqtynumerator") ? materEntry.getBigDecimal("entryqtynumerator") : new BigDecimal("0"));
        bomQueryObject.setDeno(property.contains("entryqtydenominator") ? materEntry.getBigDecimal("entryqtydenominator") : new BigDecimal("0"));
        bomQueryObject.setParentmater(mainProduct != null ? (Long)mainProduct.getPkValue() : 0L);
        bomQueryObject.setParentmaterattr(mainProduct != null ? mainProduct.getString("materialattr") : "");
        bomQueryObject.setFixscrap(property.contains("entryfixscrap") ? materEntry.getBigDecimal("entryfixscrap") : new BigDecimal("0"));
        bomQueryObject.setScraprate(property.contains("entryscraprate") ? materEntry.getBigDecimal("entryscraprate") : new BigDecimal("0"));
        bomQueryObject.setRemark(property.contains("entryremark") ? materEntry.getString("entryremark") : "");
        bomQueryObject.setBomversion(property.contains("entryversion") ? materEntry.getLong("entryversion.id") : 0L);
        bomQueryObject.setAuxpty(property.contains("entryauxproperty") ? materEntry.getLong("entryauxproperty.id") : 0L);
        bomQueryObject.setQtyentry(PDMProMaterDTHelper.queryStepEntry(materEntry, qtymole, qtydeno));
        bomQueryObject.setParententryId(parententryId);
        bomQueryObject.setEntryId(entryId);
        bomQueryObject.setBomId((Long)bom.getPkValue());
        bomQueryObject.setBomEntryId((Long)materEntry.getPkValue());
        bomQueryObject.setValiddate(property.contains("entryvaliddate") ? materEntry.getDate("entryvaliddate") : null);
        bomQueryObject.setInvaliddate(property.contains("entryinvaliddate") ? materEntry.getDate("entryinvaliddate") : null);
        bomQueryObject.setJumplevel(property.contains("entryisjumplevel") ? materEntry.getBoolean("entryisjumplevel") : false);
        BigDecimal mole = bomQueryObject.getMole().multiply(qtymole);
        BigDecimal deno = bomQueryObject.getDeno().multiply(qtydeno);
        BigDecimal zero = new BigDecimal("0");
        if (mole.compareTo(zero) <= 0 || deno.compareTo(zero) <= 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u5f85\u5206\u914d\u7528\u91cf\u6570\u503c\u5f02\u5e38\u3002", (String)"ProMaterDTBUtil_0", (String)"mmc-pdm-common", (Object[])new Object[0]), materEntry.get("entrymaterial.masterid.number")));
        }
        bomQueryObject.setQtymole(mole);
        bomQueryObject.setQtydeno(deno);
        bomQueryObject.setLongId(materEntry.getString("id"));
        bomQueryObject.setReplace(property.contains("entryisreplace") ? materEntry.getBoolean("entryisreplace") : false);
        bomQueryObject.setReplacePlanId(property.contains("entryreplaceplan") ? materEntry.getLong("entryreplaceplan.id") : 0L);
        return bomQueryObject;
    }

    public static BOMQueryObject geBOMQueryObject(DynamicObject materEntry, String longId, Long parententryId, Long entryId, BigDecimal qtymole, BigDecimal qtydeno) {
        String property = materEntry.getDataEntityType().getProperties().toString();
        BOMQueryObject bomQueryObject = new BOMQueryObject();
        bomQueryObject.setMater(property.contains("entrymaterial") ? materEntry.getLong("entrymaterial.id") : 0L);
        bomQueryObject.setMaterattr(property.contains("entrymaterialattr") ? materEntry.getString("entrymaterialattr") : "");
        bomQueryObject.setUnit(property.contains("entryunit") ? materEntry.getLong("entryunit.id") : 0L);
        bomQueryObject.setUsagetype(property.contains("entryqtytype") ? materEntry.getString("entryqtytype") : "");
        bomQueryObject.setMole(property.contains("entryqtynumerator") ? materEntry.getBigDecimal("entryqtynumerator") : new BigDecimal("0"));
        bomQueryObject.setDeno(property.contains("entryqtydenominator") ? materEntry.getBigDecimal("entryqtydenominator") : new BigDecimal("0"));
        DynamicObject parent = materEntry.getParent() instanceof DynamicObject ? (DynamicObject)materEntry.getParent() : null;
        DynamicObject mainProduct = parent != null ? parent.getDynamicObject(MAIN_PRODUCT) : null;
        long param = 0L;
        if (mainProduct != null) {
            param = (Long)mainProduct.getPkValue();
        }
        bomQueryObject.setParentmater(param);
        bomQueryObject.setParentmaterattr(mainProduct != null ? mainProduct.getString("materialattr") : "");
        bomQueryObject.setFixscrap(property.contains("entryfixscrap") ? materEntry.getBigDecimal("entryfixscrap") : new BigDecimal("0"));
        bomQueryObject.setScraprate(property.contains("entryscraprate") ? materEntry.getBigDecimal("entryscraprate") : new BigDecimal("0"));
        bomQueryObject.setRemark(property.contains("entryremark") ? materEntry.getString("entryremark") : "");
        bomQueryObject.setBomversion(property.contains("entryversion") ? materEntry.getLong("entryversion.id") : 0L);
        bomQueryObject.setAuxpty(property.contains("entryauxproperty") ? materEntry.getLong("entryauxproperty.id") : 0L);
        bomQueryObject.setValiddate(property.contains("entryvaliddate") ? materEntry.getDate("entryvaliddate") : null);
        bomQueryObject.setInvaliddate(property.contains("entryinvaliddate") ? materEntry.getDate("entryinvaliddate") : null);
        bomQueryObject.setJumplevel(property.contains("entryisjumplevel") ? materEntry.getBoolean("entryisjumplevel") : false);
        bomQueryObject.setParententryId(parententryId);
        bomQueryObject.setEntryId(entryId);
        bomQueryObject.setLongId(longId);
        if (parent != null) {
            bomQueryObject.setBomId(parent.getLong("id"));
        }
        bomQueryObject.setBomEntryId(materEntry.getLong("id"));
        BigDecimal mole = bomQueryObject.getMole().multiply(qtymole);
        BigDecimal deno = bomQueryObject.getDeno().multiply(qtydeno);
        BigDecimal zero = new BigDecimal("0");
        if (mole.compareTo(zero) <= 0 || deno.compareTo(zero) <= 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u5f85\u5206\u914d\u7528\u91cf\u6570\u503c\u5f02\u5e38\u3002", (String)"ProMaterDTBUtil_0", (String)"mmc-pdm-common", (Object[])new Object[0]), materEntry.getString("entrymaterial.name")));
        }
        bomQueryObject.setQtymole(mole);
        bomQueryObject.setQtydeno(deno);
        bomQueryObject.setReplace(property.contains("entryisreplace") ? materEntry.getBoolean("entryisreplace") : false);
        bomQueryObject.setReplacePlanId(property.contains("entryreplaceplan") ? materEntry.getLong("entryreplaceplan.id") : 0L);
        return bomQueryObject;
    }

    public static Integer getGreatestCommonDivisor(Integer fenzi, Integer fenmu) {
        int gongyinshu = 1;
        int small = fenzi < fenmu ? fenzi : fenmu;
        for (int i = 1; i <= small; ++i) {
            if (fenzi % i != 0 || fenmu % i != 0) continue;
            gongyinshu = i;
        }
        return gongyinshu;
    }

    public static StringBuilder checkDTBAddRigth(IDataModel model, IFormView view, String entryEntity, String name, Boolean isMSelect) {
        StringBuilder error = new StringBuilder();
        EntryGrid workProEntry = (EntryGrid)view.getControl(WORKPROENTRY);
        EntryGrid entryGrid = (EntryGrid)view.getControl(entryEntity);
        if (model.getEntryEntity(WORKPROENTRY) == null || model.getEntryEntity(WORKPROENTRY).size() == 0) {
            error.append(ResManager.loadKDString((String)"\u5de5\u5e8f\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u5206\u914d\u3002\n", (String)"ProMaterDTBUtil_1", (String)"mmc-pdm-common", (Object[])new Object[0]));
        }
        if (workProEntry == null || workProEntry.getSelectRows().length <= 0) {
            error.append(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5de5\u5e8f\u3002\n", (String)"ProMaterDTBUtil_2", (String)"mmc-pdm-common", (Object[])new Object[0]));
        }
        if (model.getEntryEntity(entryEntity) == null || model.getEntryEntity(entryEntity).size() == 0) {
            error.append(name).append(ResManager.loadKDString((String)"\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u5206\u914d\u3002\n", (String)"ProMaterDTBUtil_3", (String)"mmc-pdm-common", (Object[])new Object[0]));
        }
        if (entryGrid != null && entryGrid.getSelectRows().length > 0) {
            int[] selectRows = entryGrid.getSelectRows();
            if (!isMSelect.booleanValue()) {
                Object isJumpLevel;
                if (selectRows.length > 1) {
                    error.append(ResManager.loadKDString((String)"\u6279\u91cf\u52a0\u5165\u65f6\uff0c\u8bf7\u4f7f\u7528\u5168\u52a0\u529f\u80fd\u6309\u94ae\u3002\n", (String)"ProMaterDTBUtil_4", (String)"mmc-pdm-common", (Object[])new Object[0]));
                }
                if ("notallocatentry".equals(entryEntity) && selectRows.length > 0 && Boolean.parseBoolean((isJumpLevel = model.getValue(NALLOCATISJUMPLEVEL, selectRows[0])).toString())) {
                    error.append(ResManager.loadKDString((String)"\u8df3\u5c42\u4ef6\uff0c\u8bf7\u4f7f\u7528\u5168\u52a0\u529f\u80fd\u6309\u94ae\u3002\n", (String)"ProMaterDTBUtil_5", (String)"mmc-pdm-common", (Object[])new Object[0]));
                }
            }
        } else {
            error.append(String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u6267\u884c\u5206\u914d\u7684%s\u3002\n", (String)"ProMaterDTBUtil_6", (String)"mmc-pdm-common", (Object[])new Object[0]), name));
        }
        return error;
    }

    public static StringBuilder checkDTBRemoveRight(IDataModel model, IFormView view, String entryEntity, String name, Boolean isMSelect) {
        StringBuilder error = new StringBuilder();
        EntryGrid entryGrid = (EntryGrid)view.getControl(entryEntity);
        if (model.getEntryEntity(entryEntity) == null || model.getEntryEntity(entryEntity).size() == 0) {
            error.append(name).append(ResManager.loadKDString((String)"\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u79fb\u51fa\u3002\n", (String)"ProMaterDTBUtil_7", (String)"mmc-pdm-common", (Object[])new Object[0]));
        }
        if (entryGrid == null || entryGrid.getSelectRows().length <= 0) {
            error.append(String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u6267\u884c\u79fb\u51fa\u7684%s\u3002\n", (String)"ProMaterDTBUtil_8", (String)"mmc-pdm-common", (Object[])new Object[0]), name));
        }
        if (!isMSelect.booleanValue() && entryGrid != null && entryGrid.getSelectRows().length > 1) {
            error.append(ResManager.loadKDString((String)"\u6279\u91cf\u79fb\u51fa\u65f6\uff0c\u8bf7\u4f7f\u7528\u5168\u79fb\u529f\u80fd\u6309\u94ae\u3002\n", (String)"ProMaterDTBUtil_9", (String)"mmc-pdm-common", (Object[])new Object[0]));
        }
        return error;
    }

    public static Long getRandNum() {
        ORM orm = ORM.create();
        long id = orm.genLongId("pdm_promaterdtb.notallocatentry");
        return id;
    }

    public static Set<Long> getNonVersionBomIds() {
        HashSet<Long> ids = new HashSet<Long>(16);
        String algoKey = "kd.mmc.pdm.common.util.ProMaterDTBUtil#getNonVersionBomIds";
        QFilter[] qFilters = new QFilter[]{new QFilter("version", "=", (Object)0L)};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)PDM_MFTBOM, (String)"id", (QFilter[])qFilters, null);){
            dataSet.forEach(r -> ids.add(r.getLong("id")));
        }
        return ids;
    }

    public static Set<Long> getBetweenDateBomIds(Date minDate, Date maxDate) {
        Objects.requireNonNull(minDate, "minDate is null");
        Objects.requireNonNull(maxDate, "maxDate is null");
        HashSet<Long> ids = new HashSet<Long>(16);
        minDate = PDMDateUtil.getDate(minDate);
        maxDate = PDMDateUtil.getDate(maxDate);
        Date date = PDMDateUtil.addDay(minDate, 1);
        QFilter qFilterDate1 = new QFilter("version.effectdate", "<", (Object)date);
        QFilter qFilterDate2 = new QFilter("version.invaliddate", ">=", (Object)maxDate);
        QFilter[] qFilters = new QFilter[]{qFilterDate1, qFilterDate2};
        String algoKey = "kd.mmc.pdm.common.util.ProMaterDTBUtil#getBetweenDateBomIds";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)PDM_MFTBOM, (String)"id", (QFilter[])qFilters, null);){
            dataSet.forEach(r -> ids.add(r.getLong("id")));
        }
        return ids;
    }

    public static Set<Long> getBetweenDatePRouteIds(Date minDate, Date maxDate) {
        Objects.requireNonNull(minDate, "minDate is null");
        Objects.requireNonNull(maxDate, "maxDate is null");
        HashSet<Long> ids = new HashSet<Long>(16);
        minDate = PDMDateUtil.getDate(minDate);
        maxDate = PDMDateUtil.getDate(maxDate);
        QFilter qFilterDate0 = new QFilter("routeversion", "=", (Object)0L);
        QFilter qFilterDate1 = new QFilter("routeversion.effectdate", "<=", (Object)minDate);
        QFilter qFilterDate2 = new QFilter("routeversion.invaliddate", ">=", (Object)maxDate);
        QFilter qFilterDate = qFilterDate0.or(qFilterDate1.and(qFilterDate2));
        QFilter[] qFilters = new QFilter[]{qFilterDate};
        String algoKey = "kd.mmc.pdm.common.util.ProMaterDTBUtil#getBetweenDatePRouteIds";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)PDM_ROUTE, (String)"id", (QFilter[])qFilters, null);){
            dataSet.forEach(r -> ids.add(r.getLong("id")));
        }
        return ids;
    }

    public static StringBuilder saveCheckDTBAddRigth(IDataModel model, IFormView view, String entryEntity, String name) {
        StringBuilder error = new StringBuilder();
        if (model.getEntryEntity(WORKPROENTRY) == null || model.getEntryEntity(WORKPROENTRY).size() == 0) {
            error.append(ResManager.loadKDString((String)"\u5de5\u5e8f\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u5206\u914d\u3002\n", (String)"ProMaterDTBUtil_1", (String)"mmc-pdm-common", (Object[])new Object[0]));
        }
        if (model.getEntryEntity(entryEntity) == null || model.getEntryEntity(entryEntity).size() == 0) {
            error.append(name).append(ResManager.loadKDString((String)"\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u5206\u914d\u3002\n", (String)"ProMaterDTBUtil_3", (String)"mmc-pdm-common", (Object[])new Object[0]));
        }
        return error;
    }

    public static Set<Long> getProIds(Long materialId) {
        Objects.requireNonNull(materialId, "materialId is null");
        HashSet<Long> ids = new HashSet<Long>(16);
        QFilter status = new QFilter("status", "=", (Object)"C");
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        QFilter proTypeAQf = new QFilter("processtype", "=", (Object)"A");
        String entityName = PDM_ROUTE;
        QFilter materQf = new QFilter("material.id", "=", (Object)materialId);
        QFilter[] aQfs = new QFilter[]{status, enable, proTypeAQf, materQf};
        String sels = "id";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"Query-pdm_processrouteA", (String)entityName, (String)sels, (QFilter[])aQfs, null);){
            dataSet.forEach(row -> ids.add(row.getLong("id")));
        }
        QFilter proTypeBQf = new QFilter("processtype", "=", (Object)"B");
        HashSet mGroupIds = new HashSet(16);
        QFilter mastQFilter = new QFilter("masterid.id", "=", (Object)materialId);
        QFilter[] grQfs = new QFilter[]{mastQFilter, status, enable};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"Query-bd_materialmftinfo", (String)"bd_materialmftinfo", (String)"mftcontrolentry.materialcontrol.id", (QFilter[])grQfs, null);){
            dataSet.forEach(row -> mGroupIds.add(row.getLong("mftcontrolentry.materialcontrol.id")));
        }
        QFilter mGroupQf = new QFilter("materialgroup.id", "in", mGroupIds);
        QFilter[] bQfs = new QFilter[]{status, enable, proTypeBQf, mGroupQf};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"Query-pdm_processrouteB", (String)entityName, (String)sels, (QFilter[])bQfs, null);){
            dataSet.forEach(row -> ids.add(row.getLong("id")));
        }
        QFilter proTypeCQf = new QFilter("processtype", "=", (Object)"C");
        QFilter[] cQfs = new QFilter[]{status, enable, proTypeCQf};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"Query-pdm_processrouteC", (String)entityName, (String)sels, (QFilter[])cQfs, null);){
            dataSet.forEach(row -> ids.add(row.getLong("id")));
        }
        return ids;
    }
}

