/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.common.workcard;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class ToolRequireCardUtils {
    private static Log log = LogFactory.getLog(ToolRequireCardUtils.class);

    public static Map<Long, Set<Long>> getProjectCardMap(Set<Long> projectIds, String entity) {
        log.info("\u9879\u76eeid" + projectIds.toString());
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"pmpd", (String)"WorkPackageService", (String)"getJobCardByProject", (Object[])new Object[]{projectIds});
        log.info("mmc-pmpd:WorkPackageService\u63a5\u53e3\u8fd4\u56de\u7684\u6570\u636e" + result.toString());
        HashSet cardIds = new HashSet(16);
        result.forEach((k, v) -> cardIds.addAll(v));
        QFilter qFilter = new QFilter("id", "in", cardIds);
        QFilter filter = new QFilter("cardtype.worktypectrl.entryentity.basedata", "=", (Object)entity);
        Map map = BusinessDataServiceHelper.loadFromCache((String)"mpdm_mrocardroute", (String)"id", (QFilter[])new QFilter[]{qFilter, filter});
        HashMap<Long, Set<Long>> data = new HashMap<Long, Set<Long>>(16);
        result.forEach((k, v) -> data.put((Long)k, v.stream().filter(x -> map.containsKey(x)).collect(Collectors.toSet())));
        log.info("\u901a\u8fc7mpdm_mrocardroute\u8fc7\u6ee4\u7684\u6570\u636e" + ((Object)data).toString());
        return data;
    }

    public static Set<Long> getToolRequireCard(Set<Long> orgIds, Set<Long> cardIds) {
        QFilter filter = new QFilter("org", "in", orgIds);
        QFilter filter2 = new QFilter("projectrange.toolcreatestatus", "!=", (Object)"B");
        QFilter filter3 = new QFilter("entryentity.cardnum", "in", cardIds);
        String algoKey = "querttoolrequirecard";
        String selectFields = "entryentity.cardnum";
        HashSet<Long> ids = new HashSet<Long>(256);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"pdm_toolrequirecard", (String)selectFields, (QFilter[])new QFilter[]{filter, filter2, filter3}, (String)"");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                ids.add(row.getLong("entryentity.cardnum"));
            }
        }
        return ids;
    }

    public static Set<Long> getCardToolDemand(Set<Long> orgIds, Set<Long> cardIds) {
        QFilter filter = new QFilter("createorg", "in", orgIds);
        QFilter filter2 = new QFilter("status", "=", (Object)"C");
        QFilter filter3 = new QFilter("enable", "=", (Object)"1");
        QFilter filter4 = new QFilter("workcard", "in", cardIds);
        String algoKey = "querycardtooldemand";
        String selectFields = "workcard";
        HashSet<Long> ids = new HashSet<Long>(256);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"mpdm_cardtooldemand", (String)selectFields, (QFilter[])new QFilter[]{filter, filter2, filter3, filter4}, (String)"");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                ids.add(row.getLong("workcard"));
            }
        }
        return ids;
    }

    public static void updateProjectCardStatus(Set<Long> projectIds) {
        DynamicObject[] load;
        for (DynamicObject object : load = BusinessDataServiceHelper.load((String)"pdm_projectscope", (String)"id,toolcreatestatus", (QFilter[])new QFilter[]{new QFilter("id", "in", projectIds)})) {
            object.set("toolcreatestatus", (Object)"B");
        }
        if (load.length > 0) {
            SaveServiceHelper.save((DynamicObject[])load);
        }
    }

    public static void updateToolRequireCardStatus(String op, Map<Long, DynamicObject> tcd) {
        DynamicObject[] load;
        Set<Long> cardIds = tcd.keySet();
        QFilter qFilter = new QFilter("toolcreatestatus", "!=", (Object)"C");
        if ("audit".equals(op)) {
            qFilter.and(new QFilter("entryentity.toolstatus", "in", (Object)Sets.newHashSet((Object[])new String[]{"A", "B"})));
        } else if ("unaudit".equals(op)) {
            qFilter.and(new QFilter("entryentity.toolstatus", "=", (Object)"C"));
            Collection<DynamicObject> values = tcd.values();
            HashSet<Long> tcdIds = new HashSet<Long>(16);
            if (null != values) {
                for (DynamicObject tcdDO : values) {
                    long pkValue = (Long)tcdDO.getPkValue();
                    tcdIds.add(pkValue);
                }
            }
            qFilter.and(new QFilter("entryentity.workcardtool", "in", tcdIds));
        }
        qFilter.and(new QFilter("entryentity.cardnum", "in", cardIds));
        qFilter.and(new QFilter("projectnum.prjstate.number", "!=", (Object)"BUSINESSCLOSURE_S"));
        for (DynamicObject object : load = BusinessDataServiceHelper.load((String)"pdm_toolrequirecard", (String)"id,projectrange,org,muluser,cardnum,toolstatus,workcardtool", (QFilter[])new QFilter[]{qFilter})) {
            DynamicObject org = object.getDynamicObject("org");
            DynamicObjectCollection entryEntity = object.getDynamicObjectCollection("entryentity");
            for (DynamicObject dynamicObject : entryEntity) {
                if (dynamicObject.getDynamicObject("cardnum") == null || !cardIds.contains(dynamicObject.getDynamicObject("cardnum").getLong("id"))) continue;
                if ("audit".equals(op)) {
                    long orgId;
                    DynamicObject workcardtool = tcd.get(dynamicObject.getDynamicObject("cardnum").getLong("id"));
                    long workcardtoolorgid = 0L;
                    if (null != workcardtool) {
                        DynamicObject createorg = workcardtool.getDynamicObject("createorg");
                        workcardtoolorgid = (Long)createorg.getPkValue();
                    }
                    if ((orgId = ((Long)org.getPkValue()).longValue()) != workcardtoolorgid) continue;
                    dynamicObject.set("toolstatus", (Object)"C");
                    dynamicObject.set("workcardtool", (Object)workcardtool);
                    continue;
                }
                if (!"unaudit".equals(op)) continue;
                DynamicObjectCollection muluser = dynamicObject.getDynamicObjectCollection("muluser");
                if (null != muluser && muluser.size() > 0) {
                    dynamicObject.set("toolstatus", (Object)"B");
                } else {
                    dynamicObject.set("toolstatus", (Object)"A");
                }
                dynamicObject.set("workcardtool", null);
            }
        }
        SaveServiceHelper.save((DynamicObject[])load);
        ToolRequireCardUtils.updateProject(load);
    }

    public static void updateProject(DynamicObject[] dataEntities) {
        HashSet status = Sets.newHashSet((Object[])new String[]{"C", "D"});
        HashSet<Long> updateProjectRangeIds = new HashSet<Long>(16);
        for (int i = 0; i < dataEntities.length; ++i) {
            DynamicObject dataEntity = dataEntities[i];
            DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection("entryentity");
            int size = dynamicObjectCollection.size();
            List toolstatus = dynamicObjectCollection.stream().filter(x -> status.contains(x.getString("toolstatus"))).collect(Collectors.toList());
            if (size <= 0 || size != toolstatus.size() || dataEntity.getDynamicObject("projectrange") == null) continue;
            updateProjectRangeIds.add(dataEntity.getDynamicObject("projectrange").getLong("id"));
        }
        ToolRequireCardUtils.updateProjectCardStatus(updateProjectRangeIds);
    }

    public static void setEntityColumn(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("projectrange");
        e.getFieldKeys().add("cardnum");
        e.getFieldKeys().add("requiretool");
        e.getFieldKeys().add("toolstatus");
        e.getFieldKeys().add("muluser");
        e.getFieldKeys().add("moddate");
        e.getFieldKeys().add("moduser");
        e.getFieldKeys().add("user");
    }

    public static Set<Long> getCardIds(Set<Long> cardIds, long orgId) {
        Set<Long> existWorkTypeCtrl;
        Set<Long> existCTDCardIds;
        HashSet<Long> removeCardIds = new HashSet<Long>(16);
        Set<Long> existCRDCardIds = ToolRequireCardUtils.getExistCRDCardIds(cardIds, orgId, 0L);
        if (null != existCRDCardIds && existCRDCardIds.size() > 0) {
            removeCardIds.addAll(existCRDCardIds);
        }
        if (null != (existCTDCardIds = ToolRequireCardUtils.getExistCTDCardIds(cardIds, orgId)) && existCTDCardIds.size() > 0) {
            removeCardIds.addAll(existCTDCardIds);
        }
        if (null != (existWorkTypeCtrl = ToolRequireCardUtils.getExistWorkTypeCtrl(cardIds)) && existWorkTypeCtrl.size() > 0) {
            removeCardIds.addAll(existWorkTypeCtrl);
        }
        return removeCardIds;
    }

    public static Set<Long> getExistCTDCardIds(Set<Long> cardIds, long orgId) {
        HashSet<Long> removeCardIds = new HashSet<Long>(16);
        QFilter cardToolDemandFilter = new QFilter("workcard", "in", cardIds);
        cardToolDemandFilter.and(new QFilter("createorg", "=", (Object)orgId));
        cardToolDemandFilter.and(new QFilter("status", "=", (Object)"C"));
        cardToolDemandFilter.and(new QFilter("enable", "=", (Object)"1"));
        DynamicObject[] cardtooldemands = BusinessDataServiceHelper.load((String)"mpdm_cardtooldemand", (String)"id,workcard", (QFilter[])cardToolDemandFilter.toArray());
        if (null != cardtooldemands && cardtooldemands.length > 0) {
            for (DynamicObject cardtooldemand : cardtooldemands) {
                DynamicObject workcard = cardtooldemand.getDynamicObject("workcard");
                if (null == workcard) continue;
                long workCardId = (Long)workcard.getPkValue();
                removeCardIds.add(workCardId);
            }
        }
        return removeCardIds;
    }

    public static Set<Long> getExistWorkTypeCtrl(Set<Long> cardIds) {
        HashSet<Long> removeCardIds = new HashSet<Long>(16);
        HashMap<Long, Long> cardOrCtrlIdMap = new HashMap<Long, Long>(16);
        HashSet exist = new HashSet(16);
        String selectProp = "id,number,cardtype,cardtype.worktypectrl";
        Map objectDynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"mpdm_mrocardroute", (String)selectProp, (QFilter[])new QFilter[]{new QFilter("id", "in", cardIds)});
        if (null != objectDynamicObjectMap) {
            Collection wordcards = objectDynamicObjectMap.values();
            for (DynamicObject wordcard : wordcards) {
                DynamicObject worktypectrl;
                long cardId = (Long)wordcard.getPkValue();
                DynamicObject cardtype = wordcard.getDynamicObject("cardtype");
                if (null == cardtype || null == (worktypectrl = cardtype.getDynamicObject("worktypectrl"))) continue;
                long pkValue = (Long)worktypectrl.getPkValue();
                cardOrCtrlIdMap.put(pkValue, cardId);
            }
            if (null != cardOrCtrlIdMap) {
                DynamicObject[] ctrls;
                Set ctrlIds = cardOrCtrlIdMap.keySet();
                QFilter ctrlFilter = new QFilter("entryentity.basedata", "=", (Object)"mpdm_cardtooldemand");
                ctrlFilter.and(new QFilter("id", "in", ctrlIds));
                for (DynamicObject ctrl : ctrls = BusinessDataServiceHelper.load((String)"mpdm_worktypectrl", (String)"id", (QFilter[])ctrlFilter.toArray())) {
                    long id = ctrl.getLong("id");
                    exist.add(cardOrCtrlIdMap.get(id));
                }
            }
            Iterator<Object> iterator = cardIds.iterator();
            while (iterator.hasNext()) {
                long cardId = (Long)iterator.next();
                if (exist.contains(cardId)) continue;
                removeCardIds.add(cardId);
            }
        }
        return removeCardIds;
    }

    public static Set<Long> getExistCRDCardIds(Set<Long> cardIds, long orgId, long excludeId) {
        DynamicObject[] load;
        HashSet<Long> removeCardIds = new HashSet<Long>(16);
        QFilter toolCardQfilter = new QFilter("entryentity.cardnum", "in", cardIds);
        toolCardQfilter.and(new QFilter("org", "=", (Object)orgId));
        toolCardQfilter.and(new QFilter("entryentity.toolstatus", "!=", (Object)"C"));
        if (excludeId != 0L) {
            toolCardQfilter.and(new QFilter("id", "!=", (Object)excludeId));
            toolCardQfilter.and(new QFilter("entryentity.toolstatus", "!=", (Object)"D"));
        }
        if (null != (load = BusinessDataServiceHelper.load((String)"pdm_toolrequirecard", (String)"id,projectrange,entryentity.cardnum,entryentity.toolstatus", (QFilter[])toolCardQfilter.toArray())) && load.length > 0) {
            for (DynamicObject object : load) {
                DynamicObject cardnum = object.getDynamicObject("entryentity.cardnum");
                if (null == cardnum) continue;
                long id = (Long)cardnum.getPkValue();
                removeCardIds.add(id);
            }
        }
        return removeCardIds;
    }

    public static void removeSetCollect(Set<Long> cardIds, Set<Long> existCRDCardIds) {
        if (null != existCRDCardIds && existCRDCardIds.size() > 0) {
            for (Long next : existCRDCardIds) {
                cardIds.remove(next);
            }
        }
    }
}

