/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.opplugin.ecn;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.pdm.common.util.BOMVersionUtil;
import kd.mmc.pdm.opplugin.ecn.ECNAuditValidator;

public class ECNAuditOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("id");
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("pentrybom");
        e.getFieldKeys().add("pentryecn");
        e.getFieldKeys().add("entryversioncontrol");
        e.getFieldKeys().add("pentrynewversion");
        e.getFieldKeys().add("pentryoldversion");
        e.getFieldKeys().add("pentryvaliddate");
        e.getFieldKeys().add("pentryinvaliddate");
        e.getFieldKeys().add("proentrymaterial");
        e.getFieldKeys().add("pentryexecmode");
        e.getFieldKeys().add("pentryexecdate");
        e.getFieldKeys().add("pentryexecstatus");
        e.getFieldKeys().add("entrybomentryid");
        e.getFieldKeys().add("entrymode");
        e.getFieldKeys().add("entrybom");
        e.getFieldKeys().add("entrymaterial");
        e.getFieldKeys().add("entryunit");
        e.getFieldKeys().add("entryversion");
        e.getFieldKeys().add("entryqtytype");
        e.getFieldKeys().add("entryqtynumerator");
        e.getFieldKeys().add("entryqtydenominator");
        e.getFieldKeys().add("entryfixscrap");
        e.getFieldKeys().add("entryscraprate");
        e.getFieldKeys().add("entryvaliddate");
        e.getFieldKeys().add("entryinvaliddate");
        e.getFieldKeys().add("entryauxproperty");
        e.getFieldKeys().add("entryremark");
        e.getFieldKeys().add("entryqty");
        e.getFieldKeys().add("entrymaterialattr");
        e.getFieldKeys().add("entryoperationnumber");
        e.getFieldKeys().add("entrytimeunit");
        e.getFieldKeys().add("entrywarehouse");
        e.getFieldKeys().add("entrylocation");
        e.getFieldKeys().add("entryisbackflush");
        e.getFieldKeys().add("entryisbulkmaterial");
        e.getFieldKeys().add("entryisjumplevel");
        e.getFieldKeys().add("entrysupplyorg");
        e.getFieldKeys().add("entryiskey");
        e.getFieldKeys().add("entryleadtime");
        e.getFieldKeys().add("entryissuemode");
        e.getFieldKeys().add("entryisstockalloc");
        e.getFieldKeys().add("entryoutorg");
        e.getFieldKeys().add("entryoutwarehouse");
        e.getFieldKeys().add("entryoutlocation");
        e.getFieldKeys().add("entryreplaceplan");
        e.getFieldKeys().add("entryisreplaceplanmm");
        e.getFieldKeys().add("entryownertype");
        e.getFieldKeys().add("entryowner");
        e.getFieldKeys().add("qtyentrymaterial");
        e.getFieldKeys().add("qtyentrybatchstartqty");
        e.getFieldKeys().add("qtyentrybatchendqty");
        e.getFieldKeys().add("qtyentryqtynumerator");
        e.getFieldKeys().add("qtyentryqtydenominator");
        e.getFieldKeys().add("qtyentryfixscrap");
        e.getFieldKeys().add("qtyentryscraprate");
        e.getFieldKeys().add("qtyentryvaliddate");
        e.getFieldKeys().add("qtyentryinvaliddate");
        e.getFieldKeys().add("qtyentryauxproperty");
        e.getFieldKeys().add("qtyentryisstepfix");
        e.getFieldKeys().add("qtyentrysrcid");
        e.getFieldKeys().add("setupentrysrcid");
        e.getFieldKeys().add("setupentryremark");
        e.getFieldKeys().add("setupentrysetuplocation");
        e.getFieldKeys().add("setupentryqty");
        e.getFieldKeys().add("entryprocessseq");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new ECNAuditValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        for (DynamicObject data : e.getDataEntities()) {
            DynamicObject org = data.getDynamicObject("org");
            String ecnbillno = data.getString("billno");
            DynamicObjectCollection pentrys = data.getDynamicObjectCollection("pentry");
            for (int k = 0; k < pentrys.size(); ++k) {
                DynamicObject product;
                DynamicObject pentry = (DynamicObject)pentrys.get(k);
                String entryversioncontrol = pentry.getString("entryversioncontrol");
                if (!StringUtils.equals((CharSequence)entryversioncontrol, (CharSequence)"B") || (product = pentry.getDynamicObject("proentrymaterial")) == null) continue;
                DynamicObject mater = product.getDynamicObject("masterid");
                DynamicObject pentrynewversion = BOMVersionUtil.getNextVersionByECN((DynamicObject)org, (DynamicObject)mater, (String)ecnbillno, (String)"A");
                pentry.set("pentrynewversion", (Object)pentrynewversion);
            }
            SaveServiceHelper.update((DynamicObject)data);
        }
    }
}

